/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var mob = 0;
         	var mobOpen = false;
         	var clicked = 0;
         	var btnNo = 0;
         	var eventCal=0, paraCal=0;
         	var headline, headlinemob0, headlinemob1, stand0, stand1, source;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "background-color":"white"});
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	var endOl = new Date("August 22, 2016 00:00:01 GMT+0000 (GMT)"); //Aug24
         	var endPar =new Date("September 19, 2016 00:00:01 GMT+0000 (GMT)"); //Aug24
         	var todayDate = new Date();
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("logoMc").$("paralogo").css({'left':(stageWidth-300)/2+'px'});
         	sym.getSymbol("logoMc").$("olylogo").css({'left':(stageWidth-300)/2+'px'});
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // MENU TEXT START
         //********************************************************************************************************
         	var menuTxt=[];
         	menuTxt[0] = sym.getSymbol("menuBtnsMc").$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[1] = sym.$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[2] = sym.$("menuTxt").css({"pointer-events":"none"});
         	var menuArr=[];
         
         //********************************************************************************************************
         // SCROLLING
         //********************************************************************************************************
         sym.$("sports").css({'overflow-x':'hidden'});
         var scrollPos;
         function timelineScroll(num) {
         	sym.$("sports").scrollTop(30*num);
         }
         
         function resetBtns(){
         	for (var i=0; i<olySports.length; i++){
         		$(".sportMob").fadeOut(0);
         		$("#sport"+i).animate ({top:30 * i}, 0);
         		var bg=(i%2==0)?"#fff":"#ddd";
         		$("#sport"+i).css({"background-color":bg});
         		$("#name"+i+ ", #ico"+i).css({"background-color":"rgba(255,255,255,0)","color":"#000", "font-weight":"normal"});
         		$(".sportMob").css({'border-bottom':0});
         	}
         }
         var showSport = function(sportNo,comp){//show phase timing graph
         	return function(e){
         		var stageWidth=sym.$("Stage").width();
         		sym.$("sports").stop().animate({scrollTop:(31*sportNo)}, 0);
         		//timelineScroll(sportNo);
         		resetBtns();
         		comp==0?eventCal=sportNo:paraCal=sportNo;
         		$("#name"+sportNo+ ", #ico"+sportNo).css({"background-color":"#f15a24","color":"#fff", "font-weight":700});
         		$("#sport"+sportNo).css({"background-color":"rgba(255,150,0,0.3)"});
         		$("#mob"+sportNo).css({'border-bottom':'1px solid rgb(0,0,0)'});
         		if(stageWidth<600){
         			$("#mob"+sportNo).fadeIn(0);
         		}
         		e.preventDefault();
         		e.stopPropagation();
         	}
         };
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var dateArr=[3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21]; //An array of all event dates
         	var paraArr=[7,8,9,10,11,12,13,14,15,16,17,18];
         	var daystring, calTable;
         
         	var txt=[];
         	txt[19] = sym.$("txt19");
         	var txtArr=[];
         	var olySports=[]; var olyDates=[]; var olyOrder=[];
         	var paraSports=[]; var paraDates=[]; var paraOrder=[];
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33924.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob0 = $(xml).find('headlinemob0').text();
         			headlinemob1 = $(xml).find('headlinemob1').text();
         			headlinetxtmob.html(headlinemob0);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			stand0 = $(xml).find('stand0').text();
         			stand1 = $(xml).find('stand1').text();
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         			if(RTL==true){
         					headlinetxt.attr({'dir':'rtl'});
         					headlinetxtmob.attr({'dir':'rtl'});
         			}
         			// MENU TEXT START
         			for (var i=0; i<3; i++){
         				menuArr[i]=$(xml).find('menuTxt'+i).text();
         				menuTxt[i].html(menuArr[i]);
         			} // MENU TEXT END
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<32; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         			}
         			txt[19].html(txtArr[i]);
         			txt[19].css({"pointer-events":"none",'line-height':lineHeight,'font-size':fontSize});
         			var stringDay = txtArr[19];
         			daystring=stringDay.split(";");//makes array of day names
         			//********************************************************************************************************
         			//SPORT TABLE
         			$(xml).find("sport").each(function(){
         				var $event=$(this);
         				olyOrder.push($event.attr('id'));
         				var eventname=$event.find("event").text();
         				olySports.push(eventname);
         				var eventdates=$event.find("dates").text();
         				var dateString=eventdates.split(";").map(Number);
         				olyDates.push(dateString);
         			});
         			$(xml).find("para").each(function(){
         				var $para=$(this);
         				paraOrder.push($para.attr('id'));
         				var paraname=$para.find("event").text();
         				paraSports.push(paraname);
         				var paradates=$para.find("dates").text();
         				var paradateString=paradates.split(";").map(Number);
         				paraDates.push(paradateString);
         			});
         			//Aug 24
         			var calShow= (todayDate>endOl&&todayDate<endPar)?1:0;
         			makeTable(calShow); clicked=calShow;
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + calShow).$("bg").css(red);
         			sym.getSymbol("menuBtnsMc").$("menuTxt").html(menuArr[calShow]);
         			//********************************************************************************************************
         		},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         function makeTable(comp){
         			if(comp==0){
         				var weekdays=0;
         				var txtArrStart=0;
         				var stand=stand0;
         				var totalDays=19;
         				var eventList=olySports;
         				var numOfDays=21;
         				var startCal=1;
         				var eventDates=olyDates;
         				var allDates=dateArr;
         				var iconImg="sportIcons";
         				var order=olyOrder;
         			}else{
         				var weekdays=4;
         				var txtArrStart=20;
         				var stand=stand1;
         				var totalDays=12;
         				var eventList=paraSports;
         				var numOfDays=18;
         				var startCal=5;
         				var eventDates=paraDates;
         				var allDates=paraArr;
         				var iconImg="paraIcons";
         				var order=paraOrder;
         			}
         			var dateTable="<div class='sportTable dayHeader'>";
         			dateTable+="<div class='eventdates' ><div class='mm'>"+stand+"</div>";
         			for (var d=0;d<totalDays;d++){
         				dateTable+="<div class='dd'>"+txtArr[d+txtArrStart]+"</div>";
         			}
         			dateTable+="</div></div>";
         			var tableTxt="<table class='sportTable'>";
         			for (var i=0;i<eventList.length;i++){ //create a row for each sport
         				//build weekly calendar
         				var counter=startCal;
         				var weekdays2=0;
         				var weekContent="";
         				var weekBody="";
         				//while (weekdays>0){// leave blank for days of previous month
         				//	weekContent += "<div class='monthPre'></div>";
         				//	weekdays--;
         				//}
         				while (counter <= numOfDays){
         					if (weekdays2 > 6){ // start new line after 1 week.
         						weekdays2 = 0;
         						weekContent += "</div><div class='weekdays'>";
         					}	
         					var bgCol=(eventDates[i].indexOf(counter)>=0)?"rgba(255,200,0,0.3)":"rgba(255,255,255,0)";
         					var fontCol=(counter>weekdays+2)?"rgb(0,0,0)":"rgb(150,150,150)";
         					weekContent +="<div id='s"+i+"dd"+counter+"' class='month' style='background-color:"+bgCol+";color:"+fontCol+"'>"+counter+"</div>"; 
         					weekdays2++;
         					counter++;
         				}
         				weekBody +="<div class='wcalendar' id='mobcal"+i+"' width='100%'><div class='daysOfWeek'>";
         				for (var d=0;d<7;d++){
         					weekBody +="<div class='wdays'>"+daystring[d]+"</div>";
         				}
         				weekBody +="</div>";
         				weekBody += "<div class='weekdays'>";
         				weekBody += weekContent;
         				weekBody += "</div></div>";
         				//end build
         
         				var bg=(i%2==0)?'#fff':'#ddd';
         				tableTxt+="<tr id='sport"+i+"' class='sport'  style='background-color:"+bg+"'><td class='sporticon' id='ico"+i+"' style='background-position-y:"+(-30*order[i])+"px'></td>";
         				tableTxt+="<td id='name"+i+"' class='sportName'>"+eventList[i]+"</td>";
         				for (var dd=0;dd<totalDays;dd++){//create a cell for each date
         					tableTxt+="<td id='sport"+i+"_"+dd+"' class='sportdates'>";
         					if(eventDates[i].indexOf(allDates[dd])>=0){//put icon in cell for each event date
         						tableTxt+="<img src='images/icon.png'>";
         					}
         					tableTxt+="</td>";
         				}
         				tableTxt+="</tr><tr class='sportMob' id='mob"+i+"'><td colspan='21'>"+weekBody+"</td></tr>";
         			}
         			tableTxt+="</table>";
         			sym.$("sports").append(tableTxt);
         			sym.$("dates").append(dateTable);
         			$(".sportTable").css({"display":"table","width":"100%","font-family":"pragmatica-web, arial sans-serif","font-size":"13px",'border-collapse':'collapse'});
         			$(".sportTable tr:odd").css({"background-color":"#fff"});
         			$(".sport").css({'display':'table-row','height':'28px','border-color':"rgb(150,150,150)","border-width":"1px 0","border-style":"solid"});
         			$(".eventdates").css({'display':'table-row'});
         			$(".sporticon").css({'display':'table-cell','width':'5%','min-width':'30px','background-image': 'url(images/'+iconImg+'.png)','height':'28px','overflow':'hidden','background-repeat':'no-repeat','cursor':'pointer'});
         			$(".sportName").css({'display':'table-cell','width':'28%','min-width':'120px','padding-left':'3px', 'font-size':'15px'});
         			$(".sportdates, .dd").css({'display':'table-cell','width':'3.5%','min-width':'19px','text-align':'center','border-color':"rgb(150,150,150)","border-width":"0 1px","border-style":"solid","pointer-events":"none",'line-height':"16px"});
         			$(".sportdates").css({'padding': '5px 0px 0px'});
         			$(".sportdates img").css({'vertical-align':'middle'});
         			$(".mm").css({'display':'table-cell','width':'33%','min-width':'150px','padding-left':'5px','font-size':stanSize});
         			$(".dayHeader").css({'position':'absolute','top':'0px'});
         			$(".sportMob").css({'display':'table-row','background-color':'#fff','width':'100%'});
         			sym.$('dates').css({'overflow-y':'scroll'});
         			$(".sportMob").fadeOut(0);
         			$(".daysOfWeek, .weekdays").css({'display':'table-row'});
         			$(".month, .monthPre, .wdays").css({'display':'table-cell','width':'14.25%','vertical-align':'middle','border':'1px solid rgba(255,150,0,0.3)'});
         			$(".wcalendar").css({'display':'table','width':'100%','margin':'3px 0px','font-family':'pragmatica-web,arial,sans-serif','font-size':'12px','border-collapse':'collapse','text-align':'center','background-color':'rgb(255,255,255)'});
         			$('.weekdays').css({'height':'30px'});
         			$(".rtl").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         			if(RTL==true){
         				$(".sportTable, .wcalendar, .sportName, .mm, .dd, .wdays, .daysOfWeek, .weekdays").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         				$(".sportName, .mm").css({'text-align':'right', 'padding-right':'3px'});
         				$('.month').css({'font-size':'16px','transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         				$(".sportName, .mm").attr({'dir':'rtl'});
         			}else{
         				$(".month").css({'font-size':'16px'});
         			}
         			for (var n=0;n<eventList.length;n++){
         				$("#ico"+n).css({'background-position':'0px '+(-30*order[n])+'px'});//for Firefox
         				$("#ico"+n).on('click',showSport(n,comp));
         				$("#name"+n).css({'cursor':'pointer'});
         				$("#name"+n).on('click',showSport(n,comp));
         			}
         }
         //********************************************************************************************************
         // MENU BUTTONS
         //********************************************************************************************************
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<2; h++){
         	menuArray.push(h);
         }
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(grey);
         		if (mobOpen == true) {
         			mob = 1;
         			menuMob();
         		}
         	}
         }
         resetmenu();
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		sym.$("logoMc").fadeOut(200);
         		if(clicked!=menuNo){
         		clicked = menuNo;			
         		eventCal=0;paraCal=0;
         		sym.$("sports").stop().animate({scrollTop:(0)}, 0);
         		resetmenu();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(red);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").html(menuArr[menuNo]);
         		sym.$("sports").empty();
         		sym.$("dates").empty();
         		makeTable(menuNo);
         		initSize();
         		}
         	};
         };
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         //sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(red);
         
         //********************************************************************************************************
         // MOBILE MENU BUTTON
         //********************************************************************************************************
         sym.$("menuBtnMob").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (mobOpen == true) {
         		mob = 1;
         	} else {
         		mob = 2;
         	}
         	menuMob();
         });
         
         function menuMob() {
         	var stageWidth=sym.$("Stage").width();
         	if (RTL == false){
         		if (mob == 0){ // HIDE MOBILE MENU
         			sym.$("menuBtnMob").stop().animate({top:-40}, 0);
         			for (var s=0; s<3; s++){
         					sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, right:40-(s*40)}, 200, 'easeOutCubic');
         			}
         		}else{
         			if (mob == 1){ // MOBILE MENU CLOSED
         				for (var s=0; s<3; s++){
         					sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, right:0}, 200, 'easeOutCubic');
         				}
         				mobOpen = false;
         			}
         			if (mob == 2){ // MOBILE MENU OPEN
         				for (var s=0; s<3; s++){
         					sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:(s+1)*40, right:0}, 200, 'easeOutCubic');
         				}
         				mobOpen = true;
         			}
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         		}
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "text-align":"left", "padding":"6px"});
         		sym.$("standTxt").css({"pointer-events":"none", "text-align":"left", "padding":"6px"});
         	}else{ // RTL = TRUE
         		if (mob == 0){ // HIDE MOBILE MENU
         			sym.$("menuBtnMob").stop().animate({top:-40}, 0);
         			for (var s=0; s<3; s++){
         					sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:40-(s*40)}, 0, 'easeOutCubic');
         			}
         		}else{
         			if (mob == 1){ // MOBILE MENU CLOSED
         				for (var s=0; s<3; s++){
         					sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:0}, 0, 'easeOutCubic');
         				}
         				mobOpen = false;
         			}
         			if (mob == 2){ // MOBILE MENU OPEN
         				for (var s=0; s<3; s++){
         					sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:(s+1)*40, left:0}, 0, 'easeOutCubic');
         				}
         				mobOpen = true;
         			}
         			sym.$("menuBtnMob").stop().animate({top:0, left:0}, 0);
         		}
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "text-align":"right", "padding":"6px", "right":"10px", "left":"auto"});
         		sym.$("standTxt").css({"pointer-events":"none", "text-align":"right", "padding":"6px"});
         		sym.$("menuBtnsMc").stop().animate({left:0}, 0);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").css({"text-align":"left", "left":"90px"});
         	}
         }
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	if(stageWidth<800){
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeOut(0);
         	}else{
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeIn(0);
         	}
         	var mobhead=(clicked==0)?headlinemob0:headlinemob1;
         	if(stageWidth<600){
         		$(".dd, .sportdates").fadeOut(0);
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(mobhead);
         		$("#mob"+eventCal).fadeIn(0);
         		$("#mob"+eventCal).css({'border-bottom':'1px solid rgb(0,0,0)'});
         		$("#name"+eventCal+", #ico"+eventCal).css({"background-color":"#f15a24","color":"#fff", "font-weight":700});
         		$("#sport"+eventCal).css({"background-color":"rgba(255,150,0,0.3)"});
         	}else{
         		$(".dd, .sportdates").fadeIn(0);
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		$(".sportMob").fadeOut(0);
         		$(".sportMob").css({'border-bottom':0});
         	}
         	if (stageWidth<480){
         		mob = 1;
         	}else{
         		mob = 0;
         	}
         	setStyle();
         	menuMob();
         }
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //********************************************************************************************************
         $(window).on('resize',initSize);
         setTimeout(function(){ sym.$("logoMc").fadeOut(200); }, 1600);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------

      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'menuBtn1'
   (function(symbolName) {   
   
   })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'auxBtn'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("auxBtnsMc");
   //Edge symbol end:'auxBtnsMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'dateBx_1'
   (function(symbolName) {   
   
   })("iconBx");
   //Edge symbol end:'iconBx'

   //=========================================================
   
   //Edge symbol: 'LogoMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("LogoMc");
   //Edge symbol end:'LogoMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33924");