/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var mob = 0;
         	var mobOpen = false;
         	var clicked = 0;
         	var btnNo = 0;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px", 'line-height':"15px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // MENU TEXT START
         //********************************************************************************************************
         	var menuTxt=[];
         	menuTxt[0] = sym.$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[1] = sym.$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[2] = sym.$("menuTxt").css({"pointer-events":"none"});
         	var menuArr=[];
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         
         	for (var i=0; i<16; i++){
         		txt[i] = sym.getSymbol("mapMc").getSymbol("scrollableMapMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=16; i<19; i++){
         		txt[i] = sym.getSymbol("keyMc").$("txt"+i).css({"pointer-events":"none", "width":"auto"});
         	}
         	for (var i=19; i<23; i++){
         		txt[i] = sym.getSymbol("timelineCapMc").$("txt"+i).css(blackTxtBox);
         	}
         	for (var i=23; i<35; i++){
         		txt[i] = sym.getSymbol("trenchMc").getSymbol("scrollableMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33906.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			//create table
         			var newTable="<div id='newTab'>";
         			var dataTab1;
         			newTable+="<div id='newtab1'>";
         			$(xml).find('table1').each(function() {
         				var strap=$(this).find('strap').text();
         				newTable+="<div class='redstrap'>"+strap+"</div>";
         				newTable+="<table class='events'>";
         				$(this).find('number1').each(function() {
         					dataTab1 = $(this).find("date1").text();
         					newTable+="<tr><td>"+dataTab1+"</td></tr>";
         				});
         				newTable+="</table>";
         			});
         
         			sym.getSymbol("tablesMc").$("tableMc").append(newTable);
         			//apply styles
         			$("#newTab").css({"font-family":"Pragmatica-web, sans-serif"});
         			$(".events").css({"text-align":"left","color":"#000000","font-size":"13px","line-height":"15px",'border':0,'border-collapse':'collapse'});
         			$("#newtab1 tr:odd").css({"background-color":"#fff"});
         			$("#newtab1 tr:even").css({"background-color":"#eaece5"});
         			$("#newtab1 tr:first-child").css({"text-align":"center", "background-color":"#836300","color":"#ffffff", "font":"13px, Pragmatica-web, sans-serif"});
         			$("#newtab1 tr:last-child").css({"text-align":"left", "background-color":"#333","color":"#ffffff", "font":"13px, Pragmatica-web, sans-serif"});
         			$(".events td").css({'padding':'10px 20px 10px 10px'});
         			$(".events img").css({'max-width':'195px','padding-bottom':'10px'});
         			sym.getSymbol("tablesMc").$("tableMc").css({'overflow-y':'scroll'});
         
         			if (RTL == true) {
         				$(".events").css({"text-align":"right","color":"#000000","font-size":"13px","line-height":"15px",'border':0,'border-collapse':'collapse'});
         				$("#newtab1 tr:first-child").css({"text-align":"center", "background-color":"#836300","color":"#ffffff", "font":"13px, Pragmatica-web, sans-serif"});
         				$("#newtab1 tr:last-child").css({"text-align":"right", "background-color":"#333","color":"#ffffff", "font":"13px, Pragmatica-web, sans-serif"});
         				for (var i=19; i<23; i++){
         					txt[i] = sym.getSymbol("timelineCapMc").$("txt"+i).css({"text-align":"right"});
         				}
         			}
         
         			// MENU TEXT START
         			for (var i=0; i<3; i++){
         				menuArr[i]=$(xml).find('menuTxt'+i).text();
         				menuTxt[i].html(menuArr[i]);
         			} // MENU TEXT END
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<35; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         			sym.getSymbol("mapMc").getSymbol("scrollableMapMc").$("txt3").css(blackTxtBox);
         			sym.getSymbol("mapMc").getSymbol("scrollableMapMc").$("txt8").css(blackTxtBox);
         			sym.getSymbol("trenchMc").getSymbol("scrollableMc").$("txt23").css({"pointer-events":"none", "font-size":"20px"});
         			sym.getSymbol("trenchMc").getSymbol("scrollableMc").$("txt24").css({"pointer-events":"none", "height":"auto"});
         			sym.getSymbol("trenchMc").getSymbol("scrollableMc").$("txt24").animate({top:156 - sym.getSymbol("trenchMc").getSymbol("scrollableMc").$("txt24").height()+10}, 0);
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //********************************************************************************************************
         // SCROLL TIMELINE
         //********************************************************************************************************
         function timelineScroll(){
         // Map scroll position to timeline position
         var tabHeight = sym.getSymbol("tablesMc").$("#newTab").height();
         var tableHeight = sym.getSymbol("tablesMc").$("tableMc").height();
         var scrollPos = sym.getSymbol("tablesMc").$("tableMc").scrollTop();
         var duration = sym.getSymbol("timelineMc").getDuration();
         var percent = scrollPos / (tabHeight - tableHeight);
         var time = duration * percent;
         sym.getSymbol("timelineMc").stop(time);
         sym.getSymbol("timelineCapMc").stop(time);
         sym.getSymbol("tablesMc").$("scrollDown").fadeOut(200);
         sym.getSymbol("tablesMc").$("tableMc").css({'overflow-y':'auto'});
         }	
         sym.getSymbol("tablesMc").$("tableMc").on('scroll',timelineScroll);	
         sym.getSymbol("tablesMc").$("tableMc").css({'overflow-x':'hidden'});
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("timelineMc").stop().animate({width:stageWidth+200}, 0);
         	if(stageWidth<800){
         		if (clicked == 0){
         			sym.$("tablesMc").stop().animate({left:stageWidth-230, width:230}, 0);
         		}
         		if (clicked == 1){
         			sym.$("tablesMc").stop().animate({left:stageWidth+20}, 0);
         			sym.$("mapMc").stop().animate({left:stageWidth/2-285, width:stageWidth}, 0);
         		}
         		if (clicked == 2){
         			sym.$("tablesMc").stop().animate({left:stageWidth+20}, 0);
         			sym.$("trenchMc").stop().animate({left:stageWidth/2-285, width:stageWidth}, 0);
         		}
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeOut(0);
         		sym.$("standTxt").css({"font-size":"25px", "line-height":"25px"});
         	}else{
         		if (clicked == 1){
         			sym.$("mapMc").stop().animate({left:0, width:570}, 0);
         		}
         		if (clicked == 2){
         			sym.$("trenchMc").stop().animate({left:0, width:570}, 0);
         		}
         		sym.$("tablesMc").stop().animate({left:stageWidth-230, width:230}, 0);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeIn(0);
         		sym.$("standTxt").css({"font-size":"25px", "line-height":"25px"});
         	}
         	if(stageWidth<640){
         		sym.$("standTxt").css({"font-size":"25px", "line-height":"25px"});
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	if(stageWidth<570){
         		sym.$("mapMc").css({'cursor':'ew-resize'});
         		sym.$("trenchMc").css({'cursor':'ew-resize'});
         		if (clicked == 1){
         			sym.$("mapMc").stop().animate({left:0, width:stageWidth}, 0);
         		}
         		if (clicked == 2){
         			sym.$("trenchMc").stop().animate({left:0, width:stageWidth}, 0);
         		}
         		sym.$("standTxt").css({"font-size":"23px", "line-height":"23px"});
         	}else{
         		sym.$("mapMc").css({'cursor':'auto'});
         		sym.$("trenchMc").css({'cursor':'auto'});
         	}
         	if (stageWidth<480){
         		if (clicked == 0){
         			sym.$("tablesMc").stop().animate({left:0, width:stageWidth}, 0);
         		}
         		if (clicked == 1){
         			sym.$("tablesMc").stop().animate({left:stageWidth+20, width:230}, 0);
         		}
         		sym.$("standTxt").css({"font-size":"20px", "line-height":"20px"});
         		mob = 1;
         	}else{
         		if (clicked == 0){
         			sym.$("tablesMc").stop().animate({left:stageWidth-230, width:230}, 0);
         		}
         		mob = 0;
         	}
         	setStyle();
         	menuMob();
         }
         
         //********************************************************************************************************
         // MENU BUTTONS
         //********************************************************************************************************
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<3; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(grey);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		if (mobOpen == true) {
         			mob = 1;
         			menuMob();
         		}
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		sym.$("introMc").fadeOut(200);
         		sym.$("standTxt").fadeOut(200);
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(red);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[menuNo]);
         		sym.$("keyMc").stop().animate({left:-500}, 200, 'easeInCubic');
         		sym.$("mapMc").stop().animate({left:-590}, 200, 'easeOutCubic');
         		sym.$("trenchMc").stop().animate({left:-590}, 200, 'easeOutCubic');
         		sym.$("timelineMc").fadeOut(0);
         		sym.$("timelineCapMc").fadeOut(0);
         		initSize();
         		if (menuNo == 0){
         			sym.$("timelineMc").fadeIn(0);
         			sym.$("timelineCapMc").fadeIn(0);
         		}
         		if (menuNo == 1){
         			sym.$("keyMc").stop().animate({left:0}, 500, 'easeOutCubic');
         			sym.$("mapMc").stop().animate({left:0}, 500, 'easeOutCubic');
         		}
         		if (menuNo == 2){
         			sym.$("trenchMc").stop().animate({left:0}, 500, 'easeOutCubic');
         		}
         
         	};
         };
         
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         
         //********************************************************************************************************
         // MOBILE MENU BUTTON
         //********************************************************************************************************
         sym.$("menuBtnMob").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (mobOpen == true) {
         		mob = 1;
         	} else {
         		mob = 2;
         	}
         	menuMob();
         });
         function menuMob() {
         	var stageWidth=sym.$("Stage").width();
         	if (RTL == false){
         		if (mob == 0){ // HIDE MOBILE MENU
         			sym.$("menuBtnMob").stop().animate({top:-40}, 0);
         			for (var s=0; s<3; s++){ 
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:180+(s*40)}, 200, 'easeOutCubic');
         			}
         		}
         		if (mob == 1){ // MOBILE MENU CLOSED
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<3; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:260}, 200, 'easeOutCubic');
         			}
         			mobOpen = false;
         		}
         		if (mob == 2){ // MOBILE MENU OPEN
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<3; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:(s+1)*40}, 200, 'easeOutCubic');
         			}
         			mobOpen = true;
         		}
         		sym.$("menuBtnsMc").stop().animate({left:stageWidth-300}, 0);
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "text-align":"left", "padding":"6px"});
         		sym.$("standTxt").css({"pointer-events":"none", "text-align":"center", "padding":"6px"});
         		sym.$("menuBtnMob").stop().animate({left:stageWidth-40}, 0);
         	}else{ // RTL = TRUE
         		if (mob == 0){ // HIDE MOBILE MENU
         			sym.$("menuBtnMob").stop().animate({top:-40}, 0);
         			for (var s=0; s<3; s++){ 
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:80-(s*40)}, 200, 'easeOutCubic');
         			}
         		}
         		if (mob == 1){ // MOBILE MENU CLOSED
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<3; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:0}, 200, 'easeOutCubic');
         			}
         			mobOpen = false;
         		}
         		if (mob == 2){ // MOBILE MENU OPEN
         			sym.$("menuBtnMob").stop().animate({top:0}, 0);
         			for (var s=0; s<3; s++){
         				sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:(s+1)*40}, 200, 'easeOutCubic');
         			}
         			mobOpen = true;
         		}
         		sym.$("menuBtnsMc").stop().animate({left:0}, 0);
         		sym.$("standTxt").css({"text-align":"center", "padding-top":"6px"});
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "text-align":"right", "padding-top":"6px"});
         
         		sym.$("menuBtnMob").stop().animate({left:0}, 0);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").css({"text-align":"left", "left":"130px"});
         	}
         }
         
         //********************************************************************************************************
         // MOUSE SCROLL SYMBOL
         //********************************************************************************************************
         var x,left,down;
         sym.$("timelineMc").mousedown(function(e){
             e.stopPropagation(); e.preventDefault();
             down=true;
             x=e.pageX;
             left=$(this).scrollLeft();
         });
         
         sym.$("timelineMc").mousemove(function(e){
         	e.stopPropagation(); e.preventDefault();
             if(down){
                 var newX=e.pageX;
                 sym.$("timelineMc").scrollLeft(left-newX+x);    
             }
         });
         sym.$("timelineMc").mouseup(function(e){down=false;});
         //********************************************************************************************************
         sym.$("mapMc").mousedown(function(e){
             e.stopPropagation(); e.preventDefault();
             down=true;
             x=e.pageX;
             left=$(this).scrollLeft();
         });
         
         sym.$("mapMc").mousemove(function(e){
         	e.stopPropagation(); e.preventDefault();
             if(down){
                 var newX=e.pageX;
                 sym.$("mapMc").scrollLeft(left-newX+x);    
             }
         });
         sym.$("mapMc").mouseup(function(e){down=false;});
         //********************************************************************************************************
         sym.$("trenchMc").mousedown(function(e){
             e.stopPropagation(); e.preventDefault();
             down=true;
             x=e.pageX;
             left=$(this).scrollLeft();
         });
         
         sym.$("trenchMc").mousemove(function(e){
         	e.stopPropagation(); e.preventDefault();
             if(down){
                 var newX=e.pageX;
                 sym.$("trenchMc").scrollLeft(left-newX+x);    
             }
         });
         sym.$("trenchMc").mouseup(function(e){down=false;});
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("mapMc").css({'overflow-x':'auto'});
         	sym.$("trenchMc").css({'overflow-x':'auto'});
         	sym.getSymbol("mapMc").getSymbol("scrollableMapMc").$("txt11").css({"text-align":"center", "line-height":"22px"});
         	sym.getSymbol("keyMc").$("keyBg").stop().animate ({width:sym.getSymbol("keyMc").$("txt17").width()+60}, 0);
         }
         setStyle();
         
         //********************************************************************************************************
         // SET STAGE
         //********************************************************************************************************
         sym.$("mapMc").stop().animate ({left:-600}, 0);
         sym.$("trenchMc").stop().animate ({left:-600}, 0);
         sym.$("keyMc").stop().animate ({left:-600}, 0);
         sym.$("timelineMc").fadeOut(0);
         sym.$("timelineCapMc").fadeOut(0);
         
         //********************************************************************************************************
         // SOURCE BUTTON
         //********************************************************************************************************
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'menuBtn1'
   (function(symbolName) {   
   
   })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'auxBtn'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'galBtns'
   (function(symbolName) {   
   
   })("rectBtns");
   //Edge symbol end:'rectBtns'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("auxBtnsMc");
   //Edge symbol end:'auxBtnsMc'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'scrollMc_1'
   (function(symbolName) {   
   
      })("mapMc");
   //Edge symbol end:'mapMc'

   //=========================================================
   
   //Edge symbol: 'tableMc'
   (function(symbolName) {   
   
   })("tableMc");
   //Edge symbol end:'tableMc'

   //=========================================================
   
   //Edge symbol: 'tablesMc'
   (function(symbolName) {   
   
   })("tablesMc");
   //Edge symbol end:'tablesMc'

   //=========================================================
   
   //Edge symbol: 'introMc'
   (function(symbolName) {   
   
   })("introMc");
   //Edge symbol end:'introMc'

   //=========================================================
   
   //Edge symbol: 'keyMc'
   (function(symbolName) {   
   
   })("keyMc");
   //Edge symbol end:'keyMc'

   //=========================================================
   
   //Edge symbol: 'timelineMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5500, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("timelineMc");
   //Edge symbol end:'timelineMc'

   //=========================================================
   
   //Edge symbol: 'timelineCapMc'
   (function(symbolName) {   
   
   })("timelineCapMc");
   //Edge symbol end:'timelineCapMc'

   //=========================================================
   
   //Edge symbol: 'mapMc_1'
   (function(symbolName) {   
   
         })("trenchMc");
   //Edge symbol end:'trenchMc'

   //=========================================================
   
   //Edge symbol: 'scrollableMc_1'
   (function(symbolName) {   
   
      })("scrollableMapMc");
   //Edge symbol end:'scrollableMapMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33906");