/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         var RTL="false"; //select true if right to left
         var stageWidth, gnYear=2016, gn=33835;//2016 33835
         //REMOVE mobgraph
         
         //CREATE ARRAYS
         var screenArr=['globeMc','driverChampMc','teamChampMc','driversMc','liveMc','circuitMc','timingMc','resultMc']; //scenes
         var teamArr=['MER','FER','WIL','RBR','FOR','REN','TOR','SAU','MLA','MAN','HAA'];//2016
         var countryArr=['aus','brn','chn','rus','esp','mon','can','eur','aut','eng','hun','ger','bel','ita','sin','mas','jpn','usa','mex','bra','uae'];//2016
         var latitude =[-38,26,31,44,41,44,46,40,47,52,47,49,50,46,1,3,35,29,19,-24,24];//latitude
         var longitude =[145,50,121,40,2,7,-74,50,14,1,19,9,6,9,104,102,137,-95,-99,-47,55];//longitude
         
         
         var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         
         //***************************** XML FOR TEXT *************************************
         //AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         var headline, headlinemob, months, keyWidth, liveCap, statCap, loaded=0, clicked=0, selectPhase, carStop, racestatus;
         var champHead=[], caps=[], capsText=[], raceArr=[], raceText=[], raceCorners=[], teamTxtArr=[], driverTxtArr=[], gpDate=[], driverID=[], phaseBtnTxt=[], phaseTxtArr=[], menuArray=[], menuText=[], menuTxtArr=[], coundownCap=[];
         for (var r=0;r<countryArr.length; r++){
         	raceArr[r]=[];
         }
         //var teamDriverArr=[];
         for (var t=0;t<teamArr.length; t++){
         	teamTxtArr[t]=[]; driverTxtArr[t]=[];
         } 
         for (var i=0; i<5; i++){ //menu icons
         	menuText[i]= sym.getSymbol("menuButtons").getSymbol("menuBtn"+i).$("menuTxt").css("pointer-events","none");
         	sym.getSymbol("menuButtons").getSymbol("menuBtn"+i).$("icon").attr('src','images/menuIcon'+i+'.png');
         }
         
         for (var i=5; i<8; i++){ //race button icons
         	menuText[i]= sym.getSymbol("raceButtons").getSymbol("menuBtn"+i).$("menuTxt").css("pointer-events","none");
         	sym.getSymbol("raceButtons").getSymbol("menuBtn"+i).$("icon").attr('src','images/menuIcon'+i+'.png');
         }
         
         for (var p=0;p<8;p++){//phase buttons
         	phaseBtnTxt[p] = sym.getSymbol("raceButtons").getSymbol("phaseBtn"+p).$("phaseTxt").css("pointer-events","none");
         }
         
         capsText[0]=sym.getSymbol("circuitMc").$("weatherTxt").css("pointer-events","none");
         capsText[1]=sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("speedGearsMc").getSymbol("gearsMc").$("gearTxt").css("pointer-events","none");
         capsText[2]=sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("speedGearsMc").getSymbol("gearsMc").$("speedTxt").css("pointer-events","none");
         capsText[3]=sym.getSymbol("circuitMc").getSymbol("circuitOverlay").$("key1").css("pointer-events","none");
         capsText[4]=sym.getSymbol("circuitMc").getSymbol("circuitOverlay").$("key2").css("pointer-events","none");
         capsText[5]=sym.getSymbol("circuitMc").getSymbol("circuitOverlay").$("key3").css("pointer-events","none");
         capsText[6]= sym.getSymbol("liveMc").$("lapTxt").css("pointer-events","none");
         capsText[7]= sym.getSymbol("liveMc").$("timeTxt").css("pointer-events","none");
         capsText[8]= sym.getSymbol("resultMc").$("resultTxt").css("pointer-events","none");
         raceText[0]=sym.getSymbol("circuitMc").$("gpTxt").css("pointer-events","none");
         raceText[1]=sym.getSymbol("circuitMc").$("venueTxt").css("pointer-events","none");
         raceText[2]=sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("speedGearsMc").$("distanceTxt").css("pointer-events","none");
         raceText[3]=sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("speedGearsMc").$("lapTxt").css("pointer-events","none");
         
         $.ajax({	
         	type: "GET",
         	url: "GN"+gn+".xml",
         	dataType: "xml",
         	success: function(xml) {
         		headline=$(xml).find('headline').text();
         		headlinemob=$(xml).find('headlinemob').text();
         		sym.getSymbol('styleMc').$('headlinetxt').html(headline);
         		var source=$(xml).find('source').text();
         		sourcetxt.html(source);
         		for (var i=0;i<menuText.length;i++){ //get menu labels
         			menuTxtArr[i]= $(xml).find('menu'+i).text();
         			menuText[i].html(menuTxtArr[i]);
         		}
         		var phaseString=$(xml).find('phasebuttons').text(); //get phase button labels
         		phaseTxtArr = phaseString.split(";");
         		for (var p=0;p<8;p++){
         			phaseBtnTxt[p].html(phaseTxtArr[p]);
         		}
         		for (var h=0;h<2;h++){
         			champHead[h]=$(xml).find('head'+h).text();
         		}
         		sym.getSymbol("driverChampMc").$("driverChampTxt").html(champHead[0]);
         		var monthstring = $(xml).find('months').text(); //get month names
         		months=monthstring.split(";");
         		var statCapString=$(xml).find('statusCap').text();
         		statCap= statCapString.split(";");
         		var liveCapString=$(xml).find('statusTxt').text();
         		liveCap= liveCapString.split(";");
         		var countdownString=$(xml).find('countdown').text();
         		coundownCap= countdownString.split(";");
         		for (var c=0;c<15;c++){
         			caps[c]= $(xml).find('cap'+c).text(); //fixed text captions
         			if (c<capsText.length){
         				capsText[c].html(caps[c]);
         			}
         		}
         		sym.getSymbol("timingMc").$("timeTxt").html(caps[7]);
         		sym.getSymbol("globeMc").$("mapTxt0").html(caps[13]);
         		sym.getSymbol("globeMc").$("mapTxt1").html(caps[14]);
         		for (var r=0;r<raceArr.length;r++){			//get details for each race
         			$(xml).find("race"+r).each(function(){
         				var $races = $(this);
         				for (var n=0; n<5; n++){
         					raceArr[r][n] = $races.find('raceCap'+n).text();
         				}
         				gpDate[r]=$races.find('raceDate').text();
         				var cornerString=$races.find('corners').text();
         				raceCorners[r]=cornerString.split(";");		
         			});
         		}				
         		for (var i=0; i<raceText.length; i++){ //add labels for first race circuit
         			raceText[i].html(raceArr[0][i]);
         		}
         		for (var t=0;t<teamArr.length;t++){	
         			$(xml).find("team"+t).each(function(){
         				var $teams = $(this);
         				for (var m=0; m<2; m++){
         					teamTxtArr[t][m] = $teams.find('teamCap'+m).text(); 	//get details for each team
         				}
         				$teams.find("driver").each(function(){
         					var $driver = $(this);
         					driverTxtArr[t].push($driver);
         				});
         			});
         		}
         		sym.getSymbol("circuitMc").$("statusTxt").html(statCap[4]);
         		sym.getSymbol("circuitMc").$("statusTxt").css({"background-color":"rgb(100,100,100)"});
         		sym.getSymbol("liveMc").$("statusTxt").html(statCap[4]);	
         		getStats('MER',3);
         		sym.getSymbol(screenArr[3]).$("driveCar"+carPos).css({'left':carStop+'px'});	
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("mainCar").attr("src","cars/"+teamArr[0]+"big.png");
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("reflection").attr("src","cars/"+teamArr[0]+"big.png");
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("driverHead").attr("src","drivers/"+teamArr[0]+".png");
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("bkwheel").attr("src","cars/"+teamArr[0]+"bk.png");
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("frwheel").attr("src","cars/"+teamArr[0]+"fr.png");
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("bkwheelR").attr("src","cars/"+teamArr[0]+"bk.png");
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("frwheelR").attr("src","cars/"+teamArr[0]+"fr.png");
         
         	},
         	complete: function(){
         				initSize();
         				counter=setInterval(countDown,1000);
         	}
         }); 
         //******************************* END XML ********************************************
         //******************************* MENU BUTTONS ***************************************
         var raceNo=0, mob, mobGraph, raceIDno; //number to select live race
         
         for (var m = 0; m < 5; m++){
         	var menuBtnSymbols = sym.getSymbol("menuButtons").getSymbol("menuBtn" +m); // Create an instance element of a symbol as a child of the given parent element
         	menuBtnSymbols.setVariable("menuId", m); //set the value of a Symbol variable
         	menuArray.push(menuBtnSymbols); //push it into the array
         	sym.getSymbol("menuButtons").$("menuBtn" +m).css({"cursor":"pointer"});
         }
         for (var m = 5; m < 8; m++){
         	var menuBtnSymbols = sym.getSymbol("raceButtons").getSymbol("menuBtn" +m); // Create an instance element of a symbol as a child of the given parent element
         	menuBtnSymbols.setVariable("menuId", m); //set the value of a Symbol variable
         	menuArray.push(menuBtnSymbols); //push it into the array
         	sym.getSymbol("raceButtons").$("menuBtn" +m).css({"cursor":"pointer"});
         }
         $.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
         	var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
         	menuBtnElement.on ("click", {menuId:count}, menuBtnClick);
         });
         sym.getSymbol("raceButtons").$("menuBtn7").off('click');//unbind results button
         
         function resetmenu(){
         	sym.getSymbol("menuButtons").$("menuBtn2xtra").stop().animate({'top':'-95px'},200);//show standings btns
         	sym.getSymbol("menuButtons").$("teamBtns").stop().animate({'top':'-540px'},200);//show phases btns
         	sym.getSymbol("raceButtons").$("menuBtn5xtra").stop().animate({'top':'0px'},200);//hide
         	clicked=0;//reset clicked button
         	for (var i=0; i<menuArray.length; i++){
         		menuArray[i].$("menuBg").fadeIn(0);
         	}
         }
         //resetmenu();
         function menuBtnClick (e){
         	e.preventDefault();
         	e.stopPropagation();
         	var menuMenu_id = (e.data.menuId); //get the id of the clicked item
         	resetmenu();
         	switch (menuMenu_id){
         		case(1):
         			sym.getSymbol("menuButtons").$("menuBtn2xtra").stop().animate({'top':'40px'},200);//show standings btns
         		break;
         		case(4):
         			sym.getSymbol("menuButtons").$("teamBtns").stop().animate({'top':'40px'},200);//show phases btns
         		break;
         		case(6):
         			sym.getSymbol("raceButtons").$("menuBtn5xtra").stop().animate({'top':'-285px'},200);//hide
         		break;
         		default:
         			$(".screens").fadeOut(0);
         			menuMenu_id>1?sym.$(screenArr[menuMenu_id-1]).fadeIn(0):(mob==1)?sym.$("calendarMc").fadeIn(0):sym.$(screenArr[menuMenu_id]).fadeIn(0);
         			$(".gpname, gpdate, .gpstat").fadeIn(0);
         			sym.$("calendarMc").stop().animate({width:"40%"},0);
         			sym.$("circuitMc").stop().animate({width:"60%"},0);
         			sym.$("raceButtons").stop().animate({width:"60%"},0);
         			if (menuMenu_id==0){
         				getSeason();
         				clearInterval(seasonInterval);
         				seasonInterval=setInterval(getSeason,900000);
         				getRace(latestGP);
         			}
         			if (menuMenu_id==2){ //drivers champs
         				getDriverStandings();
         			}
         			if (menuMenu_id==3){ //team champs
         				getConsStandings();
         			}
         			if	(menuMenu_id==5){ //4 live 5 circuit, 6 timings 7 results
         					playIt(latestGPno);
         			}
         			if(menuMenu_id<5&&menuMenu_id!=0){
         			sym.$("raceButtons").animate({'bottom':'-25px'},400);
         			}else{
         				sym.$("raceButtons").animate({'bottom':'15px'},400);
         			}
         			clicked=menuMenu_id;	
         			initSize();
         		break;
         	}
         }
         menuArray[0].$("menuBg").fadeOut(0);//show first button as clicked
         
         //TEAM STRIP BUTTONS	
         var carPos=0, hidden=1;//for showTeam
         var showTeam = function(teamdetails,longteam){ //to handle lexical scope
         	return function (e) {
         	resetmenu();
         	$(".screens").fadeOut(0);
         	sym.$("raceButtons").animate({'bottom':'-25px'},400);
         	sym.$(screenArr[3]).fadeIn(200);
         	menuArray[4].$("menuBg").fadeOut(0);
         	getStats(teamdetails,3);
         		if (carPos==0){
                  carPos=1;
                  hidden=0;
               }else{
                  carPos=0;
                  hidden=1;
               }
         		sym.getSymbol("driversMc").$("driveCar"+carPos).css({'left':'-200%'});	
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("mainCar").attr("src","cars/"+teamdetails+"big.png");
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("reflection").attr("src","cars/"+teamdetails+"big.png");
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("driverHead").attr("src","drivers/"+teamdetails+".png");
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("bkwheel").attr("src","cars/"+teamdetails+"bk.png");
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).$("frwheel").attr("src","cars/"+teamdetails+"fr.png");
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("bkwheelR").attr("src","cars/"+teamdetails+"bk.png");
         		sym.getSymbol(screenArr[3]).getSymbol("driveCar0").$("frwheelR").attr("src","cars/"+teamdetails+"fr.png");
         		sym.getSymbol("driversMc").$("driveCar"+carPos).delay(1600).stop().animate ({left:carStop}, 1100);	
         		sym.getSymbol("driversMc").getSymbol("driveCar"+carPos).play();
         		sym.getSymbol("driversMc").$("driveCar"+hidden).stop().animate ({left:'110%'}, 1200);
         		sym.getSymbol("driversMc").getSymbol("driveCar"+hidden).play();
         		var team=teamdetails;
         		clicked=4;
         		initSize();
         		e.preventDefault();
         		e.stopPropagation();
         	};
         };
         for (var j=0;j<teamArr.length;j++){ //Create team buttons
         			sym.getSymbol("menuButtons").getSymbol("teamBtns").$("teamBtn"+j).css({"cursor":'pointer'});
         			sym.getSymbol("menuButtons").getSymbol("teamBtns").$("teamBtn"+j).click(showTeam(teamArr[j],teamTxtArr[j][0]));
         }
         //******************************* END MENU *******************************************
         //******************************* RESPONSIVE *****************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	sym.stop(stageWidth*10);
         	//car animations
         	var symWidth=sym.$("teamChampMc").width();
         	var scaleCar=(symWidth<480)?symWidth/480:1;
         	sym.getSymbol("teamChampMc").$("carPic").css({'transform':'scale('+0.5*scaleCar+','+0.5*scaleCar+')'});
         	for (var i=0;i<2;i++){
         	 sym.getSymbol("driversMc").$("driveCar"+i).css({'transform':'scale('+0.55*scaleCar+','+0.55*scaleCar+')'});
         	}
         	var carWidth=sym.getSymbol("teamChampMc").$("carPic").width();
         	carStop=(symWidth-carWidth)/2;
         	sym.getSymbol("teamChampMc").$("carPic").css({'left':carStop+'px'});
         	sym.getSymbol("driversMc").$("driveCar"+carPos).css({'left':carStop+'px'});
         	$(".screens").fadeOut(0);
         	(symWidth<=480)?($(".griddriver").fadeOut(0),$(".driverShort").fadeIn(0)):($(".griddriver").fadeIn(0),$(".driverShort").fadeOut(0));
         
         	if(stageWidth<=480){
         		sym.getSymbol('styleMc').$('headlinetxt').html(headlinemob);
         		$(".resultrace").css({'font-size':'12px'});
         		$(".liverace").css({'font-size':'12px'});
         		mob=1;
         	}else{
         		sym.getSymbol('styleMc').$('headlinetxt').html(headline);
         		$(".resultrace").css({'font-size':'12px'});
         		$(".liverace").css({'font-size':'12px'});
         		mob=0;
         	}
         	if(stageWidth>=640){
         		sym.$('calendarMc').fadeIn(0);
         		if(clicked>1&&clicked<5){//Mar 18
         		sym.$(screenArr[clicked-1]).fadeIn(0);
         		}else if(clicked==6){
         		sym.$(screenArr[4]).fadeIn(0);//liveMc
         		}else if(clicked==8){
         		sym.$(screenArr[6]).fadeIn(0);//timingMc
         		}else{
         		sym.$(screenArr[clicked]).fadeIn(0);
         		}
         		if(clicked==5){ sym.$('calendarMc').css({'width':'10%'});sym.$('circuitMc').css({'width':'90%'}); sym.$('raceButtons').css({'width':'90%'});};
         	}else{
         		sym.$('calendarMc').fadeOut(0);
         		if(clicked>1){//Mar 18
         			if(clicked<5){
         			sym.$(screenArr[clicked-1]).fadeIn(0);
         			}else{
         				if(clicked==6){
         						sym.$(screenArr[4]).fadeIn(0);//liveMc
         				}else if(clicked==8){
         					sym.$(screenArr[6]).fadeIn(0);//timingMc
         				}else{
         					sym.$(screenArr[clicked]).fadeIn(0);
         				}
         			}
         		}else{
         		sym.$('calendarMc').fadeIn(0);
         		}
         	}
         	//circuit/calendar
         	clicked==5?$(".gpname, .gpdate, .gpstat").fadeOut(0):$(".gpname, .gpdate, .gpstat").fadeIn(0);
         
         	mobGraph=(symWidth<=400)?1:0;
         	//globe centre
         	var globeWidth=sym.$("globeMc").width();
         	sym.getSymbol('globeMc').$('globe').css({'left':(globeWidth-230)/2+'px'});
         	sym.getSymbol("circuitMc").getSymbol("circuitOverlay").$("playPause").css({'left':((sym.$("circuitMc").width())-50)/2+'px'});
         	sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("speedGearsMc").$("gearsMc").css({'left':((sym.$("circuitMc").width())-132)/2+'px'});
         	//buttons centre icons
         	var menuWidth=sym.$("menuButtons").width()/3;
         	var racebtnWidth=sym.$("raceButtons").width()/3;
         	for (var i=0;i<menuArray.length;i++){
         		i<5?(sym.getSymbol("menuButtons").getSymbol("menuBtn"+i).$("icon").css({'left':(menuWidth-37)/2+'px'}),(mob==1?menuText[i].fadeOut(0):menuText[i].fadeIn(0))):sym.getSymbol("raceButtons").getSymbol("menuBtn"+i).$("icon").css({'left':(racebtnWidth-37)/2+'px'});
         	}
         	for (var j=0;j<teamArr.length;j++){
         			sym.getSymbol("menuButtons").getSymbol("teamBtns").$("teamBtn"+j).css({'left':(menuWidth-42)/2+'px'});
         	}
         };
         var wWidth = $(window).width();
         $(window).resize(function(){
           if(wWidth != $(window).width()){
             initSize();
             wWidth = $(window).width();
           }
         });
         //***************************** END RESPONSIVE ***********************************
         //***************************** DATE FUNCTIONS ***********************************
         var d=new Date();
         function getDDMMYY(thisDateStr) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var mm = thisDate.getMonth() + 1;
         	var dd = thisDate.getDate()+1;
         	mm = ((mm < 10) ? '0' : "") + mm;
         	dd = ((dd < 10) ? '0' : "") + dd;
         	return dd + "/" + mm + "/" + (thisDate.getFullYear()).toString();
         }
         function getDDmonthYY(thisDateStr) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var mm = thisDate.getMonth();
         	var dd = thisDate.getDate()+1;
         	return months[mm] + " " + dd +", "+ (thisDate.getFullYear()).toString();
         }
         
         //***************************** END DATE **************************************
         function setStyle(){
         	$(".continents").css({"-webkit-border-radius":"50%","-khtml-border-radius":"50%","-moz-border-radius":"50%","border-radius":"50%","-webkit-mask-image":"-webkit-gradient(linear, left top, right top, color-stop(0, rgba(0,0,0,1)), color-stop(1, rgba(0,0,0,1)))"});
         }
         setStyle();
         
         //***************************** LIVE DATA ****************************************
         //LIVE DATA ADDRESS
         var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://www.graphicnews.org/")+ "infostradasports/api.php";
         var latestGP, latestGPno, scrubPos=1, raceFinished;//latest GP
         var seasonInterval,conInterval,driverInterval,gpInterval,phaseInterval; //REFRESH RATE
         
         //FUNCTIONS
         //STATUS COUNTDOWN - TIME
         var counter, raceDate, diff=0, localOffset=0;
         function parsedDate(thisDateStr){
         	var matchRndDate = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var dDate = parseInt(matchRndDate,10)+localOffset;
         	return dDate;
         } 
         function countDown(){
         	var gpDate= Date.UTC(raceDate)
         	var todayDate = new Date();
         	diff = raceDate-todayDate;
         	var days = Math.floor(diff/86400000);
         	var hours = Math.floor((diff%86400000)/3600000);
         	var mins = Math.floor((diff%86400000)%3600000/60000);
         	var secs = Math.floor((diff%86400000)%3600000%60000/1000);
         	var dd = leadingZero(days).toString();
         	var hh = leadingZero(hours).toString();
         	var mm = leadingZero(mins).toString();
         	var ss = leadingZero(secs).toString();
         	if(todayDate<raceDate){
         		var gpdiff = raceDate-todayDate;
         		var gpdays = Math.floor(gpdiff/86400000);
         		if (gpdays>1){
         			sym.getSymbol("globeMc").$("mapTxt1").html(coundownCap[0]+" "+days+" "+coundownCap[1]+" "+hh+coundownCap[2]+":"+mm+coundownCap[3]+":"+ss+coundownCap[4]);
         		}else{
         			sym.getSymbol("globeMc").$("mapTxt1").html("");
         		}
         	}
         }
         function leadingZero(time) {
             return (time < 10) ? "0" + time : time;
         }
         //END COUNTDOWN
         
         var y=latitude[latestGPno];
         var x=longitude[latestGPno];
         function spinGlobe(gpno){
         	var x=Math.round(-591-(parseInt(longitude[gpno],10)*500/360));//500px distance from gmt to gmt
         	var xBack=Math.round(-420+(parseInt(longitude[gpno],10)*500/360));
         	var y=Math.round(115-(Math.sin((latitude[gpno])*Math.PI*0.75/180)*115)+3);//Map height to equator-sin(convert degrees to radians*height to equator)
         	sym.getSymbol("globeMc").getSymbol("globe").getSymbol("continents").$("mapFront").stop().animate({left:x},700,'easeOutCubic');
         	sym.getSymbol("globeMc").getSymbol("globe").getSymbol("continents").$("mapBack").stop().animate({left:xBack},700,'easeOutCubic');
         	sym.getSymbol("globeMc").getSymbol("globe").$("dot0").stop().animate({'top':y},700,'easeOutElastic');
         	sym.getSymbol("calendarMc").$("graph").stop().animate({scrollTop:45*gpno},200);
         	}
         function raceDetails(gp,gpNo){//get circuit
         	getRace(gp);
         	latestGP=gp;
         	for (var i=0; i<raceText.length; i++){ //add labels for race circuit
         		raceText[i].html(raceArr[gpNo][i]);
         	}
         	sym.getSymbol("circuitMc").getSymbol((countryArr[gpNo].toUpperCase())+"Mc").$("gpTxt").html(raceArr[gpNo][1].toUpperCase());
         	for (var r=0; r<raceCorners[gpNo].length;r++){
         		sym.getSymbol("circuitMc").getSymbol((countryArr[gpNo].toUpperCase())+"Mc").$("corner"+r).html(raceCorners[gpNo][r]);
         		sym.getSymbol("circuitMc").getSymbol((countryArr[gpNo].toUpperCase())+"Mc").$("corner"+r).css({'font-size':'14px','line-height':'15px'});
         		sym.getSymbol("circuitMc").getSymbol((countryArr[gpNo].toUpperCase())+"Mc").$("pit").html(raceCorners[gpNo][raceCorners[gpNo].length-1]);
         		sym.getSymbol("circuitMc").getSymbol((countryArr[gpNo].toUpperCase())+"Mc").$("pit").css({'font-size':'14px'});
         	}
         	stopIt();
         	scrubPos=1;//reset scrub position
         	$(".circuits").fadeOut(0); //all circuits
         	$(".minicircuits").fadeOut(0); //all mini circuits
         	for (var n=0;n<countryArr.length; n++){
         		sym.getSymbol("circuitMc").getSymbol((countryArr[n].toUpperCase())+"Mc").getSymbol("carMc").stop();						
         	}
         	sym.getSymbol("circuitMc").$((countryArr[gpNo].toUpperCase())+"Mc").fadeIn(0);
         	sym.getSymbol("circuitMc").getSymbol("circuitOverlay").$((countryArr[gpNo].toUpperCase())+"mini").fadeIn(0);
         }
         var showGP = function(gp,status,gpNo){ //get race
         	return function (e) {
         		resetmenu();
         		$(".screens").fadeOut(0);
         		sym.$("raceButtons").animate({'bottom':'15px'},400);
         		latestGPno=gpNo;
         		raceDetails(gp,gpNo);			
         		sym.getSymbol("resultMc").$("gpTxt").html(raceArr[gpNo][0]);
         		sym.getSymbol("raceButtons").$("menuBtn7").off('click');//unbind results button
         		sym.getSymbol("raceButtons").$('menuBtn5').off('click',playLatest);//unbind circuit button
         		sym.getSymbol("circuitMc").$("weather").attr('src','images/weather0.png');						
         		sym.getSymbol("circuitMc").$("weatherTxt").fadeOut(0);
         		for (var n=0;n<8; n++){
         			sym.getSymbol("raceButtons").getSymbol("phaseBtn"+n).$("btnBg").css({'background-color':'rgb(93,93,93)','border':'solid 1px rgb(255,255,255)'});
         			sym.getSymbol("raceButtons").$("phaseBtn"+n).off('click');
         		}
         		sym.getSymbol("circuitMc").$("statusTxt").html(statCap[4]);
         		sym.getSymbol("circuitMc").$("statusTxt").css({"background-color":"rgb(100,100,100)"});
         		sym.getSymbol("liveMc").$("statusTxt").html(statCap[4]);
         		sym.getSymbol("timingMc").$("loading").fadeIn(0);
         		sym.getSymbol("liveMc").$("loading").fadeIn(0);
         		sym.getSymbol("resultMc").$("loading").fadeIn(0);
         		sym.getSymbol("timingMc").$("graph").empty();
         		sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("gridtxt0").empty();
         		sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("gridtxt1").empty();
         		for (var i = 0; i < (teamArr.length*2); i++) {
         			sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("grid"+i).stop().animate({'top':781}, 0);								
         			sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("grid"+i).empty();
         		}
         		sym.getSymbol("timingMc").$("gridSlider").fadeOut(0);
         		sym.getSymbol("timingMc").$("graph").fadeOut(0);
         		sym.getSymbol("timingMc").$("timeTxt").fadeOut(0);
         		clearInterval(seasonInterval);
         	inPlay=false;
         		if (status==0){//Pre-race
         			sym.getSymbol("circuitMc").$("statusTxt").html(statCap[4]);
         			sym.getSymbol("circuitMc").$("statusTxt").css({"background-color":"rgb(100,100,100)"});
         			sym.getSymbol("liveMc").$("statusTxt").html(statCap[4]);
         			menuArray[5].$("menuBg").fadeOut(0);
         			sym.$(screenArr[5]).fadeIn(0);
         			playIt(gpNo);
         			clicked=5;
         		}else if(status==2){//Live
         			menuArray[6].$("menuBg").fadeOut(0);
         			sym.$(screenArr[4]).fadeIn(0);
         			clicked=6;
         		}else if(status==4){//Finished
         			menuArray[7].$("menuBg").fadeOut(0);
         			sym.$(screenArr[7]).fadeIn(0);
         			clicked=7;
         		}
         		sym.getSymbol('calendarMc').$('graph').stop().animate({scrollTop:gpNo*45+'px'},400);
         		$(".gpweekend").css({'background-color':'rgba(230,225,215,0)'});
         		$("#gp"+gpNo).css({'background-color':'rgba(255,225,215,0.6)'});
         		initSize();
         		e.preventDefault();
         		e.stopPropagation();
         	};
         };
         // PLAY/PAUSE BTN
         var inPlay;
         sym.getSymbol("circuitMc").getSymbol("circuitOverlay").$("playPause").on('click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("playPause").$("play").is(":visible") ) {
         		playIt(latestGPno);
         	} else{
         		stopIt();
         	}
         });
         function playIt(number){ //play circuit animation
         	if (inPlay==false){
         		startTimer();
         		$(".gpname, .gpdate, .gpstat").fadeOut(0);
         		if(stageWidth>=640){
         		sym.$("calendarMc").stop().animate({width:"10%"},200);
         		sym.$("circuitMc").stop().animate({width:"90%"},200);
         		sym.$("raceButtons").animate({width:"90%"},200);
         		}else{
         		sym.$("calendarMc").stop().animate({width:"10%"},0);
         		sym.$("circuitMc").stop().animate({width:"100%"},0);
         		sym.$("raceButtons").animate({width:"100%"},0);
         		}
         		sym.getSymbol("circuitMc").getSymbol((countryArr[number].toUpperCase())+"Mc").getSymbol("carMc").play();	
         		sym.getSymbol("circuitMc").getSymbol((countryArr[number].toUpperCase())+"Mc").play(scrubPos);
         		sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol((countryArr[number].toUpperCase())+"mini").play(scrubPos);
         		sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("playPause").$("play").fadeOut(0);
         		sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("playPause").$("pause").fadeIn(0);
         		sym.getSymbol("circuitMc").$((countryArr[latestGPno].toUpperCase())+"Mc").css({'overflow-x':'hidden'});
         		inPlay=true;
         	}
         }
         function stopIt() {
         	stopTimer();
         	for(var r=0;r<countryArr.length;r++){
         		sym.getSymbol("circuitMc").getSymbol((countryArr[r].toUpperCase())+"Mc").stop();
         		sym.getSymbol("circuitMc").getSymbol('circuitOverlay').getSymbol((countryArr[r].toUpperCase())+"mini").stop();
         	}
         	sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("playPause").$("play").fadeIn(0);
         	sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("playPause").$("pause").fadeOut(0);
         	sym.getSymbol("circuitMc").$((countryArr[latestGPno].toUpperCase())+"Mc").css({'overflow-x':'auto'});
         	scrubPos=sym.getSymbol("circuitMc").getSymbol((countryArr[latestGPno].toUpperCase())+"Mc").getPosition();
         	scrubPos=(scrubPos>1&&scrubPos<15000)?scrubPos:1;
         	inPlay=false;
         }
         
         var playLatest = function(gp,gpNo){
         	return function (e) {
         		raceDetails(gp,gpNo);
         		playIt(gpNo);
         		e.preventDefault();
         		e.stopPropagation();
         	};
         };
         var playTimer=0;
         function startTimer() {
         	playTimer = setInterval(startReplay, 150);
         }
         function startReplay() {
         	var symWidth=sym.$("circuitMc").width();
         	var pos = sym.getSymbol("circuitMc").getSymbol((countryArr[latestGPno].toUpperCase())+"Mc").getPosition();
         	var x = sym.getSymbol("circuitMc").getSymbol((countryArr[latestGPno].toUpperCase())+"Mc").$("carMc").position();
         	sym.getSymbol("circuitMc").$((countryArr[latestGPno].toUpperCase())+"Mc").stop().animate({scrollLeft: x.left+20}, 500);
         	if (pos == 0 || pos == 15000) {
         		stopIt();
         		sym.getSymbol("circuitMc").$((countryArr[latestGPno].toUpperCase())+"Mc").css({'overflow-x':'auto'});
         	}else{
         
         	}
         }
         function stopTimer() {
         	clearInterval(playTimer);
         }
         
         var showPhase = function(phaseNo,stage,session){//show phase timing graph
         	return function(e){
         		resetmenu();
         		$(".screens").fadeOut(0);
         			$(".gpname, gpdate, .gpstat").fadeIn(0);//Mar 18
         			sym.$("calendarMc").stop().animate({width:"40%"},0);
         			sym.$("circuitMc").stop().animate({width:"60%"},0);
         			sym.$("raceButtons").stop().animate({width:"60%"},0);
         		sym.getSymbol("timingMc").$("statusTxt"). fadeIn(0);
         		if (stage<6){
         			if(stage<3){
         				var stageCap=statCap[0];
         			}else{
         			var stageCap=statCap[1];
         			}
         			getPhases(phaseNo);
         			sym.$("timingMc").fadeIn(0);
         			sym.getSymbol("timingMc").$("gridSlider"). fadeOut(0);
         			sym.getSymbol("timingMc").$("graph"). fadeIn(0);
         			sym.getSymbol("timingMc").$("timeTxt"). fadeIn(0);
         			sym.getSymbol("timingMc").$("statusTxt").html(stageCap+" "+session);
         			sym.getSymbol("timingMc").$("statusTxt"). fadeIn(0);
         			var statWidth=sym.getSymbol("timingMc").$("statusTxt").width();
         			sym.getSymbol("timingMc").$("statusTxt").css({'background-color':'rgb(225,5,20)'});
         			selectPhase=6;
         			clicked=8;
         		}else if(stage==6){
         			getGrid(phaseNo);
         			sym.$("timingMc").fadeIn(0);
         			sym.getSymbol("timingMc").$("gridSlider"). fadeIn(0);
         			sym.getSymbol("timingMc").$("graph"). fadeOut(0);
         			sym.getSymbol("timingMc").$("timeTxt"). fadeOut(0);
         			sym.getSymbol("timingMc").$("statusTxt"). fadeIn(0);//Mar 19
         			sym.getSymbol("timingMc").$("statusTxt").html(raceArr[latestGPno][0]+" "+statCap[2]);
         			sym.getSymbol("timingMc").$("statusTxt").css({'background-color':'rgb(225,5,20)'});
         			selectPhase=6;
         			clicked=8;
         		}else{
         			getLive(phaseNo);
         			sym.$(screenArr[6]).fadeOut(0);//timing
         			sym.$(screenArr[4]).fadeIn(0);//live
         			selectPhase=4;
         			clicked=6;
         		}
         		menuArray[6].$("menuBg").fadeOut(0);
         		sym.getSymbol("raceButtons").$("menuBtn5xtra").stop().animate({'top':'0px'},400);
         		for (var i=0; i<8;i++){
         			if(i==stage){
         				sym.getSymbol('raceButtons').getSymbol('phaseBtn'+i).$('btnBg').css({'background-color':'rgb(0,0,0)'});
         			}else{
         				sym.getSymbol('raceButtons').getSymbol('phaseBtn'+i).$('btnBg').css({'background-color':'rgb(93,93,93)'});
         			}
         		}
         		initSize();
         		e.preventDefault();
         		e.stopPropagation();
         	}
         };
         function showFinished(){//Elements if race finished
         	raceFinished=1;
         }
         function sessLiveOrFin(latest,number,status){//Elements to show if live or finished
         	var stat=(number>0)?number+" "+status:status;
         	sym.getSymbol("circuitMc").$("statusTxt").html(latest+" "+stat);
         	sym.getSymbol("liveMc").$("statusTxt").html(latest+" "+stat);
         }
         
         //END FUNCTIONS
         function getSeason(){//get live season data
         	$.ajax({ type:"GET",
         		url:dataURL,
         		data:  "gn="+gn+"&q=season&yr="+gnYear+"&race=",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			sym.getSymbol("calendarMc").$('loading').fadeOut(0);
         			sym.getSymbol("calendarMc").$("graph").empty();
         			var seasondata=data;
         			var raceFinished, raceLive, gpflag, flagHTML, gpstatusHTML,latestStatus;
         			for (var i = 0; i < seasondata.length; i++) {
         				var gpID = seasondata[i].n_EventPhaseID;
         				var gpStatus=seasondata[i].n_StatusCode;
         				var countryShort = seasondata[i].c_CountryShort;
         				var orderNo;
         					if(i==0){
         						orderNo=i;
         					}
         					if(gpStatus>512){//Cancelled
         						orderNo=i;
         					}else{
         						orderNo++;
         					if(seasondata[i].b_Current==true){
         						if(gpStatus>=128){//race finished
         							racestatus = 4;
         							sym.getSymbol("globeMc").$("mapTxt1").html("");//Replace countdown March 21
         						}else if(gpStatus>=8&&gpStatus<192){//live
         							racestatus = 2;
         						}else{//not started
         							racestatus = 0;
         						}
         						raceDate=parsedDate(seasondata[i].d_DateEnd);//get date of current race
         						latestGP=gpID; //assign latest race to menu buttons
         						latestGPno=i;
         						latestStatus=racestatus;
         						sym.getSymbol("raceButtons").$('menuBtn5').off('click',playLatest);
         						sym.getSymbol("raceButtons").$('menuBtn5').on('click',playLatest(gpID,i));
         					}else if(seasondata[i].b_Finished==true){
         						racestatus = 4;
         					}else{
         						racestatus = 0;
         					}
         					var seasonText="<div class='gpseason'>";//create season graph
         					seasonText +="<table class='gpweekend' id='gp"+i+"'><tr>";
         					seasonText +="<td class='gpflag' id='gpflag"+i+"'></td>";
         					seasonText +="<td class='gpname' id='gpname"+i+"'></td>";
         					seasonText +="<td class='gpdate' id='gpdate"+i+"'></td>";
         					seasonText +="<td class='gpstat' id='gpstatus"+i+"'></td>";
         					seasonText +="</tr></table>";
         					seasonText +="</div>";	
         					sym.getSymbol("calendarMc").$("graph").append(seasonText);
         					gpflag =  countryArr[i];
         					flagHTML = "<img src='images/" +gpflag+ "Flag.png' height='35px' width='30px'>"
         					gpstatusHTML = "<img src='images/flag" +racestatus+ ".png' height='26px' width='26px'>";
         					var gpdate=getDDmonthYY(seasondata[i].d_DateEnd);
         					$('#gp' + i).css({'cursor':'pointer'});
         					$('#gp' + i).on('click',showGP(gpID,racestatus,i));
         					$('#gpflag' + i).html(flagHTML);
         					$('#gpname' + i).text(raceArr[i][0]);
         					$('#gpdate' + i).html(gpDate[i]);
         					$('#gpstatus' + i).html(gpstatusHTML);
         					$('.gpseason').css({'width':'100%','height':'42px','border-top':'solid 1px rgb(255,255,255)','border-bottom':'solid 1px rgb(150,150,150)','font-family':'pragmatica-web, sans-serif','font-size':'14px'});
         					$('.gpweekend').css({'width':'100%'});
         					$('.gpflag').css({'width':'10%','text-align':'center'});
         					$('.gpname').css({'width':'42%','font-weight':700,'font-size':'14px'});
         					$('.gpdate').css({'width':'38%', 'font-style':'oblique','text-align':'left'});
         					$('.gpstat').css({'width':'10%','padding':'3px'});
         				}
         			}
         			$("#gp"+latestGPno).css({'background-color':'rgba(255,225,215,0.6)'});
         			if (loaded==0){
         				spinGlobe(latestGPno);
         				var latestStatCap=(latestStatus==4)?liveCap[2]:(latestStatus==2)?liveCap[1]:caps[13];
         				latestStatCap=latestStatCap.toUpperCase();
         				sym.getSymbol("globeMc").$("mapTxt0").html(latestStatCap+": "+raceArr[latestGPno][0]);
         			}
         			loaded++;
         		}
         	});
         }
         getSeason();
         seasonInterval = setInterval(getSeason,900000);
         
         function getStartList(){//get startlist data if race hasn't started
         	$.ajax({ type: "GET", 
         		url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&q=startlist&race=",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			var startData=data;
         			if (startData.length>20){
         				barHeight = ((590/startData.length)-4);
         			}else{
         				barHeight = 24;
         			}
         			for (var i=0; i<startData.length; i++){
         				if(i==0){ //show lead driver details
         					var drivershort = startData[i].c_PersonShort;
         					var driverID = startData[i].n_PersonID;
         					var imgCar = startData[i].c_TeamShort;
         					var leadDriver = '<b>' +startData[i].c_Person+ '</b> ' +startData[i].c_NOCShort+ '</span>';
         					sym.getSymbol("driverchampMc").$("driversTxt").html(leadDriver);
         					sym.getSymbol("driverchampMc").$("driverPic").attr("src","drivers/"+driverID+".jpg");
         				}	
         				var tableText ="<div class='driverschamp'>";
         				tableText += "<div id='driverdata"+i+"'>";
         				tableText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         				tableText += "<td id='driverrnk"+i+"' width='25px' style='font-weight:bold'></td>";
         				tableText += "<td id='driverNm"+i+"'width='100px'></td>";
         				tableText += "<td id='driverteam"+i+"' style='font-style:italic'></td>";
         				tableText += "<td id='driverpts"+i+"' style='font-weight:bold'></td>";
         				tableText += "</tr></table>";
         				tableText += "</div></div>";
         				sym.getSymbol("driverchampMc").$("graph").append(tableText);
         				$('#driverrnk' + i).text(i+1);		
         				$('#driverNm' + i).text(startData[i].c_PersonShort);
         				$('#driverteam' + i).text(startData[i].c_TeamShort);
         				if (i==0){
         					$('#driverpts' + i).text("0"+caps[12]);
         				}else{
         					$('#driverpts' + i).text("0");
         				}
         				$(".driverschamp").css({'font-size':'14px', 'font-family':'pragmatica-web, sans-serif', 'width':'100%', 'margin-bottom':'4px'});
         				$("#driverdata" + i).css({'height':barHeight+'px','width':'60%', 'background-color':'rgba(230,225,215,0.8)', 'padding-left':'3px', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         				$("#driverpts" + i).css({'text-align':'right', 'padding-right':'3px'});
         				$("#driverdata" + i).animate({width:scale+'%'},1500);
         				sym.getSymbol("driverchampMc").$("graph").css({'margin-top':'3px'});
         			}
         		}
         	});
         }
         
         var barHeight, nRaceDrivers, maxPoints, scale;
         function getDriverStandings(){//get drivers championship data
         	$.ajax({ type:"GET",
         		url:dataURL,
         		data:  "gn="+gn+"&q=champdrivers&yr="+gnYear+"&race=",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			var rankData = data;
         			sym.getSymbol("driverChampMc").$("loading").hide();
         			sym.getSymbol("driverChampMc").$("graph").empty();
         			if (rankData.length<1){
         				getStartList();
         			}else{
         			//Ensure all drivers will fit in graph
         				nRaceDrivers = rankData.length;
         				if (rankData.length>20){
         					barHeight = ((510/rankData.length)-4);
         				}else{
         					barHeight = 20;
         				}
         				//calculate relative length of each bar
         				maxPoints = rankData[0].n_PointsSort;
         				var min = (maxPoints!=null) ? maxPoints : 0;
         				for (var n=0; n<rankData.length; n++) {
         					if (rankData[n].n_PointsSort!=null && rankData[n].n_PointsSort<min) {
         						min = rankData[n].n_PointsSort;									
         					}
         				}					
         				for (var i = 0; i < rankData.length; i++) {
         					if(i==0){ //show lead driver details
         						var drivershort = rankData[i].c_PersonShort;
         						var driverID = rankData[i].n_PersonID;
         						var imgCar = rankData[i].c_TeamShort;
         						var leadDriver = '<b>' +rankData[i].c_Person+ '</b> ' +rankData[i].c_NOCShort+ '</span>';
         						sym.getSymbol("driverChampMc").$("driversTxt").html(leadDriver);
         						sym.getSymbol("driverChampMc").$("driverPic").attr("src","drivers/"+driverID+".jpg");
         					}
         					var tableText ="<div class='driverschamp'>";//build drivers standings table
         					tableText += "<div id='driverdata"+i+"' class='driverbar'>";
         					tableText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         					tableText += "<td id='driverrnk"+i+"' width='20px' style='font-weight:bold'></td>";
         					tableText += "<td id='driverNm"+i+"'width="+(mobGraph==1?'90px':'100px')+"></td>";
         					tableText += "<td id='driverteam"+i+"' style='font-style:italic'></td>";
         					tableText += "<td id='driverpts"+i+"' style='font-weight:bold'></td>";
         					tableText += "</tr></table>";
         					tableText += "</div></div>";
         					sym.getSymbol("driverChampMc").$("graph").append(tableText);
         					var teamLogo='<img src="images/'+ rankData[i].c_TeamShort +'.png" width="16px">';
         					if (rankData[i].n_Rank!=null){
         						$('#driverrnk' + i).text(rankData[i].n_Rank);
         					}else{
         						$('#driverrnk' + i).text(i+1);
         					}		
         					$('#driverNm' + i).text((rankData[i].c_PersonShort).toUpperCase());
         					$('#driverteam' + i).html(teamLogo);
         					if (rankData[i].c_Points!=null){
         						if (i==0&&caps[12]!=undefined){
         							$('#driverpts' + i).text(rankData[i].c_Points+caps[12]);
         						}else{
         							$('#driverpts' + i).text(rankData[i].c_Points);
         						}	
         					}else{
         						$('#driverpts' + i).text("0");
         					}					                                        
         					if (maxPoints==min && rankData[i].n_PointsSort==maxPoints) {
         						scale=100;//max length
         					}else if(rankData[i].n_PointsSort==null){
         						scale=54; //min length
         					}else{
         						scale = 100-((maxPoints-rankData[i].n_PointsSort)*45/(maxPoints-min));
         					}
         					$(".driverschamp").css({'font-size':'13px', 'font-family':'pragmatica-web, sans-serif', 'width':'98%', 'margin-bottom':'4px'});
         					$(".driverbar").css({'width':'54%', 'background-color':'rgba(230,225,215,0.8)', 'padding-left':'3px', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         					$("#driverdata" + i).css({'height':barHeight+'px'});
         					$("#driverpts" + i).css({'text-align':'right', 'padding-right':'3px'});
         					$("#driverdata" + i).animate({width:scale+'%'},1500);
         					sym.getSymbol("driverChampMc").$("graph").css({'margin-top':'3px'});
         				}
         			}
         		}
         	});
         }
         getDriverStandings();
         var nTeams, teamBar;
         function getConsStandings(){//get constructors championship live data
         	$.ajax({ type:"GET",
         		url:dataURL,
         		data:  "gn="+gn+"&q=champteams&yr="+gnYear+"&race=",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			var teamData = data;
         			sym.getSymbol("menuButtons").$("menuBtn3").unbind('click',menuBtnClick);//disable button
         			if (teamData.length<1){//if championship hasn't started
         				sym.getSymbol("menuButtons").$("menuBtn3").bind ("click", {menuId:4}, menuBtnClick);//reassign button
         			}else{
         				sym.getSymbol("menuButtons").$("menuBtn3").bind ("click", {menuId:3}, menuBtnClick);
         				sym.getSymbol("teamChampMc").$("loading").css({'display':'none'});
         				sym.getSymbol("teamChampMc").$("graph").empty();
         				//Ensure all teams will fit in graph
         				nTeams = teamData.length;
         				if (teamData.length>=11){
         					teamBar = ((297/teamData.length)-4);
         				}else{
         					teamBar = 25;
         				}
         				//calculate relative length of each bar
         				teamPoints = teamData[0].n_PointsSort;
         				var minpts = (teamPoints!=null) ? teamPoints : 0;
         				for (var n=0; n<teamData.length; n++) {
         					if (teamData[n].n_PointsSort!=null && teamData[n].n_PointsSort<minpts) {
         						minpts = teamData[n].n_PointsSort;									
         					}
         				}	
         				for (var i = 0; i < teamData.length; i++) {
         					teamname=teamData[i].c_TeamShort;
         					longname=teamData[i].c_Team;
         					if(i==0){ //show lead team details
         						var imgCar = teamData[i].c_TeamShort;
         						sym.getSymbol("teamChampMc").getSymbol("carPic").$("mainCar").attr("src","cars/"+imgCar+"big.png");
         						sym.getSymbol("teamChampMc").getSymbol("carPic").$("reflection").attr("src","cars/"+imgCar+"big.png");
         						sym.getSymbol("teamChampMc").getSymbol("carPic").$("driverHead").attr("src","drivers/"+imgCar+".png");
         						sym.getSymbol("teamChampMc").getSymbol("carPic").$("bkwheel").attr("src","cars/"+imgCar+"bk.png");
         						sym.getSymbol("teamChampMc").getSymbol("carPic").$("frwheel").attr("src","cars/"+imgCar+"fr.png");
         						getStats(teamname,2);
         					}
         					var constructorsText ="<div class='teamchamp'>";//build championship table
         					constructorsText += "<div id='teamdata"+i+"' class='teambar'>";
         					constructorsText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         					constructorsText += "<td id='teamrnk"+i+"' width='20px' style='font-weight:bold'></td>";
         					constructorsText += "<td id='teamLogo"+i+"' width="+(mobGraph==1?'1px':'20px')+"></td>";
         					constructorsText += "<td id='teamNm"+i+"'></td>";
         					constructorsText += "<td id='teampts"+i+"' style='font-weight:bold'></td>";
         					constructorsText += "</tr></table>";
         					constructorsText += "</div></div>";
         					sym.getSymbol("teamChampMc").$("graph").append(constructorsText);
         					var teamLogo=(mobGraph==1)?'':'<img src="images/'+ teamData[i].c_TeamShort +'.png" width="16px">';
         					if (teamData[i].n_Rank!=null){
         						$('#teamrnk' + i).text(teamData[i].n_Rank);
         					}else{
         						$('#teamrnk' + i).text(i+1);
         					}
         					$('#teamLogo' + i).html(teamLogo);
         					if (teamData[i].c_Team=="RedBull - Renault"){
         						$('#teamNm' + i).text("Red Bull - Renault");
         					}else{
         						$('#teamNm' + i).text((teamData[i].c_Team).toUpperCase());
         					}
         					if(teamData[i].c_Points!=null){
         						if (i==0){
         							$('#teampts' + i).text(teamData[i].c_Points+caps[12]);
         						}else{
         							$('#teampts' + i).text(teamData[i].c_Points);
         						}
         					}else{
         						$('#teampts' + i).text("0");
         					}					                                        
         					if (teamPoints==minpts && teamData[i].n_PointsSort==teamPoints) {
         						scale=100;//max length of bar
         					}else if(teamData[i].n_PointsSort==null){
         						scale=(mobGraph==1)?70:56;//minimum
         					}else{
         						scale = 100-((teamPoints-teamData[i].n_PointsSort)*(mobGraph==1?30:44)/(teamPoints-minpts));
         					}
         					$(".teamchamp").css({'font-size':'13px', 'font-family':'pragmatica-web, sans-serif', 'width':'98%','margin-bottom':'4px'});
         					$(".teambar").css({'background-color':'rgba(230,225,215,0.8)', 'padding-left':'3px', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         					$("#teamdata" + i).css({'height':teamBar+'px','width':scale+'%'});
         					$("#teamdata" + i + " table").css({'height':teamBar+'px'});
         					$("#teampts" + i).css({'text-align':'right', 'padding-right':'3px'});
         					sym.getSymbol("teamChampMc").$("graph").css({'margin-top':'3px'});
         				}
         			}
         		}
         	});
         }
         getConsStandings();
         var flag1txt, flag2txt;
         function getStats(teamdetails,view){//show team facts from xml arrays
         	sym.getSymbol(screenArr[view]).$("teamTxt0").css({'font-weight':700});	//team name	
         	var headprefix=(view==2)?champHead[1]+": ":"";
         	for (var i=0;i<teamArr.length;i++){
         		if (teamdetails==teamArr[i]){
         			sym.getSymbol(screenArr[view]).$("teamTxt0").html((view==2)?champHead[1]:teamTxtArr[i][0]);//if view=3 Constructors else team name
         			sym.getSymbol(screenArr[view]).$("teamTxt1").html(teamTxtArr[i][1]);
         			//create array of each team in xml, 
         			for (var n=0;n<2;n++){
         					var number=driverTxtArr[i][n].find('d0').text();var name =driverTxtArr[i][n].find('d1').text();
         					var stats=driverTxtArr[i][n].find('d2').text();var nat=driverTxtArr[i][n].find('d3').text();
         					var id = driverTxtArr[i][n].find('driverid').text().toString();
         					sym.getSymbol(screenArr[view]).getSymbol("teamDriverMc"+n).$("driverTxt0").html(number);
         					sym.getSymbol(screenArr[view]).getSymbol("teamDriverMc"+n).$("driverTxt1").html(name);
         					sym.getSymbol(screenArr[view]).getSymbol("teamDriverMc"+n).$("driverTxt2").html(nat);
         					sym.getSymbol(screenArr[view]).getSymbol("teamDriverMc"+n).$("driverTxt3").html(stats);
         					sym.getSymbol(screenArr[view]).getSymbol("teamDriverMc"+n).$("driverflag").attr("src","images/"+nat+".gif");
         					sym.getSymbol(screenArr[view]).getSymbol("teamDriverMc"+n).$("driverpic").attr("src","drivers/"+id+".jpg");
         					sym.getSymbol(screenArr[view]).getSymbol("teamDriverMc"+n).$("driverHelmet").attr("src","drivers/"+id+".png");
         			}
         		}
         	}
         }
         var raceStage;
         function getRace(raceID){ //GET race weekend live data
         	$.ajax({ type: "GET", 
         		url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&q=race&race="+raceID,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {                	
         			var racePhases = data;
         			var n;//session number
         			var latestPhase;var getFunction;var phaseBtnNo;
         			for (var i = 0; i < racePhases.length; i++) {
         				sym.getSymbol("raceButtons").$("phaseBtn"+i).off("click");
         				phase=racePhases[i].n_PhaseID;
         				var sessionNo=(racePhases[i].n_SessionNr>0)?racePhases[i].n_SessionNr:"";
         				var sessLive=(racePhases[i].b_Current==true)?1:0;
         				var sessStarted=(racePhases[i].b_Started==true)?1:0;
         				var sessFin=(racePhases[i].b_Finished==true)?1:0;
         				var nullSession=0;
         				if (racePhases[i].b_FreePractice==true){//free practice
         					n = racePhases[i].n_Phase1Nr;						
         					phaseBtnNo=sessionNo-1;
         					raceStage = "FP";
         					if(racePhases[i].b_Started==true){
         						latestPhase = statCap[0];
         					}else{
         						if(n==1){
         							sessLive=0;
         						}
         						latestPhase = statCap[4];
         						sessionNo="";
         					}
         				}else if (racePhases[i].b_Qualifying==true&&racePhases[i].n_Phase2Nr==null){//show nothing if null
         					sessLive=0;
         					sessFin=0;
         					sessStarted=0;	
         					nullSession=1;													
         				}else if (racePhases[i].b_Qualifying==true&&racePhases[i].n_Phase2Nr>0){//qualifying						
         					n = racePhases[i].n_Phase2Nr;
         					phaseBtnNo=sessionNo+2;						
         					raceStage = "Q";
         					latestPhase = statCap[1];
         				}else if (racePhases[i].b_StartingGrid==true){//grid	
         					n="0";
         					phaseBtnNo="6";
         					raceStage ="Q";
         					latestPhase = statCap[2];						
         				}else if (racePhases[i].b_Race==true){//race
         					n="1";
         					phaseBtnNo="7";
         					raceStage ="R";
         					latestPhase = statCap[3];						
         				}
         				clearInterval(gpInterval);
         				var lC=0;
         				if (nullSession<1){//if its a real session
         					if(sessLive==1){											
         						if(sessStarted==1){
         							getInfo(phase);
         							getLive(phase);
         							if(sessFin==1){	
         								sym.getSymbol("raceButtons").getSymbol("phaseBtn"+phaseBtnNo).$("btnBg").css({"border":"solid 2px rgb(255,45,0)"}); 
                  					if(racePhases[i].b_Race==true){
                  						showFinished();
                  						sym.getSymbol("raceButtons").$("menuBtn7").on ("click", {menuId:7}, menuBtnClick);
         								}else{
                  						sym.getSymbol("circuitMc").$("statusTxt").css({"background-color":"rgb(225,5,20)"});
                  					}
         								lC=2;
                  				}else{
                  					sym.getSymbol("raceButtons").getSymbol("phaseBtn"+phaseBtnNo).$("btnBg").css({"border":"solid 2px rgb(85,192,40)"});
                  					sym.getSymbol("circuitMc").$("statusTxt").css({"background-color":"rgb(85,192,40)"});
                  					lC=1;
                  				}
                  			}else{
                  				sym.getSymbol("circuitMc").$("statusTxt").css({"background-color":"rgb(100,100,100)"});
                  				sym.getSymbol("raceButtons").getSymbol("phaseBtn"+phaseBtnNo).$("btnBg").css({"border":"solid 1px rgb(100,100,100)"});
                  				//sym.getSymbol("menuButtons").$("menuBtn5").off('click');
         							lC=0;
                  			}
                  			sym.getSymbol("raceButtons").$("phaseBtn"+phaseBtnNo).on('click',showPhase(phase,phaseBtnNo,sessionNo));
                  			sessLiveOrFin(latestPhase,sessionNo,liveCap[lC]);
                  		}else if(sessFin==1){	
                  			sym.getSymbol("raceButtons").getSymbol("phaseBtn"+phaseBtnNo).$("btnBg").css({"border":"solid 2px rgb(255,45,0)"});
                  			sym.getSymbol("circuitMc").$("statusTxt").css({"background-color":"rgb(225,5,20)"});
                  			if (racePhases[i].b_Race==true){
                  				showFinished();
                  				getInfo(phase);
                  				getLive(phase);
                  			}
         						lC=2;
         						//sessLiveOrFin(latestPhase,sessionNo,liveCap[lC]);
                  			sym.getSymbol("raceButtons").$("phaseBtn"+phaseBtnNo).on('click',showPhase(phase,phaseBtnNo,sessionNo));
                  		}
                  		else{
         						lC=0;
         					}         											
         					sym.getSymbol("raceButtons").$("phaseBtn"+phaseBtnNo).css({"cursor":"pointer"});
         				}
                  }//end for
         			phaseNo=phaseBtnNo;
         		}
         	});
         }
         function getInfo(phaseID){//GET individual phase info for laps/live race conditions
         	$.ajax({ type: "GET", 
         		url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&q=info&race="+phaseID,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			var latestPhase;
         			sym.getSymbol("liveMc").$("lapCounter").fadeOut(0);	//hide lapCounter
         			capsText[6].fadeOut(0);//
         			if (data[0].n_WeatherConditionType!=null){
         				sym.getSymbol("circuitMc").$("weatherTxt").show();
         				sym.getSymbol("circuitMc").$("weather").attr('src','images/weather'+ data[0].n_WeatherConditionType +'.png'); // Add weather symbol						
         			}
         			var sessionNo=(data[0].n_SessionNr>0)?data[0].n_SessionNr:"";
         			if (data[0].b_FreePractice==true){
         				pitstoptxt="";	
         			}else if(data[0].b_Qualifying==true){
         				pitstoptxt="";				
         			}else if(data[0].b_StartingGrid==true){
         				pitstoptxt="";					
         			}else if(data[0].b_Race==true){//only show laps, etc if race
         				capsText[7].html(caps[11]);//
         				//Angle per lap
         				var laps = data[0].n_LapsScheduled;
         				var lapsDriven = data[0].n_LapsDriven;
         				var lapsAngle = 360*lapsDriven/laps;						
         				capsText[6].html(caps[6] +":<br><b>"+ lapsDriven+"/"+laps); //lap text
         				capsText[6].fadeIn(400);//show lapTxt
         				sym.getSymbol("liveMc").$("pitstop").fadeIn(0);
         				sym.getSymbol("liveMc").$("lapCounter").fadeIn(400);																						
         				if (lapsDriven/laps<0.5){
         					sym.getSymbol("liveMc").getSymbol("lapCounter").$("laps2").hide();
         					sym.getSymbol("liveMc").getSymbol("lapCounter").$("laps1").animate({rotate:lapsAngle},{//rotate lap counter
         					step: function(now,fx) {
         					$(this).css('-webkit-transform','rotate('+now+'deg)');
         					$(this).css('-moz-transform','rotate('+now+'deg)'); 
         					$(this).css('-ms-transform','rotate('+now+'deg)'); 
         					$(this).css('-op-transform','rotate('+now+'deg)'); 
         					$(this).css('transform','rotate('+now+'deg)');
         					},duration:'fast'},'linear');
         				}else{
         					sym.getSymbol("liveMc").getSymbol("lapCounter").$("laps1").animate({rotate:180},{
         					step: function(now,fx) {
         					$(this).css('-webkit-transform','rotate(180deg)');
         					$(this).css('-moz-transform','rotate(180deg)'); 
         					$(this).css('-moz-transform','rotate(180deg)'); 
         					$(this).css('-ms-transform','rotate(180deg)');
         					$(this).css('-op-transform','rotate(180deg)');
         					$(this).css('transform','rotate(180deg)');
         					},duration:'fast'},'linear');
         					sym.getSymbol("liveMc").getSymbol("lapCounter").$("laps2").show();
         					sym.getSymbol("liveMc").getSymbol("lapCounter").$("laps2").animate({rotate:lapsAngle},{
         					step: function(now,fx) {
         					$(this).css('-webkit-transform','rotate('+now+'deg)');
         					$(this).css('-moz-transform','rotate('+now+'deg)'); 
         					$(this).css('-ms-transform','rotate('+now+'deg)'); 
         					$(this).css('-op-transform','rotate('+now+'deg)'); 
         					$(this).css('transform','rotate('+now+'deg)');
         					},duration:'fast'},'linear');
         				}
         			}
         			if (data[0].b_Finished==true){
         				sym.getSymbol("liveMc").$("statusTxt").css({"background-color":"rgb(225,5,20)"});
         				gpInterval=setInterval(liveGP,300000);
         			}else if (data[0].b_Started==true){
         				sym.getSymbol("liveMc").$("statusTxt").css({"background-color":"rgb(85,192,40)"});
         				gpInterval=setInterval(liveGP,45000);
         			}else{
         				sym.getSymbol("liveMc").$("statusTxt").css({"background-color":"rgb(100,100,100)"});
         				gpInterval=setInterval(liveGP,300000);
         			}
         		}
         	});
         }
         function getLive(phaseID) { //GET LIVE timing data and final result
         	$.ajax({ type: "GET", 
         		url: dataURL,
         		data: "gn="+gn+"&yr="+gnYear+"&race="+phaseID,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			raceData = data;
         			//Ensure all drivers will fit in graph
         			sym.getSymbol("resultMc").$("graph").empty();
         			sym.getSymbol("resultMc").$("loading").fadeOut(0);
         			sym.getSymbol("liveMc").$("graph").empty();					
         			sym.getSymbol("liveMc").$("loading").fadeOut(0);
         			var nDrivers = raceData.length;
         			var barHeightr;
         			var minTime;
         			if (raceData.length>18){
         				barHeightr = Math.round((470/raceData.length)-4);
         			}else{
         				barHeightr = 18;
         			}
         			//calculate relative length of each bar
         			if (raceStage =="R"){
         				minTime = raceData[0].n_TimeRel;
         				var mxm = (minTime!=null) ? minTime : 0;
         				var timeRel = 0;							
         				for (var n=0; n<raceData.length; n++) {
         					if (raceData[n].n_TimeRel!=null && raceData[n].n_TimeRel>mxm) {
         						mxm = raceData[n].n_TimeRel;
         					}
         				}
         			}else if (raceData[0].n_TimeAbs!=undefined){//during other phases	
         				minTime = raceData[0].n_TimeAbs; 
         				var mxm = (minTime!=null) ? minTime : 0;
         				var timeRel = 1;							
         				for (var n=0; n<raceData.length; n++) {
         					if (raceData[n].n_TimeAbs!=null && raceData[n].n_TimeAbs>mxm) {
         						mxm = raceData[n].n_TimeAbs;									
         					}
         				}
         			}				
         			for (var i = 0; i < raceData.length; i++) {
         				if(i==0){ //show lead drivers
         					var imgDriver1 = raceData[i].n_PersonID;
         					var leadDriver1 = '<b>' +raceData[i].c_Person+ '</b> ' +raceData[i].c_NOCShort;					
         					sym.getSymbol("resultMc").$("driverPic1").attr("src", "drivers/"+imgDriver1+".jpg");
         					sym.getSymbol("resultMc").$("drivertxt1").html(leadDriver1);
         				}
         				if(i==1){ //show lead drivers
         					var imgDriver2 = raceData[i].n_PersonID;
         					var leadDriver2 = '<b>' +raceData[i].c_Person+ '</b> ' +raceData[i].c_NOCShort;					
         					sym.getSymbol("resultMc").$("driverPic2").attr("src", "drivers/"+imgDriver2+".jpg");
         					sym.getSymbol("resultMc").$("drivertxt2").html(leadDriver2);
         				}
         				if(i==2){ //show lead drivers
         					var imgDriver3 = raceData[i].n_PersonID;
         					var leadDriver3 = '<b>' +raceData[i].c_Person+ '</b> ' +raceData[i].c_NOCShort;					
         					sym.getSymbol("resultMc").$("driverPic3").attr("src", "drivers/"+imgDriver3+".jpg");
         					sym.getSymbol("resultMc").$("drivertxt3").html(leadDriver3);
         				}
         				//create timing tables and final results tanle
         				if (i==0){
         					var tableText ="<div class='liverace'>";
         					tableText += "<div id='livedriverdata"+i+"'>";
         					tableText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr height="+barHeightr+">";
         					tableText += "<td id='driver"+i+"'width="+(mobGraph==1?'90px':'115px')+"></td>";
         					tableText += "<td id='team"+i+"' style='font-style:italic' width='18px'></td>";
         					tableText += "<td id='pitstops"+i+"' style='font-weight:bold' width='15px'></td>";
         					tableText += "<td id='pitCaps"+i+"'></td>";
         					tableText += "<td id='time"+i+"'></td>";
         					tableText += "</tr></table>";
         					tableText += "</div>";
         					tableText += "</div>";
         				}else{
         					var tableText ="<div class='liverace'>";
         					tableText += "<div id='livedriverdata"+i+"'>";
         					tableText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr height="+barHeightr+">";
         					tableText += "<td class='driver' id='driver"+i+"'width="+(mobGraph==1?'90px':'115px')+"></td>";
         					tableText += "<td id='team"+i+"' style='font-style:italic' width='18px'></td>";
         					tableText += "<td id='pitstops"+i+"' style='font-weight:bold' width='15px'></td>";
         					tableText += "<td id='time"+i+"'></td>";
         					tableText += "</tr></table>";
         					tableText += "</div>";
         					tableText += "</div>";
         				}
         				var resultsText ="<div class='resultrace'>";
         				resultsText +="<div id='resultdata"+i+"'>";
         				resultsText +="<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         				resultsText +="<td id='resultorder"+i+"' width='12%'></td>";
         				resultsText +="<td class='driver' id='resultdriver"+i+"' width='50%'></td>";
         				resultsText +="<td id='resultteam"+i+"' style='font-style:italic' width='8%'></td>";
         				resultsText +="<td id='points"+i+"'></td>";
         				resultsText +="</tr></table>";
         				resultsText +="</div>";
         				resultsText +="</div>";					
         				sym.getSymbol("liveMc").$("graph").append(tableText);
         				var teamLogo=(mobGraph==1)?'':'<img src="images/'+ raceData[i].c_TeamShort +'.png" width="16px">';
         				$('#driver' + i).text((raceData[i].c_PersonShort).toUpperCase());
         				$('#team' + i).html(teamLogo);
         				if (raceData[i].n_PitStops){					
         					$('#pitstops' + i).text(raceData[i].n_PitStops);
         					$('#pitstops' + i).css({'font-weight':'bold','text-align':'center','color':'rgb(255,255,255)','background-color':'rgba(0,0,0,0.15)'});
         					if(i==0){
         						$('#pitCaps' + i).text(caps[10]);
         						$('#pitCaps' + i).css({'font-weight':'bold', 'color':'rgba(0,0,0,0.30)'});
         					}
         				}
         				if (timeRel==1){
         					var hrs =(raceData[i].n_TimeAbs>3600000)?Math.floor(raceData[i].n_TimeAbs/3600000)+":":"";
         					var mins=(raceData[i].n_TimeAbs>3600000)?Math.floor((raceData[i].n_TimeAbs%3600000)/60000):Math.floor(raceData[i].n_TimeAbs/60000);
         					if (mins<10){
         						mins="0"+mins+":";
         					}else if(mins<1){
         						mins="00:";
         					}else{
         						mins=mins+":";
         					}
         					var secs=(raceData[i].n_TimeAbs>3600000)?(raceData[i].n_TimeAbs%3600000%60000)/1000:(raceData[i].n_TimeAbs%60000%60000)/1000;
         					if (secs<10){
         						secs="0"+secs;
         					}
         					var timing = hrs+mins+secs;
         					$('#time' + i).text(timing);
         					if (minTime==mxm && raceData[i].n_TimeAbs==mxm) {	//if minTime=mxm=item Time that means that there is just 1 item with valid time. show this graph as max
         						scale=100;
                  		}else if(raceData[i].n_TimeAbs==null){
                  			scale=(mobGraph==1)?65:59;
                  		}else{
                  			scale = 100-((raceData[i].n_TimeAbs-minTime)*(mobGraph==1?30:39)/(mxm-minTime));
                  		}	
                  	}else if (timeRel==0){
                  		if(raceData[i].n_RankSort==1&&raceData[i].n_TimeAbs==null){
                  			scale=100;
                  			$('#time' + i).text();
                  		}else if(raceData[i].n_TimeRel==null){						
                  			scale=(mobGraph==1)?65:59;
                  			if (raceData[i].c_ResultSuffix==null){
                  			}else{
                  				$('#time' + i).text(raceData[i].c_ResultSuffix);
                  			}
                  		}else{
                  			scale = 100-(raceData[i].n_TimeRel*(mobGraph==1?30:39)/mxm);
                  			$('#time' + i).text(raceData[i].c_Result);
                  		}
                  	}
                  	$(".liverace").css({'font-size':'13px', 'font-family':'pragmatica-web, sans-serif', 'width':'98%', 'margin-bottom':'4px'});
                  	$("#livedriverdata" + i).css({'height':barHeightr+'px','width':scale+'%','background-color':'rgb(230,225,215)','padding-left':'3px', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
                  	$("#time" + i).css({'text-align':'right', 'padding-right':'5px'});
                  	sym.getSymbol("liveMc").$("graph").css({'margin-top':'3px'});
                  	if (raceFinished==1){ // final results
                  		sym.getSymbol("resultMc").$("graph").append(resultsText);					
                  		order = raceData[i].n_RankSort;
                  		if (raceData[i].c_ChampionshipPoints!=undefined){
                  			points = raceData[i].c_ChampionshipPoints;
                  		}else{
                  			points="";
                  		}
                  		$('#resultorder' + i).html("<b>"+order+"</b>");
                  		$('#resultdriver' + i).text((raceData[i].c_PersonShort).toUpperCase());
                        //$('#resultteam' + i).text(raceData[i].c_TeamShort);
                        $('#resultteam' + i).html(teamLogo);
                  		if (i==0){
                  			$('#points' + i).html("<b>"+points+caps[12]+"</b>");
                  		}else{
                  			$('#points' + i).html("<b>"+points+"</b>");
                  		}
                  		$(".resultrace").css({'font-size':'13px', 'font-family':'pragmatica-web, sans-serif', 'width':'100%', 'margin-bottom':'4px'});
                  		$("#resultdata"+i).css({'height':barHeightr+'px','width':'60%','padding-left':'3px','background-color':'rgb(230,225,215)', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
                  		$("#points" + i).css({'text-align':'right', 'padding-right':'5px'});
                  		sym.getSymbol("resultMc").$("graph").css({'margin-top':'3px'});
                  	}
         			}
         		},
         		error: function(){
         		}		
         	});
         }
         var scalePhase;
         function getPhases(phaseID){//get timing data for completed phases
         	$.ajax({ type:"GET",
         		url:dataURL,
         		data:  "gn="+gn+"&yr="+gnYear+"&race="+phaseID,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			var phaseData = data;
         			var barHeight;var minTime;
         			sym.getSymbol("timingMc").$("loading").fadeOut(0);
         			sym.getSymbol("timingMc").$("graph").empty();
         			//Ensure all drivers will fit in graph
         			if (phaseData.length>18){
         				barHeight = Math.round(470/phaseData.length)-4;
         			}else{
         				barHeight = 18;
         			}
         			minTime = phaseData[0].n_TimeAbs;
         			var max = (minTime!=null) ? minTime : 0;
         			for (var n=0; n<phaseData.length; n++) {
         				if (phaseData[n].n_TimeAbs!=null && phaseData[n].n_TimeAbs>max) {
         					max = phaseData[n].n_TimeAbs;									
         				}
         				if (phaseData[n].n_TimeAbs!=null && phaseData[n].n_TimeAbs<minTime) {
         					minTime = phaseData[n].n_TimeAbs;									
         				}
         			}
         			for (var i = 0; i < phaseData.length; i++) {//build timing table
         				var phaseText ="<div class='phaserace'>";
         				phaseText +="<div id='phasedriverdata"+i+"'>";
         				phaseText +="<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
         				phaseText +="<td id='phasedriver"+i+"'width="+(mobGraph==1?'90px':'115px')+"></td>";
         				phaseText +="<td id='phaseteam"+i+"' style='font-style:italic' width='40px'></td>";
         				phaseText +="<td id='phasetime"+i+"'></td>";
         				phaseText +="</tr></table>";
         				phaseText +="</div>";
         				phaseText +="</div>";
         				sym.getSymbol("timingMc").$("graph").append(phaseText);
         				$('#phasedriver' + i).text((phaseData[i].c_PersonShort).toUpperCase());
         				var teamLogo=(mobGraph==1)?'':'<img src="images/'+ raceData[i].c_TeamShort +'.png" width="16px">';
         				//$('#phaseteam' + i).text(phaseData[i].c_TeamShort);
         				$('#phaseteam' + i).html(teamLogo);
         				var mins=Math.floor(phaseData[i].n_TimeAbs/60000)+":";
         				var secs=(phaseData[i].n_TimeAbs%60000%60000)/1000;
         				if (secs<10){
         					secs="0"+secs;
         				}
         				$('#phasetime' + i).text(mins+secs);
         				if (minTime==max && phaseData[i].n_TimeAbs==max) {	//if minTime=mxm=item Time that means that there is just 1 item with valid time. show this graph as max
         					scalePhase=100;
         				}else if(phaseData[i].n_TimeAbs==null){
         					scalePhase=(mobGraph==1)?65:59;
         				}else{
         					scalePhase = 100-((phaseData[i].n_TimeAbs-minTime)*(mobGraph==1?35:41)/(max-minTime));
         				}
         				$(".phaserace").css({'font-size':'13px', 'font-family':'pragmatica-web, sans-serif', 'width':'98%', 'margin-bottom':'4px'});
         				$("#phasedriverdata" + i).css({'height':barHeight+'px', 'width':scalePhase+'%','padding-left':'3px','background-color':'rgb(230,225,215)', 'box-shadow':'3px 2px 5px rgba(100,100,100,0.75)'});
         				$("#phasetime" + i).css({'text-align':'right', 'padding-right':'5px'});
         				sym.getSymbol("timingMc").$("graph").css({'margin-top':'3px'});
         			}
         		},
         		error: function(){
         		}
         	});
         }
         
         // GRID BUTTON
         function getGrid(phaseID){
         $.ajax({ type:"GET",
         			url:dataURL,
         			data:  "gn="+gn+"&yr="+gnYear+"&race="+phaseID,
                  contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  async: true,
                  crossDomain: true,
                  success: function (data) {
                  var gridData = data;
         			sym.getSymbol("timingMc").$("loading").fadeOut(0);
         			sym.getSymbol("timingMc").$("gridSlider"). fadeIn(500);
         			sym.getSymbol("timingMc").$("graph"). fadeOut(500);
         			sym.getSymbol("timingMc").$("timeTxt"). fadeOut(500);
         				var gridMove, go;
         				for (var i = 0; i < gridData.length; i++) {
         					sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("grid"+i).empty();												
         					var gridText ="<div class='gridlist'><table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'>";
         					gridText += "<tr><td class='gridorder' id='gridorder"+i+"' width='10%'></td>";
         					gridText +="<td class='griddriver' id='griddriver"+i+"' width='62%'></td>";
         					gridText +="<td class='driverShort' id='griddriverS"+i+"' width='62%'></td>";
         					gridText +="<td class='gridlogo' id='gridteam"+i+"' width='28%' font-style:italic'></td>";
         					gridText +="</tr></table></div>";
         					if (i%2==0){
         					sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("gridtxt0").append(gridText);
         					}else{
         					sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("gridtxt1").append(gridText);
         					}
         					var gridCar = '<img src="cars/'+ gridData[i].c_TeamShort +'o.png" width="24px">';
         					var order = gridData[i].n_RankSort;
         					var teamLogo='<img src="images/'+ gridData[i].c_TeamShort +'.png" width="24px">';
         					$('#gridorder' + i).html("<b>"+order+"</b>");
         					$('#griddriver' + i).text(gridData[i].c_Person);
         					$('#griddriverS' + i).text((gridData[i].c_PersonShort).toUpperCase());
         					$('#gridteam' + i).html(teamLogo);
         					$(".gridorder").css({'width':'8%'});
         					$(".griddriver").css({'width':'52%','padding-left':'2%'});
         					$(".gridlogo").css({'width':'10%','font-style':'italic'});
         					$(".gridlist").css({'font-size':'14px', 'font-family':'pragmatica-web, sans-serif', 'width':'100%', 'height':'66px','border-bottom':'solid 1px rgb(150,150,150)','padding-top':'5px'});
         					sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("grid"+i).append(gridCar);
         					if (i%2==0){
         					gridMove=5+(i*35);
         					}else{
         					gridMove=-15+(i*35);
         					}
         					sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("grid"+i).delay(i*400).animate({'top':gridMove}, 1000);								
         				}
         				sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("gridtxt1").css({'margin-top':'5px'});
         				sym.getSymbol("timingMc").getSymbol("gridSlider").getSymbol("grid").$("gridtxt1").css({'margin-top':'17px'});
         				sym.getSymbol("timingMc").$("gridSlider").css({'overflow-y':'scroll'});
         				sym.getSymbol("timingMc").$("gridSlider").scrollTop(0);
                  },
                  complete:function(){
         				initSize();
                  }
               });
         }
         
         function liveGP(){
         	getRace(latestGP);
         }
         setTimeout(liveGP, 2000);//get latest race at startup
         gpInterval=setInterval(liveGP,60000);
         // CIRCUIT BUTTONS & TIMELINE FUNCTIONS
         sym.gearChange = function(gearIn,gearOut,duration) {
         	sym.$({countNum: gearIn}).animate({countNum: gearOut}, {
         		duration: duration,
         		easeOut:'cubic',
         		step: function() {
         		 sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("speedGearsMc").getSymbol("gearsMc").$("gear").text(Math.round(this.countNum));//
         		},
         	});
         }
         sym.speedChange = function(speedIn,speedOut,duration) {
         	sym.$({countNum: speedIn}).animate({countNum: speedOut}, {
         	  duration: duration,
         	  easeOut:'cubic',
         	  step: function() {
         		 sym.getSymbol("circuitMc").getSymbol("circuitOverlay").getSymbol("speedGearsMc").getSymbol("gearsMc").$("speed").html(Math.round(this.countNum));
         	  },
         	});
         }
         $(".alertnote").css({'padding':'2px 5px','border-radius':'5px'});
         $('img').on('dragstart',function(e){ e.preventDefault(); }); //make images undraggable
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //********************************************************************************************************

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleMc'
   (function(symbolName) {   
   
   })("StyleMc");
   //Edge symbol end:'StyleMc'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'RaceBtn'
   (function(symbolName) {   
   
   })("RaceBtn");
   //Edge symbol end:'RaceBtn'

   //=========================================================
   
   //Edge symbol: 'PhaseBtn'
   (function(symbolName) {   
   
   })("PhaseBtn");
   //Edge symbol end:'PhaseBtn'

   //=========================================================
   
   //Edge symbol: 'MenuBtn'
   (function(symbolName) {   
   
   })("MenuBtn");
   //Edge symbol end:'MenuBtn'

   //=========================================================
   
   //Edge symbol: 'MenuButtonsMc'
   (function(symbolName) {   
   
   })("MenuButtonsMc");
   //Edge symbol end:'MenuButtonsMc'

   //=========================================================
   
   //Edge symbol: 'TeamButtonStrip'
   (function(symbolName) {   
   
   })("TeamButtonStrip");
   //Edge symbol end:'TeamButtonStrip'

   //=========================================================
   
   //Edge symbol: 'CalendarMc'
   (function(symbolName) {   
   
   })("CalendarMc");
   //Edge symbol end:'CalendarMc'

   //=========================================================
   
   //Edge symbol: 'ResultMc'
   (function(symbolName) {   
   
   })("ResultMc");
   //Edge symbol end:'ResultMc'

   //=========================================================
   
   //Edge symbol: 'TimingMc'
   (function(symbolName) {   
   
   })("TimingMc");
   //Edge symbol end:'TimingMc'

   //=========================================================
   
   //Edge symbol: 'LiveMc'
   (function(symbolName) {   
   
   })("LiveMc");
   //Edge symbol end:'LiveMc'

   //=========================================================
   
   //Edge symbol: 'lapCounter'
   (function(symbolName) {   
   
   })("lapCounter");
   //Edge symbol end:'lapCounter'

   //=========================================================
   
   //Edge symbol: 'DriverChampMc'
   (function(symbolName) {   
   
   })("DriverChampMc");
   //Edge symbol end:'DriverChampMc'

   //=========================================================
   
   //Edge symbol: 'TeamChampMc'
   (function(symbolName) {   
   
   })("TeamChampMc");
   //Edge symbol end:'TeamChampMc'

   //=========================================================
   
   //Edge symbol: 'TeamDriverMc'
   (function(symbolName) {   
   
   })("TeamDriverMc");
   //Edge symbol end:'TeamDriverMc'

   //=========================================================
   
   //Edge symbol: 'DriveCar'
   (function(symbolName) {   
   
   })("DriveCar");
   //Edge symbol end:'DriveCar'

   //=========================================================
   
   //Edge symbol: 'DriversMc'
   (function(symbolName) {   
   
   })("DriversMc");
   //Edge symbol end:'DriversMc'

   //=========================================================

//=========================================================

//=========================================================

//Edge symbol: 'flatmap_two'
(function(symbolName){})("flatmap-two");
   //Edge symbol end:'flatmap-two'

//=========================================================

//Edge symbol: 'Symbol_1'
(function(symbolName){})("continents-animation");
   //Edge symbol end:'continents-animation'

//=========================================================

//Edge symbol: 'globe'
(function(symbolName){})("globe");
   //Edge symbol end:'globe'

   //=========================================================
   
   //Edge symbol: 'GlobeMc'
   (function(symbolName) {   
   
   })("GlobeMc");
   //Edge symbol end:'GlobeMc'

   //=========================================================
   
   //Edge symbol: 'RaceButtons'
   (function(symbolName) {   
   
   })("RaceButtons");
   //Edge symbol end:'RaceButtons'

   //=========================================================
   
   //Edge symbol: 'CircuitMc'
   (function(symbolName) {   
   
   })("CircuitMc");
   //Edge symbol end:'CircuitMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("AUSmini");
   //Edge symbol end:'AUSmini'

   //=========================================================

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'carMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.play();

      });
      //Edge binding end

   })("carMc");
   //Edge symbol end:'carMc'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,305,1150);
         sym.getComposition().getStage().gearChange(1,7,1150);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1151, function(sym, e) {
         sym.getComposition().getStage().speedChange(305,145,200);
         sym.getComposition().getStage().gearChange(7,3,200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1350, function(sym, e) {
         sym.getComposition().getStage().speedChange(145,200,500);
         sym.getComposition().getStage().gearChange(3,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1856, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,282,1150);
         sym.getComposition().getStage().gearChange(4,5,1150);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(282,92,425);
         sym.getComposition().getStage().gearChange(5,2,425);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3425, function(sym, e) {
         sym.getComposition().getStage().speedChange(92,145,325);
         sym.getComposition().getStage().gearChange(2,3,325);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3750, function(sym, e) {
         sym.$({countNum: 220}).animate({countNum: 280}, {
           duration: 1400,
           easeOut:'cubic',
           step: function() {
             sym.$("speed").html(Math.round(this.countNum));
           },
         });
         
         sym.$({countNum: 5}).animate({countNum: 7}, {
           duration: 1400,
           easeOut:'cubic',
           step: function() {
             sym.$("gear").text(Math.round(this.countNum));
           },
         });
         sym.getComposition().getStage().speedChange(145,239,650);
         sym.getComposition().getStage().gearChange(3,6,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4400, function(sym, e) {
         sym.getComposition().getStage().speedChange(239,283,850);
         sym.getComposition().getStage().gearChange(6,7,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5250, function(sym, e) {
         sym.getComposition().getStage().speedChange(283,186,750);
         sym.getComposition().getStage().gearChange(7,4,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6000, function(sym, e) {
         sym.getComposition().getStage().speedChange(186,255,450);
         sym.getComposition().getStage().gearChange(4,6,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6450, function(sym, e) {
         sym.getComposition().getStage().speedChange(255,280,800);
         sym.getComposition().getStage().gearChange(6,7,800);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(280,115,250);
         sym.getComposition().getStage().gearChange(7,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(115,292,1750);
         sym.getComposition().getStage().gearChange(3,7,1750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(292,226,500);
         sym.getComposition().getStage().gearChange(7,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9750, function(sym, e) {
         sym.getComposition().getStage().speedChange(226,233,400);
         sym.getComposition().getStage().gearChange(6,5,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10150, function(sym, e) {
         sym.getComposition().getStage().speedChange(233,284,600);
         sym.getComposition().getStage().gearChange(5,7,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10750, function(sym, e) {
         sym.getComposition().getStage().speedChange(284,284,400);
         sym.getComposition().getStage().gearChange(7,7,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11750, function(sym, e) {
         sym.getComposition().getStage().speedChange(284,138,200);
         sym.getComposition().getStage().gearChange(7,3,200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11938, function(sym, e) {
         sym.getComposition().getStage().speedChange(138,205,1000);
         sym.getComposition().getStage().gearChange(3,5,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12923, function(sym, e) {
         sym.getComposition().getStage().speedChange(205,84,500);
         sym.getComposition().getStage().gearChange(5,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(84,180,500);
         sym.getComposition().getStage().gearChange(2,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14000, function(sym, e) {
         sym.getComposition().getStage().speedChange(180,300,1000);
         sym.getComposition().getStage().gearChange(4,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("AUSMc");
   //Edge symbol end:'AUSMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'gearsMc'
   (function(symbolName) {   
   
   })("gearsMc");
   //Edge symbol end:'gearsMc'

   //=========================================================
   
   //Edge symbol: 'playPause'
   (function(symbolName) {   
   
   })("playPause");
   //Edge symbol end:'playPause'

   //=========================================================
   
   //Edge symbol: 'CircuitOverlay'
   (function(symbolName) {   
   
   })("CircuitOverlay");
   //Edge symbol end:'CircuitOverlay'

   //=========================================================
   
   //Edge symbol: 'speedGearsMc'
   (function(symbolName) {   
   
   })("speedGearsMc");
   //Edge symbol end:'speedGearsMc'

   //=========================================================
   
   //Edge symbol: 'status'
   (function(symbolName) {   
   
   })("Status");
   //Edge symbol end:'Status'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,300,1000);
         sym.getComposition().getStage().gearChange(2,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,63,650);
         sym.getComposition().getStage().gearChange(7,1,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2150, function(sym, e) {
         sym.getComposition().getStage().speedChange(63,158,350);
         sym.getComposition().getStage().gearChange(1,3,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2500, function(sym, e) {
         sym.getComposition().getStage().speedChange(158,221,500);
         sym.getComposition().getStage().gearChange(3,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(221,300,1000);
         sym.getComposition().getStage().gearChange(5,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4000, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,111,500);
         sym.getComposition().getStage().gearChange(7,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         sym.getComposition().getStage().speedChange(111,190,1000);
         sym.getComposition().getStage().gearChange(2,4,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5500, function(sym, e) {
         sym.getComposition().getStage().speedChange(190,253,750);
         sym.getComposition().getStage().gearChange(4,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6250, function(sym, e) {
         sym.getComposition().getStage().speedChange(253,79,250);
         sym.getComposition().getStage().gearChange(6,1,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6500, function(sym, e) {
         sym.getComposition().getStage().speedChange(79,205,900);
         sym.getComposition().getStage().gearChange(1,5,900);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7400, function(sym, e) {
         sym.getComposition().getStage().speedChange(205,63,350);
         sym.getComposition().getStage().gearChange(5,1,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(63,284,1250);
         sym.getComposition().getStage().gearChange(1,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9500, function(sym, e) {
         sym.getComposition().getStage().speedChange(284,255,1250);
         sym.getComposition().getStage().gearChange(7,6,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10750, function(sym, e) {
         sym.getComposition().getStage().speedChange(255,126,900);
         sym.getComposition().getStage().gearChange(6,3,900);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11650, function(sym, e) {
         sym.getComposition().getStage().speedChange(126,300,1200);
         sym.getComposition().getStage().gearChange(3,7,1200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13250, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,128,500);
         sym.getComposition().getStage().gearChange(7,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13750, function(sym, e) {
         sym.getComposition().getStage().speedChange(128,300,1250);
         sym.getComposition().getStage().gearChange(3,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("BRNMc");
   //Edge symbol end:'BRNMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("BRNmini");
   //Edge symbol end:'BRNmini'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,311,750);
         sym.getComposition().getStage().gearChange(1,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 750, function(sym, e) {
         sym.getComposition().getStage().speedChange(311,95,750);
         sym.getComposition().getStage().gearChange(7,2,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(95,85,250);
         sym.getComposition().getStage().gearChange(2,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getComposition().getStage().speedChange(85,295,850);
         sym.getComposition().getStage().gearChange(2,6,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3250, function(sym, e) {
         sym.getComposition().getStage().speedChange(295,76,300);
         sym.getComposition().getStage().gearChange(6,2,300);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3550, function(sym, e) {
         sym.getComposition().getStage().speedChange(76,270,1000);
         sym.getComposition().getStage().gearChange(2,6,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5150, function(sym, e) {
         sym.getComposition().getStage().speedChange(270,108,1200);
         sym.getComposition().getStage().gearChange(6,3,1200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6350, function(sym, e) {
         sym.getComposition().getStage().speedChange(108,261,1400);
         sym.getComposition().getStage().gearChange(3,6,1400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(261,85,500);
         sym.getComposition().getStage().gearChange(6,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8250, function(sym, e) {
         sym.getComposition().getStage().speedChange(85,250,1250);
         sym.getComposition().getStage().gearChange(2,6,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9500, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,326,1000);
         sym.getComposition().getStage().gearChange(6,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(326,73,150);
         sym.getComposition().getStage().gearChange(7,2,150);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12900, function(sym, e) {
         sym.getComposition().getStage().speedChange(73,159,850);
         sym.getComposition().getStage().gearChange(2,4,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13750, function(sym, e) {
         sym.getComposition().getStage().speedChange(159,300,1250);
         sym.getComposition().getStage().gearChange(4,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("CHNMc");
   //Edge symbol end:'CHNMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("CHNmini");
   //Edge symbol end:'CHNmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,310,1400);
         sym.getComposition().getStage().gearChange(1,8,1400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(310,325,1500);
         sym.getComposition().getStage().gearChange(7,7,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(325,125,250);
         sym.getComposition().getStage().gearChange(7,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3250, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,275,1000);
         sym.getComposition().getStage().gearChange(3,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4250, function(sym, e) {
         sym.getComposition().getStage().speedChange(275,165,1000);
         sym.getComposition().getStage().gearChange(7,4,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5500, function(sym, e) {
         sym.getComposition().getStage().speedChange(165,125,1000);
         sym.getComposition().getStage().gearChange(4,3,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6500, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,265,750);
         sym.getComposition().getStage().gearChange(3,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(265,165,1250);
         sym.getComposition().getStage().gearChange(6,4,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8500, function(sym, e) {
         sym.getComposition().getStage().speedChange(165,215,1250);
         sym.getComposition().getStage().gearChange(4,5,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9750, function(sym, e) {
         sym.getComposition().getStage().speedChange(215,330,1250);
         sym.getComposition().getStage().gearChange(5,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11750, function(sym, e) {
         sym.getComposition().getStage().speedChange(330,90,500);
         sym.getComposition().getStage().gearChange(7,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12250, function(sym, e) {
         sym.getComposition().getStage().speedChange(90,110,1250);
         sym.getComposition().getStage().gearChange(2,3,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(110,260,750);
         sym.getComposition().getStage().gearChange(3,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14250, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,115,500);
         sym.getComposition().getStage().gearChange(6,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14750, function(sym, e) {
         sym.getComposition().getStage().speedChange(115,250,250);
         sym.getComposition().getStage().gearChange(3,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("290");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("RUSMc");
   //Edge symbol end:'RUSMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("RUSmini");
   //Edge symbol end:'RUSmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,309,1700);
         sym.getComposition().getStage().gearChange(1,7,1700);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getComposition().getStage().speedChange(309,141,250);
         sym.getComposition().getStage().gearChange(7,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.getComposition().getStage().speedChange(141,188,250);
         sym.getComposition().getStage().gearChange(3,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(188,235,850);
         sym.getComposition().getStage().gearChange(4,5,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3100, function(sym, e) {
         sym.getComposition().getStage().speedChange(235,286,1500);
         sym.getComposition().getStage().gearChange(5,7,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4600, function(sym, e) {
         sym.getComposition().getStage().speedChange(286,142,400);
         sym.getComposition().getStage().gearChange(7,3,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(142,248,750);
         sym.getComposition().getStage().gearChange(3,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5750, function(sym, e) {
         sym.getComposition().getStage().speedChange(248,102,500);
         sym.getComposition().getStage().gearChange(5,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6250, function(sym, e) {
         sym.getComposition().getStage().speedChange(102,262,1000);
         sym.getComposition().getStage().gearChange(2,6,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(262,145,250);
         sym.getComposition().getStage().gearChange(6,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(145,185,250);
         sym.getComposition().getStage().gearChange(3,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(185,246,500);
         sym.getComposition().getStage().gearChange(4,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8250, function(sym, e) {
         sym.getComposition().getStage().speedChange(246,230,350);
         sym.getComposition().getStage().gearChange(5,5,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8600, function(sym, e) {
         sym.getComposition().getStage().speedChange(230,291,1250);
         sym.getComposition().getStage().gearChange(5,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(291,74,350);
         sym.getComposition().getStage().gearChange(7,2,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10600, function(sym, e) {
         sym.getComposition().getStage().speedChange(74,125,1000);
         sym.getComposition().getStage().gearChange(2,3,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11600, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,128,500);
         sym.getComposition().getStage().gearChange(3,3,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12250, function(sym, e) {
         sym.getComposition().getStage().speedChange(128,171,500);
         sym.getComposition().getStage().gearChange(3,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(171,95,150);
         sym.getComposition().getStage().gearChange(3,2,150);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12900, function(sym, e) {
         sym.getComposition().getStage().speedChange(95,212,600);
         sym.getComposition().getStage().gearChange(2,4,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(212,300,1250);
         sym.getComposition().getStage().gearChange(4,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("ESPMc");
   //Edge symbol end:'ESPMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("ESPmini");
   //Edge symbol end:'ESPmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,309,1700);
         sym.getComposition().getStage().gearChange(1,7,1700);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getComposition().getStage().speedChange(309,141,250);
         sym.getComposition().getStage().gearChange(7,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.getComposition().getStage().speedChange(141,188,250);
         sym.getComposition().getStage().gearChange(3,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(188,235,850);
         sym.getComposition().getStage().gearChange(4,5,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3100, function(sym, e) {
         sym.getComposition().getStage().speedChange(235,286,1500);
         sym.getComposition().getStage().gearChange(5,7,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4600, function(sym, e) {
         sym.getComposition().getStage().speedChange(286,142,400);
         sym.getComposition().getStage().gearChange(7,3,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(142,248,750);
         sym.getComposition().getStage().gearChange(3,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5750, function(sym, e) {
         sym.getComposition().getStage().speedChange(248,102,500);
         sym.getComposition().getStage().gearChange(5,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6250, function(sym, e) {
         sym.getComposition().getStage().speedChange(102,262,1000);
         sym.getComposition().getStage().gearChange(2,6,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(262,145,250);
         sym.getComposition().getStage().gearChange(6,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(145,185,250);
         sym.getComposition().getStage().gearChange(3,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(185,246,500);
         sym.getComposition().getStage().gearChange(4,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8250, function(sym, e) {
         sym.getComposition().getStage().speedChange(246,230,350);
         sym.getComposition().getStage().gearChange(5,5,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8600, function(sym, e) {
         sym.getComposition().getStage().speedChange(230,291,1250);
         sym.getComposition().getStage().gearChange(5,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(291,74,350);
         sym.getComposition().getStage().gearChange(7,2,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10600, function(sym, e) {
         sym.getComposition().getStage().speedChange(74,125,1000);
         sym.getComposition().getStage().gearChange(2,3,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11600, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,128,500);
         sym.getComposition().getStage().gearChange(3,3,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12250, function(sym, e) {
         sym.getComposition().getStage().speedChange(128,171,500);
         sym.getComposition().getStage().gearChange(3,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(171,95,150);
         sym.getComposition().getStage().gearChange(3,2,150);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12900, function(sym, e) {
         sym.getComposition().getStage().speedChange(95,212,600);
         sym.getComposition().getStage().gearChange(2,4,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(212,300,1250);
         sym.getComposition().getStage().gearChange(4,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("MONMc");
   //Edge symbol end:'MONMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("MONmini");
   //Edge symbol end:'MONmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,299,1500);
         sym.getComposition().getStage().gearChange(1,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(299,76,300);
         sym.getComposition().getStage().gearChange(7,2,300);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1800, function(sym, e) {
         sym.getComposition().getStage().speedChange(76,70,350);
         sym.getComposition().getStage().gearChange(2,2,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2150, function(sym, e) {
         sym.getComposition().getStage().speedChange(70,242,850);
         sym.getComposition().getStage().gearChange(2,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(242,287,1000);
         sym.getComposition().getStage().gearChange(5,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4000, function(sym, e) {
         sym.getComposition().getStage().speedChange(287,110,400);
         sym.getComposition().getStage().gearChange(7,2,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4400, function(sym, e) {
         sym.getComposition().getStage().speedChange(110,252,850);
         sym.getComposition().getStage().gearChange(2,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5250, function(sym, e) {
         sym.getComposition().getStage().speedChange(252,248,750);
         sym.getComposition().getStage().gearChange(6,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6000, function(sym, e) {
         sym.getComposition().getStage().speedChange(248,191,1000);
         sym.getComposition().getStage().gearChange(6,4,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7000, function(sym, e) {
         sym.getComposition().getStage().speedChange(191,203,250);
         sym.getComposition().getStage().gearChange(4,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(203,281,500);
         sym.getComposition().getStage().gearChange(4,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8250, function(sym, e) {
         sym.getComposition().getStage().speedChange(281,183,250);
         sym.getComposition().getStage().gearChange(7,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8895, function(sym, e) {
         sym.getComposition().getStage().speedChange(183,225,450);
         sym.getComposition().getStage().gearChange(4,5,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9359, function(sym, e) {
         sym.getComposition().getStage().speedChange(225,152,250);
         sym.getComposition().getStage().gearChange(5,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9606, function(sym, e) {
         sym.getComposition().getStage().speedChange(152,251,650);
         sym.getComposition().getStage().gearChange(3,6,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(251,257,350);
         sym.getComposition().getStage().gearChange(6,6,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10600, function(sym, e) {
         sym.getComposition().getStage().speedChange(257,269,500);
         sym.getComposition().getStage().gearChange(6,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11100, function(sym, e) {
         sym.getComposition().getStage().speedChange(269,122,350);
         sym.getComposition().getStage().gearChange(6,2,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11450, function(sym, e) {
         sym.getComposition().getStage().speedChange(122,300,1000);
         sym.getComposition().getStage().gearChange(2,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,84,500);
         sym.getComposition().getStage().gearChange(7,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14000, function(sym, e) {
         sym.getComposition().getStage().speedChange(84,299,1000);
         sym.getComposition().getStage().gearChange(2,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("MASMc");
   //Edge symbol end:'MASMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("MASmini");
   //Edge symbol end:'MASmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,290,950);
         sym.getComposition().getStage().gearChange(1,6,950);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,260,650);
         sym.getComposition().getStage().gearChange(6,6,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1650, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,140,600);
         sym.getComposition().getStage().gearChange(6,3,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(140,245,750);
         sym.getComposition().getStage().gearChange(3,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(245,200,250);
         sym.getComposition().getStage().gearChange(5,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3250, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,185,500);
         sym.getComposition().getStage().gearChange(4,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3750, function(sym, e) {
         sym.getComposition().getStage().speedChange(185,185,2250);
         sym.getComposition().getStage().gearChange(4,4,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6000, function(sym, e) {
         sym.getComposition().getStage().speedChange(185,123,500);
         sym.getComposition().getStage().gearChange(4,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6500, function(sym, e) {
         sym.getComposition().getStage().speedChange(123,64,1500);
         sym.getComposition().getStage().gearChange(2,1,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(64,285,750);
         sym.getComposition().getStage().gearChange(1,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8500, function(sym, e) {
         sym.getComposition().getStage().speedChange(285,297,750);
         sym.getComposition().getStage().gearChange(7,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(297,180,750);
         sym.getComposition().getStage().gearChange(7,4,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10000, function(sym, e) {
         sym.getComposition().getStage().speedChange(180,140,750);
         sym.getComposition().getStage().gearChange(4,3,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10750, function(sym, e) {
         sym.getComposition().getStage().speedChange(140,312,1250);
         sym.getComposition().getStage().gearChange(3,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12500, function(sym, e) {
         sym.getComposition().getStage().speedChange(312,90,1250);
         sym.getComposition().getStage().gearChange(7,2,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14250, function(sym, e) {
         sym.getComposition().getStage().speedChange(90,290,750);
         sym.getComposition().getStage().gearChange(2,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("290");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("JPNMc");
   //Edge symbol end:'JPNMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("JPNmini");
   //Edge symbol end:'JPNmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,305,700);
         sym.getComposition().getStage().gearChange(1,7,700);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 750, function(sym, e) {
         sym.getComposition().getStage().speedChange(305,255,250);
         sym.getComposition().getStage().gearChange(7,5,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.getComposition().getStage().speedChange(255,285,500);
         sym.getComposition().getStage().gearChange(5,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(285,120,600);
         sym.getComposition().getStage().gearChange(46,2,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2150, function(sym, e) {
         sym.getComposition().getStage().speedChange(120,90,450);
         sym.getComposition().getStage().gearChange(2,2,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2600, function(sym, e) {
         sym.getComposition().getStage().speedChange(90,256,750);
         sym.getComposition().getStage().gearChange(2,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3350, function(sym, e) {
         sym.getComposition().getStage().speedChange(256,300,650);
         sym.getComposition().getStage().gearChange(6,7,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4000, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,320,500);
         sym.getComposition().getStage().gearChange(7,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         sym.getComposition().getStage().speedChange(320,180,400);
         sym.getComposition().getStage().gearChange(7,4,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4900, function(sym, e) {
         sym.getComposition().getStage().speedChange(180,140,500);
         sym.getComposition().getStage().gearChange(4,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5250, function(sym, e) {
         sym.getComposition().getStage().speedChange(140,125,250);
         sym.getComposition().getStage().gearChange(3,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5500, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,195,250);
         sym.getComposition().getStage().gearChange(3,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5750, function(sym, e) {
         sym.getComposition().getStage().speedChange(195,280,500);
         sym.getComposition().getStage().gearChange(4,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6250, function(sym, e) {
         sym.getComposition().getStage().speedChange(280,295,500);
         sym.getComposition().getStage().gearChange(6,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6750, function(sym, e) {
         sym.getComposition().getStage().speedChange(295,310,500);
         sym.getComposition().getStage().gearChange(6,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(310,255,250);
         sym.getComposition().getStage().gearChange(7,6,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(255,265,500);
         sym.getComposition().getStage().gearChange(6,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.getComposition().getStage().speedChange(265,290,500);
         sym.getComposition().getStage().gearChange(6,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8500, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,305,500);
         sym.getComposition().getStage().gearChange(6,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9000, function(sym, e) {
         sym.getComposition().getStage().speedChange(305,270,500);
         sym.getComposition().getStage().gearChange(7,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9500, function(sym, e) {
         sym.getComposition().getStage().speedChange(270,170,700);
         sym.getComposition().getStage().gearChange(6,4,700);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10200, function(sym, e) {
         sym.getComposition().getStage().speedChange(170,280,500);
         sym.getComposition().getStage().gearChange(4,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10750, function(sym, e) {
         sym.getComposition().getStage().speedChange(280,325,1500);
         sym.getComposition().getStage().gearChange(6,7,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12250, function(sym, e) {
         sym.getComposition().getStage().speedChange(325,180,500);
         sym.getComposition().getStage().gearChange(7,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(180,235,250);
         sym.getComposition().getStage().gearChange(4,5,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13000, function(sym, e) {
         sym.getComposition().getStage().speedChange(235,280,500);
         sym.getComposition().getStage().gearChange(5,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(280,110,400);
         sym.getComposition().getStage().gearChange(6,3,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13900, function(sym, e) {
         sym.getComposition().getStage().speedChange(110,130,350);
         sym.getComposition().getStage().gearChange(3,3,350);
         

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14250, function(sym, e) {
         sym.getComposition().getStage().speedChange(130,225,250);
         sym.getComposition().getStage().gearChange(3,5,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14500, function(sym, e) {
         sym.getComposition().getStage().speedChange(225,280,500);
         sym.getComposition().getStage().gearChange(5,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("290");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("ENGMc");
   //Edge symbol end:'ENGMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("ENGmini");
   //Edge symbol end:'ENGmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,325,1450);
         sym.getComposition().getStage().gearChange(1,8,1450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(325,105,250);
         sym.getComposition().getStage().gearChange(8,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getComposition().getStage().speedChange(105,280,1250);
         sym.getComposition().getStage().gearChange(3,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(280,125,625);
         sym.getComposition().getStage().gearChange(6,4,625);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3626, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,220,500);
         sym.getComposition().getStage().gearChange(4,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4250, function(sym, e) {
         sym.getComposition().getStage().speedChange(220,290,1500);
         sym.getComposition().getStage().gearChange(5,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5500, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,215,650);
         sym.getComposition().getStage().gearChange(6,5,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5900, function(sym, e) {
         sym.getComposition().getStage().speedChange(215,165,450);
         sym.getComposition().getStage().gearChange(5,4,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6350, function(sym, e) {
         sym.getComposition().getStage().speedChange(165,145,250);
         sym.getComposition().getStage().gearChange(4,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6600, function(sym, e) {
         sym.getComposition().getStage().speedChange(145,241,650);
         sym.getComposition().getStage().gearChange(4,5,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(241,105,150);
         sym.getComposition().getStage().gearChange(5,2,150);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7400, function(sym, e) {
         sym.getComposition().getStage().speedChange(105,139,350);
         sym.getComposition().getStage().gearChange(2,3,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(139,155,250);
         sym.getComposition().getStage().gearChange(2,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.getComposition().getStage().speedChange(155,140,500);
         sym.getComposition().getStage().gearChange(4,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8750, function(sym, e) {
         sym.getComposition().getStage().speedChange(140,250,750);
         sym.getComposition().getStage().gearChange(4,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9500, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,220,500);
         sym.getComposition().getStage().gearChange(5,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10000, function(sym, e) {
         sym.getComposition().getStage().speedChange(220,285,1000);
         sym.getComposition().getStage().gearChange(5,6,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11000, function(sym, e) {
         sym.getComposition().getStage().speedChange(285,120,250);
         sym.getComposition().getStage().gearChange(6,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11250, function(sym, e) {
         sym.getComposition().getStage().speedChange(120,90,1250);
         sym.getComposition().getStage().gearChange(3,3,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12500, function(sym, e) {
         sym.getComposition().getStage().speedChange(90,150,900);
         sym.getComposition().getStage().gearChange(3,4,900);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13750, function(sym, e) {
         sym.getComposition().getStage().speedChange(150,195,350);
         sym.getComposition().getStage().gearChange(4,4,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14250, function(sym, e) {
         sym.getComposition().getStage().speedChange(195,260,750);
         sym.getComposition().getStage().gearChange(4,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("290");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("HUNMc");
   //Edge symbol end:'HUNMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("HUNmini");
   //Edge symbol end:'HUNmini'

   //=========================================================
   
   //Edge symbol: 'circuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10, function(sym, e) {
         sym.getComposition().getStage().speedChange(100,295,2600);
         sym.getComposition().getStage().gearChange(1,7,2400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2700, function(sym, e) {
         sym.getComposition().getStage().speedChange(295,100,300);
         sym.getComposition().getStage().gearChange(7,3,300);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3100, function(sym, e) {
         sym.getComposition().getStage().speedChange(100,305,3600);
         sym.getComposition().getStage().gearChange(3,7,3200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6808, function(sym, e) {
         sym.getComposition().getStage().speedChange(305,65,400);
         sym.getComposition().getStage().gearChange(7,2,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7300, function(sym, e) {
         sym.getComposition().getStage().speedChange(65,295,1900);
         sym.getComposition().getStage().gearChange(2,7,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9300, function(sym, e) {
         sym.getComposition().getStage().speedChange(295,105,300);
         sym.getComposition().getStage().gearChange(7,3,300);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9700, function(sym, e) {
         sym.getComposition().getStage().speedChange(105,285,1500);
         sym.getComposition().getStage().gearChange(3,6,1300);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11300, function(sym, e) {
         sym.getComposition().getStage().speedChange(285,185,300);
         sym.getComposition().getStage().gearChange(6,4,300);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11700, function(sym, e) {
         sym.getComposition().getStage().speedChange(185,255,1000);
         sym.getComposition().getStage().gearChange(4,5,800);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12400, function(sym, e) {
         sym.getComposition().getStage().speedChange(255,170,400);
         sym.getComposition().getStage().gearChange(5,4,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12900, function(sym, e) {
         sym.getComposition().getStage().speedChange(170,225,600);
         sym.getComposition().getStage().gearChange(4,5,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13600, function(sym, e) {
         sym.getComposition().getStage().speedChange(225,265,1400);
         sym.getComposition().getStage().gearChange(4,6,1200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("265");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("GERMc");
   //Edge symbol end:'GERMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("GERmini");
   //Edge symbol end:'GERmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,85,450);
         sym.getComposition().getStage().gearChange(1,2,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 500, function(sym, e) {
         sym.getComposition().getStage().speedChange(85,170,500);
         sym.getComposition().getStage().gearChange(2,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.getComposition().getStage().speedChange(170,280,500);
         sym.getComposition().getStage().gearChange(4,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(280,315,500);
         sym.getComposition().getStage().gearChange(6,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.getComposition().getStage().speedChange(315,305,250);
         sym.getComposition().getStage().gearChange(7,7,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(305,310,250);
         sym.getComposition().getStage().gearChange(7,7,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2500, function(sym, e) {
         sym.getComposition().getStage().speedChange(310,320,750);
         sym.getComposition().getStage().gearChange(7,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3250, function(sym, e) {
         sym.getComposition().getStage().speedChange(320,335,1250);
         sym.getComposition().getStage().gearChange(7,8,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4650, function(sym, e) {
         sym.getComposition().getStage().speedChange(335,125,350);
         sym.getComposition().getStage().gearChange(8,3,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,190,500);
         sym.getComposition().getStage().gearChange(3,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5500, function(sym, e) {
         sym.getComposition().getStage().speedChange(190,245,750);
         sym.getComposition().getStage().gearChange(4,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6250, function(sym, e) {
         sym.getComposition().getStage().speedChange(245,125,350);
         sym.getComposition().getStage().gearChange(5,3,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6600, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,152,400);
         sym.getComposition().getStage().gearChange(3,3,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7000, function(sym, e) {
         sym.getComposition().getStage().speedChange(152,300,1000);
         sym.getComposition().getStage().gearChange(3,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,215,350);
         sym.getComposition().getStage().gearChange(7,5,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8350, function(sym, e) {
         sym.getComposition().getStage().speedChange(215,285,900);
         sym.getComposition().getStage().gearChange(5,6,900);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(285,160,250);
         sym.getComposition().getStage().gearChange(6,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9500, function(sym, e) {
         sym.getComposition().getStage().speedChange(160,235,600);
         sym.getComposition().getStage().gearChange(4,5,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10100, function(sym, e) {
         sym.getComposition().getStage().speedChange(235,270,1100);
         sym.getComposition().getStage().gearChange(5,7,1100);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11250, function(sym, e) {
         sym.getComposition().getStage().speedChange(270,325,1250);
         sym.getComposition().getStage().gearChange(7,8,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12500, function(sym, e) {
         sym.getComposition().getStage().speedChange(325,315,500);
         sym.getComposition().getStage().gearChange(8,8,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13000, function(sym, e) {
         sym.getComposition().getStage().speedChange(315,330,750);
         sym.getComposition().getStage().gearChange(8,8,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13750, function(sym, e) {
         sym.getComposition().getStage().speedChange(330,85,850);
         sym.getComposition().getStage().gearChange(8,2,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14150, function(sym, e) {
         sym.getComposition().getStage().speedChange(85,280,850);
         sym.getComposition().getStage().gearChange(2,6,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("290");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("BELMc");
   //Edge symbol end:'BELMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("BELmini");
   //Edge symbol end:'BELmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,335,1750);
         sym.getComposition().getStage().gearChange(1,7,1750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getComposition().getStage().speedChange(335,86,250);
         sym.getComposition().getStage().gearChange(7,1,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.getComposition().getStage().speedChange(86,74,250);
         sym.getComposition().getStage().gearChange(1,1,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(74,260,750);
         sym.getComposition().getStage().gearChange(1,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,305,750);
         sym.getComposition().getStage().gearChange(5,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3750, function(sym, e) {
         sym.getComposition().getStage().speedChange(305,330,850);
         sym.getComposition().getStage().gearChange(6,7,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4600, function(sym, e) {
         sym.getComposition().getStage().speedChange(330,120,400);
         sym.getComposition().getStage().gearChange(7,2,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(120,133,250);
         sym.getComposition().getStage().gearChange(2,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5250, function(sym, e) {
         sym.getComposition().getStage().speedChange(133,264,750);
         sym.getComposition().getStage().gearChange(2,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6000, function(sym, e) {
         sym.getComposition().getStage().speedChange(264,193,250);
         sym.getComposition().getStage().gearChange(5,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6250, function(sym, e) {
         sym.getComposition().getStage().speedChange(193,260,750);
         sym.getComposition().getStage().gearChange(4,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7000, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,178,250);
         sym.getComposition().getStage().gearChange(5,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(178,304,1500);
         sym.getComposition().getStage().gearChange(3,6,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8750, function(sym, e) {
         sym.getComposition().getStage().speedChange(304,332,750);
         sym.getComposition().getStage().gearChange(6,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9500, function(sym, e) {
         sym.getComposition().getStage().speedChange(332,169,500);
         sym.getComposition().getStage().gearChange(7,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10000, function(sym, e) {
         sym.getComposition().getStage().speedChange(169,212,250);
         sym.getComposition().getStage().gearChange(3,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(212,235,250);
         sym.getComposition().getStage().gearChange(4,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10500, function(sym, e) {
         sym.getComposition().getStage().speedChange(235,335,1500);
         sym.getComposition().getStage().gearChange(4,7,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(335,215,500);
         sym.getComposition().getStage().gearChange(7,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13250, function(sym, e) {
         sym.getComposition().getStage().speedChange(215,285,750);
         sym.getComposition().getStage().gearChange(4,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14000, function(sym, e) {
         sym.getComposition().getStage().speedChange(285,300,1000);
         sym.getComposition().getStage().gearChange(5,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("290");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("ITAMc");
   //Edge symbol end:'ITAMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("ITAmini");
   //Edge symbol end:'ITAmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,290,950);
         sym.getComposition().getStage().gearChange(1,6,950);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,90,650);
         sym.getComposition().getStage().gearChange(6,2,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1650, function(sym, e) {
         sym.getComposition().getStage().speedChange(90,200,600);
         sym.getComposition().getStage().gearChange(2,4,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,135,750);
         sym.getComposition().getStage().gearChange(4,3,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(135,280,1250);
         sym.getComposition().getStage().gearChange(3,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4250, function(sym, e) {
         sym.getComposition().getStage().speedChange(280,298,750);
         sym.getComposition().getStage().gearChange(7,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(298,110,400);
         sym.getComposition().getStage().gearChange(7,3,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5400, function(sym, e) {
         sym.getComposition().getStage().speedChange(110,94,600);
         sym.getComposition().getStage().gearChange(3,2,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6000, function(sym, e) {
         sym.getComposition().getStage().speedChange(94,126,650);
         sym.getComposition().getStage().gearChange(2,6,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6650, function(sym, e) {
         sym.getComposition().getStage().speedChange(126,255,850);
         sym.getComposition().getStage().gearChange(3,6,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(255,140,1000);
         sym.getComposition().getStage().gearChange(6,3,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8500, function(sym, e) {
         sym.getComposition().getStage().speedChange(140,80,750);
         sym.getComposition().getStage().gearChange(3,2,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(80,250,1100);
         sym.getComposition().getStage().gearChange(2,6,1100);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10350, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,80,400);
         sym.getComposition().getStage().gearChange(6,2,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10750, function(sym, e) {
         sym.getComposition().getStage().speedChange(80,225,750);
         sym.getComposition().getStage().gearChange(2,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11500, function(sym, e) {
         sym.getComposition().getStage().speedChange(225,85,250);
         sym.getComposition().getStage().gearChange(5,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11750, function(sym, e) {
         sym.getComposition().getStage().speedChange(85,130,250);
         sym.getComposition().getStage().gearChange(2,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12000, function(sym, e) {
         sym.getComposition().getStage().speedChange(130,80,500);
         sym.getComposition().getStage().gearChange(3,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12500, function(sym, e) {
         sym.getComposition().getStage().speedChange(80,126,250);
         sym.getComposition().getStage().gearChange(2,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(126,80,250);
         sym.getComposition().getStage().gearChange(3,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13000, function(sym, e) {
         sym.getComposition().getStage().speedChange(80,118,250);
         sym.getComposition().getStage().gearChange(2,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13250, function(sym, e) {
         sym.getComposition().getStage().speedChange(118,150,1000);
         sym.getComposition().getStage().gearChange(3,3,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14000, function(sym, e) {
         sym.getComposition().getStage().speedChange(150,200,500);
         sym.getComposition().getStage().gearChange(3,4,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14500, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,290,500);
         sym.getComposition().getStage().gearChange(4,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("290");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("SINMc");
   //Edge symbol end:'SINMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("SINmini");
   //Edge symbol end:'SINmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,325,950);
         sym.getComposition().getStage().gearChange(1,8,950);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.getComposition().getStage().speedChange(325,120,400);
         sym.getComposition().getStage().gearChange(8,3,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1382, function(sym, e) {
         sym.getComposition().getStage().speedChange(120,200,600);
         sym.getComposition().getStage().gearChange(3,5,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,320,2000);
         sym.getComposition().getStage().gearChange(5,8,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4000, function(sym, e) {
         sym.getComposition().getStage().speedChange(320,75,600);
         sym.getComposition().getStage().gearChange(8,2,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4600, function(sym, e) {
         sym.getComposition().getStage().speedChange(75,240,400);
         sym.getComposition().getStage().gearChange(2,5,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(240,330,2000);
         sym.getComposition().getStage().gearChange(5,8,2000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7000, function(sym, e) {
         sym.getComposition().getStage().speedChange(330,105,350);
         sym.getComposition().getStage().gearChange(8,2,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7350, function(sym, e) {
         sym.getComposition().getStage().speedChange(105,150,400);
         sym.getComposition().getStage().gearChange(2,3,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(150,270,750);
         sym.getComposition().getStage().gearChange(3,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8500, function(sym, e) {
         sym.getComposition().getStage().speedChange(270,175,750);
         sym.getComposition().getStage().gearChange(7,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9250, function(sym, e) {
         sym.getComposition().getStage().speedChange(175,180,1000);
         sym.getComposition().getStage().gearChange(5,5,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(180,235,500);
         sym.getComposition().getStage().gearChange(5,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10750, function(sym, e) {
         sym.getComposition().getStage().speedChange(235,290,500);
         sym.getComposition().getStage().gearChange(6,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11250, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,315,1000);
         sym.getComposition().getStage().gearChange(7,8,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12250, function(sym, e) {
         sym.getComposition().getStage().speedChange(315,200,500);
         sym.getComposition().getStage().gearChange(8,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,230,600);
         sym.getComposition().getStage().gearChange(5,6,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13350, function(sym, e) {
         sym.getComposition().getStage().speedChange(230,160,400);
         sym.getComposition().getStage().gearChange(6,4,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13750, function(sym, e) {
         sym.getComposition().getStage().speedChange(160,300,1250);
         sym.getComposition().getStage().gearChange(4,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("AUTMc");
   //Edge symbol end:'AUTMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("AUTmini");
   //Edge symbol end:'AUTmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

      

   })("EURMc");
   //Edge symbol end:'EURMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("EURmini");
   //Edge symbol end:'EURmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,136,700);
         sym.getComposition().getStage().gearChange(1,2,700);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 750, function(sym, e) {
         sym.getComposition().getStage().speedChange(136,77,750);
         sym.getComposition().getStage().gearChange(2,1,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(77,253,750);
         sym.getComposition().getStage().gearChange(1,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(253,130,500);
         sym.getComposition().getStage().gearChange(5,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2750, function(sym, e) {
         sym.getComposition().getStage().speedChange(130,155,250);
         sym.getComposition().getStage().gearChange(3,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(155,254,750);
         sym.getComposition().getStage().gearChange(3,5,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3750, function(sym, e) {
         sym.getComposition().getStage().speedChange(254,93,750);
         sym.getComposition().getStage().gearChange(5,2,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         sym.getComposition().getStage().speedChange(93,155,500);
         sym.getComposition().getStage().gearChange(2,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(155,294,1500);
         sym.getComposition().getStage().gearChange(2,6,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6500, function(sym, e) {
         sym.getComposition().getStage().speedChange(294,120,350);
         sym.getComposition().getStage().gearChange(6,2,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6850, function(sym, e) {
         sym.getComposition().getStage().speedChange(120,160,400);
         sym.getComposition().getStage().gearChange(2,2,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(160,297,1500);
         sym.getComposition().getStage().gearChange(2,6,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8750, function(sym, e) {
         sym.getComposition().getStage().speedChange(297,56,750);
         sym.getComposition().getStage().gearChange(6,1,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9500, function(sym, e) {
         sym.getComposition().getStage().speedChange(56,310,1250);
         sym.getComposition().getStage().gearChange(1,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12500, function(sym, e) {
         sym.getComposition().getStage().speedChange(310,135,1250);
         sym.getComposition().getStage().gearChange(7,2,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13750, function(sym, e) {
         sym.getComposition().getStage().speedChange(135,294,600);
         sym.getComposition().getStage().gearChange(2,6,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("300");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("CANMc");
   //Edge symbol end:'CANMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("CANmini");
   //Edge symbol end:'CANmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,310,1250);
         sym.getComposition().getStage().gearChange(1,8,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1250, function(sym, e) {
         sym.getComposition().getStage().speedChange(310,110,250);
         sym.getComposition().getStage().gearChange(8,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(110,90,250);
         sym.getComposition().getStage().gearChange(2,5,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getComposition().getStage().speedChange(90,230,500);
         sym.getComposition().getStage().gearChange(2,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2250, function(sym, e) {
         sym.getComposition().getStage().speedChange(230,285,750);
         sym.getComposition().getStage().gearChange(5,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.getComposition().getStage().speedChange(285,240,500);
         sym.getComposition().getStage().gearChange(7,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3500, function(sym, e) {
         sym.getComposition().getStage().speedChange(240,190,1000);
         sym.getComposition().getStage().gearChange(6,4,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         sym.getComposition().getStage().speedChange(190,165,750);
         sym.getComposition().getStage().gearChange(4,4,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5250, function(sym, e) {
         sym.getComposition().getStage().speedChange(165,260,500);
         sym.getComposition().getStage().gearChange(4,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5750, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,290,750);
         sym.getComposition().getStage().gearChange(6,7,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6500, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,90,250);
         sym.getComposition().getStage().gearChange(7,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6750, function(sym, e) {
         sym.getComposition().getStage().speedChange(90,200,750);
         sym.getComposition().getStage().gearChange(2,4,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,280,500);
         sym.getComposition().getStage().gearChange(4,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.getComposition().getStage().speedChange(280,335,1700);
         sym.getComposition().getStage().gearChange(7,8,1700);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9750, function(sym, e) {
         sym.getComposition().getStage().speedChange(335,105,250);
         sym.getComposition().getStage().gearChange(8,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10000, function(sym, e) {
         sym.getComposition().getStage().speedChange(105,80,1500);
         sym.getComposition().getStage().gearChange(2,2,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11500, function(sym, e) {
         sym.getComposition().getStage().speedChange(80,250,1250);
         sym.getComposition().getStage().gearChange(2,6,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(250,285,500);
         sym.getComposition().getStage().gearChange(6,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13250, function(sym, e) {
         sym.getComposition().getStage().speedChange(285,195,250);
         sym.getComposition().getStage().gearChange(7,4,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(195,260,500);
         sym.getComposition().getStage().gearChange(4,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14000, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,105,500);
         sym.getComposition().getStage().gearChange(6,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14500, function(sym, e) {
         sym.getComposition().getStage().speedChange(105,280,500);
         sym.getComposition().getStage().gearChange(3,7,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("280");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("USAMc");
   //Edge symbol end:'USAMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("USAmini");
   //Edge symbol end:'USAmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("260");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3500, function(sym, e) {
         sym.getComposition().getStage().speedChange(355,115,500);
         sym.getComposition().getStage().gearChange(8,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,355,3500);
         sym.getComposition().getStage().gearChange(1,8,3500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4500, function(sym, e) {
         sym.getComposition().getStage().speedChange(105,320,2250);
         sym.getComposition().getStage().gearChange(3,8,2250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6750, function(sym, e) {
         sym.getComposition().getStage().speedChange(320,70,500);
         sym.getComposition().getStage().gearChange(8,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(70,80,500);
         sym.getComposition().getStage().gearChange(2,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.getComposition().getStage().speedChange(80,255,650);
         sym.getComposition().getStage().gearChange(2,6,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8650, function(sym, e) {
         sym.getComposition().getStage().speedChange(255,155,450);
         sym.getComposition().getStage().gearChange(6,4,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9000, function(sym, e) {
         sym.getComposition().getStage().speedChange(155,230,1010);
         sym.getComposition().getStage().gearChange(4,6,1010);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10100, function(sym, e) {
         sym.getComposition().getStage().speedChange(230,150,300);
         sym.getComposition().getStage().gearChange(6,4,300);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10400, function(sym, e) {
         sym.getComposition().getStage().speedChange(150,310,1850);
         sym.getComposition().getStage().gearChange(4,8,1850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12250, function(sym, e) {
         sym.getComposition().getStage().speedChange(310,120,350);
         sym.getComposition().getStage().gearChange(8,3,350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12600, function(sym, e) {
         sym.getComposition().getStage().speedChange(120,200,400);
         sym.getComposition().getStage().gearChange(3,5,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13250, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,105,250);
         sym.getComposition().getStage().gearChange(5,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13000, function(sym, e) {
         sym.getComposition().getStage().speedChange(200,105,250);
         sym.getComposition().getStage().gearChange(5,2,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13500, function(sym, e) {
         sym.getComposition().getStage().speedChange(105,260,1500);
         sym.getComposition().getStage().gearChange(2,6,1500);

      });
      //Edge binding end

   })("MEXMc");
   //Edge symbol end:'MEXMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("MEXmini");
   //Edge symbol end:'MEXmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,315,450);
         sym.getComposition().getStage().gearChange(1,7,450);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 500, function(sym, e) {
         sym.getComposition().getStage().speedChange(315,106,500);
         sym.getComposition().getStage().gearChange(7,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.getComposition().getStage().speedChange(106,166,500);
         sym.getComposition().getStage().gearChange(3,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.getComposition().getStage().speedChange(166,257,500);
         sym.getComposition().getStage().gearChange(3,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.getComposition().getStage().speedChange(257,323,1200);
         sym.getComposition().getStage().gearChange(5,7,1200);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4250, function(sym, e) {
         sym.getComposition().getStage().speedChange(323,154,500);
         sym.getComposition().getStage().gearChange(7,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4750, function(sym, e) {
         sym.getComposition().getStage().speedChange(154,251,600);
         sym.getComposition().getStage().gearChange(3,5,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5350, function(sym, e) {
         sym.getComposition().getStage().speedChange(251,293,1100);
         sym.getComposition().getStage().gearChange(5,6,1100);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6500, function(sym, e) {
         sym.getComposition().getStage().speedChange(293,218,250);
         sym.getComposition().getStage().gearChange(6,5,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6750, function(sym, e) {
         sym.getComposition().getStage().speedChange(218,231,500);
         sym.getComposition().getStage().gearChange(5,5,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7250, function(sym, e) {
         sym.getComposition().getStage().speedChange(231,76,750);
         sym.getComposition().getStage().gearChange(5,2,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         sym.getComposition().getStage().speedChange(76,104,500);
         sym.getComposition().getStage().gearChange(2,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8500, function(sym, e) {
         sym.getComposition().getStage().speedChange(104,72,900);
         sym.getComposition().getStage().gearChange(2,2,900);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9400, function(sym, e) {
         sym.getComposition().getStage().speedChange(72,235,850);
         sym.getComposition().getStage().gearChange(2,5,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10250, function(sym, e) {
         sym.getComposition().getStage().speedChange(235,130,850);
         sym.getComposition().getStage().gearChange(5,3,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11151, function(sym, e) {
         sym.getComposition().getStage().speedChange(130,276,1350);
         sym.getComposition().getStage().gearChange(3,6,1350);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12750, function(sym, e) {
         sym.getComposition().getStage().speedChange(276,309,1000);
         sym.getComposition().getStage().gearChange(6,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13750, function(sym, e) {
         sym.getComposition().getStage().speedChange(309,315,1250);
         sym.getComposition().getStage().gearChange(7,7,1250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("315");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("BRAMc");
   //Edge symbol end:'BRAMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("BRAmini");
   //Edge symbol end:'BRAmini'

   //=========================================================
   
   //Edge symbol: 'CircuitMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 41, function(sym, e) {
         sym.getComposition().getStage().speedChange(20,290,700);
         sym.getComposition().getStage().gearChange(1,6,700);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 750, function(sym, e) {
         sym.getComposition().getStage().speedChange(290,127,400);
         sym.getComposition().getStage().gearChange(6,3,400);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1150, function(sym, e) {
         sym.getComposition().getStage().speedChange(127,260,600);
         sym.getComposition().getStage().gearChange(3,6,600);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1750, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,254,650);
         sym.getComposition().getStage().gearChange(6,5,650);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2400, function(sym, e) {
         sym.getComposition().getStage().speedChange(254,300,850);
         sym.getComposition().getStage().gearChange(5,7,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3250, function(sym, e) {
         sym.getComposition().getStage().speedChange(300,70,1000);
         sym.getComposition().getStage().gearChange(7,2,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4250, function(sym, e) {
         sym.getComposition().getStage().speedChange(70,260,750);
         sym.getComposition().getStage().gearChange(2,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.getComposition().getStage().speedChange(260,315,800);
         sym.getComposition().getStage().gearChange(6,7,800);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7000, function(sym, e) {
         sym.getComposition().getStage().speedChange(315,81,500);
         sym.getComposition().getStage().gearChange(7,2,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7500, function(sym, e) {
         sym.getComposition().getStage().speedChange(81,125,250);
         sym.getComposition().getStage().gearChange(2,3,250);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7750, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,312,1000);
         sym.getComposition().getStage().gearChange(3,7,1000);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9750, function(sym, e) {
         sym.getComposition().getStage().speedChange(312,128,850);
         sym.getComposition().getStage().gearChange(7,3,850);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10600, function(sym, e) {
         sym.getComposition().getStage().speedChange(128,110,500);
         sym.getComposition().getStage().gearChange(3,3,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11109, function(sym, e) {
         sym.getComposition().getStage().speedChange(110,275,750);
         sym.getComposition().getStage().gearChange(3,6,750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11750, function(sym, e) {
         sym.getComposition().getStage().speedChange(275,113,1500);
         sym.getComposition().getStage().gearChange(6,3,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13250, function(sym, e) {
         sym.getComposition().getStage().speedChange(113,125,1500);
         sym.getComposition().getStage().gearChange(3,3,1500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14500, function(sym, e) {
         sym.getComposition().getStage().speedChange(125,290,500);
         sym.getComposition().getStage().gearChange(3,6,500);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15000, function(sym, e) {
         sym.stop();
         var mySymbolObject = sym.getSymbol("carMc").stop(1);
         sym.$("speed").html("290");
         sym.getComposition().getStage().stopIt();

      });
      //Edge binding end

   })("UAEMc");
   //Edge symbol end:'UAEMc'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'circuitMini'
   (function(symbolName) {   
   
   })("UAEmini");
   //Edge symbol end:'UAEmini'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'GridSlider'
   (function(symbolName) {   
   
   })("GridSlider");
   //Edge symbol end:'GridSlider'

   //=========================================================
   
   //Edge symbol: 'Grid'
   (function(symbolName) {   
   
   })("Grid");
   //Edge symbol end:'Grid'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33835");