/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var clickIcon = 0;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none", "padding":"6px"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"0px", "color":"rgba(50,50,50,1)",
         	"background-color":"white", "height":"auto","width":"auto", "padding":"10px", "padding-bottom":"10px"};
         
         	var monthStyle = {"background-color":"rgba(0,0,0,1)","width":"auto", "padding":"8px", "font-size":"22px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         	if (RTL == false){
         		var datSty = "<div style='clear:both; margin-bottom:2px'><div style='float:left; margin-right:5px; margin-left:0px; border-radius:2px; font-size:18px; font-weight:600; background-color:#660000; color:rgba(255,255,255,1); padding-left:6px; padding-right:6px; padding-top:6px; padding-bottom:6px'>";
         		var eveSty = "<div style='clear:both; margin-bottom:2px'><div style='float:left; margin-right:5px; margin-left:0px; border-radius:2px; font-size:18px; font-weight:600; background-color:#da0000; color:rgba(255,255,255,1); padding-left:6px; padding-right:6px; padding-top:6px; padding-bottom:6px'>";
         		var capSty = "</div><div style='padding-right:5px; padding-left:0px; padding-bottom:1px'>";
         		var endSty = "</div></div>";
         	} else {
         		var datSty = "<div style='clear:both; margin-bottom:2px'><div style='float:right; margin-right:5px; margin-left:6px; border-radius:2px; font-size:18px; font-weight:600; background-color:#660000; color:rgba(255,255,255,1); padding-left:6px; padding-right:6px; padding-top:6px; padding-bottom:6px'>";
         		var eveSty = "<div style='clear:both; margin-bottom:2px'><div style='float:right; margin-right:5px; margin-left:6px; border-radius:2px; font-size:18px; font-weight:600; background-color:#da0000; color:rgba(255,255,255,1); padding-left:6px; padding-right:6px; padding-top:6px; padding-bottom:6px'>";
         		var capSty = "</div><div style='padding-left:5px; padding-left:0px; padding-bottom:1px'>";
         		var endSty = "</div></div>";
         	}
         
         
         //********************************************************************************************************
         // ADD BUTTONS
         //********************************************************************************************************
         imageSymbolArray = []; //the array that will hold references to your new symbols.
         
         function traceSelected (symbolInTheArray){
         		var iconNo = symbolInTheArray.getVariable("id");
         		clickIcon = iconNo;
         		swiped();
         		imageSymbolArray[clickIcon].$("stroke").stop().animate ({opacity:1}, 0);
         }
         
         for (var i = 0; i < 12; i++){
          var mySymbolObject = sym.createChildSymbol("picBtn", "btnsMc");  // Create an instance element of a symbol as a child of the given parent element
          mySymbolObject.setVariable("id", i);  //set the value of a Symbol variable
          imageSymbolArray.push(mySymbolObject);  //push it into the array
         }
         
         $.each(imageSymbolArray, function( count, symbolInTheArray ){ //a 'for each' loop through the newly populated array.
          var menuItem = $(symbolInTheArray); //create jQuery reference to the item - not really needed here but shows how to do it.
          var menuElement = $(symbolInTheArray.getSymbolElement());  //create a jQuery reference to the DIV element inside the symbol.
          menuElement.bind ("click",function(){traceSelected(symbolInTheArray);});
         })
         
         function resetIcon(){
         	for (var i=0; i<12; i++){
         		imageSymbolArray[i].$("pic").stop().animate ({left:-100}, 0);
         		imageSymbolArray[i].$("stroke").stop().animate ({opacity:0}, 0);
         		sym.getSymbol("mainPicMc").$("imageMain"+i).stop().animate({opacity:0}, 100);
         	}
         }
         resetIcon();
         
         for (var i=0; i<imageSymbolArray.length; i++){
         		imageSymbolArray[i].$("pic").stop().animate ({top:-60*i, left:-100}, 0);
         	}
         sym.getSymbol("mainPicMc").$("imageMain"+0).stop().animate({opacity:1}, 100);
         imageSymbolArray[clickIcon].$("stroke").stop().animate ({opacity:1}, 0);
         
         
         //********************************************************************************************************
         // SWIPE
         //********************************************************************************************************
         sym.$("mainPicMc").swipeleft(function(){
         		e.stopPropagation(); e.preventDefault();
         		if (clickIcon > 10) {
         
         		} else {
         			clickIcon++;
         			swiped();
         		}
               });
         
         sym.$("mainPicMc").swiperight(function(){
         		e.stopPropagation(); e.preventDefault();
         		if (clickIcon < 1) {
         
         		} else {
         			clickIcon--;
         			swiped();
         		}
               });
         
         function swiped(){
         	resetIcon();
         	changeMonth();
         	initSize();
         		imageSymbolArray[clickIcon].$("pic").stop().animate ({left:0}, 0);
         		sym.getSymbol("toggleBtn").$("arrowUp").fadeOut(0);
         		sym.getSymbol("toggleBtn").$("arrowDown").fadeIn(0);
         		sym.getSymbol("mainPicMc").$("imageMain"+clickIcon).stop().animate({opacity:1}, 100);
         }
         imageSymbolArray[0].$("pic").stop().animate ({left:0}, 0);
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	txt[0] = sym.$("monthTxt").css(monthStyle);
         	txt[1] = sym.$("capTxt").css(blackTxtBox);
         
         	var monthArr=[];
         	var monthEvents=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33774.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         $(xml).find("month").each(function(){
         		var $month=$(this);
         		var monthname=$month.attr('date');
         		monthArr.push(monthname);
         		monthEvents.push($month);
         });
         		sym.$("monthTxt").css(monthStyle);
         		sym.$("capTxt").css({'font-size':fontSize, 'line-height':lineHeight});
         		},
            complete:function(){
         		changeMonth();
         		initSize();
            }
         	}); // END XML
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         var btnWidth = 8;
         var btnHeight = 60;
         var minHt = 0;
         var maxHt = 0;
         
         sym.$("capTxt").css({'overflow-x':'hidden'});
         
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	if(stageWidth <=600){
         		sym.$("toggleBtn").stop().fadeIn(0);
         		btnWidth = 6;
         		btnHeight = 50;
         		sym.$("btnsMc").stop().animate ({left:0, width:stageWidth, top:42, height:100}, 0);
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		sym.$("mainPicMc").stop().animate ({left:0, top:42 + (btnHeight*2), width:stageWidth, height:stageWidth/1.1}, 0);
         		sym.$("capTxt").stop().animate ({top:560 - sym.$("capTxt").height()+5, scrollTop:0, width:stageWidth-20}, 0);
         		maxHt = 110;
         		minHt = 0;
         
         		if (sym.$("capTxt").height() > 110){
         			sym.$("capTxt").stop().animate({left:0, top:560 - 110, scrollTop:0, width:stageWidth-20}, 0);
         			sym.$("toggleBtn").stop().animate({top: 560 - 45}, 0);
         		} else {
         			sym.$("capTxt").css({'overflow-y':'visible'});
         			sym.$("capTxt").stop().animate ({left:0, top:560 - sym.$("capTxt").height()+10, scrollTop:0, width:stageWidth-20}, 0);
         			sym.$("toggleBtn").animate({top: 560 - sym.$("capTxt").height()-20}, 0);
         		}
         		sym.$("monthTxt").stop().animate ({top:560 - sym.$("capTxt").height()-20, left:0, width:stageWidth-16}, 0);
         
         	}else{
         		sym.$("toggleBtn").stop().fadeOut(0);
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		btnWidth = 9;
         		btnHeight = 60;
         		maxHt = 262;
         		minHt = 262;
         		sym.$("btnsMc").stop().animate ({width:(stageWidth/3), height:540, left:(stageWidth - sym.$("btnsMc").width())}, 0);
         		sym.$("mainPicMc").stop().animate ({left:stageWidth/2-400, top:42}, 0);
         		sym.$("monthTxt").stop().animate ({top:282, left:stageWidth - sym.$("btnsMc").width(), width:(stageWidth/3)-20}, 0);
         		sym.$("capTxt").stop().animate ({top:312, left:stageWidth - sym.$("btnsMc").width(), width:(stageWidth/3)-20}, 0);
         	}
         	if (stageWidth<484){
         		sym.$("toggleBtn").stop().fadeOut(0);
         	}else{
         
         	}
         	setStyle();
         	for (var i=0;i<imageSymbolArray.length;i++){
         		imageSymbolArray[i].getSymbolElement().css({'width':stageWidth/btnWidth});
         		imageSymbolArray[i].getSymbolElement().css({'height':btnHeight});
         		imageSymbolArray[i].getSymbolElement().css({'position':'relative','float':'left'});
         	}
         	sym.$("capTxt").css({'height':'auto', "max-height":maxHt, "min-height":minHt, 'overflow-y':'visible'});
         	sym.getSymbol("toggleBtn").$("arrowDown").fadeIn(50);
         	sym.getSymbol("toggleBtn").$("arrowUp").fadeOut(50);
         }
         initSize();
         
         function changeMonth() {
         		sym.$("monthTxt").html(monthArr[clickIcon]);
         		var $events=monthEvents[clickIcon].find('event');
         		var capTxt= "";
         		$events.each(function(){
         			var $event=$(this);
         			var day=$event.attr("day");
         			var caption=$event.find("caption").text();
         			var pic=$event.attr("pic");
         			var dateStyle=(pic==0)?datSty:eveSty;
         			capTxt += dateStyle+day+capSty+caption+ "<hr>";
         		});
         		capTxt += endSty;	
         		sym.$("capTxt").html(capTxt);
         		}
         
         //********************************************************************************************************
         // TOGGLE BUTTON
         //********************************************************************************************************
         
         sym.getSymbol("toggleBtn").$("arrowUp").fadeOut(0);
         
         sym.$("toggleBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (sym.getSymbol("toggleBtn").$("arrowDown").is(":visible") ) { 
         		sym.getSymbol("toggleBtn").$("arrowDown").fadeOut(50);
         		sym.getSymbol("toggleBtn").$("arrowUp").fadeIn(50);
         		sym.$("capTxt").animate({top: 585}, 200, "easeOutCubic");
         		sym.$("toggleBtn").animate({top: 555}, 200, "easeOutCubic");
         		sym.$("monthTxt").animate({top: 585}, 200, "easeOutCubic");
         	}else{
         		sym.getSymbol("toggleBtn").$("arrowDown").fadeIn(50);
         		sym.getSymbol("toggleBtn").$("arrowUp").fadeOut(50);
         		sym.$("capTxt").animate({top: 560 - sym.$("capTxt").height()+10}, 200, "easeOutCubic");
         		sym.$("toggleBtn").animate({top: 560 - sym.$("capTxt").height()-20}, 200, "easeOutCubic");
         		sym.$("monthTxt").animate({top: 560 - sym.$("capTxt").height()-20}, 200, "easeOutCubic");
         	}
         }); 
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	if (RTL == true){
         		sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none", "padding":"6px", "padding-right":"6px", "text-align":"right"});
         		sym.$("capTxt").css({"pointer-events":"none", "text-align":"right"});
         		sym.$("monthTxt").css({"pointer-events":"none", "text-align":"right"});
         	}
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'btnsMc'
   (function(symbolName) {   
   
   })("btnsMc");
   //Edge symbol end:'btnsMc'

   //=========================================================
   
   //Edge symbol: 'picBtn'
   (function(symbolName) {   
   
   })("picBtn");
   //Edge symbol end:'picBtn'

   //=========================================================
   
   //Edge symbol: 'mainPicMc'
   (function(symbolName) {   
   
   })("mainPicMc");
   //Edge symbol end:'mainPicMc'

   //=========================================================
   
   //Edge symbol: 'txtBtn'
   (function(symbolName) {   
   
   })("txtBtn");
   //Edge symbol end:'txtBtn'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33774");