/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var clicked = 0;
         	var btnNo = 0;
         	var path = 	sym.getSymbol("scrollMc").getSymbol("scrollableMc")
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none", "padding":"6px"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none", "padding":"6px"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "background-color":"white", "padding":"6px", "height":"auto"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var goldTxtBox = {"border-color":"white", "border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"#fbb24c", "height":"auto", "padding":"6px", "padding-bottom":"30px", "box-shadow":"2px 2px 5px rgba(0,0,0,0.3)"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         	var gold  = {"background-color":"#fbb24c"};
         
         //********************************************************************************************************
         // ADD BUTTONS
         //********************************************************************************************************
         imageSymbolArray = []; //the array that will hold references to your new symbols.
         
         function traceSelected (symbolInTheArray){
         		var iconNo = symbolInTheArray.getVariable("id");
         		resetIcon();
         		clickIcon = iconNo;
         		imageSymbolArray[clickIcon].$("bg").css(gold);
         		imageSymbolArray[clickIcon].$("no").css({"color":"black", "font-weight":"bold"});
         		sym.$("txt15").empty();
         		sym.$("txt15").append(txtArr[clickIcon + 15]);
         		sym.$("closeBtn").animate({top:110 + sym.$("txt15").height() + sym.$("standTxt").height() }, 0);
         		sym.$("closeBtn").stop().fadeIn(200);
         		sym.$("txt15").stop().animate ({left:5}, 0, function(){ sym.$("txt15").stop().animate ({opacity:1}, 200); });
         }
         
         for (var i = 0; i < 5; i++){
          var mySymbolObject = sym.createChildSymbol("auxBtn", "rectBtns");  // Create an instance element of a symbol as a child of the given parent element
          mySymbolObject.setVariable("id", i);  //set the value of a Symbol variable
          imageSymbolArray.push(mySymbolObject);  //push it into the array
         }
         
         $.each(imageSymbolArray, function( count, symbolInTheArray ){ //a 'for each' loop through the newly populated array.
          var menuItem = $(symbolInTheArray); //create jQuery reference to the item - not really needed here but shows how to do it.
          var menuElement = $(symbolInTheArray.getSymbolElement());  //create a jQuery reference to the DIV element inside the symbol.
          menuElement.bind ("click",function(){traceSelected(symbolInTheArray);});
         })
         
         function resetIcon(){
         	for (var i=0; i<5; i++){
         		imageSymbolArray[i].$("bg").css(red);
         		imageSymbolArray[i].$("no").css({"color":"white", "font-weight":"normal"});
         		path.$("txt6").stop().animate({opacity:0}, 200);
               path.$("redNoseMc").stop().animate({opacity:0}, 200);
               path.$("pointer").stop().animate({opacity:0}, 200);
         	}
         }
         resetIcon();
         
         for (var i=0;i<imageSymbolArray.length;i++){
         		imageSymbolArray[i].getSymbolElement().css({'position':'relative','float':'left'});
         	}
         
         //********************************************************************************************************
         // SET STAGE
         //********************************************************************************************************
         sym.$("scrollMc").css({'overflow-y':'hidden'});
         sym.$("txt15").stop().animate ({opacity:0, left:-800}, 0);
         path.$("txt6").stop().animate({opacity:1}, 200);
         path.$("redNoseMc").stop().animate({opacity:1}, 200);
         path.$("pointer").stop().animate({opacity:1}, 200);
         sym.$("closeBtn").fadeOut(0);
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         
         	for (var i=0; i<5; i++){
         		txt[i] = imageSymbolArray[i].$("no").css({"pointer-events":"none"});
         	}
         	for (var i=5; i<15; i++){
         		txt[i] = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[15] = sym.$("txt15").css(goldTxtBox);
         	txt[16] = sym.$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.$("txt17").css({"pointer-events":"none"});
         	txt[18] = sym.$("txt18").css({"pointer-events":"none"});
         	txt[19] = sym.$("txt19").css({"pointer-events":"none"});
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33758.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<20; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize, 'line-height':lineHeight});
         			}
         			sym.$("closeBtn").animate({top:110 + sym.$("txt15").height() + sym.$("standTxt").height() }, 0);
         			sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt6").css({'height':"auto"});
         			path.$("txt6").animate({top:0 + sym.$("txt15").height() + sym.$("standTxt").height() +20}, 0);
         			path.$("txt5").animate({top:450 - path.$("txt5").height() + 0}, 0);
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("rectBtns").stop().animate({top:40 + sym.$("standTxt").height()+10}, 0);
         	sym.$("txt15").stop().animate({top:90 + sym.$("standTxt").height()+10}, 0);
         
         	if(stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		sym.$("scrollMc").css({'overflow-x':'visible'});
         		path.$("txt5").stop().animate({opacity:0}, 0);
         		sym.getSymbol("scrollMc").$("scrollableMc").css('cursor', 'ew-resize'); // SCROLL CODE
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		sym.$("scrollMc").css({'overflow-x':'hidden'});
         		path.$("txt5").stop().animate({opacity:1}, 0);
         		sym.getSymbol("scrollMc").$("scrollableMc").css('cursor', 'default'); // SCROLL CODE
         	}
         
         	setStyle();
         	scrollPos();
         	sym.$("closeBtn").animate({top:110 + sym.$("txt15").height() + sym.$("standTxt").height() }, 0);
         	path.$("txt6").animate({top:40 + sym.$("standTxt").height() +0}, 0);
         	path.$("redNoseMc").animate({top:40 + sym.$("standTxt").height() + path.$("txt6").height() +5}, 0);
         }
         
         //********************************************************************************************************
         // MOUSE SCROLL SYMBOL
         //********************************************************************************************************
         var x,left,down;
         sym.$("scrollMc").on('touchstart mousedown', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=true;
         	x=e.pageX;
         	left=$(this).scrollLeft();
         });
         
         sym.$("scrollMc").on('touchmove mousemove', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(down){
         		var newX=e.pageX;
         		sym.$("scrollMc").scrollLeft(left-newX+x);    
         	}
         });
         sym.$("scrollMc").on('touchend mouseup', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=false;
         });
         
         sym.$("scrollMc").scroll(function() {
         	scrollPos();
         });
         
         function scrollPos(){
         	resetIcon();
         	var stageWidth=sym.$("Stage").width();
         	var width = sym.$("scrollMc").scrollLeft();
             if(width  < 1) {
                path.$("txt6").stop().animate({opacity:1}, 200);
                path.$("redNoseMc").stop().animate({opacity:1}, 200);
                path.$("pointer").stop().animate({opacity:1}, 200);
             } else if (width  > (480-stageWidth)-10) {
                path.$("txt5").stop().animate({opacity:1}, 200);
         
             } else {
             	path.$("txt6").stop().animate({opacity:0}, 200);
               path.$("redNoseMc").stop().animate({opacity:0}, 200);
               path.$("pointer").stop().animate({opacity:0}, 200);
               path.$("txt5").stop().animate({opacity:0}, 200);
             }
         	sym.$("closeBtn").stop().fadeOut(200);
         	sym.$("txt15").stop().animate ({opacity:0}, 200, function(){ sym.$("txt15").stop().animate ({left:-800}, 0); });
         
         }
         //********************************************************************************************************
         // CLOSE BUTTON
         //********************************************************************************************************
         sym.$("closeBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	scrollPos();
         	});
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         
         	if (RTL == true){
         		sym.$("standTxt").css({"text-align":"right", "padding-top":"6px"});
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "text-align":"right", "padding-top":"6px"});
         		for (var i=0;i<imageSymbolArray.length;i++){
         		imageSymbolArray[i].getSymbolElement().css({'position':'relative','float':'right'});
         		sym.$("txt15").css({"text-align":"right"});
         	}
         	}
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'rectBtns'
   (function(symbolName) {   
   
   })("rectBtns");
   //Edge symbol end:'rectBtns'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'closeBtn'
   (function(symbolName) {   
   
   })("closeBtn");
   //Edge symbol end:'closeBtn'

   //=========================================================
   
   //Edge symbol: 'redNoseMc'
   (function(symbolName) {   
   
   })("redNoseMc");
   //Edge symbol end:'redNoseMc'

   //=========================================================
   
   //Edge symbol: 'auxBtn'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNews33758");