/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var clicked = 0;
         	var btnNo = 0;
         	var clickIcon = 0;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none", "padding":"6px"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	sym.$("txt0").css({'height':'auto', "max-height":"110px", 'overflow-x':'hidden'});
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"0px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"10px","border-bottom":"solid 10px rgba(0,0,0,1)"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         
         //********************************************************************************************************
         // ADD BUTTONS
         //********************************************************************************************************
         imageSymbolArray = []; //the array that will hold references to your new symbols.
         function traceSelected (symbolInTheArray){
         		var iconNo = symbolInTheArray.getVariable("id");
         		clickIcon = iconNo;
         		swiped();
         }
         
         for (var i = 0; i < 18; i++){
          var mySymbolObject = sym.createChildSymbol("picBtn", "btnsMc");  // Create an instance element of a symbol as a child of the given parent element
          mySymbolObject.setVariable("id", i);  //set the value of a Symbol variable
          imageSymbolArray.push(mySymbolObject);  //push it into the array
         }
         
         $.each(imageSymbolArray, function( count, symbolInTheArray ){ //a 'for each' loop through the newly populated array.
          var menuItem = $(symbolInTheArray); //create jQuery reference to the item - not really needed here but shows how to do it.
          var menuElement = $(symbolInTheArray.getSymbolElement());  //create a jQuery reference to the DIV element inside the symbol.
          menuElement.bind ("click",function(){traceSelected(symbolInTheArray);});
         })
         
         function resetIcon(){
         	for (var i=0; i<18; i++){
         		imageSymbolArray[i].$("pic").stop().animate ({left:-100}, 0);
         		sym.getSymbol("mainPicMc").$("imageMain"+i).stop().animate({opacity:0}, 100);
         	}
         }
         resetIcon();
         
         for (var i=0; i<imageSymbolArray.length; i++){
         		imageSymbolArray[i].$("pic").stop().animate ({top:-60*i, left:-100}, 0);
         	}
         sym.getSymbol("mainPicMc").$("imageMain"+0).stop().animate({opacity:1}, 100);
         
         //********************************************************************************************************
         // SWIPE
         //********************************************************************************************************
         sym.$("mainPicMc").swipeleft(function(){
         		e.stopPropagation(); e.preventDefault();
         		if (clickIcon > 16) {
         
         		} else {
         			clickIcon++;
         			swiped();
         		}
               });
         
         sym.$("mainPicMc").swiperight(function(){
         		e.stopPropagation(); e.preventDefault();
         		if (clickIcon < 1) {
         
         		} else {
         			clickIcon--;
         			swiped();
         		}
               });
         
         function swiped(){
         	resetIcon();
         		imageSymbolArray[clickIcon].$("pic").stop().animate ({left:0}, 0);
         		sym.getSymbol("toggleBtn").$("arrowUp").fadeOut(0);
         		sym.getSymbol("toggleBtn").$("arrowDown").fadeIn(0);
         		sym.getSymbol("mainPicMc").$("imageMain"+clickIcon).stop().animate({opacity:1}, 100);
         		sym.$("txt0").html(txtArr[clickIcon]);
         		initSize();
         }
         imageSymbolArray[0].$("pic").stop().animate ({left:0}, 0);
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         	txt[0] = sym.$("txt0").css(blackTxtBox);
         	for (var i=1; i<18; i++){
         		txt[i] = sym.$("txt"+i).css({"pointer-events":"none"});
         	}
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33749.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<18; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         		},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         var btnWidth = 8;
         var btnHeight = 60;
         
         	function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	var capHeight= sym.$("txt0").height();
         	if(stageWidth<801){
         		sym.$("btnsMc").stop().animate ({width:stageWidth/4, height:540}, 0);
         		btnWidth = 8;
         		btnHeight = 60;
         		sym.$("mainPicMc").stop().animate ({left:(stageWidth/4), top:42, width:(stageWidth/4)*3, height:(stageWidth/4)*2.8}, 0);
         		sym.$("txt0").stop().animate ({left:(stageWidth/4), width:(stageWidth/4)*3-20}, 0);
         	}
         
         	if(stageWidth>769){
         		sym.$("toggleBtn").fadeIn(0);
         	}else if(stageWidth<770&&stageWidth>640){
         		sym.$("toggleBtn").fadeOut(0);
         	}else if(stageWidth<641&&stageWidth>429){
         		sym.$("toggleBtn").fadeIn(0);
         	}else{
         		sym.$("toggleBtn").fadeOut(0);
         	}
         	if(stageWidth<640){
         		sym.$("btnsMc").stop().animate ({width:stageWidth, top:42, height:100}, 0);
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		btnWidth = 9;
         		btnHeight = 50;
         		sym.$("mainPicMc").stop().animate ({left:0, top:42 + (btnHeight*2), width:stageWidth, height:stageWidth/1.1}, 0);
         		sym.$("txt0").stop().animate ({left:0, width:stageWidth-20}, 0);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	if (stageWidth<480){
         		btnWidth = 6;
         		sym.$("btnsMc").stop().animate ({width:stageWidth, top:42, height:150}, 0);
         		sym.$("mainPicMc").stop().animate ({left:0, top:92 + (btnHeight*2), width:stageWidth, height:stageWidth/1.1}, 0);
         	}
         	setStyle();
         	for (var i=0;i<imageSymbolArray.length;i++){
         		imageSymbolArray[i].getSymbolElement().css({'width':Math.floor(stageWidth/btnWidth),'height':btnHeight,'position':'relative','float':'left'});
         	}
         	sym.getSymbol("toggleBtn").$("arrowDown").fadeIn(50);
         	sym.getSymbol("toggleBtn").$("arrowUp").fadeOut(50);
         	sym.$("txt0").stop().animate({top:560 - capHeight-5, scrollTop: 0}, 200, "easeOutCubic");
         	sym.$("toggleBtn").stop().animate({top: 560 - capHeight-30}, 200, "easeOutCubic");
         }
         
         //********************************************************************************************************
         // TOGGLE BUTTON
         //********************************************************************************************************
         sym.getSymbol("toggleBtn").$("arrowUp").fadeOut(0);
         
         sym.$("toggleBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (sym.getSymbol("toggleBtn").$("arrowDown").is(":visible") ) { 
         		sym.getSymbol("toggleBtn").$("arrowDown").fadeOut(50);
         		sym.getSymbol("toggleBtn").$("arrowUp").fadeIn(50);
         		sym.$("txt0").animate({top: 585}, 500, "easeOutCubic");
         		sym.$("toggleBtn").animate({top: 555}, 495, "easeOutCubic");
         	}else{
         		sym.getSymbol("toggleBtn").$("arrowDown").fadeIn(50);
         		sym.getSymbol("toggleBtn").$("arrowUp").fadeOut(50);
         		sym.$("txt0").animate({top: 560 - sym.$("txt0").height()-5}, 500, "easeOutCubic");
         		sym.$("toggleBtn").animate({top: 560 - sym.$("txt0").height()-30}, 500, "easeOutCubic");
         	}
         }); 
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	if (RTL == true){
         		sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none", "padding":"6px", "padding-right":"6px", "text-align":"right"});
         		sym.$("txt0").css({"pointer-events":"none", "text-align":"right"});
         		sym.$("txt0").attr("dir","rtl");	sym.getSymbol("styleHead").$("headlineTxt").attr("dir","rtl");
         	}
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'btnsMc'
   (function(symbolName) {   
   
   })("btnsMc");
   //Edge symbol end:'btnsMc'

   //=========================================================
   
   //Edge symbol: 'picBtn'
   (function(symbolName) {   
   
   })("picBtn");
   //Edge symbol end:'picBtn'

   //=========================================================
   
   //Edge symbol: 'mainPicMc'
   (function(symbolName) {   
   
   })("mainPicMc");
   //Edge symbol end:'mainPicMc'

   //=========================================================
   
   //Edge symbol: 'txtBtn'
   (function(symbolName) {   
   
   })("txtBtn");
   //Edge symbol end:'txtBtn'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33749");