/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var RTL = false; // RIGHT TO LEFT
         	var mob = 0;
         	var paraVis = false;
         	var clicked = 0;
         	var btnNo = 0;
         	var standIn = false;
         	
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none", "padding":"5px"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var path = sym.getSymbol("scrollMc").getSymbol("scrollableMc")
         	var parkPath = sym.getSymbol("oParkMc").getSymbol("olyPark")
         	
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var blackTxtBox = {"font-size":"14px", "border-color":"white", "border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(50,50,50,1)", "height":"auto","width":"auto", "padding":"6px", "padding-right":"6px"};
         
         	var greenTxtBox = {"font-size":"14px", "border-color":"white", "border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"#00a551", "height":"auto", "width":"auto", "padding":"6px", "padding-right":"6px"};
         
         	var redTxtBox = {"font-size":"13px", "border-color":"white", "border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"#da0000", "padding":"6px", "height":"auto"};
         
         	var yellowTxtBox = {"font-size":"14px", "border-color":"white", "border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"black",
         	"background-color":"#ed9b00", "padding":"6px", "height":"auto"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var grey2  = {"background-color":"rgba(160,160,160,0.5)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         	var blackTxt  = {"color":"rgba(0,0,0,1)"};
         	var whiteTxt  = {"color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // MENU TEXT START
         //********************************************************************************************************
         	var menuTxt=[];
         	menuTxt[0] = sym.getSymbol("menuBtnsMc").$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[1] = sym.$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[2] = sym.$("menuTxt").css({"pointer-events":"none"});
         	var menuArr=[];
         
         //********************************************************************************************************
         // ADD OLYMPIC BUTTONS
         //********************************************************************************************************
         imageSymbolArray = []; //the array that will hold references to your new symbols.
         
         function traceSelected (symbolInTheArray){
         		var iconNo = symbolInTheArray.getVariable("id");
         
         		path.$("dotsMc").stop().animate({opacity:1}, 200);
         		closeCeremony();
         		clickIcon = iconNo;
         		resetIcon();
         
         		imageSymbolArray[iconNo].$("bg").css(red);
         		imageSymbolArray[iconNo].$("txt").css({'color':'white', 'font-weight':'bold'});
         
         		path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").empty();
         		path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").append(txtArr[iconNo + 73]);
         		path.getSymbol("dotsMc").getSymbol("redDotMc2").$("venTxt").empty();
         		path.getSymbol("dotsMc").getSymbol("redDotMc2").$("venTxt").append(txtArr[87]);
         		openSoccer();
         
         		if (iconNo == 0){ clickIcon = 0; rioView(); };
         		if (iconNo == 1){ clickIcon = 0; rioView(); };
         		if (iconNo == 2){ clickIcon = 2; rioView(); };
         		if (iconNo == 3){ clickIcon = 1; rioView(); };
         		if (iconNo == 4){ clickIcon = 3; rioView(); };
         		if (iconNo == 5){ clickIcon = 4; rioView(); };
         		if (iconNo == 6){ clickIcon = 4; rioView(); };
         		if (iconNo == 7){ clickIcon = 5; rioView(); };
         		if (iconNo == 8){ clickIcon = 5; rioView(); };
         		if (iconNo == 9){ clickIcon = 6; rioView(); };
         		if (iconNo == 10){ clickIcon = 7; closeSoccer(); rioView(); reg1(); };
         		if (iconNo == 11){ clickIcon = 7; closeSoccer(); rioView(); reg1(); };
         		if (iconNo == 12){ clickIcon = 8; path.getSymbol("dotsMc").$("redDotMc2").fadeIn(0); rioView(); reg1();
         		} else { 
         			path.getSymbol("dotsMc").$("redDotMc2").fadeOut(0);
         		};
         		if (iconNo == 13){ clickIcon = 8; closeSoccer(); rioView(); reg1(); };
         		if (iconNo == 14){ clickIcon = 9; clear(); path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").append(txtArr[88]); rioView(); reg1(); };
         		if (iconNo == 15){ clickIcon = 10; clear(); path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").append(txtArr[89]); rioView(); reg1(); };
         		if (iconNo == 16){ clickIcon = 10; clear(); path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").append(txtArr[90]); rioView(); reg1(); };
         		if (iconNo == 17){ clickIcon = 11; clear(); path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").append(txtArr[91]); closeSoccer(); rioView(); reg2(); };
         		if (iconNo == 18){ clickIcon = 12; clear(); path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").append(txtArr[92]); closeSoccer(); rioView(); reg2(); };
         		if (iconNo == 19){ clickIcon = 13; clear(); path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").append(txtArr[93]); closeSoccer(); rioView(); reg2(); };
         		if (iconNo == 20){ clickIcon = 13; clear(); path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").append(txtArr[94]); closeSoccer(); rioView(); reg1(); };
         		if (iconNo == 21){ clickIcon = 13; clear(); path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").append(txtArr[95]); closeSoccer(); rioView(); reg1(); };
         		if (iconNo == 22){ clickIcon = 14; clear(); path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").append(txtArr[96]); rioView(); reg0(); };
         		if (iconNo == 23){ clickIcon = 14; clear(); path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").append(txtArr[97]); rioView(); reg0(); };
         		if (iconNo == 24){ clickIcon = 14; clear(); path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").append(txtArr[98]); rioView(); reg0(); };
         		if (iconNo == 25){ clickIcon = 14; clear(); path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").append(txtArr[99]); rioView(); reg0(); };
         		if (iconNo == 26){ clickIcon = 15; clear(); path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").append(txtArr[100]); rioView(); reg0(); };
         		if (iconNo == 27){ clickIcon = 16; clear(); path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").append(txtArr[101]);
         			path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").stop().animate({top: -30}, 0); 
         			rioView(); reg0();
         		} else {
         			path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").stop().animate({top: 0}, 0);
         		}
         
         		if (iconNo == 28){ clickIcon = 0; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[103]); parkView(); }
         		if (iconNo == 29){ clickIcon = 1; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[104]); parkView(); }
         		if (iconNo == 30){ clickIcon = 1; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[105]); parkView(); }
         		if (iconNo == 31){ clickIcon = 1; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[106]); parkView(); }
         		if (iconNo == 32){ clickIcon = 2; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[107]); parkView(); }
         		if (iconNo == 33){ clickIcon = 2; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[108]); parkView(); }
         		if (iconNo == 34){ clickIcon = 3; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[109]); parkView(); }
         		if (iconNo == 35){ clickIcon = 4; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[110]); parkView(); 
         			parkPath.getSymbol("redDotPark").$("venTxt").stop().css('width','150px');
         			sym.$("oParkMc").stop().animate({scrollLeft:200}, 250, 'easeOutCubic');
         		} else {
         			parkPath.getSymbol("redDotPark").$("venTxt").stop().css('width','200px');
         		}
         		if (iconNo == 36){ clickIcon = 4; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[111]); parkView(); 
         			parkPath.getSymbol("redDotPark").$("venTxt").stop().css('width','150px');
         			sym.$("oParkMc").stop().animate({scrollLeft:200}, 250, 'easeOutCubic');
         		}
         		if (iconNo == 37){ clickIcon = 5; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[112]); parkView(); }
         		if (iconNo == 38){ clickIcon = 5; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[113]); parkView(); }
         		if (iconNo == 39){ clickIcon = 6; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[114]); parkView(); }
         		if (iconNo == 40){ clickIcon = 7; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[115]); parkView(); sym.$("oParkMc").stop().animate({scrollLeft:200}, 250, 'easeOutCubic'); }
         		if (iconNo == 41){ clickIcon = 8; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[116]); parkView(); }
         
         		function rioView(){
         			sym.$("oParkMc").fadeOut(0);
         			path.getSymbol("dotsMc").$("redDotMc").fadeIn(0);
         			var x = path.getSymbol("dotsMc").$("stadDot" + (clickIcon)).position();
         			var y = path.getSymbol("dotsMc").$("stadDot" + (clickIcon)).position();
         			path.getSymbol("dotsMc").$("redDotMc").stop().animate({opacity:1, left: x.left-8, top: y.top-8}, 100);
         			sym.$("scrollMc").stop().animate({scrollLeft:100}, 250, 'easeOutCubic');
         		}
         
         		function parkView(){
         			sym.$("oParkMc").stop().fadeIn(0);
         			path.getSymbol("dotsMc").$("redDotMc").fadeOut(0);
         			var x = parkPath.$("stadDot" + (clickIcon)).position();
         			var y = parkPath.$("stadDot" + (clickIcon)).position();
         			parkPath.$("redDotPark").stop().animate({left: x.left-8, top: y.top-8}, 100);
         			sym.$("oParkMc").stop().animate({scrollLeft:150}, 250, 'easeOutCubic');
         		}
         }
         
         for (var i = 0; i < 42; i++){
          var mySymbolObject = sym.createChildSymbol("iconBtn", "btnsMc");  // Create an instance element of a symbol as a child of the given parent element
          mySymbolObject.setVariable("id", i);  //set the value of a Symbol variable
          imageSymbolArray.push(mySymbolObject);  //push it into the array
         }
         
         $.each(imageSymbolArray, function( count, symbolInTheArray ){ //a 'for each' loop through the newly populated array.
          var menuItem = $(symbolInTheArray); //create jQuery reference to the item - not really needed here but shows how to do it.
          var menuElement = $(symbolInTheArray.getSymbolElement());  //create a jQuery reference to the DIV element inside the symbol.
          menuElement.bind ("click",function(){traceSelected(symbolInTheArray);});
         })
         
         for (var i=0; i<imageSymbolArray.length; i++){
         	imageSymbolArray[i].$("icon").animate ({top:-51 * i}, 0);
         }
         //------------------------------------------------------------------------------------------------------
         function resetIcon(){
         	for (var i=0; i<imageSymbolArray.length; i++){
         		imageSymbolArray[i].$("bg").css('background-color', 'white');
         		imageSymbolArray[i].$("txt").css({'color':'grey', 'font-weight':'normal'});
         	}
         	for (var p=28; p<imageSymbolArray.length; p++){
         		imageSymbolArray[p].$("bg").css('background-color', "rgba(0,165,81,1)");
         		imageSymbolArray[p].$("txt").css({'color':'white', 'font-weight':'normal'});
         	}
         }
         resetIcon();
         
         //********************************************************************************************************
         // ADD PARA BUTTONS
         //********************************************************************************************************
         paraSymbolArray = []; //the array that will hold references to your new symbols.
         
         function paraSelected (symbolInTheArray){ //a function to call to make sure we know it’s working!
         		var paraNo = symbolInTheArray.getVariable("paraid");
         		path.$("paraDotsMc").stop().animate({opacity:1}, 200);
         		closeCeremony();
         		clickPara = paraNo;
         		resetPara();
         
         		paraSymbolArray[paraNo].$("bg").css(red);
         		paraSymbolArray[paraNo].$("txt").css({'color':'white', 'font-weight':'bold'});
         
         		path.getSymbol("paraDotsMc").getSymbol("redDotMc").$("venTxt").empty();
         		path.getSymbol("paraDotsMc").getSymbol("redDotMc").$("venTxt").append(txtArr[paraNo + 117]);
         		parkPath.$("redDotPark2").stop().animate({opacity:0}, 0);
         
         		if (paraNo == 0){ clickPara = 0; rioParaView(); };
         		if (paraNo == 1){ clickPara = 1; rioParaView(); };
         		if (paraNo == 2){ clickPara = 2; rioParaView(); };
         		if (paraNo == 3){ clickPara = 3; rioParaView(); };
         		if (paraNo == 4){ clickPara = 4; rioParaView(); reg1(); };
         		if (paraNo == 5){ clickPara = 5; rioParaView(); reg1(); };
         		if (paraNo == 6){ clickPara = 6; rioParaView(); reg2(); };
         		if (paraNo == 7){ clickPara = 7; rioParaView(); reg1(); };
         		if (paraNo == 8){ clickPara = 7; rioParaView(); reg2(); };
         		if (paraNo == 9){ clickPara = 8; rioParaView(); reg2(); };
         		if (paraNo == 10){ clickPara = 8; rioParaView(); reg2(); };
         		if (paraNo == 11){ clickPara = 9; rioParaView(); };
         		if (paraNo == 12){ clickPara = 9; rioParaView(); };
         		if (paraNo == 13){ clickPara = 9; rioParaView(); };
         		if (paraNo == 14){ clickPara = 10; rioParaView();
         			path.getSymbol("paraDotsMc").getSymbol("redDotMc").$("venTxt").stop().animate({top:-30}, 0); 
         			rioParaView(); reg0();
         		} else {
         			path.getSymbol("paraDotsMc").getSymbol("redDotMc").$("venTxt").stop().animate({top:0}, 0); 
         		}
         
         		if (paraNo == 15){ clickPara = 0; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[132]); parkParaView(); parkPath.$("redDotPark2").stop().animate({opacity:1}, 0); reg1(); }
         		if (paraNo == 16){ clickPara = 0; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[133]); parkParaView(); reg1(); }
         		if (paraNo == 17){ clickPara = 1; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[134]); parkParaView(); reg1(); }
         		if (paraNo == 18){ clickPara = 2; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[135]); parkParaView(); reg1(); }
         		if (paraNo == 19){ clickPara = 3; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[136]); parkParaView(); reg1(); }
         		if (paraNo == 20){ clickPara = 5; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[137]); parkParaView(); reg3(); }
         		if (paraNo == 21){ clickPara = 6; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[138]); parkParaView(); reg3(); }
         		if (paraNo == 22){ clickPara = 6; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[139]); parkParaView(); reg3(); }
         		if (paraNo == 23){ clickPara = 7; clear(); parkPath.getSymbol("redDotPark").$("venTxt").append(txtArr[141]); parkParaView(); reg3(); }
         
         		function rioParaView(){
         			sym.$("oParkMc").fadeOut(0);
         			path.getSymbol("paraDotsMc").$("redDotMc").fadeIn(0);
         			var x = path.getSymbol("paraDotsMc").$("stadDot" + (clickPara)).position();
         			var y = path.getSymbol("paraDotsMc").$("stadDot" + (clickPara)).position();
         			path.getSymbol("paraDotsMc").$("redDotMc").stop().animate({opacity:1, left: x.left-8, top: y.top-8}, 100);
         			sym.$("scrollMc").stop().animate({scrollLeft:100}, 250, 'easeOutCubic');
         		}
         
         		function parkParaView(){
         			sym.$("oParkMc").stop().fadeIn(0);
         			path.getSymbol("paraDotsMc").$("redDotMc").fadeOut(0);
         			var x = parkPath.$("stadDot" + (clickPara)).position();
         			var y = parkPath.$("stadDot" + (clickPara)).position();
         			parkPath.$("redDotPark").stop().animate({left: x.left-8, top: y.top-8}, 100);
         			sym.$("oParkMc").stop().animate({scrollLeft:150}, 250, 'easeOutCubic');
         		}
         }
         
         for (var i = 0; i < 24; i++){
          var mySymbolObject = sym.createChildSymbol("iconParaBtn", "paraBtnsMc");  // Create an instance element of a symbol as a child of the given parent element
          mySymbolObject.setVariable("paraid", i);  //set the value of a Symbol variable
          paraSymbolArray.push(mySymbolObject);  //push it into the array
         }
         
         $.each(paraSymbolArray, function( count, symbolInTheArray ){ //a 'for each' loop through the newly populated array.
          var paraItem = $(symbolInTheArray); //create jQuery reference to the item - not really needed here but shows how to do it.
          var paraElement = $(symbolInTheArray.getSymbolElement());  //create a jQuery reference to the DIV element inside the symbol.
          paraElement.bind ("click",function(){paraSelected(symbolInTheArray);});
         })
         
         for (var i=0; i<paraSymbolArray.length; i++){
         	paraSymbolArray[i].$("icon").animate ({top:-51 * i}, 0);
         }
         function resetPara(){
         	for (var i=0; i<paraSymbolArray.length; i++){
         		paraSymbolArray[i].$("bg").css('background-color', 'white');
         		paraSymbolArray[i].$("txt").css({'color':'grey', 'font-weight':'normal'});
         	}
         	for (var p=15; p<paraSymbolArray.length; p++){
         		paraSymbolArray[p].$("bg").css('background-color', "rgba(0,165,81,1)");
         		paraSymbolArray[p].$("txt").css({'color':'white', 'font-weight':'normal'});
         	}
         }
         sym.$("paraBtnsMc").css({'background-color':'#fff'});
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var txt=[];
         		txt[0] = sym.$("txt0").css({"pointer-events":"none"});
         	for (var i=1; i<14; i++){
         		txt[i] = path.$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=14; i<25; i++){
         		txt[i] = sym.getSymbol("soccerMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=0; i<imageSymbolArray.length; i++){
         		txt[i+25] = imageSymbolArray[i].$("txt").css({"pointer-events":"none"});
         	}
         	for (var i=67; i<73; i++){
         		txt[i] = sym.getSymbol("oParkMc").getSymbol("olyPark").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=73; i<102; i++){
         		txt[i] = sym.$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[102] = sym.getSymbol("oParkMc").$("txt102").css({"pointer-events":"none"});
         	for (var i=103; i<142; i++){
         		txt[i] = sym.$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=0; i<paraSymbolArray.length; i++){
         		txt[i+142] = paraSymbolArray[i].$("txt").css({"pointer-events":"none"});
         	}
         	txt[166] = path.getSymbol("ceremonyDotMc").$("txt166").css(yellowTxtBox);
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33738.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			// MENU TEXT START
         			for (var i=0; i<3; i++){
         				menuArr[i]=$(xml).find('menuTxt'+i).text();
         				menuTxt[i].html(menuArr[i]);
         			} // MENU TEXT END
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<168; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				if(i<167){
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         				}
         			}
         			for (var i=0; i<imageSymbolArray.length; i++){
         				imageSymbolArray[i].$("txt").css({'font-size':'13px', 'line-height':'15px'});
         			}
         			for (var i=0; i<paraSymbolArray.length; i++){
         				paraSymbolArray[i].$("txt").css({'font-size':'13px', 'line-height':'15px'});
         			}
         
         			sym.$("txt0").css({'font-size':'16px', 'line-height':'16px', "width":"auto"});
         			sym.$("txt0Bg").stop().animate({width:sym.$("txt0").width()+20}, 0);
         			path.$("txt2").css(blackTxtBox);
         			path.$("txt3").css(blackTxtBox);
         			path.$("txt4").css({'font-size':'18px', 'line-height':'18px'});
         			path.$("txt6").css(blackTxtBox);
         			path.$("txt5").css(whiteTxtBox);
         			path.$("txt7").css(greenTxtBox);
         			path.$("txt8").css(blackTxtBox);
         			path.$("txt13").css({'font-size':'12px', 'line-height':'20px'});
         			path.$("regBtn0").animate({left:163 + path.$("txt2").width()+7}, 0);
         			path.$("regBtn1").animate({left:359 + path.$("txt3").width()+7}, 0);
         			path.$("regBtn2").animate({left:567 + path.$("txt6").width()+7}, 0);
         			path.$("regBtn3").animate({left:124 + path.$("txt8").width()+7}, 0);
         			path.$("regBtn4").animate({left:240 + path.$("txt7").width()+7}, 0);
         			sym.getSymbol("soccerMc").$("txt14").css({'font-size':'16px', 'line-height':'18px'});
         			sym.getSymbol("soccerMc").$("txt20").css({'font-size':'12px', 'line-height':'18px'});
         			path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").css(redTxtBox)
         			path.getSymbol("dotsMc").getSymbol("redDotMc2").$("venTxt").css(redTxtBox)
         			parkPath.getSymbol("redDotPark").$("venTxt").css(redTxtBox)
         			sym.getSymbol("oParkMc").$("txt102").css({'font-size':'16px'});
         			path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").empty();
         			path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").append(txtArr[73]);
         			path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").css('width','150px');
         			path.getSymbol("dotsMc").getSymbol("redDotMc2").$("venTxt").css('width','150px');
         
         			path.getSymbol("paraDotsMc").getSymbol("redDotMc").$("venTxt").css(redTxtBox)
         			path.getSymbol("paraDotsMc").getSymbol("redDotMc").$("venTxt").empty();
         			path.getSymbol("paraDotsMc").getSymbol("redDotMc").$("venTxt").append(txtArr[117]);
         			path.getSymbol("paraDotsMc").getSymbol("redDotMc").$("venTxt").css('width','150px', redTxtBox);
         
         			parkPath.getSymbol("redDotPark2").$("venTxt").empty();
         			parkPath.getSymbol("redDotPark2").$("venTxt").append(txtArr[140]);
         			parkPath.getSymbol("redDotPark2").$("venTxt").css(redTxtBox);
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //********************************************************************************************************
         // SET STAGE
         //********************************************************************************************************
         sym.$("btnsMc").css({'overflow-x':'hidden'});
         sym.$("paraBtnsMc").css({'overflow-x':'hidden'});
         sym.$("scrollMc").css({'overflow-y':'hidden'});
         path.$("ceremonyDotMc").stop().animate({opacity:0}, 0);
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	closeCeremony();
         	var stageWidth=sym.$("Stage").width();
         	sym.$("oParkMc").css({'overflow-y':'hidden'});
         	sym.getSymbol("soccerMc").getSymbol("standBtn").$("arrow").css({"transform":"scaleX(-1)"});
         	sym.$("soccerMc").stop().animate({left:stageWidth-50}, 0);
         	standIn = false;
         
         	if(stageWidth<800){
         		sym.getSymbol("scrollMc").$("scrollableMc").css('cursor', 'ew-resize'); // SCROLL CODE
         		sym.$("soccerMc").animate({left:stageWidth-50}, 0);
         		sym.getSymbol("soccerMc").$("standBtn").fadeIn(0);
         		sym.$("btnsMc").css({'overflow-y':'visible'});
         		sym.$("paraBtnsMc").css({'overflow-y':'visible'});
         	}else{
         		sym.getSymbol("scrollMc").$("scrollableMc").css('cursor', 'default'); // SCROLL CODE
         		sym.$("soccerMc").animate({left:stageWidth-320}, 0);
         		sym.getSymbol("soccerMc").$("standBtn").fadeOut(0);
         	}
         	if(stageWidth<640){
         		sym.$("txt0Bg").stop().animate({opacity:0}, 0);
         		sym.$("txt0").stop().animate({opacity:0}, 0);
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeOut(0);
         	}else{
         		sym.$("txt0Bg").stop().animate({opacity:1}, 0);
         		sym.$("txt0").stop().animate({opacity:1}, 0);
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeIn(0);
         	}
         	if(stageWidth<500){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		sym.$("oParkMc").stop().animate({width:stageWidth}, 0);
         		sym.$("oParkMc").css({'overflow-x':'visible'});
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		sym.$("oParkMc").css({'overflow-x':'hidden'});
         		sym.$("oParkMc").stop().animate({width:500}, 0);
         	}
         	var colNo = (stageWidth/165).toFixed(0);
         	var btnWidth = (stageWidth-15)/colNo;
         	for (var i=0;i<imageSymbolArray.length;i++){
         		imageSymbolArray[i].getSymbolElement().css({'width':btnWidth});
         		imageSymbolArray[i].getSymbolElement().css({'position':'relative','float':'left'});
         	}
         	for (var i=0;i<paraSymbolArray.length;i++){
         		paraSymbolArray[i].getSymbolElement().css({'width':btnWidth});
         		paraSymbolArray[i].getSymbolElement().css({'position':'relative','float':'left'});
         	}
         	setStyle();
         }
         
         //********************************************************************************************************
         // MENU BUTTONS
         //********************************************************************************************************
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<2; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(grey);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		closeCeremony();
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(red);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[menuNo]);
         		if (menuNo == 0){
         			paraVis = false;
         			switchView();
         			txt[0].html(txtArr[0]);
         			sym.$("txt0Bg").stop().animate({width:sym.$("txt0").width()+20}, 0);
         
         		}
         		if (menuNo == 1){
         			paraVis = true;
         			switchView();
         			txt[0].html(txtArr[167]);
         			sym.$("txt0Bg").stop().animate({width:sym.$("txt0").width()+20}, 0);
         		}
         	};
         };
         
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(red);
         
         function clear(){
         	path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").empty();
         	parkPath.getSymbol("redDotPark").$("venTxt").empty();
         	}
         function reg0(){
         	sym.$("scrollMc").stop().animate({scrollLeft:50}, 250, 'easeOutCubic');
         	}
         function reg1(){
         	sym.$("scrollMc").stop().animate({scrollLeft:300}, 250, 'easeOutCubic');
         	}
         function reg2(){
         	sym.$("scrollMc").stop().animate({scrollLeft:350}, 250, 'easeOutCubic');
         	}
         function reg3(){
         	sym.$("scrollMc").stop().animate({scrollLeft:200}, 250, 'easeOutCubic');
         	}
         
         //********************************************************************************************************
         // SWITCH VIEW
         //********************************************************************************************************
         
         function switchView(){
         	closeCeremony();
         	reg0();
         	if (paraVis == false){
         		path.$("dotsMc").stop().animate({opacity:0}, 200);
         		sym.getSymbol("oParkMc").getSymbol("olyPark").$("olyArt").fadeIn(0);
         		sym.getSymbol("oParkMc").getSymbol("olyPark").$("paraArt").fadeOut(0);
         		sym.getSymbol("oParkMc").getSymbol("olyPark").$("stadDot4").fadeIn(0);
         		sym.$("soccerMc").stop().animate({opacity:1}, 0);
         		path.$("dotsMc").stop().animate({opacity:1}, 0);
         		path.$("paraDotsMc").stop().animate({opacity:0}, 0);
         		sym.$("paraBtnsMc").css({"top":"-800px"});
         		path.getSymbol("dotsMc").$("redDotMc").fadeIn(0);
         		var x = path.getSymbol("dotsMc").$("stadDot" + (0)).position();
         		var y = path.getSymbol("dotsMc").$("stadDot" + (0)).position();
         		path.getSymbol("dotsMc").$("redDotMc").stop().animate({opacity:1, left: x.left-8, top: y.top-8}, 100);
         		parkPath.$("redDotPark2").stop().animate({opacity:0}, 0);
         
         		resetIcon();
         		sym.$("oParkMc").fadeOut(0);
         
         		path.getSymbol("dotsMc").$("redDotMc2").fadeOut(0);
         		imageSymbolArray[0].$("bg").css(red);
         		imageSymbolArray[0].$("txt").css({'color':'white', 'font-weight':'bold'});
         		path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").empty();
         		path.getSymbol("dotsMc").getSymbol("redDotMc").$("venTxt").append(txtArr[73]);	
         	}else{
         		path.$("paraDotsMc").stop().animate({opacity:0}, 200);
         		sym.getSymbol("oParkMc").getSymbol("olyPark").$("olyArt").fadeOut(0);
         		sym.getSymbol("oParkMc").getSymbol("olyPark").$("paraArt").fadeIn(0);
         		sym.getSymbol("oParkMc").getSymbol("olyPark").$("stadDot4").fadeOut(0);
         		sym.$("soccerMc").stop().animate({opacity:0}, 0);
         		path.$("dotsMc").stop().animate({opacity:0}, 0);
         		path.$("paraDotsMc").stop().animate({opacity:1}, 0);
         		sym.$("paraBtnsMc").css({"top":"378px"});
         		path.getSymbol("paraDotsMc").$("redDotMc").fadeIn(0);
         		var x = path.getSymbol("paraDotsMc").$("stadDot" + (0)).position();
         		var y = path.getSymbol("paraDotsMc").$("stadDot" + (0)).position();
         		path.getSymbol("paraDotsMc").$("redDotMc").stop().animate({opacity:1, left: x.left-8, top: y.top-8}, 100);
         		parkPath.$("redDotPark2").stop().animate({opacity:1}, 0);
         
         		resetPara();
         		sym.$("oParkMc").fadeOut(0);
         
         		paraSymbolArray[0].$("bg").css(red);
         		paraSymbolArray[0].$("txt").css({'color':'white', 'font-weight':'bold'});
         
         		path.getSymbol("paraDotsMc").getSymbol("redDotMc").$("venTxt").empty();
         		path.getSymbol("paraDotsMc").getSymbol("redDotMc").$("venTxt").append(txtArr[117]);	
         	}
         }
         switchView();
         
         //********************************************************************************************************
         // SOCCER CLOSE
         //********************************************************************************************************
         function closeSoccer(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("soccerMc").stop().animate({left:stageWidth-50}, 0);
         	sym.getSymbol("soccerMc").$("standBtn").fadeIn(0);
         	sym.getSymbol("soccerMc").getSymbol("standBtn").$("arrow").css({"transform":"scaleX(-1)"});
         	standIn = false;
         }
         function openSoccer(){
         	var stageWidth=sym.$("Stage").width();
         	if (stageWidth < 800) {
         		sym.$("soccerMc").stop().animate({left:stageWidth-50}, 0);
         		sym.getSymbol("soccerMc").$("standBtn").fadeIn(0);
         		sym.getSymbol("soccerMc").getSymbol("standBtn").$("arrow").css({"transform":"scaleX(-1)"});
         		standIn = false;
         	} else {
         		sym.getSymbol("soccerMc").$("standBtn").fadeOut(0);
         		sym.getSymbol("soccerMc").getSymbol("standBtn").$("arrow").css({"transform":"scaleX(1)"});
         		sym.$("soccerMc").stop().animate({left:stageWidth-320}, 200, 'easeOutCubic');
         		standIn = true;
         		}
         }
         //********************************************************************************************************
         // SOCCER BUTTON
         //********************************************************************************************************
         var standIn = false;
         sym.getSymbol("soccerMc").$("standBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	closeCeremony();
         	sym.$("infoPark").stop().fadeOut(0);
         	sym.$("oParkMc").stop().fadeOut(0);
         	sym.$("infoPanel").fadeOut(0);
         	var stageWidth=sym.$("Stage").width();
         	if (standIn == false){
         		sym.getSymbol("soccerMc").getSymbol("standBtn").$("arrow").css({"transform":"scaleX(1)"});
         		sym.$("soccerMc").animate({left:stageWidth-320}, 200, 'easeOutCubic');
         		standIn = true;
         	} else {
         		sym.getSymbol("soccerMc").getSymbol("standBtn").$("arrow").css({"transform":"scaleX(-1)"});
         		sym.$("soccerMc").animate({left:stageWidth-50}, 200, 'easeOutCubic');
         		standIn = false;
         	}
         	});
         
         //********************************************************************************************************
         // CEREMONY BUTTON
         //********************************************************************************************************
         
         sym.getSymbol("menuBtnsMc").$("menuBtn2").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	path.$("ceremonyDotMc").stop().animate({opacity:1}, 200);
         	sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         	sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[2]);
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn2").$("bg").css({"background-color":"#ed9b00"});
         	resetIcon();
         	resetPara();
         	sym.$("oParkMc").fadeOut(0);
         	reg1();
         	path.$("paraDotsMc").stop().animate({opacity:0}, 200);
         	path.$("dotsMc").stop().animate({opacity:0}, 200);
         
         	});
         function closeCeremony(){
         	path.$("ceremonyDotMc").stop().animate({opacity:0}, 200);
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn2").$("bg").css(grey);
         }
         
         //********************************************************************************************************
         // MOUSE SCROLL SYMBOL
         //********************************************************************************************************
         var x,left,down;
         sym.$("scrollMc").on('touchstart mousedown', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=true;
         	x=e.pageX;
         	left=$(this).scrollLeft();
         });
         
         sym.$("scrollMc").on('touchmove mousemove', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(down){
         		var newX=e.pageX;
         		sym.$("scrollMc").scrollLeft(left-newX+x);    
         	}
         });
         sym.$("scrollMc").on('touchend mouseup', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=false;
         });
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	closeCeremony();
         	if (RTL == true){
         		for (var s=0; s<3; s++){ 
         			sym.getSymbol("menuBtnsMc").$("menuBtn"+s).stop().animate({top:0, left:80-(s*40)}, 0);
         		}
         		sym.$("menuBtnsMc").stop().animate({left:0}, 0);
         		sym.getSymbol("styleHead").$("headlineTxt").css({"text-align":"right", "padding-top":"6px"});
         		sym.getSymbol("menuBtnsMc").$("menuTxt").css({"text-align":"left", "left":"130px"});
         	}
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'menuBtnMob'
   (function(symbolName) {   
   
   })("menuBtnMob");
   //Edge symbol end:'menuBtnMob'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'menuBtn1'
   (function(symbolName) {   
   
   })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'auxBtn'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'rectBtns'
   (function(symbolName) {   
   
   })("rectBtns");
   //Edge symbol end:'rectBtns'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("auxBtnsMc");
   //Edge symbol end:'auxBtnsMc'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'btnsMc'
   (function(symbolName) {   
   
   })("btnsMc");
   //Edge symbol end:'btnsMc'

   //=========================================================
   
   //Edge symbol: 'iconBtn'
   (function(symbolName) {   
   
   })("iconBtn");
   //Edge symbol end:'iconBtn'

   //=========================================================
   
   //Edge symbol: 'iconBg'
   (function(symbolName) {   
   
   })("iconBg");
   //Edge symbol end:'iconBg'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'soccerMc'
   (function(symbolName) {   
   
   })("soccerMc");
   //Edge symbol end:'soccerMc'

   //=========================================================
   
   //Edge symbol: 'arrow'
   (function(symbolName) {   
   
   })("arrow");
   //Edge symbol end:'arrow'

   //=========================================================
   
   //Edge symbol: 'redDotMc'
   (function(symbolName) {   
   
   })("redDotMc");
   //Edge symbol end:'redDotMc'

   //=========================================================
   
   //Edge symbol: 'dotsMc'
   (function(symbolName) {   
   
   })("dotsMc");
   //Edge symbol end:'dotsMc'

   //=========================================================
   
   //Edge symbol: 'stadDot'
   (function(symbolName) {   
   
   })("stadDot");
   //Edge symbol end:'stadDot'

   //=========================================================
   
   //Edge symbol: 'rings'
   (function(symbolName) {   
   
   })("rings");
   //Edge symbol end:'rings'

   //=========================================================
   
   //Edge symbol: 'christ'
   (function(symbolName) {   
   
   })("christ");
   //Edge symbol end:'christ'

   //=========================================================
   
   //Edge symbol: 'olyPark'
   (function(symbolName) {   
   
   })("olyPark");
   //Edge symbol end:'olyPark'

   //=========================================================
   
   //Edge symbol: 'oParkMc'
   (function(symbolName) {   
   
   })("oParkMc");
   //Edge symbol end:'oParkMc'

   //=========================================================
   
   //Edge symbol: 'redDotPark'
   (function(symbolName) {   
   
   })("redDotPark");
   //Edge symbol end:'redDotPark'

   //=========================================================
   
   //Edge symbol: 'redDotMc_1'
   (function(symbolName) {   
   
      })("redDotMc2");
   //Edge symbol end:'redDotMc2'

   //=========================================================
   
   //Edge symbol: 'paraBtns'
   (function(symbolName) {   
   
   })("paraBtns");
   //Edge symbol end:'paraBtns'

   //=========================================================
   
   //Edge symbol: 'dotsMc_1'
   (function(symbolName) {   
   
      })("paraDotsMc");
   //Edge symbol end:'paraDotsMc'

   //=========================================================
   
   //Edge symbol: 'iconBg_1'
   (function(symbolName) {   
   
      })("paraIconBg");
   //Edge symbol end:'paraIconBg'

   //=========================================================
   
   //Edge symbol: 'olyArt'
   (function(symbolName) {   
   
   })("olyArt");
   //Edge symbol end:'olyArt'

   //=========================================================
   
   //Edge symbol: 'olyArt_1'
   (function(symbolName) {   
   
   })("paraArt");
   //Edge symbol end:'paraArt'

   //=========================================================
   
   //Edge symbol: 'redDotMc2_1'
   (function(symbolName) {   
   
         })("ceremonyDotMc");
   //Edge symbol end:'ceremonyDotMc'

   //=========================================================
   
   //Edge symbol: 'iconBtn_1'
   (function(symbolName) {   
   
      })("iconParaBtn");
   //Edge symbol end:'iconParaBtn'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33738");