/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var mob = 0;
         	var mobOpen = false;
         	var clicked = 0;
         	var btnNo = 0;
         	var newView = true;
         	var pOld = -146;
         	var pNew = 154;
         	var roofUp = 0;
         	var spin = 0;
         	var tierIn = 0;
         	var gnNo=33700;
         //********************************************************************************************************
         // CSS STYLES
         //********************************************************************************************************
         	var whiteTxtBox = {"border-color":"black", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var blackTxtBox = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var grey  = {"background-color":"rgba(160,160,160,1)"};
         	var red = {"background-color":"rgba(218,0,0,1)"};
         	var black  = {"background-color":"rgba(0,0,0,1)"};
         	var white  = {"background-color":"rgba(255,255,255,1)"};
         
         //********************************************************************************************************
         // TEXT AND XML
         //********************************************************************************************************
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none", "padding-left":"6px", "padding-top":"6px"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.getSymbol("standMc").$("standTxt").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         
         	var txt=[];
         	txt[0] = sym.getSymbol("standMc").$("txt0").css({"pointer-events":"none","height":"auto"});
         	txt[1] = sym.$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.getSymbol("tiersMc").$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.getSymbol("tiersMc").$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.getSymbol("tiersMc").$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.getSymbol("tiersMc").getSymbol("seatsMc").$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.getSymbol("tiersMc").getSymbol("seatsMc").$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.getSymbol("tiersMc").getSymbol("seatsMc").$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.getSymbol("tiersMc").$("txt13").css({"pointer-events":"none"});
         	txt[14] = sym.getSymbol("tiersMc").$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.getSymbol("tiersMc").$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.getSymbol("tiersMc").$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.getSymbol("tiersMc").$("txt17").css({"pointer-events":"none"});
         	txt[18] = sym.getSymbol("tiersMc").$("txt18").css({"pointer-events":"none"});
         	txt[19] = sym.$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.$("txt20").css({"pointer-events":"none"});
         	txt[21] = sym.getSymbol("tiersMc").$("txt21").css({"pointer-events":"none"});
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN"+gnNo+".xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<22; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize, 'line-height':lineHeight, "height":"auto"});
         			}
         			sym.$("txt19").css({'font-size':"16px"});
         			sym.getSymbol("standMc").$("txt0").animate({top:528 - sym.getSymbol("standMc").$("txt0").height()+5}, 0);
         			sym.getSymbol("standMc").$("parrotMc").animate({top:285 - sym.getSymbol("standMc").$("txt0").height()-0}, 0);
         			sym.$("txt2").css({"line-height":"18px"});
         			sym.getSymbol("tiersMc").$("txt17").css({"font-size":"14px"});
         			sym.getSymbol("tiersMc").$("txt18").css({"font-size":"14px"});
         			sym.$("txt1Point").empty();
         			sym.$("txt1Point").append(txtArr[1]);
         			sym.getSymbol("tiersMc").getSymbol("pitchMc").$("txt21p").empty();
         			sym.getSymbol("tiersMc").getSymbol("pitchMc").$("txt21p").append(txtArr[21]);
         			sym.getSymbol("tiersMc").getSymbol("pitchMc").$("txt13p").empty();
         			sym.getSymbol("tiersMc").getSymbol("pitchMc").$("txt13p").append(txtArr[13]);
         			sym.getSymbol("tiersMc").getSymbol("pitchMc").$("txt14p").empty();
         			sym.getSymbol("tiersMc").getSymbol("pitchMc").$("txt14p").append(txtArr[14]);
         			sym.getSymbol("tiersMc").getSymbol("pitchMc").$("txt15p").empty();
         			sym.getSymbol("tiersMc").getSymbol("pitchMc").$("txt15p").append(txtArr[15]);
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("rectBtns").stop().animate({left:stageWidth/2-160}, 0);
         
         	if(stageWidth<800){
         		sym.$("standMc").stop().animate({left:-200}, 200);
         		sym.getSymbol("standMc").getSymbol("standBtn").$("plus").fadeIn(0);
         		sym.$("txt2").stop().animate({ left:5 }, 0);
         	}else{
         
         	}
         	if(stageWidth<640){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	if (stageWidth<480){
         
         	}else{
         
         	}
         	setStyle();
         	sym.getSymbol("tiersMc").getSymbol("pitchBtn").$("plus").fadeIn(0);
         	sym.getSymbol("tiersMc").$("pitchMc").stop().fadeOut(0);
         	sym.getSymbol("tiersMc").getSymbol("seatsBtn").$("plus").fadeIn(0);
         	sym.getSymbol("tiersMc").$("seatsMc").stop().fadeOut(0);
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         }
         
         //********************************************************************************************************
         // STANDFIRST TOGGLE BUTTON
         //********************************************************************************************************
         sym.getSymbol("standMc").$("standBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	sym.$("txt2").stop().animate({ left:5 }, 0);
         	if (sym.getSymbol("standMc").getSymbol("standBtn").$("plus").is(":visible") ) { 
         		sym.getSymbol("standMc").getSymbol("standBtn").$("plus").fadeOut(0);
         		sym.$("standMc").stop().animate({left:0}, 200);
         	}else{
         		sym.getSymbol("standMc").getSymbol("standBtn").$("plus").fadeIn(0);
         		sym.$("standMc").stop().animate({left:-200}, 200);
         	}
         });
         
         //********************************************************************************************************
         // PITCH TOGGLE BUTTON
         //********************************************************************************************************
         sym.getSymbol("tiersMc").$("pitchBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (sym.getSymbol("tiersMc").getSymbol("pitchBtn").$("plus").is(":visible") ) { 
         		sym.getSymbol("tiersMc").getSymbol("pitchBtn").$("plus").fadeOut(0);
         		sym.getSymbol("tiersMc").$("pitchMc").stop().fadeIn(200);
         		sym.getSymbol("tiersMc").$("seatsMc").stop().fadeOut(200);
         		sym.getSymbol("tiersMc").getSymbol("seatsBtn").$("plus").fadeIn(0);
         	}else{
         		sym.getSymbol("tiersMc").getSymbol("pitchBtn").$("plus").fadeIn(0);
         		sym.getSymbol("tiersMc").$("pitchMc").stop().fadeOut(200);
         	}
         	sym.getSymbol("standMc").getSymbol("standBtn").$("plus").fadeIn(0);
         	sym.$("standMc").stop().animate({left:-200}, 200);
         });
         
         //********************************************************************************************************
         // SEATS TOGGLE BUTTON
         //********************************************************************************************************
         sym.getSymbol("tiersMc").$("seatsBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (sym.getSymbol("tiersMc").getSymbol("seatsBtn").$("plus").is(":visible") ) { 
         		sym.getSymbol("tiersMc").getSymbol("seatsBtn").$("plus").fadeOut(0);
         		sym.getSymbol("tiersMc").$("seatsMc").stop().fadeIn(200);
         		sym.getSymbol("tiersMc").$("pitchMc").stop().fadeOut(200);
         		sym.getSymbol("tiersMc").getSymbol("pitchBtn").$("plus").fadeIn(0);
         	}else{
         		sym.getSymbol("tiersMc").getSymbol("seatsBtn").$("plus").fadeIn(0);
         		sym.getSymbol("tiersMc").$("seatsMc").stop().fadeOut(200);
         	}
         	sym.getSymbol("standMc").getSymbol("standBtn").$("plus").fadeIn(0);
         	sym.$("standMc").stop().animate({left:-200}, 200);
         });
         
         //********************************************************************************************************
         // STADIUM CODE
         //********************************************************************************************************
         function stadView() {
         	if (newView == true){
         		sym.$("txt19").empty();
         		sym.$("txt19").append(txtArr[19]);
         		sym.getSymbol("stadOldBtn").$("btnClick").fadeOut(0);
         		sym.getSymbol("stadNewBtn").$("btnClick").fadeIn(0);
         		sym.getSymbol("stadMc").$("stadiumNewRoof").fadeIn(500);
         		sym.getSymbol("stadMc").$("stadiumNew").fadeIn(500);
         		sym.$("rampPoint").stop().animate({ opacity:1 }, 200);
         		sym.$("txt6").stop().animate({ opacity:1 }, 200);
         		sym.$("txt2").stop().animate({ opacity:1 }, 200);
         		sym.$("txt1Point").stop().animate({ opacity:0 }, 200);
         		sym.$("museumPoint1").stop().animate({ opacity:0 }, 200);
         		sym.$("txt1").stop().animate({ opacity:1 }, 200);
         		sym.$("museumPoint").stop().animate({ opacity:1 }, 200);
         		if (roofUp == 1){
         			sym.$("solar").stop().animate({ opacity:0 }, 200);
         			sym.$("solarPoint").stop().animate({ opacity:0 }, 200);
         			sym.$("txt3").stop().animate({ opacity:0 }, 200);
         			sym.$("mediaPoint").stop().animate({ opacity:1 }, 200);
         			sym.$("txt4").stop().animate({ opacity:1 }, 200);
         			sym.$("vipPoint").stop().animate({ opacity:1 }, 200);
         			sym.$("txt5").stop().animate({ opacity:1 }, 200);
         		} else {
         			sym.$("solar").stop().animate({ opacity:1 }, 200);
         			sym.$("solarPoint").stop().animate({ opacity:1 }, 200);
         			sym.$("txt3").stop().animate({ opacity:1 }, 200);
         			sym.$("mediaPoint").stop().animate({ opacity:0 }, 200);
         			sym.$("txt4").stop().animate({ opacity:0 }, 200);
         			sym.$("vipPoint").stop().animate({ opacity:0 }, 200);
         			sym.$("txt5").stop().animate({ opacity:0 }, 200);
         		}
         	} else {
         		sym.$("solar").stop().animate({ opacity:0 }, 200);
         		sym.$("solarPoint").stop().animate({ opacity:0 }, 200);
         		sym.$("txt3").stop().animate({ opacity:0 }, 200);
         		sym.$("txt19").empty();
         		sym.$("txt19").append(txtArr[20]);
         		sym.getSymbol("stadNewBtn").$("btnClick").fadeOut(0);
         		sym.getSymbol("stadOldBtn").$("btnClick").fadeIn(0);
         		sym.getSymbol("stadMc").$("stadiumNewRoof").fadeOut(500);
         		sym.getSymbol("stadMc").$("stadiumNew").fadeOut(500);
         		sym.$("rampPoint").stop().animate({ opacity:0 }, 200);
         		sym.$("txt6").stop().animate({ opacity:0 }, 200);
         		sym.$("txt2").stop().animate({ opacity:0 }, 200);
         		sym.$("txt1Point").stop().animate({ opacity:1 }, 200);
         		sym.$("museumPoint1").stop().animate({ opacity:1 }, 200);
         		sym.$("txt1").stop().animate({ opacity:0 }, 200);
         		sym.$("museumPoint").stop().animate({ opacity:0 }, 200);
         		sym.$("mediaPoint").stop().animate({ opacity:0 }, 200);
         		sym.$("txt4").stop().animate({ opacity:0 }, 200);
         		sym.$("vipPoint").stop().animate({ opacity:0 }, 200);
         		sym.$("txt5").stop().animate({ opacity:0 }, 200);
         	}
         }
         stadView();
         
         sym.getSymbol("stadMc").$("newInsidePointMc").stop().animate({ opacity:0 }, 0);
         sym.getSymbol("roofBtn").$("btnClick").fadeOut(0);
         sym.getSymbol("stadOldBtn").$("btnClick").fadeOut(0);
         sym.getSymbol("stadNewBtn").$("btnClick").fadeIn(0);
         sym.$("txt1Point").stop().animate({ opacity:0 }, 0);
         sym.$("museumPoint1").stop().animate({ opacity:0 }, 0);
         
         //********************************************************************************************************
         function roofsMove(){
         if (roofUp == 0){
         	sym.getSymbol("roofBtn").$("btnClick").fadeIn(0);
         	sym.getSymbol("roofBtn").$("plus").fadeOut(0);
         	sym.getSymbol("stadMc").$("stadiumOldRoof").stop().animate({ opacity:0.5, height: 310 }, 500, 'easeOutCubic');
         	sym.getSymbol("stadMc").$("stadiumNewRoof").stop().animate({ opacity:0.0, height: 310 }, 500, 'easeOutCubic');
         	roofUp = 1;
         }else{
         	sym.getSymbol("roofBtn").$("btnClick").fadeOut(0);
         	sym.getSymbol("roofBtn").$("plus").fadeIn(0);
         	sym.getSymbol("stadMc").$("stadiumOldRoof").stop().animate({ opacity:1, height: 600 }, 500, 'easeOutCubic');
         	sym.getSymbol("stadMc").$("stadiumNewRoof").stop().animate({ opacity:1, height: 600 }, 500, 'easeOutCubic', function() {
         		//sym.getSymbol("stadMc").$("newInsidePointMc").stop().animate({ opacity:0 }, 250);
         	});
         	roofUp = 0;
         	}
         }
         
         //********************************************************************************************************
         // CLOSE TIERS BUTTON
         //********************************************************************************************************
         sym.getSymbol("tiersMc").$("closeBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	sym.$("tiersMc").stop().fadeOut(200)
         	sym.getSymbol("standMc").$("standBtn").fadeIn(0);
         	sym.$("txt2").stop().animate({ left:5 }, 0);
         });
         
         //********************************************************************************************************
         // BUTTONS STADIUM OLD
         //********************************************************************************************************
         sym.$("stadOldBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	newView = false;
         	stadView();
         });
         
         //********************************************************************************************************
         // BUTTONS STADIUM NEW
         //********************************************************************************************************
         sym.$("stadNewBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	newView = true;
         	stadView()
         });
         
         //********************************************************************************************************
         // BUTTONS ROOFS
         //********************************************************************************************************
         sym.$("roofBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	roofsMove();
         	stadView();
         });
         
         //********************************************************************************************************
         // BUTTONS TIERS
         //********************************************************************************************************
         sym.$("tierBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	sym.$("tiersMc").stop().fadeIn(200);
         	sym.getSymbol("standMc").getSymbol("standBtn").$("plus").fadeIn(0);
         	sym.$("standMc").stop().animate({left:-200}, 200);
         	sym.getSymbol("standMc").$("standBtn").fadeOut(0);
         });
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE  
         function setStyle(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("tiersMc").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         //********************************************************************************************************
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         
         //********************************************************************************************************
         // SET STAGE
         //********************************************************************************************************
         $(window).on('resize',initSize);
         
         function setStage(){
         	sym.$("tiersMc").fadeOut(0);
         	sym.$("txt2").stop().animate({ left:200 }, 0);
         	sym.getSymbol("tiersMc").$("pitchMc").stop().fadeOut(0);
         	sym.getSymbol("tiersMc").$("seatsMc").stop().fadeOut(0);
         	var stageWidth=sym.$("Stage").width();
         	if (stageWidth > 799) {
         		sym.getSymbol("standMc").getSymbol("standBtn").$("plus").fadeOut(0);
         		sym.$("standMc").stop().animate({left:0}, 0);
         	}
         }
         setStage();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'tierBtn'
   (function(symbolName) {   
   
   })("tierBtn");
   //Edge symbol end:'tierBtn'

   //=========================================================
   
   //Edge symbol: 'tiersMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6300, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7950, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("tiersMc");
   //Edge symbol end:'tiersMc'

   //=========================================================
   
   //Edge symbol: 'fadeMc'
   (function(symbolName) {   
   
   })("fadeMc");
   //Edge symbol end:'fadeMc'

   //=========================================================
   
   //Edge symbol: 'roofBtn'
   (function(symbolName) {   
   
   })("roofBtn");
   //Edge symbol end:'roofBtn'

   //=========================================================
   
   //Edge symbol: 'arrowMc'
   (function(symbolName) {   
   
   })("arrowMc");
   //Edge symbol end:'arrowMc'

   //=========================================================
   
   //Edge symbol: 'stadNewMc'
   (function(symbolName) {   
   
   })("stadNewMc");
   //Edge symbol end:'stadNewMc'

   //=========================================================
   
   //Edge symbol: 'standMc'
   (function(symbolName) {   
   
   })("standMc");
   //Edge symbol end:'standMc'

   //=========================================================
   
   //Edge symbol: 'parrotMc'
   (function(symbolName) {   
   
   })("parrotMc");
   //Edge symbol end:'parrotMc'

   //=========================================================
   
   //Edge symbol: 'roofBtn_1'
   (function(symbolName) {   
   
      })("stadiumBtn");
   //Edge symbol end:'stadiumBtn'

   //=========================================================
   
   //Edge symbol: 'pitchMc'
   (function(symbolName) {   
   
   })("pitchMc");
   //Edge symbol end:'pitchMc'

   //=========================================================
   
   //Edge symbol: 'seatsMc'
   (function(symbolName) {   
   
   })("seatsMc");
   //Edge symbol end:'seatsMc'

   //=========================================================
   
   //Edge symbol: 'tierBtn_1'
   (function(symbolName) {   
   
      })("closeBtn");
   //Edge symbol end:'closeBtn'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33700");