/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clicked = 0;
         	var btnNo = 0;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "height":"auto", "width":"auto", "padding":"4px", "background-color":"white"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var whiteTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         	
         	for (var b=0;b<3; b++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+b).$("txt").html(b+1);
         	}
         	
         	for (var i=0; i<5; i++){
         		sym.getSymbol("mobBtnsMc").getSymbol("btn"+i).$("no").html(i+1);
         	}
         	
         	var outBtn  = {"background-color":"rgba(160,160,160,1)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         	var black = {"background-color":"black"};
         	
         	var txt=[];
         	for (var i=0; i<4; i++){
         		txt[i] = sym.getSymbol("tableMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[4] = sym.$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.$("txt12").css({"pointer-events":"none"});
         	for (var i=13; i<23; i++){
         		txt[i] = sym.getSymbol("engineMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[23] = sym.$("txt23").css({"pointer-events":"none"});
         	txt[24] = sym.$("txt24").css({"pointer-events":"none"});
         	txt[25] = sym.$("txt25").css({"pointer-events":"none"});
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33674.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<26; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         	
         			sym.$("txt10").css({'font-size':"16px"});
         			sym.getSymbol("engineMc").$("txt13").css({'font-size':'15px','line-height':'17px'});
         	
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //********************************************************************************************************
         // SET STAGE
         //********************************************************************************************************
         
         	sym.getSymbol("dot0").$("bg").css(overBtn);
         	sym.getSymbol("dot3").$("bg").css(overBtn);
         	sym.getSymbol("dot2").$("no").html("2");
         	sym.getSymbol("dot3").$("no").html("2");
         
         function hideAll() {
         	sym.getSymbol("planeMc").$("enginesFront").stop().animate({opacity:0}, 0);
         	sym.getSymbol("planeMc").$("enginesBack").stop().animate({opacity:0}, 0);
         	sym.getSymbol("planeMc").$("tanks").stop().animate({opacity:0}, 0);
         	sym.$("pointer1").stop().animate({opacity:0}, 0);
         	sym.$("pointer2").stop().animate({opacity:0}, 0);
         	sym.$("pointer3").stop().animate({opacity:0}, 0);
         	sym.$("pointer4").stop().animate({opacity:0}, 0);
         	sym.$("pointer5").stop().animate({opacity:0}, 0);
         	sym.$("txt4").stop().animate({opacity:0}, 0);
         	sym.$("txt5").stop().animate({opacity:0}, 0);
         	sym.$("txt6").stop().animate({opacity:0}, 0);
         	sym.$("txt7").stop().animate({opacity:0}, 0);
         	sym.$("txt8").stop().animate({opacity:0}, 0);
         	sym.$("txt11").stop().animate({opacity:0}, 0);
         	sym.$("txt12").stop().animate({opacity:0}, 0);
         	for (var i=14; i<23; i++){
         		sym.getSymbol("engineMc").$("txt"+i).stop().animate({opacity:0}, 0);
         	}
         	for (var i=1; i<8; i++){
         		sym.getSymbol("engineMc").$("point"+i).stop().animate({opacity:0}, 0);
         	}
         	sym.getSymbol("engineMc").$("coneBox").stop().animate({opacity:0}, 0);
         	sym.getSymbol("engineMc").$("cone1").stop().animate({opacity:0}, 0);
         	sym.getSymbol("engineMc").$("cone2").stop().animate({opacity:0}, 0);
         	sym.$("dot0").stop().animate({opacity:0}, 0);
         	sym.$("dot1").stop().animate({opacity:0}, 0);
         	sym.$("dot2").stop().animate({opacity:0}, 0);
         	sym.$("dot3").stop().animate({opacity:0}, 0);
         	sym.$("engineMc").animate({opacity:0}, 0);
         	}
         hideAll();
         
         	sym.$("txt11").stop().animate({opacity:1}, 0);
         	sym.$("txt12").stop().animate({opacity:1}, 0);
         	sym.$("pointer3").stop().animate({opacity:1}, 0);
         	sym.$("pointer5").stop().animate({opacity:1}, 0);
         
         //********************************************************************************************************
         // INIT SIZE
         //********************************************************************************************************
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("mobBtnsMc").stop().animate({left:stageWidth/2-160}, 0);
         
         	if(stageWidth<640){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	if (stageWidth<480){
         		resetmenu();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(overBtn);
         		hideAll();
         		resetAux();
         		sym.getSymbol("mobBtnsMc").getSymbol("btn0").$("bg").css(overBtn);
         		sym.$("txt11").stop().animate({opacity:1}, 0);
         		sym.$("txt12").stop().animate({opacity:1}, 0);
         		sym.$("pointer3").stop().animate({opacity:1}, 0);
         		sym.$("pointer5").stop().animate({opacity:1}, 0);
         		sym.$("txt8").css({'text-align':'right'});
         		sym.$("txt12").css({'text-align':'right'});
         		sym.getSymbol("engineMc").$("txt15").css({'text-align':'center'});
         	}else{
         		sym.$("txt8").css({'text-align':'left'});
         		sym.$("txt12").css({'text-align':'left'});
         		sym.getSymbol("engineMc").$("txt15").css({'text-align':'left'});
         	}
         	setStyle();
         }
         
         //********************************************************************************************************
         // MENU BUTTONS
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<3; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(black);
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		hideAll();
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		if (menuNo == 0){
         			sym.$("txt11").stop().animate({opacity:1}, 200);
         			sym.$("txt12").stop().animate({opacity:1}, 200);
         			sym.$("pointer3").stop().animate({opacity:1}, 200);
         			sym.$("pointer5").stop().animate({opacity:1}, 200);
         		}
         		if (menuNo == 1){
         			sym.getSymbol("planeMc").$("enginesFront").stop().animate({opacity:1}, 200);
         			sym.getSymbol("planeMc").$("tanks").stop().animate({opacity:1}, 200);
         			sym.getSymbol("planeMc").$("enginesBack").stop().animate({opacity:1}, 200);
         			sym.getSymbol("planeMc").$("enginesFront").stop().animate({opacity:1}, 200);
         			sym.$("pointer1").stop().animate({opacity:1}, 0);
         			sym.$("pointer2").stop().animate({opacity:1}, 0);
         			sym.$("pointer3").stop().animate({opacity:1}, 0);
         			sym.$("pointer4").stop().animate({opacity:1}, 0);
         			sym.$("pointer5").stop().animate({opacity:1}, 0);
         			sym.$("txt4").stop().animate({opacity:1}, 0);
         			sym.$("txt5").stop().animate({opacity:1}, 0);
         			sym.$("txt6").stop().animate({opacity:1}, 0);
         			sym.$("txt7").stop().animate({opacity:1}, 0);
         			sym.$("txt8").stop().animate({opacity:1}, 0);
         			sym.$("dot0").stop().animate({opacity:1}, 0);
         			sym.$("dot1").stop().animate({opacity:1}, 0);
         			sym.$("dot2").stop().animate({opacity:1}, 0);
         			sym.$("dot3").stop().animate({opacity:1}, 0);
         		}
         		if (menuNo == 2){
         			sym.$("engineMc").stop().animate({opacity:1}, 200);
         			for (var i=14; i<23; i++){
         				sym.getSymbol("engineMc").$("txt"+i).stop().animate({opacity:1}, 200);
         			}
         			for (var i=1; i<8; i++){
         				sym.getSymbol("engineMc").$("point"+i).stop().animate({opacity:1}, 200);
         			}
         			sym.getSymbol("engineMc").$("coneBox").stop().animate({opacity:1}, 200);
         			sym.getSymbol("engineMc").$("cone1").stop().animate({opacity:1}, 200);
         			sym.getSymbol("engineMc").$("cone2").stop().animate({opacity:1}, 200);
         		}
         	};
         };
         
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(overBtn);
         
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         // AUX BUTTONS
         var clickAux = 0;
         auxArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<5; a++){
         	auxArray.push(a);
         }
         
         function resetAux(){
         	for (var a=0; a<auxArray.length; a++){
         		sym.getSymbol("mobBtnsMc").getSymbol("btn" + a).$("bg").css(outBtn);
         	}
         }
         resetAux();
         
         // AUX CLICK
         var auxBtnClick = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		clickAux = auxNo;
         		resetAux();
         		hideAll();
         		sym.getSymbol("mobBtnsMc").getSymbol("btn" + auxNo).$("bg").css(overBtn);
         		if (auxNo == 0) {
         			sym.$("txt11").stop().animate({opacity:1}, 0);
         			sym.$("txt12").stop().animate({opacity:1}, 0);
         			sym.$("pointer3").stop().animate({opacity:1}, 0);
         			sym.$("pointer5").stop().animate({opacity:1}, 0);
         		}
         		if (auxNo == 1) {
         			sym.$("txt4").stop().animate({opacity:1}, 200);
         			sym.$("txt8").stop().animate({opacity:1}, 200);
         			sym.$("pointer3").stop().animate({opacity:1}, 200);
         			sym.$("pointer5").stop().animate({opacity:1}, 200);
         			sym.getSymbol("planeMc").$("enginesFront").stop().animate({opacity:1}, 200);
         			sym.getSymbol("planeMc").$("enginesBack").stop().animate({opacity:1}, 200);
         			sym.getSymbol("planeMc").$("tanks").stop().animate({opacity:0}, 0);
         		}
         		if (auxNo == 2) {
         			sym.$("txt5").stop().animate({opacity:1}, 200);
         			sym.$("txt6").stop().animate({opacity:1}, 200);
         			sym.$("txt7").stop().animate({opacity:1}, 200);
         			sym.$("pointer1").stop().animate({opacity:1}, 200);
         			sym.$("pointer2").stop().animate({opacity:1}, 200);
         			sym.$("pointer4").stop().animate({opacity:1}, 200);
         			sym.getSymbol("planeMc").$("tanks").stop().animate({opacity:1}, 200);
         		}
         		if (auxNo == 3) {
         			sym.$("engineMc").stop().animate({opacity:1}, 0);
         			for (var i=14; i<20; i++){
         				sym.getSymbol("engineMc").$("txt"+i).stop().animate({opacity:1}, 200);
         			}
         			for (var i=1; i<7; i++){
         				sym.getSymbol("engineMc").$("point"+i).stop().animate({opacity:10}, 200);
         			}
         		}
         		if (auxNo == 4) {
         			for (var i=20; i<24; i++){
         				sym.getSymbol("engineMc").$("txt"+i).stop().animate({opacity:1}, 200);
         			}
         			sym.$("engineMc").stop().animate({opacity:1}, 0);
         			sym.getSymbol("engineMc").$("point7").stop().animate({opacity:1}, 200);
         			sym.getSymbol("engineMc").$("coneBox").stop().animate({opacity:1}, 200);
         			sym.getSymbol("engineMc").$("cone1").stop().animate({opacity:1}, 200);
         			sym.getSymbol("engineMc").$("cone2").stop().animate({opacity:1}, 200);
         		}
         	};
         };
         for (var b=0;b<auxArray.length;b++){
         	sym.getSymbol("mobBtnsMc").$("btn"+b).on('touchstart click',auxBtnClick(b));
         	sym.getSymbol("mobBtnsMc").$("btn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("mobBtnsMc").getSymbol("btn0").$("bg").css(overBtn);
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE SETTING 
         function setStyle() {
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("engineMc").stop(stageWidth*10);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyle();
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4775, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'auxBtn'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'galBtns'
   (function(symbolName) {   
   
   })("galBtns");
   //Edge symbol end:'galBtns'

   //=========================================================
   
   //Edge symbol: 'skyMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("skyMc");
   //Edge symbol end:'skyMc'

   //=========================================================
   
   //Edge symbol: 'tableMc'
   (function(symbolName) {   
   
   })("tableMc");
   //Edge symbol end:'tableMc'

   //=========================================================
   
   //Edge symbol: 'tankDot'
   (function(symbolName) {   
   
   })("tankDot");
   //Edge symbol end:'tankDot'

   //=========================================================
   
   //Edge symbol: 'planeMc'
   (function(symbolName) {   
   
   })("planeMc");
   //Edge symbol end:'planeMc'

   //=========================================================
   
   //Edge symbol: 'engineMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("engineMc");
   //Edge symbol end:'engineMc'

   //=========================================================
   
   //Edge symbol: 'redArrow'
   (function(symbolName) {   
   
   })("redArrow");
   //Edge symbol end:'redArrow'

   //=========================================================
   
   //Edge symbol: 'engineAnim'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.play(750);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.play(750);

      });
      //Edge binding end

   })("engineAnim");
   //Edge symbol end:'engineAnim'

   //=========================================================
   
   //Edge symbol: 'redArrow_1'
   (function(symbolName) {   
   
   })("blueArrow");
   //Edge symbol end:'blueArrow'

   //=========================================================
   
   //Edge symbol: 'skyMc_1'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("skyMc_1");
   //Edge symbol end:'skyMc_1'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33674");