/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clicked = 0;
         	var btnNo = 0;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "height":"auto", "width":"auto", "padding":"4px"});
         	var standmob;
         	var standtxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var whiteTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"4px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.6)", "height":"auto","width":"auto", "padding":"3px"};
         	
         // MENU TEXT START
         	var menuTxt=[];
         	for (var h=0; h<4; h++){
         		menuTxt[h] = sym.getSymbol("menuBtn" + h).$("txt").css({"pointer-events":"none"});
         	}
         	var menuArr=[];
         	var outBtn  = {"background-color":"white"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         
         	var txt=[];
         	txt[0] = sym.getSymbol("globeMc").$("txt0").css(whiteTxtBox);
         	txt[1] = sym.getSymbol("globeMc").$("txt1").css(whiteTxtBox);
         	txt[2] = sym.getSymbol("globeMc").$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.getSymbol("globeMc").$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("globeMc").$("txt4").css(whiteTxtBox);
         	txt[5] = sym.getSymbol("permMc").$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.getSymbol("permMc").$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.getSymbol("permMc").$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.getSymbol("permMc").$("txt8").css({"pointer-events":"none"});
         
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33606.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			standmob = $(xml).find('standmob').text();
         			standtxtmob.html(standmob);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			// MENU TEXT START
         			for (var i=0; i<4; i++){
         				menuArr[i]=$(xml).find('menuTxt'+i).text();
         				menuTxt[i].html(menuArr[i]);
         			} // MENU TEXT END
         
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<9; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         			sym.getSymbol("globeMc").$("txt4").animate({left:370 - sym.getSymbol("globeMc").$("txt4").width()+10}, 0);
         		},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 0, 'easeInCubic');
         	sym.$("permMc").stop().animate({left:-stageWidth}, 0);
         	sym.getSymbol("standBtn").$("minus").fadeIn(0);
         	if (stageWidth<400){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		sym.$("standTxt").empty();
         		sym.$("standTxt").append(standmob);
         
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		sym.$("standTxt").empty();
         		sym.$("standTxt").append(stand);
         	}
         	setStyle();
         	setStyleUpdate();
         }
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // MENU BUTTONS
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<4; h++){
         	menuArray.push(h);
         }
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		if (menuNo == 0) {
         			sym.getSymbol("menuBtn0").$("txt").css({"color":"white"});
         			sym.getSymbol("menuBtn1").$("txt").css({"color":"black"});
         			sym.getSymbol("menuBtn2").$("txt").css({"color":"black"});
         			sym.getSymbol("menuBtn3").$("txt").css({"color":"black"});
         			sym.getSymbol("menuBtn0").$("bg").css({"background-color":"#4a6a94"});
         			sym.getSymbol("menuBtn1").$("bg").css({"background-color":"#ffffff"});
         			sym.getSymbol("menuBtn2").$("bg").css({"background-color":"#ffffff"});
         			sym.getSymbol("menuBtn3").$("bg").css({"background-color":"#ffffff"});
         			sym.getSymbol("globeMc").$("perm0").fadeIn(250);
         			sym.getSymbol("globeMc").$("perm1").fadeOut(250);
         			sym.getSymbol("globeMc").$("perm2").fadeOut(250);
         			sym.getSymbol("globeMc").$("perm3").fadeOut(250);
         		}
         		if (menuNo == 1) {
         			sym.getSymbol("menuBtn0").$("txt").css({"color":"white"});
         			sym.getSymbol("menuBtn1").$("txt").css({"color":"white"});
         			sym.getSymbol("menuBtn2").$("txt").css({"color":"black"});
         			sym.getSymbol("menuBtn3").$("txt").css({"color":"black"});
         			sym.getSymbol("menuBtn0").$("bg").css({"background-color":"#4a6a94"});
         			sym.getSymbol("menuBtn1").$("bg").css({"background-color":"#4a7eab"});
         			sym.getSymbol("menuBtn2").$("bg").css({"background-color":"#ffffff"});
         			sym.getSymbol("menuBtn3").$("bg").css({"background-color":"#ffffff"});
         			sym.getSymbol("globeMc").$("perm0").fadeIn(250);
         			sym.getSymbol("globeMc").$("perm1").fadeIn(250);
         			sym.getSymbol("globeMc").$("perm2").fadeOut(250);
         			sym.getSymbol("globeMc").$("perm3").fadeOut(250);
         		}
         		if (menuNo == 2) {
         			sym.getSymbol("menuBtn0").$("txt").css({"color":"white"});
         			sym.getSymbol("menuBtn1").$("txt").css({"color":"white"});
         			sym.getSymbol("menuBtn2").$("txt").css({"color":"white"});
         			sym.getSymbol("menuBtn3").$("txt").css({"color":"black"});
         			sym.getSymbol("menuBtn0").$("bg").css({"background-color":"#4a6a94"});
         			sym.getSymbol("menuBtn1").$("bg").css({"background-color":"#4a7eab"});
         			sym.getSymbol("menuBtn2").$("bg").css({"background-color":"#498dcb"});
         			sym.getSymbol("menuBtn3").$("bg").css({"background-color":"#ffffff"});
         			sym.getSymbol("globeMc").$("perm0").fadeIn(250);
         			sym.getSymbol("globeMc").$("perm1").fadeIn(250);
         			sym.getSymbol("globeMc").$("perm2").fadeIn(250);
         			sym.getSymbol("globeMc").$("perm3").fadeOut(250);
         		}
         		if (menuNo == 3) {
         			sym.getSymbol("menuBtn0").$("txt").css({"color":"white"});
         			sym.getSymbol("menuBtn1").$("txt").css({"color":"white"});
         			sym.getSymbol("menuBtn2").$("txt").css({"color":"white"});
         			sym.getSymbol("menuBtn3").$("txt").css({"color":"white"});
         			sym.getSymbol("menuBtn0").$("bg").css({"background-color":"#4a6a94"});
         			sym.getSymbol("menuBtn1").$("bg").css({"background-color":"#4a7eab"});
         			sym.getSymbol("menuBtn2").$("bg").css({"background-color":"#498dcb"});
         			sym.getSymbol("menuBtn3").$("bg").css({"background-color":"#93bde4"});
         			sym.getSymbol("globeMc").$("perm0").fadeIn(250);
         			sym.getSymbol("globeMc").$("perm1").fadeIn(250);
         			sym.getSymbol("globeMc").$("perm2").fadeIn(250);
         			sym.getSymbol("globeMc").$("perm3").fadeIn(250);
         		}
         	};
         };
         
         for (var b=0;b<menuArray.length;b++){
         	sym.$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         	sym.$("menuBtn"+b).css({'cursor':'pointer'});
         }
         	sym.getSymbol("menuBtn0").$("bg").css({"background-color":"#4a6a94"});
         	sym.getSymbol("menuBtn0").$("txt").css({"color":"white"});
         	sym.getSymbol("globeMc").$("perm0").fadeIn(0);
         	sym.getSymbol("globeMc").$("perm1").fadeOut(0);
         	sym.getSymbol("globeMc").$("perm2").fadeOut(0);
         	sym.getSymbol("globeMc").$("perm3").fadeOut(0);
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // TOGGLE STANDFIRST BUTTON
         sym.$("standBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	var stageWidth=sym.$("Stage").width();
         	if (sym.getSymbol("standBtn").$("minus").is(":visible") ) { 
         		sym.getSymbol("standBtn").$("minus").fadeOut(0);
         		sym.$("permMc").stop().animate({left:0}, 300);
         	}else{
         		sym.getSymbol("standBtn").$("minus").fadeIn(0);
         		sym.$("permMc").stop().animate({left:-stageWidth}, 300);
         	}
         }); 
         
         //--------------------------------------------------------------------------------------------------------
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SET STYLE SETTING 
         function setStyle() {
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("permMc").stop(stageWidth*10);
         	sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "height":"auto", "width":"auto", "padding":"6px", "padding-top":"6px"});
         	sym.getSymbol("styleHead").$("headlineTxt").stop().animate({width:stageWidth}, 0);
         	sym.getSymbol("styleBase").$("creditTxt").animate({left:stageWidth-120}, 0);
         }
         function setStyleUpdate(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyleUpdate();
         //--------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //--------------------------------------------------------------------------------------------------------
         $(window).on('resize',initSize);
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------- END -------------------------------------------------
         //--------------------------------------------------------------------------------------------------------

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'globeMc'
   (function(symbolName) {   
   
   })("globeMc");
   //Edge symbol end:'globeMc'

   //=========================================================
   
   //Edge symbol: 'permMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("permMc");
   //Edge symbol end:'permMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33606");