/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clicked = 0;
         	var btnNo = 0;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline, headlinemob;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none", "padding":"6px", "padding-top":"6px"});
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "height":"auto", "width":"auto", "padding":"4px"});
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var whiteTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"#fff200", "height":"auto","width":"auto", "padding":"20px"};
         	
         	var yellowTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"30px", "color":"black",
         	"background-color":"#fff200", "height":"auto","width":"auto", "padding":"6px"};
         	
         	var orangeTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"30px", "color":"black",
         	"background-color":"#f47920", "height":"auto","width":"auto", "padding":"6px"};
         	
         	var blueTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"6px", "color":"white",
         	"background-color":"#0095da", "height":"auto","width":"auto", "padding":"6px"};
         	
         	var blueTxtBoxRound = {"border-width":"0px","border-style":"solid", "border-radius":"30px", "color":"white",
         	"background-color":"#0095da", "height":"auto","width":"auto", "padding":"6px"};
         	
         	for (var i=0; i<24; i++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+i).$("no").html(i+1);
         	}
         	
         	var outBtn  = {"background-color":"rgba(160,160,160,1)"};
         	var overBtn = {"background-color":"#f47920"};
         	
         	var movie=[];
         	var budget=[];
         	var box=[];
         	var increase=[];
         	for (var i=0; i<24; i++){
         		movie[i] = sym.$("movie").css({"pointer-events":"none"});
         		budget[i] = sym.$("budget").css(yellowTxtBox);
         		box[i] = sym.$("box").css(orangeTxtBox);
         		increase[i] = sym.$("increase").css(blueTxtBoxRound);
         		}
         	var increaseArr=[];
         	var boxArr=[];
         	var budgetArr=[];
         	var movieArr=[];
         	
         	var txt=[];
         		txt[0] = sym.$("txt0").css({"pointer-events":"none"});
         		txt[1] = sym.$("txt1").css({"pointer-events":"none"});
         		txt[2] = sym.$("txt2").css({"pointer-events":"none"});
         		txt[3] = sym.$("txt3").css({"pointer-events":"none"});
         		txt[4] = sym.$("txt4").css({"pointer-events":"none"});
         		txt[5] = sym.$("txt5").css({"pointer-events":"none"});
         		txt[6] = sym.$("txt6").css({"pointer-events":"none"});
         		txt[7] = sym.$("txt7").css({"pointer-events":"none"});
         		txt[8] = sym.$("txt8").css({"pointer-events":"none"});
         		txt[9] = sym.$("txt9").css({"pointer-events":"none"});
         		txt[10] = sym.$("txt10").css({"pointer-events":"none"});
         		txt[11] = sym.$("txt11").css({"pointer-events":"none"});
         		txt[12] = sym.getSymbol("spectre").$("txt12").css({"pointer-events":"none"});
         		txt[13] = sym.getSymbol("spectre").$("txt13").css({"pointer-events":"none"});
         		txt[14] = sym.getSymbol("spectre").$("txt14").css({"pointer-events":"none"});
         		txt[15] = sym.getSymbol("spectre").$("txt15").css({"pointer-events":"none"});
         		txt[16] = sym.getSymbol("spectre").$("txt16").css({"pointer-events":"none"});
         		txt[17] = sym.$("txt17").css({"pointer-events":"none"});
         		txt[18] = sym.$("txt18").css({"pointer-events":"none"});
         		txt[19] = sym.$("txt19").css({"pointer-events":"none"});
         		txt[20] = sym.$("txt20").css({"pointer-events":"none"});
         	var txtArr=[]
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33596.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			var stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			var source = $(xml).find('source').text();
         			sourcetxt.html(source);
         			//var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<17; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				//txt[i].css({'font-size':fontSize});
         			}
         			for (var i=0; i<24; i++){
         				movieArr[i]=$(xml).find('movie'+i).text();
         				movie[i].html(movieArr[i]);
         				budgetArr[i]=$(xml).find('budget'+i).text();
         				budget[i].html(budgetArr[i]);
         				boxArr[i]=$(xml).find('box'+i).text();
         				box[i].html(boxArr[i]);
         				increaseArr[i]=$(xml).find('increase'+i).text();
         				increase[i].html(increaseArr[i]);
         			}
         			addNos();
         			sym.$("box").animate({left:280 - sym.$("box").width()+15}, 0);
         			sym.$("txt1").animate({width:sym.$("budget").width()+15}, 0);
         			sym.$("txt2").animate({width:sym.$("box").width()+30, left:280 - sym.$("box").width()+7}, 0);
         			sym.$("movie").css({'font-size':'16px'});
         			sym.$("txt0").css(blueTxtBox);
         			sym.$("txt3").animate({left:30 + sym.$("increase").width()}, 0);
         			sym.getSymbol("spectre").$("txt16").empty();
         			sym.getSymbol("spectre").$("txt16").append(txtArr[11]);
         		}
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         	}); // END XML
         sym.$("spectre").fadeOut(0);
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function addNos(){
         	sym.$("budget").empty();
         	sym.$("budget").append(txtArr[4] + budgetArr[clicked] + txtArr[5]);
         	sym.$("txt1").animate({width:sym.$("budget").width()+15}, 0);
         	sym.$("box").empty();
         	sym.$("box").append(txtArr[4] + boxArr[clicked] + txtArr[5]);
         	sym.$("box").animate({left:280 - sym.$("box").width()+20}, 0);
         	sym.$("increase").empty();
         	sym.$("increase").append(increaseArr[clicked]);
         	sym.$("txt3").animate({left:30 + sym.$("increase").width()}, 0);
         	var no = "<div style='font-size:54px'>"+(clicked+1)+"</div>";
         	sym.$("movie").empty();
         	sym.$("movie").append(movieArr[clicked] + '<br>' + '<br>' + (no));
         	boxSize = (parseInt(boxArr[clicked],10) / parseInt(boxArr[22],10)) * 100 + 100;
         	spiralSize = (parseInt(budgetArr[clicked],10) / parseInt(budgetArr[22],10)) * 160 + 170;
         	budgetSize = parseInt(budgetArr[clicked],10)/3+16;
         	sym.$("boxRingMc").stop().animate ({width:boxSize, height:boxSize, left:160-boxSize/2, top:250-boxSize/2}, 200, 'easeOutCubic');
         	sym.$("spiral").stop().animate ({width:spiralSize, height:spiralSize, left:160-spiralSize/2, top:250-spiralSize/2}, 200, 'easeOutCubic');
         	sym.$("budgetRingMc").stop().animate ({width:budgetSize, height:budgetSize, left:160-budgetSize/2-2, top:250-budgetSize/2-2}, 200, 'easeOutCubic');
         	changeHead();
         }
         addNos();
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // BUTTONS BLUE
         var blueVis = 0;
         sym.$("blueBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (blueVis == 0) {
         		sym.$("txt0").stop().animate ({top:600 - sym.$("txt0").height()-30}, 200, 'easeInCubic');
         		sym.$("blueBtn").css({'transform':'scaleY(-1)','-webkit-transform':'scaleY(-1)','-ms-transform':'scaleY(-1)'});
         		blueVis = 1;
         	}else{
         		sym.$("txt0").animate({top:600}, 200);
         		sym.$("blueBtn").css({'transform':'scaleY(1)','-webkit-transform':'scaleY(1)','-ms-transform':'scaleY(1)'});
         		blueVis = 0;
         	}
         	});
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SWIPE
         sym.$("swipe").swipeleft(function(){
         	e.stopPropagation(); e.preventDefault();
         	resetmenu();
         
         	if (clicked >= 23) {
         		//changeHead();
         	}else{
         		clicked++
         		addNos();
         	}
         	sym.getSymbol("menuBtnsMc").$("backBtn"+ clicked).css(overBtn);
         	});
         sym.$("swipe").swiperight(function(){
         	e.stopPropagation(); e.preventDefault();
         	resetmenu();
         
         	if (clicked <= 0) {
         		changeHead();
         	}else{
         		clicked--
         		addNos();
         	}
         	sym.getSymbol("menuBtnsMc").$("backBtn"+ clicked).css(overBtn);
         	});
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         
         // MENU BUTTONS
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<24; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").$("backBtn" + h).css(outBtn);
         	}
         	for (var h=1; h<7; h++){
         		sym.$("head"+h).fadeOut(50);
         	}
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	sym.$("txt0").animate({top:600}, 200);
         	sym.$("blueBtn").css({'transform':'scaleY(1)','-webkit-transform':'scaleY(1)','-ms-transform':'scaleY(1)'});
         	blueVis = 0;
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("menuBtnsMc").$("backBtn"+ menuNo).css(overBtn);
         		sym.$("head"+h).fadeOut(0);
         		addNos();
         	};
         };
         
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("menuBtnsMc").$("backBtn0").css(overBtn);
         
         function changeHead() {
         	sym.$("blueBtn").fadeIn(0);
         	sym.$("spectre").fadeOut(200);
         	sym.$("txt6").empty();
         	if (clicked == 0||clicked == 1||clicked == 2||clicked == 3||clicked == 4||clicked == 6){
         		sym.$("head1").fadeIn(0);
         		sym.$("txt6").append(txtArr[6]);
         	}
         	if (clicked == 5){
         		sym.$("head4").fadeIn(0);
         		sym.$("txt6").append(txtArr[7]);
         	}
         	if (clicked == 7||clicked == 8||clicked == 9||clicked == 10||clicked == 11||clicked == 12||clicked == 13){
         		sym.$("head2").fadeIn(0);
         		sym.$("txt6").append(txtArr[8]);
         	}
         	if (clicked == 14||clicked == 15){
         		sym.$("head5").fadeIn(0);
         		sym.$("txt6").append(txtArr[9]);
         	}
         	if (clicked == 16||clicked == 17||clicked == 18||clicked == 19){
         		sym.$("head3").fadeIn(0);
         		sym.$("txt6").append(txtArr[10]);
         	}
         	if (clicked == 20||clicked == 21||clicked == 22){
         		sym.$("head6").fadeIn(0);
         		sym.$("txt6").append(txtArr[11]);
         	}
         	if (clicked == 23){
         		sym.$("spectre").fadeIn(200);
         		sym.getSymbol("spectre").play(0);
         		sym.$("txt0").animate({top:600}, 200);
         		sym.$("blueBtn").css({'transform':'scaleY(1)','-webkit-transform':'scaleY(1)','-ms-transform':'scaleY(1)'});
         		blueVis = 0;
         		sym.$("blueBtn").fadeOut(0);
         	}
         }
         changeHead();
         //--------------------------------------------------------------------------------------------------------
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.$("txt0").animate({top:600}, 200);
         	sym.$("blueBtn").css({'transform':'scaleY(1)','-webkit-transform':'scaleY(1)','-ms-transform':'scaleY(1)'});
         	blueVis = 0;
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         		sym.$("blueBtn").fadeOut(0);
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         		if (clicked >= 23){
         			sym.$("blueBtn").fadeOut(0);
         		}else{
         			sym.$("blueBtn").fadeIn(0);
         		}
         	}
         }); 
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------- END -------------------------------------------------
         //--------------------------------------------------------------------------------------------------------

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'boxMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("boxMc");
   //Edge symbol end:'boxMc'

   //=========================================================
   
   //Edge symbol: 'standBgMc'
   (function(symbolName) {   
   
   })("standBgMc");
   //Edge symbol end:'standBgMc'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'Symbol_1'
   (function(symbolName) {   
   
   })("Symbol_1");
   //Edge symbol end:'Symbol_1'

   //=========================================================
   
   //Edge symbol: 'blueBtn'
   (function(symbolName) {   
   
   })("blueBtn");
   //Edge symbol end:'blueBtn'

   //=========================================================
   
   //Edge symbol: 'arrow'
   (function(symbolName) {   
   
   })("arrow");
   //Edge symbol end:'arrow'

   //=========================================================
   
   //Edge symbol: 'boxRingMc'
   (function(symbolName) {   
   
   })("boxRingMc");
   //Edge symbol end:'boxRingMc'

   //=========================================================
   
   //Edge symbol: 'head'
   (function(symbolName) {   
   
   })("head1");
   //Edge symbol end:'head1'

   //=========================================================
   
   //Edge symbol: 'head1_1'
   (function(symbolName) {   
   
   })("head2");
   //Edge symbol end:'head2'

   //=========================================================
   
   //Edge symbol: 'head2_1'
   (function(symbolName) {   
   
   })("head3");
   //Edge symbol end:'head3'

   //=========================================================
   
   //Edge symbol: 'head3_1'
   (function(symbolName) {   
   
   })("head4");
   //Edge symbol end:'head4'

   //=========================================================
   
   //Edge symbol: 'head4_1'
   (function(symbolName) {   
   
   })("head5");
   //Edge symbol end:'head5'

   //=========================================================
   
   //Edge symbol: 'head5_1'
   (function(symbolName) {   
   
   })("head6");
   //Edge symbol end:'head6'

   //=========================================================
   
   //Edge symbol: 'spectre'
   (function(symbolName) {   
   
   })("spectre");
   //Edge symbol end:'spectre'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33596");