/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clicked = 0;
         	var btnNo = 0;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var whiteTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         
         	var outBtn  = {"background-color":"rgba(160,160,160,1)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         
         	var txt=[];
         	for (var i=0; i<15; i++){
         		txt[i] = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=15; i<27; i++){
         		txt[i] = sym.getSymbol("profileMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[27] = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt27").css({"pointer-events":"none", "padding":"6px", "border-radius":"5px"});
         	txt[28] = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt28").css({"pointer-events":"none", "padding":"6px", "border-radius":"5px"});
         	for (var i=29; i<46; i++){
         		txt[i] = sym.getSymbol("panelMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[46] = sym.$("txt46").css({"pointer-events":"none"});
         	txt[47] = sym.$("txt47").css({"pointer-events":"none"});
         	txt[48] = sym.$("txt48").css({"pointer-events":"none"});
         	txt[49] = sym.$("txt49").css({"pointer-events":"none"});
         	txt[50] = sym.$("txt50").css({"pointer-events":"none"});
         
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33550.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<46 ; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeOut(0);
         
         sym.getSymbol("controlsMc").$("playBtn").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	if (sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").is(":visible") ) { 
         		startTimer();
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeOut(0);
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("pause").fadeIn(0);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").play();
         		sym.getSymbol("profileMc").getSymbol("profile").play();
         	}else{
         		stopTimer();
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeIn(0);
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("pause").fadeOut(0);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").stop();
         		sym.getSymbol("profileMc").getSymbol("profile").stop();
         	}
         }); 
         
         var timer;
         
         function startTimer() {
           timer = setInterval(startReplay, 150);
         }
         function startReplay() {
           var stageWidth=sym.$("Stage").width();
         		var pos = sym.getSymbol("scrollMc").getSymbol("scrollableMc").getPosition();
         		sym.getSymbol("controlsMc").$("km").text((pos / 284.36).toFixed(1) + " " + (txtArr[0]));
         		sym.getSymbol("controlsMc").$("miles").text((pos / 458).toFixed(1) + " " + (txtArr[13]));
         		var x = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("racer").position();
         		sym.$("scrollMc").stop().animate({scrollLeft: x.left-100}, 500);
         		if (pos == 0 || pos == 12000) {
         			sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeIn(0);
         			sym.getSymbol("controlsMc").getSymbol("playBtn").$("pause").fadeOut(0);
         			stopTimer();
         		}
         }
         function stopTimer() {
           clearInterval(timer);
         }
         startTimer();
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("panelMc").stop().animate({left:stageWidth + 20}, 200, 'easeOutCubic');
         	// SCROLL START
         	sym.$("scrollMc").stop().animate({width:stageWidth}, 0);
         	sym.$("scrollMc").css({'overflow-y':'hidden'});
         	sym.$("scrollMc").css({'overflow-x':'hidden'});
         	// SCROLL END
         	sym.getSymbol("standBtn").$("plus").fadeIn(0);
         	sym.$("standBtn").animate({left:stageWidth-50}, 0);
         	sym.$("controlsMc").animate({left:stageWidth/2-160}, 0);
         	sym.$("controlsMc").fadeIn(100);
         
         	setStyle();
         	if(stageWidth<800){
         
         	}else{
         
         	}
         	if(stageWidth<640){
         		sym.getSymbol("scrollMc").$("scrollableMc").css('cursor', 'ew-resize'); // SCROLL CODE
         	}else{
         		sym.getSymbol("scrollMc").$("scrollableMc").css('cursor', 'default'); // SCROLL CODE
         	}
         	if (stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	setStyleUpdate();
         }
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------------------------------------------------------------- 
         // MOUSE SCROLL SYMBOL
         var x,left,down;
         sym.$("scrollMc").on('touchstart mousedown', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=true;
         	x=e.pageX;
         	left=$(this).scrollLeft();
         });
         
         sym.$("scrollMc").on('touchmove mousemove', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(down){
         		var newX=e.pageX;
         		sym.$("scrollMc").scrollLeft(left-newX+x);    
         	}
         });
         sym.$("scrollMc").on('touchend mouseup', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=false;
         });
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // TOGGLE STANDFIRST BUTTON
         sym.$("standBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	var stageWidth=sym.$("Stage").width();
         	if (sym.getSymbol("standBtn").$("plus").is(":visible") ) { 
         		sym.getSymbol("standBtn").$("plus").fadeOut(0);
         		sym.$("panelMc").stop().animate({left:stageWidth - 320}, 200, 'easeOutCubic');
         		sym.$("controlsMc").fadeOut(100);
         	}else{
         		sym.getSymbol("standBtn").$("plus").fadeIn(0);
         		sym.$("panelMc").stop().animate({left:stageWidth + 20}, 200, 'easeOutCubic');
         		sym.$("controlsMc").fadeIn(100);
         	}
         }); 
         //--------------------------------------------------------------------------------------------------------
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SET STYLE SETTING 
         function setStyle() {
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("profileMc").stop(stageWidth*10);
         	sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "height":"auto", "width":"auto", "padding":"6px", "padding-top":"6px"});
         	sym.getSymbol("styleHead").$("headlineTxt").stop().animate({width:stageWidth}, 0);
         	sym.getSymbol("styleBase").$("creditTxt").animate({left:stageWidth-120}, 0);
         }
         function setStyleUpdate(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyleUpdate();
         //--------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         		sym.$("controlsMc").fadeOut(100);
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         		sym.$("controlsMc").fadeIn(100);
         	}
         }); 
         //--------------------------------------------------------------------------------------------------------
         $(window).on('resize',initSize);
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------- END -------------------------------------------------
         //--------------------------------------------------------------------------------------------------------

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'courseMc'
   (function(symbolName) {   
   
   })("courseMc");
   //Edge symbol end:'courseMc'

   //=========================================================
   
   //Edge symbol: 'profileMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("profileMc");
   //Edge symbol end:'profileMc'

   //=========================================================
   
   //Edge symbol: 'profile'
   (function(symbolName) {   
   
   })("profile");
   //Edge symbol end:'profile'

   //=========================================================
   
   //Edge symbol: 'controlsMc'
   (function(symbolName) {   
   
   })("controlsMc");
   //Edge symbol end:'controlsMc'

   //=========================================================
   
   //Edge symbol: 'Symbol_1'
   (function(symbolName) {   
   
   })("Symbol_1");
   //Edge symbol end:'Symbol_1'

   //=========================================================
   
   //Edge symbol: 'panelMc'
   (function(symbolName) {   
   
   })("panelMc");
   //Edge symbol end:'panelMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33550");