/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clicked = 0;
         	var nextClick = 0;
         	var scrollPos = 0;
         	var btnNo = 0;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	var gnRed = "#da0000";
         	var whiteTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"3px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,1)", "height":"auto","width":"auto", "padding":"3px", "padding-left":"6px", "padding-right":"6px", "box-shadow":"2px 2px 2px rgba(0,0,0,0.5)"};
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         	var itemArray = ["al","az","ct","fl","ga","il","in","la","ma","md","mn","ms","nc","nj","nv","ny","oh","pa","sc","tn","tx","wv","ca","globeAsia","globeSA"];
         	$.each(itemArray, function(index, value) {
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").$(value).fadeOut(0);
         	});
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("ca").fadeIn(0);
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         imageSymbolArray = []; //the array that will hold references to your new symbols.
         
         function traceSelected (symbolInTheArray){
         	var clickedId = symbolInTheArray.getVariable("id");
         	nextClick = clickedId;
         	doneClick();
         }
         
         for (var i = 0; i < 49; i++){
         	var mySymbolObject = sym.createChildSymbol("menuBtn", "menuBtnsMc");  // Create an instance element of a symbol as a child of the given parent element menuBtnsMc
         	mySymbolObject.setVariable("id", i);  //set the value of a Symbol variable
         	imageSymbolArray.push(mySymbolObject);  //push it into the array
         }
         
         $.each(imageSymbolArray, function( count, symbolInTheArray ){ //a 'for each' loop through the newly populated array.
         	menuItem = $(symbolInTheArray); //create jQuery reference to the item - not really needed here but shows how to do it.
         	menuElement = $(symbolInTheArray.getSymbolElement());  //create a jQuery reference to the DIV element inside the symbol.
         	menuElement.bind ("click",function(){traceSelected(symbolInTheArray);});
         })
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         var move = 30;
         for (var i=0; i<imageSymbolArray.length; i++){
         	imageSymbolArray[i].getSymbolElement().animate ({top:move * i}, 0);
         	imageSymbolArray[i].$("no").html(i+1); // Add numbers to buttons
         	imageSymbolArray[i].getSymbolElement().css('cursor', 'default');
         }
         for (var i=44; i<imageSymbolArray.length; i++){
         	imageSymbolArray[i].getSymbolElement().animate ({top:move * i+30}, 0);
         }
         imageSymbolArray[48].getSymbolElement().animate ({top:move * 49+30}, 0);
         
         sym.getSymbol("menuBtnsMc").$("menuBtnHead1").animate({top:44 * move}, 0);
         sym.getSymbol("menuBtnsMc").$("menuBtnHead2").animate({top:49 * move}, 0);
         sym.getSymbol("menuBtnsMc").$("txt4").animate({top:51 * move+5}, 0);
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function resetMenu(){
         	for (var i=0; i<imageSymbolArray.length; i++){
         		imageSymbolArray[i].$("bg").css({"background-color":"#fff"});
         		imageSymbolArray[i].$("no").css({"color":"rgba(0,0,0,1)"});
          		imageSymbolArray[i].$("name").css({"color":"rgba(0,0,0,1)"});
          		imageSymbolArray[i].$("date").css({"color":"rgba(0,0,0,1)"});
          		imageSymbolArray[21].$("bg").css({"background-color":"rgba(218,0,0,0.1)"});
          		imageSymbolArray[21].$("no").css({"font-weight":"bold"});
          		imageSymbolArray[21].$("name").css({"font-weight":"bold"});
          		imageSymbolArray[21].$("date").css({"font-weight":"bold"});
          		imageSymbolArray[31].$("bg").css({"background-color":"rgba(218,0,0,0.1)"});
          		imageSymbolArray[31].$("no").css({"font-weight":"bold"});
          		imageSymbolArray[31].$("name").css({"font-weight":"bold"});
          		imageSymbolArray[31].$("date").css({"font-weight":"bold"});
          		imageSymbolArray[36].$("bg").css({"background-color":"rgba(218,0,0,0.1)"});
          		imageSymbolArray[36].$("no").css({"font-weight":"bold"});
          		imageSymbolArray[36].$("name").css({"font-weight":"bold"});
          		imageSymbolArray[36].$("date").css({"font-weight":"bold"});
          		imageSymbolArray[39].$("bg").css({"background-color":"rgba(218,0,0,0.1)"});
          		imageSymbolArray[39].$("no").css({"font-weight":"bold"});
          		imageSymbolArray[39].$("name").css({"font-weight":"bold"});
          		imageSymbolArray[39].$("date").css({"font-weight":"bold"});
          		imageSymbolArray[44].$("bg").css({"background-color":"rgba(252,175,23,0.2)"});
          		imageSymbolArray[45].$("bg").css({"background-color":"rgba(252,175,23,0.2)"});
          		imageSymbolArray[46].$("bg").css({"background-color":"rgba(252,175,23,0.2)"});
          		imageSymbolArray[47].$("bg").css({"background-color":"rgba(252,175,23,0.2)"});
         	}
         }
         resetMenu();
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function doneClick(){
         	sym.$("Text").html(nextClick);
         	if (nextClick <= 0){
         		sym.$("backBtn").fadeOut(0);
         	} else if (nextClick >= 48){
         		sym.$("nextBtn").fadeOut(0);
         	} else {
         		sym.$("nextBtn").fadeIn(0);
         		sym.$("backBtn").fadeIn(0);
         	}
         	resetMenu();
         	imageSymbolArray[nextClick].$("bg").css({"background-color":"#3777bc"});
         	imageSymbolArray[nextClick].$("no").css({"color":"rgba(255,255,255,1)"});
          	imageSymbolArray[nextClick].$("name").css({"color":"rgba(255,255,255,1)"});
          	imageSymbolArray[nextClick].$("date").css({"color":"rgba(255,255,255,1)"});
          	sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dot").css({"background-color":"#2d53da"});
         	if (nextClick == 21|| nextClick == 31 || nextClick == 36 || nextClick == 39) {
         		imageSymbolArray[nextClick].$("bg").css({"background-color":"rgba(218,0,0,1)"});
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dot").css({"background-color":"#da0000"});
         	}
         	if (nextClick == 44|| nextClick == 45 || nextClick == 46 || nextClick == 47) {
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dot").css({"background-color":"rgba(255,205,0,1)"});
         		imageSymbolArray[nextClick].$("bg").css({"background-color":"rgba(255,205,0,1)"});
         		imageSymbolArray[nextClick].$("no").css({"color":"rgba(0,0,0,1)"});
         		imageSymbolArray[nextClick].$("name").css({"color":"rgba(0,0,0,1)"});
         		imageSymbolArray[nextClick].$("date").css({"color":"rgba(0,0,0,1)"});
         	}
         	var itemArray = ["al","az","ct","fl","ga","il","in","la","ma","md","mn","ms","nc","nj","nv","ny","oh","pa","sc","tn","tx","wv","ca","globeAsia","globeSA"];
         	$.each(itemArray, function(index, value) {
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").$(value).fadeOut(200);
         	});
         
         	var slideleft = ["007","063","268","289","288","200","364","102","102","050","046","090","007","024","390","386","365","379","212","256","238","355","368","208","286","364","370","219","215","333","284","364","388","343","031","362","155","328","221","401","409","296","274","370","409","425","309","336","250"];
         	var slideTop  = ["114","145","231","160","190","117","195","097","097","172","175","172","126","158","243","253","235","223","223","121","223","173","178","231","222","152","208","197","197","095","166","087","099","086","109","121","076","183","066","085","066","205","098","143","074","060","106","171","059"];
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dot").stop().animate ({left:(slideleft[nextClick]), top:(slideTop[nextClick])}, 0);
         
         	var x = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dot").position();
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt2").stop().animate({top:x.top + 22, left:x.left - sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt2").width()/2}, 50);
         
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt2").empty();
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt2").css({"width":"0px"});
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt2").css({"width":"auto"});
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt2").append(stateArr[nextClick]);
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").$((stShortArr[nextClick])).stop().fadeIn(200);
         
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt2").stop().animate({top:x.top + 22, left:x.left+0}, 200);
         	sym.$("scrollMc").stop().animate({scrollLeft:(460-stageWidth)/2}, 50);
         
         	if (x.left < 100){
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt2").stop().animate({top:x.top + 22, left:x.left}, 200);
         		sym.$("scrollMc").stop().animate({scrollLeft:-160}, 50);
         	}
         	if (x.left > 200){
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt2").stop().animate({top:x.top + 22, left:x.left - sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt2").width()/2}, 200);
         		sym.$("scrollMc").stop().animate({scrollLeft:+160}, 50);
         	}
         	if (nextClick == 2 || nextClick == 3 || nextClick == 5 || nextClick == 5 || nextClick == 7 || nextClick == 8 || nextClick == 19 || nextClick == 36 || nextClick == 38 || nextClick == 41){
         		sym.$("scrollMc").stop().animate({scrollLeft:scrollPos}, 200);
         	}
         }
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // MENU TEXT START
         	var name=[];
         	var date=[];
         	var state=[];
         	var stShort=[];
         	for (var i=0; i<imageSymbolArray.length; i++){
         		name[i] = imageSymbolArray[i].$("name").css({"pointer-events":"none"});
         		date[i] = imageSymbolArray[i].$("date").css({"pointer-events":"none"});
         		state[i] = sym.$("txt2").css({"pointer-events":"none"});
         		stShort[i] = imageSymbolArray[i].$("stShort").css({"pointer-events":"none"});
         		state[0] = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt2").css(whiteTxtBox);
         	}
         	var stShortArr=[];
         	var stateArr=[];
         	var dateArr=[];
         	var nameArr=[];
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // NEXT BUTTONS COUNT
         	sym.$("nextBtn").on('touchstart click', function(e){
         		e.stopPropagation(); e.preventDefault();
         		nextClick++;
         		sym.$("menuBtnsMc").stop().animate({scrollTop:(nextClick ) *30}, 200);
         		doneClick();
         	});
         
         // BACK BUTTONS COUNT
         	sym.$("backBtn").on('touchstart click', function(e){
         		e.stopPropagation(); e.preventDefault();
         		nextClick--;
         		sym.$("menuBtnsMc").stop().animate({scrollTop:(nextClick ) *30}, 200);
         		doneClick();
         	});
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         	var outBtn  = {"background-color":"rgba(160,160,160,1)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         	var txt=[];
         	txt[0] = sym.getSymbol("menuBtnsMc").getSymbol("menuBtnHead1").$("txt").css({"pointer-events":"none"});
         	txt[1] = sym.getSymbol("menuBtnsMc").getSymbol("menuBtnHead2").$("txt").css({"pointer-events":"none"});
         	txt[2] = sym.$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.getSymbol("panelMc").$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("menuBtnsMc").$("txt4").css({"pointer-events":"none", "padding":"5px"});
         	var txtArr=[];
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         //AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33543.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			standBackgroudColour = $(xml).find('standBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			for (var i=0; i<49; i++){
         				nameArr[i]=$(xml).find('name'+i).text();
         				name[i].html(nameArr[i]);
         				dateArr[i]=$(xml).find('date'+i).text();
         				date[i].html(dateArr[i]);
         				stateArr[i]=$(xml).find('state'+i).text();
         				state[i].html(stateArr[i]);
         				stShortArr[i]=$(xml).find('stShort'+i).text();
         				stShort[i].html(stShortArr[i]);
         			} // MENU TEXT END
         
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<5; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         			sym.$("txt2").css({"pointer-events":"none", 'font-size':"12px"});
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtnHead1").$("txt").css({'font-size':"15px"});
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtnHead2").$("txt").css({'font-size':"15px"});
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("scrollMc").css({'overflow-y':'hidden'});
         	sym.getSymbol("standBtn").$("plus").fadeIn(0);
         	sym.$("standBtn").animate({left:stageWidth-50}, 0);
         	setStyle();
         	if(stageWidth<800){
         
         	}else{
         
         	}
         	if(stageWidth<640){
         		scrollPos = (460-stageWidth)/2;
         		sym.$("scrollMc").stop().animate({width:stageWidth}, 0);
         		sym.$("standBtn").animate({top:0}, 0);
         		sym.$("scrollMc").css('cursor', 'ew-resize'); // SCROLL CODE
         		sym.$("menuBtnsMc").animate({width:stageWidth}, 0);
         		sym.$("panelMc").animate({left:stageWidth+20}, 0);
         	}else{
         		scrollPos = (780-stageWidth)/2
         		sym.$("standBtn").animate({top:-50}, 0);
         		sym.getSymbol("scrollMc").$("scrollableMc").css('cursor', 'default'); // SCROLL CODE
         		sym.$("menuBtnsMc").animate({width:stageWidth-320}, 0);
         		sym.$("panelMc").animate({left:stageWidth-320}, 0);
         		sym.$("scrollMc").stop().animate({width:stageWidth-320}, 0);
         		sym.$("scrollMc").stop().animate({scrollLeft:scrollPos}, 0);
         	}
         	if (stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	setStyleUpdate();
         }
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------------------------------------------------------------- 
         // MOUSE SCROLL SYMBOL
         var x,left,down;
         sym.$("scrollMc").on('touchstart mousedown', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=true;
         	x=e.pageX;
         	left=$(this).scrollLeft();
         });
         
         sym.$("scrollMc").on('touchmove mousemove', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(down){
         		var newX=e.pageX;
         		sym.$("scrollMc").scrollLeft(left-newX+x);    
         	}
         });
         sym.$("scrollMc").on('touchend mouseup', function(e){
         	e.stopPropagation(); e.preventDefault();
         	down=false;
         });
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // TOGGLE STANDFIRST BUTTON
         sym.$("standBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	var stageWidth=sym.$("Stage").width();
         	if (sym.getSymbol("standBtn").$("plus").is(":visible") ) { 
         		sym.getSymbol("standBtn").$("plus").fadeOut(0);
         		sym.$("panelMc").stop().animate({left:stageWidth-320}, 200);
         	}else{
         		sym.getSymbol("standBtn").$("plus").fadeIn(0);
         		sym.$("panelMc").stop().animate({left:stageWidth+20}, 200);
         	}
         }); 
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         
         doneClick(); // work the magic
         
         //--------------------------------------------------------------------------------------------------------
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SET STYLE SETTING 
         function setStyle() {
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "height":"auto", "width":"auto", "padding":"6px", "padding-top":"6px"});
         	sym.getSymbol("styleHead").$("headlineTxt").stop().animate({width:stageWidth}, 0);
         	sym.getSymbol("styleBase").$("creditTxt").animate({left:stageWidth-120}, 0);
         }
         function setStyleUpdate(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyleUpdate();
         //--------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         		sym.$("txt2").fadeOut(0);
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         		sym.$("txt2").stop().delay(200).fadeIn(0);
         	}
         }); 
         //--------------------------------------------------------------------------------------------------------
         $(window).on('resize',initSize);
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------- END -------------------------------------------------
         //--------------------------------------------------------------------------------------------------------

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtnHead");
   //Edge symbol end:'menuBtnHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'panelMc'
   (function(symbolName) {   
   
   })("panelMc");
   //Edge symbol end:'panelMc'

   //=========================================================
   
   //Edge symbol: 'navBtn'
   (function(symbolName) {   
   
   })("navBtn");
   //Edge symbol end:'navBtn'

   //=========================================================
   
   //Edge symbol: 'navBtn_1'
   (function(symbolName) {   
   
   })("navBtnBack");
   //Edge symbol end:'navBtnBack'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33543");