/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clicked = 0;
         	var btnNo = 0;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "height":"auto", "width":"auto", "padding":"6px", "padding-right":"60px", "background-color":"white"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var whiteTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         	
         	var txtBlack = {"color":"rgba(255,255,255,1)", "background-color":"rgba(0,0,0,0.8)", "height":"auto", "padding":"10px"};
         	
         	var txtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"#fbae17", "height":"auto", "padding":"5px"};
         	
         	var outBtn  = {"background-color":"rgba(160,160,160,1)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         	
         	var txt=[];
         	for (var i=0; i<14; i++){
         		txt[i] = sym.getSymbol("mapMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[14] = sym.$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.getSymbol("tunnelMc").$("txt17").css({"pointer-events":"none"});
         	txt[18] = sym.getSymbol("tunnelMc").$("txt18").css({"pointer-events":"none"});
         	txt[19] = sym.$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.$("txt20").css({"pointer-events":"none"});
         	txt[21] = sym.$("txt21").css({"pointer-events":"none"});
         	txt[22] = sym.$("txt22").css({"pointer-events":"none"});
         	txt[23] = sym.$("txt23").css({"pointer-events":"none"});
         	txt[24] = sym.$("txt24").css({"pointer-events":"none"});
         	txt[25] = sym.$("txt25").css({"pointer-events":"none"});
         	txt[26] = sym.$("txt26").css({"pointer-events":"none"});
         	txt[27] = sym.$("txt27").css(txtBlack);
         	txt[28] = sym.$("txt28").css({"pointer-events":"none"});
         	txt[29] = sym.$("txt29").css({"pointer-events":"none"});
         	txt[30] = sym.$("txt30").css({"pointer-events":"none"});
         	
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33532.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<30; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         			sym.getSymbol("mapMc").$("txt13").css(txtBox);
         			sym.$("txt27").append('<hr>' + txtArr[28] + '<hr>' + txtArr[29]);
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function hideTxt(){
         	sym.$("trenchPointer").stop().animate({opacity:0}, 0);
         	for (var i=19; i<27; i++){
         		sym.$("txt"+i).stop().animate({opacity:0}, 0);
         	}
         }
         hideTxt();
         sym.$("infoBtn").fadeOut(0);
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         
         sym.getSymbol("playBtn").$("replay").fadeOut(0);
         
         var count = 0;
         var lapse = 5500;
         
         sym.$("playBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	var stageWidth = sym.$("Stage").width();
         	count++;
         	hideTxt();
         	sym.getSymbol("playBtn").$("replay").fadeOut(0);
         	sym.getSymbol("playBtn").$("play").fadeIn(0);
         	sym.$("txt14").empty();
         	sym.$("txt14").append(txtArr[14 + count]);
         	sym.getSymbol("tunnelMc").play();
         	sym.$("playBtn").stop().animate({top:600}, 100);
         	sym.$("txt14").stop().animate({opacity:0}, 0);
         	sym.$("txt14").delay(lapse).animate({opacity:1}, 0);
         	sym.$("playBtn").delay(lapse-150).animate({top:542}, 100);
         	if (count == 0) {
         		lapse = 5500;
         		sym.$("infoBtn").fadeOut(0);
         		sym.$("trenchPointer").stop().animate({opacity:0}, 500);
         		for (var i=19; i<27; i++){
         			sym.$("txt"+i).stop().animate({opacity:0}, 500);
         		}
         	}
         	if (count == 1) {
         		lapse = 4000;
         	}
         	if (count == 2) {
         		lapse = 9000;
         	} 
         	if (count == 3) {
         		for (var i=19; i<27; i++){
         			sym.$("txt"+i).stop().delay(lapse).animate({opacity:1}, 500);
         		}
         		sym.$("trenchPointer").stop().delay(lapse).animate({opacity:1}, 500, function(){ sym.$("infoBtn").fadeIn(200); });
         		sym.$("txt14").stop().animate({opacity:0}, 0);
         		sym.getSymbol("playBtn").$("play").fadeOut(0);
         		sym.getSymbol("playBtn").$("replay").fadeIn(0);
         		lapse = 100;
         		count = -1;
         	}
         	sym.$("txt27").stop().animate({top:600}, 300);
         	sym.$("infoBtn").stop().animate({top:542}, 230);
         	sym.getSymbol("infoBtn").$("plus").fadeIn(0);
         	});
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function initSize(){
         	var stageWidth = sym.$("Stage").width();
         	sym.getSymbol("standBtn").$("plus").fadeIn(0);
         	sym.$("standBtn").animate({left:stageWidth-50}, 0);
         	sym.$("gradBoxMc").stop().animate({top:-40 + sym.$("standTxt").height()}, 0);
         	setStyle();
         	if(stageWidth<800){
         
         	}else{
         
         	}
         	if(stageWidth<640){
         		sym.$("mapMc").animate({left:stageWidth+10}, 0);
         		sym.$("standBtn").animate({top:40}, 0);
         		sym.$("standTxt").css({"height":"auto"});
         		sym.$("standTxt").animate({width:stageWidth-50}, 0);
         		sym.$("infoBtn").animate({left:stageWidth-60}, 0);
         		sym.$("txt27").animate({left:stageWidth-260}, 0);
         	}else{
         		sym.$("mapMc").animate({left:stageWidth-278}, 0);
         		sym.$("standBtn").animate({top:-50}, 0);
         		sym.$("standTxt").animate({width:stageWidth-300}, 0);
         		sym.$("infoBtn").animate({left:stageWidth-338}, 0);
         		sym.$("txt27").animate({left:stageWidth-530}, 0);
         	}
         	if (stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	sym.getSymbol("infoBtn").$("plus").fadeIn(0);
         	sym.$("txt27").stop().animate({top:600}, 300);
         	sym.$("infoBtn").stop().animate({top:542}, 230);
         	sym.getSymbol("infoBtn").$("plus").fadeIn(0);
         	setStyleUpdate();
         }
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // TOGGLE INFO BUTTON
         sym.$("infoBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (sym.getSymbol("infoBtn").$("plus").is(":visible") ) { 
         		sym.getSymbol("infoBtn").$("plus").fadeOut(0);
         		sym.$("txt27").stop().animate({top:570 - sym.$("txt27").height()}, 300);
         		sym.$("infoBtn").stop().animate({top:530 - sym.$("txt27").height()}, 300);
         	}else{
         		sym.getSymbol("infoBtn").$("plus").fadeIn(0);
         		sym.$("txt27").stop().animate({top:600}, 300);
         		sym.$("infoBtn").stop().animate({top:542}, 230);
         	}
         }); 
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // TOGGLE STANDFIRST BUTTON
         sym.$("standBtn").on('touchstart click', function(e){
         	var stageWidth=sym.$("Stage").width();
         	e.stopPropagation(); e.preventDefault();
         	if (sym.getSymbol("standBtn").$("plus").is(":visible") ) { 
         		sym.getSymbol("standBtn").$("plus").fadeOut(0);
         		sym.$("mapMc").stop().animate({left:stageWidth-282}, 140);
         	}else{
         		sym.getSymbol("standBtn").$("plus").fadeIn(0);
         		sym.$("mapMc").stop().animate({left:stageWidth+20}, 100);
         	}
         	sym.getSymbol("infoBtn").$("plus").fadeIn(0);
         	sym.$("txt27").stop().animate({top:600}, 300);
         	sym.$("infoBtn").stop().animate({top:542}, 230);
         }); 
         
         //--------------------------------------------------------------------------------------------------------
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SET STYLE SETTING 
         function setStyle() {
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "height":"auto", "width":"auto", "padding":"6px", "padding-top":"6px"});
         	sym.getSymbol("styleHead").$("headlineTxt").stop().animate({width:stageWidth-5}, 0);
         	sym.getSymbol("styleBase").$("creditTxt").animate({left:stageWidth-120}, 0);
         }
         function setStyleUpdate(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyleUpdate();
         //--------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //--------------------------------------------------------------------------------------------------------
         $(window).on('resize',initSize);
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------- END -------------------------------------------------
         //--------------------------------------------------------------------------------------------------------

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'boxMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1000, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("boxMc");
   //Edge symbol end:'boxMc'

   //=========================================================
   
   //Edge symbol: 'standBgMc'
   (function(symbolName) {   
   
   })("standBgMc");
   //Edge symbol end:'standBgMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn1'
   (function(symbolName) {   
   
   })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn2'
   (function(symbolName) {   
   
   })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("auxBtnsMc");
   //Edge symbol end:'auxBtnsMc'

   //=========================================================
   
   //Edge symbol: 'auxBtn'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'trafficMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         // play the timeline from the given position (ms or label)
         sym.play(1);

      });
      //Edge binding end

   })("trafficMc");
   //Edge symbol end:'trafficMc'

   //=========================================================
   
   //Edge symbol: 'tunnelMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 300, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8500, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("tunnelMc");
   //Edge symbol end:'tunnelMc'

   //=========================================================
   
   //Edge symbol: 'mapMc'
   (function(symbolName) {   
   
   })("mapMc");
   //Edge symbol end:'mapMc'

   //=========================================================
   
   //Edge symbol: 'gradBoxMc'
   (function(symbolName) {   
   
   })("gradBoxMc");
   //Edge symbol end:'gradBoxMc'

   //=========================================================
   
   //Edge symbol: 'tunnelScaleMc'
   (function(symbolName) {   
   
   })("tunnelScaleMc");
   //Edge symbol end:'tunnelScaleMc'

   //=========================================================
   
   //Edge symbol: 'playBtn'
   (function(symbolName) {   
   
   })("playBtn");
   //Edge symbol end:'playBtn'

   //=========================================================
   
   //Edge symbol: 'txtMc'
   (function(symbolName) {   
   
   })("txtMc");
   //Edge symbol end:'txtMc'

   //=========================================================
   
   //Edge symbol: 'trenchTxt'
   (function(symbolName) {   
   
   })("trenchTxt");
   //Edge symbol end:'trenchTxt'

   //=========================================================
   
   //Edge symbol: 'pointMc'
   (function(symbolName) {   
   
   })("pointMc");
   //Edge symbol end:'pointMc'

   //=========================================================
   
   //Edge symbol: 'playBtn_1'
   (function(symbolName) {   
   
      })("infoBtn");
   //Edge symbol end:'infoBtn'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNews33532");