/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clicked = 0;
         	var btnNo = 0;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "height":"auto", "width":"auto", "padding":"4px"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var whiteTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         	
         	var txtBox = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"white",  "border-color":"white", 
         	"background-color":"black", "height":"auto","width":"auto", "padding":"6px"};
         	
         	var outBtn  = {"background-color":"rgba(160,160,160,1)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         	
         	var txt=[];
         	txt[0] = sym.$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt1").css(txtBox);
         	txt[2] = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt2").css(txtBox);
         	
         	for (var i=3;i<9; i++){
         		txt[i] = sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("txtMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[9] = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt9").css({"pointer-events":"none"});
         	for (var i=10;i<13; i++){
         		txt[i] = sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("txtMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[13] = sym.$("txt13").css({"pointer-events":"none"});
         	for (var i=14;i<22; i++){
         		txt[i] = sym.getSymbol("profileMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[22] = sym.$("txt22").css({"pointer-events":"none"});
         	txt[23] = sym.$("txt23").css({"pointer-events":"none"});
         	txt[24] = sym.$("txt24").css({"pointer-events":"none"});
         	
         	var txtArr=[];
         	var tableArr=[]; //create array of tables
         	var strapArr=[]; //create strap array
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33519.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			//create table
         			var newTable="<div id='newTab'>";
         			var dataTab1;
         			newTable+="<div id='newtab1'>";
         			$(xml).find('table1').each(function() {
         				var strap=$(this).find('strap').text();
         				newTable+="<div class='redstrap'>"+strap+"</div>";
         				newTable+="<table class='events'>";
         				$(this).find('number1').each(function() {
         					dataTab1 = $(this).find("date1").text();
         					newTable+="<tr><td>"+dataTab1+"</td></tr>";
         				});
         				newTable+="</table>";
         			});
         	
         		sym.$("tableMc").append(newTable);
         		//apply styles
         		$("#newTab").css({"font-family":"Pragmatica-web, sans-serif"});
         		$(".events").css({"text-align":"left","color":"#000000","font-size":"14px","line-height":"15px",'border':0,'border-collapse':'collapse'});
         		$("#newtab1 tr:odd").css({"background-color":"#fff"});
         		$("#newtab1 tr:even").css({"background-color":"#edf4f9"});
         		$("#newtab1 tr:first-child").css({"text-align":"left", "line-height":"15px", "background-color":"#005ba5","color":"#ffffff", "font-size":"14px"});
         		$(".events td").css({'padding':'10px 20px 10px 10px'});
         		sym.$("tableMc").css({'overflow-y':'scroll'});
         		sym.$("tableMc").css({'overflow-x':'hidden'});
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<25; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         	
         			sym.$("txt24").text("50" + " " + (txtArr[24]));
         			sym.$("txt0").css({'font-size':16});
         		},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeOut(0);
         	
         sym.getSymbol("controlsMc").$("playBtn").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	if (sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").is(":visible") ) { 
         		start();
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeOut(0);
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("pause").fadeIn(0);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").play();
         		sym.getSymbol("profileMc").play();
         	}else{
         		stop();
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeIn(0);
         		sym.getSymbol("controlsMc").getSymbol("playBtn").$("pause").fadeOut(0);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").stop();
         		sym.getSymbol("profileMc").stop();
         	}
         }); 
         
         var timer = 0;
         function start(){
         	timer = setInterval(function(){
         		var stageWidth=sym.$("Stage").width();
         		var pos = sym.getSymbol("scrollMc").getSymbol("scrollableMc").getPosition();
         		sym.getSymbol("controlsMc").$("km").text((pos / 367.3).toFixed(1) + " " + (txtArr[23]));
         		sym.getSymbol("controlsMc").$("miles").text((pos / 591.6).toFixed(1) + " " + (txtArr[22]));
         		var x = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("racer").position();
         		sym.$("scrollMc").stop().animate({scrollLeft: x.left-100}, 100);
         		if (pos == 0 || pos == 15500) {
         			sym.getSymbol("controlsMc").getSymbol("playBtn").$("play").fadeIn(0);
         			sym.getSymbol("controlsMc").getSymbol("playBtn").$("pause").fadeOut(0);
         			abortTimer();
         		}
         	},150);
         }
         function stop() {
             clearInterval(timer);
         }
         start();
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("controlsMc").fadeIn(0);
         	// SCROLL START
         	sym.$("scrollMc").stop().animate({width:stageWidth}, 0);
         	sym.$("scrollMc").css({'overflow-y':'hidden'});
         	sym.$("scrollMc").css({'overflow-x':'hidden'});
         	// SCROLL END
         	sym.getSymbol("standBtn").$("plus").fadeIn(0);
         	setStyle();
         	if(stageWidth<800){
         	}else{
         	}
         	if(stageWidth<640){
         		sym.$("standBtn").animate({top:40, left:stageWidth-50}, 0);
         		sym.getSymbol("scrollMc").$("scrollableMc").css('cursor', 'ew-resize'); // SCROLL CODE
         		sym.$("tableMc").stop().animate({left:stageWidth + 20, width:270}, 0);
         	}else{
         		sym.$("standBtn").animate({top:-50}, 0);
         		sym.getSymbol("scrollMc").$("scrollableMc").css('cursor', 'default'); // SCROLL CODE
         		sym.$("tableMc").stop().animate({left:stageWidth-(stageWidth-480), width:stageWidth-480}, 0);
         	}
         	if (stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		sym.getSymbol("profileMc").$("profile320").fadeIn(0);
         		sym.getSymbol("profileMc").$("profileBg320").fadeIn(0);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		sym.getSymbol("profileMc").$("profile320").fadeOut(0);
         		sym.getSymbol("profileMc").$("profileBg320").fadeOut(0);
         	}
         	setStyleUpdate();
         }
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------------------------------------------------------------- 
         // MOUSE SCROLL SYMBOL
         var x,left,down;
         sym.$("scrollMc").on('touchstart mousedown', function(e){
             e.stopPropagation(); e.preventDefault();
             abortTimer();
             down=true;
             x=e.pageX;
             left=$(this).scrollLeft();
         });
         
         sym.$("scrollMc").on('touchmove mousemove', function(e){
         	e.stopPropagation(); e.preventDefault();
         	abortTimer();
             if(down){
                 var newX=e.pageX;
                 sym.$("scrollMc").scrollLeft(left-newX+x);    
             }
         });
         	sym.$("scrollMc").on('touchend mouseup', function(e){
         		down=false;
         	});
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------------------------------------------------------------- 
         // TOGGLE STANDFIRST BUTTON
         sym.$("standBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	var stageWidth=sym.$("Stage").width();
         	if (sym.getSymbol("standBtn").$("plus").is(":visible") ) { 
         		sym.getSymbol("standBtn").$("plus").fadeOut(0);
         		sym.$("tableMc").stop().animate({left:stageWidth-270}, 200);
         		sym.$("standBtn").stop().animate({left:stageWidth-320}, 200);
         		hideControls();
         	}else{
         		sym.getSymbol("standBtn").$("plus").fadeIn(0);
         		sym.$("tableMc").stop().animate({left:stageWidth+20}, 200);
         		sym.$("standBtn").stop().animate({left:stageWidth-50}, 180);
         		showControls();
         	}
         }); 
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function hideControls() {
         	sym.$("controlsMc").fadeOut(0);
         	sym.$("playNext").fadeOut(0);
         	sym.$("playBack").fadeOut(0);
         }
         
         function showControls() {
         	sym.$("controlsMc").fadeIn(0);
         	sym.$("playNext").fadeIn(0);
         	sym.$("playBack").fadeIn(0);
         }
         //--------------------------------------------------------------------------------------------------------
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SET STYLE SETTING 
         function setStyle() {
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "height":"auto", "width":"auto", "padding":"6px", "padding-top":"6px"});
         	sym.getSymbol("styleHead").$("headlineTxt").stop().animate({width:stageWidth-0}, 0);
         	sym.getSymbol("styleBase").$("creditTxt").animate({left:stageWidth-120}, 0);
         }
         function setStyleUpdate(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyleUpdate();
         //--------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         		hideControls();
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         		showControls();
         	}
         }); 
         //--------------------------------------------------------------------------------------------------------
         $(window).on('resize',initSize);
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------- END -------------------------------------------------
         //--------------------------------------------------------------------------------------------------------

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'standBtn'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'courseContMc'
   (function(symbolName) {   
   
   })("courseContMc");
   //Edge symbol end:'courseContMc'

   //=========================================================
   
   //Edge symbol: 'txtMc'
   (function(symbolName) {   
   
   })("txtMc");
   //Edge symbol end:'txtMc'

   //=========================================================
   
   //Edge symbol: 'prifileMc'
   (function(symbolName) {   
   
   })("profileMc");
   //Edge symbol end:'profileMc'

   //=========================================================
   
   //Edge symbol: 'controlsMc'
   (function(symbolName) {   
   
   })("controlsMc");
   //Edge symbol end:'controlsMc'

   //=========================================================
   
   //Edge symbol: 'tablesMc'
   (function(symbolName) {   
   
   })("tableMc");
   //Edge symbol end:'tableMc'

   //=========================================================
   
   //Edge symbol: 'Symbol_1'
   (function(symbolName) {   
   
   })("Symbol_1");
   //Edge symbol end:'Symbol_1'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33519");