/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('touchstart click');
         	var clicked = 0;
         	var btnNo = 0;
         	var counter = 0;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var whiteTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         	
         	for (var b=0;b<12; b++){
         		sym.$("car"+b).attr("src", "images/car" + b + ".png");
         		sym.$("car"+b).stop().animate ({opacity:0}, 0);
         	}
         	
         	var outBtn  = {"background-color":"rgba(160,160,160,1)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         	
         	var txt=[];
         	for(var i=0;i<13;i++){
         	txt[i] = sym.$("txt"+i).css({"pointer-events":"none"});
         	}
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33481.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<12; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("btnsMc").stop().animate ({left:stageWidth/2-115}, 0);
         
         	setStyle();
         
         	for (var b=0;b<12; b++){
         		sym.$("car" + (counter - b)).stop().animate ({opacity:0, left:0, top:200, width:150, height:88}, 300, 'easeInOutCubic');
         		sym.$("car" + (counter + b)).stop().animate ({opacity:0, left:650, top:200, width:150, height:88}, 300, 'easeInOutCubic');
         		}
         
         		sym.$("txt0").empty();
         		sym.$("txt0").append(txtArr[counter]);
         
         		if (counter < 1) {
         			sym.getSymbol("btnBackMc").$("btnBack").fadeOut(0);
         			sym.$("btnBackMc").fadeOut(0);
         		}else{
         			sym.$("btnBackMc").fadeIn(0);
         		}
         		if (counter > 10) {
         			sym.getSymbol("btnNextMc").$("btnBack").fadeOut(0);
         			sym.$("btnNextMc").fadeOut(0);
         		}else{
         			sym.$("btnNextMc").fadeIn(0);
         		}
         	if(stageWidth<800){
         		sym.$("car" + counter).stop().animate ({opacity:1, left:0, top:100, width:stageWidth, height:stageWidth/2}, 400, 'easeInOutCubic');
         	}else{
         		sym.$("car" + counter).stop().animate ({opacity:1, left:0, top:40, width:stageWidth, height:stageWidth/2}, 400, 'easeInOutCubic');
         	}
         	if(stageWidth<640){
         		sym.$("car" + counter).stop().animate ({opacity:1, left:0, top:130, width:stageWidth, height:stageWidth/2}, 400, 'easeInOutCubic');
         	}else{
         
         	}
         	if (stageWidth<480){
         		sym.$("car" + counter).stop().animate ({opacity:1, left:0, top:160, width:stageWidth, height:stageWidth/2}, 400, 'easeInOutCubic');
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		//
         	}
         		resetmenu();
         		sym.getSymbol("btnsMc").getSymbol("dot" + (counter)).$("btnClick").fadeIn(0);
         }
         
         	// MAKE ELEMENTS INVISIBLE
         	sym.$("btnBackMc").fadeOut(0);
         
         	// GLASS BUTTON
         	sym.$("btnNextMc").on(clickEventType, function(e){
         	e.stopPropagation(); e.preventDefault();
         	counter++;
         	initSize();
         	});
         
         	sym.$("btnBackMc").on(clickEventType, function(e){
         	e.stopPropagation(); e.preventDefault();
         	counter--;
         	initSize();
         	});
         
         // MENU BUTTONS --------------------------------------------	
         menuArray = []; //the array that will hold references to the buttons.
         	for (var h = 0; h < 12; h++){
         		var menuBtnSymbols = sym.getSymbol("btnsMc").getSymbol("dot" +h);
         			menuBtnSymbols.setVariable("menuId", h);
                  	 menuArray.push(menuBtnSymbols);
                  }
         
                  $.each(menuArray, function( count, menuInTheArray ){
                  	 var menuBtnItem = $(menuInTheArray); 
                  	 var menuBtnElement = menuInTheArray.getSymbolElement();
                  	 menuBtnElement.bind (clickEventType, {menuId:count}, menuBtnClick);
                  	}
                  )
         
         	function resetmenu(){
         		for (var h=0; h<menuArray.length; h++){
                  menuArray[h].$("btnClick").fadeOut(0);
                  menuArray[h].$("btnOver").fadeOut(0);
         		}
         	}
         	resetmenu();
         
         	function menuBtnClick (e){
         		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
         		resetmenu();
         		sym.getSymbol("btnsMc").getSymbol("dot" + (menuMenu_id)).$("btnClick").fadeIn(0);
         		counter = menuMenu_id;
         		initSize();
         	}
         
         sym.getSymbol("btnsMc").getSymbol("dot0").$("btnClick").fadeIn(0);
         
         sym.$("swipe").on("swipeleft",function(){
         		e.stopPropagation(); e.preventDefault();
         		if (counter > 10) {
         
         		}else{
         			counter++;
         			initSize();
         		}
               });
         sym.$("swipe").on("swiperight",function(){
         		e.stopPropagation(); e.preventDefault();
         		if (counter < 1) {
         
         		}else{
         			counter--;
         			initSize();
         		}
               });
         
         //--------------------------------------------------------------------------------------------------------
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SET STYLE SETTING 
         function setStyle() {
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "height":"auto", "width":"auto", "padding":"6px", "padding-top":"6px"});
         	sym.getSymbol("styleBase").$("creditTxt").animate({left:stageWidth-120}, 0);
         }
         //--------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.preventDefault(); e.stopPropagation();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //--------------------------------------------------------------------------------------------------------
         $(window).on('resize',initSize);
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------- END -------------------------------------------------
         //--------------------------------------------------------------------------------------------------------

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'btnsMc'
   (function(symbolName) {   
   
   })("btnsMc");
   //Edge symbol end:'btnsMc'

   //=========================================================
   
   //Edge symbol: 'dot0'
   (function(symbolName) {   
   
   })("dot0");
   //Edge symbol end:'dot0'

   //=========================================================
   
   //Edge symbol: 'btnBackMc'
   (function(symbolName) {   
   
   })("btnBackMc");
   //Edge symbol end:'btnBackMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33481");