/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clicked = 0;
         	var btnNo = 0;
         	var swipe = 0;
         	var swipeNo = 0;
         	var standTop = 70;
         	var mobile = 0;
         	var noBg = 0;
         	var planePos = 0;
         	var togVert = 0;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.getSymbol("introMc").$("standTxt").css({"pointer-events":"none", "background-color":"rgba(0,0,0,0.7)", "height":"auto","padding":"10px","padding-left":"15px","padding-right":"15px"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	var blackBox = {"background-color":"rgba(0,0,0,0.8)", "width":"auto", "height":"auto", "padding":"6px", "padding-right":"15px",  "padding-bottom":"15px", "pointer-events":"none"};
         	var whiteTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         	var capBox = {"background-color":"rgba(0,0,0,0.8)", "padding":"10px", "pointer-events":"none"};
         	
         // MENU TEXT START
         	var menuTxt=[];
         	menuTxt[0] = sym.getSymbol("menuBtn0").$("txt").css({"pointer-events":"none"});
         	menuTxt[1] = sym.getSymbol("menuBtn1").$("txt").css({"pointer-events":"none"});
         	menuTxt[2] = sym.getSymbol("menuBtn2").$("txt").css({"pointer-events":"none"});
         	menuTxt[3] = sym.getSymbol("menuBtn3").$("txt").css({"pointer-events":"none"});
         	var menuArr=[];
         	var outBtn  = {"background-color":"rgba(137,152,105,1)"};
         	var overBtn = {"background-color":"rgba(90,110,45,1)"};
         
         	var txt=[];
         	for (var i=0; i<34;i++){
         		txt[i] = sym.getSymbol("mapMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[34] = sym.$("txt34").css({"pointer-events":"none"});
         	for (var i=35; i<45;i++){
         		txt[i] = sym.getSymbol("menMc").$("txt"+i).css({"pointer-events":"none", "padding":"0px"});
         	}
         	txt[45] = sym.getSymbol("menMc").getSymbol("menHeadMc").$("txt45").css({"pointer-events":"none"});
         	txt[46] = sym.getSymbol("menMc").getSymbol("menHeadMc").$("txt46").css({"pointer-events":"none"});
         	txt[47] = sym.$("txt47").css({"pointer-events":"none"});
         	txt[48] = sym.$("txt48").css({"pointer-events":"none"});
         	txt[49] = sym.getSymbol("planesMc").$("txt49").css({"pointer-events":"none"});
         	txt[50] = sym.$("txt50").css({"pointer-events":"none"});
         	txt[51] = sym.$("txt51").css({"pointer-events":"none"});
         	txt[52] = sym.$("txt52").css({"pointer-events":"none"});
         	txt[53] = sym.$("txt53").css({"pointer-events":"none"});
         	txt[54] = sym.$("txt54").css({"pointer-events":"none"});
         	txt[55] = sym.$("txt55").css({"pointer-events":"none"});
         	txt[56] = sym.getSymbol("planesMc").getSymbol("lossesMc").getSymbol("lossesTopMc").$("txt56").css({"pointer-events":"none"});
         	txt[57] = sym.getSymbol("planesMc").getSymbol("lossesMc").getSymbol("lossesTopMc").$("txt57").css({"pointer-events":"none"});
         	txt[58] = sym.getSymbol("planesMc").getSymbol("lossesMc").getSymbol("lossesTopMc").$("txt58").css({"pointer-events":"none"});
         	txt[59] = sym.getSymbol("planesMc").getSymbol("lossesMc").getSymbol("lossesTopMc").$("txt59").css({"pointer-events":"none"});
         	txt[60] = sym.getSymbol("planesMc").getSymbol("lossesMc").getSymbol("lossesTopMc").$("txt60").css({"pointer-events":"none"});
         	txt[61] = sym.getSymbol("planesMc").getSymbol("lossesMc").getSymbol("lossesTopMc").$("txt61").css({"pointer-events":"none"});
         	txt[62] = sym.getSymbol("planesMc").getSymbol("lossesMc").getSymbol("lossesGraphMc").$("txt62").css({"pointer-events":"none"});
         	txt[63] = sym.getSymbol("planesMc").getSymbol("lossesMc").getSymbol("lossesGraphMc").$("txt63").css({"pointer-events":"none"});
         	txt[64] = sym.getSymbol("planesMc").getSymbol("lossesMc").getSymbol("lossesGraphMc").$("txt64").css({"pointer-events":"none"});
         	txt[65] = sym.getSymbol("planesMc").getSymbol("lossesMc").getSymbol("lossesGraphMc").$("txt65").css({"pointer-events":"none"});
         	txt[66] = sym.getSymbol("planesMc").getSymbol("lossesMc").getSymbol("lossesGraphMc").$("txt66").css({"pointer-events":"none"});
         	txt[67] = sym.getSymbol("planesMc").getSymbol("lossesMc").getSymbol("lossesGraphMc").$("txt67").css({"pointer-events":"none"});
         	txt[68] = sym.getSymbol("planesMc").getSymbol("lossesMc").getSymbol("lossesGraphMc").$("txt68").css({"pointer-events":"none"});
         	txt[69] = sym.getSymbol("planesMc").$("txt69").css({"pointer-events":"none"});
         	txt[70] = sym.$("txt70").css({"pointer-events":"none"});
         
         
         	//txt[16] = sym.$("txt16").css({"pointer-events":"none", "background-color":"#3d3d3d", "height":"auto","padding":"10px","padding-left":"15px","padding-right":"15px"});
         	sym.getSymbol("mapMc").$("txt25").css({"pointer-events":"none", "background-color":"black", "width":"auto","padding":"5px","border-radius":"5px"});
         	sym.getSymbol("mapMc").$("txt29").css({"pointer-events":"none", "background-color":"black", "width":"auto","padding":"5px","border-radius":"5px"});
         	sym.getSymbol("mapMc").$("txt31").css({"pointer-events":"none", "background-color":"black", "width":"auto","padding":"5px","border-radius":"5px"});
         	sym.getSymbol("mapMc").$("txt33").css({"pointer-events":"none", "background-color":"white", "width":"auto","height":"auto","padding":"5px","border-radius":"5px", "border-width":"1px","border-style":"solid", "border-color":"rgba(200,200,200,1)",});
         
         	var txtArr=[];
         
         	var tableArr=[]; //create array of tables
         	for (var i=0; i<3;i++){
         		tableArr[i]=[];//create array for each table
         	}
         	var strapArr=[]; //create strap array
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33468.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css({"background-color":custonCol});
         			stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("introMc").$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         //create table
         			var newTable="<div id='newTab'>";
         			var dataTab1;
         			newTable+="<div id='newtab1'>";
         			$(xml).find('table1').each(function() {
         				var strap=$(this).find('strap').text();
         				newTable+="<div class='redstrap'>"+strap+"</div>";
         				newTable+="<table class='events'>";
         				$(this).find('number1').each(function() {
         					dataTab1 = $(this).find("date1").text();
         					newTable+="<tr><td>"+dataTab1+"</td></tr>";
         				});
         				newTable+="</table>";
         			});
         
         		sym.getSymbol("tablesMc").$("tableMc").append(newTable);
         		//apply styles
         		$("#newTab").css({"font-family":"Pragmatica-web, sans-serif"});
         		$(".events").css({"text-align":"left","color":"#000000","font-size":"13px","line-height":"15px",'border':0,'border-collapse':'collapse'});
         		$("#newtab1 tr:odd").css({"background-color":"#fff"});
         		$("#newtab1 tr:even").css({"background-color":"#ddd"});
         		$("#newtab1 tr:first-child").css({"text-align":"center", "background-color":"#333","color":"#ffffff", "font":"13px, Pragmatica-web, sans-serif"});
         		$(".events td").css({'padding':'10px 20px 10px 10px'});
         		$(".events img").css({'max-width':'195px','padding-bottom':'10px'});
         		sym.getSymbol("tablesMc").$("tableMc").css({'overflow-y':'scroll'});
         
         			// MENU TEXT START
         			for (var i=0; i<4; i++){
         				menuArr[i]=$(xml).find('menuTxt'+i).text();
         				menuTxt[i].html(menuArr[i]);
         			} // MENU TEXT END
         
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<70; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         			sym.$("txt34").css({"font-size":"15px", "pointer-events":"none", "background-color":"rgba(0,0,0,0.8)", "height":"auto","padding":"10px","padding-left":"15px","padding-right":"15px"});
         			sym.getSymbol("menMc").getSymbol("menHeadMc").$("txt45").css({"font-size":"18px"});
         			sym.getSymbol("menMc").getSymbol("menHeadMc").$("txt46").css({"font-size":"18px"});
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         function timelineScroll(){
         // Map scroll position to timeline position
         var tabHeight = sym.getSymbol("tablesMc").$("#newTab").height();
         var tableHeight = sym.getSymbol("tablesMc").$("tableMc").height();
         var scrollPos = sym.getSymbol("tablesMc").$("tableMc").scrollTop();
         var duration = sym.getSymbol("timelineMc").getDuration();
         var percent = scrollPos / (tabHeight - tableHeight);
         var time = duration * percent;
         sym.getSymbol("timelineMc").stop(time);
         sym.getSymbol("tablesMc").$("scrollDown").fadeOut(200);
         sym.getSymbol("tablesMc").$("tableMc").css({'overflow-y':'auto'});
         }	
         sym.getSymbol("tablesMc").$("tableMc").on('scroll',timelineScroll);	
         sym.getSymbol("tablesMc").$("tableMc").css({'overflow-x':'hidden'});
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("introMc").stop(stageWidth*10);
         	sym.$("mapMc").stop().animate({width:stageWidth+230}, 0);
         	sym.$("timelineMc").stop().animate({width:stageWidth+200}, 0);
         	sym.$("timelineMc").css({'overflow-x':'scroll'});
         	sym.$("timelineMc").css({'overflow-y':'hidden'});
         	sym.getSymbol("toggleBtn").$("plus").fadeIn(0);
         	sym.$("toggleBtn").stop().animate({left:stageWidth-50}, 0);
         	setStyle();
         	if(stageWidth<800){
         		sym.getSymbol("planesMc").$("lossesMc").stop().animate({left:stageWidth+20}, 0);
         		planePos = (stageWidth-sym.getSymbol("planesMc").$("plane0").width())/2;
         		sym.getSymbol("planesMc").$("plane" + clickAux).stop().animate ({left:stageWidth}, 0, function(){ sym.getSymbol("planesMc").$("plane"+ clickAux).stop().animate ({left:planePos}, 0); });
         		noBg = 3;
         		swipeNo = 3;
         		if(togVert == 1){
         			sym.$("toggleBtn").fadeIn(0);
         		}
         		if(togVert == 0){
         			sym.$("toggleBtn").fadeOut(0);
         		}
         	}else{
         		sym.$("toggleBtn").fadeOut(0);
         		sym.getSymbol("planesMc").$("lossesMc").stop().animate({left:0}, 0);
         		sym.getSymbol("planesMc").$("plane" + clickAux).stop().animate ({left:stageWidth}, 0, function(){ sym.getSymbol("planesMc").$("plane"+ clickAux).stop().animate ({left:planePos}, 0); });
         		noBg = 4;
         		planePos = 320;
         		swipeNo = 2;
         	}
         	if(stageWidth<640){
         		sym.$("txt34").css({"height":"auto"});
         		sym.getSymbol("introMc").$("standTxt").css({"height":"auto"});
         		sym.$("txt34").stop().animate({top:0-sym.$("txt34").height()}, 0);
         		noBg = 2;
         		swipeNo = 4;
         		if(togVert == 0){
         			sym.$("toggleBtn").fadeIn(0);
         		}
         	}else{
         		sym.$("txt34").css({"height":"512px"});
         		sym.getSymbol("introMc").$("standTxt").css({"height":"512px"});
         		sym.$("txt34").stop().animate({top:70}, 0);
         	}
         	if (stageWidth<480){
         		sym.$("toggleBtn").stop().animate({top:100}, 0);
         		sym.getSymbol("planesMc").getSymbol("lossesMc").$("lossesTopMc").stop().animate({top:30}, 0);
         		sym.getSymbol("planesMc").getSymbol("lossesMc").$("lossesGraphMc").stop().animate({top:10}, 0);
         		for (var i=0; i<7;i++){
         			sym.getSymbol("planesMc").$("plane"+i).stop().animate ({width:stageWidth, height:sym.getSymbol("planesMc").$("plane"+i).width()/3, top:60}, 0);
         		}
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":"16px"});		
         		standTop = 100;
         		sym.getSymbol("tablesMc").$("tableMc").stop().animate({width:stageWidth, height:482}, 0);
         		sym.$("mapMc").css('cursor', 'ew-resize'); // SCROLL CODE
         		sym.$("mapMc").css({'overflow-x':'scroll'});
         		for (var i=0; i<10;i++){
         			sym.getSymbol("menMc").$("bg"+i).stop().animate({width:stageWidth/noBg, left:(stageWidth/noBg)*i}, 0);
         			sym.getSymbol("menMc").$("txt"+(35+i)).stop().animate({width:stageWidth/noBg-10, left:5+(stageWidth/noBg)*i}, 0);
         			sym.getSymbol("menMc").$("man"+i).stop().animate({left:5+(stageWidth/noBg)*i}, 0);
         		}			
         	}else{
         		sym.$("toggleBtn").stop().animate({top:70}, 0);
         		sym.getSymbol("planesMc").getSymbol("lossesMc").$("lossesTopMc").stop().animate({top:0}, 0);
         		sym.getSymbol("planesMc").getSymbol("lossesMc").$("lossesGraphMc").stop().animate({top:0}, 0);
         		for (var i=0; i<7;i++){
         			sym.getSymbol("planesMc").$("plane"+i).stop().animate ({width:480, height:150, top:40}, 0);
         		}
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":"28px"});	
         		standTop = 70;
         		sym.getSymbol("tablesMc").$("tableMc").stop().animate({width:230, height:512}, 0);
         		sym.$("mapMc").css('cursor', 'default'); // SCROLL CODE
         		sym.$("mapMc").css({'overflow-x':'hidden'});
         		for (var i=0; i<10;i++){
         			sym.getSymbol("menMc").$("bg"+i).stop().animate({width:stageWidth/noBg, left:(stageWidth/noBg)*i}, 0);
         			sym.getSymbol("menMc").$("txt"+(35+i)).stop().animate({width:stageWidth/noBg-20, left:10+(stageWidth/noBg)*i}, 0);
         			sym.getSymbol("menMc").$("man"+i).stop().animate({left:10+(stageWidth/noBg)*i}, 0);
         		}
         	}
         	if (stageWidth<400){
         		for (var i=0; i<7;i++){
         			sym.getSymbol("planesMc").$("plane"+i).stop().animate ({width:stageWidth, height:sym.getSymbol("planesMc").$("plane"+i).width()/3, top:80}, 0);
         		}
         	}
         	sym.getSymbol("tablesMc").$("scrollDown").stop().animate({left:sym.getSymbol("tablesMc").$("tableMc").width()/2-33}, 0);
         	setStyleUpdate();
         	swipe = 0;
         	sym.$("menMc").stop().animate({left:-stageWidth+stageWidth},0);
         	sym.getSymbol("menMc").$("bg").stop().animate({width:stageWidth/noBg*10}, 0);
         	sym.getSymbol("menMc").getSymbol("menHeadMc").$("menHeadBg").stop().animate({width:stageWidth/noBg*10}, 0);
         	sym.getSymbol("menMc").getSymbol("menHeadMc").$("txt46").stop().animate({left:5+(stageWidth/noBg)*4}, 0);
         	sym.getSymbol("menMc").$("swipePanel").stop().animate({width:stageWidth/noBg*10}, 0);
         
         }
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // MENU BUTTONS
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<4; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtn" + h).$("bg").css(outBtn);
         		sym.$("timelineMc").fadeOut(0);
         		sym.$("mapMc").fadeOut(0);
         		sym.$("planesMc").fadeOut(0);
         		sym.$("menMc").fadeOut(0);
         		sym.$("navBtns").fadeOut(0);
         		sym.$("tablesMc").stop().animate ({opacity:0}, 200, function(){ sym.$("tablesMc").fadeOut(0); });
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		var stageWidth=sym.$("Stage").width();
         		sym.$("txt34").stop().animate({opacity:0}, 0);
         		sym.$("introMc").stop().animate ({opacity:0}, 200, function(){ sym.$("introMc").fadeOut(0); });
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		if (menuNo == 0){
         			sym.$("txt34").stop().animate({opacity:1}, 0);
         			togVert = 0;
         			sym.$("mapMc").fadeIn(0);
         		}
         		if (menuNo == 1){
         			sym.$("toggleBtn").fadeOut(0);
         			sym.$("navBtns").fadeIn(0);
         			sym.$("menMc").fadeIn(0);
         			sym.getSymbol("navBtns").$("navBtnBack").fadeOut(0);
         		}
         		if (menuNo == 2){
         			sym.$("toggleBtn").fadeOut(0);
         			sym.$("tablesMc").stop().animate ({opacity:1}, 0, function(){ sym.$("tablesMc").fadeIn(200); });
         			sym.$("timelineMc").fadeIn(0);
         		}
         		if (menuNo == 3){
         			togVert = 1;
         			sym.$("planesMc").fadeIn(0);
         		}
         		initSize();
         	};
         };
         for (var b=0;b<menuArray.length;b++){
         	sym.$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         	sym.$("menuBtn"+b).css({'cursor':'pointer'});
         }
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // MOUSE SCROLL SYMBOL
         var x,left,down;
         sym.$("timelineMc").mousedown(function(e){
             e.stopPropagation(); e.preventDefault();
             down=true;
             x=e.pageX;
             left=$(this).scrollLeft();
         });
         
         sym.$("timelineMc").mousemove(function(e){
         	e.stopPropagation(); e.preventDefault();
             if(down){
                 var newX=e.pageX;
                 sym.$("timelineMc").scrollLeft(left-newX+x);    
             }
         });
         sym.$("timelineMc").mouseup(function(e){down=false;});
         sym.$("mapMc").mousedown(function(e){
             e.stopPropagation(); e.preventDefault();
             down=true;
             x=e.pageX;
             left=$(this).scrollLeft();
         });
         
         sym.$("mapMc").mousemove(function(e){
         	e.stopPropagation(); e.preventDefault();
             if(down){
                 var newX=e.pageX;
                 sym.$("mapMc").scrollLeft(left-newX+x);    
             }
         });
         sym.$("mapMc").mouseup(function(e){down=false;});
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // TOGGLE BUTTON
         sym.$("toggleBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	var stageWidth=sym.$("Stage").width();
         	if (sym.getSymbol("toggleBtn").$("plus").is(":visible") ) { 
         		sym.getSymbol("toggleBtn").$("plus").fadeOut(0);
         		if (togVert == 0){
         			sym.$("txt34").stop().animate({top:standTop}, 140);
         			sym.$("toggleBtn").stop().animate({top:standTop + sym.$("txt34").height() +20}, 200);
         		}else{
         			sym.getSymbol("planesMc").$("lossesMc").stop().animate({left:stageWidth-320}, 200);
         		}
         	}else{
         		if (togVert == 0){
         			sym.$("txt34").stop().animate({top:0-sym.$("txt34").height()}, 220);
         			sym.$("toggleBtn").stop().animate({top:standTop}, 100);
         		}else{
         			sym.getSymbol("planesMc").$("lossesMc").stop().animate({left:stageWidth+20}, 200);
         		}
         		sym.getSymbol("toggleBtn").$("plus").fadeIn(0);
         
         	}
         }); 
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SWIPE IMAGE
         sym.$("menMc").on("swipeleft",function(){
         	e.stopPropagation(); e.preventDefault();
         		if (swipe >= swipeNo) {
         
         		}else{
         			swipe++;
         			swipeIt();
         		}
         }); 
         
         sym.$("menMc").on("swiperight",function(){
         	e.stopPropagation(); e.preventDefault();
         		if (swipe <= 0) {
         
         		}else{
         			swipe--;
         			swipeIt();
         		}
         }); 
         // NAV BUTTONS
         sym.getSymbol("navBtns").$("navBtnNext").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	swipe++;
         	swipeIt();
         });
         sym.getSymbol("navBtns").$("navBtnBack").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	swipe--;
         	swipeIt();
         });
         
         function swipeIt() {
         	var stageWidth=sym.$("Stage").width();
         	sym.$("menMc").stop().animate({left:swipe*(-stageWidth)}, 100);
         	if (swipeNo==swipe){
         		sym.$("menMc").stop().animate({left:-(stageWidth/noBg)*(10-noBg)}, 100);
         		sym.getSymbol("navBtns").$("navBtnNext").fadeOut(0);
         	}else{
         		sym.$("menMc").stop().animate({left:swipe*(-stageWidth)}, 100);
         		sym.getSymbol("navBtns").$("navBtnNext").fadeIn(0);
         		}
         	if (swipe <= 0) {
         		sym.getSymbol("navBtns").$("navBtnBack").fadeOut(0);
         	}else{
         		sym.getSymbol("navBtns").$("navBtnBack").fadeIn(0);
         		}
         }
         sym.getSymbol("navBtns").$("navBtnBack").fadeOut(0);
         
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         // PLANE BUTTONS
         var clickAux = 0;
         auxArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<7; a++){
         	auxArray.push(a);
         }
         
         function resetAux(){
         	for (var a=0; a<auxArray.length; a++){
         		var stageWidth=sym.$("Stage").width();
         		sym.getSymbol("planesMc").getSymbol("planeBtns").$("planeGlow" + a).fadeOut(0);
         		sym.getSymbol("planesMc").$("plane" + a).stop().animate ({left:-stageWidth-1000}, 200);
         	}
         }
         resetAux();
         
         // AUX CLICK
         var auxBtnClick = function(auxNo){ //to handle lexical scope
         	return function (e) {
         	e.preventDefault(); e.stopPropagation();
         		var stageWidth=sym.$("Stage").width();
         		clickAux = auxNo;
         		resetAux();
         		sym.getSymbol("planesMc").getSymbol("planeBtns").$("planeGlow" + auxNo).fadeIn(0);
         		sym.getSymbol("planesMc").$("plane" + auxNo).stop().animate ({left:stageWidth}, 0, function(){ sym.getSymbol("planesMc").$("plane" + auxNo).stop().animate ({left:planePos}, 200); });
         		sym.getSymbol("planesMc").$("txt49").empty();
         		sym.getSymbol("planesMc").$("txt49").append(txtArr[auxNo+49]);
         	};
         };
         
         for (var b=0;b<auxArray.length;b++){
         	sym.getSymbol("planesMc").getSymbol("planeBtns").$("planeBtn"+b).on('touchstart click',auxBtnClick(b));
         	sym.getSymbol("planesMc").getSymbol("planeBtns").$("planeBtn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("planesMc").getSymbol("planeBtns").$("planeGlow0").fadeIn(0);
         
         
         
         //--------------------------------------------------------------------------------------------------------
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SET STYLE SETTING 
         function setStyle() {
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("menMc").stop(stageWidth*10);
         	sym.getSymbol("planesMc").stop(stageWidth*10);
         	sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "height":"auto", "width":"auto", "padding":"6px", "padding-top":"6px"});
         	sym.getSymbol("styleHead").$("headlineTxt").stop().animate({width:stageWidth-12}, 0);
         	sym.getSymbol("styleBase").$("creditTxt").animate({left:stageWidth-120}, 0);
         }
         function setStyleUpdate(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyleUpdate();
         //--------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         //--------------------------------------------------------------------------------------------------------
         $(window).on('resize',initSize);
         initSize();
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------- END -------------------------------------------------
         //--------------------------------------------------------------------------------------------------------

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'Base'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'tableMc'
   (function(symbolName) {   
   
   })("tableMc");
   //Edge symbol end:'tableMc'

   //=========================================================
   
   //Edge symbol: 'tablesMc'
   (function(symbolName) {   
   
   })("tablesMc");
   //Edge symbol end:'tablesMc'

   //=========================================================
   
   //Edge symbol: 'timelineMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5500, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("timelineMc");
   //Edge symbol end:'timelineMc'

   //=========================================================
   
   //Edge symbol: 'introMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("introMc");
   //Edge symbol end:'introMc'

   //=========================================================
   
   //Edge symbol: 'bombMc'
   (function(symbolName) {   
   
      

      

      

      

   })("bombMc");
   //Edge symbol end:'bombMc'

   //=========================================================
   
   //Edge symbol: 'toggleBtn_1'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'introMovie'
   (function(symbolName) {   
   
   })("introMovie");
   //Edge symbol end:'introMovie'

   //=========================================================
   
   //Edge symbol: 'galleryMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("planesMc");
   //Edge symbol end:'planesMc'

   //=========================================================
   
   //Edge symbol: 'videoMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("menMc");
   //Edge symbol end:'menMc'

   //=========================================================
   
   //Edge symbol: 'menHeadMc'
   (function(symbolName) {   
   
   })("menHeadMc");
   //Edge symbol end:'menHeadMc'

   //=========================================================
   
   //Edge symbol: 'navBtns'
   (function(symbolName) {   
   
   })("navBtns");
   //Edge symbol end:'navBtns'

   //=========================================================
   
   //Edge symbol: 'navBtn'
   (function(symbolName) {   
   
   })("navBtn");
   //Edge symbol end:'navBtn'

   //=========================================================
   
   //Edge symbol: 'planeBtns'
   (function(symbolName) {   
   
   })("planeBtns");
   //Edge symbol end:'planeBtns'

   //=========================================================
   
   //Edge symbol: 'losses'
   (function(symbolName) {   
   
   })("losses");
   //Edge symbol end:'losses'

   //=========================================================
   
   //Edge symbol: 'lossesMc'
   (function(symbolName) {   
   
   })("lossesMc");
   //Edge symbol end:'lossesMc'

   //=========================================================
   
   //Edge symbol: 'lossesTopMc'
   (function(symbolName) {   
   
   })("lossesTopMc");
   //Edge symbol end:'lossesTopMc'

   //=========================================================
   
   //Edge symbol: 'lossesGraphMc'
   (function(symbolName) {   
   
   })("lossesGraphMc");
   //Edge symbol end:'lossesGraphMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33468");