/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clicked = 0;
         	var btnNo = 0;
         	var swipe = 0;
         	var bgNo = 0;
         	var poolNo = 0;
         	var menuVis = 1;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var whiteTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         	// MENU TEXT START
         	var countryTxt=[];
         	var coachTxt=[];
         	var winsTxt=[];
         	var recordsTxt=[];
         	for (var i=0; i<20; i++){
         		countryTxt[i] = sym.getSymbol("menMc").$("country"+i).css({"pointer-events":"none","padding":"6px"});
         		coachTxt[i] = sym.getSymbol("menMc").$("coach"+i).css({"pointer-events":"none","padding":"6px"});
         		winsTxt[i] = sym.getSymbol("menMc").$("wins"+i).css({"pointer-events":"none","padding":"6px"});
         		recordsTxt[i] = sym.getSymbol("menMc").$("records"+i).css({"pointer-events":"none","padding":"6px"});
         	}
         	var recordsArr=[];
         	var winsArr=[];
         	var coachArr=[];
         	var countryArr=[];
         	var outBtn  = {"background-color":"rgba(160,160,160,0)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         	var txt=[];
         	for (var i=0;i<35;i++){
         	txt[i] = sym.$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[4] = sym.getSymbol("cupKeyMc").$("txt4").css({"pointer-events":"none","width":"auto"});
         	txt[5] = sym.getSymbol("cupKeyMc").$("txt5").css({"pointer-events":"none","width":"auto"});
         	txt[6] = sym.getSymbol("menuBtnsMc").$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.getSymbol("menuBtnsMc").$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.getSymbol("menuBtnsMc").$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.getSymbol("menuBtnsMc").$("txt9").css({"pointer-events":"none"});
         	var positionArr=[];
         	var notice;
         	var txtArr=[];
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33416.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         			notice=$(xml).find('notice').text();
         			// COUNTRY TEXT
         			for (var i=0; i<20; i++){
         				countryArr[i]=$(xml).find('country'+i).text();
         				countryTxt[i].html(countryArr[i]);
         				coachArr[i]=$(xml).find('coach'+i).text();
         				coachTxt[i].html(coachArr[i]);
         				winsArr[i]=$(xml).find('wins'+i).text();
         				winsTxt[i].html(winsArr[i]);
         				recordsArr[i]=$(xml).find('records'+i).text();
         				recordsTxt[i].html(recordsArr[i]);
         			} // MENU TEXT END
         			var positions=$(xml).find('positions').text();
         			positionArr=positions.split(';');
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<9; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         			for (var b=6;b<10; b++){
         				sym.getSymbol("menuBtnsMc").$("txt"+b).empty();
         				sym.getSymbol("menuBtnsMc").$("txt"+b).append(txtArr[b-6]);
         			}
         			sym.getSymbol("cupKeyMc").$("cupKey2").animate({left:-41 + sym.getSymbol("cupKeyMc").$("txt4").width()+45}, 0);
         			sym.getSymbol("cupKeyMc").$("txt5").animate({left:0 + sym.getSymbol("cupKeyMc").$("txt4").width()+80}, 0);
         			sym.$("txt0").css({"font-size":"18px"});
         	
         			for (var b=0;b<20; b++){
         				sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+b).$("txt").append(countryArr[b]);
         			}
         		},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         	for (var b=0;b<5; b++){
         		sym.getSymbol("menMc").$("team"+b).attr("src", "images/team" + b + ".jpg");
         	}
         
         //--------------------------------------------------------------------------------------------------------
         	// INITSIZE
         //--------------------------------------------------------------------------------------------------------
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	setStyle();
         	if(stageWidth < 800){
         		stageWidth=sym.$("Stage").width();
         		sym.$("slideMenuBtn").fadeIn(0);
         		sym.$("menuBtnsMc").fadeOut(0);
         		noBg = 2; swipeNo = 2;
         		menuVis = 0;
         	}else{
         		stageWidth = stageWidth-100;
         		sym.$("slideMenuBtn").fadeOut(0);
         		sym.$("menuBtnsMc").fadeIn(0);
         		noBg = 2; swipeNo = 2;
         		menuVis = 1;
         	}
         	if(stageWidth <700){
         		menuVis = 0;
         	}else{
         
         	}
         	if (stageWidth <600){
         		stageWidth=sym.$("Stage").width();
         		stageWidth = stageWidth-100;
         		sym.$("slideMenuBtn").fadeOut(0);
         		sym.$("menuBtnsMc").fadeIn(0);
         		noBg = 1; swipeNo = 4;
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		menuVis = 1;
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	if (stageWidth<400-100){
         		stageWidth=sym.$("Stage").width();
         		sym.$("slideMenuBtn").fadeIn(0);
         		sym.$("menuBtnsMc").fadeOut(0);
         		menuVis = 0;
         	}else{
         
         	}
         	swipe = 0;
         	sym.$("menMc").stop().animate({left:-stageWidth+stageWidth},0);
         	sym.getSymbol("navBtns").$("navBtnBack").fadeOut(0);
         	sym.getSymbol("navBtns").$("navBtnNext").fadeIn(0);
         	for (var i=0; i<5;i++){
         		sym.getSymbol("menMc").$("bg"+i).stop().animate({width:stageWidth/noBg, left:(stageWidth/noBg)*i}, 0);
         		sym.getSymbol("menMc").$("team"+i).stop().animate({left:(stageWidth/noBg)*i}, 0);
         		sym.getSymbol("menMc").$("teamBg"+i).stop().animate({width:stageWidth/noBg, left:(stageWidth/noBg)*i}, 0);
         		sym.getSymbol("menMc").$("country"+i).stop().animate({left:40+(stageWidth/noBg) *i}, 0);
         		sym.getSymbol("menMc").$("coach"+i).stop().animate({left:(stageWidth/noBg) *i}, 0);
         		sym.getSymbol("menMc").$("wins"+i).stop().animate({left:40+(stageWidth/noBg) *i}, 0);
         		sym.getSymbol("menMc").$("records"+i).stop().animate({left:(stageWidth/noBg) *i}, 0);
         	}
         }
         //--------------------------------------------------------------------------------------------------------
         //---------------------------------------------------------LIVE SQUAD DATA
         var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://www.graphicnews.org/")+ "infostradasports/api.php";
         var teamIDs =[831,714,686,819,1871,123,723,2867,927,662,718,915,929,5037,2076,298,10853,1041,493,46];//'AUS','ENG','FIJ','WAL','URU','RSA','SAM','JPN','SCO','USA','NZL','ARG','TGA','GEO','NAM','FRA','IRE','ITA','CAN','ROU'
         function loadTeam(number, panel){
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn=33382&yr=2015&sport=rugby&squad="+teamIDs[number],
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			sym.getSymbol("menMc").$("bg"+panel).empty();
         			squadData=data;
         			if(squadData.length>0){
         				for (var i = 0; i <squadData.length; i++) {
         					var shirtNr = (squadData[i].c_ShirtNr!=null)?squadData[i].c_ShirtNr:"";
         					var player = squadData[i].c_Person;
         					var position = squadData[i].c_FunctionShort;
         					var posArr=['H','P','LHP','THP','2R','C','SH','FH','W','LW','RW','B','FB','4L','5L','BF','OF','N8','ICtr','OCtr','BR'];
         					for (var p=0;p<21;p++){
         						position==posArr[p]?position=positionArr[p]:"";//position to what's in the array - if it matches, use relevant entry in xml array
         					}
         					var role=squadData[i].n_FunctionType;
         							if (role!=16){
         								var squadlist = "<div class='sqdPlayer' id='sqd"+panel+"player"+i+"'>";
         								squadlist += "<div class='squadCol1' id='sqd"+panel+"shirt"+i+"'></div>";
         								squadlist += "<div class='squadCol2' id='sqd"+panel+"playerName"+i+"'>"+player+"</div>";
         								squadlist += "<div class='squadCol5' id='sqd"+panel+"pos"+i+"'></div>";
         								squadlist += "</div>";
         								sym.getSymbol("menMc").$("bg"+panel).append(squadlist);   
         							}
         							//make alternate color rows, also alternating odd/even panels
         							i%2==0?panel%2==0?$('#sqd'+panel+'player'+i).css({'width':'100%', 'display':'inline-table','background-color':'rgba(255,255,255,0.1)'}):$('#sqd'+panel+'player'+i).css({'width':'100%', 'display':'inline-table','background-color':'rgba(0,0,0,0.4)'}):$('#sqd'+panel+'player'+i).css({'width':'100%', 'display':'inline-table'});													         
         							$('.squadCol1').css({'width':'10%', 'color':'rgb(0,156,178)','padding-left':'3px', 'text-align':'right','display':'table-cell'});
         							$('.squadCol2').css({'width':'90%', 'padding-left':'3%','display':'table-cell'});
         							$('#sqdplayerName'+i).css({'font-weight':400});
         							$('#sqd'+panel+'shirt'+i).text(shirtNr);
         							$('#sqd'+panel+'pos'+i).text(position);
         				}
         				$('.sqdPlayer').css({'width':'98%','padding':'0 5px 0 0','font-size':'12px','font-family':'pragmatica-web, sans-serif','color':'#fff'});
         				$('.squadCol1').css({'width':'5%', 'color':'rgb(0,156,178)','padding-left':'3px', 'text-align':'right','display':'table-cell'});
         				$('.squadCol2').css({'width':'50%', 'padding-left':'3%','display':'table-cell'});
         				$('.squadCol5').css({'width':'25%', 'display':'table-cell', 'text-align':'right','font-style':'italic','padding-right':'3px'});
         				$('.squadCol3').css({'width':'10%', 'display':'table-cell', 'text-align':'center'});
         				$('.squadCol4').css({'width':'10%', 'display':'table-cell', 'text-align':'right'});
         				$('.squadnat').css({'text-align':'right','font-style':'oblique','font-size':'90%'});
         				$(".coach").css({'font-weight':700});
         				sym.getSymbol("menMc").$("bg"+panel).css({'overflow-y':'auto','overflow-x':'hidden'});
         			}else{
         			sym.getSymbol("menMc").$("bg"+panel).html("<span style='padding:5px 10px;font-size:13px;font-family:pragmatica-web, sans-serif;color:#fff;font-weight:700'>"+notice+"</span>");
         			}
         		}
         	});
         }
         for (var t=0;t<5;t++){
         loadTeam(t, t);
         }
         //--------------------------------------------------------------------------------------------------------
         // MENU BUTTONS
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<20; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(outBtn);
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("txt").css({"color":"rgba(0,0,0,1)"});
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         	}
         }
         resetmenu();
         sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("txt").css({"color":"rgba(255,255,255,1)"});
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		clicked = menuNo;
         		swipe = clicked;
         		resetmenu();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + clicked).$("bg").css(overBtn);
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + clicked).$("txt").css({"color":"rgba(255,255,255,1)"});
         		if (clicked <= 4){
         			poolNo = 0;
         			sym.$("txt0").empty();
         			sym.$("txt0").append(txtArr[0]);
         		}
         		if (clicked >= 5){
         			poolNo = 5;
         			sym.$("txt0").empty();
         			sym.$("txt0").append(txtArr[1]);
         		}
         		if (clicked >= 10){
         			poolNo = 10;
         			sym.$("txt0").empty();
         			sym.$("txt0").append(txtArr[2]);
         		}
         		if (clicked >= 15){
         			poolNo = 15;
         			sym.$("txt0").empty();
         			sym.$("txt0").append(txtArr[3]);
         		}
         		swipe = clicked-poolNo;
         
         		if (menuVis == 1){
         			sym.$("menuBtnsMc").fadeIn(0);
         		}else{
         			sym.$("menuBtnsMc").fadeOut(0);
         		}
         		if (noBg == 2){
         			swipe = swipe/2
         		}else{
         			swipe = swipe
         		}
         		swipeIt();
         		for (var b=0; b<5; b++){
         			sym.getSymbol("menMc").$("team"+b).attr("src", "images/team" + (b+poolNo) + ".jpg");
         			sym.getSymbol("menMc").$("country"+b).empty();
         			sym.getSymbol("menMc").$("country"+b).append(countryArr[b+poolNo]);
         			sym.getSymbol("menMc").$("coach"+b).empty();
         			sym.getSymbol("menMc").$("coach"+b).append(coachArr[b+poolNo]);
         			sym.getSymbol("menMc").$("wins"+b).empty();
         			sym.getSymbol("menMc").$("wins"+b).append(winsArr[b+poolNo]);
         			sym.getSymbol("menMc").$("records"+b).empty();
         			sym.getSymbol("menMc").$("records"+b).append(recordsArr[b+poolNo]);
         			loadTeam(b+poolNo,b);//PB Sep 7
         		}
         
         	};
         };
         
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(overBtn);
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // NAV BUTTONS
         sym.getSymbol("navBtns").$("navBtnNext").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	resetmenu();
         	swipe++;
         	swipeIt();
         });
         sym.getSymbol("navBtns").$("navBtnBack").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	resetmenu();
         	swipe--;
         	swipeIt();
         });
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SWIPE IMAGE
         sym.$("menMc").on("swipeleft",function(){
         	e.stopPropagation(); e.preventDefault();
         		resetmenu();
         		if (swipe >= swipeNo) {
         
         		}else{
         			swipe++;
         			swipeIt();
         		}
         }); 
         
         sym.$("menMc").on("swiperight",function(){
         	e.stopPropagation(); e.preventDefault();
         		resetmenu();
         		if (swipe < 1) {
         
         		}else{
         			swipe--;
         			swipeIt();
         		}
         }); 
         
         function swipeIt() {
         	var stageWidth=sym.$("Stage").width();
         	if (stageWidth > 700){
         		stageWidth = stageWidth-100;
         	}
         	if (stageWidth < 700){
         		stageWidth=sym.$("Stage").width();
         	}
         	if (stageWidth < 600){
         		stageWidth = stageWidth-100;
         	}
         	if (stageWidth < 400-100){
         		stageWidth=sym.$("Stage").width();
         	}
         	sym.$("menMc").stop().animate({left:swipe*(-stageWidth)}, 100);
         	sym.getSymbol("navBtns").$("navBtnNext").fadeIn(0);
         	sym.getSymbol("navBtns").$("navBtnBack").fadeIn(0);
         	if (swipeNo==swipe){
         		sym.$("menMc").stop().animate({left:-(stageWidth/noBg)*(5-noBg)}, 100);
         		sym.getSymbol("navBtns").$("navBtnNext").fadeOut(0);
         	}else{
         		sym.$("menMc").stop().animate({left:swipe*(-stageWidth)}, 100);
         		}
         	if (swipe > 3) {
         		sym.getSymbol("navBtns").$("navBtnNext").fadeOut(0);
         		}
         	if (swipe < 1){
         		sym.getSymbol("navBtns").$("navBtnBack").fadeOut(0);
         	}
         	if (swipe == 0.5) {
         		swipe=0;
         		}
         	if (swipe == 1.5) {
         		swipe=1;
         		}
         }
         sym.getSymbol("navBtns").$("navBtnBack").fadeOut(0);
         // BUTTONS COUNT
         var showMenuBtn=0;
         sym.$("slideMenuBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	showMenuBtn=(showMenuBtn==0)?(sym.$("menuBtnsMc").fadeIn(0),1):(sym.$("menuBtnsMc").fadeOut(0),0);
         });
         //--------------------------------------------------------------------------------------------------------
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SET STYLE SETTING 
         function setStyle() {
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "height":"auto", "width":"auto", "padding":"6px", "padding-top":"6px"});
         	sym.getSymbol("styleHead").$("headlineTxt").stop().animate({width:stageWidth-40}, 0);
         	sym.getSymbol("styleBase").$("creditTxt").animate({left:stageWidth-120}, 0);
         	sym.$("menuBtnsMc").animate({left:stageWidth-100}, 0);
         	sym.$("navBtns").animate({left:stageWidth-69}, 0);
         	sym.$("slideMenuBtn").animate({left:stageWidth-40}, 0);
         }
         //--------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //--------------------------------------------------------------------------------------------------------
         $(window).on('resize',initSize);
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------- END -------------------------------------------------
         //--------------------------------------------------------------------------------------------------------

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'auxBtn'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'auxBtn_1'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'pool0'
   (function(symbolName) {   
   
   })("pool0");
   //Edge symbol end:'pool0'

   //=========================================================
   
   //Edge symbol: 'navBtn'
   (function(symbolName) {   
   
   })("navBtn");
   //Edge symbol end:'navBtn'

   //=========================================================
   
   //Edge symbol: 'menMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("menMc");
   //Edge symbol end:'menMc'

   //=========================================================
   
   //Edge symbol: 'cupKeyMc'
   (function(symbolName) {   
   
   })("cupKeyMc");
   //Edge symbol end:'cupKeyMc'

   //=========================================================
   
   //Edge symbol: 'navBtns'
   (function(symbolName) {   
   
   })("navBtns");
   //Edge symbol end:'navBtns'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33416");