/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clicked = 0;
         	var clickAux = 8;
         	var btnNo = 0;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var whiteTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         	
         	var outBtn  = {"background-color":"#276FB7"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         	
         	var txt=[];
         	for (var h=0; h<11; h++){
         		txt[h] = sym.getSymbol("mapMc").$("txt"+h).css({"pointer-events":"none"});
         	}
         	for (var h=11; h<37; h++){
         		txt[h] = sym.$("txt"+h).css({"pointer-events":"none"});
         	}
         	
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33395.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<37; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         				sym.$("txt11").empty();
         				sym.$("txt11").css('height','');
         				sym.$("txt11").css('height','auto');
         				sym.$("txt11").append(txtArr[27]);
         				sym.$("txt12").empty();
         				sym.$("txt12").append(txtArr[28]);
         		},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("txt12").animate({top:340 + sym.$("txt11").height()+10, width:sym.$("txt11").width()+0}, 0);
         	sym.$("logo").stop().animate({left:stageWidth-250}, 0);
         	// SCROLL START
         	sym.getSymbol("scrollMc").$("scrollableMc").stop().animate({width:stageWidth}, 0);
         	sym.getSymbol("scrollMc").$("scrollableMc").css({'overflow-y':'hidden'});
         	sym.getSymbol("scrollMc").$("scrollableMc").scrollLeft(stageWidth+160); // KEEP SCROLL RIGHT
         	sym.$("scrollMc").scrollLeft(stageWidth+200);
         	// SCROLL END
         
         	setStyle();
         	if(stageWidth<800){
         	var drop = 220 - sym.$("txt11").height();
         		sym.$("table").css({'max-height':drop});
         		sym.$("menuBtnsMc").fadeIn(0);
         		sym.getSymbol("scrollMc").$("scrollableMc").css('cursor', 'ew-resize'); // SCROLL CODE
         		sym.getSymbol("menuBtnsMc").$("menuBtn2").fadeOut(0);
         		sym.$("table").animate({top:340 + sym.$("txt11").height()+10, width:sym.$("txt11").width()+0, left:8}, 0);
         		if (clicked == 0){
         			sym.$("txt12").fadeIn(0);
         			sym.$("table").fadeOut(0);
         			sym.$("mapMc").fadeIn(0);
         		}
         		if (clicked == 1){
         			sym.$("txt12").fadeOut(0);
         			sym.$("table").fadeIn(0);
         			sym.$("mapMc").fadeIn(0);
         		}
         
         	}else{
         		sym.$("table").css({'max-height':'240px'});
         		sym.$("menuBtnsMc").fadeOut(0);
         		sym.$("table").animate({top:340, left:270, width:240}, 0);
         		sym.getSymbol("scrollMc").$("scrollableMc").css('cursor', 'default'); // SCROLL CODE
         		sym.$("txt12").fadeIn(0);
         		sym.$("table").fadeIn(0);
         		sym.$("mapMc").fadeIn(0);
         
         	}
         	if(stageWidth<640){
         
         	}else{
         
         	}
         	if (stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         		sym.getSymbol("menuBtnsMc").$("menuBtn2").fadeIn(0);
         		if (clicked == 0){
         			sym.$("txt11").fadeIn(0);
         			sym.$("txt12").fadeIn(0);
         			sym.$("table").fadeOut(0);
         			sym.$("mapMc").fadeOut(0);
         		}
         		if (clicked == 1){
         			sym.$("txt11").fadeIn(0);
         			sym.$("txt12").fadeOut(0);
         			sym.$("table").fadeIn(0);
         			sym.$("mapMc").fadeOut(0);
         		}
         		if (clicked == 2){
         			sym.$("txt11").fadeOut(0);
         			sym.$("txt12").fadeOut(0);
         			sym.$("table").fadeOut(0);
         			sym.$("mapMc").fadeIn(0);
         		}
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         		sym.getSymbol("menuBtnsMc").$("menuBtn2").fadeOut(0);
         		if (clicked == 2){
         			sym.$("txt11").fadeIn(0);
         			sym.$("txt12").fadeIn(0);
         			sym.$("table").fadeOut(0);
         			sym.$("mapMc").fadeIn(0);
         			clicked=0;
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(overBtn);
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn2").$("bg").css(outBtn);
         		}
         	}
         	setStyleUpdate();
         }
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // MOUSE SCROLL SYMBOL
         var x,left,down;
         sym.getSymbol("scrollMc").$("scrollableMc").mousedown(function(e){
             e.stopPropagation(); e.preventDefault();
             down=true;
             x=e.pageX;
             left=$(this).scrollLeft();
         });
         
         sym.getSymbol("scrollMc").$("scrollableMc").mousemove(function(e){
         	e.stopPropagation(); e.preventDefault();
             if(down){
                 var newX=e.pageX;
                 sym.getSymbol("scrollMc").$("scrollableMc").scrollLeft(left-newX+x);    
             }
         });
         sym.getSymbol("scrollMc").$("scrollableMc").mouseup(function(e){down=false;});
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // MENU BUTTONS
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<3; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(outBtn);
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		initSize();
         	};
         };
         
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(overBtn);
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // TABLE START
         function loadTable(){
         	sym.$("table").empty();
         	$.ajax({	
         		type: "GET",
         		url: "GN33395.xml",
         		dataType: "xml",
         		success: function(xml) {
         		var htmlOutput = '';
         	 	htmlOutput += '<table width="100%" border="0" cellpadding="4" cellspacing="0">';
         
         		var dateMonth;
         		var dateDate;
         		var dateMatch;
         
         		$(xml).find('stad'+clickAux).find('stad').each(function() {
         			dateMonth = $(this).find("month").text();
         			dateDate = $(this).find("date").text();
         			dateMatch = $(this).find("match").text();
         			var stadData = stadTable(dateMonth,dateDate,dateMatch);
         			htmlOutput = htmlOutput + stadData;
         		});
         
         		htmlOutput += '</table>';
         		sym.$("table").append(htmlOutput);
         		sym.$("table").css({ "height":"auto", "border-width":"1px","border-style":"solid","border-color":"rgba(0,0,0,0.5)", "border-radius":"5px"});
         		sym.$("table tr:odd").css({"text-align":"left", "background-color":"#DBDCDD","color":"black", "font":"13px Pragmatica-web, sans-serif", "line-height":"15px"});
         		sym.$("table tr:even").css({"text-align":"left", "background-color":"#ffffff","color":"black", "font":"13px Pragmatica-web, sans-serif", "line-height":"15px"});
         	}
         });
         
          function stadTable(dateMonth,dateDate,dateMatch){
         	output = '';
         	output += '<tr>';
         	output += '<td style="width:10%; color:white; background-color:#276FB7">'+ dateMonth +'</td>';
         	output += '<td style="width:10%; font-weight:normal">'+ dateDate +'</td>';
         	output += '<td style="width:80%; font-weight:bold">'+ dateMatch +'</td>';
         	output += '</tr>';
         	return output;
         	}
         }
         loadTable();
         // TABLE END
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // AUX BUTTONS --------------------------------------------	
         auxArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<13; a++){
         	auxArray.push(a);
         }
         
         function resetAux(){
         	for (var a=0; a<auxArray.length; a++){
         		sym.getSymbol("mapMc").getSymbol("ballBtn" + a).$("btnOver").fadeOut(0);
         	}
         	for (var h=0; h<11; h++){
         		sym.getSymbol("mapMc").$("txt"+h).css({"font-weight":"normal"});
         	}
         }
         resetAux();
         
         // AUX CLICK
         var auxBtnClick = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		clickAux = auxNo;
         		resetAux();
         		sym.getSymbol("mapMc").getSymbol("ballBtn" + auxNo).$("btnOver").fadeIn(0);
         		loadTable();
         		sym.$("txt11").empty();
         		sym.$("txt11").css('height','');
         		sym.$("txt11").css('height','auto');
         		sym.$("txt11").append(txtArr[auxNo + auxNo + 11]);
         		sym.$("txt12").empty();
         		sym.$("txt12").append(txtArr[auxNo + auxNo + 12]);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("picMain").attr("src", "images/picMain" + auxNo + ".jpg");
         		initSize();
         
         		if (clickAux <= 6){
         			sym.getSymbol("mapMc").$("txt" + clickAux).css({"font-weight":"bold"});
         		}
         		if (clickAux == 6||clickAux == 7||clickAux == 8){
         			sym.getSymbol("mapMc").$("txt6").css({"font-weight":"bold"});
         		}
         		if (clickAux >= 9){
         			sym.getSymbol("mapMc").$("txt" + (clickAux - 2)).css({"font-weight":"bold"});
         		}
         
         	};
         };
         
         for (var b=0;b<auxArray.length;b++){
         	sym.getSymbol("mapMc").$("ballBtn"+b).on('touchstart click',auxBtnClick(b));
         	sym.getSymbol("mapMc").$("ballBtn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("mapMc").getSymbol("ballBtn8").$("btnOver").fadeIn(0);
         sym.getSymbol("mapMc").$("txt6").css({"font-weight":"bold"});
         
         
         //--------------------------------------------------------------------------------------------------------
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SET STYLE SETTING 
         function setStyle() {
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "height":"auto", "width":"auto", "padding":"6px", "padding-top":"6px"});
         	sym.getSymbol("styleHead").$("headlineTxt").stop().animate({width:stageWidth-0}, 0);
         	sym.getSymbol("styleBase").$("creditTxt").animate({left:stageWidth-120}, 0);
         }
         function setStyleUpdate(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyleUpdate();
         //--------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //--------------------------------------------------------------------------------------------------------
         $(window).on('resize',initSize);
         initSize();
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------- END -------------------------------------------------
         //--------------------------------------------------------------------------------------------------------

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'menuBtn_1'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("auxBtnsMc");
   //Edge symbol end:'auxBtnsMc'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'Base'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'toggleBtn_1'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'standBgMc'
   (function(symbolName) {   
   
   })("standBgMc");
   //Edge symbol end:'standBgMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn0_1'
   (function(symbolName) {   
   
      })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtn1_1'
   (function(symbolName) {   
   
      })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'mapMc'
   (function(symbolName) {   
   
   })("mapMc");
   //Edge symbol end:'mapMc'

   //=========================================================
   
   //Edge symbol: 'ballBtn'
   (function(symbolName) {   
   
   })("ballBtn");
   //Edge symbol end:'ballBtn'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNews33395");