/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         var gnYear=2015;
         var gnNo=33382;
         var screenArr=['latest','overview','matchtracker'];
         var clickEventType;
         
         var showguide=0;//show guide
         var showStats=0;//show statistics
         var matchView=0;//view of matchtracker
         var stageWidth;
         var matchStatus=0;//status of match
         var teamSelect;
         var mob = 0;
         var finalMatch=360478;
         //GET QUERY STRING PARAMETERS----------------------
         var get = [];
         location.search.replace('?', '').split('&').forEach(function (val) {
           split = val.split("=", 2);
           get[split[0]] = split[1];
         });
         //TEXT---------------------------------------------
         var headlinetxt=sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         sym.getSymbol("styleHead").$("headerBox").css("border-bottom","solid 1px rgb(0,0,0)");
         var headline, headlinemob;
         var sourcetxt=sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css({"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"});
         var menuTxt=sym.getSymbol("styleHead").getSymbol("menuBtns").$("menuTxt").css("pointer-events","none");	
         var menuTxtArr=[];var txt=[];var txtArr=[];var timetxt=[];var teamArr=[];var tableCaps=[];var months=[];var key=[];var yearArr=[];var champsArr=[];var stadArr=[];var positionArr=[];
         var matchArr=['h2hMc','timer','matchStats','teams','guide','positions'];
         txt[0]=sym.getSymbol("latest").$("txt0").css("pointer-events","none");
         txt[1]=sym.getSymbol("overview").$("txt1").css("pointer-events","none");
         for(var i=2;i<6;i++){
         txt[i]=sym.getSymbol("overview").getSymbol("groupStage").$("txt"+i).css("pointer-events","none");
         }
         for(var i=6;i<11;i++){
         txt[i]=sym.getSymbol("overview").getSymbol("knockout").$("txt"+i).css("pointer-events","none");
         }
         txt[11]=sym.getSymbol("matchtracker").getSymbol("guide").$("txt11").css("pointer-events","none");
         
         var guideTxt, timerTxt;
         var timeZoneTxtArr=[sym.getSymbol("styleHead").getSymbol("timeZone").$("timezoneTxt"),sym.getSymbol("latest").getSymbol("latestTable").getSymbol("timeZone").$("timezoneTxt")];
         var dateFormat;
         $.ajax({	
         	type: "GET",
         	url: "GN"+gnNo+".xml",
         	dataType: "xml",
         	success: function(xml) {
         		headline=$(xml).find('headline').text();
         		headlinetxt.html(headline);
         		headlinemob=$(xml).find('headlinemob').text();
         		var source=$(xml).find('source').text();
         		sourcetxt.html(source);
         		dateFormat=$(xml).find('dateformat').text();//for different date formats
         		for (var m=0;m<2;m++){
         			sym.getSymbol("styleHead").getSymbol("menuBtns").getSymbol("menuBtn"+m).$("icon").attr('src','images/menuIcon'+m+'.png');
         			menuTxtArr[m]= $(xml).find('menuTxt'+m).text();
         		}
         		menuTxt.html(menuTxtArr[0]);
         		var monthsArr = $(xml).find('months').text(); months=monthsArr.split(";");
               var keyArr = $(xml).find('key').text(); key=keyArr.split(";");
               var timeArr = $(xml).find('time').text(); timetxt=timeArr.split(";");
               for (var i=0;i<2;i++){
         			timeZoneTxtArr[i].html(timetxt[0]);
               }
               var teamLongArr= $(xml).find("teams").text(); teamArr=teamLongArr.split(";");
               var teamShortNameArr= $(xml).find("teamShort").text(); teamShortArr=teamShortNameArr.split(";");
               var matchBtns=$(xml).find("matchBtns").text(); var matchBtnArr=matchBtns.split(";");
               for (var m=0;m<4;m++){
         			sym.getSymbol("matchtracker").getSymbol("matchBtn"+m).$("icon").attr('src','images/matchIcon'+m+'.png');
         			sym.getSymbol("matchtracker").getSymbol("matchBtn"+m).$("menuTxt").html(matchBtnArr[m]);
         			sym.getSymbol("matchtracker").$("matchBtn"+m).on('click',matchMenu(m));
               }
         		for  (var i=0;i<37;i++){
         			txtArr[i]= $(xml).find('txt'+i).text(); //fixed text captions 12=winner, 13=loser
         			if(i<txt.length){
         				txt[i].html(txtArr[i]);
         			}
         		}
         		var positionCaps = $(xml).find('positions').text();
         		positionArr=positionCaps.split(";");
         		var tableHeadCaps = $(xml).find('table0').text();
         		tableCaps=tableHeadCaps.split(";");
         		var tableHead ="<table class='thead'>";
         		tableHead +="<tr>";
         		tableHead +="<td class='rowflag'></td>";
         		tableHead +="<td class='rowname'></td>";
         		tableHead +="<td class='rowwon'>"+tableCaps[0]+"</td>";
         		tableHead +="<td class='rowdraw'>"+tableCaps[1]+"</td>";
         		tableHead +="<td class='rowlost'>"+tableCaps[2]+"</td>";
         		tableHead +="<td class='rowf'>"+tableCaps[3]+"</td>";
         		tableHead +="<td class='rowa'>"+tableCaps[4]+"</td>";
         		tableHead +="<td class='rowpts'>"+tableCaps[5]+"</td></tr>";
         		tableHead +="</table>";
         		sym.getSymbol("overview").$("tableHead").append(tableHead);
         		$(".thead").css({'width':'99%','position':'absolute','font-family':'pragmatica-web, sans-serif','font-weight':700,'border':'none','border-collapse':'collapse','font-size':'12px','margin':'0 1px'});
         		$(".rowflag").css({'width':'10%'});
         		$(".rowname").css({'width':'38%','text-align':'left'});
         		$(".rowwon, .rowdraw, .rowlost").css({'width':'6%','text-align':'center'});
         		$(".rowf, .rowa").css({'width':'10%','text-align':'right'});
         		$(".rowpts").css({'width':'7%','text-align':'right','padding-right':'2px','font-weight':700});
         		var tooltipCaps = $(xml).find('table1').text();//tool tip for group table
         		sym.getSymbol("overview").$("tooltip0").html(tooltipCaps);
         		sym.getSymbol("overview").$("tooltip0").css({'background-color':'rgb(255,235,165)','border':'solid 1px rgb(0,0,0)','border-radius':'2px','display':'none'});
         
         		var timertxtArr=[];
         		for (var i=0;i<10;i++){
         			timertxtArr[i]= $(xml).find('guidetxt'+i).text();
         		}
         		//instruction page
                  		sym.getSymbol("matchtracker").getSymbol("guide").$("txt11").html(txtArr[11]);//check numbers	
                  		timerTxt="<div class='action period4'>";//style by period
                  		timerTxt+="<div class='personh'>"+timertxtArr[0]+"</div>";
                  		timerTxt+="<div class='type'><img src='images/con.png'></div><div class='actiontime'>"+timertxtArr[1]+"</div><div class='type'></div><div class='persona'></div>";
                  		timerTxt+="</div>";
                  		timerTxt+="<div class='action period4'>";
                  		timerTxt+="<div class='personh'>"+timertxtArr[2]+"</div>";
                  		timerTxt+="<div class='type'><img src='images/try.png'></div><div class='actiontime'>"+timertxtArr[3]+"</div><div class='type'></div><div class='persona'></div>";
                  		timerTxt+="</div>";
                  		timerTxt+="<div class='action period4'>";
                  		timerTxt+="<div class='personh'></div><div class='type'></div><div class='actiontime'>"+timertxtArr[4]+"</div><div class='type'><img src='images/pen.png'></div><div class='persona'>"+timertxtArr[5]+"</div>";
                  		timerTxt+="</div>";
                  		timerTxt+="<div class='action period4'>";
                  		timerTxt+="<div class='personh'></div><div class='type'></div><div class='actiontime'>"+timertxtArr[6]+"</div><div class='type'><img src='images/yellow.png'></div><div class='persona'>"+timertxtArr[7]+"</div>";
                  		timerTxt+="</div>";
                  		timerTxt+="<div class='action period4'>";
                  		timerTxt+="<div class='personh'>"+timertxtArr[8]+"</div>";
                  		timerTxt+="<div class='type'><img src='images/sub.png'></div><div class='actiontime'>"+timertxtArr[9]+"</div><div class='type'></div><div class='persona'></div>";
                  		timerTxt+="</div>";
                  		guideTxt="<img src='images/samplestats.png'><br>";
                  		guideTxt+=txtArr[23]+", "+txtArr[24]+", "+txtArr[25]+", "+txtArr[26];
                  		sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt0").html(txtArr[27]);
                  		sym.getSymbol("matchtracker").$("txt16").html(txtArr[21]);
                  		sym.getSymbol("matchtracker").$("txt17").html(txtArr[21]);
                  		sym.getSymbol("matchtracker").getSymbol("matchStats").$("txt18").html(txtArr[26]);
         
         	},
         	complete: function(){
         	setTimeout(openMatch,2500);
         	initSize();
         	}
         });
         //DATES-----------------------------------------------
         var showLocal=0;
         var startDate= Date.parse("September 18, 2015, 20:00 UTC");
         var endDate = Date.parse("October 31, 2015, 23:59 UTC");
         var oneDay = 86400000;
         var todayDate = new Date();
         var todayTime = todayDate.getTime();
         var localOffset=todayDate.getTimezoneOffset()*60000;
         var gmtStart = Date.parse("October 25, 2015, 01:59 UTC");
         var gmtEnd = Date.parse("March 27, 2016, 00:59 UTC");
         function getDDMMYY(thisDateStr) {
                     var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
                     //var thisDate = new Date(parseInt(dateTxt, 10));
                     var thisDate = new Date(parseInt(dateTxt, 10)+oneDay);
                     var mm = thisDate.getMonth() + 1;
                     var dd = thisDate.getDate();
                     mm = ((mm < 10) ? '0' : "") + mm;
                     dd = ((dd < 10) ? '0' : "") + dd;
                     return dd + "/" + mm + "/" + (thisDate.getFullYear()).toString();
                 }
         function getDDmonthYY(thisDateStr) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var matchDate=thisDate.getTime() +localOffset;
         	var matchTime=new Date(matchDate);
         	var mm = matchTime.getMonth();
         	var dd = matchTime.getDate();
         	if (dateFormat=="dayMonth"){ //allows different date formats
         		return dd.toString() +months[mm];
         	}else{
         		return months[mm] + " " + dd.toString();
         	}
         } 
         function getDateLocal(thisDateStr) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var mm = thisDate.getMonth();
         	var dd = thisDate.getDate();
         	//return months[mm] + " " + dd +", "+ (thisDate.getFullYear()).toString();
         	if (dateFormat=="dayMonth"){ //allows different date formats
         		return dd.toString() +months[mm];
         	}else{
         		return months[mm] + " " + dd.toString();
         	}
         }
         function getMatchTime(thisDateStr,venuetime){
         	var timeTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(timeTxt, 10));
         	var thisTime = thisDate.getTime()+localOffset-venuetime;//localOffset to UTC - offset to time at venue
         	var matchTime = new Date(thisTime);
         	var hh = matchTime.getHours();
         	var mm = parseInt(matchTime.getMinutes(),10);
         	mm=(mm<10)?"0"+mm:mm;
         	return hh+":"+mm;
         }
         function getMatchLocal(thisDateStr){
         	var timeTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(timeTxt, 10));
         	var hh = thisDate.getHours();
         	var mm = parseInt(thisDate.getMinutes(),10);
         	mm=(mm<10)?"0"+mm:mm;
         	return hh+":"+mm;
         }
         function parsedDate(thisDateStr){
         	var matchRndDate = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var dDate = parseInt(matchRndDate,10)+localOffset;
         	return dDate;
         } 
         var offsetBrazil;//Offset between time at venue and UTC
         function getDST(thisDateStr){
         	var thisDate = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf('+'));
         	var offsetUTC=(thisDate<gmtStart||thisDate>gmtEnd)?-3600000:0;
         	return offsetUTC;
         }
         
         var timeZoneArr=[sym.getSymbol("styleHead").$("timeZone"),sym.getSymbol("latest").getSymbol("latestTable").$("timeZone")];
         for(var t=0;t<2;t++){
         timeZoneArr[t].css({'cursor':'pointer'});timeZoneArr[t].on("click",timeZoneClick);timeZoneArr[t].on("mouseover",timeZoneOver);timeZoneArr[t].on("mouseout",timeZoneOut);
         }
         function timeZoneClick(){
         	showLocal=(showLocal==0)?($(".localtime").fadeIn(0),$(".venuetime").fadeOut(0),1):($(".localtime").fadeOut(0),$(".venuetime").fadeIn(0),0); 
         	for(var t=0;t<2;t++){ timeZoneTxtArr[t].html(timetxt[showLocal]); }
         }
         function timeZoneOver(){
         	for(var t=0;t<2;t++){ showLocal==0?timeZoneTxtArr[t].html(timetxt[1]):timeZoneTxtArr[t].html(timetxt[0]); }
         }
         function timeZoneOut(){
         	for(var t=0;t<2;t++){ showLocal==0?timeZoneTxtArr[t].html(timetxt[0]):timeZoneTxtArr[t].html(timetxt[1]); }
         }
         //RESPONSIVE-----------------------------------------------
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	sym.getSymbol("matchtracker").stop(stageWidth*10);
         	sym.getSymbol("matchtracker").getSymbol("teams").stop(stageWidth*10);
         	sym.getSymbol("matchtracker").getSymbol("h2hMc").stop(stageWidth*10);
         	sym.getSymbol("overview").getSymbol("knockout").stop(stageWidth*10);
         	sym.getSymbol("styleHead").$("timeZone").fadeIn(0);
         	sym.getSymbol('bg').$('cup').css({'left':stageWidth/2-152+'px'});
         	var posWidth=sym.getSymbol("matchtracker").$("positions").width();
         	sym.getSymbol("matchtracker").getSymbol("positions").$("playerNos").css({'left':posWidth/2-146+'px'});
         	//Matchtracker
         	var btnWidth=sym.getSymbol("matchtracker").$("matchBtn0").width();
            if(matchStatus>=8){ sym.getSymbol("matchtracker").$("clock").fadeIn(0);matchView=1; }
         	for (var i=0;i<4;i++){
         		sym.getSymbol("matchtracker").getSymbol("matchBtn"+i).$("icon").css({'left':btnWidth/2-18+'px'});
         		i==matchView?(sym.getSymbol("matchtracker").$(matchArr[matchView]).fadeIn(0),sym.getSymbol("matchtracker").getSymbol("matchBtn"+matchView).$("menuBg").css({'opacity':0.75})):
         		(sym.getSymbol("matchtracker").$(matchArr[i]).fadeOut(0),sym.getSymbol("matchtracker").getSymbol("matchBtn"+i).$("menuBg").css({'opacity':0.25}));
         		if (stageWidth>=640){
         			//var xtraPanel= (matchView==3)?(matchStatus<2)?0:1:3; sym.getSymbol("matchtracker").$(matchArr[xtraPanel]).fadeIn(0);//matchStatus<8
         			var xtraPanel= (matchView==3)?(matchStatus<2)?5:1:3; sym.getSymbol("matchtracker").$(matchArr[xtraPanel]).fadeIn(0);
         		}else{
         			if(matchView==3){ showguide=0;}
         		}
         	}
         	showguide==0?sym.getSymbol("matchtracker").$("guide").fadeOut(0):sym.getSymbol("matchtracker").$("guide").fadeIn(0);
         	if(stageWidth<400){
         	$(".rowwon, .rowdraw, .rowlost").fadeOut(0);
         	}else{
         	$(".rowwon, .rowdraw, .rowlost").fadeIn(0);
         	}
         	if(stageWidth<=480){
         	   menuTxt.fadeOut(0);
         	   headlinetxt.css({"font-size":"22px"});
         	   headlinetxt.html(headlinemob);//change headline for mobile
         	   $(".venuef, .rowf, .rowa, .scoref img").fadeOut(0);
         		sym.getSymbol("overview").$("tooltip0").fadeOut(0);
         		sym.getSymbol("overview").$("tipBtn0").fadeOut(0);showtip=0;
         	}else{
         	   menuTxt.fadeIn(0);
         		headlinetxt.css({"font-size":"24px"});
         		headlinetxt.html(headline);
         		$(".venuef, .rowf, .rowa, .scoref img").fadeIn(0);
         		sym.getSymbol("overview").$("tipBtn0").fadeIn(0);
         	}
         	if(stageWidth<640){
         		timeZoneArr[0].fadeOut(0);
         		$(".longname").fadeOut(0); $(".shortname").fadeIn(0);
         		//$(".grpscore").css({'width':'25%'});
         		$('.grpteamh, .grpteama').css({'width':'20%'});
         		$('.grpmatch').css({'font-size':'11px'});
         	}else{
         		timeZoneArr[0].fadeIn(0);
         		$(".longname").fadeIn(0);$(".shortname").fadeOut(0);
         		//$(".grpscore").css({'width':'auto'});
         		$('.grpteamh, .grpteama').css({'width':'35%'});
         		$('.grpmatch').css({'font-size':'12px'});
         	}
         };
         var wWidth = $(window).width();
         $(window).resize(function(){
           if(wWidth != $(window).width()){
             initSize();
             wWidth = $(window).width();
           }
         });
         
         // MENU BUTTONS-------------------------------------------------
                  menuArray = []; //the array that will hold references to the buttons.
                  for (var m = 0; m < 2; m++){
                  		var menuBtnSymbols = sym.getSymbol("styleHead").getSymbol("menuBtns").getSymbol("menuBtn" +m); // Create an instance element of a symbol as a child of the given parent element
                  		menuBtnSymbols.setVariable("menuId", m); //set the value of a Symbol variable
                  		menuArray.push(menuBtnSymbols); //push it into the array
                  	}
                  $.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
                  		var menuBtnItem = $(menuInTheArray); //create jQuery reference to the item
                  		var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
                  		menuBtnElement.on ("click", {menuId:count}, menuBtnClick);
                  		menuBtnElement.on ("touchstart click", {menuId:count}, menuBtnClick);
                  		menuBtnElement.on ("mouseover", {menuId:count}, menuShow);
                  		menuBtnElement.on ("mouseout", {menuId:count}, menuHide);
                  		menuBtnElement.css({"cursor":"pointer"});
                  })
                  function resetmenu(){
                  		for (var m=0; m<menuArray.length; m++){	
                           menuArray[m].$("menuBg").fadeOut(0);
                  		}
                  }
                  resetmenu();
                  function menuBtnClick (e){
                  		e.preventDefault();
                  		e.stopPropagation();
                  		resetmenu(); //set them all back to normal state
                  		sym.$("latest").animate({opacity:1.0},0);
                  		clearInterval(matchInterval);
         					clearInterval(playInterval);
                  		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
         					for (var i=0;i<3;i++){
         						if (menuMenu_id==i){
         							sym.$(screenArr[i]).fadeIn(400);
         							sym.getSymbol("styleHead").getSymbol("menuBtns").getSymbol("menuBtn" + i).$("menuBg").fadeIn(0);
         							menuTxt.html(menuTxtArr[i]);
         							if(menuMenu_id==0){
         								sym.getSymbol("bg").$("posts").animate({opacity:0.3},400);
         								sym.getSymbol("bg").$("cup").animate({opacity:1},400);
         							}else{
         								sym.getSymbol("bg").$("posts").animate({opacity:0},400);
         								sym.getSymbol("bg").$("cup").animate({opacity:0.2},400);
         							}
         						}else{
         							sym.$(screenArr[i]).fadeOut(400);
         						}						 
         					}
         					initSize();
                  }
                  function menuShow (e){
                  		var menuMenu_id = (e.data.menuId); //get the id of the over button
                  		menuTxt.html(menuTxtArr[menuMenu_id]);
                  }
                  function menuHide (e){
                  		var menuMenu_id = (e.data.menuId); //get the id of the out button
                  }
         sym.getSymbol("styleHead").getSymbol("menuBtns").getSymbol("menuBtn0").$("menuBg").fadeIn(0);	
         
         //MATCH MENU---------------------------------------------------
         function makeGuide(n){
         	sym.getSymbol("matchtracker").getSymbol("guide").$("txt2").empty();
         	var title=(n==1)?11:18;
         	var txtObj=(n==1)?timerTxt:guideTxt;
         	sym.getSymbol("matchtracker").getSymbol("guide").$("txt11").html(txtArr[title]);
         	sym.getSymbol("matchtracker").getSymbol("guide").$("txt11").append(txtObj);
         	$('.action').css({'display':'inline-table','height':'20px','width':'100%','font-size':'12px','font-family':'pragmatica-web, sans-serif','text-align':'left','border-bottom':'solid 1px rgb(150,150,150)','border-top':'solid 1px rgba(255,255,255,0.6)'});
            $(".period4").css({'background-color':'rgba(255,170,50,0.1)'});
            $('.personh').css({'text-align':'right','display':'table-cell','width':'37%'});
            $('.actiontime').css({'background-color':'rgba(100,100,100,0.6)','text-align':'center','display':'table-cell','width':'12%','color':'rgb(255,255,255)'});
            $('.type').css({'display':'table-cell','width':'7%','text-align':'center'});
            $('.persona').css({'text-align':'left','display':'table-cell','width':'37%'});
            $(".action img").css({'width':'20px'});
         }
         var matchMenu = function(n){ //to handle lexical scope
         	return function (e) {
         		for (i=0;i<4;i++){
         			if (i==n){
         				matchView=n;
         				sym.getSymbol("matchtracker").getSymbol("matchBtn"+n).$("menuBg").animate({'opacity':0.75},0);
         				if(stageWidth<640||i<3){
         					if(matchStatus<8&&(n==1||n==2)){
         						makeGuide(n); sym.getSymbol("matchtracker").$(matchArr[4]).fadeIn(600);showguide=1;
         					}else{
         						sym.getSymbol("matchtracker").$(matchArr[n]).fadeIn(600); sym.getSymbol("matchtracker").$(matchArr[4]).fadeOut(600);showguide=0;	sym.getSymbol("matchtracker").$(matchArr[5]).fadeOut(600);				
         					}
         				}else{
         					sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquadh").css({'box-shadow':'0px 0px 6px rgba(7,102,102,0.8)'});
         					sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquada").css({'box-shadow':'0px 0px 6px rgba(7,102,102,0.8)'});
         					sym.getSymbol("matchtracker").$(matchArr[5]).fadeIn(600);
         					sym.getSymbol("matchtracker").$(matchArr[4]).fadeOut(600);
         					showguide=0;
         				}					
         			}else{
         				if(stageWidth<640){
         					sym.getSymbol("matchtracker").$(matchArr[i]).fadeOut(600);
         					sym.getSymbol("matchtracker").$("positions").fadeOut(600);//
         				}else{
         					if(i<3&&n<3){
         						sym.getSymbol("matchtracker").$(matchArr[i]).fadeOut(600);
         						sym.getSymbol("matchtracker").$("positions").fadeOut(600);//
         					}
         				}
         				sym.getSymbol("matchtracker").getSymbol("matchBtn"+i).$("menuBg").animate({'opacity':0.25},0);
         				sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquadh").css({'box-shadow':'inset 3px 3px 3px rgba(100,100,100,0.5)'});
         				sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquada").css({'box-shadow':'inset 3px 3px 3px rgba(100,100,100,0.5)'});
         			}
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };  
         //TOGGLE SHOW GROUP STAGE MATCHES
         var groupShow;
          var showMatches = function(group){ //to handle lexical scope
                  	return function (e) {
                  			if(groupShow==group){
                  				sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).animate({'height':'101px'},300);
                  				$("#gt"+group).css({'display':'none'});
                  				groupShow="";
                  			}else{			
                  				for (var i=1;i<=4;i++){
                  					if (group==i){
                  						$("#gt"+group).css({'display':'block'});
                  						sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).animate({'height':'308px'},300);
                  					}else{
                  						sym.getSymbol("overview").getSymbol("groupStage").$("group"+i).animate({'height':'101px'},300);
                  						$("#gt"+i).css({'display':'none'});
                  					}
                  				}
                  				groupShow=group;
                  			}
                  		e.preventDefault();
                  	};
                  };
         //---------------------------------------------------// SOURCE BUTTON - DO NOT EDIT
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //---------------------------------------------------//TOOLTIP
         sym.getSymbol("overview").$("tableHead").on('click',showTip);
                  var showtip=0;
                  function showTip(){
                  	showtip=(showtip==0)?(sym.getSymbol("overview").$("tooltip0").fadeIn(0),1):(sym.getSymbol("overview").$("tooltip0").fadeOut(0),0);
                  	e.preventDefault(); e.stopPropagation();
                  }
         var showPos = function(team,number,name){ //to handle lexical scope
         	return function (e) {
         		var teamt=(team==1)?"h":"a";
         		for (var i=1;i<3;i++){
         			sym.getSymbol("matchtracker").getSymbol("positions").$("team"+i+"Txt").empty();
         			sym.getSymbol("matchtracker").getSymbol("positions").$("team"+i+"Txt").css({'pointer-events':'none'});
         			if (team!=i){
         				sym.getSymbol("matchtracker").getSymbol("positions").$("team"+i+"Txt").animate({'width':0, 'padding':0},200);
         			}
         		}
         		var playerPos=(!name)?positionArr[number-1]:name;
         		for (var p=1;p<16;p++){
         		sym.getSymbol("matchtracker").getSymbol("positions").getSymbol("playerNos").getSymbol("h"+p).$("posBg").css({'box-shadow':'0 0 0px 0px rgba(255,255,255,0)'});
         		sym.getSymbol("matchtracker").getSymbol("positions").getSymbol("playerNos").getSymbol("a"+p).$("posBg").css({'box-shadow':'0 0 0px 0px rgba(255,255,255,0)'});
         		}
         		sym.getSymbol("matchtracker").getSymbol("positions").$("team"+team+"Txt").html(positionArr[number-1]);
         		sym.getSymbol("matchtracker").getSymbol("positions").$("team"+team+"Txt").stop().animate({'width':'41%','padding':'3px 35px 0 15px'},200);
         		sym.getSymbol("matchtracker").getSymbol("positions").getSymbol("playerNos").getSymbol(teamt+number).$("posBg").css({'box-shadow':'0 0 6px 2px rgba(255,0,0,0.8)'});
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // SET PLAYER POSITION STYLES TO DEFAULT
         	for (var i=1;i<3;i++){
         		sym.getSymbol("matchtracker").getSymbol("positions").$("team"+i+"Txt").css({'pointer-events':'none','width':0,'background-color':'rgba(100,100,100,0.5)','color':'rgb(255,255,255)','padding':0});
         		sym.getSymbol("matchtracker").getSymbol("positions").$("team"+i+"Txt").empty();
         	}
         	for (var p=0;p<15;p++){
         		sym.getSymbol("matchtracker").getSymbol("positions").getSymbol("playerNos").getSymbol("h"+(p+1)).$("posBg").css({"background-color":"rgb(255,255,255)","border":"solid 1px rgb(255,0,0)"});
         		sym.getSymbol("matchtracker").getSymbol("positions").getSymbol("playerNos").getSymbol("h"+(p+1)).$("posTxt").css({"color":"rgb(255,0,0)","pointer-events":"none"});
         		sym.getSymbol("matchtracker").getSymbol("positions").getSymbol("playerNos").getSymbol("h"+(p+1)).$("posTxt").html(p+1);
         		sym.getSymbol("matchtracker").getSymbol("positions").getSymbol("playerNos").getSymbol("a"+(p+1)).$("posTxt").html(p+1);
         	}
         //------------------------------------------------------//LIVE DATA
         //LOAD FUNCTIONS
         function loadMatch(match){
         		resetmenu();
         		showguide=0;matchView=0;matchStatus=0;
         		clearInterval(matchInterval);
         		clearInterval(playInterval);
         		getMatchInfo(match);
         		getMatch(match);
         		matchInterval = setInterval(function() { getMatchInfo(match); }, 60000);
         		playInterval = setInterval(function() { getMatch(match); }, 60000);
         		for (var i=0;i<screenArr.length;i++){
         			i==2?sym.$(screenArr[i]).fadeIn(400):sym.$(screenArr[i]).fadeOut(400);
         		}
         		sym.getSymbol("bg").$("posts").stop().animate({opacity:0.3},400);
         		sym.getSymbol("bg").$("cup").stop().animate({opacity:0},1000);
         		sym.getSymbol("matchtracker").$("teams").fadeIn(0);
         		sym.getSymbol("matchtracker").$("guide").fadeOut(0);
         		initSize();
         }
         var showMatch = function(match){ //to handle lexical scope
         	return function (e) {
         		loadMatch(match);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         function openMatch(){
         	if (get["match"] + "" != "undefined"){// Check if there is a matchID
         		var startMatch=parseInt(get["match"],10);
         		loadMatch(startMatch);
         	}else if(todayDate>endDate-oneDay){//direct to final matchtracker
         		loadMatch(finalMatch);
         	}else{
         		sym.play();
         	}	
         }
         //----------------------------------------------
         //REFRESH RATES
         var fixtureInterval;
         var groupInterval;
         var matchInterval;
         var playInterval;
         var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://www.graphicnews.org/")+ "infostradasports/api.php";
         var teamIDs =[915,831,493,714,819,298,5037,10853,1041,2867,2076,718,46,723,927,123,929,662,1871,686];//'ARG','AUS','CAN','ENG','FIJ','FRA','GEO','IRE','ITA','JPN','NAM','NZL','ROU','SAM','SCO','RSA','TGA','USA','URU','WAL'
         var venueID=[10438,15899,26737,35238,35239,36882,37425,49670,49671,49672,49673,49674];
         //------------------------start
         var firstGroup=68714;var lastGroup=68717;
         function getDetails(groupIndex) {
                  	var group = groupIndex - 1;
                  	var id = firstGroup + group;
                  	$.ajax({ type: "GET", url: dataURL,
                  		data: "gn="+gnNo+"&yr="+gnYear+"&sport=rugby&phaseID=" + id,
                  		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  		async: true,
                  		crossDomain: true,
                  		error: function () {
                  			console.log("Error retrieving Group[" + groupIndex + "]");
                  		},
                  		success: function (groupDetails) {
                  			loadDetails(groupDetails, group);
                  		}
                  	});
         }
         function loadDetails(groupDetails, group) {
         	var imgHTML;
         	for (var i = 0; i < 5; i++) {//4 in each group
         		for(var c=0;c<20;c++){//20 teams
         			if (groupDetails[i].n_TeamID==teamIDs[c]){
         				var teamName=teamArr[c];
         			}
               }
         		$('#t' + group + 'n' + i).text(teamName);
         		$('#t' + group + 'p' + i).text(groupDetails[i].n_Matches);
         		$('#t' + group + 'w' + i).text(groupDetails[i].n_MatchesWon);
         		$('#t' + group + 'd' + i).text(groupDetails[i].n_MatchesDrawn);
         		$('#t' + group + 'l' + i).text(groupDetails[i].n_MatchesLost);
         		$('#t' + group + 'f' + i).text(groupDetails[i].n_Points2For);
         		$('#t' + group + 'a' + i).text(groupDetails[i].n_Points2Against);
         		$('#t' + group + 'pts' + i).text(groupDetails[i].c_Points);
         		imgHTML='<img src="flags/'+(groupDetails[i].c_TeamNatioShort) +'.png" height="12px" width="22px">';
         		$('#t' + group + 'flag' + i).html(imgHTML);
         	}
         
         	$(".grp").css({'width':'99%','position':'absolute','background-color':'rgb(215,230,245)','font-family':'pragmatica-web, sans-serif','border':'none','border-collapse':'collapse','font-size':'12px','margin':'0 1px'});
         	$(".toprow").css({'background-color':'rgb(235,240,250)'});
         	$(".rowflag").css({'width':'10%'});
         	$(".rowname").css({'width':'38%','text-align':'left'});
         	$(".rowwon, .rowdraw, .rowlost").css({'width':'6%','text-align':'center'});
         	$(".rowf, .rowa").css({'width':'10%','text-align':'right'});
         	$(".rowpts").css({'width':'7%','text-align':'right','padding-right':'2px','font-weight':700});
         } 
         var resultsData;
         function getGroupResults() {
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gnNo+"&yr="+gnYear+"&sport=rugby&editionID=68708",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			resultsData = data;
         			for (var group = 1; group <= 4; group++) {//4 groups
         				sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).empty();
         				var tableTxt= "<div id='gt" + group + "' style='display:none; position:absolute; bottom:3px; width:100%'></div>";  
         				tableTxt += "<div id='grptable"+group+"'>";
         
         				tableTxt +="<table class='grp'>";
         				for (var t=0;t<5;t++){
         					tableTxt +=(t<2)?"<tr class='toprow'>":"<tr>";
         					tableTxt +="<td class='rowflag' id='t"+ (group - 1) + "flag"+t+"'></td>";
         					tableTxt +="<td class='rowname' id='t" + (group - 1) + "n"+t+"'></td>";
         					tableTxt +="<td class='rowwon' id='t" + (group - 1) + "w"+t+"'></td>";
         					tableTxt +="<td class='rowdraw' id='t" + (group - 1) + "d"+t+"'></td>";
         					tableTxt +="<td class='rowlost' id='t" + (group - 1) + "l"+t+"'></td>";
         					tableTxt +="<td class='rowf' id='t" + (group - 1) + "f"+t+"'></td>";
         					tableTxt +="<td class='rowa' id='t" + (group - 1) + "a"+t+"'></td>";
         					tableTxt +="<td class='rowpts' id='t" + (group - 1) + "pts"+t+"'></td></tr>";
         				}
         				tableTxt +="</table>";
         
         				tableTxt += "<table style='position:absolute; top:0px; width:165px; background-color:rgb(215,230,245); border:none; border-collapse:collapse; font-family:pragmatica-web, sans-serif; font-size:12px'>";
         				tableTxt += "</div>";			
         				sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).append(tableTxt);
         				getDetails(group);
         				sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).on('click', showMatches(group));
         				sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).css({'cursor':'pointer'});
         			} 
         			getTeamFixtures();
         		}
         	});
         }
         
         var fixtureData;   
         function getTeamFixtures() { 
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gnNo+"&yr="+gnYear+"&sport=rugby&editionID=68708",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			fixtureData = data;
         			if(fixtureData.length>0){
         			$("#gt1").empty();
         			$("#gt2").empty();
         			$("#gt3").empty();
         			$("#gt4").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("qf1").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("qf2").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("qf3").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("qf4").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("sf1").empty();
         			sym.getSymbol("overview").getSymbol("knockout").$("sf2").empty();	
         			sym.getSymbol("overview").getSymbol("knockout").$("ru").empty();	
         			sym.getSymbol("overview").getSymbol("knockout").$("final").empty();
         			sym.getSymbol("latest").getSymbol("latestTable").$('table').empty();
         			for (var i = 0; i < fixtureData.length; i++) {
         				var matchID = fixtureData[i].n_MatchID;
         				var homeTeamID=(fixtureData[i].n_Team1ID>0)?fixtureData[i].n_Team1ID:"null";
         				var awayTeamID=(fixtureData[i].n_Team2ID>0)?fixtureData[i].n_Team2ID:"null";
         				var matchesRnd = parsedDate(fixtureData[i].d_DateUTC);
         				var matchDay = fixtureData[i].n_PhaseID;
         				var phaseLevel = fixtureData[i].n_PhaseLevel;
         				var matchNo = fixtureData[i].n_MatchNr;
         				var teamHome, teamAway, teamHshort, teamAshort;
         				var city=fixtureData[i].c_City;
         				var stad=fixtureData[i].c_Stadium;
         				var crestH = '<img src="crests/'+ homeTeamID +'.png">';
         				var crestA = '<img src="crests/'+ awayTeamID +'.png">';
         
         				var offsetVenue, matchTime, matchDate, localTime, venueTime;;
                  	if (fixtureData[i].d_DateUTC!=null){
                  		offsetVenue = getDST(fixtureData[i].d_DateUTC);
                  		localTime=getDateLocal(fixtureData[i].d_Date)+", "+getMatchLocal(fixtureData[i].d_Date);
                  		venueTime=getDDmonthYY(fixtureData[i].d_DateUTC)+", "+getMatchTime(fixtureData[i].d_Date,offsetVenue);
                  		matchDate = getDDmonthYY(fixtureData[i].d_DateUTC);
                  		matchddmm=getDDMMYY(fixtureData[i].d_Date);
                  	}else{
                  		offsetVenue = "TBC"; matchTime = "TBC";localTime="TBC";venueTime="TBC";matchDate =  "TBC";matchddmm="TBC";
                  	}
         				for(var c=0;c<20;c++){
         					if (homeTeamID>0){
         						if (homeTeamID==teamIDs[c]){
         							teamHome=teamArr[c]; teamHshort=teamShortArr[c]
         						}else{
         							teamHome=fixtureData[i].c_Team1;teamHshort=fixtureData[i].c_Team1Short;
         							teamHome=teamHome.replace("Winner", txtArr[12]); teamHome=teamHome.replace("Loser", txtArr[13]);
         						}
         					}else{
         						teamHome=null;teamHshort=null;
         					}
         					if (awayTeamID>0){
         						if (awayTeamID==teamIDs[c]){
         							teamAway=teamArr[c]; teamAshort=teamShortArr[c]
         						}else{
         							teamAway=fixtureData[i].c_Team2;teamAshort=fixtureData[i].c_Team2Short;//txtArr[12]
         							teamAway=teamAway.replace("Winner", txtArr[12]); teamAway=teamAway.replace("Loser", txtArr[13]);
         						}
         					}else{
         						teamAway=null;teamAshort=null;
         					}
         				}
         				var imgH = '<img src="flags/'+ teamHshort +'.png">';
         				var imgA = '<img src="flags/'+ teamAshort +'.png">';
         			//SHOW LATEST MATCHES
         				if((todayTime<startDate&&matchesRnd<=startDate+(oneDay*1))||(matchesRnd>todayTime-(oneDay*0.75)&&matchesRnd<todayTime+(oneDay*3))||todayTime>endDate&&matchesRnd>endDate-(oneDay*2)){
         					if (i%2 == 0){
         						var fixtureTxt = "<table class='fixtxt even' id='matchf" + i + "'>";
         					}else{
         						var fixtureTxt = "<table class='fixtxt' id='matchf" + i + "'>";
         					}
         					fixtureTxt += "<tr>";
         					fixtureTxt += "<td class='crestf' style='crest' id='homecrestf" + i + "'>"+crestH+"</td>";
         					fixtureTxt += "<td class='teamf' style='padding-left:3px' id='homef" + i + "'></td>";
         					fixtureTxt += "<td class='scoref' id='scoref" + i + "'></td>";
         					fixtureTxt += "<td class='teamf away' style='text-align:right' id ='awayf" + i + "'></td>";
         					fixtureTxt += "<td class='crestf away' id='awaycrestf" + i + "'>"+crestA+"</td>";
         					fixtureTxt += "</tr></table>";
         					sym.getSymbol("latest").getSymbol("latestTable").$('table').append(fixtureTxt);
         					} //closes if parsedate	
         				var tableTxt = "<table class='grpmatch' id='match"+i+"'><tr>";
         				tableTxt +="<td class='flag' id='flagh" + i + "'></td>";
         				tableTxt +="<td class='grpteamh' id='teamh" + i + "'></td>";
         				tableTxt +="<td class='grpscore' id ='score" + i + "'></td>";
         				tableTxt +="<td class='grpteama' id='teama" + i + "' ></td>";
         				tableTxt +="<td class='flag' id='flaga" + i + "' ></td>";
         				tableTxt +="<td id='result" + i + "' ></td></tr></table>";
         				var overviewTxt = "<table class='match' id='match"+i+"'>";
         				overviewTxt += "<tr>";
         				overviewTxt += "<td class='flag' id='flagh"+i+"'></td>";
         				overviewTxt += "<td class='team' id='hometeam"+i+"'></td>";
         				overviewTxt += "<td id='scoreh"+i+"'></td>";
         				overviewTxt += "<td id='penh"+i+"'></td>";
         				overviewTxt += "</tr>";
         				overviewTxt += "<tr>";
         				overviewTxt += "<td class='flag' id='flaga"+i+"'></td>";
         				overviewTxt += "<td class='team' id='awayteam"+i+"'></td>";
         				overviewTxt += "<td id='scorea"+i+"'></td>";
         				overviewTxt += "<td id='pena"+i+"'></td>";
         				overviewTxt += "</tr>";
         				overviewTxt += "</table>";				
         				var groupPhase=[];
         				for (var p=0;p<4;p++){
         					groupPhase[p]=68714+p;
         					if(fixtureData[i].n_PhaseID==groupPhase[p]){
         						var groupOv="<div class='gstage'>"+tableTxt+"</div>";
         						$('#gt'+(p+1)).append(groupOv);
         					}
         				}
         				var qmatch=[];
         				if (phaseLevel==5){//Quarter-finals
         					for (var q=0;q<4;q++){
         						qmatch[q]=41+q;//check match number!!!!
         						if(matchNo==qmatch[q]){
         							var qfOv="<div class='kstage'>"+overviewTxt+"</div>";
         							sym.getSymbol("overview").getSymbol("knockout").$('qf'+(q+1)).append(qfOv);
         						}
         					}
         				}
         				var smatch=[];
         				if (phaseLevel==4){//Semi-finals
         					for (var s=0;s<2;s++){
         						smatch[s]=45+s;
         						if(matchNo==smatch[s]){
         							var sfOv="<div class='kstage'>"+overviewTxt+"</div>";
         							sym.getSymbol("overview").getSymbol("knockout").$('sf'+(s+1)).append(sfOv);
         						}
         					}
         				}
         				var finTxt;
         				if (phaseLevel==3){//Third place
         					var ruOv="<div class='kstage'>"+overviewTxt+"</div>";
         					sym.getSymbol("overview").getSymbol("knockout").$('ru').append(ruOv);
         				}
         				if (phaseLevel==2){//Final
         					var finalOv="<div class='kstage'>"+overviewTxt+"</div>";
         					sym.getSymbol("overview").getSymbol("knockout").$('final').append(finalOv);
         				}
         				$("#match"+i).on('click',showMatch(matchID,homeTeamID,awayTeamID));
         				$("#match"+i).on('mouseover',function(){ $(this).css({'background-color':'rgba(220,155,0,0.2)'});});
         				$("#match"+i).on('mouseout',function(){ $(this).css({'background-color':'rgba(255,255,255,0)'});});
         				$("#matchf"+i).css({'cursor':'pointer'});
         				$("#matchf"+i).on('click',showMatch(matchID,homeTeamID,awayTeamID));
         				$("#matchf"+i).on('mouseover',function(){ $(this).css({'background-color':'rgba(220,155,0,0.2)'});});
         				$("#matchf"+i).on('mouseout',function(){ 
         						this.className=="fixtxt even"?$(this).css({'background-color':'rgba(215,230,245,0.5)'}):$(this).css({'background-color':'rgba(255,255,255,0)'});
         					});
         				$('#flagh' + i).html(imgH);
         				$('#flaga' + i).html(imgA);
         				$('#teamh' + i).html("<span class='longname'>"+teamHome+"</span>"+"<span class='shortname'>"+teamHshort+"</span>");
         				$('#teama' + i).html("<span class='longname'>"+teamAway+"</span>"+"<span class='shortname'>"+teamAshort+"</span>");
         				phaseLevel<=4?($('#hometeam' + i).text(teamHome),$('#awayteam' + i).text(teamAway)):
         					($('#hometeam' + i).html("<span class='longname'>"+teamHome+"</span>"+"<span class='shortname'>"+(teamHshort!=null?teamHshort:teamHome)+"</span>"),
         					$('#awayteam' + i).html("<span class='longname'>"+teamAway+"</span>"+"<span class='shortname'>"+(teamAshort!=null?teamAshort:teamAway)+"</span>"));
         				$('#homef' + i).text(teamHome);
         				$('#awayf' + i).text(teamAway);
         				var pena=(fixtureData[i].n_Result2Shootout!=null||fixtureData[i].n_Result2Shootout!=undefined)?'<i> ('  + fixtureData[i].n_Result2Shootout + ')</i>':'';    
         				var penh=(fixtureData[i].n_Result1Shootout!=null||fixtureData[i].n_Result1Shootout!=undefined)?'<i> (' + fixtureData[i].n_Result1Shootout + ')</i>':'';               
         				$('#penh' + i).html(penh);
         				$('#pena' + i).html(pena);
         				var scoreH = (fixtureData[i].n_HomeGoals!=null||fixtureData[i].n_HomeGoals!=undefined)?'<b>' + (fixtureData[i].n_HomeGoals)+ '</b>':'';
         				$('#scoreh' + i).html(scoreH);
         				var scoreA = (fixtureData[i].n_AwayGoals!=null||fixtureData[i].n_AwayGoals!=undefined)?'<b>' + (fixtureData[i].n_AwayGoals)+ '</b>':'';
         				$('#scorea' + i).html(scoreA);
         				var score =(fixtureData[i].n_Result1!=null||fixtureData[i].n_Result1!=undefined)?'<b>' + (fixtureData[i].n_Result1)+ '-' + (fixtureData[i].n_Result2)+'</b>':'<i>'+matchDate+'</i>';
         				var scoref =(fixtureData[i].n_Result1!=null||fixtureData[i].n_Result1!=undefined)?'<b>' + (fixtureData[i].n_Result1)+ '-' + (fixtureData[i].n_Result2)+'</b>':'<img src="images/time.png"><span class="venuetime">'+venueTime+'</span><span class="localtime">'+localTime+'</span>';
         				$('#score' + i).html(score);
         				$('#scoref' + i).html(scoref+"<span class='venuef'><br/>"+stad+", "+city+"</span>");
         				var matchNo= fixtureData[i].n_MatchNr;
         				//matchResult=(fixtureData[i].b_Finished==true)&&(fixtureData[i].n_MatchStatusCode<128)?'<img src="images/ball.png" height="13px" width="13px">':'';
         				if (phaseLevel<=9){
         					sym.getSymbol("overview").getSymbol("knockout").$("dateTxt"+matchNo).text(matchDate);
         				}
         			} //close for    
         			sym.getSymbol("latest").getSymbol("latestTable").$("table").css({'overflow-y':'auto'});
         				$('.even').css({'background-color':'rgba(215,230,245,0.5)'});
         				$('.fixtxt').css({'font-size':'14px', 'font-family':'pragmatica-web,sans-serif', 'width':'100%'});
         				$('.teamf').css({'width':'23%','font-weight':700});
         				$(".crestf").css({'width':'12%'});
         				$(".scoref").css({'width':'30%','text-align':'center'});
         				$(".away").css({'text-align':'right'});
         				$(".crestf img").css({'border':'none','max-width':'80px','width':'100%'});
         				$('.match').css({'margin-left':'2px','cursor':'pointer','height':'32px','font-size':'12px', 'font-family':'pragmatica-web,sans-serif','border-collapse':'collapse', 'width':'100%'});
         				$('.grpmatch').css({'cursor':'pointer','height':'12px','font-size':'12px', 'font-family':'pragmatica-web,sans-serif','border-collapse':'collapse', 'width':'100%'});
         				$(".scoref img").css({"width":"15px","margin-right":"5px"});  
         			$(".venuef").css({'font-style':'italic'}); 
         			$('.grpteamh').css({'text-align':'left', 'width':'32%','padding':'0px'});
         			$('.grpteama').css({'text-align':'right', 'width':'32%','padding':'0px'});
         			$('.grpscore').css({'padding':'0px','text-align':'center'}); 
         			$(".team").css({'padding-bottom':'1px'});
         			$(".flag").css({'width':'22px','padding':'0 2px 0 2px'});
         			$(".flag img").css({'border':'none','width':'22px','height':'12px'}); 
         			$('.gstage').css({'height':'20px'});
         			$(".shortname").fadeOut(0);
         			showLocal==0?($(".localtime").fadeOut(0),$(".venuetime").fadeIn(0)):($(".localtime").fadeIn(0),$(".venuetime").fadeOut(0)); 
         		}else{
         			console.log('No fixtures');
         		}
         		},//end success
         		error:function(){
         			console.log('Fixtures not found');
         		}
         	}); //close ajax
          }//close function
         getGroupResults();
         if(todayTime>startWC-(oneDay*3)&&todayTime<endWC+(oneDay*3)){
         groupInterval = setInterval(getGroupResults,120000);//Sep 18 increased frequency
         }
         
         //------------------------------------------------------------------------------ // LIVE MATCH 			
         function getMatchInfo(matchID){
         	var infoData;
         	sym.getSymbol("matchtracker").$("penaltiesTxt").fadeOut(0);
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gnNo+"&yr="+gnYear+"&sport=rugby&match="+matchID+"&q=info",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			infoData = data;
         			var matchteam1, matchteam2, matchteam1Short, matchteam2Short, score1, score2;
         			var homeTeamID=infoData[0].n_Team1ID;var awayTeamID=infoData[0].n_Team2ID;
         			for (var p=0;p<15;p++){
         					sym.getSymbol("matchtracker").getSymbol("positions").getSymbol("playerNos").$("h"+(p+1)).off('click');
         					sym.getSymbol("matchtracker").getSymbol("positions").getSymbol("playerNos").$("a"+(p+1)).off('click');
         			}
         			getTeams(matchID,infoData[0].n_Team1ID,infoData[0].n_Team2ID);
         			for(var c=0;c<20;c++){
         					if (homeTeamID>0){
         						if (homeTeamID==teamIDs[c]){
         							matchteam1=teamArr[c]; matchteam1Short=teamShortArr[c]
         						}else{
         							matchteam1=infoData[0].c_Team1;matchteam1Short=infoData[0].c_Team1Short;
         							matchteam1=matchteam1.replace("Winner", txtArr[12]); matchteam1=matchteam1.replace("Loser", txtArr[13]);
         						}
         					}else{
         						matchteam1=null;matchteam1Short=null;
         					}
         					if (awayTeamID>0){
         						if (awayTeamID==teamIDs[c]){
         							matchteam2=teamArr[c]; matchteam2Short=teamShortArr[c]
         						}else{
         							matchteam2=infoData[0].c_Team2;matchteam2Short=infoData[0].c_Team2Short;
         							matchteam2=matchteam2.replace("Winner", txtArr[12]); matchteam2=matchteam2.replace("Loser", txtArr[13]);
         						}
         					}else{
         						matchteam2=null;matchteam2Short=null;
         					}
         			}
         			var notStarted=['h2hMc'];
         			var showStarted=['timer','timeTxt','clock'];
         			//matchStatus = infoData[0].n_MatchStatusCode;//
         			if(infoData[0].b_Postponed==true||infoData[0].b_Abandoned==true){matchStatus=4096;}
         			else if(infoData[0].b_Finished==true){matchStatus=128;}
         			else if(infoData[0].b_Suspended==true){matchStatus=16;}
         			else if(infoData[0].b_Started==true){matchStatus=8;}
         			else if(infoData[0].b_Live==true){matchStatus=2;}
         			else{matchStatus=0;}
         			getH2H(matchID);	
         			//if(infoData[0].b_Started==false){
         			if(matchStatus<8){
         				score1="0";
         				score2="0";
         				for(var n=0;n<notStarted.length;n++){
         					sym.getSymbol("matchtracker").$(notStarted[n]).fadeIn(600);
         				}
         				for(var m=0;m<showStarted.length;m++){
         					sym.getSymbol("matchtracker").$(showStarted[m]).fadeOut(0);
         				}
         				clearInterval(playInterval);
         			}else{
         				//if(infoData[0].b_Live==true){
         				if(matchStatus>=2){
         					clearInterval(matchInterval);
         					clearInterval(playInterval);
         					matchInterval = setInterval(function() { getMatchInfo(matchID); }, 60000);
         					playInterval = setInterval(function() { getMatch(matchID); }, 60000);
         				}
         				score1=infoData[0].n_Result1;
         				score2=infoData[0].n_Result2;
         				for(var n=0;n<notStarted.length;n++){
         					sym.getSymbol("matchtracker").$(notStarted[n]).fadeOut(0);
         				}
         				for(var m=0;m<showStarted.length;m++){
         					sym.getSymbol("matchtracker").$(showStarted[m]).fadeIn(600);
         				}
         				getmatchStats(matchID);
         			}
         			//if(infoData[0].b_Finished==true){
         			if(matchStatus>=128){
         				clearInterval(matchInterval);
         				matchInterval = setInterval(function() { getMatchInfo(matchID); }, 300000);
         				clearInterval(playInterval);
         			}
         				//var matchTime = (infoData[0].d_DateUTC)?getDDmonthYY(infoData[0].d_DateUTC):"TBC";
         //		}else{
         				var offsetVenue, matchDate, localTime, venueTime;;
         				if (infoData[0].d_DateUTC!=null){
         						offsetVenue = getDST(infoData[0].d_DateUTC);
         						localTime=getMatchLocal(infoData[0].d_Date)+" "+getDateLocal(infoData[0].d_Date);
         						venueTime=getMatchTime(infoData[0].d_Date,offsetVenue)+" "+getDDmonthYY(infoData[0].d_DateUTC);
         						matchDate=getDDmonthYY(infoData[0].d_DateUTC);
         				}else{
         						offsetVenue = "TBC"; localTime="TBC";venueTime="TBC";matchDate =  "TBC";
         				}
         //			}
         			var matchscore = score1 + "-" + score2;
         			var imgH = "crests/"+ (teamIDs.indexOf(homeTeamID)>=0?homeTeamID:null) +".png";
         			var imgA = "crests/"+ (teamIDs.indexOf(awayTeamID)>=0?awayTeamID:null) +".png";				
         			var matchInfo = infoData[0].c_Stadium + ", " + infoData[0].c_City + "<br /><img src'images/time.png'><span class='venuetime'>" + venueTime + "</span><span class='localtime'>"+localTime+"</span>";
         			sym.getSymbol("matchtracker").$("matchcrest1").attr("src",imgH);				
         			sym.getSymbol("matchtracker").$("matchcrest2").attr("src",imgA);				
         			sym.getSymbol("matchtracker").$("matchteam1Txt").text(matchteam1);
         			sym.getSymbol("matchtracker").$("matchteam2Txt").text(matchteam2);
         			sym.getSymbol("matchtracker").$("matchscoreTxt").text(matchscore);
         			sym.getSymbol("matchtracker").$("matchinfoTxt").html(matchInfo);
         			showLocal==0?($(".localtime").fadeOut(0),$(".venuetime").fadeIn(0)):($(".localtime").fadeIn(0),$(".venuetime").fadeOut(0)); 
         			//matchStatus 8 (in progress), 128 (finished)
         			//PENALTY SHOOTOUT
         			if (infoData[0].n_PeriodSort>=10&&infoData[0].n_Result1Shootout!=null){
         				//if (lastPeriod==10){	
         				var pensH=(infoData[0].n_Result1Shootout>=0)?infoData[0].n_Result1Shootout:"";
         				var pensA=(infoData[0].n_Result2Shootout>=0)?infoData[0].n_Result2Shootout:"";
         				var penalties= txtArr[33]+" (" +pensH+ "-" +pensA+ ")";
         				if (infoData[0].n_Result1Shootout>=0||infoData[0].n_Result2Shootout>=0){
         						sym.getSymbol("matchtracker").$("penaltiesTxt").html(penalties);
         						sym.getSymbol("matchtracker").$("penaltiesTxt").fadeIn(0);
         					}
         			}	               							
         		}
         	});
         }
         
         var matchData;
         var lastAction;
         var lastTime;
         var lastPeriod;
         function getMatch(matchID) { 
         	var minutes = sym.getSymbol("matchtracker").$("timeTxt");
         	minutes.text("0"); 
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gnNo+"&yr="+gnYear+"&sport=rugby&match="+matchID,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			matchData = data;
         				if(matchData){
         					lastAction = matchData[0].n_ActionTime;
         					lastPeriod = matchData[0].n_PeriodSort;
         					var lastTimetxt;
         					var minutes = sym.getSymbol("matchtracker").$("timeTxt");
         					sym.getSymbol("matchtracker").$("timer").empty();
         					//create display for each action	
         					var actionTxt, penTxt, HorA, actionSet, actionType, action, actionTime, actionMs, actionPeriod;
         					var keyTxt="<div class='action'>";
         					keyTxt+="<div class='key'><img src='images/try.png' style='width:15px'> "+key[0]+"</div>";
         					keyTxt+="<div class='key'>"+"<img src='images/pen.png' style='width:15px'> "+key[1]+"</div>";
         					keyTxt+="<div class='key'>"+"<img src='images/con.png' style='width:15px'> "+key[2]+"</div>";
         					keyTxt+="<div class='key'>"+"<img src='images/sub.png' style='width:15px'> "+key[3]+"</div>";
         					keyTxt+="</div>";
         					sym.getSymbol("matchtracker").$("timer").append(keyTxt)
         					for (var i = 0; i <= matchData.length; i++) {
         						if (matchData[i].n_ActionTime>lastAction){
         							lastAction=matchData[i].n_ActionTime;
         						}
         						if (matchData[i].n_PeriodSort>lastPeriod){
         							lastPeriod=matchData[i].n_PeriodSort;
         						}         		        
         						actionSet = matchData[i].n_ActionSetID;
         						actionType = matchData[i].n_ActionType;
         						actionSpec= matchData[i].n_ActionTypeSpecific;
         						actionTime = (matchData[i].c_ActionMinute==null)?"":matchData[i].c_ActionMinute;
         						var HorA = (matchData[i].n_HomeOrAway==1)?"h":"a";
         						if (actionSet==2||actionSet==5||actionSet==15){
         							actionMs = matchData[i].n_ActionTime;
         							actionPeriod = matchData[i].n_PeriodSort;
         							var actionTxt="<div class='action period"+actionPeriod+"' id=action"+i+"'>";//style by period
         							actionTxt+="<div class='personh' id='person"+i+"h'></div>";
         							actionTxt+="<div class='type' id='type"+i+"h'></div>";	
         							actionTxt+="<div class='actiontime' id='actionMins"+i+"'></div>";
         							actionTxt+="<div class='type' id='type"+i+"a'></div>";
         							actionTxt+="<div class='persona' id='person"+i+"a'></div>";
         							actionTxt+="</div>";
         							//then append each action (latest at top)
         							switch (actionType){
         								case 1: if (actionSpec==4){action="drop"}else if(actionSpec==8){action="try"}else{action="pentry"}; break;
         								case 5: action =(actionSpec==1)?"con":"pen"; break;
         								case 20: if (actionSpec==4){action="miss"}else if(actionSpec==8){action="miss"}else{action="miss"}; break;
         								case 64: action ="yellow"; break;
         								case 128: action ="red"; break;
         								case 512: action ="sub"; break;//1=sub-in, 2=temp sub-in
         								case 1024: action = "sub"; break;//1=sub out, 2=temp sub out, 4=injured out, 8=injured temp out, 16=blood bin out
         							}	
         							sym.getSymbol("matchtracker").$("timer").prepend(actionTxt);
         							var player=matchData[i].c_PersonShort;     
         							var sub=(actionSet==15)?" (" + matchData[i].c_SubPersonShort + ")":"";//substitutions
         							var persontxt=(action=="pentry")?txtArr[34]:player+sub;
         							//$('#person' + i + HorA).text(player+sub);
         							$('#person' + i + HorA).text(persontxt);
         							$('#actionMins' + i).text(actionTime);
         							//create icons for each action
         							/*
         							switch (actionSet){
         								case 2:
         								switch(actionType){
         									case 1:
         									switch(actionSpec){
         										case 4: action="drop"; break;
         										case 8: action="try"; break;
         										case 16: action="pentry"; break;
         									};
         									break;
         									case 5: action =(actionSpec==1)?"con":"pen"; break;
         								}
         							}
         							*/
         							var imgHTML="<img src='images/"+action +".png' height='20px' width='20px'>";
         							$('#type' + i + HorA).html(imgHTML);
         							$('.key').css({'display':'table-cell','font-style':'italic','padding-left':'5px'});
         							$('.action').css({'display':'inline-table','height':'20px','width':'100%','font-size':'12px','font-family':'pragmatica-web, sans-serif','text-align':'left','border-bottom':'solid 1px rgb(150,150,150)','border-top':'solid 1px rgba(255,255,255,0.6)'});
         							$(".period4").css({'background-color':'rgba(255,170,50,0.1)'});
         							$(".period6, .period8").css({'background-color':'rgba(255,0,0,0.1)'});
         							$(".period10").css({'background-color':'rgba(255,40,0,0.3)'});
         							$('.personh').css({'text-align':'right','display':'table-cell','width':'37%'});
         							$('.actiontime').css({'background-color':'rgba(100,100,100,0.6)','text-align':'center','display':'table-cell','width':'12%','color':'rgb(255,255,255)'});
         							$('.type').css({'display':'table-cell','width':'7%','text-align':'center'});
         							$('.persona').css({'text-align':'left','display':'table-cell','width':'37%'});
                  			} //close if
         						if (lastAction>6000000){					//if after 100 mins but before penalties
         							lastTime=6000000;
         						}else if ((lastAction>5400000)&&(lastPeriod<7)){					//if after 90 mins but before second period
         							lastTime=5400000;
         						}else if ((lastAction>4800000)&&(lastPeriod==11)){					//if after 80 mins match has finished
         							lastTime=4800000;
         						}else if ((lastAction>4800000)&&(lastPeriod<5)){					//if after 80 mins but before extra time
         							lastTime=4800000;
         						}else if((lastAction>2400000)&&(lastPeriod<4)){ 		// if match is in 1st half but > 40 mins
         							lastTime=2400000;
         						}else{
         							lastTime=lastAction;
         						}
         						//display latest time
         						if (lastPeriod==11){
         							lastTimetxt=Math.round(lastTime/60000);
         						}else if (lastPeriod<9){ //before penalty shootout
         							if(lastAction > 0){	
         								lastTimetxt=Math.round(lastAction/60000);
         							}
         						}else{
         							lastTimetxt="120";
         						}
                  			minutes.text(lastTimetxt); //SHOW LATEST TIME
         					} //close for 
         					if (lastPeriod>5){ //extra time draw line at ht/ft
         					}
         				}
         		},//close success 
         		error: function(){ 
         			console.log("Match not started");
         		}  	                                                  	           
         	}); //close ajax
         }
         var positions=['W','H','P','FB','BR','2R','SH','FH'];
         function getTeams(matchID,home,away) {           
                  	sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquadh").empty(); //PASS teamIDs to teamInterval
                  	sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquada").empty();
                     var teamData;
                  	$.ajax({ type: "GET", url: dataURL,
                  		data: "gn="+gnNo+"&yr="+gnYear+"&sport=rugby&q=teams&match="+matchID,
                  		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  		async: true,
                  		crossDomain: true,
                  		success: function (data) {
                  			teamData = data;
                  			if (!teamData){
         							getSquad(home,"home");
         							getSquad(away,"away");
         							sym.getSymbol("matchtracker").$("txt16").html(txtArr[21]);
         							sym.getSymbol("matchtracker").$("txt17").html(txtArr[21]);
                  			}else{
         							var coach,teamlist,team,hORa,matchRef;
         							sym.getSymbol("matchtracker").$("txt16").html(txtArr[20]);
         							sym.getSymbol("matchtracker").$("txt17").html(txtArr[20]);
         							sym.getSymbol("matchtracker").getSymbol("teams").$("preloaderh").fadeOut(0);
         							sym.getSymbol("matchtracker").getSymbol("teams").$("preloadera").fadeOut(0);
         							for (var i = 0; i < teamData.length; i++) {		
         								var shirtNr = (teamData[i].c_ShirtNr!=null)?teamData[i].c_ShirtNr:"";
         								var player = teamData[i].c_Person;
         								var playerShort = teamData[i].c_PersonShort;
         								if (teamData[i].n_HomeOrAway==1){
         									teamlist = "matchSquadh";
         									hORa='h';
         								}else if (teamData[i].n_HomeOrAway==-1){
         									teamlist = "matchSquada";
         									hORa='a';
         								}else if(teamData[i].b_Referee==true&&teamData[i].c_FunctionShort=="Ref"){
         									matchRef=teamData[i].c_Person;
         									sym.getSymbol("matchtracker").$("matchinfoTxt").append("<br>"+txtArr[22]+matchRef);
         								}
         								if (teamData[i].b_Player==true){	
         									if (teamData[i].b_StartingLineup==true){
         										var lineupTxt = "<div class='lineup' id='lineup" + i + "'>";
         									} else{
         										var lineupTxt = "<div class='substitute' id='lineup" + i + "'>";
         									}	
         										lineupTxt += "<div class='shirtNr' id='teamShirt" + i + "'></div>";
         										lineupTxt += "<div class='playerNm' id='teamPerson" + i + "'></div>";
         										lineupTxt += "</div>";
         										sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquad"+hORa).append(lineupTxt);
         								}
         								//if (teamData[i].n_FunctionType==16){
         								if (teamData[i].b_Coach==true){
         									coach = "<div style='padding-left:3px'><b>" + teamData[i].c_Person + "</b> <span style='text-align:right; font-style:oblique; font-size:12px'></span></div>";
         									sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquad"+hORa).prepend(coach);
         								}
         								sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquad"+hORa).css({'font-family':'pragmatica-web,sans-serif','font-size':'13px'}); 
         								$('.lineup').css({'width':'100%','display':'inline-table'});
         								$('.substitute').css({'width':'100%','display':'inline-table','font-style':'oblique'});
         								$('.shirtNr').css({'width':'10%','display':'table-cell','text-align':'left','padding-left':'3px'});  
         								$('.playerNm').css({'width':'90%','display':'table-cell','text-align':'left','padding-left':'5px'});                        			
         								$('#teamShirt' + i).text(shirtNr);
         								$('#teamPerson' + i).html(player);
         								var posn = teamData[i].c_FunctionShort;//H,P,LHP,THP,2R,C,SH,FH,W,LW,RW,B,FB,4L,5L,BF,OF,	N8,ICtr, OCtr	
         								var hORaNum=(hORa=="h")?1:2;
         								if (shirtNr>0&&shirtNr<16){
         									sym.getSymbol("matchtracker").getSymbol("positions").getSymbol("playerNos").$(hORa+shirtNr).on('click',showPos(hORaNum,shirtNr,playerShort));
         								}	
         							}
         							initSize();
         						}
         
                  		}
                  	});
         }
         function getSquad(team,homeOrAway){
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gnNo+"&yr="+gnYear+"&sport=rugby&squad="+team,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			squadData=data;
         			for (var p=0;p<15;p++){
         					sym.getSymbol("matchtracker").getSymbol("positions").getSymbol("playerNos").$("h"+(p+1)).on('click',showPos(1,p+1));
         					sym.getSymbol("matchtracker").getSymbol("positions").getSymbol("playerNos").$("a"+(p+1)).on('click',showPos(2,p+1));
         			}
         			if(squadData.length>0){
         			for (var i = 0; i <squadData.length; i++) {
         				var shirtNr = (squadData[i].c_ShirtNr!=null)?squadData[i].c_ShirtNr:"";
         				var player = squadData[i].c_Person;
         				//var position=squadData[i].c_FunctionShort;
         				var position=squadData[i].n_FunctionType;
         					if(homeOrAway){
         						var hORa=(homeOrAway=="home")?"h":"a";
         						if (position!=16){
         							var squadlist = "<div id='"+hORa+"player"+i+"'>";
         							squadlist += "<div class='squadCol1' id='"+hORa+"sqdshirt"+i+"'></div>";
         							squadlist += "<div class='squadCol2' id='"+hORa+"sqdplayerName"+i+"'>"+player+"</div>";
         							squadlist += "<div class='squadCol5' id='"+hORa+"sqdpos"+i+"'></div>";
         							squadlist += "</div>";
         							sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquad"+hORa).append(squadlist);  
         						}else{//null
         							var coach = "<div id='"+hORa+"player"+i+"'>";
         							coach += "<div class='squadCol2 coach' id='"+hORa+"sqdplayerName"+i+"'>"+txtArr[19]+player+"</div>";
         							coach += "<div class='squadCol5' id='"+hORa+"nat"+i+"'>" + squadData[i].c_PersonNatioShort + "</div>";
         							coach += "</div>";
         							sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquad"+hORa).prepend(coach);
         						}
         						sym.getSymbol("matchtracker").getSymbol("teams").$("preloader"+hORa).fadeOut(0); 
         						sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquad"+hORa).css({'font-size':'12px','font-family':'pragmatica-web, sans-serif'});          
         						$('#'+hORa+'player'+i).css({'width':'100%', 'display':'inline-table'});
         						$('.squadCol1').css({'width':'10%', 'color':'rgb(0,156,178)','padding-left':'3px', 'text-align':'right','display':'table-cell'});
         						$('.squadCol2').css({'width':'90%', 'padding-left':'3%','display':'table-cell'});
         						$('#'+hORa+'sqdplayerName'+i).css({'font-weight':400});
         						$('#'+hORa+'sqdshirt'+i).text(shirtNr);
         						//$('#'+hORa+'sqdplayerName'+i).html(player);
         
         					}
         			}
         			$('.squadCol1').css({'width':'5%', 'color':'rgb(0,156,178)','padding-left':'3px', 'text-align':'right','display':'table-cell'});
         			$('.squadCol2').css({'width':'50%', 'padding-left':'3%','display':'table-cell'});
         			$('.squadCol5').css({'width':'25%', 'display':'table-cell', 'text-align':'center','font-style':'italic'});
         			$('.squadCol3').css({'width':'10%', 'display':'table-cell', 'text-align':'center'});
         			$('.squadCol4').css({'width':'10%', 'display':'table-cell', 'text-align':'right'});
         			$('.squadnat').css({'text-align':'right','font-style':'oblique','font-size':'90%'});
         			$(".coach").css({'font-weight':700});
         			initSize();
         				sym.getSymbol("matchtracker").getSymbol("teams").$("preloader"+hORa).fadeOut(0);
         			}
         		}
         	});
         }
         
         //PIE CHART
         function pieChart(hwins,awins,draws,placeHolder){			
              var canvasWidth = 145, //width
               canvasHeight = 90,   //height
               outerRadius = 45,   //radius
               //color = d3.scale.category20(); //builtin range of colors
         		color = d3.scale.ordinal().range(["#006666","#4e9799","#33c5cc","#FF6666"]);
             var dataSet = [
               {"legendLabel":"Won", "magnitude":awins},  
               {"legendLabel":"Drawn", "magnitude":draws}, 
               {"legendLabel":"Won", "magnitude":hwins}];
             var vis = d3.select(placeHolder)
               .append("svg:svg") //create the SVG element inside the <body>
                 .data([dataSet]) //associate our data with the document
                 .attr("width", canvasWidth) //set the width of the canvas
                 .attr("height", canvasHeight) //set the height of the canvas
                 .append("svg:g") //make a group to hold our pie chart
         			.attr("transform", "translate("+canvasWidth/2+","+canvasHeight/2+")") //move centre of pie chart from 0, 0 to middle of placeholder
         			//	.attr("viewBox", +canvasWidth/2+"px",+canvasHeight/2+"px",90,90)
         				.style("-webkit-transform", "translate("+canvasWidth/2+"px,"+canvasHeight/2+"px)");
             // This will create <path> elements for us using arc data...
             var arc = d3.svg.arc()
               .outerRadius(outerRadius)
         		.innerRadius(outerRadius-30); //donut chart
             var pie = d3.layout.pie() //this will create arc data for us given a list of values
               .value(function(d) { return d.magnitude; }) // Binding each value to the pie
               .sort( function(d) { return null; } );
             // Select all <g> elements with class slice (there aren't any yet)
             var arcs = vis.selectAll("g.slice")  // Associate the generated pie data (an array of arcs, each having startAngle, endAngle and value properties) 
               .data(pie) // This will create <g> elements for every "extra" data element that should be associated with a selection. The result is creating a <g> for every object in the data array
               .enter() // Create a group to hold each slice (we will have a <path> and a <text> element associated with each slice)
               .append("svg:g")
               .attr("class", "slice");    //allow us to style things in the slices (like text)
             arcs.append("svg:path")
               //set the color for each slice to be chosen from the color function defined above
               .attr("fill", function(d, i) { return color(i); } ) //this creates the actual SVG path using the associated data (pie) with the arc drawing function
               .attr("d", arc);
         }
         function getH2H(match){
         	sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hmatch").html("<div style='font-family:pragmatica-web;text-align:center;font-size:14px'>"+txtArr[29]+"</div>");
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gnNo+"&yr="+gnYear+"&sport=rugby&q=h2hsum&match="+match,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hgoals").empty();
         			sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt1").empty();
         			sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt2").empty();
         			sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt3").empty();
         			sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hmatch").empty();
         			sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt4").fadeIn(0);
         			h2hData = data;
         			if(h2hData.length>0&&h2hData[0].n_Matches>0){			
         				var hwins=h2hData[0].n_MatchesWonHome;
         				var awins=h2hData[0].n_MatchesWonAway;
         				var draws=h2hData[0].n_MatchesDrawn;
         				var hgoals=h2hData[0].n_GoalsForHome;
         				var agoals=h2hData[0].n_GoalsForAway;
         				var placeHolder="#Stage_matchtracker_h2hMc_h2hmatch";
         				pieChart(hwins,awins,draws,placeHolder);
         				sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt1").html(txtArr[28]+": <b>"+hwins+"</b>");
         				sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt2").html(txtArr[29]+": <b>"+awins+"</b>");
         				sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt3").html(txtArr[30]+": <b>"+draws+"</b>");
         				//sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt4").html(txtArr[14]);
         				var barTxt="<div class='barGraph'>";
         					barTxt+="<div id='capGoals'></div>";
         				barTxt+="<div id='hbarGoals'></div>";
         				barTxt+="<div id='abarGoals'></div>";
         				barTxt+="</div>";
         				sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hgoals").append(barTxt);
         				var hwidth=(hgoals/(hgoals+agoals)*100)+"%";
         				var awidth=(agoals/(hgoals+agoals)*100)+"%";
         				$("#hbarGoals").text(hgoals);
         				$("#abarGoals").text(agoals);
         				var acolor=(agoals==0)?'#33c5cc':'#006666';
         				var hcolor=(hgoals==0)?'#006666':'#33c5cc';
         				$("#capGoals").html(txtArr[31]);
         				$(".barGraph").css({'font-family':'pragmatica-web,sans-serif','width':'100%','height':'20px','font-size':'13px','font-weight':700, 'display':'inline-table'});
         				$("#capGoals").css({'text-align':'center','width':'100%','display':'table-caption'});
         				$("#hbarGoals").css({'background-color':hcolor,'color':'#ffffff','padding-left':'5px','padding-top':'2px','text-align':'left', 'display':'table-cell','width':hwidth});
         				$("#abarGoals").css({'background-color':acolor,'color':'#ffffff','padding-right':'5px','padding-top':'2px','text-align':'right','width':awidth,'display':'table-cell'});
         			}else{
         				sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt4").fadeOut(0);
         				sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hmatch").append("<div style='font-family:pragmatica-web;text-align:center;font-size:14px'>"+txtArr[32]+"</div>");
         			}
         		}
         	});
         }
         function getmatchStats(match){
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gnNo+"&yr="+gnYear+"&sport=rugby&q=stats&match="+match,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			sym.getSymbol("matchtracker").getSymbol("matchStats").$("chartHolder1").empty();
         			sym.getSymbol("matchtracker").getSymbol("matchStats").$("chartHolder2").empty();
         			sym.getSymbol("matchtracker").getSymbol("matchStats").$("barCharts").empty();
         			matchData = data;
         			var bar;
         			var placeHolder1="#Stage_matchtracker_matchStats_chartHolder1"; var placeHolder2="#Stage_matchtracker_matchStats_chartHolder2";
         			if (matchData.length>0){
         				function drawBar(){
                  			var barTxt="<div class='barGraph'>";
                  			barTxt+="<div id='cap"+bar+"'></div>";
                  			barTxt+="<div id='hbar"+bar+"'></div>";
                  			barTxt+="<div id='abar"+bar+"'></div>";
                  			barTxt+="</div>";
         						sym.getSymbol("matchtracker").getSymbol("matchStats").$("barCharts").append(barTxt);
                  	}
                  	var pts1,pts2,kicks1,kicks2,cons1,cons2,pens1,pens2,drops1,drops2,missed1,missed2,cmissed1,cmissed2,pmissed1,pmissed2,dmissed1,dmissed2;
         				for (var i = 0; i < matchData.length; i++) {
         					if(matchData[i].n_StatID==219003){//tries
         						pts1=matchData[i].n_Value1;
         						pts2=matchData[i].n_Value2;
         						bar="tries";
         						drawBar();
         					}else if(matchData[i].n_StatID==219004){//cons
         						cons1=matchData[i].n_Value1;
         						cons2=matchData[i].n_Value2;
         						pts1=cons1;
         						pts2=cons2;
         						bar="cons";
         						drawBar();
         					}else if(matchData[i].n_StatID==219005){//cons missed
         						cmissed1=matchData[i].n_Value1;
         						cmissed2=matchData[i].n_Value2;
         					}else if(matchData[i].n_StatID==219006){//pens
         						pens1=matchData[i].n_Value1;
         						pens2=matchData[i].n_Value2;
         						pts1=pens1;
         						pts2=pens2
         						bar="pens";
         						drawBar();
         					}else if(matchData[i].n_StatID==219007){//pen missed
         						pmissed1=matchData[i].n_Value1;
         						pmissed2=matchData[i].n_Value2;
         					}else if(matchData[i].n_StatID==219008){//drops
         						drops1=matchData[i].n_Value1;
         						drops2=matchData[i].n_Value2;
         					}else if(matchData[i].n_StatID==219009){//drops missed
         						dmissed1=matchData[i].n_Value1;
         						dmissed2=matchData[i].n_Value2;
         					}
         					var hwidth=(pts1/(pts1+pts2)*100)+"%";
         					var awidth=(pts2/(pts1+pts2)*100)+"%";
         					$("#hbar"+bar).text(pts1);
         					$("#abar"+bar).text(pts2);
         					$(".barGraph").css({'margin':'10px 0px','font-family':'pragmatica-web,sans-serif','width':'100%','height':'20px','font-size':'13px', 'display':'inline-table'});
         					$("#cap"+bar).css({'text-align':'center','width':'100%','display':'table-caption','font-weight':700});
         					$("#hbar"+bar).css({'background-color':'#33c5cc','color':'#ffffff','padding-left':'5px','text-align':'left', 'display':'table-cell','width':hwidth});
         					$("#abar"+bar).css({'background-color':'#006666','color':'#ffffff','padding-right':'5px','text-align':'right','width':awidth,'display':'table-cell'});
         
         					$("#captries").html(txtArr[23]);
         					$("#capcons").html(txtArr[24]);
         					$("#cappens").html(txtArr[25]);
         
         
         				}
         				missed1=cmissed1+pmissed1+dmissed1; missed2=cmissed2+pmissed2+dmissed2;
         				kicks1=cons1+pens1+drops1+missed1; kicks2=cons2+pens2+drops2+missed2;
         				var success1=kicks1-missed1; var success2=kicks2-missed2;
         				console.log(success2/kicks2);
         				pieChart(success1,missed1,0,placeHolder1); pieChart(success2,missed2,0,placeHolder2);
         				sym.getSymbol("matchtracker").getSymbol("matchStats").$("hpiTxt").html(Math.round(success1/kicks1*100)+"%");
         				sym.getSymbol("matchtracker").getSymbol("matchStats").$("apiTxt").html(Math.round(success2/kicks2*100)+"%");
         
         			}
         		}
         	});
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'MenuBtns'
   (function(symbolName) {   
   
   })("MenuBtns");
   //Edge symbol end:'MenuBtns'

   //=========================================================
   
   //Edge symbol: 'StyleHead'
   (function(symbolName) {   
   
   })("StyleHead");
   //Edge symbol end:'StyleHead'

   //=========================================================
   
   //Edge symbol: 'MenuBtn'
   (function(symbolName) {   
   
   })("MenuBtn");
   //Edge symbol end:'MenuBtn'

   //=========================================================
   
   //Edge symbol: 'TimeZone'
   (function(symbolName) {   
   
   })("TimeZone");
   //Edge symbol end:'TimeZone'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'Match'
   (function(symbolName) {   
   
   })("Match");
   //Edge symbol end:'Match'

   //=========================================================
   
   //Edge symbol: 'TableHead'
   (function(symbolName) {   
   
   })("TableHead");
   //Edge symbol end:'TableHead'

   //=========================================================
   
   //Edge symbol: 'H2hMc'
   (function(symbolName) {   
   
   })("H2hMc");
   //Edge symbol end:'H2hMc'

   //=========================================================
   
   //Edge symbol: 'MatchStats'
   (function(symbolName) {   
   
   })("MatchStats");
   //Edge symbol end:'MatchStats'

   //=========================================================
   
   //Edge symbol: 'Teams'
   (function(symbolName) {   
   
   })("Teams");
   //Edge symbol end:'Teams'

   //=========================================================
   
   //Edge symbol: 'example'
   (function(symbolName) {   
   
   })("example");
   //Edge symbol end:'example'

   //=========================================================
   
   //Edge symbol: 'MatchMenuBtn'
   (function(symbolName) {   
   
   })("MatchMenuBtn");
   //Edge symbol end:'MatchMenuBtn'

   //=========================================================
   
   //Edge symbol: 'GroupStage'
   (function(symbolName) {   
   
   })("GroupStage");
   //Edge symbol end:'GroupStage'

   //=========================================================
   
   //Edge symbol: 'Overview'
   (function(symbolName) {   
   
   })("Overview");
   //Edge symbol end:'Overview'

   //=========================================================
   
   //Edge symbol: 'Knockout'
   (function(symbolName) {   
   
   })("Knockout");
   //Edge symbol end:'Knockout'

   //=========================================================
   
   //Edge symbol: 'Minimize'
   (function(symbolName) {   
   
   })("Minimize");
   //Edge symbol end:'Minimize'

   //=========================================================
   
   //Edge symbol: 'Latest'
   (function(symbolName) {   
   
   })("Latest");
   //Edge symbol end:'Latest'

   //=========================================================
   
   //Edge symbol: 'LatestTable'
   (function(symbolName) {   
   
   })("LatestTable");
   //Edge symbol end:'LatestTable'

   //=========================================================
   
   //Edge symbol: 'bg'
   (function(symbolName) {   
   
   })("bg");
   //Edge symbol end:'bg'

   //=========================================================
   
   //Edge symbol: 'Positions'
   (function(symbolName) {   
   
   })("Positions");
   //Edge symbol end:'Positions'

   //=========================================================
   
   //Edge symbol: 'PlayerNos'
   (function(symbolName) {   
   
   })("PlayerNos");
   //Edge symbol end:'PlayerNos'

   //=========================================================
   
   //Edge symbol: 'posBtn'
   (function(symbolName) {   
   
   })("posBtn");
   //Edge symbol end:'posBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33382");