/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clicked = 0;
         	var btnNo = 0;
         	var mob = 0;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "height":"auto", "width":"auto", "padding":"8px"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var whiteTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.6)", "height":"auto","width":"auto", "padding":"3px"};
         	
         	var whiteTxtBox2 = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,1)", "height":"auto","width":"auto", "padding":"6px", "padding-left":"50px"};
         	
         	var redTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(218,0,0,1)", "height":"auto","width":"auto", "padding":"6px"};
         	
         	var yellowTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"#FBAE17", "height":"auto","width":"auto", "padding":"6px"};
         	
         	var blueTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"0px", "background-color":"#0060AE", "height":"auto", "padding":"5px"};
         	
         	var outBtn  = {"background-color":"rgba(160,160,160,1)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         	
         	var txt=[];
         	for (var i=0; i<9; i++){
         		txt[i] = sym.getSymbol("mapMc1").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[9] = sym.$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.$("txt13").css({"pointer-events":"none"});
         	txt[14] = sym.$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.$("txt15").css({"pointer-events":"none"});
         	for (var i=16; i<31; i++){
         		txt[i] = sym.getSymbol("mapMc2").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[31] = sym.$("txt31").css({"pointer-events":"none"});
         	txt[32] = sym.$("txt32").css({"pointer-events":"none"});
         	txt[33] = sym.$("txt33").css({"pointer-events":"none"});
         	txt[34] = sym.$("txt34").css({"pointer-events":"none"});
         	for (var i=35; i<42; i++){
         		txt[i] = sym.getSymbol("liftMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[42] = sym.$("txt42").css({"pointer-events":"none"});
         	txt[43] = sym.$("txt43").css({"pointer-events":"none"});
         	txt[44] = sym.$("txt44").css({"pointer-events":"none"});
         	txt[45] = sym.$("txt45").css({"pointer-events":"none"});
         	txt[46] = sym.$("txt46").css({"pointer-events":"none"});
         	txt[47] = sym.$("txt47").css({"pointer-events":"none"});
         	txt[48] = sym.$("txt48").css({"pointer-events":"none"});
         	txt[49] = sym.$("txt49").css({"pointer-events":"none"});
         	txt[50] = sym.$("txt50").css({"pointer-events":"none"});
         	
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33368.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			standBackgroudColour = $(xml).find('standBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			sym.getSymbol("standBgMc").$("standBg").css({"background-color":standBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<42; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         	
         			//sym.getSymbol("SYMBOL").$("txt").animate({top:yNUMBER - sym.getSymbol("SYMBOL").$("txt").height()+10}, 200);
         			sym.$("txt10").css(blueTxtBox);
         			sym.getSymbol("mapMc2").$("txt16").css(redTxtBox);
         			sym.getSymbol("mapMc2").$("txt18").css(whiteTxtBox);
         			sym.getSymbol("mapMc2").$("txt23").css(yellowTxtBox);
         			sym.getSymbol("mapMc2").$("txt29").css({"font-size":"12px"});
         			sym.$("txt31").css(blueTxtBox);
         			sym.$("txt31").css({"font-size":"16px"});
         			sym.$("txt32").css(whiteTxtBox2);
         	
         			// CHANGE TEXT
         			for (var i=0; i<9; i++){
         			sym.getSymbol("mapMc320").$("map"+i).empty();
         			sym.getSymbol("mapMc320").$("map"+i).append(txtArr[i]);
         			}
         	
         	
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SET STAGE	
         sym.$("maskTimeline").fadeOut(0);
         sym.getSymbol("liftBtn").$("btnReplay").fadeOut(0);
         sym.getSymbol("nextBtn").$("btnReplay").fadeOut(0);
         sym.$("liftBtn").fadeOut(0);
         sym.$("txt31").fadeOut(0);
         sym.$("txt32").fadeOut(0);
         sym.$("liftMc").fadeOut(0);
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("standBtn").$("plus").fadeIn(0);
         	sym.$("standBtn").animate({left:stageWidth-50}, 0);
         	sym.$("nextBtn").animate({top:280 + sym.$("txt10").height()+10}, 0);
         
         
         	setStyle();
         	if(stageWidth<800){
         	}else{
         	}
         	if(stageWidth<640){
         	sym.$("txt11").animate({top:280 + sym.$("txt10").height()+60, width:stageWidth-340, left:8}, 0);
         	sym.$("nextBtn").animate({left:0}, 0);
         		sym.$("standBtn").animate({top:40}, 0);
         		sym.$("standTxt").css({"height":"auto"});
         		sym.$("standTxt").animate({top:0 - sym.$("standTxt").height()-16, width:stageWidth-16}, 0);
         		sym.$("standBgMc").animate({top:0 - sym.$("standTxt").height()-16, width:stageWidth-0, height: sym.$("standTxt").height() +20}, 0);
         	}else{
         		sym.$("txt11").animate({top:280 + sym.$("txt10").height()+60, width:stageWidth-550, left:210}, 0);
         		sym.$("nextBtn").animate({left:202}, 0);
         		sym.$("standBtn").animate({top:-40}, 0);
         		sym.$("standTxt").animate({top:40, width:185, height:534}, 0);
         		sym.$("standBgMc").animate({top:40, width:200, height:542}, 0);
         	}
         	if (stageWidth<480){
         		mob = 1;
         		if (clicked == 0){
         			sym.$("mapMc320").fadeIn(0);
         		}
         		sym.$("nextBtn").animate({top:80}, 0);
         		sym.$("txt11").animate({top:88, width:260, left:50}, 0);
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		mob = 0;
         		sym.$("mapMc320").fadeOut(0);
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         	setStyleUpdate();
         }
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // TOGGLE STANDFIRST BUTTON
         sym.$("standBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (sym.getSymbol("standBtn").$("plus").is(":visible") ) { 
         		sym.getSymbol("standBtn").$("plus").fadeOut(0);
         		sym.$("standTxt").stop().animate({top:40}, 140);
         		sym.$("standBgMc").stop().animate({top:40, height: sym.$("standTxt").height() +20}, 140);
         		sym.$("standBtn").stop().animate({top:40 + sym.$("standTxt").height() +20}, 140);
         	}else{
         		sym.getSymbol("standBtn").$("plus").fadeIn(0);
         		sym.$("standTxt").stop().animate({top:0-sym.$("standTxt").height()}, 220);
         		sym.$("standBgMc").stop().animate({top:0 - sym.$("standTxt").height(), height:sym.$("standTxt").height()}, 220);
         		sym.$("standBtn").stop().animate({top:40}, 100);
         	}
         }); 
         
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         
         // BUTTONS SINK
         sym.$("nextBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         		sym.$("mapMc320").fadeOut(0);
         		clicked++;
         		sym.$("txt11").empty();
         		sym.$("txt32").empty();
         		if (clicked == 1) {
         			sym.getSymbol("mapMc2").play(1);
         			sym.$("txt11").append(txtArr[12]);
         		}
         		if (clicked == 2) {
         			sym.getSymbol("mapMc2").play(3201);
         			sym.$("txt11").append(txtArr[13]);
         		}
         		if (clicked == 3) {
         			sym.getSymbol("mapMc2").play(3501);
         			sym.$("txt11").append(txtArr[14]);
         		}
         		if (clicked == 4) {
         			sym.getSymbol("mapMc2").play(4049);
         			sym.$("txt11").append(txtArr[15]);
         		}
         		if (clicked == 5) {
         			sym.$("maskTimeline").fadeIn(200);
         			sym.getSymbol("mapMc2").stop(0);
         			sym.$("txt11").append(txtArr[11]);
         			sym.$("liftBtn").fadeIn(0);
         			sym.$("txt31").fadeIn(0);
         			sym.$("txt32").fadeIn(0);
         			sym.$("liftMc").fadeIn(0);
         			sym.getSymbol("liftMc").play(1);
         			sym.$("txt32").append(txtArr[32]);
         		}
         	});
         
         	// BUTTON LIFT
         sym.$("liftBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         		clicked++;
         		sym.$("txt32").empty();
         		if (clicked == 6) {
         			sym.getSymbol("liftMc").play(1539);
         			sym.$("txt32").append(txtArr[33]);
         		}
         		if (clicked == 7) {
         			sym.getSymbol("liftMc").play(2119);
         			sym.$("txt32").append(txtArr[34]);
         			sym.getSymbol("liftBtn").$("btnReplay").fadeIn(0);
         			sym.getSymbol("liftBtn").$("arrowNext").fadeOut(0);
         
         		}
         		if (clicked == 8) {
         			sym.getSymbol("liftBtn").$("btnReplay").fadeOut(0);
         			sym.getSymbol("liftBtn").$("arrowNext").fadeIn(0);
         			sym.getSymbol("liftMc").play(1);
         			sym.$("liftBtn").fadeOut(0);
         			sym.$("txt31").fadeOut(0);
         			sym.$("txt32").fadeOut(0);
         			sym.$("liftMc").fadeOut(0);
         			sym.$("maskTimeline").fadeOut(200);
         			clicked = 0;
         			if (mob == 1){
         				sym.$("mapMc320").fadeIn(0);
         			}
         		}
         	});
         
         //--------------------------------------------------------------------------------------------------------
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SET STYLE SETTING 
         function setStyle() {
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "height":"auto", "width":"auto", "padding":"6px", "padding-top":"6px"});
         	sym.getSymbol("styleHead").$("standTxt").animate({top:0 + sym.getSymbol("styleHead").$("headlineTxt").height()+8}, 0);
         	sym.getSymbol("styleHead").$("headlineTxt").stop().animate({width:stageWidth}, 0);
         	sym.getSymbol("styleBase").$("creditTxt").animate({left:stageWidth-120}, 0);
         }
         function setStyleUpdate(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("styleHead").$("standTxt").animate({top:0 + sym.getSymbol("styleHead").$("headlineTxt").height()+12}, 0);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyleUpdate();
         //--------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //--------------------------------------------------------------------------------------------------------
         $(window).on('resize',initSize);
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------- END -------------------------------------------------
         //--------------------------------------------------------------------------------------------------------

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'Base'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'toggleBtn_1'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'standBgMc'
   (function(symbolName) {   
   
   })("standBgMc");
   //Edge symbol end:'standBgMc'

   //=========================================================
   
   //Edge symbol: 'mapMc1'
   (function(symbolName) {   
   
   })("mapMc1");
   //Edge symbol end:'mapMc1'

   //=========================================================
   
   //Edge symbol: 'mapMc2'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3165, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3500, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4048, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("mapMc2");
   //Edge symbol end:'mapMc2'

   //=========================================================
   
   //Edge symbol: 'mapMc302'
   (function(symbolName) {   
   
   })("mapMc302");
   //Edge symbol end:'mapMc302'

   //=========================================================
   
   //Edge symbol: 'navBtn'
   (function(symbolName) {   
   
   })("navBtn");
   //Edge symbol end:'navBtn'

   //=========================================================
   
   //Edge symbol: 'navBg'
   (function(symbolName) {   
   
   })("navBg");
   //Edge symbol end:'navBg'

   //=========================================================
   
   //Edge symbol: 'liftMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1538, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2118, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("liftMc");
   //Edge symbol end:'liftMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33368");