/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clicked = 0;
         	var btnNo = 0;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none", "height":"auto", "width":"auto", "padding":"8px"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var txtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,0.8)", "height":"auto", "padding":"6px", "pointer-events":"none"};
         	
         	var outBtn  = {"background-color":"rgba(0,0,0,1)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         	
         	var txt=[];
         	txt[0] = sym.$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.$("txt9").css(txtBox);
         	txt[10] = sym.$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.$("txt13").css({"pointer-events":"none"});
         	txt[14] = sym.$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.$("txt17").css({"pointer-events":"none"});
         	txt[18] = sym.$("txt18").css({"pointer-events":"none"});
         	txt[19] = sym.$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.$("txt20").css({"pointer-events":"none"});
         	txt[21] = sym.$("txt21").css({"pointer-events":"none"});
         	txt[22] = sym.$("txt22").css({"pointer-events":"none"});
         	txt[23] = sym.$("txt23").css({"pointer-events":"none"});
         	txt[24] = sym.$("txt24").css({"pointer-events":"none"});
         	txt[25] = sym.$("txt25").css({"pointer-events":"none"});
         	txt[26] = sym.$("txt26").css({"pointer-events":"none"});
         	txt[27] = sym.$("txt27").css({"pointer-events":"none"});
         	txt[28] = sym.$("txt28").css({"pointer-events":"none"});
         	txt[29] = sym.$("txt29").css({"pointer-events":"none"});
         	txt[30] = sym.$("txt30").css({"pointer-events":"none"});
         	txt[31] = sym.$("txt31").css({"pointer-events":"none"});
         	txt[32] = sym.$("txt32").css({"pointer-events":"none"});
         	txt[33] = sym.$("txt33").css({"pointer-events":"none"});
         	txt[34] = sym.$("txt34").css({"pointer-events":"none"});
         	txt[35] = sym.$("txt35").css({"pointer-events":"none"});
         	txt[36] = sym.$("txt36").css({"pointer-events":"none"});
         	txt[37] = sym.$("txt37").css({"pointer-events":"none"});
         	txt[38] = sym.$("txt38").css({"pointer-events":"none"});
         	txt[39] = sym.$("txt39").css({"pointer-events":"none"});
         	txt[40] = sym.$("txt40").css({"pointer-events":"none"});
         	txt[41] = sym.$("txt41").css({"pointer-events":"none"});
         	txt[42] = sym.$("txt42").css({"pointer-events":"none"});
         	txt[43] = sym.$("txt43").css({"pointer-events":"none"});
         	txt[44] = sym.$("txt44").css({"pointer-events":"none"});
         	txt[45] = sym.$("txt45").css({"pointer-events":"none"});
         	txt[46] = sym.$("txt46").css({"pointer-events":"none"});
         	txt[47] = sym.$("txt47").css({"pointer-events":"none"});
         	txt[48] = sym.$("txt48").css({"pointer-events":"none"});
         	txt[49] = sym.$("txt49").css({"pointer-events":"none"});
         	txt[50] = sym.$("txt50").css({"pointer-events":"none"});
         	
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33340.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css({"background-color":custonCol});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<20; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         	
         			//sym.getSymbol("SYMBOL").$("txt").animate({top:yNUMBER - sym.getSymbol("SYMBOL").$("txt").height()+10}, 200);
         			sym.$("txt9").css({"font-size":"14px"});
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // MENU BUTTONS
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<6; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtn" + h).$("bg").css(outBtn);
         		sym.getSymbol("houseMc").getSymbol("pulseMc" + h).stop(0);
         		sym.getSymbol("houseMc").$("pulseMc" + h).fadeOut(0);
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		sym.$("txt9").empty();
         		sym.$("txt9").append(txtArr[menuNo + 9]);
         		sym.getSymbol("houseMc").$("pulseMc" + menuNo).fadeIn(200);
         		sym.getSymbol("houseMc").getSymbol("pulseMc" + menuNo).play(0);
         	};
         };
         
         for (var b=0;b<menuArray.length;b++){
         	sym.$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         	sym.$("menuBtn"+b).css({'cursor':'pointer'});
         }
         	sym.getSymbol("menuBtn0").$("bg").css(overBtn);
         	sym.getSymbol("houseMc").getSymbol("pulseMc0").play(0);
         	sym.getSymbol("houseMc").$("pulseMc0").fadeIn(200);
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("standBtn").$("plus").fadeIn(0);
         	sym.$("standBtn").animate({left:stageWidth-50}, 0);
         	setStyle();
         	if(stageWidth<800){
         
         	}else{
         
         	}
         	if(stageWidth<640){
         		sym.$("standBtn").animate({top:40}, 0);
         		sym.$("standTxt").css({"height":"auto"});
         		sym.$("standTxt").animate({top:0 - sym.$("standTxt").height()-16, width:stageWidth-16}, 0);
         		sym.$("standBg").animate({top:0 - sym.$("standTxt").height()-16, width:stageWidth-0, height: sym.$("standTxt").height() +20}, 0);
         	}else{
         		sym.$("standBtn").animate({top:-40}, 0);
         		sym.$("standTxt").animate({top:40, width:185, height:534}, 0);
         		sym.$("standBg").animate({top:40, width:200, height:542}, 0);
         	}
         	if (stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").empty();
         		sym.getSymbol("styleHead").$("headlineTxt").append(headline);
         	}
         }
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // TOGGLE BUTTON
         sym.$("standBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (sym.getSymbol("standBtn").$("plus").is(":visible") ) { 
         		sym.getSymbol("standBtn").$("plus").fadeOut(0);
         		sym.$("standTxt").stop().animate({top:40}, 140);
         		sym.$("standBg").stop().animate({top:40, height: sym.$("standTxt").height() +20}, 140);
         		sym.$("standBtn").stop().animate({top:40 + sym.$("standTxt").height() +20}, 140);
         	}else{
         		sym.getSymbol("standBtn").$("plus").fadeIn(0);
         		sym.$("standTxt").stop().animate({top:0-sym.$("standTxt").height()}, 220);
         		sym.$("standBg").stop().animate({top:0 - sym.$("standTxt").height(), height:sym.$("standTxt").height()}, 220);
         		sym.$("standBtn").stop().animate({top:40}, 100);
         	}
         }); 
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // GOOGLE BUTTON
         sym.$("compBtn1").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	sym.getSymbol("compBtn1").$("bg").css(overBtn);
         	sym.getSymbol("compBtn2").$("bg").css(outBtn);
         	sym.$("txt1").empty(); sym.$("txt1").append(txtArr[1]);
         	sym.$("txt2").empty(); sym.$("txt2").append(txtArr[2]);
         	sym.$("txt3").empty(); sym.$("txt3").append(txtArr[3]);
         	sym.$("txt4").empty(); sym.$("txt4").append(txtArr[4]);
         	sym.$("compLogo2").fadeOut(0);
         	sym.$("compLogo1").fadeIn(0);
         }); 
         
         // APPLE BUTTON
         sym.$("compBtn2").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	sym.getSymbol("compBtn2").$("bg").css(overBtn);
         	sym.getSymbol("compBtn1").$("bg").css(outBtn);
         	sym.$("txt1").empty(); sym.$("txt1").append(txtArr[5]);
         	sym.$("txt2").empty(); sym.$("txt2").append(txtArr[6]);
         	sym.$("txt3").empty(); sym.$("txt3").append(txtArr[7]);
         	sym.$("txt4").empty(); sym.$("txt4").append(txtArr[8]);
         	sym.$("compLogo1").fadeOut(0);
         	sym.$("compLogo2").fadeIn(0);
         }); 
         sym.$("compLogo2").fadeOut(0);
         sym.getSymbol("compBtn1").$("bg").css(overBtn);
         //--------------------------------------------------------------------------------------------------------
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SET STYLE SETTING 
         function setStyle() {
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "height":"auto", "width":"auto", "padding":"6px", "padding-top":"6px"});
         	sym.getSymbol("styleHead").$("headlineTxt").stop().animate({width:stageWidth-0}, 0);
         	sym.getSymbol("styleBase").$("creditTxt").animate({left:stageWidth-120}, 0);
         }
         //--------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //--------------------------------------------------------------------------------------------------------
         $(window).on('resize',initSize);
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------- END -------------------------------------------------

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'Base'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'toggleBtn_1'
   (function(symbolName) {   
   
   })("standBtn");
   //Edge symbol end:'standBtn'

   //=========================================================
   
   //Edge symbol: 'compBtn'
   (function(symbolName) {   
   
   })("compBtn1");
   //Edge symbol end:'compBtn1'

   //=========================================================
   
   //Edge symbol: 'compBtn1_1'
   (function(symbolName) {   
   
   })("compBtn2");
   //Edge symbol end:'compBtn2'

   //=========================================================
   
   //Edge symbol: 'menuBtn0_1'
   (function(symbolName) {   
   
      })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtn1_1'
   (function(symbolName) {   
   
      })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'menuBtn2_1'
   (function(symbolName) {   
   
      })("menuBtn3");
   //Edge symbol end:'menuBtn3'

   //=========================================================
   
   //Edge symbol: 'menuBtn3_1'
   (function(symbolName) {   
   
      })("menuBtn4");
   //Edge symbol end:'menuBtn4'

   //=========================================================
   
   //Edge symbol: 'menuBtn4_1'
   (function(symbolName) {   
   
      })("menuBtn5");
   //Edge symbol end:'menuBtn5'

   //=========================================================
   
   //Edge symbol: 'pulseMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.play(1000);

      });
      //Edge binding end

   })("pulseMc");
   //Edge symbol end:'pulseMc'

   //=========================================================
   
   //Edge symbol: 'houseMc'
   (function(symbolName) {   
   
   })("houseMc");
   //Edge symbol end:'houseMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33340");