/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var mapClick = 0;
         	var diff = 0;
         	mapPlay = false;
         	var standClick = 0;
         	var dateClicked = 0;
         	var btnNo = 0;
         	var speed = 220;
         	var stringDate, RTL;
         	var mob = false;
         	var d = new Date();
         	var n = d.getMonth();
         	var dateClicked = 0;
         	var calOpen = false;
         	var monthNo = d.getMonth()+1;
         	
         //********************************************************************************************************
         // TEST FOR MOBILE
         //********************************************************************************************************		
         var isMobile = { 
         	Android: function() { return navigator.userAgent.match(/Android/i); }, 
         	BlackBerry: function() { return navigator.userAgent.match(/BlackBerry/i); }, 
         	iOS: function() { return navigator.userAgent.match(/iPhone|iPad|iPod/i); }, 
         	Opera: function() { return navigator.userAgent.match(/Opera Mini/i); }, 
         	Windows: function() { return navigator.userAgent.match(/IEMobile/i); }, 
         	any: function() { return (isMobile.Android() || isMobile.BlackBerry() || isMobile.iOS() || isMobile.Opera() || isMobile.Windows()); }
         };
         if (!isMobile.any())
         	mob = false;
         if (isMobile.any())
         	mob = true;
         
         //********************************************************************************************************
         // TEXT
         //********************************************************************************************************
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var headlinemob;
         	var headlinetxtmob = sym.$("text").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none","padding":"6px"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         
         	var outBtn  = {"background-color":"rgba(122,122,122,1)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         	var dateBox = {"color":"white", "text-align":"center", "font-size":"12px", "font-family":"Arial", "line-height":"12px", "padding-top":"8px","border-style":"solid", "border-color":"rgba(225,225,225,0.2)", "border-width":"1px"}
         	var dayBox = {"color":"white", "text-align":"center", "font-size":"12px", "font-family":"Arial", "line-height":"12px", "padding-top":"8px","border-style":"solid", "border-color":"rgba(225,225,225,0.2)", "border-width":"1px"}
         	var pointerTxt = {"border-color":"white", "border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"#00aadf", "height":"auto", "padding":"6px",  "padding-bottom":"10px",  "padding-top":"15px"};
         	var txt=[];
         	for (var i=0; i<13; i++){
         		txt[i] = sym.getSymbol("torchMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=13; i<19; i++){
         		txt[i] = sym.$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=19; i<22; i++){
         		txt[i] = sym.getSymbol("mapKeyMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=22; i<67; i++){
         		txt[i] = sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("mapTxtMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=67; i<81; i++){
         		txt[i] = sym.$("txt"+i).css({"pointer-events":"none"});
         	}
         
         //PB DATE FUNCTIONS
         var todayDate,nextDate,startDate,endDate,leap,febDays,endDay,dd,mm,yy,daysPerMonth;
         function getToday(){
         	var startMonth=4;
         	var startYear=2016;
         	var endMonth=7;
         	var endYear=2016;
         	startDate = new Date(2016,4,3); endDate=new Date(2016,7,5);
         	todayDate = new Date();
         	todayDate=(todayDate<startDate)?startDate:new Date();
         	nextDate = new Date(todayDate.getDate()+1);
         }
         getToday();
         function newDay(){ //creates selcted date
         					todayDate=(todayDate<=endDate)?todayDate:endDate;
         					yy = todayDate.getFullYear();
         					mm = todayDate.getMonth(); mm = (mm<10)?"0"+(mm): (mm)+ "";
         					dd = todayDate.getDate();	dd = (dd<10)?"0" + dd: dd + "";
         					daysPerMonth=["31",febDays,"31","30","31","30","31","31","30","31","30","31"];
         }
         newDay();
         function closestNum (num, arr) { //finds the closest number to num in arr so we can go to the closest date to today
         	var curr = arr[0];
         	var diff = Math.abs(num - curr);
         	for (var i = 0; i < arr.length; i++) {
         		if (num<=arr[i]){
         			var newdiff = Math.abs (num - arr[i]);
         			if (newdiff < diff) {
         				diff = newdiff;
         				curr = arr[i];
         			}
         		}
         	}
         	return curr;
         }
         //END
         
         	var txtArr=[], month=[], monthEvents=[];
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33332.xml",
         		dataType: "xml",
         		success: function(xml) {
         			headerBackgroudColour = $(xml).find('headerBackgroudColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			headlinemob = $(xml).find('headlinemob').text();
         			headlinetxtmob.html(headlinemob);
         			sym.getSymbol("styleHead").$("headerBox").css({"background-color":headerBackgroudColour});
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         			var fontSize= $(xml).find('fontSize').text();
         			var lineHeight= $(xml).find('lineHeight').text();
         			for (var i=0; i<81; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         				txt[i].css({'line-height':lineHeight});
         			}
         			var mapPath = sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("mapTxtMc");
         			mapPath.$("txt35").css({"font-size":"20px"});
         			mapPath.$("txt39").css({"width":"auto", "background-color":"green", "color":"white", "padding":"4px"});
         			mapPath.$("txt39").animate({left:310-mapPath.$("txt39").width()-0}, 0);
         			mapPath.$("txt56").css({"width":"auto", "background-color":"green", "color":"white", "padding":"4px"});
         			mapPath.$("txt57").css({"width":"auto", "background-color":"#da0000", "color":"white", "padding":"4px"});
         			mapPath.$("txt56").css({"width":mapPath.$("txt57").width()+0, "background-color":"green", "color":"white", "padding":"4px"});
         			mapPath.$("txt66").css({"line-height":"20px"});
         			sym.getSymbol("calMc").getSymbol("calBtn").$("txt").append(txtArr[72]);
         			var stringDate = $(xml).find('txt71').text(); // Stage date for stage btn info
                  datestring=stringDate.split(";");
         
         		$(xml).find("month").each(function(){
         			var $month=$(this);
         			var monthname=$month.attr('name');
         			month.push(monthname);
         			monthEvents.push($month);
         		});
         		},
            complete:function(){
         		initSize();
         		getCalendar();
            }
         	}); // END XML
         
         //****************************************************************************************************
         //BUILD CALENDAR
         //****************************************************************************************************
         var pointBtnPath = sym.getSymbol("calMc").getSymbol("pointBtnsMc");
         function getDay(){
         			var monthArr=['J','F','M','A','MAY','JUNE','JULY','AUGUST','S','O','N','D'];//animation labels - DO NOT USE XML, may be translated
         			if (todayDate.getDate()<=dateName[dateName.length-1]){
         				var todaydd=closestNum(todayDate.getDate(),dateName);
         				day=todaydd;
         				var indexNo=dateName.indexOf(day);
         				if (dateName[indexNo]==day){
         						if (todayDate<=startDate){
         							pointBtnPath.$("pointerBtnPrev").fadeOut(0);
         						}else{
         							pointBtnPath.$("pointerBtnPrev").fadeIn(0);
         						}
         						if (todayDate>=endDate){
         							pointBtnPath.$("pointerBtnNext").fadeOut(0);
         						}else{
         							pointBtnPath.$("pointerBtnNext").fadeIn(0);
         						}
         						sym.getSymbol("calMc").$("placeListTxt").css(pointerTxt);
         						sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("startDot").fadeIn(0);
         						sym.getSymbol("calMc").$("placeListTxt").html(placeName[indexNo]);
         						pointBtnPath.$("txtDate").html(month[monthNo]+" "+dateName[indexNo]);
         						sym.getSymbol("scrollMc").getSymbol("scrollableMc").play((monthArr[monthNo]+dateName[indexNo]));
         						$("#mm"+monthNo+"dd"+day).css({'color':'rgb(0,0,0)','background-color':'rgba(255,255,255,1)'});
         						sym.$("mapTxt").html("m" + monthNo + " "+"d" +day);
         						todayDate.setDate(day);
         				}
         			}else{//the next dd is greater than datename.length
         				if(todayDate.getMonth()<endDate.getMonth()){
         					todayDate.setMonth(todayDate.getMonth()+1);
         				}else{
         					todayDate.setMonth(monthNo);
         				}
         				var lastDay=daysPerMonth[todayDate.getMonth()];
         				todayDate.setDate(lastDay);//SET IT TO THE LAST DAY OF THE PREVIOUS MONTH
         				sym.$("mapTxt").html("m" + todayDate.getMonth() + " "+"d" +todayDate.getDate());
         				newDay();
         				getCalendar();
         			}					
         }
         var dateName=[], placeName=[];//arrays to hold the xml data
         function getMonth(){ 
         		sym.getSymbol("calMc").getSymbol("calBtn").$("txt").text(month[monthNo]);
         		dateName.length=0; placeName.length=0; // empty the arrays each time a new month is loaded
         		(monthNo<5)?sym.getSymbol("calMc").$("calMonthBtnPrev").fadeOut(0):sym.getSymbol("calMc").$("calMonthBtnPrev").fadeIn(0);//Fade buttons in/out
         		(monthNo>6)?sym.getSymbol("calMc").$("calMonthBtnNext").fadeOut(0):sym.getSymbol("calMc").$("calMonthBtnNext").fadeIn(0);
         		var $events=monthEvents[monthNo].find('location');
         		$events.each(function(){
         			var $event=$(this);
         			var datenam=$event.find("date").text();
         			dateName.push(parseInt(datenam,10));//so we can find indexOf with a number
         			var placenam=$event.find("name").text();
         			placeName.push(placenam);
         			$('#mm'+(monthNo)+'dd'+datenam).addClass('select');
         			$('#mm'+(monthNo)+'dd'+datenam).on('click', calDate(datenam, monthNo,todayDate.getFullYear()));
         		});
         		$(".select").css({'font-weight':700,'color':'rgb(255,255,255)','background-color':'rgba(0,170,223,0.5)','cursor':'pointer'});//days with an event
         		getDay();
         }
         function getCalendar(){
         	sym.getSymbol("calMc").$("calendar").empty();
         	var yrC=todayDate.getFullYear();
         	var monthC=todayDate.getMonth();
         	monthNo=monthC;
         	var leap;
         if(monthC==1){
         	leap=((parseInt(yrC)%4==0)&&(parseInt(yrC)%100!=0)||(parseInt(yrC)%400==0))?"true":"false";
         	var febDays=(leap=="true")?29:28;
         	}
         	var firstOfMonth=new Date(yrC,monthC,1);
         	var weekdays=firstOfMonth.getDay();
         	var weekdays2=weekdays;
         	numOfDays=daysPerMonth[monthC];
         	var calContent="";
         	var calendarBody="";
         	var counter=1;
         	//build weekly calendar
         	//days in previous and next months, and day of week.
         		var weekContent="";
         		var weekBody="";
         		var counter=1;
         		while (weekdays>0){// leave blank for days of previous month
         			weekContent += "<td class='monthPre'></td>";
         			weekdays--;
         		}
         		while (counter <= numOfDays){
         			if (weekdays2 > 6){ // start new line.
         				weekdays2 = 0;
         				weekContent += "</tr><tr class='weekdays'>";
         			}		
         			weekContent +="<td id='mm"+monthC+"dd"+counter+"' class='monthNow'>"+counter+"</td>";    			
         			weekdays2++;
         			counter++;
         		}
         		weekBody +="<table class='wcalendar' width='100%'><tr class='daysOfWeek'>";
         		for (var i=0;i<7;i++){
         		weekBody += "<td>"+datestring[i]+"</td>";//days of the week
         		}
         		weekBody += "</tr>";
         		weekBody += "<tr class='weekdays'>";
         		weekBody += weekContent;
         		weekBody += "</tr></table>";
         		sym.getSymbol("calMc").$("calendar").append(weekBody);
         //end build
         $(".wcalendar").css({'width':'100%','min-width':'300px','margin':'auto','font-family':'pragmatica-web,arial,sans-serif','font-size':'12px','border-collapse':'collapse','text-align':'center','background-color':'rgba(0,170,223,0.5)'});
         $('.weekdays').css({'height':'30px'});
         $('.daysOfWeek').css({'color':'rgb(255,255,255)','font-weight':700, 'background-color':'rgba(0,110,173,1)'});
         $(".calendar").css({'width':'50px','font-family':'pragmatica-web,arial,sans-serif','font-size':'12px','border-collapse':'collapse','text-align':'center'});
         if(RTL==true){
         	$(".wcalendar, .weekdays, .daysOfWeek").addClass('rtl');
         }else{
         	$(".monthNow").css({'color':'rgb(150,150,150)','background-color':'rgba(255,255,255,0.5)'});
         }
         $(".rtl").css({'transform':'scaleX(-1)','-webkit-transform':'scaleX(-1)','-ms-transform':'scaleX(-1)'});
         $(".cal").css({'height':'16px'});
         sym.getSymbol("calMc").getSymbol("calBtn").$("txt").html(month[monthNo]);
         getMonth();
         }
         
         //********************************CHANGE DAY WITH FORWARD BACK BUTTONS*****************************
         function dayChange(num){
         	if(num>0){//forward
         		todayDate.setDate(todayDate.getDate()+1);
         	}else if(num<0){//back
         		if(dateName.indexOf(todayDate.getDate()-1)==-1){
         			todayDate.setDate(todayDate.getDate()-2);//go back 2 days if nothing at 1 day
         		}else{
         			todayDate.setDate(todayDate.getDate()-1);
         		}
         	}
         	newDay();
         	getCalendar();
         	mapPlay = false;
         	moveMap();
         	openPlaceList()
         	sym.getSymbol("calMc").$("calMonthBtnPrev").fadeOut(0);
         	sym.getSymbol("calMc").$("calMonthBtnNext").fadeOut(0);
         }
         //********************************CHANGE DAY WITH CALENDAR BUTTONS*****************************
         var calDate = function(dC,mC,yrC){ //sets new date
         	return function (e) {
         					//change class of selected event date to highlight with border/bg-color
         					$('.monthNow').removeClass('dayNow');
         					$(".select").css({'color':'rgb(255,255,255)','background-color':'rgba(0,170,223,0.5)'});
         					$("#mm"+mC+"dd"+dC).css({'color':'rgb(0,0,0)','background-color':'rgba(255,255,255,1)'});
         					todayDate = new Date(yrC,mC,dC);
         					newDay();
         					getDay();
         				closeCal();
         				openPlaceList()
         				mapPlay = false;
         				moveMap();
         				e.preventDefault(); e.stopPropagation();
         	};
         };
         //*******************************CHANGE MONTH WITH MONTH FORWARD/BACK BUTTONS ****************
         function changeMonth(m) {
         			e.preventDefault();
         			e.stopPropagation();
         			var lastDay=daysPerMonth[m];
         			var nextday=(m<todayDate.getMonth())?lastDay:1;//SET DAY TO THE FIRST/LAST DAY OF THE PREVIOUS MONTH
         			todayDate=new Date(yy,m,nextday);
         			sym.$("mapTxt").html("m" + todayDate.getMonth() + " "+"d" +todayDate.getDate());	
         			newDay();
         			getCalendar();
         }
         
         //********************************************************************************************************
         // ROTATE
         //********************************************************************************************************
         	$.fn.animateRotate = function(angle, duration, easing, complete) {
             return this.each(function() {
                 var $elem = $(this);
                 $({deg: 0}).animate({deg: angle}, {
                     duration: duration,
                     easing: easing,
                     step: function(now) {
                         $elem.css({
                           '-moz-transform':'rotate('+now+'deg)',
                           '-webkit-transform':'rotate('+now+'deg)',
                           '-o-transform':'rotate('+now+'deg)',
                           '-ms-transform':'rotate('+now+'deg)',
                           'transform':'rotate('+now+'deg)'
                         });
                     },
                     complete: complete || $.noop
                 });
             });
         };
         
         //********************************************************************************************************
         // SCROLL TIMER
         //********************************************************************************************************
         var timer;
         
         function startTimer() {
           timer = setInterval(startReplay, 150);
           sym.getSymbol("scrollMc").$("scrollableMc").stop().animate({top: -240}, 500, 'easeInOutCubic');
         }
         function startReplay() {
          	var stageWidth=sym.$("Stage").width();
         	var pos = sym.getSymbol("scrollMc").getSymbol("scrollableMc").getPosition();
         	var dotPos = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dotMc").position();
         	if(dotPos.left > 310){
         		sym.$("scrollMc").stop().animate({scrollLeft: 300}, 1000);
         	} else if (dotPos.left < 290){
         		sym.$("scrollMc").stop().animate({scrollLeft: 40}, 1000);
         	} else {
         
         	}
         	sym.$("mask").fadeIn(0);
         	if (pos == 0 || pos == 25000) {
         		stopTimer();
         	}
         }
         function stopTimer() {
           clearInterval(timer);
           sym.$("mask").fadeOut(0);
         }
         sym.$("mask").fadeOut(0);
         //********************************************************************************************************
         // CALENDAR BUTTON
         //********************************************************************************************************
         pointBtnPath.$("pointerBtnNext").on('touchstart click', function(e){
         	dayChange(1);
         });
         pointBtnPath.$("pointerBtnPrev").on('touchstart click', function(e){
         	dayChange(-1);
         });
         pointBtnPath.$("pointerBtnPlay").on('touchstart click', function(e){
         	mapPlay=true;
         	playStopMap();
         	closePlaceList();
         });
         pointBtnPath.$("pointerBtnClose").on('touchstart click', function(e){
         	closePlaceList();
         });
         sym.getSymbol("calMc").$("calMonthBtnNext").on('touchstart click', function(e){
         	changeMonth(monthNo+1);
         });
         sym.getSymbol("calMc").$("calMonthBtnPrev").on('touchstart click', function(e){
         	changeMonth(monthNo-1);
         });
         
         sym.getSymbol("calMc").$("calBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (calOpen == false) {
         		openCal();
         		calOpen = true;
         	}else{
         		closeCal();
         	}
         	mapPlay=false;
         	playStopMap();
         });
         
         function openCal(){
         	sym.getSymbol("calMc").getSymbol("calBtn").$("txt").html(month[monthNo]);
         	sym.getSymbol("calMc").$("calendar").stop().animate({top:25}, 200, 'easeOutCubic');
         	sym.getSymbol("calMc").getSymbol("calBtn").$("arrow").fadeOut(0);
         	getMonth();
         }
         function closeCal(){
         	sym.getSymbol("calMc").getSymbol("calBtn").$("txt").html(txtArr[72]);
         	sym.getSymbol("calMc").$("calendar").stop().animate({top:-300}, 200, 'easeInCubic');
         	sym.getSymbol("calMc").$("calMonthBtnPrev").fadeOut(0);
         	sym.getSymbol("calMc").$("calMonthBtnNext").fadeOut(0);
         	sym.getSymbol("calMc").getSymbol("calBtn").$("arrow").fadeIn(0);
         	calOpen = false;
         }
         closeCal();
         
         //********************************************************************************************************
         // OPEN PLACE LIST
         //********************************************************************************************************
         function openPlaceList(){
         	sym.getSymbol("calMc").$("pointBtnsMc").fadeIn(0);
         	sym.getSymbol("calMc").$("placeListTxt").stop().animate({top:20}, 300, 'easeOutCubic');
         }
         //********************************************************************************************************
         // CLOSE PLACE LIST
         //********************************************************************************************************
         function closePlaceList(){
         	sym.getSymbol("calMc").getSymbol("calBtn").$("txt").html(txtArr[72]);
         	sym.getSymbol("calMc").$("pointBtnsMc").fadeOut(0);
         	sym.getSymbol("calMc").$("placeListTxt").stop().animate({top:-500}, 300, 'easeInCubic');
         	sym.getSymbol("scrollMc").$("scrollableMc").stop().animate({top: -240}, 500, 'easeInOutCubic');
         }
         //********************************************************************************************************
         // MOVE MAP ON CLICK
         //********************************************************************************************************
         function moveMap(){
         	pointHeight = sym.getSymbol("calMc").$("placeListTxt").height();
         	var pos = sym.getSymbol("scrollMc").getSymbol("scrollableMc").getPosition();
         	var dotPos = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("dotMc").position();
         	if(dotPos.top < 445){ //414
         		sym.getSymbol("scrollMc").$("scrollableMc").stop().animate({top:-100}, 1000, 'easeInOutCubic');
         	} else {
         		sym.getSymbol("scrollMc").$("scrollableMc").stop().animate({top: -240}, 1000, 'easeInOutCubic');
         	}
         	if(dotPos.left < 300){ //414
         		sym.$("scrollMc").stop().animate({scrollLeft: 40}, 1000, 'easeInOutCubic');
         	} else {
         		sym.$("scrollMc").stop().animate({scrollLeft: 300}, 1000, 'easeInOutCubic');
         	}
         
         }
         //********************************************************************************************************
         // PLAY STOP ROUTE
         //********************************************************************************************************
         function playStopMap(){
         	if (mapPlay == false){
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").stop();
         		stopTimer();
         	} else {
         		startTimer();
             	sym.getSymbol("scrollMc").getSymbol("scrollableMc").play();
         		//sym.$("pointerMc").animate({top:-300}, 200, 'easeOutCubic');
         		closeCal();
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("startDot").fadeOut(0);
         	}
         }
         
         //********************************************************************************************************
         // MAP BUTTON
         //********************************************************************************************************
         sym.$("mapBtn").on('touchstart click', function(e){
         		e.stopPropagation(); e.preventDefault();
         		closeSource();
         		sym.$("calMc").fadeIn(0);
         		speed = 0;
         		closeStandfirst();
         		if (mapClick == 0){
         			sym.$("mapKeyMc").animate({opacity:1}, 200);
         			sym.$("mapBtn").animateRotate(180, 0);
         			sym.$("scrollMc").animate({left:0}, 50);
         			mapPlay = true;
         			playStopMap();
         			mapClick = 1;
         			if(stageWidth==640){
         				sym.$("standBtn").animate({top:0}, 0);
         				sym.$("mapBtn").animate({left:stageWidth-81}, 0);
         			}
         		}else{
         			sym.$("mapKeyMc").animate({opacity:0}, 200);
         			sym.$("mapBtn").animateRotate(0, 0);
         			sym.$("scrollMc").animate({left:680}, 50);
         			mapPlay = false;
         			playStopMap();
         			mapClick = 0;
         			if(stageWidth==640){
         				sym.$("standBtn").animate({top:-40}, 0);
         				sym.$("mapBtn").animate({left:stageWidth-40}, 0);
         				leftStandfirst();
         			}else{
         			}
         			closeCal();
         			sym.$("calMc").fadeOut(0);
         			calOpen = false;
         		}
         		sym.getSymbol("torchMc").getSymbol("logoMc").stop(0);
         		closePlaceList();
         	});
         sym.$("mapKeyMc").animate({opacity:0}, 0);
         sym.$("calMc").fadeOut(0);
         
         //********************************************************************************************************
         // INIT
         //********************************************************************************************************
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	sym.$("standBtn").animate({left:stageWidth-40}, 0);
         	sym.$("mapKeyMc").animate({left:sym.$("scrollMc").width()/2-160}, 0);
         	sym.$("calMc").animate({left:sym.$("scrollMc").width()/2-160}, 0);
         	sym.$("pointerMc").animate({left:sym.$("scrollMc").width()/2-160}, 0);
         
         	if(stageWidth<640){
         		sym.$("standTxt").stop().animate({width:stageWidth-20}, 0);
         		sym.$("standBgMc").stop().animate({width:stageWidth, height:sym.$("standTxt").height()+40}, 0);
         		sym.$("scrollMc").css({"overflow-x":"auto"});
         		sym.$("standBtn").animate({top:0}, 0);
         		sym.$("mapBtn").animate({left:stageWidth-81}, 0);
         		speed = 0;
         		closeStandfirst();
         	}else{
         		if(mapClick == 0){
         			leftStandfirst();
         			sym.$("standBtn").animate({top:-40}, 0);
         			sym.$("mapBtn").animate({left:stageWidth-40}, 0);
         		}else{
         			sym.$("standBtn").animate({top:0}, 0);
         			sym.$("mapBtn").animate({left:stageWidth-81}, 0);
         		}
         		sym.$("scrollMc").css({"overflow-x":"hidden"});
         	}
         
         	if(stageWidth<540){
         		if (mob == false){
         			sym.$("mapKeyMc").animate({top:542}, 0);
         		}
         	}else{
         		sym.$("mapKeyMc").animate({top:557}, 0);
         	}
         
         	if(stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").html(headlinemob);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").html(headline);
         	}
         	setStyleUpdate();
         	closeSource();
         	setStyle();
         }
         
         //********************************************************************************************************
         // STANDFIRST BUTTON
         //********************************************************************************************************
         sym.$("standBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	speed = 220;
         	closeSource();
         	if (standClick == 0) {
         		openStandfirst();
         	}else{
         		closeStandfirst();
         	}
         });
         function closeStandfirst(){
         	stageWidth=sym.$("Stage").width();
         	sym.getSymbol("standBtn").$("arrow").animateRotate(270, 0);
         	sym.$("standTxt").stop().animate({width:stageWidth, top:0-(sym.$("standTxt").height()+40)}, speed);
         	sym.$("standBgMc").stop().animate({width:stageWidth, top:0 - sym.$("standTxt").height(), height:sym.$("standTxt").height()}, speed);
         	standClick = 0;
         }
         function openStandfirst(){
         	stageWidth=sym.$("Stage").width();
         	sym.$("standTxt").css({"height":"auto",'-webkit-text-size-adjust':'100%'});
         	sym.$("standTxt").stop().animate({top:40, width:stageWidth-10}, speed);
         	sym.$("standBgMc").stop().animate({top:40, width:stageWidth, height:sym.$("standTxt").height()+20}, speed);
         	sym.getSymbol("standBtn").$("arrow").animateRotate(90, 0);
         	standClick = 1;
         }
         function leftStandfirst(){
         	sym.getSymbol("standBtn").$("arrow").animateRotate(270, 0);
         	sym.$("standTxt").css({'top':'40px', 'width':'204px', 'height':'534px'});
         	sym.$("standBgMc").css({'top':'40px', 'width':'220px', 'height':'542px'});
         	standClick = 0;
         }
         
         //********************************************************************************************************
         // ARROW BUTTONS
         //********************************************************************************************************
         sym.getSymbol("torchMc").$("arrowBtnUp").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	closeSource();
         	sym.getSymbol("torchMc").getSymbol("logoMc").stop(0);
         	sym.getSymbol("torchMc").play();
         	sym.getSymbol("torchMc").$("arrowBtnUp").fadeOut(0);
         	sym.getSymbol("torchMc").$("arrowBtnDown").fadeIn(0);
         	sym.getSymbol("torchMc").getSymbol("arrowBtnDown").$("btnBg").css(overBtn);
         	if(stageWidth<640){
         		closeStandfirst()
         	}
         	});
         sym.getSymbol("torchMc").$("arrowBtnDown").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if(stageWidth<640){
         		closeStandfirst();
         	}
         	sym.getSymbol("torchMc").getSymbol("logoMc").stop(0);
         	sym.getSymbol("torchMc").playReverse();
         	sym.getSymbol("torchMc").$("arrowBtnUp").fadeIn(0);
         	sym.getSymbol("torchMc").$("arrowBtnDown").fadeOut(0);
         	sym.getSymbol("torchMc").getSymbol("arrowBtnUp").$("btnBg").css(overBtn);
         	});
         sym.getSymbol("torchMc").getSymbol("arrowBtnUp").$("btnBg").css(overBtn);
         sym.getSymbol("torchMc").$("arrowBtnDown").fadeOut(0);
         
         //********************************************************************************************************
         // SCROLLING
         //********************************************************************************************************
         var x,left,down;
         sym.$("scrollMc").on('mousedown', function(e){
         	down=true;
         	x=e.pageX;
         	left=sym.$("scrollMc").scrollLeft();
         	e.stopPropagation();
         });
         
         sym.$("scrollMc").on('mousemove', function(e){
         	if(down==true){
         		var newX=e.pageX;
         		sym.$("scrollMc").scrollLeft(left-newX+x);    
         	}
         });
         sym.$("scrollMc").on('mouseup', function(e){
         	down=false;
         	e.preventDefault();
         });
         
         //********************************************************************************************************
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //********************************************************************************************************
         // SET STYLE SETTING 
         function setStyle() {
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "height":"auto", "width":"auto", "padding":"6px", "padding-top":"6px"});
         	sym.getSymbol("styleHead").$("headlineTxt").stop().animate({width:stageWidth-0}, 0);
         }
         function setStyleUpdate(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         	sym.$("scrollMc").css({"overflow-y":"hidden"});
         	setTimer();
         }
         setStyleUpdate();
         
         //********************************************************************************************************
         // COUNTDOWN TIMER
         //********************************************************************************************************
         function setTimer(){
         	today = new Date();
         	todayDay = today.getTime();
         	target1 = new Date("3 May, 2016");
         	targetDay1 = target1.getTime();
         	daysLeft1 = Math.floor(((targetDay1 - todayDay) / (60*60*24)) / 1000);
         	target2 = new Date("5 August, 2016");
         	targetDay2 = target2.getTime();
         	daysLeft2 = Math.floor(((targetDay2 - todayDay) / (60*60*24)) / 1000);
         	var countdown=(daysLeft1 > 0)?txtArr[13] + " <b>"+ daysLeft1 + "</b>":(daysLeft2 >0)? txtArr[14] + " <b>"+ daysLeft2 + "</b>": "<b>"+txtArr[18]+ "</b>";
         	sym.$("standTxt").html(stand+ "<p>" + countdown + "</p>");
         }
         
         
         //********************************************************************************************************
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         function closeSource(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         }
         
         //********************************************************************************************************
         $(window).on('resize',initSize);
         //********************************************************************************************************
         //-------------------------------------------------- END -------------------------------------------------
         //********************************************************************************************************

      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'torchMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 861, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("torchMc");
   //Edge symbol end:'torchMc'

   //=========================================================
   
   //Edge symbol: 'arrowBtn'
   (function(symbolName) {   
   
   })("arrowBtn");
   //Edge symbol end:'arrowBtn'

   //=========================================================
   
   //Edge symbol: 'fireMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         // insert code here
         sym.play(0);

      });
      //Edge binding end

   })("fireMc");
   //Edge symbol end:'fireMc'

   //=========================================================
   
   //Edge symbol: 'standBgMc'
   (function(symbolName) {   
   
   })("standBgMc");
   //Edge symbol end:'standBgMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'mapKeyMc'
   (function(symbolName) {   
   
   })("mapKeyMc");
   //Edge symbol end:'mapKeyMc'

   //=========================================================
   
   //Edge symbol: 'arrow'
   (function(symbolName) {   
   
   })("arrow");
   //Edge symbol end:'arrow'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'LogoMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2000, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("LogoMc");
   //Edge symbol end:'LogoMc'

   //=========================================================
   
   //Edge symbol: 'calMc'
   (function(symbolName) {   
   
   })("calMc");
   //Edge symbol end:'calMc'

   //=========================================================
   
   //Edge symbol: 'calBtn'
   (function(symbolName) {   
   
   })("calBtn");
   //Edge symbol end:'calBtn'

   //=========================================================
   
   //Edge symbol: 'calDateBtn'
   (function(symbolName) {   
   
   })("calDateBtn");
   //Edge symbol end:'calDateBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtn0_1'
   (function(symbolName) {   
   
      })("calMonthBtn");
   //Edge symbol end:'calMonthBtn'

   //=========================================================
   
   //Edge symbol: 'dotMc'
   (function(symbolName) {   
   
   })("dotMc");
   //Edge symbol end:'dotMc'

   //=========================================================
   
   //Edge symbol: 'pointerMc'
   (function(symbolName) {   
   
   })("pointerMc");
   //Edge symbol end:'pointerMc'

   //=========================================================
   
   //Edge symbol: 'pointerBtn'
   (function(symbolName) {   
   
   })("pointerBtn");
   //Edge symbol end:'pointerBtn'

   //=========================================================
   
   //Edge symbol: 'pointerBtnClose'
   (function(symbolName) {   
   
   })("pointerBtnClose");
   //Edge symbol end:'pointerBtnClose'

   //=========================================================
   
   //Edge symbol: 'pointerBtns'
   (function(symbolName) {   
   
   })("pointerBtns");
   //Edge symbol end:'pointerBtns'

   //=========================================================
   
   //Edge symbol: 'mapTxtMc'
   (function(symbolName) {   
   
   })("mapTxtMc");
   //Edge symbol end:'mapTxtMc'

   //=========================================================
   
   //Edge symbol: 'pointerBtn_1'
   (function(symbolName) {   
   
      })("pointerBtnPlay");
   //Edge symbol end:'pointerBtnPlay'

   //=========================================================
   
   //Edge symbol: 'calDateBtn_1'
   (function(symbolName) {   
   
      })("calSpace");
   //Edge symbol end:'calSpace'

   //=========================================================
   
   //Edge symbol: 'calendar'
   (function(symbolName) {   
   
   })("calendar");
   //Edge symbol end:'calendar'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 55, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 250, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 439, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 600, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 857, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1264, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1573, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1899, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2237, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2399, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2556, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2665, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2931, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3241, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3328, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3634, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3836, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4108, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4355, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4561, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4843, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5095, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5440, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5643, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5959, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6175, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6508, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6638, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6727, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6750, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6899, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7128, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7382, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7529, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7690, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 7950, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8152, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8630, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 9315, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10118, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 10468, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11000, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11443, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 11857, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12304, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13132, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 13839, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 14101, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15237, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 15766, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 16876, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 16923, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 17520, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 17840, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 18260, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 18534, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 18815, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 19009, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 19338, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 19667, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 20038, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 20474, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 20951, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 21178, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 21369, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 21622, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 21766, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 21812, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 22054, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 22273, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 22404, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 22690, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 22946, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 23233, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 23529, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 23725, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 23938, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 23953, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 23963, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 23971, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 23979, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 24010, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 24178, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 24224, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 24485, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 24539, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 24777, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 24885, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 24938, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 24963, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 24974, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 25000, function(sym, e) {
         if (mapPlay == false) {
         	sym.stop();
         }

      });
      //Edge binding end

   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'mapTxtMc_1'
   (function(symbolName) {   
   
   })("mapTxtMc_1");
   //Edge symbol end:'mapTxtMc_1'

   //=========================================================
   
   //Edge symbol: 'pointBtnsMc'
   (function(symbolName) {   
   
   })("pointBtnsMc");
   //Edge symbol end:'pointBtnsMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33332");