/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('touchstart click');
         	var clicked = 1;
         	var btnNo = 0;
         	var mobile = 0;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	//var winner;
         	//var winnertxt = sym.getSymbol("winnersMc").$("winner").css("pointer-events","none");
         	//var course;
         	//var coursetxt = sym.getSymbol("winnersMc").$("course0").css("pointer-events","none");
         	
         	var whiteTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         	
         	for (var a=0; a<18; a++){
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("roundBtnsMc").getSymbol("roundBtn"+a).$("txt").html(a+1);
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("roundBtnsMc").getSymbol("roundBtn"+a).$("txt").css({"pointer-events":"none"});
         		sym.getSymbol("holesMc").getSymbol("allHolesMc").$("holeMc"+a).animate ({left:240*a});
         	}
         	
         	var outBtn  = {"background-color":"#123f6d"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         	
         	var txt=[];
         	txt[0] = sym.$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.getSymbol("cardMc").$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.getSymbol("cardMc").$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("cardMc").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("cardMc").$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.getSymbol("cardMc").$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.getSymbol("cardMc").$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.getSymbol("cardMc").$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.getSymbol("cardMc").$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.getSymbol("cardMc").$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.getSymbol("winnersMc").$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.getSymbol("winnersMc").$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.getSymbol("winnersMc").$("txt13").css({"pointer-events":"none"});
         	txt[14] = sym.$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.getSymbol("cardMc").$("txt15").css({"pointer-events":"none"});
         	
         	for (var h=16; h<32; h++){
         		txt[h] = sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt"+h).css({"pointer-events":"none"});
         	}
         	
         	var parstring;
         	var yardsstring;
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33312.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css({"background-color":custonCol});
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<32; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         			stringPar = $(xml).find('txt0').text(); // Stage date for stage btn info
                  parstring=stringPar.split("<br>");
                  stringYards = $(xml).find('txt1').text(); // Stage date for stage btn info
                  yardsstring=stringYards.split("<br>");
         
                  for (var h=0; h<18; h++){
         				sym.getSymbol("cardMc").getSymbol("btn"+h).$("txt01").html(h+1).css({"pointer-events":"none"});
         				sym.getSymbol("cardMc").getSymbol("btn"+h).$("txt02").append(parstring[h]).css({"pointer-events":"none"});
         				sym.getSymbol("cardMc").getSymbol("btn"+h).$("txt03").append(yardsstring[h]).css({"pointer-events":"none"});
         			}
         			sym.getSymbol("holesMc").$("txt22").css({"pointer-events":"none", "font-size":"16px"});
         			sym.getSymbol("holesMc").$("txt22").empty();
         			sym.getSymbol("holesMc").$("txt22").append(txtArr[3] + " " + parstring[clickedAux] + "<br>" + txtArr[4] + " " + yardsstring[clickedAux]);
         			sym.getSymbol("cardMc").$("txt15").css({"font-size":"16px"});
         			sym.getSymbol("winnersMc").$("txt11").css({"font-size":"16px"});
         
         		},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         
         sym.$("cardMc").fadeOut(0);
         sym.$("winnersMc").fadeOut(0);
         sym.getSymbol("slideBtns").getSymbol("menuBtn1").$("bbg").css(overBtn);
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	//sym.$("scrollMc").stop().animate({width:stageWidth}, 0);
         	//sym.$("scrollMc").scrollLeft(stageWidth);
         	sym.getSymbol("scrollMc").$("scrollableMc").stop().animate({width:stageWidth}, 0);
         	sym.$("slideBtns").stop().animate({left:stageWidth-280}, 0, 'easeInCubic');
         	//sym.getSymbol("scrollMc").$("scrollableMc").scrollLeft(stageWidth+160);
         	sym.getSymbol("scrollMc").$("scrollableMc").css({'overflow-y':'hidden'});
         	//sym.getSymbol("scrollMc").$("scrollableMc").css({'overflow-x':'hidden'});
         
         	setStyle();
         	if(stageWidth<800){
         		sym.getSymbol("slideBtns").getSymbol("menuBtn0").$("bbg").css(outBtn);
         		sym.getSymbol("slideBtns").getSymbol("menuBtn1").$("bbg").css(outBtn);
         		sym.getSymbol("slideBtns").getSymbol("menuBtn2").$("bbg").css(outBtn);
         		sym.$("slideBtns").stop().animate({left:stageWidth-40}, 0);
         		sym.$("slideBtns").fadeIn(0);
         		sym.$("holesMc").stop().animate({left:stageWidth+20}, 0, 'easeInCubic');
         		sym.$("cardMc").stop().animate({left:stageWidth+20}, 0, 'easeInCubic');
         		sym.$("winnersMc").stop().animate({left:stageWidth+20}, 0, 'easeInCubic');
         		sym.getSymbol("slideBtns").$("slideBackBtn").fadeOut(0);
         		sym.getSymbol("slideBtns").$("slideBackBtn").stop().animate({left:0}, 0);
         		mobile = 0;
         	}else{
         		sym.$("holesMc").stop().animate({left:stageWidth-240}, 0, 'easeInCubic');
         		sym.$("cardMc").stop().animate({left:stageWidth-240}, 0, 'easeInCubic');
         		sym.$("winnersMc").stop().animate({left:stageWidth-240}, 0, 'easeInCubic');
         		sym.getSymbol("slideBtns").$("slideBackBtn").fadeOut(0);
         		sym.getSymbol("slideBtns").$("slideBackBtn").stop().animate({left:-40}, 0);
         		mobile = 1;
         		sym.getSymbol("slideBtns").getSymbol("menuBtn" + clicked).$("bbg").css(overBtn);
         	}
         	if(stageWidth<640){
         	sym.getSymbol("scrollMc").$("scrollableMc").css('cursor', 'ew-resize');
         
         	}else{
         	sym.getSymbol("scrollMc").$("scrollableMc").css('cursor', 'default');
         	}
         	if (stageWidth<480){
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt16").stop().animate({width:300}, 0);
         	}else{
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").$("txt16").stop().animate({width:420}, 0);
         	}
         	setStyleUpdate();
         }
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // MENU BUTTONS
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<3; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("slideBtns").getSymbol("menuBtn" + h).$("bbg").css(outBtn);
         	}
         	var stageWidth=sym.$("Stage").width();
         	sym.$("slideBtns").stop().animate({left:stageWidth-280}, 200, 'easeInCubic');
         	sym.$("holesMc").stop().animate({left:stageWidth-240}, 200, 'easeInCubic');
         	sym.$("cardMc").stop().animate({left:stageWidth-240}, 200, 'easeInCubic');
         	sym.$("winnersMc").stop().animate({left:stageWidth-240}, 200, 'easeInCubic');
         	sym.getSymbol("slideBtns").$("slideBackBtn").fadeOut(0);
         }
         //resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("slideBtns").getSymbol("menuBtn" + menuNo).$("bbg").css(overBtn);
         		if (menuNo == 0){
         			sym.$("cardMc").fadeIn(100);
         			sym.$("winnersMc").fadeOut(100);
         			sym.getSymbol("slideBtns").$("slideBackBtn").stop().animate ({top:0}, 0);
         		}
         		if (menuNo == 1){
         			sym.$("cardMc").fadeOut(100);
         			sym.$("winnersMc").fadeOut(100);
         			sym.getSymbol("slideBtns").$("slideBackBtn").stop().animate ({top:40}, 0);
         		}
         		if (menuNo == 2){
         			sym.$("cardMc").fadeOut(100);
         			sym.$("winnersMc").fadeIn(100);
         			sym.getSymbol("slideBtns").$("slideBackBtn").stop().animate ({top:80}, 0);
         		}
         		sym.getSymbol("slideBtns").$("slideBackBtn").fadeIn(0);
         	};
         };
         /*
         // MENU OVER
         var menuBtnOver = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[menuNo]);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OUT
         var menuBtnOut = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[clicked]);
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(outBtn);
         		if (clicked == menuNo){
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         */
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("slideBtns").$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         	//sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseover',menuBtnOver(b));
         	//sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseout',menuBtnOut(b));
         	sym.getSymbol("slideBtns").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         	sym.getSymbol("slideBtns").getSymbol("menuBtn0").$("bg").css(overBtn);
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SLIDE BUTTON
         sym.getSymbol("slideBtns").$("slideBackBtn").on(clickEventType, function(e){
         	e.stopPropagation(); e.preventDefault();
         	var stageWidth=sym.$("Stage").width();
         	sym.$("slideBtns").stop().animate({left:stageWidth-40}, 200, 'easeInCubic');
         	sym.$("holesMc").stop().animate({left:stageWidth+20}, 200, 'easeInCubic');
         	sym.$("cardMc").stop().animate({left:stageWidth+20}, 200, 'easeInCubic');
         	sym.$("winnersMc").stop().animate({left:stageWidth+20}, 200, 'easeInCubic');
         	sym.getSymbol("slideBtns").$("slideBackBtn").fadeOut(0);
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("slideBtns").getSymbol("menuBtn" + h).$("bbg").css(outBtn);
         	}
         });
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // NAV CLICK FUNCTION
         function navClick(){
         	sym.getSymbol("holesMc").$("allHolesMc").stop().animate ({left:-240*clickedAux}, 500, 'easeOutCubic');
         	sym.getSymbol("holesMc").$("holeNo").html(clickedAux + 1);
         	sym.getSymbol("holesMc").$("txt22").empty();
         	sym.getSymbol("holesMc").$("txt22").append(txtArr[3] + " " + parstring[clickedAux] + "<br>" + txtArr[4] + " " + yardsstring[clickedAux]);
         	sym.getSymbol("holesMc").$("holeNo").empty();
         	sym.getSymbol("holesMc").$("holeNo").append(clickedAux+1);
         
         	if (clickedAux <=0 ){
         		sym.getSymbol("holesMc").$("navBackBtn").fadeOut(0);
         	}else{
         		sym.getSymbol("holesMc").$("navBackBtn").fadeIn(0);
         	}
         	if (clickedAux >= 17){
         		sym.getSymbol("holesMc").$("navNextBtn").fadeOut(0);
         	}else{
         		sym.getSymbol("holesMc").$("navNextBtn").fadeIn(0);
         	}
         	resetAux();
         	resetDot();
         	sym.getSymbol("cardMc").getSymbol("btn" + clickedAux).$("btnBg").fadeIn(0);
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("roundBtnsMc").getSymbol("roundBtn" + clickedAux).$("btnBg").css({"background-color":"#da0000"});
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("roundBtnsMc").getSymbol("roundBtn" + clickedAux).$("txt").css({"color":"white"});
         	sym.getSymbol("cardMc").getSymbol("btn"+clickedAux).$("txt01").css({"color":"white", "font-weight":"medium"});
         	sym.getSymbol("cardMc").getSymbol("btn"+clickedAux).$("txt02").css({"color":"white", "font-weight":"medium"});
         	sym.getSymbol("cardMc").getSymbol("btn"+clickedAux).$("txt03").css({"color":"white", "font-weight":"medium"});
         }
         sym.getSymbol("holesMc").$("navBackBtn").fadeOut(0);
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // CARD BUTTONS --------------------------------------------	
         var clickedAux = 0;
         var auxNo = 0;
         
         auxArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<18; a++){
         	auxArray.push(a);
         }
         
         function resetAux(){
         	for (var a=0; a<auxArray.length; a++){
         		sym.getSymbol("cardMc").getSymbol("btn" + a).$("btnBg").fadeOut(0);
         		sym.getSymbol("cardMc").getSymbol("btn" + a).$("txt01").css({"color":"black", "font-weight":"normal"});
         		sym.getSymbol("cardMc").getSymbol("btn" + a).$("txt02").css({"color":"black", "font-weight":"normal"});
         		sym.getSymbol("cardMc").getSymbol("btn" + a).$("txt03").css({"color":"black", "font-weight":"normal"});
         	}
         }
         resetAux();
         
         // AUX CLICK
         var auxBtnClick = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		clickedAux = auxNo;
         		navClick();
         	};
         };
         /*
         // AUX OVER
         var auxBtnOver = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("btnBg").fadeIn(0);
         		sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("txt01").css({"color":"white", "font-weight":"medium"});
         		sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("txt02").css({"color":"white", "font-weight":"medium"});
         		sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("txt03").css({"color":"white", "font-weight":"medium"});
         	};
         };
         // AUX OUT
         var auxBtnOut = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("btnBg").fadeOut(0);
         		sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("txt01").css({"color":"black", "font-weight":"normal"});
         		sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("txt02").css({"color":"black", "font-weight":"normal"});
         		sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("txt03").css({"color":"black", "font-weight":"normal"});
         		if (clickedAux == auxNo){
         			sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("btnBg").fadeIn(0);
         			sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("txt01").css({"color":"white", "font-weight":"medium"});
         			sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("txt02").css({"color":"white", "font-weight":"medium"});
         			sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("txt03").css({"color":"white", "font-weight":"medium"});
         		}
         	};
         };
         */
         for (var b=0;b<auxArray.length;b++){
         	sym.getSymbol("cardMc").$("btn"+b).on('touchstart click',auxBtnClick(b));
         	//sym.getSymbol("cardMc").$("btn"+b).on('mouseover',auxBtnOver(b));
         	//sym.getSymbol("cardMc").$("btn"+b).on('mouseout',auxBtnOut(b));
         	sym.getSymbol("cardMc").$("btn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("cardMc").getSymbol("btn0").$("btnBg").fadeIn(0);
         sym.getSymbol("cardMc").getSymbol("btn0").$("txt01").css({"color":"white", "font-weight":"medium"});
         sym.getSymbol("cardMc").getSymbol("btn0").$("txt02").css({"color":"white", "font-weight":"medium"});
         sym.getSymbol("cardMc").getSymbol("btn0").$("txt03").css({"color":"white", "font-weight":"medium"});
         
         //sym.$("navBtnBack").fadeOut(0);
         //sym.getSymbol("navBtnNext").$("bg").css({"background-color":"#da0000"});
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // DOT BUTTONS --------------------------------------------	
         var dotNo = 0;
         var clickedAux = 0;
         var clickedDot = 0;
         dotArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<18; a++){
         	dotArray.push(a);
         }
         
         function resetDot(){
         	for (var a=0; a<dotArray.length; a++){
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("roundBtnsMc").getSymbol("roundBtn" + a).$("btnBg").css({"background-color":"white"});
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("roundBtnsMc").getSymbol("roundBtn" + a).$("txt").css({"color":"black"});
         	}
         }
         resetDot();
         
         // DOT CLICK
         var dotBtnClick = function(dotNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		clickedAux = dotNo;
         		clickedDot = clickedAux;
         		navClick();
         		if (mobile == 0){
         			var stageWidth=sym.$("Stage").width();
         			sym.$("slideBtns").stop().animate({left:stageWidth-280}, 200, 'easeInCubic');
         			sym.$("holesMc").stop().animate({left:stageWidth-240}, 200, 'easeInCubic');
         			sym.$("cardMc").stop().animate({left:stageWidth-240}, 200, 'easeInCubic');
         			sym.$("winnersMc").stop().animate({left:stageWidth-240}, 200, 'easeInCubic');
         			sym.getSymbol("slideBtns").$("slideBackBtn").fadeIn(0);
         			sym.$("cardMc").fadeOut(100);
         			sym.$("winnersMc").fadeOut(100);
         			sym.getSymbol("slideBtns").$("slideBackBtn").stop().animate ({top:40}, 0);
         			sym.getSymbol("slideBtns").getSymbol("menuBtn0").$("bbg").css(outBtn);
         			sym.getSymbol("slideBtns").getSymbol("menuBtn1").$("bbg").css(overBtn);
         			sym.getSymbol("slideBtns").getSymbol("menuBtn2").$("bbg").css(outBtn);
         			clicked=1;
         		}
         	};
         };
         /*
         // DOT OVER
         var dotBtnOver = function(dotNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("roundBtnsMc").getSymbol("roundBtn" + dotNo).$("btnBg").css({"background-color":"#da0000"});
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("roundBtnsMc").getSymbol("roundBtn" + dotNo).$("txt").css({"color":"white"});
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // DOT OUT
         var dotBtnOut = function(dotNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("roundBtnsMc").getSymbol("roundBtn" + dotNo).$("btnBg").css({"background-color":"white"});
         		sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("roundBtnsMc").getSymbol("roundBtn" + dotNo).$("txt").css({"color":"black"});
         		if (clickedDot == dotNo){
         			sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("roundBtnsMc").getSymbol("roundBtn" + dotNo).$("btnBg").css({"background-color":"#da0000"});
         			sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("roundBtnsMc").getSymbol("roundBtn" + dotNo).$("txt").css({"color":"white"});
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         */
         for (var b=0;b<dotArray.length;b++){
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("roundBtnsMc").$("roundBtn"+b).on('touchstart click',dotBtnClick(b));
         	//sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("roundBtnsMc").$("roundBtn"+b).on('mouseover',dotBtnOver(b));
         	//sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("roundBtnsMc").$("roundBtn"+b).on('mouseout',dotBtnOut(b));
         	sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("roundBtnsMc").$("roundBtn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("roundBtnsMc").getSymbol("roundBtn0").$("btnBg").css({"background-color":"#da0000"});
         sym.getSymbol("scrollMc").getSymbol("scrollableMc").getSymbol("roundBtnsMc").getSymbol("roundBtn0").$("txt").css({"color":"white"});
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // NAVIGATION BUTTONS
         sym.getSymbol("holesMc").$("navNextBtn").on(clickEventType, function(e){
         	e.stopPropagation(); e.preventDefault();
         	clickedAux++;
         	navClick();
         	});
         /*
         	sym.getSymbol("holesMc").$("navBtnNext").mouseover(function(){
         	sym.getSymbol("navBtnNext").$("bg").css({"background-color":"black"});
         	});
         sym.getSymbol("holesMc").$("navBtnNext").mouseout(function(){
         	sym.getSymbol("navBtnNext").$("bg").css({"background-color":"#da0000"});
         	});
         */
         sym.getSymbol("holesMc").$("navBackBtn").on(clickEventType, function(e){
         	e.stopPropagation(); e.preventDefault();
         	clickedAux--;
         	navClick();
         	});
         /*
         sym.getSymbol("holesMc").$("navBtnBack").mouseover(function(){
         	sym.getSymbol("navBtnBack").$("bg").css({"background-color":"black"});
         	});
         sym.getSymbol("holesMc").$("navBtnBack").mouseout(function(){
         	sym.getSymbol("navBtnBack").$("bg").css({"background-color":"#da0000"});
         	});
         */
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // MOUSE SCROLL SYMBOL
         var x,left,down;
         sym.getSymbol("scrollMc").$("scrollableMc").mousedown(function(e){
             e.stopPropagation(); e.preventDefault();
             down=true;
             x=e.pageX;
             left=$(this).scrollLeft();
         });
         
         sym.getSymbol("scrollMc").$("scrollableMc").mousemove(function(e){
         	e.stopPropagation(); e.preventDefault();
             if(down){
                 var newX=e.pageX;
                 sym.getSymbol("scrollMc").$("scrollableMc").scrollLeft(left-newX+x);    
             }
         });
         sym.getSymbol("scrollMc").$("scrollableMc").mouseup(function(e){down=false;});
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // WINNERS BUTTONS --------------------------------------------
         
         	// ADD NUMBERS
         	for (var b=0; b<10; b++){
         		sym.getSymbol("winnersMc").getSymbol("winnersBtn"+b).$("txt").html(b+2005)
         	}
                  winnersBtnArray = []; //the array that will hold references to the buttons.
         
                  for (var w = 0; w < 10; w++){
                  	 var winnersBtnSymbols = sym.getSymbol("winnersMc").getSymbol("winnersBtn" +w); // Create an instance element of a symbol as a child of the given parent element
                  	 winnersBtnSymbols.setVariable("winnersBtnId", w); //set the value of a Symbol variable
                  	 winnersBtnArray.push(winnersBtnSymbols); //push it into the array
                  	 sym.getSymbol("winnersMc").$("winnersBtn"+w).css({'cursor':'pointer'});
                  }
         
                  $.each(winnersBtnArray, function( count, winnersBtnInTheArray ){ //a 'for each' loop through the newly populated array
                  	 var winnersBtnItem = $(winnersBtnInTheArray); //create jQuery reference to the item
                  	 var winnersBtnElement = winnersBtnInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
                  	 winnersBtnElement.bind ("click touchstart", {winnersBtnId:count}, winnersBtnClick);
                  	 winnersBtnElement.bind ("mouseover", {winnersBtnId:count}, winnersBtnShow);
                  	 winnersBtnElement.bind ("mouseout", {winnersBtnId:count}, winnersBtnHide);
         
                  	})
         
         	function resetwinnersBtn(){
         		for (var k=0; k<winnersBtnArray.length; k++){
               	winnersBtnArray[k].$("btnClick").fadeOut(0);
         			winnersBtnArray[k].$("btnOver").fadeOut(0);
         			winnersBtnArray[k].$("txt").css({"color":"black"});
         		}
         	}
         	resetwinnersBtn();
         
         function winnersBtnClick (e){
         	sym.getSymbol("winnersMc").$("table").empty()
         		resetwinnersBtn(); //set them all back to normal state
         		var winnersBtn_id = (e.data.winnersBtnId); //get the id of the clicked item
         		sym.getSymbol("winnersMc").getSymbol("winnersBtn" + winnersBtn_id).$("btnClick").fadeIn(0);
         		sym.getSymbol("winnersMc").getSymbol("winnersBtn" + winnersBtn_id).$("txt").css({"color":"white"});
         		//sym.getSymbol("winnersMc").$("winPic").attr("src", "images/w" + (winnersBtn_id + 2005) + ".jpg");
         		getYear(2005 + winnersBtn_id);
         		//Removed all the ajax and buildtable functions
         }
         function winnersBtnShow (e){
               var winnersBtn_id = (e.data.winnersBtnId); //get the id of the over button
         		sym.getSymbol("winnersMc").getSymbol("winnersBtn" + winnersBtn_id).$("btnOver").fadeIn(0);
         }
         function winnersBtnHide (e){
               var winnersBtn_id = (e.data.winnersBtnId); //get the id of the out button
         		sym.getSymbol("winnersMc").getSymbol("winnersBtn" + winnersBtn_id).$("btnOver").fadeOut(0);
         }
         
         sym.getSymbol("winnersMc").getSymbol("winnersBtn9").$("btnClick").fadeIn(0);
         sym.getSymbol("winnersMc").getSymbol("winnersBtn9").$("txt").css({"color":"white"});
         
         function getYear(year){
         		$.ajax({	
         		type: "GET",
         		url: year + "_results.xml",
         		dataType: "xml",
         		success: function(xml) {
         		//winner = $(xml).find('winner').text();
         		//winnertxt.html(winner);
         		//course = $(xml).find('course').text();
         		//coursetxt.html(course);
         
         		// Build an HTML string
         		var htmlOutput = '';
         	 	htmlOutput += '<table width="100%" border="0" cellpadding="3" cellspacing="0">';
         		var playerName;
         		var playerScore;
         		//var playerPrize;
         		// Run the function for each student tag in the XML file
         		$('Ranked',xml).each(function(i) {
         			playerName = $(this).find("person").text();
         			playerScore = $(this).find("score").text();
         			//playerPrize = $(this).find("prize").text();
         			// Build row HTML data and store in string
         			var playerdata = winnersTable(playerName,playerScore/*,playerPrize*/);
         			htmlOutput = htmlOutput + playerdata;
         		});
         		htmlOutput += '</table>';
         		sym.getSymbol("winnersMc").$("table").append(htmlOutput);
         		sym.getSymbol("winnersMc").$("table").css({'overflow-x':'hidden'});
         		sym.getSymbol("winnersMc").$("table tr:odd").css({"text-align":"left", "background-color":"#E9E9EA","color":"#000000", "font":"13px Pragmatica-web, sans-serif"});
         		sym.getSymbol("winnersMc").$("table tr:even").css({"text-align":"left", "background-color":"#F8F8F9","color":"#000000", "font":"13px Pragmatica-web, sans-serif"});
         		sym.getSymbol("winnersMc").$("table tr:first-child").css({"text-align":"left", "font-weight":"normal", "background-color":"#e60000","color":"#ffffff", "font":"13px, Pragmatica-web, sans-serif"});
         	}
         });
         
          function winnersTable(playerName,playerScore,playerPrize){
         	// Build HTML string and return
         	output = '';
         	output += '<tr>';
         	output += '<td style="width:45%;font-weight: normal;">'+ playerName +'</td>';
         	output += '<td style="width:55%;">'+ playerScore +'</td>';
         	//output += '<td style="width:20%;font-weight: bold;">'+ playerPrize +'</td>';
         	output += '</tr>';
         	return output;
         	}
         }
         getYear(2014);
         //--------------------------------------------------------------------------------------------------------
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SET STYLE SETTING 
         function setStyle() {
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "height":"auto", "width":"auto", "padding":"6px", "padding-top":"6px"});
         	sym.getSymbol("styleHead").$("standTxt").animate({top:0 + sym.getSymbol("styleHead").$("headlineTxt").height()+8}, 0);
         	sym.getSymbol("styleHead").$("headlineTxt").stop().animate({width:stageWidth-0}, 0);
         	sym.getSymbol("styleBase").$("creditTxt").animate({left:stageWidth-0}, 0);
         }
         function setStyleUpdate(){
         	var stageWidth=sym.$("Stage").width();
         	for (var b=0;b<3; b++){
         	}
         	sym.getSymbol("styleHead").$("standTxt").animate({top:0 + sym.getSymbol("styleHead").$("headlineTxt").height()+12}, 0);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyleUpdate();
         //--------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //--------------------------------------------------------------------------------------------------------
         $(window).on('resize',initSize);
         initSize();
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------- END -------------------------------------------------
         //--------------------------------------------------------------------------------------------------------

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'Base'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'roundBtnsMc'
   (function(symbolName) {   
   
   })("roundBtnsMc");
   //Edge symbol end:'roundBtnsMc'

   //=========================================================
   
   //Edge symbol: 'roundBtn'
   (function(symbolName) {   
   
   })("roundBtn");
   //Edge symbol end:'roundBtn'

   //=========================================================
   
   //Edge symbol: 'holesMc'
   (function(symbolName) {   
   
   })("holesMcNew");
   //Edge symbol end:'holesMcNew'

   //=========================================================
   
   //Edge symbol: 'cardBtn'
   (function(symbolName) {   
   
   })("cardBtn");
   //Edge symbol end:'cardBtn'

   //=========================================================
   
   //Edge symbol: 'cardMc'
   (function(symbolName) {   
   
   })("cardMc");
   //Edge symbol end:'cardMc'

   //=========================================================
   
   //Edge symbol: 'allHolesMc'
   (function(symbolName) {   
   
   })("allHolesMc");
   //Edge symbol end:'allHolesMc'

   //=========================================================
   
   //Edge symbol: 'holesMc'
   (function(symbolName) {   
   
   })("holesMc");
   //Edge symbol end:'holesMc'

   //=========================================================
   
   //Edge symbol: 'holeMc0'
   (function(symbolName) {   
   
   })("holeMc0");
   //Edge symbol end:'holeMc0'

   //=========================================================
   
   //Edge symbol: 'navBtn'
   (function(symbolName) {   
   
   })("navNextBtn");
   //Edge symbol end:'navNextBtn'

   //=========================================================
   
   //Edge symbol: 'holeMc0_1'
   (function(symbolName) {   
   
   })("holeMc1");
   //Edge symbol end:'holeMc1'

   //=========================================================
   
   //Edge symbol: 'holeMc1_1'
   (function(symbolName) {   
   
   })("holeMc2");
   //Edge symbol end:'holeMc2'

   //=========================================================
   
   //Edge symbol: 'holeMc2_1'
   (function(symbolName) {   
   
   })("holeMc3");
   //Edge symbol end:'holeMc3'

   //=========================================================
   
   //Edge symbol: 'holeMc3_1'
   (function(symbolName) {   
   
   })("holeMc4");
   //Edge symbol end:'holeMc4'

   //=========================================================
   
   //Edge symbol: 'holeMc4_1'
   (function(symbolName) {   
   
   })("holeMc5");
   //Edge symbol end:'holeMc5'

   //=========================================================
   
   //Edge symbol: 'holeMc5_1'
   (function(symbolName) {   
   
   })("holeMc6");
   //Edge symbol end:'holeMc6'

   //=========================================================
   
   //Edge symbol: 'holeMc6_1'
   (function(symbolName) {   
   
   })("holeMc7");
   //Edge symbol end:'holeMc7'

   //=========================================================
   
   //Edge symbol: 'holeMc7_1'
   (function(symbolName) {   
   
   })("holeMc8");
   //Edge symbol end:'holeMc8'

   //=========================================================
   
   //Edge symbol: 'holeMc8_1'
   (function(symbolName) {   
   
   })("holeMc9");
   //Edge symbol end:'holeMc9'

   //=========================================================
   
   //Edge symbol: 'holeMc9_1'
   (function(symbolName) {   
   
   })("holeMc10");
   //Edge symbol end:'holeMc10'

   //=========================================================
   
   //Edge symbol: 'holeMc9_1'
   (function(symbolName) {   
   
   })("holeMc11");
   //Edge symbol end:'holeMc11'

   //=========================================================
   
   //Edge symbol: 'holeMc11_1'
   (function(symbolName) {   
   
   })("holeMc12");
   //Edge symbol end:'holeMc12'

   //=========================================================
   
   //Edge symbol: 'holeMc12_1'
   (function(symbolName) {   
   
   })("holeMc13");
   //Edge symbol end:'holeMc13'

   //=========================================================
   
   //Edge symbol: 'holeMc13_1'
   (function(symbolName) {   
   
   })("holeMc14");
   //Edge symbol end:'holeMc14'

   //=========================================================
   
   //Edge symbol: 'holeMc14_1'
   (function(symbolName) {   
   
   })("holeMc15");
   //Edge symbol end:'holeMc15'

   //=========================================================
   
   //Edge symbol: 'holeMc15_1'
   (function(symbolName) {   
   
   })("holeMc16");
   //Edge symbol end:'holeMc16'

   //=========================================================
   
   //Edge symbol: 'holeMc16_1'
   (function(symbolName) {   
   
   })("holeMc17");
   //Edge symbol end:'holeMc17'

   //=========================================================
   
   //Edge symbol: 'navNextBtn_1'
   (function(symbolName) {   
   
      })("navBackBtn");
   //Edge symbol end:'navBackBtn'

   //=========================================================
   
   //Edge symbol: 'slideBtns'
   (function(symbolName) {   
   
   })("slideBtns");
   //Edge symbol end:'slideBtns'

   //=========================================================
   
   //Edge symbol: 'winnersMc'
   (function(symbolName) {   
   
   })("winnersMc");
   //Edge symbol end:'winnersMc'

   //=========================================================
   
   //Edge symbol: 'winnersBtn'
   (function(symbolName) {   
   
   })("winnersBtn");
   //Edge symbol end:'winnersBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'menuBtn0_1'
   (function(symbolName) {   
   
   })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtn0_2'
   (function(symbolName) {   
   
   })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'menuBtn2_1'
   (function(symbolName) {   
   
   })("slideBackBtn");
   //Edge symbol end:'slideBackBtn'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNews33312");