/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clicked = 0;
         	var btnNo = 0;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.getSymbol("introMc").$("standTxt").css({"pointer-events":"none", "background-color":"#3d3d3d", "height":"auto","padding":"10px","padding-left":"15px","padding-right":"15px"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	var blackBox = {"background-color":"rgba(0,0,0,0.8)", "width":"auto", "height":"auto", "padding":"6px", "padding-right":"15px",  "padding-bottom":"15px", "pointer-events":"none"};
         	var whiteTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         	var capBox = {"background-color":"rgba(0,0,0,0.8)", "padding":"10px", "pointer-events":"none"};
         	
         // MENU TEXT START
         	var menuTxt=[];
         	menuTxt[0] = sym.getSymbol("menuBtn0").$("txt").css({"pointer-events":"none"});
         	menuTxt[1] = sym.getSymbol("menuBtn1").$("txt").css({"pointer-events":"none"});
         	menuTxt[2] = sym.getSymbol("menuBtn2").$("txt").css({"pointer-events":"none"});
         	menuTxt[3] = sym.getSymbol("menuBtn3").$("txt").css({"pointer-events":"none"});
         	var menuArr=[];
         	var outBtn  = {"background-color":"rgba(0,0,0,1)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         
         	var txt=[];
         	txt[0] = sym.getSymbol("timelineMc").$("txt0").css(blackBox);
         	txt[1] = sym.getSymbol("timelineMc").$("txt1").css(blackBox);
         	txt[2] = sym.getSymbol("timelineMc").$("txt2").css(blackBox);
         	txt[3] = sym.getSymbol("timelineMc").$("txt3").css(blackBox);
         	txt[4] = sym.getSymbol("bombMc").getSymbol("bombCutMc").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("bombMc").getSymbol("bombCutMc").$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.getSymbol("bombMc").getSymbol("bombCutMc").$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.getSymbol("bombMc").getSymbol("bombCutMc").$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.getSymbol("bombMc").$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.getSymbol("bombMc").$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.getSymbol("bombMc").$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.getSymbol("bombMc").$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.getSymbol("bombMc").$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.getSymbol("bombMc").$("txt13").css({"pointer-events":"none"});
         	txt[14] = sym.getSymbol("bombMc").$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.getSymbol("bombMc").$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.$("txt16").css({"pointer-events":"none", "background-color":"#3d3d3d", "height":"auto","padding":"10px","padding-left":"15px","padding-right":"15px"});
         	txt[17] = sym.getSymbol("galleryMc").$("txt17").css(capBox);
         	txt[18] = sym.$("txt18").css({"pointer-events":"none"});
         	txt[19] = sym.$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.$("txt20").css({"pointer-events":"none"});
         	txt[21] = sym.$("txt21").css({"pointer-events":"none"});
         	txt[22] = sym.$("txt22").css({"pointer-events":"none"});
         	txt[23] = sym.$("txt23").css({"pointer-events":"none"});
         	txt[24] = sym.$("txt24").css({"pointer-events":"none"});
         	txt[25] = sym.$("txt25").css({"pointer-events":"none"});
         	txt[26] = sym.$("txt26").css({"pointer-events":"none"});
         	txt[27] = sym.getSymbol("bombMc").$("txt27").css({"pointer-events":"none"});
         	txt[28] = sym.getSymbol("videoMc").$("txt28").css({"pointer-events":"none"});
         	txt[29] = sym.$("txt29").css({"pointer-events":"none"});
         	txt[30] = sym.$("txt30").css({"pointer-events":"none"});
         
         	var txtArr=[];
         
         	var txtArr=[];
         	var tableArr=[]; //create array of tables
         	for (var i=0; i<3;i++){
         		tableArr[i]=[];//create array for each table
         	}
         	var strapArr=[]; //create strap array
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33286.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css({"background-color":custonCol});
         			stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("introMc").$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         //create table
         			var newTable="<div id='newTab'>";
         			var dataTab1;
         			newTable+="<div id='newtab1'>";
         			$(xml).find('table1').each(function() {
         				var strap=$(this).find('strap').text();
         				newTable+="<div class='redstrap'>"+strap+"</div>";
         				newTable+="<table class='events'>";
         				$(this).find('number1').each(function() {
         					dataTab1 = $(this).find("date1").text();
         					newTable+="<tr><td>"+dataTab1+"</td></tr>";
         				});
         				newTable+="</table>";
         			});
         			newTable+="</div>";
         			newTable+="<div id='newtab2'>";
         			$(xml).find('table2').each(function() {
         				var strap=$(this).find('strap').text();
         				newTable+="<div class='redstrap'>"+strap+"</div>";
         				newTable+="<table class='events'>";
         				$(this).find('number2').each(function() {
         					dataTab2 = $(this).find("date2").text();
         					newTable+="<tr><td>"+dataTab2+"</td></tr>";
         				});
         				newTable+="</table>";
         			});			
         			newTable+="</div>";
         			newTable+="<div id='newtab3'>";
         			$(xml).find('table3').each(function() {
         				var strap=$(this).find('strap').text();
         				newTable+="<div class='redstrap'>"+strap+"</div>";
         				newTable+="<table class='events'>";
         				$(this).find('number3').each(function() {
         					dataTab3 = $(this).find("date3").text();
         					newTable+="<tr><td>"+dataTab3+"</td></tr>";
         				});
         				newTable+="</table>";
         			});	
         		sym.getSymbol("tablesMc").$("tableMc").append(newTable);
         		//apply styles
         		$("#newTab").css({"font-family":"Pragmatica-web, sans-serif"});
         		$(".events").css({"text-align":"left","color":"#000000","font-size":"13px","line-height":"15px",'border':0,'border-collapse':'collapse'});
         		$("#newtab1 tr:odd").css({"background-color":"#dddddd"});
         		$("#newtab1 tr:even").css({"background-color":"#ffffff"});
         		$("#newtab2 tr:odd").css({"background-color":"#cccccc"});
         		$("#newtab2 tr:even").css({"background-color":"#dddddd"});
         		$("#newtab3 tr:odd").css({"background-color":"#dddddd"});
         		$("#newtab3 tr:even").css({"background-color":"#ffffff"});
         		$('.events td').css({'padding':'10px', 'padding-right':'10px'});
         		$(".redstrap").css({'font-weight':600,'color':'black','width':'100%','background-color':'#FFCB05', 'text-align':'center', 'padding-top':4, 'padding-bottom':4});
         		sym.getSymbol("tablesMc").$("tableMc").css({'overflow-y':'scroll'});
         
         			// MENU TEXT START
         			for (var i=0; i<4; i++){
         				menuArr[i]=$(xml).find('menuTxt'+i).text();
         				menuTxt[i].html(menuArr[i]);
         			} // MENU TEXT END
         
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<29; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         			sym.$("txt16").css({"font-size":"15px", "pointer-events":"none", "background-color":"rgba(30,30,30,0.93)", "height":"auto","padding":"10px","padding-left":"15px","padding-right":"15px"});
         			sym.getSymbol("bombMc").$("txt27").css({"font-size":"16px"});
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         function timelineScroll(){
         // Map scroll position to timeline position
         var tabHeight = sym.getSymbol("tablesMc").$("#newTab").height();
         var tableHeight = sym.getSymbol("tablesMc").$("tableMc").height();
         var scrollPos = sym.getSymbol("tablesMc").$("tableMc").scrollTop();
         var duration = sym.getSymbol("timelineMc").getDuration();
         var percent = scrollPos / (tabHeight - tableHeight);
         var time = duration * percent;
         sym.getSymbol("timelineMc").stop(time);
         sym.getSymbol("tablesMc").$("scrollDown").fadeOut(200);
         sym.getSymbol("tablesMc").$("tableMc").css({'overflow-y':'auto'});
         }	
         sym.getSymbol("tablesMc").$("tableMc").on('scroll',timelineScroll);	
         sym.getSymbol("tablesMc").$("tableMc").css({'overflow-x':'hidden'});
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         var standTop = 70;
         var mobile = 0;
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("introMc").stop(stageWidth*10);
         	//sym.$("timelineMc").stop().animate({width:stageWidth+230}, 0);
         	sym.$("timelineMc").css({'overflow-x':'scroll'});
         	sym.$("timelineMc").css({'overflow-y':'hidden'});
         	sym.getSymbol("toggleBtn").$("plus").fadeIn(0);
         	setStyle();
         	if(stageWidth<800){
         	}else{
         
         	}
         	if(stageWidth<640){
         		sym.$("txt16").css({"height":"auto"});
         		sym.$("toggleBtn").stop().animate({left:stageWidth-50, top:-200}, 0);
         		sym.getSymbol("introMc").$("standTxt").css({"height":"auto"});
         		sym.$("txt16").stop().animate({top:0-sym.$("txt16").height()}, 0);
         	}else{
         		sym.$("txt16").css({"height":"512px"});
         		sym.getSymbol("introMc").$("standTxt").css({"height":"512px"});
         		sym.$("toggleBtn").stop().animate({left:800, top:70}, 0);
         		sym.$("txt16").stop().animate({top:70}, 0);
         	}
         	if (stageWidth<480){
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":"20px"});		
         		sym.$("galleryMc").stop().animate({top:100}, 0);
         		standTop = 100;
         		sym.getSymbol("tablesMc").$("tableMc").stop().animate({width:stageWidth, height:482}, 0);
         		sym.$("toggleBtn").stop().animate({top:100}, 0);
         	}else{
         		sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":"28px"});	
         		sym.$("galleryMc").stop().animate({top:70}, 0);
         		standTop = 70;
         		sym.$("toggleBtn").stop().animate({top:70}, 0);
         		sym.getSymbol("tablesMc").$("tableMc").stop().animate({width:230, height:512}, 0);
         	}
         	sym.getSymbol("tablesMc").$("scrollDown").stop().animate({left:sym.getSymbol("tablesMc").$("tableMc").width()/2-33}, 0);
         }
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // MENU BUTTONS
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<4; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtn" + h).$("bg").css(outBtn);
         		sym.$("tablesMc").stop().animate ({opacity:0}, 200, function(){ sym.$("tablesMc").fadeOut(0); });
         		sym.$("timelineMc").stop().animate ({opacity:0}, 200, function(){ sym.$("timelineMc").fadeOut(0); });
         		sym.$("bombMc").stop().animate ({opacity:0}, 200, function(){ sym.$("bombMc").fadeOut(0); });
         		sym.$("galleryMc").fadeOut(0);
         		sym.$("videoMc").fadeOut(0);
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.preventDefault(); e.stopPropagation();
         		sym.$("introMc").stop().animate ({opacity:0}, 200, function(){ sym.$("introMc").fadeOut(0); });
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		if (menuNo == 0){
         			sym.$("timelineMc").fadeIn(0);
         			sym.$("timelineMc").stop().animate({opacity:1}, 200);
         			sym.$("tablesMc").fadeIn(0);
         			sym.$("tablesMc").stop().animate({opacity:1}, 200);
         			sym.$("txt16").stop().animate({opacity:0}, 200);
         		}
         		if (menuNo == 1){
         			sym.$("bombMc").fadeIn(0);
         			sym.$("bombMc").stop().animate({opacity:1}, 200);
         			sym.getSymbol("bombMc").play(1)
         			sym.$("txt16").stop().animate({opacity:1}, 200);
         		}
         		if (menuNo == 2){
         			sym.$("galleryMc").fadeIn(0);
         			sym.$("txt16").stop().animate({opacity:1}, 200);
         		}
         		if (menuNo == 3){
         			sym.$("videoMc").fadeIn(0);
         			sym.getSymbol("videoMc").$("bomb")[0].play(0);
         		}
         	};
         };
         for (var b=0;b<menuArray.length;b++){
         	sym.$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         	sym.$("menuBtn"+b).css({'cursor':'pointer'});
         }
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // MOUSE SCROLL SYMBOL
         var x,left,down;
         sym.$("timelineMc").mousedown(function(e){
             e.stopPropagation(); e.preventDefault();
             down=true;
             x=e.pageX;
             left=$(this).scrollLeft();
         });
         
         sym.$("timelineMc").mousemove(function(e){
         	e.stopPropagation(); e.preventDefault();
             if(down){
                 var newX=e.pageX;
                 sym.$("timelineMc").scrollLeft(left-newX+x);    
             }
         });
         sym.$("timelineMc").mouseup(function(e){down=false;});
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // TOGGLE BUTTON
         sym.$("toggleBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (sym.getSymbol("toggleBtn").$("plus").is(":visible") ) { 
         		sym.getSymbol("toggleBtn").$("plus").fadeOut(0);
         		sym.$("txt16").stop().animate({top:standTop}, 140);
         		sym.$("toggleBtn").stop().animate({top:standTop + sym.$("txt16").height() +20}, 200);
         	}else{
         		sym.getSymbol("toggleBtn").$("plus").fadeIn(0);
         		sym.$("txt16").stop().animate({top:0-sym.$("txt16").height()}, 220);
         		sym.$("toggleBtn").stop().animate({top:standTop}, 100);
         	}
         }); 
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // BOMB BTN
         sym.getSymbol("bombMc").$("bombBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	sym.getSymbol("bombMc").play();
         	});
         	//--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SWIPE IMAGE
         var swipe = 0;
         sym.$("galleryMc").on("swipeleft",function(){
         	e.stopPropagation(); e.preventDefault();
         		if (swipe >= 9) {
         		}else{
         			swipe++;
         			swipeIt();
         		}
         }); 
         
         sym.$("galleryMc").on("swiperight",function(){
         	e.stopPropagation(); e.preventDefault();
         		if (swipe <= 0) {
         		}else{
         			swipe--;
         			swipeIt();
         		}
         }); 
         
         // GALLERY NAV BTN
         sym.getSymbol("galleryMc").$("galNavLeft").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	swipe--;
         	swipeIt();
         	});
         
         sym.getSymbol("galleryMc").$("galNavRight").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	swipe++;
         	swipeIt();
         	});
         
         function swipeIt() {
         	sym.getSymbol("galleryMc").$("swipePic").attr("src", "images/pic" + swipe + ".jpg");
         	sym.getSymbol("galleryMc").$("txt17").empty();
         	sym.getSymbol("galleryMc").$("txt17").append(txtArr[swipe + 17]);
         	sym.getSymbol("galleryMc").$("picNo").text((swipe+1) + "/10");
         	if (swipe <= 0) {
         		sym.getSymbol("galleryMc").$("galNavLeft").fadeOut(0);
         	}else{
         		sym.getSymbol("galleryMc").$("galNavLeft").fadeIn(0);
         		}
         	if (swipe >= 9) {
         		sym.getSymbol("galleryMc").$("galNavRight").fadeOut(0);
         	}else{
         		sym.getSymbol("galleryMc").$("galNavRight").fadeIn(0);
         		}
         }
         sym.getSymbol("galleryMc").$("galNavLeft").fadeOut(0);
         
         //--------------------------------------------------------------------------------------------------------
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SET STYLE SETTING 
         function setStyle() {
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("videoMc").stop(stageWidth*10);
         	sym.getSymbol("galleryMc").stop(stageWidth*10);
         	sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "height":"auto", "width":"auto", "padding":"6px", "padding-top":"6px"});
         	sym.getSymbol("styleHead").$("headlineTxt").stop().animate({width:stageWidth-12}, 0);
         	sym.getSymbol("styleBase").$("creditTxt").animate({left:stageWidth-120}, 0);
         }
         //--------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         //--------------------------------------------------------------------------------------------------------
         $(window).on('resize',initSize);
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------- END -------------------------------------------------
         //--------------------------------------------------------------------------------------------------------

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'Base'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'tableMc'
   (function(symbolName) {   
   
   })("tableMc");
   //Edge symbol end:'tableMc'

   //=========================================================
   
   //Edge symbol: 'tablesMc'
   (function(symbolName) {   
   
   })("tablesMc");
   //Edge symbol end:'tablesMc'

   //=========================================================
   
   //Edge symbol: 'timelineMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("timelineMc");
   //Edge symbol end:'timelineMc'

   //=========================================================
   
   //Edge symbol: 'introMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("introMc");
   //Edge symbol end:'introMc'

   //=========================================================
   
   //Edge symbol: 'bombMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3084, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6000, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6283, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6954, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("bombMc");
   //Edge symbol end:'bombMc'

   //=========================================================
   
   //Edge symbol: 'bombCutMc'
   (function(symbolName) {   
   
   })("bombCutMc");
   //Edge symbol end:'bombCutMc'

   //=========================================================
   
   //Edge symbol: 'toggleBtn_1'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'introMovie'
   (function(symbolName) {   
   
   })("introMovie");
   //Edge symbol end:'introMovie'

   //=========================================================
   
   //Edge symbol: 'galleryMc'
   (function(symbolName) {   
   
   })("galleryMc");
   //Edge symbol end:'galleryMc'

   //=========================================================
   
   //Edge symbol: 'videoMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("videoMc");
   //Edge symbol end:'videoMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33286");