/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType=('touchstart click');
         	var clicked = 0;
         	var btnNo = 0;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css({"pointer-events":"none","background-color":"rgba(255,255,255,1)", "height":"auto", "width":"auto", "padding":"4px"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var whiteTxtBox = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,1)", "height":"auto", "padding":"6px"};
         	
         	var purpleTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"white",
         	"background-color":"#572160","width":"auto", "padding":"4px", "padding-left":"10px", "padding-right":"10px"};
         	
         // MENU TEXT START
         	var menuTxt=[];
         	menuTxt[0] = sym.getSymbol("menuBtnsMc").$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[1] = sym.$("menuTxt").css({"pointer-events":"none"});
         	var menuArr=[];
         
         	for (var b=0;b<2; b++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+b).$("menuIcon").attr("src", "images/menuIcon" + b + ".png");
         	} // MENU TEXT END
         
         	var outBtn  = {"background-color":"rgba(0,0,0,1)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         
         	var txt=[];
         	txt[0] = sym.getSymbol("scene1Mc").getSymbol("break1Mc").$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.getSymbol("scene1Mc").getSymbol("break1Mc").$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.getSymbol("scene1Mc").getSymbol("break1Mc").$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.getSymbol("scene1Mc").getSymbol("break1Mc").$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("scene1Mc").getSymbol("break1Mc").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("scene1Mc").getSymbol("break1Mc").$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.getSymbol("scene1Mc").$("txt6").css(purpleTxtBox);
         	txt[7] = sym.getSymbol("scene1Mc").$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.getSymbol("scene1Mc").$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.getSymbol("scene1Mc").$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.getSymbol("scene2Mc").$("txt10").css(purpleTxtBox);
         	txt[11] = sym.getSymbol("scene2Mc").$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.getSymbol("scene2Mc").$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.getSymbol("scene2Mc").$("txt13").css({"pointer-events":"none"});
         	txt[14] = sym.getSymbol("scene2Mc").$("txt14").css(whiteTxtBox);
         	txt[15] = sym.getSymbol("scene2Mc").getSymbol("break2Mc").$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.getSymbol("scene2Mc").getSymbol("break2Mc").$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.getSymbol("scene2Mc").getSymbol("break2Mc").$("txt17").css({"pointer-events":"none"});
         	txt[18] = sym.getSymbol("scene2Mc").getSymbol("break2Mc").$("txt18").css({"pointer-events":"none"});
         	txt[19] = sym.getSymbol("scene2Mc").getSymbol("break2Mc").$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.getSymbol("scene2Mc").getSymbol("break2Mc").$("txt20").css({"pointer-events":"none"});
         	txt[21] = sym.getSymbol("scene2Mc").getSymbol("break2Mc").$("txt21").css({"pointer-events":"none"});
         
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33234.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css({"background-color":custonCol});
         			stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("styleHead").$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			// MENU TEXT START
         			for (var i=0; i<2; i++){
         				menuArr[i]=$(xml).find('menuTxt'+i).text();
         				menuTxt[i].html(menuArr[i]);
         			} // MENU TEXT END
         
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<22; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         
         			//sym.getSymbol("SYMBOL").$("txt").animate({top:yNUMBER - sym.getSymbol("SYMBOL").$("txt").height()+10}, 200);
         			sym.getSymbol("scene1Mc").$("txt6").css({"font-size":"16px"});
         			sym.getSymbol("scene2Mc").$("txt10").css({"font-size":"16px"});
         ;
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // MENU BUTTONS
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<2; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(outBtn);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         	}
         }
         //resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[menuNo]);
         		if (menuNo == 0){
         			sym.getSymbol("scene2Mc").getSymbol("break2Mc").playReverse();
         			sym.$("scene2Mc").fadeOut(100);
         			sym.$("scene1Mc").fadeIn(100);
         			sym.getSymbol("scene1Mc").getSymbol("break1Mc").play(0);
         		}
         		if (menuNo == 1){
         			sym.getSymbol("scene1Mc").getSymbol("break1Mc").playReverse();
         			sym.$("scene1Mc").fadeOut(100);
         			sym.$("scene2Mc").fadeIn(100);
         			sym.getSymbol("scene2Mc").getSymbol("break2Mc").play(0);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         /*
         // MENU OVER
         var menuBtnOver = function(menuNo){ //to handle lexical scope
         	return function (e) {
         	e.preventDefault(); e.stopPropagation();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[menuNo]);
         	};
         };
         // MENU OUT
         var menuBtnOut = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		e.stopPropagation(); e.preventDefault();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[clicked]);
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(outBtn);
         		if (clicked == menuNo){
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		}
         	};
         };
         */
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on(clickEventType,menuBtnClick(b));
         	//sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseover',menuBtnOver(b));
         	//sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseout',menuBtnOut(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(overBtn);
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("scene1Mc").stop(stageWidth*10);
         	sym.getSymbol("scene2Mc").stop(stageWidth*10);
         	sym.$("breakBtn").stop().animate({left:stageWidth-34}, 0);
         	setStyle();
         	sym.getSymbol("scene1Mc").$("txt6").animate({top:153 + (sym.getSymbol("styleHead").$("headlineTxt").height()+sym.getSymbol("styleHead").$("standTxt").height())+5}, 0);
         	sym.getSymbol("scene2Mc").$("txt10").animate({top:0 + (sym.getSymbol("styleHead").$("headlineTxt").height()+sym.getSymbol("styleHead").$("standTxt").height())+25}, 0);
         	sym.getSymbol("breakBtn").$("minus").fadeOut(0);
         	sym.getSymbol("breakBtn").$("plus").fadeIn(0);
         	if(stageWidth<800){
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeOut(0);
         
         	}else{
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeIn(0);
         	}
         	if(stageWidth<640){
         		sym.$("breakBtn").fadeIn(0);
         		sym.getSymbol("scene1Mc").$("break1Mc").stop().animate({left:stageWidth + 471}, 0);
         		sym.getSymbol("scene1Mc").getSymbol("break1Mc").$("scene1BgPanel").stop().animate({opacity:1}, 0);
         		sym.getSymbol("scene1Mc").$("scene1Bg").stop().animate({left:stageWidth + 471}, 0);
         		sym.getSymbol("scene2Mc").$("break2Mc").stop().animate({left:stageWidth + 471}, 0);
         	}else{
         		sym.$("breakBtn").fadeOut(0);
         		sym.getSymbol("scene1Mc").$("break1Mc").stop().animate({left:stageWidth - 169}, 0);
         		sym.getSymbol("scene1Mc").getSymbol("break1Mc").$("scene1BgPanel").stop().animate({opacity:0}, 0);
         		sym.getSymbol("scene1Mc").$("scene1Bg").stop().animate({left:stageWidth - 169}, 0);
         		sym.getSymbol("scene2Mc").$("break2Mc").stop().animate({left:stageWidth - 719}, 0);
         	}
         	if (stageWidth<480){
         
         	}else{
         
         	}
         	setStyleUpdate();
         }
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // TOGGLE BUTTON
         sym.$("breakBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	var stageWidth=sym.$("Stage").width();
         	if (sym.getSymbol("breakBtn").$("plus").is(":visible") ) { 
         		sym.getSymbol("breakBtn").$("plus").fadeOut(0);
         		sym.getSymbol("breakBtn").$("minus").fadeIn(0);
         		sym.getSymbol("scene1Mc").$("break1Mc").stop().animate({left:stageWidth - 169}, 200);
         		sym.getSymbol("scene1Mc").$("scene1Bg").stop().animate({left:stageWidth - 169}, 200);
         		sym.getSymbol("scene2Mc").$("break2Mc").stop().animate({left:stageWidth - 700}, 200);
         	}else{
         		sym.getSymbol("breakBtn").$("plus").fadeIn(0);
         		sym.getSymbol("breakBtn").$("minus").fadeOut(0);
         		sym.getSymbol("scene1Mc").$("break1Mc").stop().animate({left:stageWidth + 471}, 200);
         		sym.getSymbol("scene1Mc").$("scene1Bg").stop().animate({left:stageWidth + 471}, 200);
         		sym.getSymbol("scene2Mc").$("break2Mc").stop().animate({left:stageWidth + 1}, 200);
         	}
         });
         
         //--------------------------------------------------------------------------------------------------------
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SET STYLE SETTING 
         function setStyle() {
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "height":"auto", "width":"auto", "padding":"6px", "padding-top":"6px"});
         	sym.getSymbol("styleHead").$("standTxt").animate({top:0 + sym.getSymbol("styleHead").$("headlineTxt").height()+8}, 0);
         	sym.getSymbol("styleHead").$("headlineTxt").stop().animate({width:stageWidth-90}, 0);
         	sym.getSymbol("styleBase").$("creditTxt").animate({left:stageWidth-120}, 0);
         }
         function setStyleUpdate(){
         	var stageWidth=sym.$("Stage").width();
         	for (var b=0;b<2; b++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+b).$("bg").animate({height:0 + sym.getSymbol("styleHead").$("headlineTxt").height()+12}, 0);
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+b).$("menuIcon").animate({top:(sym.getSymbol("styleHead").$("headlineTxt").height()/2)-14}, 0);
         	}
         	sym.getSymbol("styleHead").$("standTxt").animate({top:0 + sym.getSymbol("styleHead").$("headlineTxt").height()+12}, 0);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyleUpdate();
         //--------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         }); 
         /*
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         */
         //--------------------------------------------------------------------------------------------------------
         $(window).on('resize',initSize);
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------- END -------------------------------------------------
         //--------------------------------------------------------------------------------------------------------

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtn_1'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("auxBtnsMc");
   //Edge symbol end:'auxBtnsMc'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'Base'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'break1Mc'
   (function(symbolName) {   
   
   })("break1Mc");
   //Edge symbol end:'break1Mc'

   //=========================================================
   
   //Edge symbol: 'breakBtn'
   (function(symbolName) {   
   
   })("breakBtn");
   //Edge symbol end:'breakBtn'

   //=========================================================
   
   //Edge symbol: 'scene1Mc'
   (function(symbolName) {   
   
   })("scene1Mc");
   //Edge symbol end:'scene1Mc'

   //=========================================================
   
   //Edge symbol: 'break2Mc'
   (function(symbolName) {   
   
   })("break2Mc");
   //Edge symbol end:'break2Mc'

   //=========================================================
   
   //Edge symbol: 'scene2Mc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6300, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("scene2Mc");
   //Edge symbol end:'scene2Mc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33234");