/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clicked = 0;
         	var btnNo = 0;
         	//var mob=(sym.$("Stage").width()>480)?0:1;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"25px","padding-right":"4px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({"pointer-events":"none"});
         	var stand;
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css({"pointer-events":"none","background-color":"rgba(255,255,255,1)", "height":"auto", "width":"auto", "padding":"4px"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var whiteTxtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         	
         // MENU TEXT START
         	var menuTxt=[];
         	menuTxt[0] = sym.getSymbol("menuBtnsMc").$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[1] = sym.$("menuTxt").css({"pointer-events":"none"});
         	var menuArr=[];
         
         	for (var b=0;b<2; b++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+b).$("menuIcon").attr("src", "images/menuBtn" + b + ".png");
         	} // MENU TEXT END
         
         	for (var c=0;c<3; c++){
         		sym.getSymbol("scrollMc").getSymbol("cockMc").getSymbol("auxBtnsMc").getSymbol("auxBtn" + c).$("menuIcon").attr("src", "images/menuIcon" + c + ".png");
         	}
         
         	var yellowBox = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"#fbae17", "height":"auto", "padding":"6px", "pointer-events":"none", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"};
         
         	var whiteBox = {"border-color":"black", "border-width":"1px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"white", "height":"auto", "padding":"6px", "pointer-events":"none", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"};
         
         	var outBtn  = {"background-color":"rgba(0,0,0,1)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         
         	var txt=[];
         	txt[0] = sym.getSymbol("scrollMc").getSymbol("planeMc").$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.getSymbol("scrollMc").getSymbol("planeMc").$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.getSymbol("scrollMc").getSymbol("planeMc").$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.getSymbol("scrollMc").getSymbol("planeMc").$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("scrollMc").getSymbol("planeMc").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("scrollMc").getSymbol("sizeMc").$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.getSymbol("scrollMc").getSymbol("sizeMc").$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.getSymbol("scrollMc").getSymbol("cockMc").getSymbol("cockMc0").$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.getSymbol("scrollMc").getSymbol("cockMc").getSymbol("cockMc0").$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.getSymbol("scrollMc").getSymbol("cockMc").getSymbol("cockMc1").$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.getSymbol("scrollMc").getSymbol("cockMc").getSymbol("cockMc1").$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.getSymbol("scrollMc").getSymbol("cockMc").getSymbol("cockMc2").$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.getSymbol("scrollMc").getSymbol("cockMc").getSymbol("cockMc2").$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.getSymbol("scrollMc").getSymbol("cockMc").getSymbol("cockMc2").$("txt13").css({"pointer-events":"none"});
         	txt[14] = sym.getSymbol("scrollMc").getSymbol("mapMc").$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.getSymbol("scrollMc").getSymbol("mapMc").$("txt15").css(yellowBox);
         	txt[16] = sym.getSymbol("scrollMc").getSymbol("mapMc").$("txt16").css(yellowBox);
         	txt[17] = sym.getSymbol("scrollMc").getSymbol("mapMc").$("txt17").css(yellowBox);
         	txt[18] = sym.getSymbol("scrollMc").getSymbol("mapMc").$("txt18").css(yellowBox);
         	txt[19] = sym.getSymbol("scrollMc").getSymbol("mapMc").$("txt19").css(yellowBox);
         	txt[20] = sym.getSymbol("scrollMc").getSymbol("mapMc").$("txt20").css(yellowBox);
         	txt[21] = sym.getSymbol("scrollMc").getSymbol("mapMc").$("txt21").css(yellowBox);
         	txt[22] = sym.getSymbol("scrollMc").getSymbol("mapMc").$("txt22").css(whiteBox);
         	txt[23] = sym.getSymbol("scrollMc").getSymbol("mapMc").$("txt23").css({"pointer-events":"none"});
         	txt[24] = sym.getSymbol("scrollMc").getSymbol("mapMc").$("txt24").css({"pointer-events":"none"});
         	txt[25] = sym.getSymbol("scrollMc").getSymbol("mapMc").$("txt25").css({"pointer-events":"none"});
         	txt[26] = sym.getSymbol("scrollMc").getSymbol("mapMc").$("txt26").css({"pointer-events":"none"});
         	txt[27] = sym.getSymbol("scrollMc").getSymbol("mapMc").$("txt27").css({"pointer-events":"none"});
         	txt[28] = sym.$("txt28").css({"pointer-events":"none"});
         	txt[29] = sym.$("txt29").css({"pointer-events":"none"});
         	txt[30] = sym.$("txt30").css({"pointer-events":"none"});
         
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33220.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css({"background-color":custonCol});
         			stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("styleHead").$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			// MENU TEXT START
         			for (var i=0; i<2; i++){
         				menuArr[i]=$(xml).find('menuTxt'+i).text();
         				menuTxt[i].html(menuArr[i]);
         			} // MENU TEXT END
         
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<31; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         			sym.getSymbol("scrollMc").getSymbol("mapMc").$("txt14").css({"font-size":"16px"});
         		},
            complete:function(){
         		initSize();
            }
         
         	}); // END XML
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.$("scrollMc").stop().animate({width:stageWidth}, 0);
         	sym.getSymbol("scrollMc").$("cockMc").stop().animate({left:(stageWidth/2)-178}, 0);
         	sym.getSymbol("scrollMc").$("planeMc").stop().animate({width:stageWidth}, 0);
         	sym.getSymbol("scrollMc").$("mapMc").stop().animate({width:stageWidth}, 0);
         	sym.getSymbol("scrollMc").$("planeMc").css({'overflow-x':'auto'});
         	sym.getSymbol("scrollMc").$("mapMc").css({'overflow-x':'scroll'});
         	sym.getSymbol("scrollMc").stop(stageWidth*10);
         	sym.getSymbol("scrollMc").$("planeMc").scrollLeft(stageWidth+160);
         	sym.getSymbol("scrollMc").$("planeMc").css({'overflow-y':'hidden'});//PB
         	sym.getSymbol("scrollMc").$("mapMc").css({'overflow-y':'hidden'});//PB
         	setStyle();
         	if(stageWidth<800){
         		sym.getSymbol("scrollMc").$("planeMc").css('cursor', 'ew-resize');
         		sym.getSymbol("scrollMc").$("mapMc").css('cursor', 'ew-resize');
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeOut(0);
         	}else{
         		sym.getSymbol("scrollMc").$("planeMc").css('cursor', 'default');
         		sym.getSymbol("scrollMc").$("mapMc").css('cursor', 'default');
         		sym.getSymbol("menuBtnsMc").$("menuTxt").fadeIn(0);
         	}
         	if(stageWidth<640){
         		sym.getSymbol("scrollMc").getSymbol("sizeMc").$("sizeBg").stop().animate({opacity:1}, 0);
         		sym.getSymbol("scrollMc").$("sizeMc").fadeOut(0);
         		sym.getSymbol("scrollMc").getSymbol("sqrTogBtn").$("plus").fadeIn(0);
         	}else{
         		sym.getSymbol("scrollMc").$("sizeMc").fadeIn(0);
         		sym.getSymbol("scrollMc").getSymbol("sizeMc").$("sizeBg").stop().animate({opacity:0.5}, 0);
         	}
         	if (stageWidth<480){
         
         	}else{
         
         	}
         	setStyleUpdate();
         }
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // MENU BUTTONS
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<2; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(outBtn);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         	}
         }
         //resetmenu();
         
         sym.getSymbol("scrollMc").$("mapMc").stop().animate({opacity:0}, 0);
         sym.getSymbol("scrollMc").$("mapMc").fadeOut(0);
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[menuNo]);
         		if (menuNo == 0) {
         			sym.getSymbol("scrollMc").$("mapMc").stop().animate({opacity:0}, 200);
         			sym.getSymbol("scrollMc").$("mapMc").fadeOut(0);
         		}
         		if (menuNo == 1) {
         			sym.getSymbol("scrollMc").$("mapMc").fadeIn(0);
         			sym.getSymbol("scrollMc").$("mapMc").stop().animate({opacity:1}, 200);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OVER
         var menuBtnOver = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[menuNo]);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OUT
         var menuBtnOut = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[clicked]);
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(outBtn);
         		if (clicked == menuNo){
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('touchstart click',menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseover',menuBtnOver(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseout',menuBtnOut(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(overBtn);
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // AUX BUTTONS
         var clickAux = 0;
         var outAux  = {"background-color":"rgba(61,61,61,1)"};
         var overAux = {"background-color":"rgba(218,0,0,1)"};
         auxArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<3; a++){
         	auxArray.push(a);
         }
         
         function resetAux(){
         	for (var a=0; a<auxArray.length; a++){
         		sym.getSymbol("scrollMc").getSymbol("cockMc").getSymbol("auxBtnsMc").getSymbol("auxBtn" + a).$("bg").css(outAux);
         		sym.getSymbol("scrollMc").getSymbol("cockMc").$("cockMc" + a).fadeOut(200);
         	}
         }
         resetAux();
         
         // AUX CLICK
         var auxBtnClick = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		clickAux = auxNo;
         		resetAux();
         		sym.getSymbol("scrollMc").getSymbol("cockMc").getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxNo).$("bg").css(overAux);
         		sym.getSymbol("scrollMc").getSymbol("cockMc").$("cockMc" + auxNo).fadeIn(200);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // AUX OVER
         var auxBtnOver = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("scrollMc").getSymbol("cockMc").getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxNo).$("bg").css(overAux);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // AUX OUT
         var auxBtnOut = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("scrollMc").getSymbol("cockMc").getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxNo).$("bg").css(outAux);
         		if (clickAux == auxNo){
         			sym.getSymbol("scrollMc").getSymbol("cockMc").getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxNo).$("bg").css(overAux);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<auxArray.length;b++){
         	sym.getSymbol("scrollMc").getSymbol("cockMc").getSymbol("auxBtnsMc").$("auxBtn"+b).on('touchstart click',auxBtnClick(b));
         	sym.getSymbol("scrollMc").getSymbol("cockMc").getSymbol("auxBtnsMc").$("auxBtn"+b).on('mouseover',auxBtnOver(b));
         	sym.getSymbol("scrollMc").getSymbol("cockMc").getSymbol("auxBtnsMc").$("auxBtn"+b).on('mouseout',auxBtnOut(b));
         	sym.getSymbol("scrollMc").getSymbol("cockMc").getSymbol("auxBtnsMc").$("auxBtn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("scrollMc").getSymbol("cockMc").getSymbol("auxBtnsMc").getSymbol("auxBtn0").$("bg").css(overBtn);
         sym.getSymbol("scrollMc").getSymbol("cockMc").$("cockMc0").fadeIn(0);
         
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         // HIDE COCKPIT BUTTON
         sym.getSymbol("scrollMc").getSymbol("cockMc").getSymbol("sqrTogBtn").$("plus").fadeOut(0);
         sym.getSymbol("scrollMc").getSymbol("cockMc").$("sqrTogBtn").on('touchstart click', function(e){
         	e.stopPropagation(); e.preventDefault();
         		sym.getSymbol("scrollMc").$("cockMc").fadeOut(0);
         		sym.getSymbol("scrollMc").getSymbol("planeMc").$("toggleCockBtn").fadeIn(0);
         }); 
         sym.getSymbol("scrollMc").getSymbol("cockMc").$("sqrTogBtn").mouseover(function(){
         	sym.getSymbol("scrollMc").getSymbol("cockMc").getSymbol("sqrTogBtn").$("rollOver").stop().animate ({opacity:0.3}, 100);
         });
         sym.getSymbol("scrollMc").getSymbol("cockMc").$("sqrTogBtn").mouseout(function(){
         	sym.getSymbol("scrollMc").getSymbol("cockMc").getSymbol("sqrTogBtn").$("rollOver").stop().animate ({opacity:0}, 100);
         });
         
         sym.getSymbol("scrollMc").$("cockMc").fadeOut(0);
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         // TOGGLE COCKPIT BUTTON
         sym.getSymbol("scrollMc").getSymbol("planeMc").$("toggleCockBtn").on('touchstart click', function(e){
         	sym.getSymbol("scrollMc").$("cockMc").fadeIn(200);
         	sym.getSymbol("scrollMc").getSymbol("planeMc").$("toggleCockBtn").fadeOut(0);
         	e.stopPropagation(); e.preventDefault();
         }); 
         sym.getSymbol("scrollMc").getSymbol("planeMc").$("toggleCockBtn").mouseover(function(){
         	sym.getSymbol("scrollMc").getSymbol("planeMc").getSymbol("toggleCockBtn").$("rollOver").stop().animate ({opacity:0.3}, 100);
         });
         sym.getSymbol("scrollMc").getSymbol("planeMc").$("toggleCockBtn").mouseout(function(){
         	sym.getSymbol("scrollMc").getSymbol("planeMc").getSymbol("toggleCockBtn").$("rollOver").stop().animate ({opacity:0}, 100);
         });
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         
         // PLANE SIZE BUTTON
         sym.getSymbol("scrollMc").$("sqrTogBtn").on('touchstart click', function(e){
         	if (sym.getSymbol("scrollMc").getSymbol("sqrTogBtn").$("plus").is(":visible") ) { 
         		sym.getSymbol("scrollMc").getSymbol("sqrTogBtn").$("plus").fadeOut(0);
         		sym.getSymbol("scrollMc").$("sizeMc").fadeIn(0);
         	}else{
         		sym.getSymbol("scrollMc").getSymbol("sqrTogBtn").$("plus").fadeIn(0);
         		sym.getSymbol("scrollMc").$("sizeMc").fadeOut(0);
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         sym.getSymbol("scrollMc").$("sqrTogBtn").mouseover(function(){
         	sym.getSymbol("scrollMc").getSymbol("sqrTogBtn").$("rollOver").stop().animate ({opacity:0.3}, 100);
         });
         sym.getSymbol("scrollMc").$("sqrTogBtn").mouseout(function(){
         	sym.getSymbol("scrollMc").getSymbol("sqrTogBtn").$("rollOver").stop().animate ({opacity:0}, 100);
         });
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // MOUSE SCROLL SYMBOL
         var x,left,down;
         sym.getSymbol("scrollMc").$("planeMc").mousedown(function(e){
             e.stopPropagation(); e.preventDefault();
             down=true;
             x=e.pageX;
             left=$(this).scrollLeft();
         });
         
         sym.getSymbol("scrollMc").$("planeMc").mousemove(function(e){
         	e.stopPropagation(); e.preventDefault();
             if(down){
                 var newX=e.pageX;
                 sym.getSymbol("scrollMc").$("planeMc").scrollLeft(left-newX+x);    
             }
         });
         sym.getSymbol("scrollMc").$("planeMc").mouseup(function(e){down=false;});
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         sym.getSymbol("scrollMc").$("mapMc").mousedown(function(e){
             e.stopPropagation(); e.preventDefault();
             down=true;
             x=e.pageX;
             left=$(this).scrollLeft();
         });
         
         sym.getSymbol("scrollMc").$("mapMc").mousemove(function(e){
         	e.stopPropagation(); e.preventDefault();
             if(down){
                 var newX=e.pageX;
                 sym.getSymbol("scrollMc").$("mapMc").scrollLeft(left-newX+x);    
             }
         });
         sym.getSymbol("scrollMc").$("mapMc").mouseup(function(e){down=false;});
         
         
         //--------------------------------------------------------------------------------------------------------
         //----------------------------------------- TEMPLATE CODE BELOW ------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SET STYLE SETTING 
         function setStyle() {
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("styleHead").$("headlineTxt").css({"font-size":headSize, "height":"auto", "width":"auto", "padding":"6px", "padding-top":"6px"});
         	sym.getSymbol("styleHead").$("standTxt").animate({top:0 + sym.getSymbol("styleHead").$("headlineTxt").height()+8}, 0);
         	sym.getSymbol("styleHead").$("headlineTxt").stop().animate({width:stageWidth-90}, 0);
         	sym.getSymbol("styleBase").$("creditTxt").animate({left:stageWidth-120}, 0);
         }
         function setStyleUpdate(){
         	var stageWidth=sym.$("Stage").width();
         	for (var b=0;b<2; b++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+b).$("bg").animate({height:0 + sym.getSymbol("styleHead").$("headlineTxt").height()+12}, 0);
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+b).$("menuIcon").animate({top:(sym.getSymbol("styleHead").$("headlineTxt").height()/2)-14}, 0);
         	}
         	sym.getSymbol("styleHead").$("standTxt").animate({top:0 + sym.getSymbol("styleHead").$("headlineTxt").height()+12}, 0);
         	sym.$("stageWidthTxt").text(stageWidth + "px");
         }
         setStyleUpdate();
         //--------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on('touchstart click', function(e){
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         //--------------------------------------------------------------------------------------------------------
         $(window).on('resize',initSize);
         //--------------------------------------------------------------------------------------------------------
         //-------------------------------------------------- END -------------------------------------------------
         //--------------------------------------------------------------------------------------------------------

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtn_1'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("auxBtnsMc");
   //Edge symbol end:'auxBtnsMc'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'Base'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'menuBtn0'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'scrollableMc'
   (function(symbolName) {   
   
   })("scrollableMc");
   //Edge symbol end:'scrollableMc'

   //=========================================================
   
   //Edge symbol: 'propMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 52, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("propMc");
   //Edge symbol end:'propMc'

   //=========================================================
   
   //Edge symbol: 'scrollMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("scrollMc");
   //Edge symbol end:'scrollMc'

   //=========================================================
   
   //Edge symbol: 'auxBtn_1'
   (function(symbolName) {   
   
   })("auxBtn_1");
   //Edge symbol end:'auxBtn_1'

   //=========================================================
   
   //Edge symbol: 'cockMc'
   (function(symbolName) {   
   
   })("cockMc");
   //Edge symbol end:'cockMc'

   //=========================================================
   
   //Edge symbol: 'cockMc0'
   (function(symbolName) {   
   
   })("cockMc0");
   //Edge symbol end:'cockMc0'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc_1'
   (function(symbolName) {   
   
   })("auxBtnsMc_1");
   //Edge symbol end:'auxBtnsMc_1'

   //=========================================================
   
   //Edge symbol: 'cockMc1'
   (function(symbolName) {   
   
   })("cockMc1");
   //Edge symbol end:'cockMc1'

   //=========================================================
   
   //Edge symbol: 'cockMc2'
   (function(symbolName) {   
   
   })("cockMc2");
   //Edge symbol end:'cockMc2'

   //=========================================================
   
   //Edge symbol: 'menuBtn0_1'
   (function(symbolName) {   
   
   })("menuBtn0_1");
   //Edge symbol end:'menuBtn0_1'

   //=========================================================
   
   //Edge symbol: 'sizeMc'
   (function(symbolName) {   
   
   })("sizeMc");
   //Edge symbol end:'sizeMc'

   //=========================================================
   
   //Edge symbol: 'planeSlideMc'
   (function(symbolName) {   
   
   })("planeMc");
   //Edge symbol end:'planeMc'

   //=========================================================
   
   //Edge symbol: 'mapMc'
   (function(symbolName) {   
   
   })("mapMc");
   //Edge symbol end:'mapMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNews33220");