/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         var gnYear=2015;//2014
         var gnNo=33185;//31990
         
         var showguide=0;//show guide
         var showStats=0;//show statistics
         var matchView=0;//view of matchtracker
         var stageWidth;
         var matchStatus=0;//status of match
         var showstage=0;//show -hide knockout stages
         
         var showLocal=0;
         var teamselect;//from EPL to show team fixtures
         var grpTeams=[];
         var firstGroup=115490;//109475
         var firstKnOut=115528;//109513
         var finalID=1981229;//1981229
         //GET QUERY STRING PARAMETERS TO SHOW MATCH
         var get = [];
         location.search.replace('?', '').split('&').forEach(function (val) {
         	split = val.split("=", 2);
         	get[split[0]] = split[1];
         });
         //REFRESH RATES
         var fixtureInterval, groupInterval, matchInterval, playInterval, headline, headlineMob, notice;
         var screenArr=['latest','overview','matchtracker'];
         for (var i=0; i<2; i++){
         	sym.getSymbol("menuBtns").getSymbol("menuBtn"+i).$("icon").attr('src','images/menuIcon'+i+'.png');
         }
         var menuTxtArr=[];
         var headlinetext=sym.getSymbol("styleMc").$("headlinetxt").css("pointer-events","none");
         var sourcetxt=sym.getSymbol("styleMc").getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         var menuTxt=sym.getSymbol("menuBtns").$("menuTxt").css("pointer-events","none");
         var text=[];
         	text[0]=sym.getSymbol("overview").$("txt0").css("pointer-events","none");
         	text[1]=sym.getSymbol("overview").$("txt1").css("pointer-events","none");
         	for (var t=2;t<15;t++){
         		text[t]=sym.getSymbol("overview").getSymbol("knockout").$("txt"+t).css("pointer-events","none");
         	}
         	text[15]=sym.getSymbol("overview").$("txt15").css("pointer-events","none");
         var txtArr=[]; var teamArr=[]; var tableCaps=[]; var months=[]; var key=[]; var timetxt=[]; var winner=[]; var recordArr=[];
         var qualArr=[]; var rankArr=[]; var trophyArr=[]; var venueArr=[]; var teamShortArr=[]; var zoneArr=[]; var teamAltArr=[]; 
         var guideTxt, timerTxt;
         	sym.getSymbol("overview").$("knockout").on('click',showStages);
         sym.getSymbol("overview").$("up").on('click',showStages);
         sym.getSymbol("overview").$("knockout").css({'cursor':'pointer'});sym.getSymbol("overview").$("up").css({'cursor':'pointer'});
         $(".knockoutCaps").fadeOut(0);
         var teamId=[4206,107227,4012,4014,4231,4017,4019,4034,4038,4301,4054,4067,4716,4222,4080,4771,4094,4103,4009,11,4291,4849,4134,4718,100340,4037,104941,4007,4991,4452,4048,4772];
         
         //AJAX gets data from xml source  --------------------------------------------
         $.ajax({	
         	type: "GET",
         	url: "GN"+gnNo+".xml",
         	dataType: "xml",
         	success: function(xml) {
         		headline=$(xml).find('headline').text();
         		headlineMob=$(xml).find('headlinemob').text();
         		headlinetext.html(headline);
         		var source=$(xml).find('source').text();
         		sourcetxt.html(source);
         		dateFormat=$(xml).find('dateformat').text();//for different date formats
         		for (var m=0;m<2;m++){
         			menuTxtArr[m]= $(xml).find('menuTxt'+m).text();
         		}
         		var matchBtns=$(xml).find("matchBtns").text(); var matchBtnArr=matchBtns.split(";");
               for (var m=0;m<4;m++){
         			sym.getSymbol("matchtracker").getSymbol("matchBtn"+m).$("icon").attr('src','images/matchIcon'+m+'.png');
         			sym.getSymbol("matchtracker").getSymbol("matchBtn"+m).$("menuTxt").html(matchBtnArr[m]);
         			sym.getSymbol("matchtracker").$("matchBtn"+m).on('click',matchMenu(m));
               }
         		for  (var i=0;i<48;i++){
         			txtArr[i]= $(xml).find('txt'+i).text(); //fixed text captions
         			if(i<text.length){
         				text[i].html(txtArr[i]);
         			}
         		}
         		notice=txtArr[47];
         		//instruction page
                  		sym.getSymbol("matchtracker").getSymbol("guide").$("txt2").html(txtArr[36]);	
                  		timerTxt="<div class='action period4'>";//style by period
                  		timerTxt+="<div class='personh'>"+txtArr[37]+"</div>";
                  		timerTxt+="<div class='type'><img src='images/goal.png'></div><div class='actiontime'>"+txtArr[38]+"</div><div class='type'></div><div class='persona'></div>";
                  		timerTxt+="</div>";
                  		timerTxt+="<div class='action period4'>";
                  		timerTxt+="<div class='personh'></div><div class='type'></div><div class='actiontime'>"+txtArr[39]+"</div><div class='type'><img src='images/sub.png'></div><div class='persona'>"+txtArr[40]+"</div>";
                  		timerTxt+="</div>";
                  		timerTxt+="<div class='action period4'>";
                  		timerTxt+="<div class='personh'></div><div class='type'></div><div class='actiontime'>"+txtArr[41]+"</div><div class='type'><img src='images/yellow.png'></div><div class='persona'>"+txtArr[42]+"</div>";
                  		timerTxt+="</div>";
                  		guideTxt="<img src='images/samplestats.png'>";
                  		guideTxt+=txtArr[20]+", "+txtArr[21]+", "+txtArr[22]+", "+txtArr[23];
         
         		sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt0").html(txtArr[24]);
         		sym.getSymbol("matchtracker").$("txt16").html(txtArr[17]);
         		sym.getSymbol("matchtracker").$("txt17").html(txtArr[17]);
         		sym.getSymbol("matchtracker").getSymbol("matchStats").$("txt18").html(txtArr[20]);
         		sym.getSymbol("latest").getSymbol("latestTable").$("txt0").html(menuTxtArr[0]);
         		var tableHeadCaps = $(xml).find('table0').text();
         		tableCaps=tableHeadCaps.split(";");
         		var tableHead ="<table class='thead'><tr><td class='rowflag'></td><td class='rowname'></td>";
         		tableHead +="<td class='rowwon'>"+tableCaps[0]+"</td>";
         		tableHead +="<td class='rowdraw'>"+tableCaps[1]+"</td>";
         		tableHead +="<td class='rowlost'>"+tableCaps[2]+"</td>";
         		tableHead +="<td class='rowf'>"+tableCaps[3]+"</td>";
         		tableHead +="<td class='rowa'>"+tableCaps[4]+"</td>";
         		tableHead +="<td class='rowpts'>"+tableCaps[5]+"</td><";
         		tableHead +="/tr></table>";
         		sym.getSymbol("overview").$("tableHead").append(tableHead);
         		$(".thead").css({'width':'99%','position':'absolute','font-family':'pragmatica-web, sans-serif','font-weight':700,'border':'none','border-collapse':'collapse','font-size':'12px','margin':'0 1px'});
         		$(".rowflag").css({'width':'7%'});
         		$(".rowname").css({'width':'38%','text-align':'left'});
         		$(".rowwon, .rowdraw, .rowlost").css({'width':'7%','text-align':'center'});
         		$(".rowf, .rowa").css({'width':'8%','text-align':'right'});
         		$(".rowpts").css({'width':'11%','text-align':'right','padding-right':'2px','font-weight':700});
         		var tooltipCaps = $(xml).find('table1').text();//tool tip for group table
         		sym.getSymbol("overview").$("tooltip0").html(tooltipCaps);
         		sym.getSymbol("overview").$("tooltip0").css({'background-color':'rgb(255,235,165)','border':'solid 1px rgb(0,0,0)','border-radius':'2px','display':'none'});
               var monthsArr = $(xml).find('months').text();
                  months=monthsArr.split(";");
               var keyArr = $(xml).find('key').text();
                  key=keyArr.split(";");
               var timeArr = $(xml).find('time').text();
                  timetxt=timeArr.split(";");
               var winArr = $(xml).find('winner').text();
               winner=winArr.split(";");
               sym.getSymbol("latest").getSymbol("latestTable").getSymbol("timezone").$("timezoneTxt").html(timetxt[0]); 
               for (var t=0;t<32;t++){		//get details for each team
         			$(xml).find("team"+t).each(function(){
         				var $teams = $(this);
         				teamArr[t]=$teams.find('name').text();
         				teamAltArr[t]=$teams.find('teamalt').text();
         				venueArr[t]=$teams.find('home').text();
         				teamShortArr[t]=$teams.find('teamshort').text();
         				zoneArr[t]=$teams.find('zone').text();
         			});
               }
         	},
                  	complete:function(){
                  		setTimeout(openMatch,400);
                  		initSize();
                  	}
         });
         
         //------------------------------------RESPONSIVE
         var matchArr=['h2hMc','timer','matchStats','teams','guide'];
         function initSize(){
         	stageWidth=sym.$("Stage").width();
         	sym.getSymbol("matchtracker").stop(stageWidth*10);
         	sym.getSymbol("matchtracker").getSymbol("teams").stop(stageWidth*10);
         	sym.getSymbol("matchtracker").getSymbol("h2hMc").stop(stageWidth*10);
         	sym.getSymbol("overview").getSymbol("knockout").stop(stageWidth*10);
         	sym.getSymbol("styleMc").stop(stageWidth*10);
         	var btnWidth=sym.getSymbol("matchtracker").$("matchBtn0").width();
         	if(matchStatus>=8){ sym.getSymbol("matchtracker").$("clock").fadeIn(0);matchView=1; }
         	for (var i=0;i<4;i++){
         		sym.getSymbol("matchtracker").getSymbol("matchBtn"+i).$("icon").css({'left':btnWidth/2-18+'px'});	
         		i==matchView?(sym.getSymbol("matchtracker").$(matchArr[matchView]).fadeIn(0),sym.getSymbol("matchtracker").getSymbol("matchBtn"+matchView).$("menuBg").css({'opacity':0.75})):
         		(sym.getSymbol("matchtracker").$(matchArr[i]).fadeOut(0),sym.getSymbol("matchtracker").getSymbol("matchBtn"+i).$("menuBg").css({'opacity':0.25}));
         		if (stageWidth>=640){var xtraPanel= (matchView==3)?(matchStatus<8)?0:1:3; sym.getSymbol("matchtracker").$(matchArr[xtraPanel]).fadeIn(0);
         		}else{
         			if(matchView==3){ showguide=0;}
         		}
         	}
         	showguide==0?sym.getSymbol("matchtracker").$("guide").fadeOut(0):sym.getSymbol("matchtracker").$("guide").fadeIn(0);
         	var statWidth=sym.getSymbol("matchtracker").$("matchStats").width();
         	sym.getSymbol("matchtracker").getSymbol("matchStats").$("chartHolder").css({'left':statWidth/2-72+'px'});
         	if(stageWidth<640){
         		$(".longname, .longdate").fadeOut(0);$(".shortname, .altname, .shortdate").fadeIn(0);
         		$(".fixName").css({'width':'10%'});
         		sym.getSymbol("overview").$("txt15").fadeOut(0);sym.getSymbol("overview").getSymbol("knockout").$("txt14").fadeOut(0);
         		sym.getSymbol("overview").$("tipBtn0").fadeOut(0);
         		headlinetext.html(headlineMob);
         		$(".venuef, .localtime, .venuetime").css({"font-size":"12px"});
         		sym.getSymbol("latest").$("latestTable").css({'width':'100%','height':'495px','left':'0px','top':'0px'});
         		sym.getSymbol("latest").getSymbol("latestTable").$("table").css({'height':'450px'});
         	}else{
         		$(".longname, .longdate").fadeIn(0);$(".shortname, .altname, .shortdate").fadeOut(0);
         		$(".fixName").css({'width':'40%'});
         		sym.getSymbol("overview").$("txt15").fadeIn(0);
         		showstage==0?sym.getSymbol("overview").getSymbol("knockout").$("txt14").fadeOut(0):sym.getSymbol("overview").getSymbol("knockout").$("txt14").fadeIn(0)
         		sym.getSymbol("overview").$("tipBtn0").fadeIn(0);
         		headlinetext.html(headline);
         		$(".venuef, .localtime, .venuetime").css({"font-size":"13px"});//Nov 13
         		sym.getSymbol("latest").$("latestTable").css({'width':'87.5%','left':'6.3%','height':'482px','top':'7px'});
         		sym.getSymbol("latest").getSymbol("latestTable").$("table").css({'height':'437px'});
         	}
         	if(stageWidth<480){
         		$(".rowwon, .rowdraw, .rowlost, .rowf, .rowa, .venuef").fadeOut(0);
         		sym.$("bg").css('opacity',0.2);
         		$('.teamf').css({'font-size':'13px','font-weight':400});
         		$(".localtime, .venuetime").css({'font-style':'italic'});
         		$(".clock, .att, .matchtime, .city").fadeOut(0);
         		$('.scoref').css({'width':'20%'});
         		menuTxt.css({'opacity':0});
         		$(".crestf").css({"width":"15%"});
         	}else{
         		$(".rowwon, .rowdraw, .rowlost, .rowf, .rowa, .venuef").fadeIn(0);
         		sym.$("bg").css('opacity',0.5);
         		$('.teamf').css({'font-size':'14px','font-weight':700});
         		$(".localtime, .venuetime").css({'font-style':'normal'});
         		$(".clock, .att, .matchtime, .city").fadeIn(0);
         		$('.scoref').css({'width':'30%'});
         		menuTxt.css({'opacity':1.0});
         		$(".crestf").css({"width":"8%"});
         	}
         	if(stageWidth<400){
         		$(".flag").fadeOut(0);
         	}else{
         		$(".flag").fadeIn(0);
         	}
         }
         var wWidth = $(window).width();
         $(window).resize(function(){
           if(wWidth != $(window).width()){
             initSize();
             wWidth = $(window).width();
           }
         });
         //--------------------------TOOL TIP FOR GROUP TABLE
         sym.getSymbol("overview").$("tableHead").on('click',showTip);
         var showtip=0;
         function showTip(){
         	if (showtip==0){
         		sym.getSymbol("overview").$("tooltip0").fadeIn(0);
         		showtip=1;
         	}else{
         		sym.getSymbol("overview").$("tooltip0").fadeOut(0);
         		showtip=0	
         	}
         }
         //GROUP FIXTURE TABLE
         function rowColOver(e){
                  	$(this).css({'background-color':'rgba(255,0,0,1.0)','color':'rgba(255,255,255,1.0)','font-weight':700});
                  	var row = (e.data.row);
                  	var col = (e.data.col);
                  	var group = (e.data.group);
                  	for(var c=0;c<teamId.length; c++){
                  			if(row==teamId[c]){
                  				var x=teamId[c];         				
                  			}
                  			if(col==teamId[c]){
                  				var y=teamId[c];         				
                  			}
                  			for(var t=0;t<teamId.length;t++){
                  				$("#m"+group+"_h"+x+"_a"+teamId[t]).addClass("view");
                  				$("#m"+group+"_h"+teamId[t]+"_a"+y).addClass("view");
                  			}
                  		}
                  	$(".view").css({'background-color':'rgba(255,180,0,0.2)'});
         }
         function rowColOut(e){
                  	$(this).css({'background-color':'rgba(255,255,255,0)','color':'rgba(0,0,0,1.0)','font-weight':400});
                  	var row = (e.data.row);
                  	var col = (e.data.col);
                  	var group = (e.data.group);
                  	for(var c=0;c<teamArr.length; c++){
                  		if(row==teamId[c]){
                  				var x=teamId[c];
                  		}
                  		if(col==teamId[c]){
                  				var y=teamId[c];
                  		}
                  		for(var t=0;t<teamArr.length;t++){
                  			$("#m"+group+"_h"+x+"_a"+teamId[t]).removeClass("view");
                  			$("#m"+group+"_h"+teamId[t]+"_a"+y).removeClass("view");
                  		}
                  	}		
                  	$(".green").css({'background-color':'rgba(215,230,245,1.0)'});
                  	$(".white").css({'background-color':'rgba(255,255,255,0.8)'});
                  	$(".noMatch").css({'background-color':'rgba(235,240,250,1.0)'});
         }
         // MENU BUTTONS --------------------------------------------	
                  menuArray = []; //the array that will hold references to the buttons.
                  for (var m = 0; m < 2; m++){
                  		var menuBtnSymbols = sym.getSymbol("menuBtns").getSymbol("menuBtn" +m); // Create an instance element of a symbol as a child of the given parent element
                  		menuBtnSymbols.setVariable("menuId", m); //set the value of a Symbol variable
                  		menuArray.push(menuBtnSymbols); //push it into the array
                  	}
                  $.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
                  		var menuBtnItem = $(menuInTheArray); //create jQuery reference to the item
                  		var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
                  		menuBtnElement.on ("click", {menuId:count}, menuBtnClick);
                  		menuBtnElement.on ("touchstart click", {menuId:count}, menuBtnClick);
                  		menuBtnElement.on ("mouseover", {menuId:count}, menuShow);
                  		menuBtnElement.on ("mouseout", {menuId:count}, menuHide);
                  		menuBtnElement.css({"cursor":"pointer"});
                  })
                  function resetmenu(){
                  		for (var m=0; m<menuArray.length; m++){	
                           menuArray[m].$("menuBg").fadeOut(0);
                  		}
                  		menuTxt.fadeOut(0);
                  }
                  resetmenu();
                  function menuBtnClick (e){
                  		e.preventDefault();
                  		e.stopPropagation();
                  		resetmenu(); //set them all back to normal state
                  		clearInterval(matchInterval);
         					clearInterval(playInterval);
                  		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
         					for (var i=0;i<3;i++){
         						if (menuMenu_id==i){
         							sym.$(screenArr[i]).fadeIn(400);
         							sym.getSymbol("menuBtns").getSymbol("menuBtn" + i).$("menuBg").fadeIn(0);
         							menuTxt.html(menuTxtArr[i]);
         							menuTxt.fadeIn(0);
         						}else{
         							sym.$(screenArr[i]).fadeOut(400);
         						}						 
         					}
                  }
                  function menuShow (e){
                  		var menuMenu_id = (e.data.menuId); //get the id of the over button
                  		//sym.$('handMc').hide();
                  		menuTxt.html(menuTxtArr[menuMenu_id]);
         					menuTxt.fadeIn(0);
                  }
                  function menuHide (e){
                  		var menuMenu_id = (e.data.menuId); //get the id of the out button
                  		menuTxt.fadeOut(0);
                  }
         sym.getSymbol("menuBtns").getSymbol("menuBtn0").$("menuBg").fadeIn(0);	
         //MATCH MENU
         function makeGuide(n){
         	sym.getSymbol("matchtracker").getSymbol("guide").$("txt2").empty();
         	//var title=(n==1)?2:11;
         	var title=(n==1)?36:45;
         	var txtObj=(n==1)?timerTxt:guideTxt;
         	sym.getSymbol("matchtracker").getSymbol("guide").$("txt2").html(txtArr[title]);
         	sym.getSymbol("matchtracker").getSymbol("guide").$("txt2").append(txtObj);
         	$('.action').css({'display':'inline-table','height':'20px','width':'100%','font-size':'12px','font-family':'pragmatica-web, sans-serif','text-align':'left','border-bottom':'solid 1px rgb(150,150,150)','border-top':'solid 1px rgba(255,255,255,0.6)'});
            $(".period4").css({'background-color':'rgba(255,170,50,0.1)'});
            $('.personh').css({'text-align':'right','display':'table-cell','width':'37%'});
            $('.actiontime').css({'background-color':'rgba(100,100,100,0.6)','text-align':'center','display':'table-cell','width':'12%','color':'rgb(255,255,255)'});
            $('.type').css({'display':'table-cell','width':'7%','text-align':'center'});
            $('.persona').css({'text-align':'left','display':'table-cell','width':'37%'});
            $(".action img").css({'width':'20px'});
         }
         var matchMenu = function(n){ //to handle lexical scope
         	return function (e) {
         		for (i=0;i<4;i++){
         			if (i==n){
         				matchView=n;
         				sym.getSymbol("matchtracker").getSymbol("matchBtn"+n).$("menuBg").animate({'opacity':0.75},0);
         				if(stageWidth<640||i<3){
         					if(matchStatus<8&&(n==1||n==2)){
         						makeGuide(n); sym.getSymbol("matchtracker").$(matchArr[4]).fadeIn(600);showguide=1;
         					}else{
         						sym.getSymbol("matchtracker").$(matchArr[n]).fadeIn(600); sym.getSymbol("matchtracker").$(matchArr[4]).fadeOut(600);showguide=0;					
         					}
         				}else{
         					sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquadh").css({'box-shadow':'0px 0px 6px rgba(7,102,102,0.8)'});
         					sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquada").css({'box-shadow':'0px 0px 6px rgba(7,102,102,0.8)'});
         				}					
         			}else{
         				if(stageWidth<640){
         					sym.getSymbol("matchtracker").$(matchArr[i]).fadeOut(600);
         				}else{
         					if(i<3&&n<3){
         						sym.getSymbol("matchtracker").$(matchArr[i]).fadeOut(600);
         					}
         				}
         				sym.getSymbol("matchtracker").getSymbol("matchBtn"+i).$("menuBg").animate({'opacity':0.25},0);
         				sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquadh").css({'box-shadow':'inset 3px 3px 3px rgba(100,100,100,0.5)'});
         				sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquada").css({'box-shadow':'inset 3px 3px 3px rgba(100,100,100,0.5)'});
         			}														
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };      			
         //----------------------------------------
         var showguide=0;
         function showGuide(){
         	if(showguide==0){
         		sym.getSymbol("matchtracker").$("guide").fadeIn(600);
         		showguide=1;
         	}else{
         		sym.getSymbol("matchtracker").$("guide").fadeOut(600);
         		showguide=0;
         	}
         }
         var timeZone=sym.getSymbol("latest").getSymbol("latestTable").$("timezone");var timeZoneTxt=sym.getSymbol("latest").getSymbol("latestTable").getSymbol("timezone").$("timezoneTxt");
         timeZone.css({'cursor':'pointer'});timeZone.on("click",timeZoneClick);timeZone.on("mouseover",timeZoneOver);timeZone.on("mouseout",timeZoneOut);
         function timeZoneClick(){
         	showLocal=(showLocal==0)?($(".localtime").fadeIn(0),$(".venuetime").fadeOut(0),1):($(".localtime").fadeOut(0),$(".venuetime").fadeIn(0),0); 
         	timeZoneTxt.html(timetxt[showLocal]);
         }
         function timeZoneOver(){
         	showLocal==0?timeZoneTxt.html(timetxt[1]):timeZoneTxt.html(timetxt[0]);
         }
         function timeZoneOut(){
         	showLocal==0?timeZoneTxt.html(timetxt[0]):timeZoneTxt.html(timetxt[1]);
         }
         //DATE FUNCTIONS --------------------------------------------
         var startWC= Date.parse("September 15, 2015, 19:45 UTC");
         var startR2= Date.parse("January 1, 2016, 00:01 UTC");
         var endR2= Date.parse("March 17, 2016, 00:01 UTC");
         var endQF=Date.parse("April 14, 2016, 00:01 UTC");
         var endSF=Date.parse("May 5, 2016, 00:01 UTC");
         var endWC = Date.parse("May 28, 2016, 23:59 UTC");
         var gmtStart = Date.parse("October 25, 2015, 01:59 UTC");
         var gmtEnd = Date.parse("March 27, 2016, 00:59 UTC");
         var oneDay = 86400000;
         var todayDate = new Date();
         var todayTime = todayDate.getTime();
         var localOffset=todayDate.getTimezoneOffset()*60000;
         var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://www.graphicnews.org/")+ "infostradasports/api.php";
         var dateFormat;//for different date formats
         function getDDMMYY(thisDateStr) {
                     var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
                     //var thisDate = new Date(parseInt(dateTxt, 10));
                     var thisDate = new Date(parseInt((dateTxt+localOffset), 10));
                     var mm = thisDate.getMonth() + 1;
                     var dd = thisDate.getDate();
                     mm = ((mm < 10) ? '0' : "") + mm;
                     dd = ((dd < 10) ? '0' : "") + dd;
                     return dd + "/" + mm + "/" + (thisDate.getFullYear()).toString();
                 }
         function getDDmonthYY(thisDateStr,adjust) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	//var matchDate=thisDate.getTime() +localOffset+adjust;
         	var matchDate=(adjust>0)?thisDate.getTime() +adjust:thisDate.getTime() +localOffset+adjust;
         	var matchTime=new Date(matchDate);
         	//var mm = matchTime.getUTCMonth();
         	var mm = matchTime.getMonth();
         	//var dd = matchTime.getUTCDate();
         	var dd = matchTime.getDate();
         	//return months[mm] + " " + dd +", "+ (thisDate.getFullYear()).toString();
         	if (dateFormat=="dayMonth"){ //allows different date formats
         		return dd.toString() +months[mm];
         	}else{
         		return months[mm] + " " + dd.toString();
         	}
         }
         function getMMDD(thisDateStr,adjust) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	//var matchDate=thisDate.getTime() +localOffset+adjust;
         	var matchDate=(adjust>0)?thisDate.getTime() +adjust:thisDate.getTime() +localOffset+adjust;
         	var matchTime=new Date(matchDate);
         	var mm = matchTime.getMonth();
         	var dd = matchTime.getDate();
         	if (dateFormat=="dayMonth"){ //allows different date formats
         		return (mm+1).toString()  + "/" + dd.toString();
         	}else{
         		return dd.toString()  + "/" + (mm+1).toString() ;
         	}
         } 
         function getDateLocal(thisDateStr) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var mm = thisDate.getMonth();
         	var dd = thisDate.getDate();
         	//return months[mm] + " " + dd +", "+ (thisDate.getFullYear()).toString();
         	if (dateFormat=="dayMonth"){ //allows different date formats
         		return dd.toString() +months[mm];
         	}else{
         		return months[mm] + " " + dd.toString();
         	}
         }
         function getMatchTime(thisDateStr,braziltime){
         	var timeTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(timeTxt, 10));
         	var thisTime = thisDate.getTime()+localOffset-braziltime;//localOffset to UTC - offset to Brazil
         	var matchTime = new Date(thisTime);
         	var hh = matchTime.getHours();
         	var mm = parseInt(matchTime.getMinutes(),10);
         	mm=(mm<10)?"0"+mm:mm;
         	return hh+":"+mm;	
         }
         function getMatchLocal(thisDateStr){
         	var timeTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(timeTxt, 10));
         	var hh = thisDate.getHours();
         	var mm = parseInt(thisDate.getMinutes(),10);
         	mm=(mm<10)?"0"+mm:mm;
         	return hh+":"+mm;
         }
         function parsedDate(thisDateStr){
         	var matchRndDate = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	//var dDate = parseInt(matchRndDate,10);
         	var dDate = parseInt(matchRndDate,10)+localOffset;
         	return dDate;
         } 
         var offsetVenue;//Offset between time at venue and UTC
         function getDST(thisDateStr,offsetZone){
         	var thisDate = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf('+'));
         	if(thisDate<gmtStart||thisDate>gmtEnd){
         		var offsetUTC = -3600000-offsetZone;
         	}else{
         		var offsetUTC = 0-offsetZone;
         	}
         	return offsetUTC;
         }
         //------------------------------------------------SHOW HIDE KNOCKOUT STAGES
         function showStages(){
         	e.preventDefault();
         	e.stopPropagation();
         	if(showstage==0){
         		$(".knockoutCaps").fadeIn(500);//show ko captions
         		$(".groupCaps").fadeOut(500);//hide grp captions
         		$(".kstage").fadeIn(500);
         		sym.getSymbol("overview").$("up").fadeOut(0);
         		sym.getSymbol("overview").$("down").delay(400).fadeIn(300);
         		for (var i=1; i<=8; i++){
         			var moveIt=Math.floor((i-1)/2);
         			sym.getSymbol("overview").getSymbol("groupStage").$("group"+(i)).stop().animate({'height':'35px','top':16+(moveIt*42)},500, 'easeOutQuad');
         		}
         		sym.getSymbol("overview").$("groupStage").animate({'height':'190px'},500, 'easeOutQuad');	
         		sym.getSymbol("overview").$("knockout").off('click');
         		sym.getSymbol("overview").$("groupStage").on('click',showStages);
         		sym.getSymbol("overview").$("groupStage").css({'cursor':'pointer'});
         		sym.getSymbol("overview").$("knockout").css({'cursor':'auto'});
         		sym.getSymbol("overview").play();
         		showstage=1;
         	}else if(showstage==1){
         		$(".knockoutCaps").fadeOut(500);//show ko captions
         		$(".groupCaps").fadeIn(500);//hide grp captions
         		$(".kstage").fadeOut(500);
         		sym.getSymbol("overview").$("up").delay(400).fadeIn(300);
         		sym.getSymbol("overview").$("down").fadeOut(0);
         		for (var i=1; i<=8; i++){
         			var moveIt=Math.floor((i-1)/2);
         			sym.getSymbol("overview").getSymbol("groupStage").$("group"+(i)).animate({'height':'80px','top':16+(moveIt*101)},500, 'easeInQuad');
         			$("#gt"+i).css({'display':'none'});
         		}
         		sym.getSymbol("overview").$("groupStage").animate({'height':'405px'},500);	
         		sym.getSymbol("overview").$("knockout").on('click',showStages);
         		sym.getSymbol("overview").$("groupStage").off('click');
         		sym.getSymbol("overview").$("knockout").css({'cursor':'pointer'});
         		sym.getSymbol("overview").$("groupStage").css({'cursor':'auto'});
         		sym.getSymbol("overview").playReverse();
         		showstage=0;
         	}
         	initSize();
         }
         if(todayTime<startR2){
         	sym.getSymbol("overview").$("down").fadeOut(0);
         }else{
         	showStages();
         }
         function loadMatch(match){
         		resetmenu();
         		sym.getSymbol("matchtracker").$("timer").empty();//Sep 17
         		matchView=0;//Sep 17		
         		clearInterval(matchInterval);
         		clearInterval(playInterval);
         		matchInterval = setInterval(function() { getMatchInfo(match); }, 60000);
         		playInterval = setInterval(function() { getMatch(match); }, 60000);
         		getMatchInfo(match);
         		getMatch(match);
         		sym.$("matchtracker").fadeIn(400);
         		sym.$("overview").fadeOut(400);
         		sym.$("latest").fadeOut(400);
         		sym.getSymbol("matchtracker").$("preloaderh").fadeIn(0);
         		sym.getSymbol("matchtracker").$("preloadera").fadeIn(0);
         		showguide=0;
         		sym.getSymbol("matchtracker").$("guide").fadeOut(0)
         }
         var showMatch = function(match){ //to handle lexical scope
         	return function (e) {
         		loadMatch(match);
         		e.preventDefault();
         		e.stopPropagation();
         	};
         };
         function openMatch(){
         	 if (get["match"] + "" != "undefined"){// Check if there is a matchID
         		var startMatch=parseInt(get["match"],10);
         		loadMatch(startMatch);
         		sym.$("cup").animate({opacity:0.3},1000);
         		sym.$("bg").animate({opacity:0.25},1000);
         	}else if(todayDate>endSF){
         		loadMatch(finalID);//load Final
         		sym.$("cup").animate({opacity:0.3},1000);
         		sym.$("bg").animate({opacity:0.25},1000);
         	}else{
         		sym.play();
         	}
         }
         //TOGGLE SHOWMATCHES
         var groupShow;
         var showMatches = function(group){ //to handle lexical scope
         	return function (e) {
         		if(showstage==0){		
         			if(groupShow==group){
         				sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).animate({'height':'80px'},300);
         				$("#gt"+group).css({'display':'none'});
         				groupShow="";
         			}else{			
         				for (var i=1;i<=8;i++){
         					if (group==i){
         						$("#gt"+group).css({'display':'block'});
         						sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).animate({'height':'183px'},300);
         					}else{
         						sym.getSymbol("overview").getSymbol("groupStage").$("group"+i).animate({'height':'80px'},300);
         						$("#gt"+i).css({'display':'none'});
         					}
         				}
         				groupShow=group;
         			}
         		}
         		e.preventDefault();
         	};
         };
         function teamName(n){
         
         }
         //LIVE DATA --------------------------------------
         function getDetails(groupIndex) {
                  	var group = groupIndex - 1;
                  	var id = firstGroup + group;
                  	$.ajax({ type: "GET", url: dataURL,
                  		data: "gn="+gnNo+"&yr="+gnYear+"&phaseID=" + id,
                  		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  		async: true,
                  		crossDomain: true,
                  		error: function () {
                  			console.log("Error retrieving Group[" + groupIndex + "]");
                  		},
                  		success: function (groupDetails) {
                  				for (var i = 0; i < 4; i++) { //create array of team Ids in each group
                  					grpTeams[i]=groupDetails[i].n_TeamID;
         							}
                  			loadDetails(groupDetails, group);
                  		}
                  	});
         }
         function loadDetails(groupDetails, group) {
         	var imgHTML;
         	for (var i = 0; i < 4; i++) { //Create group fixtures crests
         		var teamName=groupDetails[i].c_Team;
         		var teamShort, teamAlt;
         		for(var c=0;c<32;c++){
         			if (groupDetails[i].n_TeamID==teamId[c]){
         				teamName=teamArr[c]; teamShort=teamShortArr[c]; teamAlt=teamAltArr[c];
         				var crestHTML="<img src='crests/"+teamId[c]+".png' id='teamBtn"+c+"'>"+teamShortArr[c];
         			}
               } 
               var fixTxt="<table class='fixtable'>"; //Create group fixtures table
               fixTxt+="<tr class='fixHead'><td class='fixName' id='fixName"+group+"_"+i+"'></td>";
               for(var t=0;t<4; t++){
         			if(t==i){
         				fixTxt+="<td class='matchBox noMatch' id='m"+group+"_"+i+"_"+t+"'>";	
         			}else{
         				if((i%2==0&&t%2==0)||(i%2>0&&t%2>0)){
         					fixTxt+="<td class='matchBox green' id='m"+group+"_h"+grpTeams[i]+"_a"+grpTeams[t]+"'>";	
         				}else{
         					fixTxt+="<td class='matchBox white' id='m"+group+"_h"+grpTeams[i]+"_a"+grpTeams[t]+"'>";	
         				}	
         			}				
         		}
               fixTxt+="</tr>";
               fixTxt+="</table>";
               $('#tab'+group).append(fixTxt);
         		$('#g' + group + "_" + i).html(crestHTML);
         		$('#fixName'+group+"_"+i).html("<span class='longname'>"+(teamName.length>16?teamAlt:teamName)+"</span><span class='shortname'>"+teamShort+"</span>");
         		$('#t' + group + 'n' + i).html("<span class='longname'>"+(teamName.length>16?teamAlt:teamName)+"</span><span class='altname'>"+(teamName.length>12?teamAlt:teamName)+"</span>"); //Create group tables
         		$('#t' + group + 'p' + i).text(groupDetails[i].n_Matches);
         		$('#t' + group + 'w' + i).text(groupDetails[i].n_MatchesWon);
         		$('#t' + group + 'd' + i).text(groupDetails[i].n_MatchesDrawn);
         		$('#t' + group + 'l' + i).text(groupDetails[i].n_MatchesLost);
         		$('#t' + group + 'f' + i).text(groupDetails[i].n_GoalsFor);
         		$('#t' + group + 'a' + i).text(groupDetails[i].n_GoalsAgainst);
         		$('#t' + group + 'pts' + i).text(groupDetails[i].n_Points);
         		imgHTML='<img src="flags/'+(groupDetails[i].c_TeamNatioShort) +'.png" height="12px" width="22px">';
         		$('#t' + group + 'flag' + i).html(imgHTML);
         		$(".fixtable").css({'width':'100%','font-size':'11px', 'font-family':'pragmatica-web,sans-serif','border':'none','border-collapse':'collapse'});
               $(".fixName").css({'width':'40%','padding-left':'4px'});
               $(".matchBox").css({'width':'15%','font-size':'11px','text-align':'center'});
               $(".noMatch").css({'background-color':'rgba(235,240,250,1.0)','box-shadow':'inset rgba(100,100,100,0.5) 1px 2px 1px 1px'});//0,0,0,0.4
               $(".green").css({'background-color':'rgba(215,230,245,1.0)'});//202,232,226,0.6 
               $(".white").css({'background-color':'rgba(255,255,255,0.8)'});
               $(".matchBox img").css({'width':'20px'});
               $(".matchBox.fixHead").css({'font-size':'11px', 'font-family':'pragmatica-web,sans-serif','font-weight':400});
         
         		$(".grp").css({'width':'99%','position':'absolute','background-color':'rgb(215,230,245)','font-family':'pragmatica-web, sans-serif','border':'none','border-collapse':'collapse','font-size':'12px','margin':'0 1px'});
         		$(".toprow").css({'background-color':'rgb(235,240,250)'});
         		$(".rowflag").css({'width':'7%'});
         		$(".rowname").css({'width':'38%','text-align':'left'});
         		$(".rowwon, .rowdraw, .rowlost").css({'width':'7%','text-align':'center'});
         		$(".rowf, .rowa").css({'width':'8%','text-align':'right'});
         		$(".rowpts").css({'width':'11%','text-align':'right','padding-right':'2px','font-weight':700});
         	}
         } 
         var resultsData;
         function getGroupResults() {
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gnNo+"&yr="+gnYear+"&editionID=21763",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			resultsData = data;
         			for (var group = 1; group <= 8; group++) {
         				sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).empty();
         				sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).off('click');
         				var tableTxt= "<div id='gt" + group + "' style='display:none; position:absolute; bottom:3px; width:100%'>"; 
         				tableTxt+="<table class='fixtable'>";
                     tableTxt+="<tr class='fixHead'><td class='fixName'>"+txtArr[33]+"</td>";
                       	for (var c=0; c<4; c++){
                           tableTxt+="<td class='matchBox fixHead' id='g"+(group-1)+"_"+c+"'></td>";
                        }
                        tableTxt+="</tr><tr><td colspan='5' id='tab"+(group-1)+"'></td></tr></table>";
         				tableTxt+="</div>";   
         				tableTxt += "<div id='grptable"+group+"'>";
         				tableTxt +="<table class='grp'>";
         				for (var t=0;t<4;t++){
         					tableTxt +=(t<2)?"<tr class='toprow'>":"<tr>";
         					tableTxt +="<td class='rowflag' id='t"+ (group - 1) + "flag"+t+"'></td>";
         					tableTxt +="<td class='rowname' id='t" + (group - 1) + "n"+t+"'></td>";
         					tableTxt +="<td class='rowwon' id='t" + (group - 1) + "w"+t+"'></td>";
         					tableTxt +="<td class='rowdraw' id='t" + (group - 1) + "d"+t+"'></td>";
         					tableTxt +="<td class='rowlost' id='t" + (group - 1) + "l"+t+"'></td>";
         					tableTxt +="<td class='rowf' id='t" + (group - 1) + "f"+t+"'></td>";
         					tableTxt +="<td class='rowa' id='t" + (group - 1) + "a"+t+"'></td>";
         					tableTxt +="<td class='rowpts' id='t" + (group - 1) + "pts"+t+"'></td></tr>";
         				}
         				tableTxt +="</table>";
         				tableTxt += "<table style='position:absolute; top:0px; width:165px; background-color:rgb(215,230,245); border:none; border-collapse:collapse; font-family:pragmatica-web, sans-serif; font-size:12px'>";
         				tableTxt += "</div>";			
         				sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).append(tableTxt);
         				getDetails(group);
         				sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).on('click', showMatches(group));
         				sym.getSymbol("overview").getSymbol("groupStage").$("group"+group).css({'cursor':'pointer'});
         			} 
         			getTeamFixtures();
         		}
         	});
         }
         var fixtureData;   
         function getTeamFixtures() { 
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gnNo+"&yr="+gnYear+"&editionID=21763",// 17694
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			fixtureData = data;
         			for (var k=1;k<9;k++){
         				sym.getSymbol("overview").getSymbol("knockout").$("r16-"+k).empty();
         				sym.getSymbol("overview").getSymbol("knockout").$("qf"+k).empty();
         				sym.getSymbol("overview").getSymbol("knockout").$("sf"+k).empty();
         			}
         			sym.getSymbol("overview").getSymbol("knockout").$("ru").empty();	
         			sym.getSymbol("overview").getSymbol("knockout").$("final").empty();
         			sym.getSymbol("latest").getSymbol("latestTable").$('table').empty();
         			var showLatest=0;var lastMatches=0; var nextMatches=0;
         			for (var i = 0; i < fixtureData.length; i++) {
         				var phaseLevel = fixtureData[i].n_PhaseLevel;
         				if (phaseLevel<=17){
         					var matchesRnd = parsedDate(fixtureData[i].d_DateUTC);
         					var matchDay = fixtureData[i].n_PhaseID;
         					var matchNo = fixtureData[i].n_KnockoutPhaseID;
         					var matchID = fixtureData[i].n_MatchID;
         					var homeTeamID=(fixtureData[i].n_HomeTeamID>0)?fixtureData[i].n_HomeTeamID:"null";
         					var awayTeamID=(fixtureData[i].n_AwayTeamID>0)?fixtureData[i].n_AwayTeamID:"null";
         					var homeNationShort = (!fixtureData[i].c_HomeTeamNatioShort)?"null":fixtureData[i].c_HomeTeamNatioShort;
         					var awayNationShort = (!fixtureData[i].c_AwayTeamNatioShort)?"null":fixtureData[i].c_AwayTeamNatioShort;
         					var stad=fixtureData[i].c_Stadium;
         					var teamHome, teamAway, timeZone, offsetVenue, matchTime, matchDate, localTime, venueTime, offsetZone, city,teamAltH, teamAltA, matchddmm;//Nov 13
         					var imgH = '<img src="flags/'+ homeNationShort +'.png">';
         					var imgA = '<img src="flags/'+ awayNationShort +'.png">';
         					var crestH = '<img src="crests/'+ homeTeamID +'.png">';
         					var crestA = '<img src="crests/'+ awayTeamID +'.png">';
         					teamHome=fixtureData[i].c_HomeTeam;teamAltH=fixtureData[i].c_HomeTeam;teamHshort=fixtureData[i].c_HomeTeamShort;city=fixtureData[i].c_City;
         					teamAway=fixtureData[i].c_AwayTeam;teamAltA=fixtureData[i].c_AwayTeam;teamAshort=fixtureData[i].c_AwayTeamShort;
         					for(var c=0;c<32;c++){
         						if (homeTeamID>0){
         							if (homeTeamID==teamId[c]){
         								teamHome=teamArr[c];
         								teamHshort=teamShortArr[c]; 
         								teamAltH=teamAltArr[c];
         								city=venueArr[c];
         								timeZone=zoneArr[c];
         							}else{
         								teamHome=teamHome.replace("Winner", winner[0]); teamHome=teamHome.replace("Loser", winner[1]);
         							}
         						}else{
         							teamHome=null;teamHshort=null;
         						}
         						if (awayTeamID>0){
         							if (awayTeamID==teamId[c]){
         								teamAway=teamArr[c]; teamAshort=teamShortArr[c];teamAltA=teamAltArr[c];
         							}else{
         								teamAway=teamAway.replace("Winner", winner[0]); teamAway=teamAway.replace("Loser", winner[1]);
         							}
         						}else{
         							teamAway=null;teamAshort=null;
         						}
         					}
         					switch(timeZone){
         						case "1": offsetZone=3600000; break;
         						case "2": offsetZone=7200000; break;
         						case "3": offsetZone=10800000; break;
         						default: offsetZone=0; break;
         					}
         					if (fixtureData[i].d_DateUTC!=null){
         						offsetVenue = getDST(fixtureData[i].d_DateUTC,offsetZone);
         						var timeAdjust=fixtureData[i].b_TimeUnknown==true?fixtureData[i].d_Date.substr(-6,4)*36000:0;
         						localTime=getDateLocal(fixtureData[i].d_Date)+", "+getMatchLocal(fixtureData[i].d_Date);
         						venueTime=getDDmonthYY(fixtureData[i].d_DateUTC,timeAdjust)+", "+getMatchTime(fixtureData[i].d_Date,offsetVenue);
         						matchDate = "<span class='longdate'>"+getDDmonthYY(fixtureData[i].d_DateUTC,timeAdjust)+"</span><span class='shortdate'>"+getMMDD(fixtureData[i].d_DateUTC,timeAdjust)+"</span>";
         						matchddmm=getDDMMYY(fixtureData[i].d_Date);
         					}else{
         						offsetVenue = "TBC"; matchTime = "TBC";localTime="TBC";venueTime="TBC";matchDate =  "TBC";matchddmm="TBC";
         					}
         				//SHOW LATEST MATCHES
         				if(fixtureData[i].b_Finished==true&&matchesRnd>=lastMatches){//Sep 17
         					lastMatches=matchesRnd;
         					showLatest=i;
         				}
         				if(fixtureData[i].b_Finished==true&&todayTime==matchesRnd){
         					nextMatches=matchesRnd;				
         				}else if(fixtureData[i].b_Finished==false&&i==showLatest+1){
         					nextMatches=matchesRnd;
         				}//ends
         				if((todayTime<startWC&&matchesRnd>startWC&&matchesRnd<startWC+(oneDay))||
         					((todayTime>startR2&&todayTime<endR2&&matchesRnd>startR2&&matchesRnd<endR2)||
         					(todayTime>endR2&&todayTime<endQF&&matchesRnd>endR2&&matchesRnd<endQF)||
         					(todayTime>endQF&&todayTime<endSF&&matchesRnd>endQF&&matchesRnd<endSF))&&matchesRnd>todayTime-(oneDay*4)||
         					todayTime>endWC&&matchesRnd>endWC-(oneDay*35)||
         //					(matchesRnd>todayTime-(oneDay*0.75)&&matchesRnd<todayTime+(oneDay*14))||//Sep 17 - only show today or next matchday
         					(matchesRnd==nextMatches)){
         						if (i%2 == 0){
         							var fixtureTxt = "<table class='fixtxt even' id='matchf" + i + "'>";
         						}else{
         							var fixtureTxt = "<table class='fixtxt' id='matchf" + i + "'>";
         						}
         						fixtureTxt += "<tr>";
         						fixtureTxt += "<td class='crestf' id='homecrestf" + i + "'></td>";
         						fixtureTxt += "<td class='teamf' id='homef" + i + "'></td>";
         						fixtureTxt += "<td class='scoref' id='scoref" + i + "'></td>";
         						fixtureTxt += "<td class='teamf away' id ='awayf" + i + "'></td>";
         						fixtureTxt += "<td class='crestf away' id='awaycrestf" + i + "'></td>";
         						fixtureTxt += "</tr></table>";
         						sym.getSymbol("latest").getSymbol("latestTable").$('table').append(fixtureTxt);//Sep 17
         					} //closes if parsedate	
         					//SHOW GROUP STAGE FIXTURES
         					var fixtBox = "<div id='matchg"+i+"'></div>";
         					//SHOW KNOCKOUT STAGE FIXTURES
         					var overviewTxt = "<table class='tie' id='tie"+i+"'>";
         					overviewTxt += "<tr>";
         					overviewTxt += "<td class='"+(phaseLevel>3?"flag":"finalflag")+"' id='flagh"+i+"'></td>";
         					overviewTxt += "<td class='team' id='hometeam"+i+"'></td>";
         					overviewTxt += "</tr>";
         					overviewTxt += "<tr>";
         					overviewTxt += "<td class='"+(phaseLevel>3?"flag":"finalflag")+"' id='flaga"+i+"'></td>";
         					overviewTxt += "<td class='team' id='awayteam"+i+"'></td>";
         					overviewTxt += "</tr>";
         					overviewTxt += "</table>";
         					//SHOW TWO LEG RESULTS
         					if(fixtureData[i].n_Leg!=2){
         						var leg1Txt = "<table class='leg' id='match"+i+"'>";
         						leg1Txt += "<tr><td id='legh"+i+"'></td></tr>";
         						leg1Txt += "<tr><td id='lega"+i+"'></td></tr>";
         						leg1Txt += "</table>";
         					}
         					if(fixtureData[i].n_Leg==2){
         						var leg2Txt	= "<table class='leg' id='match"+i+"'>";
         						leg2Txt += "<tr><td id='leg2a"+i+"'></td></tr>";
         						leg2Txt += "<tr><td id='leg2h"+i+"'></td></tr>";
         						leg2Txt += "</table>";
         					}		
         					var groupPhase=[];
         					for (var p=0;p<8;p++){
         						groupPhase[p]=firstGroup+p;
         						if(fixtureData[i].n_PhaseID==groupPhase[p]){
         							$("#m"+p+"_h"+fixtureData[i].n_HomeTeamID+"_a"+fixtureData[i].n_AwayTeamID).html(fixtBox);
         							var group=p;
         						}
         					}
         					var r16match=[];
         					if (phaseLevel==9){//Round of 16
         						for (var r=0;r<8;r++){
         							//109513
         							r16match[r]=firstKnOut+r;
         							if(matchNo==r16match[r]){
         								if((fixtureData[i].n_Leg)==1){
         									var r16Ov="<div class='kstage' id='tie"+matchNo+"'>"+overviewTxt+leg1Txt+"</div>";
         									sym.getSymbol("overview").getSymbol("knockout").$('r16-'+(r+1)).append(r16Ov);
         								}else{
         									$("#tie"+matchNo).append(leg2Txt);
         								}
         							}
         						}
         					}
         					var qmatch=[];
         					if (phaseLevel==5){//Quarter-finals
         						for (var q=0;q<4;q++){
         							//109521
         							qmatch[q]=firstKnOut+8+q;
         							if(matchNo==qmatch[q]){
         								if((fixtureData[i].n_Leg)==1){
         									var qfOv="<div class='kstage' id='tie"+matchNo+"'>"+overviewTxt+leg1Txt+"</div>";
         									sym.getSymbol("overview").getSymbol("knockout").$('qf'+(q+1)).append(qfOv);
         								}else{
         									$("#tie"+matchNo).append(leg2Txt);
         								}
         							}
         						}
         					}
         					var smatch=[];
         					if (phaseLevel==3){//Semi-finals
         						for (var s=0;s<2;s++){
         							//109525
         							smatch[s]=firstKnOut+12+s;
         							if(matchNo==smatch[s]){
         								if((fixtureData[i].n_Leg)==1){
         									var sfOv="<div class='kstage' id='tie"+matchNo+"'>"+overviewTxt+leg1Txt+"</div>";
         									sym.getSymbol("overview").getSymbol("knockout").$('sf'+(s+1)).append(sfOv);
         								}else{
         									$("#tie"+matchNo).append(leg2Txt);
         								}
         							}
         						}
         					}
         					var finTxt;
         					if (phaseLevel==2){//Final
         						var finalOv="<div class='kstage' id='tie"+matchNo+"'>"+overviewTxt+leg1Txt+"</div>";
         						sym.getSymbol("overview").getSymbol("knockout").$('final').append(finalOv);
         						city=txtArr[46];
         						timeZone=1;
         					}
         					$('#homecrestf' + i).html(crestH);
         					$('#awaycrestf' + i).html(crestA);
         					$('#tie'+matchNo).off('click');
         					if(homeTeamID>0||awayTeamID>0){
         						$('#tie'+matchNo).on('click',showMatch(matchID));
         						$("#match"+i).css({'cursor':'pointer'});
         						$("#match"+i).on('click',showMatch(matchID));
         					}
         					$("#match"+i).on('mouseover',function(){ $(this).css({'background-color':'rgba(255,0,0,1.0)','color':'rgba(255,255,255,1.0)','font-weight':700});});
         					$("#match"+i).on('mouseout',function(){ $(this).css({'background-color':'rgba(255,255,255,0)','color':'rgba(0,0,0,1.0)','font-weight':400});});
         					$("#matchf"+i).css({'cursor':'pointer'});
         					$("#matchf"+i).on('click',showMatch(matchID));
         					//$("#matchf"+i).on('mouseover',function(){ $(this).css({'background-color':'rgba(220,155,0,0.2)','font-weight':700});});
         					$("#matchf"+i).on('mouseover',function(){ $(this).css({'background-color':'rgba(220,155,0,0.2)'});});
         					$("#matchf"+i).on('mouseout',function(){ 
         							if(this.className=="fixtxt even"){ 
         								$(this).css({'background-color':'rgba(215,230,245,0.5)','font-weight':400});
         							}else{
         								$(this).css({'background-color':'rgba(255,255,255,0)','font-weight':400});
         							}
         						});
         					$("#matchg"+i).on('click',showMatch(matchID));
         					$("#matchg"+i).on('mouseover',{'group':group,'row':homeTeamID,'col':awayTeamID},rowColOver);
         					$("#matchg"+i).on('mouseout',{'group':group,'row':homeTeamID,'col':awayTeamID},rowColOut);
         					$('#tie'+matchNo).on('mouseover',function(){ $(this).css({'background-color':'rgba(220,155,0,0.2)'});});
         					$('#tie'+matchNo).on('mouseout',function(){ $(this).css({'background-color':'rgba(255,255,255,0)'});});										
         					$('#flagh' + i).html(imgH);
         					$('#flaga' + i).html(imgA);
         					phaseLevel<=4?($('#hometeam' + i).text(teamHome!=null?teamHome:""),$('#awayteam' + i).text(teamAway!=null?teamAway:"")):
         					($('#hometeam' + i).html("<span class='longname'>"+(teamHome!=null?teamHome.length>12?teamAltH:teamHome:"")+"</span>"+"<span class='shortname'>"+(teamHshort!=null?teamHshort:teamHome!=null?teamHome:"")+"</span>"),
         					$('#awayteam' + i).html("<span class='longname'>"+(teamAway!=null?teamAway.length>12?teamAltA:teamAway:"")+"</span>"+"<span class='shortname'>"+(teamAshort!=null?teamAshort:teamAway!=null?teamAway:"")+"</span>"));;
         					$('#homef' + i).text(teamHome!=null?teamHome:"");
         					$('#awayf' + i).text(teamAway!=null?teamAway:"");
         					var homeGoals=(fixtureData[i].n_HomeGoals!=null||fixtureData[i].n_HomeGoals!=undefined)?(fixtureData[i].n_HomeGoals):'';
         					var awayGoals=(fixtureData[i].n_AwayGoals!=null||fixtureData[i].n_AwayGoals!=undefined)?(fixtureData[i].n_AwayGoals):'';
         					var scoreH = '<b>' + homeGoals+ '</b>';
         					var scoreA = '<b>' + awayGoals+ '</b>';
         					if(fixtureData[i].n_Leg==2){
         						$('#leg2h' + i).html(scoreH); $('#leg2a' + i).html(scoreA);
         					}else{
         						$('#legh' + i).html(scoreH); $('#lega' + i).html(scoreA);
         					}
         					var score =(fixtureData[i].n_HomeGoals!=null||fixtureData[i].n_HomeGoals!=undefined)?homeGoals+ '-' + awayGoals:matchDate;
         					var scoref =(fixtureData[i].n_HomeGoals!=null||fixtureData[i].n_HomeGoals!=undefined)?'<b>' + homeGoals+ '-' + awayGoals+'</b>':'<img class="clock" src="images/time.png"><span class="venuetime">'+venueTime+'</span><span class="localtime">'+localTime+'</span>';
         					$('#scoref' + i).html(scoref+"<br/><i><span class='venuef'>"+stad+", "+city+"</span></i>");
         					$("#matchg"+i).html(score);
         					matchResult=(fixtureData[i].n_MatchStatusCode>4)&&(fixtureData[i].n_MatchStatusCode<128)?'<img src="images/ball.png" height="13px" width="13px">':'';
         					$('#result'+i).html(matchResult);
         					if (phaseLevel<=9){
         						for (var p=0;p<15;p++){
         							if(matchNo==firstKnOut+p){
         								if(fixtureData[i].n_Leg==2){
         									sym.getSymbol("overview").getSymbol("knockout").$("dateTxt"+p).append(", "+matchDate);
         								}else{
         									sym.getSymbol("overview").getSymbol("knockout").$("dateTxt"+p).html(matchDate);
         								}
         							}
         						}
         					}
         					if (showstage==0){
         						$(".kstage").fadeOut(0); 
         					}
         				}
         			} //close for
         //STYLES
         			showLocal==0?($(".localtime").fadeOut(0),$(".venuetime").fadeIn(0)):($(".localtime").fadeIn(0),$(".venuetime").fadeOut(0));
         			$('.fixtxt').css({'font-size':'14px', 'font-family':'pragmatica-web,sans-serif', 'width':'100%'});
         			$('.teamf').css({'width':'23%','font-weight':700});
         			$(".crestf").css({'width':'12%'});
         			$(".scoref").css({'width':'30%','text-align':'center'});
         			$(".away").css({'text-align':'right'});
         			$(".crestf img").css({'border':'none','max-width':(todayDate<endR2?'42px':'60px'),'width':'100%'});
         			$(".scoref img").css({"width":"14px","margin-right":"5px"});  
         			$(".venuef").css({'font-style':'italic'}); 
         			$(".team").css({'padding-bottom':'1px'});
         			$(".flag, .finalflag").css({'width':'22px','padding':'0 2px 0 2px'});
         			$(".flag img, .finalflag img").css({'border':'none','width':'22px','height':'12px'});
         			$('.grpteamh').css({'text-align':'left', 'width':'35%','padding':'0px'});
         			$('.grpteama').css({'text-align':'right', 'width':'35%','padding':'0px'});
         			$('.grpscore').css({'padding':'0px'});
         			$('.tie').css({'margin-left':'2px','border-collapse':'collapse', 'display':'table-cell','cursor':'pointer'});
         			$(".kstage").css({'display':'inline-table','width':'100%','height':'32px','font-size':'12px','font-family':'pragmatica-web,sans-serif',});
         			$(".leg").css({'padding-left':'2px','display':'table-cell','width':'10%','border-collapse':'collapse','border-left':'1px solid rgb(175,175,175)','text-align':'center'});
         			$('.even').css({'background-color':'rgba(215,230,245,0.5)'});
         			initSize();                                 
         		} //close success                                                    	           
         	}); //close ajax
          }//close function
         getGroupResults();
         if(todayTime>startWC-(oneDay*3)&&todayTime<endWC+(oneDay*3)){
         groupInterval = setInterval(getGroupResults,120000);
         }else{
         groupInterval = setInterval(getGroupResults,600000);//Sep 17
         }
         // LIVE MATCH 			
         function getMatchInfo(matchID){
         	var infoData;
         	sym.getSymbol("matchtracker").$("penaltiesTxt").fadeOut(0);
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gnNo+"&yr="+gnYear+"&match="+matchID+"&q=info",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			infoData = data;
         			var matchteam1=infoData[0].c_HomeTeam;
         			var matchteam2=infoData[0].c_AwayTeam;;
         			var matchteam1ID=infoData[0].n_HomeTeamID;var matchteam2ID=infoData[0].n_AwayTeamID;
         			getTeams(matchID,matchteam1ID,matchteam2ID);
         			var timeZone, offsetVenue, matchTime, matchDate, localTime, venueTime, offsetZone, city, matchddmm;//Nov 13
         			for(var c=0;c<32;c++){
         				if (matchteam1ID>0){
         					if (matchteam1ID==teamId[c]){
         						matchteam1=teamArr[c];city=venueArr[c];timeZone=zoneArr[c];
         					}
         				}else{
         					matchteam1=matchteam1.replace("Winner", winner[0]); matchteam1=matchteam1.replace("Loser", winner[1]);city=infoData[0].c_City;
         				}
         				if (matchteam2ID>0){
         					if (matchteam2ID==teamId[c]){
         						matchteam2=teamArr[c];
         					}
         				}else{
         					matchteam2=matchteam2.replace("Winner", winner[0]); matchteam2=matchteam2.replace("Loser", winner[1]);
         				}
         			}
         			if (matchID==finalID){//cty name for final
         				city=txtArr[46];
         			}
         			var score1, score2;
         			var notStarted=['h2hMc'];
         			var showStarted=['timer','timeTxt','clock'];
         			matchStatus = infoData[0].n_MatchStatusCode;
         			getH2H(matchID);	
         			if(infoData[0].b_Started==false){
         				score1="0";
         				score2="0";
         				for(var n=0;n<notStarted.length;n++){
         					sym.getSymbol("matchtracker").$(notStarted[n]).fadeIn(600);
         				}
         				for(var m=0;m<showStarted.length;m++){
         					sym.getSymbol("matchtracker").$(showStarted[m]).fadeOut(0);
         				}
         				clearInterval(playInterval);
         			}else{
         				if(infoData[0].b_Live==true){
         					clearInterval(matchInterval);
         					clearInterval(playInterval);
         					matchInterval = setInterval(function() { getMatchInfo(matchID); }, 45000);
         					playInterval = setInterval(function() { getMatch(matchID); }, 45000);
         				}
         				score1=infoData[0].n_HomeGoals;
         				score2=infoData[0].n_AwayGoals;
         				for(var n=0;n<notStarted.length;n++){
         					sym.getSymbol("matchtracker").$(notStarted[n]).fadeOut(0);
         				}
         				for(var m=0;m<showStarted.length;m++){
         					sym.getSymbol("matchtracker").$(showStarted[m]).fadeIn(600);
         				}
         				getmatchStats(matchID);
         			}
         			switch(timeZone){
         				case "1": offsetZone=3600000; break;
         				case "2": offsetZone=7200000; break;
         				case "3": offsetZone=10800000; break;
         				default: offsetZone=0; break;
         			}
                  if (infoData[0].d_DateUTC!=null){
         					/*
         					offsetVenue = getDST(infoData[0].d_DateUTC,offsetZone);
                  		localTime=getDateLocal(infoData[0].d_Date)+", "+getMatchLocal(infoData[0].d_Date);
                  		venueTime=getDDmonthYY(infoData[0].d_DateUTC)+", "+getMatchTime(infoData[0].d_Date,offsetVenue);
                  		matchDate = getDDmonthYY(infoData[0].d_DateUTC);
                  		matchddmm=getDDMMYY(infoData[0].d_Date);
                  		*/
                  		offsetVenue = getDST(infoData[0].d_DateUTC,offsetZone);//Nov 13
         					var timeAdjust=infoData[0].b_TimeUnknown==true?infoData[0].d_Date.substr(-6,4)*36000:0;
         					localTime=getDateLocal(infoData[0].d_Date)+", "+getMatchLocal(infoData[0].d_Date);
         					venueTime=getDDmonthYY(infoData[0].d_DateUTC,timeAdjust)+", "+getMatchTime(infoData[0].d_Date,offsetVenue);
         					matchDate = getDDmonthYY(infoData[0].d_DateUTC,timeAdjust);
         					matchddmm=getDDMMYY(infoData[0].d_Date);
                  	}else{
                  		offsetVenue = "TBC"; matchTime = "TBC";localTime="TBC";venueTime="TBC";matchDate =  "TBC";matchddmm="TBC";
                  	}
                  if(infoData[0].b_Finished==true){
         				clearInterval(matchInterval);
         				matchInterval = setInterval(function() { getMatchInfo(matchID); }, 300000);
         				clearInterval(playInterval);
         				playInterval = setInterval(function() { getMatch(matchID); }, 300000);
         				localTime=matchDate;
         				venueTime=matchDate;
         			}
         			var matchRef=(infoData[0].c_Referee==null)?"":txtArr[18] + infoData[0].c_Referee + " <i>" + infoData[0].c_RefereeNatioShort+"</i>";
         			var spectators=(infoData[0].n_Spectators==null)?"":txtArr[19] + infoData[0].n_Spectators;
         			var matchscore = score1 + "-" + score2;
         			var imgH = "crests/"+ matchteam1ID + ".png";
         			var imgA = "crests/"+ matchteam2ID + ".png";
         			var tacticsH =(infoData[0].c_HomeTactics==null)?"":infoData[0].c_HomeTactics;
         			var tacticsA = (infoData[0].c_AwayTactics==null)?"":infoData[0].c_AwayTactics;
         			var matchInfo = infoData[0].c_Stadium + "<span class='city'>, " + city + "</span><br /><img id='timezone' src='images/time.png'><span class='venuetime'>"+venueTime+"</span><span class='localtime'>"+localTime+"</span><br /><span class='ref'>" + matchRef + "</span><br /><span class='att'>" + spectators+ "</span>";
         			sym.getSymbol("matchtracker").$("matchcrest1").attr("src",imgH);				
         			sym.getSymbol("matchtracker").$("matchcrest2").attr("src",imgA);				
         			sym.getSymbol("matchtracker").$("matchteam1Txt").text(matchteam1);
         			sym.getSymbol("matchtracker").$("matchteam2Txt").text(matchteam2);
         			sym.getSymbol("matchtracker").$("matchscoreTxt").text(matchscore);
         			sym.getSymbol("matchtracker").$("matchinfoTxt").html(matchInfo);
         			$("#timezone").css({'cursor':'pointer','margin-right':'5px'});$("#timezone").on("click",timeZoneClick);$("#timezone").css({'width':'15px','margin-right':'5px'});
         			showLocal==0?($(".localtime").fadeOut(0),$(".venuetime").fadeIn(0)):($(".localtime").fadeIn(0),$(".venuetime").fadeOut(0));
         			//matchStatus 8 (in progress), 128 (finished)
         			//PENALTY SHOOTOUT ONLY
         			if (infoData[0].n_PeriodSort>=10&&infoData[0].n_HomeGoalsShootout!=null){
         				//if (lastPeriod==10){	
         				var pensH=(infoData[0].n_HomeGoalsShootout>=0)?infoData[0].n_HomeGoalsShootout:"";
         				var pensA=(infoData[0].n_AwayGoalsShootout>=0)?infoData[0].n_AwayGoalsShootout:"";
         				var penalties= txtArr[30]+" (" +pensH+ "-" +pensA+ ")";
         				if (infoData[0].n_HomeGoalsShootout>=0||infoData[0].n_AwayGoalsShootout>=0){
         						sym.getSymbol("matchtracker").$("penaltiesTxt").html(penalties);
         						sym.getSymbol("matchtracker").$("penaltiesTxt").fadeIn(0);
         					}
         			}
         			initSize();	               							
         		}
         	});
         }
         
         var matchData;
         var lastAction;
         var lastTime;
         var lastPeriod;
         function getMatch(matchID) { 
         	var minutes = sym.getSymbol("matchtracker").$("timeTxt");
         	minutes.text("0"); 
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gnNo+"&yr="+gnYear+"&match="+matchID,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			matchData = data;
         				if(matchData){
         					lastAction = matchData[0].n_ActionTime;
         					lastPeriod = matchData[0].n_PeriodSort;
         					var lastTimetxt;
         					var minutes = sym.getSymbol("matchtracker").$("timeTxt");
         					sym.getSymbol("matchtracker").$("timer").empty();
         					//create display for each action	
         					var actionTxt, penTxt, HorA, actionSet, actionType, action, actionTime, actionMs, actionPeriod;
         					var keyTxt="<div class='action'>";
         					keyTxt+="<div class='key'><img src='images/goal.png' style='width:15px'> "+key[0]+"</div>";
         					keyTxt+="<div class='key'>"+"<img src='images/pen.png' style='width:15px'> "+key[1]+"</div>";
         					keyTxt+="<div class='key'>"+"<img src='images/sub.png' style='width:15px'> "+key[2]+"</div>";
         					keyTxt+="<div class='key'>"+"<img src='images/yellow.png' style='width:15px'> "+key[3]+"</div>";
         					keyTxt+="</div>";
         					sym.getSymbol("matchtracker").$("timer").append(keyTxt)
         					for (var i = 0; i <= matchData.length; i++) {
         						if (matchData[i].n_ActionTime>lastAction){
         							lastAction=matchData[i].n_ActionTime;
         						}
         						if (matchData[i].n_PeriodSort>lastPeriod){
         							lastPeriod=matchData[i].n_PeriodSort;
         						}         		        
         						actionSet = matchData[i].n_ActionSet;
         						actionType = matchData[i].n_ActionCode;
         						actionTime = (matchData[i].c_ActionMinute==null)?"":matchData[i].c_ActionMinute;
         						var HorA = (matchData[i].n_HomeOrAway==1)?"h":"a";
         						if (actionSet==1||actionSet==2||actionSet==3||actionSet==5){
         							actionMs = matchData[i].n_ActionTime;
         							actionPeriod = matchData[i].n_PeriodSort;
         							var actionTxt="<div class='action period"+actionPeriod+"' id=action"+i+"'>";//style by period
         							actionTxt+="<div class='personh' id='person"+i+"h'></div>";
         							actionTxt+="<div class='type' id='type"+i+"h'></div>";	
         							actionTxt+="<div class='actiontime' id='actionMins"+i+"'></div>";
         							actionTxt+="<div class='type' id='type"+i+"a'></div>";
         							actionTxt+="<div class='persona' id='person"+i+"a'></div>";
         							actionTxt+="</div>";
         							//then append each action (latest at top)
         							sym.getSymbol("matchtracker").$("timer").prepend(actionTxt);
         							var player=matchData[i].c_PersonShort;     
         							var sub=(matchData[i].n_ActionSet==5)?" (" + matchData[i].c_SubPersonShort + ")":"";
         							$('#person' + i + HorA).text(player+sub);
         							$('#actionMins' + i).text(actionTime);
         							//create icons for each action
         							switch (actionSet){
         								case 1: action =(actionType==12)?"pen":"goal"; break;
         								case 2: action =(actionType==12)?"pen":"miss"; break;
         								case 3: action =(actionType==2048)?"yellow":"red"; break;
         								case 5: action="sub"; break;
         							}
         							var imgHTML="<img src='images/"+action +".png' height='20px' width='20px'>";
         							$('#type' + i + HorA).html(imgHTML);
         							$('.key').css({'display':'table-cell','font-style':'italic','padding-left':'5px'});
         							$('.action').css({'display':'inline-table','height':'20px','width':'100%','font-size':'12px','font-family':'pragmatica-web, sans-serif','text-align':'left','border-bottom':'solid 1px rgb(150,150,150)','border-top':'solid 1px rgba(255,255,255,0.6)'});
         							$(".period4").css({'background-color':'rgba(255,170,50,0.1)'});
         							$(".period6, .period8").css({'background-color':'rgba(255,0,0,0.1)'});
         							$(".period10").css({'background-color':'rgba(255,40,0,0.3)'});
         							$('.personh').css({'text-align':'right','display':'table-cell','width':'37%'});
         							$('.actiontime').css({'background-color':'rgba(100,100,100,0.6)','text-align':'center','display':'table-cell','width':'12%','color':'rgb(255,255,255)'});
         							$('.type').css({'display':'table-cell','width':'7%','text-align':'center'});
         							$('.persona').css({'text-align':'left','display':'table-cell','width':'37%'});
                  			} //close if
         						if (lastAction>7200000){					//if after 120 mins but before penalties
         							lastTime=7200000;
         						}else if ((lastAction>6300000)&&(lastPeriod<7)){					//if after 105 mins but before second period
         							lastTime=6300000;
         						}else if ((lastAction>5400000)&&(lastPeriod==11)){					//if after 90 mins match has finished
         							lastTime=5400000;
         						}else if ((lastAction>5400000)&&(lastPeriod<5)){					//if after 90 mins but before extra time
         							lastTime=5400000;
         						}else if((lastAction>2700000)&&(lastPeriod<4)){ 		// if match is in 1st half but > 45 mins
         							lastTime=2700000;
         						}else{
         							lastTime=lastAction;
         						}
         						//display latest time
         						if (lastPeriod==11){
         							lastTimetxt=Math.round(lastTime/60000);
         						}else if (lastPeriod<9){ //before penalty shootout
         							if(lastAction > 0){	
         								lastTimetxt=Math.round(lastAction/60000);
         							}
         						}else{
         							lastTimetxt="120";
         						}
                  			minutes.text(lastTimetxt); //SHOW LATEST TIME
         					} //close for 
         					if (lastPeriod>5){ //extra time draw line at ht/ft
         					}
         				}
         		},//close success 
         		error: function(){ 
         			console.log("Match not started");
         		}  	                                                  	           
         	}); //close ajax
         }
         function getTeams(matchID,home,away) {           
                  	sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquadh").empty(); //PASS teamIDs to teamInterval
                  	sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquada").empty();
                     var teamData;
                  	$.ajax({ type: "GET", url: dataURL,
                  		data: "gn="+gnNo+"&yr="+gnYear+"&q=teams&match="+matchID,
                  		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  		async: true,
                  		crossDomain: true,
                  		success: function (data) {
                  			teamData = data;
                  			if (!teamData){
         							getSquad(home,"home");
         							getSquad(away,"away");
         							sym.getSymbol("matchtracker").$("txt16").html(txtArr[17]);
         							sym.getSymbol("matchtracker").$("txt17").html(txtArr[17]);
                  			}else{
         							var coach;
         							var teamlist;
         							var team;
         							var hORa;
         							sym.getSymbol("matchtracker").$("txt16").html(txtArr[16]);
         							sym.getSymbol("matchtracker").$("txt17").html(txtArr[16]);
         							sym.getSymbol("matchtracker").getSymbol("teams").$("preloaderh").fadeOut(0);
         							sym.getSymbol("matchtracker").getSymbol("teams").$("preloadera").fadeOut(0);
         							for (var i = 0; i < teamData.length; i++) {		
         								if (teamData[i].n_HomeOrAway==1){
         									teamlist = "matchSquadh";
         									hORa='h';
         								}else if (teamData[i].n_HomeOrAway==-1){
         									teamlist = "matchSquada";
         									hORa='a';
         								}
         								if (teamData[i].n_ActionSet<8){
         									if (teamData[i].n_ActionSet==4){
         										var lineupTxt = "<div class='lineup' id='lineup" + i + "'>";
         									} else if (teamData[i].n_ActionSet==5||teamData[i].n_ActionSet==6){
         										var lineupTxt = "<div class='substitute' id='lineup" + i + "'>";
         									}	
         										lineupTxt += "<div class='shirtNr' id='teamShirt" + i + "'></div>";
         										lineupTxt += "<div class='playerNm' id='teamPerson" + i + "'></div>";
         										lineupTxt += "</div>";
         										sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquad"+hORa).append(lineupTxt);
         								}
         								if (teamData[i].n_FunctionType==16){
         									coach = "<div style='padding-left:3px'><b>" + teamData[i].c_Person + "</b> <span style='text-align:right; font-style:oblique; font-size:12px'>" + teamData[i].c_PersonNatioShort + "</span></div>";
         									sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquad"+hORa).prepend(coach);
         								}
         								sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquad"+hORa).css({'font-family':'pragmatica-web,sans-serif','font-size':'13px','padding-top':'5px'}); 
         								$('.lineup').css({'width':'100%','display':'inline-table'});
         								$('.substitute').css({'width':'100%','display':'inline-table','font-style':'oblique'});
         								$('.shirtNr').css({'width':'10%','display':'table-cell','text-align':'left','padding-left':'3px'});  
         								$('.playerNm').css({'width':'90%','display':'table-cell','text-align':'left','padding-left':'5px'});                        
         								var actionMins;	                
         								if (teamData[i].c_ActionMinute==null){
         									actionMins="";
         								}else{
         									actionMins=" ("+ teamData[i].c_ActionMinute + ")";
         								}			
         								$('#teamShirt' + i).text(teamData[i].n_ShirtNr);
         								$('#teamPerson' + i).html(teamData[i].c_Person + actionMins);
         								$('#subPerson' + i).text(teamData[i].c_SubPersonShort);
         								var posn = teamData[i].n_Position;			
         							}
         							//initSize();
         						}
         
                  		}
                  	});
         }
         function getSquad(team,homeOrAway){
                  	$.ajax({ type: "GET", url: dataURL,
                  		data: "gn="+gnNo+"&yr="+gnYear+"&squad="+team,
                  		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                  		async: true,
                  		crossDomain: true,
                  		success: function (data) {
                  			squadData=data;
                  			var hORa=(homeOrAway=="home")?"h":"a";
                  			if  (squadData.length>0){
         							for (var i = 0; i <squadData.length; i++) {
         								var shirtNr = (squadData[i].n_ShirtNr!=null)?squadData[i].n_ShirtNr:"";
         								var player = squadData[i].c_Person;
         								var ycards = squadData[i].n_CardsYellow;
         								var rcards = squadData[i].n_CardsRed;
         								var cards = ycards + "/" + rcards;
         								var goals = squadData[i].n_Goals;
         								var position=squadData[i].n_FunctionCode;
         								var contractEnd=(squadData[i].d_ContractEndDate==null)?endWC:parsedDate(squadData[i].d_ContractEndDate);//Jan 29
         								if(todayTime<contractEnd){
         									if (position>0&&position<16){
         										var squadlist = "<div id='"+hORa+"player"+i+"'>";
         										squadlist += "<div class='squadCol1' id='"+hORa+"sqdshirt"+i+"'></div>";
         										squadlist += "<div class='squadCol2' id='"+hORa+"sqdplayerName"+i+"'></div>";
         										squadlist += "<div class='squadCol3' id='"+hORa+"sqdcards"+i+"'></div>";
         										squadlist += "<div class='squadCol4' id='"+hORa+"sqdgls"+i+"'></div>";
         										squadlist += "</div>";
         									}
         									sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquad"+hORa).append(squadlist); 
         									sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquad"+hORa).css({'font-family':'pragmatica-web,sans-serif','font-size':'13px','padding-top':'5px'});  
         									sym.getSymbol("matchtracker").getSymbol("teams").$("preloader"+hORa).fadeOut(0);              
         									$('#'+hORa+'player'+i).css({'width':'100%','font-size':'12px','font-family':'pragmatica-web, sans-serif', 'display':'inline-table'});
         									$('.squadCol1').css({'width':'8%', 'color':'rgb(0,156,178)','padding-left':'3px', 'text-align':'right','display':'table-cell'});
         									$('.squadCol2').css({'width':'72%', 'padding-left':'3%','display':'table-cell'});
         									$('#'+hORa+'sqdplayerName'+i).css({'font-weight':400});
         									$('.squadCol3').css({'width':'10%', 'display':'table-cell', 'text-align':'center'});
         									$('.squadCol4').css({'width':'10%', 'display':'table-cell', 'text-align':'right'});
         									$('#'+hORa+'sqdshirt'+i).text(shirtNr);
         									$('#'+hORa+'sqdplayerName'+i).text(player);
         									//$('#'+hORa+'sqdcards'+i).text(cards);
         									//$('#'+hORa+'sqdgls'+i).text(goals);
         									}
         								}
         							}else{
         								sym.getSymbol("matchtracker").getSymbol("teams").$("matchSquad"+hORa).html("<span style='padding:5px 10px;font-size:13px;font-family:pragmatica-web, sans-serif;color:#fff;font-weight:700'>"+notice+"</span>");
         							}
                  			}
                  		});
                  }
         //PIE CHART
         function pieChart(hwins,awins,draws,placeHolder){			
              var canvasWidth = 145, //width
               canvasHeight = 90,   //height
               outerRadius = 45,   //radius
               //color = d3.scale.category20(); //builtin range of colors
         		color = d3.scale.ordinal().range(["#006666","#4e9799","#33c5cc","#FF6666"]);
             var dataSet = [
               {"legendLabel":"Won", "magnitude":awins},  
               {"legendLabel":"Drawn", "magnitude":draws}, 
               {"legendLabel":"Won", "magnitude":hwins}];
             var vis = d3.select(placeHolder)
               .append("svg:svg") //create the SVG element inside the <body>
                 .data([dataSet]) //associate our data with the document
                 .attr("width", canvasWidth) //set the width of the canvas
                 .attr("height", canvasHeight) //set the height of the canvas
                 .append("svg:g") //make a group to hold our pie chart
         			.attr("transform", "translate("+canvasWidth/2+","+canvasHeight/2+")") //move centre of pie chart from 0, 0 to middle of placeholder
         			//	.attr("viewBox", +canvasWidth/2+"px",+canvasHeight/2+"px",90,90)
         			.style("-webkit-transform", "translate("+canvasWidth/2+"px,"+canvasHeight/2+"px)");
             // This will create <path> elements for us using arc data...
             var arc = d3.svg.arc()
               .outerRadius(outerRadius)
         		.innerRadius(outerRadius-30); //donut chart
             var pie = d3.layout.pie() //this will create arc data for us given a list of values
               .value(function(d) { return d.magnitude; }) // Binding each value to the pie
               .sort( function(d) { return null; } );
             // Select all <g> elements with class slice (there aren't any yet)
             var arcs = vis.selectAll("g.slice")  // Associate the generated pie data (an array of arcs, each having startAngle, endAngle and value properties) 
               .data(pie) // This will create <g> elements for every "extra" data element that should be associated with a selection. The result is creating a <g> for every object in the data array
               .enter() // Create a group to hold each slice (we will have a <path> and a <text> element associated with each slice)
               .append("svg:g")
               .attr("class", "slice");    //allow us to style things in the slices (like text)
             arcs.append("svg:path")
               //set the color for each slice to be chosen from the color function defined above
               .attr("fill", function(d, i) { return color(i); } ) //this creates the actual SVG path using the associated data (pie) with the arc drawing function
               .attr("d", arc);
         }
         function getH2H(match){
            //sym.getSymbol("matchtracker").$("h2hmatch").html("<div style='font-family:pragmatica-web;text-align:center;font-size:14px'>"+txtArr[29]+"</div>");
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gnNo+"&yr="+gnYear+"&q=h2hsum&match="+match,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hmatch").empty();
         			sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hgoals").empty();
         			sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt1").empty();
         			sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt2").empty();
         			sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt3").empty();
         			sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt4").fadeIn(0);
         			h2hData = data;
         			if(h2hData.length>0&&h2hData[0].n_Matches>0){
         				var hwins=h2hData[0].n_MatchesWonHome;
         				var awins=h2hData[0].n_MatchesWonAway;
         				var draws=h2hData[0].n_MatchesDrawn;
         				var hgoals=h2hData[0].n_GoalsForHome;
         				var agoals=h2hData[0].n_GoalsForAway;
         				var placeHolder="#Stage_matchtracker_h2hMc_h2hmatch";
         				pieChart(hwins,awins,draws,placeHolder);
         				sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt1").html(txtArr[25]+": <b>"+hwins+"</b>");
         				sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt2").html(txtArr[26]+": <b>"+awins+"</b>");
         				sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt3").html(txtArr[27]+": <b>"+draws+"</b>");
         				sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt4").html(txtArr[35]);
         				var barTxt="<div class='barGraph'>";
         					barTxt+="<div id='capGoals'></div>";
         				barTxt+="<div id='hbarGoals'></div>";
         				barTxt+="<div id='abarGoals'></div>";
         				barTxt+="</div>";
         				sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hgoals").append(barTxt);
         				var hwidth=(hgoals/(hgoals+agoals)*100)+"%";
         				var awidth=(agoals/(hgoals+agoals)*100)+"%";
         				$("#hbarGoals").text(hgoals);
         				$("#abarGoals").text(agoals);
         				var acolor=(agoals==0)?'#33c5cc':'#006666';
         				var hcolor=(hgoals==0)?'#006666':'#33c5cc';
         				$("#capGoals").html(txtArr[28]);
         				$(".barGraph").css({'font-family':'pragmatica-web,sans-serif','width':'100%','height':'20px','font-size':'13px','font-weight':700, 'display':'inline-table'});
         				$("#capGoals").css({'text-align':'center','width':'100%','display':'table-caption'});
         				$("#hbarGoals").css({'background-color':hcolor,'color':'#ffffff','padding-left':'5px','padding-top':'2px','text-align':'left', 'display':'table-cell','width':hwidth});
         				$("#abarGoals").css({'background-color':acolor,'color':'#ffffff','padding-right':'5px','padding-top':'2px','text-align':'right','width':awidth,'display':'table-cell'});
         			}else{
         				sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hTxt4").fadeOut(0);
         				sym.getSymbol("matchtracker").getSymbol("h2hMc").$("h2hmatch").append("<div style='font-family:pragmatica-web;text-align:center;font-size:14px'>"+txtArr[29]+"</div>");
         			}
         		}
         	});
         }
         function getmatchStats(match){
         	$.ajax({ type: "GET", url: dataURL,
         		data: "gn="+gnNo+"&yr="+gnYear+"&q=stats&match="+match,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			sym.getSymbol("matchtracker").getSymbol("matchStats").$("chartHolder").empty();
         			sym.getSymbol("matchtracker").getSymbol("matchStats").$("barCharts").empty();
         			matchData = data;
         			var bar;
         			var placeHolder="#Stage_matchtracker_matchStats_chartHolder";
         			if (matchData.length>0){
         				function drawBar(){
                  			var barTxt="<div class='barGraph'>";
                  			barTxt+="<div id='cap"+bar+"'></div>";
                  			barTxt+="<div id='hbar"+bar+"'></div>";
                  			barTxt+="<div id='abar"+bar+"'></div>";
                  			barTxt+="</div>";
         						sym.getSymbol("matchtracker").getSymbol("matchStats").$("barCharts").append(barTxt);
                  	}
         				for (var i = 0; i < matchData.length; i++) {
         					if(matchData[i].n_ActionSet==13&&matchData[i].c_ActionShort=="BP"){//possession
         						var hPoss=matchData[i].n_HomePoints;
         						var aPoss=matchData[i].n_AwayPoints;
         						pieChart(hPoss,aPoss,0,placeHolder);
         						sym.getSymbol("matchtracker").getSymbol("matchStats").$("hpiTxt").html(hPoss+"%");
         						sym.getSymbol("matchtracker").getSymbol("matchStats").$("apiTxt").html(aPoss+"%");
         					}else if(matchData[i].n_ActionSet==12){
         						if(matchData[i].n_ActionSort==104){//on target
         							var hPts=matchData[i].n_HomePoints;
         							var aPts=matchData[i].n_AwayPoints;
         							bar="shots";
         							drawBar();
         						}
         						if(matchData[i].n_ActionSort==106){//saves
         							var hPts=matchData[i].n_HomePoints;
         							var aPts=matchData[i].n_AwayPoints;
         							bar="saves";
         							drawBar();
         						}
         						if(matchData[i].n_ActionSort==112){//fouls against
         							var hPts=matchData[i].n_HomePoints;
         							var aPts=matchData[i].n_AwayPoints;
         							bar="fouls";
         							drawBar();
         						}
         						var hwidth=(hPts/(hPts+aPts)*100)+"%";
         						var awidth=(aPts/(hPts+aPts)*100)+"%";
         						$("#hbar"+bar).text(hPts);
         						$("#abar"+bar).text(aPts);
         						$(".barGraph").css({'margin':'10px 0px','font-family':'pragmatica-web,sans-serif','width':'100%','height':'20px','font-size':'13px', 'display':'inline-table'});
         						$("#cap"+bar).css({'text-align':'center','width':'100%','display':'table-caption','font-weight':700});
         						$("#hbar"+bar).css({'background-color':'#33c5cc','color':'#ffffff','padding-left':'5px','text-align':'left', 'display':'table-cell','width':hwidth});
         						$("#abar"+bar).css({'background-color':'#006666','color':'#ffffff','padding-right':'5px','text-align':'right','width':awidth,'display':'table-cell'});
         					}
         						$("#capshots").html(txtArr[21]);
         						$("#capsaves").html(txtArr[22]);
         						$("#capfouls").html(txtArr[23]);
         				}
         			}
         		}
         	});
         }
         $('img').on('dragstart',function(e){ e.preventDefault(); }); //make images undraggable;

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleMc'
   (function(symbolName) {   
   
   })("StyleMc");
   //Edge symbol end:'StyleMc'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'Overview'
   (function(symbolName) {   
   
   })("Overview");
   //Edge symbol end:'Overview'

   //=========================================================
   
   //Edge symbol: 'Knockout'
   (function(symbolName) {   
   
   })("Knockout");
   //Edge symbol end:'Knockout'

   //=========================================================
   
   //Edge symbol: 'GroupStage'
   (function(symbolName) {   
   
   })("GroupStage");
   //Edge symbol end:'GroupStage'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("MenuBtn");
   //Edge symbol end:'MenuBtn'

   //=========================================================
   
   //Edge symbol: 'MenuBtns'
   (function(symbolName) {   
   
   })("MenuBtns");
   //Edge symbol end:'MenuBtns'

   //=========================================================
   
   //Edge symbol: 'Latest'
   (function(symbolName) {   
   
   })("Latest");
   //Edge symbol end:'Latest'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'LatestTable'
   (function(symbolName) {   
   
   })("LatestTable");
   //Edge symbol end:'LatestTable'

   //=========================================================
   
   //Edge symbol: 'Timezone'
   (function(symbolName) {   
   
   })("Timezone");
   //Edge symbol end:'Timezone'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'TableHead'
   (function(symbolName) {   
   
   })("TableHead");
   //Edge symbol end:'TableHead'

   //=========================================================
   
   //Edge symbol: 'Teams'
   (function(symbolName) {   
   
   })("Teams");
   //Edge symbol end:'Teams'

   //=========================================================
   
   //Edge symbol: 'MatchStats'
   (function(symbolName) {   
   
   })("MatchStats");
   //Edge symbol end:'MatchStats'

   //=========================================================
   
   //Edge symbol: 'H2hMc'
   (function(symbolName) {   
   
   })("H2hMc");
   //Edge symbol end:'H2hMc'

   //=========================================================
   
   //Edge symbol: 'example'
   (function(symbolName) {   
   
   })("example");
   //Edge symbol end:'example'

   //=========================================================
   
   //Edge symbol: 'MatchMenuBtn'
   (function(symbolName) {   
   
   })("MatchMenuBtn");
   //Edge symbol end:'MatchMenuBtn'

   //=========================================================
   
   //Edge symbol: 'Match'
   (function(symbolName) {   
   
   })("Match");
   //Edge symbol end:'Match'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33185");