/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var clicked = 0;
         	var btnNo = 0;
         	var mob = 0;
         	var sourceStyle = {"background-color":"rgba(0,0,0,1)", "height":"auto", "padding-left":"24px","padding-right":"6px","padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css({ "height":"auto", "width":"auto", "pointer-events":"none"});
         	var stand;
         	var standtxt = sym.$("standTxt").css({"pointer-events":"none","background-color":"rgba(255,255,255,1)", "height":"auto", "width":"auto", "padding":"5px"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         	var txtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px"};
         	sym.$("tabMc").empty();
         	sym.$("tabMc").css({"background-color":"rgba(255,255,255,1)", "padding":"0px", "box-shadow":"-3px -0px 3px rgba(0,0,0,0.5)"});
         	
         	var overBtn  = {"background-color":"rgba(0,0,0,1)"};
         	var outBtn = {"background-color":"rgba(218,0,0,1)"};
         	
         	var txt=[];
         	for (var i=0;i<35; i++){
         		txt[i] = sym.getSymbol("mapScrollMc").getSymbol("mapMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[35] = sym.getSymbol("keyMc").$("txt35").css({"pointer-events":"none"});
         	txt[36] = sym.getSymbol("keyMc").$("txt36").css({"pointer-events":"none"});
         	txt[37] = sym.getSymbol("keyMc").$("txt37").css({"pointer-events":"none"});
         	txt[38] = sym.getSymbol("keyMc").$("txt38").css({"pointer-events":"none"});
         	txt[39] = sym.getSymbol("keyMc").getSymbol("keyIcon0").$("txt39").css({"pointer-events":"none"});
         	txt[40] = sym.getSymbol("keyMc").getSymbol("keyIcon1").$("txt40").css({"pointer-events":"none"});
         	txt[41] = sym.getSymbol("keyMc").getSymbol("keyIcon2").$("txt41").css({"pointer-events":"none"});
         	txt[42] = sym.getSymbol("keyMc").getSymbol("keyIcon3").$("txt42").css({"pointer-events":"none"});
         	txt[43] = sym.getSymbol("keyMc").getSymbol("keyIcon4").$("txt43").css({"pointer-events":"none"});
         	txt[44] = sym.getSymbol("keyMc").getSymbol("keyIcon5").$("txt44").css({"pointer-events":"none"});
         	txt[45] = sym.getSymbol("keyMc").getSymbol("keyIcon6").$("txt45").css({"pointer-events":"none"});
         	txt[46] = sym.$("txt46").css({"pointer-events":"none"});
         	txt[47] = sym.$("txt47").css({"pointer-events":"none"});
         	txt[48] = sym.$("txt48").css({"pointer-events":"none"});
         	txt[49] = sym.$("txt49").css({"pointer-events":"none"});
         	txt[50] = sym.$("txt50").css({"pointer-events":"none"});
         	
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33168.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var newTable1="<div id='newTab1'>";
         			var dataTab1;
         			newTable1+="<div id='newtab1'>";
         			$(xml).find('table1').each(function() {
         				newTable1+="<table class='events'>";
         				$(this).find('number1').each(function() {
         					dataTab1 = $(this).find("date1").text();
         					newTable1+="<tr><td>"+dataTab1+"</td></tr>";
         				});
         				newTable1+="</table>";
         			});
         			newTable1+="</div>";	
         		sym.$("tabMc").append(newTable1);
         	
         		//apply styles
         		$("#newTab1").css({"font-family":"Pragmatica-web, sans-serif"});
         		$(".events").css({"text-align":"left","color":"#000000","font-size":"13px","line-height":"14px",'border':0,'border-collapse':'collapse'});
         		$("#newtab1 tr:odd").css({"background-color":"#e8e8e8"});
         		$("#newtab1 tr:even").css({"background-color":"#d7d7d7"});
         		$('.events td').css({'width':'90%','padding':'9px', 'padding-right':15});
         		$('.events img').css({'max-width':'110px','height':'auto'});
         		sym.$("tabMc").css({'overflow-y':'scroll'});
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<46; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         			for (var i=0;i<35; i++){
         				txt[i] = sym.getSymbol("mapScrollMc").getSymbol("mapMc").$("txt"+i).css({'font-size':'17px','line-height':'18px'});
         			}
         			sym.getSymbol("mapScrollMc").getSymbol("mapMc").$("txt31").css({'font-size':'18px'});
         			sym.getSymbol("mapScrollMc").getSymbol("mapMc").$("txt32").css({'font-size':'12px','line-height':'27px'});
         		},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	sym.getSymbol("Stage").stop(stageWidth*10);
         	sym.getSymbol("keyMc").stop(stageWidth*10);
         	sym.getSymbol("mapScrollMc").stop(stageWidth*10);
         	sym.getSymbol("styleHead").$("headerBox").animate({height:0 + sym.getSymbol("styleHead").$("headlineTxt").height()+12}, 0);
         	sym.$("standTxt").animate({top:0 + sym.getSymbol("styleHead").$("headerBox").height()+0}, 0);
         	sym.getSymbol("styleHead").$("headlineTxt").stop().animate({width:stageWidth-60}, 0);
         	sym.getSymbol("tabBtn").$("bg").animate({height:0 + sym.getSymbol("styleHead").$("headerBox").height()}, 0);
         	sym.getSymbol("tabBtn").$("plus").animate({top:(sym.getSymbol("styleHead").$("headerBox").height()/2)-7}, 0);
         	sym.getSymbol("tabBtn").$("minus").animate({top:(sym.getSymbol("styleHead").$("headerBox").height()/2)-1}, 0);
         	sym.getSymbol("styleBase").$("creditTxt").animate({left:stageWidth-120}, 0);
         	sym.$("mapScrollMc").stop().animate({width:stageWidth}, 0);
         	sym.$("mapScrollMc").css({'overflow-x':'scroll'});
         //--------------------------------------------------------------------------------------------------------
         	if(stageWidth<800){
         	}
         //--------------------------------------------------------------------------------------------------------
         	if(stageWidth<641){
         		sym.$("tabMc").fadeOut(0);
         		sym.getSymbol("tabBtn").$("plus").fadeIn(0);
         		sym.$("keyMc").fadeOut(0);
         		sym.getSymbol("keyBtn").$("plus").fadeIn(0);
         		sym.$("keyBtn").stop().animate({left:0}, 100);
         		mob = 1;
         	}else{
         		sym.$("keyMc").fadeIn(0);
         		sym.getSymbol("keyBtn").$("plus").fadeIn(0);
         		sym.$("keyBtn").stop().animate({left:-45}, 100);
         		mob = 0;
         	}
         //--------------------------------------------------------------------------------------------------------
         	if (stageWidth<480){
         	}
         };
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         var wWidth = $(window).width();
         $(window).resize(function(){
           if(wWidth != $(window).width()){
             initSize();
             wWidth = $(window).width();
           }
         });
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // KEY BUTTON
         sym.$("keyBtn").on(clickEventType, function(e){
         	if (mob == 1){
         		sym.$("tabMc").stop().fadeOut(200);
         		sym.getSymbol("tabBtn").$("plus").fadeIn(0);
         	}else{
         
         	}
         	if (sym.getSymbol("keyBtn").$("plus").is(":visible") ) {
         		sym.$("keyMc").fadeIn(200);
         		sym.getSymbol("keyBtn").$("plus").fadeOut(0);
         	}else{
         		if (mob == 1){
         			sym.$("keyMc").stop().fadeOut(0);
         		}
         		sym.$("keyMc").fadeOut(200);
         		sym.getSymbol("keyBtn").$("plus").fadeIn(0);
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         sym.$("keyBtn").mouseover(function(){
         	sym.getSymbol("keyBtn").$("bg").stop().css(overBtn);
         });
         sym.$("keyBtn").mouseout(function(){
         	sym.getSymbol("keyBtn").$("bg").stop().css(outBtn);
         });
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // TXT BUTTON
         sym.$("tabBtn").on(clickEventType, function(e){
         	if (mob == 1){
         		sym.$("keyMc").fadeOut(200);
         		sym.getSymbol("keyBtn").$("plus").fadeIn(0);
         		sym.$("keyBtn").stop().animate({left:-40}, 200);
         	}else{
         	}
         	if (sym.getSymbol("tabBtn").$("plus").is(":visible") ) { 
         		sym.$("tabMc").stop().fadeIn(200);
         		sym.getSymbol("tabBtn").$("plus").fadeOut(0);
         	}else{
         		if (mob == 1){
         			sym.$("keyBtn").stop().animate({left:0}, 200);
         		}
         		sym.$("tabMc").fadeOut(200);
         		sym.getSymbol("tabBtn").$("plus").fadeIn(0);
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         sym.$("tabBtn").mouseover(function(){
         	sym.getSymbol("tabBtn").$("bg").stop().css(overBtn);
         });
         sym.$("tabBtn").mouseout(function(){
         	sym.getSymbol("tabBtn").$("bg").stop().css(outBtn);
         });
         sym.$("tabMc").stop().fadeOut(0);
         //--------------------------------------------------------------------------------------------------------
         //--------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on(clickEventType, function(e){
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 8000, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 6400, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 4800, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3200, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn0");
   //Edge symbol end:'menuBtn0'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'Base'
   (function(symbolName) {   
   
   })("Base");
   //Edge symbol end:'Base'

   //=========================================================
   
   //Edge symbol: 'mapMc'
   (function(symbolName) {   
   
   })("mapMc");
   //Edge symbol end:'mapMc'

   //=========================================================
   
   //Edge symbol: 'map'
   (function(symbolName) {   
   
   })("map");
   //Edge symbol end:'map'

   //=========================================================
   
   //Edge symbol: 'tableMc'
   (function(symbolName) {   
   
   })("tableMc");
   //Edge symbol end:'tableMc'

   //=========================================================
   
   //Edge symbol: 'keyIcon2'
   (function(symbolName) {   
   
   })("keyIcon1");
   //Edge symbol end:'keyIcon1'

   //=========================================================
   
   //Edge symbol: 'keyIcon1_1'
   (function(symbolName) {   
   
   })("keyIcon0");
   //Edge symbol end:'keyIcon0'

   //=========================================================
   
   //Edge symbol: 'keyIcon1_1'
   (function(symbolName) {   
   
   })("keyIcon2");
   //Edge symbol end:'keyIcon2'

   //=========================================================
   
   //Edge symbol: 'keyIcon1_1'
   (function(symbolName) {   
   
   })("keyIcon3");
   //Edge symbol end:'keyIcon3'

   //=========================================================
   
   //Edge symbol: 'keyIcon3_1'
   (function(symbolName) {   
   
   })("keyIcon4");
   //Edge symbol end:'keyIcon4'

   //=========================================================
   
   //Edge symbol: 'keyIcon4_1'
   (function(symbolName) {   
   
   })("keyIcon5");
   //Edge symbol end:'keyIcon5'

   //=========================================================
   
   //Edge symbol: 'keyIcon5_1'
   (function(symbolName) {   
   
   })("keyIcon6");
   //Edge symbol end:'keyIcon6'

   //=========================================================
   
   //Edge symbol: 'keyMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("keyMc");
   //Edge symbol end:'keyMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn0_1'
   (function(symbolName) {   
   
      })("menuBtn1");
   //Edge symbol end:'menuBtn1'

   //=========================================================
   
   //Edge symbol: 'menuBtn1_1'
   (function(symbolName) {   
   
      })("menuBtn2");
   //Edge symbol end:'menuBtn2'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'mapScrollMc'
   (function(symbolName) {   
   
   })("mapScrollMc");
   //Edge symbol end:'mapScrollMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33168");