/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "click" : "click");
         	var clicked = 0;
         	var btnNo = 0;
         	var mapVis = 0;
         	var view = 0;
         	var outBtn  = {"background-color":"#3d3d3d"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         	var blackBox = {"background-color":"rgba(0,0,0,0.8)", "width":"auto", "height":"auto", "padding":"6px", "padding-right":"15px",  "padding-bottom":"15px", "pointer-events":"none"};
         	var sourceStyle = {"background-color":"rgba(0,0,0,0.8)", "height":"auto", "padding-left":"22px", "padding-top":"2px", "pointer-events":"none"};
         	var headline;
         	var headlinetxt = sym.$("headlineTxt").css("pointer-events","none");
         	var stand;
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css({"background-color":"rgba(255,255,255,1)", "height":"auto", "padding":"6px", "pointer-events":"none"});
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").css(sourceStyle);
         	
         // MENU TEXT START
         	var menuTxt=[];
         	for (var i=0; i<4; i++){
         		menuTxt[i] = sym.getSymbol("menuBtn"+i).$("txt").css({"pointer-events":"none"});
         		sym.getSymbol("menuBtn"+i).$("no").html(i+1);
         	}
         	var menuArr=[];
         // MENU TEXT END
         
         	//sym.$("mapScroll").stop().animate ({width:800}, 400, 'easeInCubic');
         
         	var txt=[];
         	txt[0] = sym.getSymbol("tablesMc").$("txt0").css(blackBox);
         	for (var i=1; i<32; i++){
         		txt[i] = sym.getSymbol("mapScroll").getSymbol("mapMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[32] = sym.getSymbol("stagesMc").getSymbol("stageMc1").$("txt32").css({"pointer-events":"none"});
         	txt[33] = sym.getSymbol("stagesMc").getSymbol("stageMc1").$("txt33").css({"pointer-events":"none"});
         	txt[34] = sym.getSymbol("stagesMc").getSymbol("stageMc2").$("txt34").css({"pointer-events":"none"});
         	txt[35] = sym.getSymbol("stagesMc").getSymbol("stageMc2").$("txt35").css({"pointer-events":"none"});
         	txt[36] = sym.$("txt36").css({"pointer-events":"none"});
         	txt[37] = sym.$("txt37").css({"pointer-events":"none"});
         	txt[38] = sym.getSymbol("tablesMc").$("txt38").css(blackBox);
         	txt[39] = sym.$("txt39").css({"pointer-events":"none"});
         	txt[40] = sym.$("txt40").css({"pointer-events":"none"});
         	txt[41] = sym.$("txt41").css({"pointer-events":"none"});
         	txt[42] = sym.$("txt42").css({"pointer-events":"none"});
         	txt[43] = sym.$("txt43").css({"pointer-events":"none"});
         	txt[44] = sym.$("txt44").css({"pointer-events":"none"});
         	txt[45] = sym.$("txt45").css({"pointer-events":"none"});
         	txt[46] = sym.$("txt46").css({"pointer-events":"none"});
         	txt[47] = sym.$("txt47").css({"pointer-events":"none"});
         	txt[48] = sym.$("txt48").css({"pointer-events":"none"});
         	txt[49] = sym.$("txt49").css({"pointer-events":"none"});
         	txt[50] = sym.$("txt50").css({"pointer-events":"none"});
         
         	var txtArr=[];
         	var tableArr=[]; //create array of tables
         	for (var i=0; i<4;i++){
         		tableArr[i]=[];//create array for each table
         	}
         	var strapArr=[]; //create strap array
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	function loadXml(){
         	$.ajax({	
         		type: "GET",
         		url: "GN33150.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("styleHead").$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			// MENU TEXT START
         			for (var i=0; i<4; i++){
         				menuArr[i]=$(xml).find('menuTxt'+i).text();
         				menuTxt[i].html(menuArr[i]);
         			} // MENU TEXT END
         
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<40; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         //populate table arrays
         			for (var i=0; i<4;i++){
         				$(xml).find('table' + i).each(function() {		
         					var $table = $(this);
         					strapArr[i]=$table.find('strap').text();
         					var $events = $table.find('number');
         					$events.each(function() {
         						var $event = $(this);
         						var dataTab=$event.find("date").text()
         						tableArr[i].push(dataTab);
         					});
         				});
         			}
         		makeTable(0); //make the table with tableArr[0]
         		sym.getSymbol("tablesMc").$("tableMc").css({'overflow-y':'scroll'});
         		sym.getSymbol("mapScroll").getSymbol("mapMc").$("txt1616").empty();
         		sym.getSymbol("mapScroll").getSymbol("mapMc").$("txt1616").append(txtArr[16]);
         
         		sym.getSymbol("tablesMc").$("txt0").animate({left:-15 - sym.getSymbol("tablesMc").$("txt0").width()-6}, 0);
         		sym.getSymbol("tablesMc").$("txt38").animate({left:-15 - sym.getSymbol("tablesMc").$("txt38").width()-6}, 0);
         		},
            complete:function(){
         		initSize();
            }
         	}); // END XML
         }
         loadXml();
         
         function makeTable(num){
         		var newTable="<div id='newTab'>";
         		newTable+="<div id='newtab'>";
         		newTable+="<table class='events'>";
         		for (var l=0;l<tableArr[num].length;l++){
         			newTable+="<tr><td>"+tableArr[num][l]+"</td></tr>";
         		}
         		newTable+="</table>";
         		newTable+="<div class='redstrap'>"+strapArr[num]+"</div>";
         		sym.getSymbol("tablesMc").$("tableMc").append(newTable);
         		$("#newTab").css({"font-family":"Pragmatica-web, sans-serif", });
         		$(".events").css({"text-align":"left","color":"#000000","font-size":"13px","line-height":"15px",'border':0,'border-collapse':'collapse'});
         		$("#newtab tr:odd").css({"background-color":"#EEEEE6",});
         		$("#newtab tr:even").css({"background-color":"#D8D7BC"});
         		$('.events td').css({'padding':'9px', 'padding-right':11});
         		if (num == 2){
         			$(".redstrap").css({'font-weight':700,'color':'rgb(255,255,255)','width':'90%','background-color':'rgb(0,0,0)', "font-size":"15px",'line-height':'17px','text-align':'center','padding-top':10,'padding-bottom':10,'padding-left':"3%",'padding-right':"7%"});
         		}
         }
         function timelineScroll(){
         // Map scroll position to timeline position
         var tabHeight = sym.getSymbol("tablesMc").getSymbol("tableMc").$("#newTab").height();
         var tableHeight = sym.getSymbol("tablesMc").$("tableMc").height();
         var scrollPos = sym.getSymbol("tablesMc").$("tableMc").scrollTop();
         var duration = sym.getSymbol("stagesMc").getSymbol("stageMc" + clicked).getDuration();
         var percent = scrollPos / (tabHeight - tableHeight);
         var time = duration * percent;
         sym.getSymbol("stagesMc").getSymbol("stageMc" + clicked).stop(time);
         sym.getSymbol("tablesMc").$("scrollDown").fadeOut(50);
         	if (mapVis == 0) {
         		sym.$("mapScroll").stop().animate ({left:-800}, 400, 'easeInCubic');
         		sym.getSymbol("toggleBtn").$("plus").fadeIn(0);
         		mapVis = 1;
         	}
         }	
         sym.getSymbol("tablesMc").$("tableMc").on('scroll',timelineScroll);	
         sym.getSymbol("tablesMc").$("txt38").stop().animate ({opacity:0}, 0);
         
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         // MENU BUTTONS
         
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<4; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtn" + h).$("bg").css(outBtn);
         		sym.getSymbol("stagesMc").$("stageMc" + h).stop().animate ({opacity:0}, 300);
         		sym.getSymbol("stagesMc").getSymbol("stageMc" + h).stop(0);
         	}
         }
         //resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         	sym.getSymbol("tablesMc").$("tableMc").scrollTop(0);
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("tablesMc").$("tableMc").empty();
         		sym.getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		makeTable(clicked); // make table with clicked table number
         		sym.getSymbol("stagesMc").$("stageMc" + menuNo).stop().animate ({opacity:1}, 300);
         		if (menuNo == 0){
         			sym.getSymbol("tablesMc").$("txt0").stop().animate ({opacity:1}, 50, 'easeInCubic');
         		}else{
         			sym.getSymbol("tablesMc").$("txt0").stop().animate ({opacity:0}, 50, 'easeInCubic');
         		}
         		if (menuNo == 3){
         			sym.getSymbol("tablesMc").$("txt38").stop().animate ({opacity:1}, 50, 'easeInCubic');
         		}else{
         			sym.getSymbol("tablesMc").$("txt38").stop().animate ({opacity:0}, 50, 'easeInCubic');
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OVER
         var menuBtnOver = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OUT
         var menuBtnOut = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtn" + menuNo).$("bg").css(outBtn);
         		if (clicked == menuNo){
         			sym.getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<menuArray.length;b++){
         	sym.$("menuBtn"+b).on(clickEventType,menuBtnClick(b));
         	sym.$("menuBtn"+b).on('mouseover',menuBtnOver(b));
         	sym.$("menuBtn"+b).on('mouseout',menuBtnOut(b));
         	sym.$("menuBtn"+b).css({'cursor':'pointer'});
         }
         	sym.getSymbol("menuBtn0").$("bg").css(overBtn);
         
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         
         // TOGGLE BUTTON
         sym.$("toggleBtn").on(clickEventType, function(e){
         	if (sym.getSymbol("toggleBtn").$("plus").is(":visible") ) { 
         		sym.getSymbol("toggleBtn").$("plus").fadeOut(0);
         		sym.getSymbol("toggleBtn2").$("plus").fadeOut(0);
         		sym.$("mapScroll").stop().animate ({left:0}, 600, 'easeOutCubic');
         	}else{
         		sym.getSymbol("toggleBtn").$("plus").fadeIn(0);
         		sym.getSymbol("toggleBtn2").$("plus").fadeIn(0);
         		sym.$("mapScroll").stop().animate ({left:-800}, 400, 'easeInCubic');
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         sym.$("toggleBtn").mouseover(function(){
         	sym.getSymbol("toggleBtn").$("rollOver").css(outBtn);
         });
         sym.$("toggleBtn").mouseout(function(){
         	sym.getSymbol("toggleBtn").$("rollOver").css(overBtn);
         });
         
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         
         // TOGGLE BUTTON TOP
         sym.$("toggleBtn2").on(clickEventType, function(e){
         	if (sym.getSymbol("toggleBtn2").$("plus").is(":visible") ) { 
         		sym.getSymbol("toggleBtn").$("plus").fadeOut(0);
         		sym.getSymbol("toggleBtn2").$("plus").fadeOut(0);
         		sym.$("mapScroll").stop().animate ({left:0}, 600, 'easeOutCubic');
         	}else{
         		sym.getSymbol("toggleBtn").$("plus").fadeIn(0);
         		sym.getSymbol("toggleBtn2").$("plus").fadeIn(0);
         		sym.$("mapScroll").stop().animate ({left:-800}, 400, 'easeInCubic');
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         sym.$("toggleBtn2").mouseover(function(){
         	sym.getSymbol("toggleBtn2").$("rollOver").css(outBtn);
         });
         sym.$("toggleBtn2").mouseout(function(){
         	sym.getSymbol("toggleBtn2").$("rollOver").css(overBtn);
         });
         
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         function initSize(){
         	sym.$("mapScroll").css({'overflow-x':'scroll'});
         	var stageWidth=sym.$("Stage").width();
         	sym.$("mapScroll").stop().animate ({width:stageWidth}, 0);
         	sym.getSymbol("styleHead").$("standTxt").fadeIn(0);
         	for (var h=0; h<4; h++){
         		sym.$("menuBtn"+h).stop().animate ({left:stageWidth-220}, 0);
         	}
         	sym.$("tablesMc").stop().animate ({left:stageWidth-220, top:0}, 0);
         	sym.getSymbol("tablesMc").$("tableMc").stop().animate ({top:170, width:220, height:415}, 0);
         	sym.getSymbol("tablesMc").$("txt0").stop().animate ({top:545}, 0);
         	sym.getSymbol("tablesMc").$("txt38").stop().animate ({top:545}, 0);
         	sym.$("toggleBtn").stop().animate ({top:513}, 0);
         	sym.$("toggleBtn2").stop().animate ({top:800}, 0);
         	if(stageWidth<800){
         		view = 0;
         		for (var h=0; h<4; h++){
         			sym.$("menuBtn"+h).stop().animate ({left:stageWidth-220}, 0);
         		}
         		sym.$("menuBtn0").stop().animate ({top:0, width:220, height:50}, 100);
         		sym.$("menuBtn1").stop().animate ({top:50, width:220, height:35}, 100);
         		sym.$("menuBtn2").stop().animate ({top:85, width:220, height:50}, 100);
         		sym.$("menuBtn3").stop().animate ({top:135, width:220, height:35}, 100);
         		sym.getSymbol("tablesMc").$("tableMc").stop().animate ({height:415}, 100);
         		sym.$("tablesMc").stop().animate ({left:stageWidth-220, top:0}, 0);
         		sym.$("stagesMc").stop().animate ({left:-0}, 300);
         		sym.getSymbol("styleHead").$("standTxt").stop().animate ({width:stageWidth-230}, 0);
         		sym.$("headlineTxt").empty();
         		sym.$("headlineTxt").append(txtArr[39]);
         	}
         	if(stageWidth<640){
         		view = 1;
         		sym.$("menuBtn0").stop().animate ({top:40, left:stageWidth-220, width:220, height:50}, 100);
         		sym.$("menuBtn1").stop().animate ({top:90, left:stageWidth-220, width:220, height:35}, 100);
         		sym.$("menuBtn2").stop().animate ({top:125, left:stageWidth-220, width:220, height:50}, 100);
         		sym.$("menuBtn3").stop().animate ({top:175, left:stageWidth-220, width:220, height:35}, 100);
         		sym.getSymbol("tablesMc").$("tableMc").stop().animate ({height:375}, 0);
         		sym.$("tablesMc").stop().animate ({top:40}, 0);
         		sym.$("tablesMc").stop().animate ({left:stageWidth-220}, 0);
         		sym.$("stagesMc").stop().animate ({left:-120}, 300);
         		sym.getSymbol("tablesMc").$("txt0").stop().animate ({top:505}, 0);
         		sym.getSymbol("tablesMc").$("txt38").stop().animate ({top:505}, 0);
         	}
         	if (stageWidth<480){
         		view = 2;
         		sym.$("toggleBtn").stop().animate ({top:800}, 0);
         		sym.$("toggleBtn2").stop().animate ({top:0}, 0);
         		sym.$("headlineTxt").empty();
         		sym.$("headlineTxt").append(txtArr[37]);
         		sym.$("tablesMc").stop().animate ({top:125, left:(0)}, 0);
         		sym.getSymbol("styleHead").$("standTxt").fadeOut(0);
         		sym.$("menuBtn0").stop().animate ({top:40, left:0, width:(stageWidth/4)}, 0);
         		sym.$("menuBtn1").stop().animate ({top:90, left:0, width:stageWidth/4}, 0);
         		sym.$("menuBtn2").stop().animate ({top:40,left:stageWidth/2, width:stageWidth/4}, 0);
         		sym.$("menuBtn3").stop().animate ({top:90,left:stageWidth/2, width:stageWidth/4}, 0);
         		sym.getSymbol("tablesMc").$("tableMc").stop().animate ({top:0, height:458, width:stageWidth}, 0);
         	}
         	sym.getSymbol("tablesMc").$("scrollDown").stop().animate ({left:sym.getSymbol("tablesMc").$("tableMc").width()/2-33}, 0);
         }
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         var wWidth = $(window).width();
         $(window).resize(function(){
           if(wWidth != $(window).width()){
             initSize();
             wWidth = $(window).width();
           }
         });
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on(clickEventType, function(e){
         	sym.getSymbol("styleBase").$("toggleSource").stop().animate ({height:sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+20}, 0);
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0-sym.getSymbol("styleBase").getSymbol("toggleSource").$("sourceTxt").height()+10}, 200, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("toggleSource").stop().animate ({top:0}, 200, 'easeInCubic');
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         
         sym.$("txt38").stop().animate ({opacity:0}, 0);

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'tableMc'
   (function(symbolName) {   
   
   })("tableMc");
   //Edge symbol end:'tableMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn25'
   (function(symbolName) {   
   
   })("menuBtn35");
   //Edge symbol end:'menuBtn35'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn40'
   (function(symbolName) {   
   
   })("menuBtn50");
   //Edge symbol end:'menuBtn50'

   //=========================================================
   
   //Edge symbol: 'stagesMc'
   (function(symbolName) {   
   
   })("stagesMc");
   //Edge symbol end:'stagesMc'

   //=========================================================
   
   //Edge symbol: 'stageMc0'
   (function(symbolName) {   
   
   })("stageMc0");
   //Edge symbol end:'stageMc0'

   //=========================================================
   
   //Edge symbol: 'tablesMc'
   (function(symbolName) {   
   
   })("tablesMc");
   //Edge symbol end:'tablesMc'

   //=========================================================
   
   //Edge symbol: 'mapMc'
   (function(symbolName) {   
   
   })("mapMc");
   //Edge symbol end:'mapMc'

   //=========================================================
   
   //Edge symbol: 'stageMc3'
   (function(symbolName) {   
   
   })("stageMc3");
   //Edge symbol end:'stageMc3'

   //=========================================================
   
   //Edge symbol: 'stageMc0_1'
   (function(symbolName) {   
   
      })("stageMc1");
   //Edge symbol end:'stageMc1'

   //=========================================================
   
   //Edge symbol: 'stageMc1_1'
   (function(symbolName) {   
   
      })("stageMc2");
   //Edge symbol end:'stageMc2'

   //=========================================================
   
   //Edge symbol: 'Base'
   (function(symbolName) {   
   
   })("Base");
   //Edge symbol end:'Base'

   //=========================================================
   
   //Edge symbol: 'mapScroll'
   (function(symbolName) {   
   
   })("mapScroll");
   //Edge symbol end:'mapScroll'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'toggleSource_1'
   (function(symbolName) {   
   
   })("toggleBtn2");
   //Edge symbol end:'toggleBtn2'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33150");