/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         var gn=33126;
         var gnYear=2015;
         var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://www.graphicnews.org/")+ "infostradasports/api.php";
         var champsArr=[753349,753351,753350,753352,753353];//men, ladies, mdouble, fdouble, mixed 753349,753351,753350,753352,753353//667159,668002,667160,668003,668004
         //CSS
         sym.getSymbol("winners").$("menPic").css({'width':'37%','max-width':'209px','height':'auto'});
         sym.getSymbol("winners").$("ladiesPic").css({'width':'37%','max-width':'209px','height':'auto'});
         $(".rounds").css({'background-color':'rgb(111,44,145)','color':'rgb(255,255,255)','border':'solid 1px rgb(255,255,255)','border-radius':'10px','width':'auto','min-width':'20px'});
         //TEXT CAPTIONS
         var menuTxt=sym.getSymbol("styleHead").$("menutxt");
         var screenArr=['winners','latest','grid','selection'];
         var menuTxtArr=[];
         var txtArr=[];
         txtArr[0]=sym.getSymbol("latest").$('txt0').css({'pointer-events':'none'});
         txtArr[1]=sym.getSymbol("winners").getSymbol("menBlock").$('txt1').css({'pointer-events':'none'});
         txtArr[2]=sym.getSymbol("winners").getSymbol("ladiesBlock").$('txt2').css({'pointer-events':'none'});
         txtArr[3]=sym.getSymbol("winners").$('txt3').css({'pointer-events':'none'});
         txtArr[4]=sym.getSymbol("winners").$('txt4').css({'pointer-events':'none'});
         var txt=[];
         var txtAlt=[];
         var timetxt=[];
         var dateFormat;//for different date formats
         var monthsArr=[];
         var yearArr=[];
         var menArr=[];
         var ladiesArr=[];
         var dblmArr=[];
         var dblfArr=[];
         var dblxArr=[];
         //AJAX retrieves data, captions from xml source
         $.ajax({	
         	type: "GET",
         	url: "GN"+gn+".xml",
         	dataType: "xml",
         	success: function(xml) {
         		var headline=$(xml).find('headline').text();
         		var source=$(xml).find('source').text();
         		dateFormat=$(xml).find('dateformat').text();//for different date formats
         		sym.getSymbol('styleHead').$('headlinetxt').html(headline);
         		sym.getSymbol('styleBase').$('sourceTxt').html(source);
         		for (var i=0;i<4;i++){ //get menu labels
         			menuTxtArr[i]= $(xml).find('menuTxt'+i).text();
         		}
         		menuTxt.html(menuTxtArr[0]);
         		var timeArr = $(xml).find('time').text();
               timetxt=timeArr.split(";");
               sym.getSymbol("latest").$("timezoneTxt").html(timetxt[0]); 
               sym.getSymbol('grid').getSymbol('matchBox').$('timezoneTxt').html(timetxt[0]);
               var months = $(xml).find('months').text();
               monthsArr=months.split(";");
         		for (var i=0;i<18;i++){
         			txt[i]=$(xml).find('txt'+i).text();
         			if(i>0&&i<txtArr.length){
         				txtArr[i].html(txt[i]);
         			}
         		}
         		for (var i=0;i<5;i++){
         			if(i<2){
         				sym.getSymbol("selection").getSymbol("selectBtn"+i).$("btnTxt").html(txt[i+1]);
         			}else{
         				sym.getSymbol("selection").getSymbol("selectBtn"+i).$("btnTxt").html(txt[i+4]);
         			}
         		}
         		sym.getSymbol('selection').$('txt14').html(txt[14]);
         		for (var i=0;i<4;i++){
         			txtAlt[i]=$(xml).find('txt0alt'+i).text();
         		}
         		$(xml).find("year").each(function(){
         			var $years = $(this);
         			yearArr.push($years.attr('date'));
         			$years.find("men").each(function(){
         				var $men = $(this);
         				menArr.push($men);
         			});
         			$years.find("women").each(function(){
         				var $ladies = $(this);
         				ladiesArr.push($ladies);
         			});
         			$years.find("doublem").each(function(){
         				var $dblMs = $(this);
         				dblmArr.push($dblMs);
         			});
         			$years.find("doublef").each(function(){
         				var $dblFs = $(this);
         				dblfArr.push($dblFs);
         			});
         			$years.find("doublex").each(function(){
         				var $dblXs = $(this);
         				dblxArr.push($dblXs);
         			});
         		});
         		makeWinnerstables(0);
         		}
         }); // END XML
         //WINNERS TABLES
         var yearClick=9;
         function makeWinnerstables(yr){
         		yearClick=yr;
         		for (var i=0;i<10;i++){
         			if(i==yr){
         				sym.getSymbol("winners").getSymbol("yearBtnStrip").getSymbol("yearBtns").$("yearBtn"+yr).css({'color':'rgba(0,0,0,1)','border-bottom':'solid 2px rgba(111,44,145,1.00)'});
         			}else{
         				sym.getSymbol("winners").getSymbol("yearBtnStrip").getSymbol("yearBtns").$("yearBtn"+i).css({'color':'rgba(0,0,0,0.4)','border-bottom':'solid 2px rgba(111,44,145,0)'});
         			}
         		}
         		sym.getSymbol("winners").getSymbol("menBlock").$("menTable").empty();
         		sym.getSymbol("winners").getSymbol("ladiesBlock").$("ladiesTable").empty();
         		sym.getSymbol("winners").$("doublesTable").empty();
         		var singleTabM="<table class='singletab winnertab'>";
         			singleTabM+="<tr><td id='msnglW' class='winner'></td><td id='s0m1' class='set'></td><td id='s1m1' class='set'></td><td id='s2m1' class='set'></td><td id='s3m1' class='set'></td><td id='s4m1' class='set'></td></tr>";
         			singleTabM+="<tr><td class='beat'></td><td colspan='5' class='set'></td></tr>";
         			singleTabM+="<tr><td id='msnglL' class='loser'></td><td id='s0m2' class='set'></td><td id='s1m2' class='set'></td><td id='s2m2' class='set'></td><td id='s3m2' class='set'></td><td id='s4m2' class='set'></td></tr>";
         			singleTabM+="</table>";
         		sym.getSymbol("winners").getSymbol("menBlock").$("menTable").append(singleTabM);
         			$('#msnglW').html(menArr[yr].find('winner').text()+" <span class='nat'>"+menArr[yr].find('natwinner').text()+"</span>");
         			$('#msnglL').html(menArr[yr].find('loser').text()+" <span class='nat'>"+menArr[yr].find('natloser').text()+"</span>");
         			var sm1=menArr[yr].find('sets1').text();
         			var sm2=menArr[yr].find('sets2').text();
         			var set1mArr=sm1.split(";");
         			var set2mArr=sm2.split(";");
         			for (var i=0;i<set1mArr.length;i++){
         				$('#s'+i+'m1').html(set1mArr[i]);
         				$('#s'+i+'m2').html(set2mArr[i]);
         			}
         		var singleTabF="<table class='singletab winnertab'>";
         			singleTabF+="<tr><td id='fsnglW' class='winner'></td><td id='s0f1' class='set'></td><td id='s1f1' class='set'></td><td id='s2f1' class='set'></td></tr>";
         			singleTabF+="<tr><td class='beat'></td><td colspan='3' class='set'></td></tr>";
         			singleTabF+="<tr><td id='fsnglL' class='loser'></td><td id='s0f2' class='set'></td><td id='s1f2' class='set'></td><td id='s2f2' class='set'></td></tr>";
         			singleTabF+="</table>";
         		sym.getSymbol("winners").getSymbol("ladiesBlock").$("ladiesTable").append(singleTabF);
         			$('#fsnglW').html(ladiesArr[yr].find('winner').text()+" <span class='nat'>"+ladiesArr[yr].find('natwinner').text()+"</span>");
         			$('#fsnglL').html(ladiesArr[yr].find('loser').text()+" <span class='nat'>"+ladiesArr[yr].find('natloser').text()+"</span>");
         			var sf1=ladiesArr[yr].find('sets1').text();
         			var sf2=ladiesArr[yr].find('sets2').text();
         			var set1fArr=sf1.split(";");
         			var set2fArr=sf2.split(";");
         			for (var i=0;i<set1fArr.length;i++){
         				$('#s'+i+'f1').html(set1fArr[i]);
         				$('#s'+i+'f2').html(set2fArr[i]);
         			}
         		var doubleTab="<table id='doubletab' class='winnertab'>";
         			doubleTab+="<tr id='mdbl'><td id='mdblW' class='winner'></td><td class='beat'><td id='mdblL' class='loser'></td><td id='mdblR' class='res'></td></tr>";
         			doubleTab+="<tr id='fdbl'><td id='fdblW' class='winner'></td><td class='beat'><td id='fdblL' class='loser'></td><td id='fdblR' class='res'></td></tr>";
         			doubleTab+="<tr id='xdbl'><td id='xdblW' class='winner'></td><td class='beat'><td id='xdblL' class='loser'></td><td id='xdblR' class='res'></td></tr>";
         			doubleTab+="</table>";
         		sym.getSymbol("winners").$("doublesTable").append(doubleTab);
         			$(".beat").html(txt[5]);
         			$("#mdblW").html(dblmArr[yr].find('winner0').text()+" <span class='nat'>"+dblmArr[yr].find('natwinner0').text()+"</span>, "+dblmArr[yr].find('winner1').text()+" <span class='nat'>"+dblmArr[yr].find('natwinner1').text()+"</span>");
         			$("#mdblL").html(dblmArr[yr].find('loser0').text()+" <span class='nat'>"+dblmArr[yr].find('natloser0').text()+"</span>, "+dblmArr[yr].find('loser1').text()+" <span class='nat'>"+dblmArr[yr].find('natloser1').text()+"</span>");
         			$("#mdblR").html(dblmArr[yr].find('score').text());
         			$("#fdblW").html(dblfArr[yr].find('winner0').text()+" <span class='nat'>"+dblfArr[yr].find('natwinner0').text()+"</span>, "+dblfArr[yr].find('winner1').text()+" <span class='nat'>"+dblfArr[yr].find('natwinner1').text()+"</span>");
         			$("#fdblL").html(dblfArr[yr].find('loser0').text()+" <span class='nat'>"+dblfArr[yr].find('natloser0').text()+"</span>, "+dblfArr[yr].find('loser1').text()+" <span class='nat'>"+dblfArr[yr].find('natloser1').text()+"</span>");
         			$("#fdblR").html(dblfArr[yr].find('score').text());
         			$("#xdblW").html(dblxArr[yr].find('winner0').text()+" <span class='nat'>"+dblxArr[yr].find('natwinner0').text()+"</span>, "+dblxArr[yr].find('winner1').text()+" <span class='nat'>"+dblxArr[yr].find('natwinner1').text()+"</span>");
         			$("#xdblL").html(dblxArr[yr].find('loser0').text()+" <span class='nat'>"+dblxArr[yr].find('natloser0').text()+"</span>, "+dblxArr[yr].find('loser1').text()+" <span class='nat'>"+dblxArr[yr].find('natloser1').text()+"</span>");
         			$("#xdblR").html(dblxArr[yr].find('score').text());
         		//tables css
         			$(".winnertab").css({'font-family':'pragmatica-web,sans-serif','font-size':'14px','border':0});
         			$(".singletab").css({'width':'325px'});
         			$("#doubletab").css({'border-collapse':'collapse'});
         			$(".singletab td").css({'background-color':'rgb(0,150,81)','color':'white','border-top':'solid 1px black','border-left':'solid 1px black'});
         			$(".singletab .winner").css({'padding-left':'3px','font-weight':700 });
         			$(".loser").css({'padding-left':'3px','font-style':'italic'});	
         			$("doubletab tr").css({'height':'18px'});
         			$(".nat").css({'font-size':'80%'});
         			$(".beat").css({'padding':'0 10px'});
         			$(".res").css({'padding-left':'10px'});
         			$(".set").css({'font-weight':700,'padding':'0 5px','text-align':'center','width':'3.5%'});
         			$(".tie").css({ 'vertical-align': 'super','font-size': '70%','font-weight':400});
         }
         //SIZE CONDITIONAL
         var clicked=0;
         var mobile=(sym.$("Stage").width()>480)?0:1;
         function initSize(){
         	var stageWidth=sym.$("Stage").width();
         	var widthLog=Math.log(stageWidth)/Math.LN10;
         	for (var i=0;i<12;i++){
         	 if (i%2==0){
         		sym.getSymbol("grid").$("col"+i).css({'left':(Math.log(i)/Math.LN10)*(((stageWidth-40)/2)-160)});//log10(i)
         		sym.getSymbol("grid").$("c"+i).css({'left':(Math.log(i)/Math.LN10)*(((stageWidth-40)/2)-160)});//log10(i)
         	 }else{
         		sym.getSymbol("grid").$("col"+i).css({'right':(Math.log(i-1)/Math.LN10)*(((stageWidth-40)/2)-160)});
         		sym.getSymbol("grid").$("c"+i).css({'right':(Math.log(i-1)/Math.LN10)*(((stageWidth-40)/2)-160)});
         	 }
         	}
         	sym.getSymbol("grid").$("col12").css({'left':stageWidth/2-160+'px'});
         	sym.getSymbol("grid").$("cf").css({'left':stageWidth/2-160+'px'});
         	sym.getSymbol("grid").$("upDown").css({'left':stageWidth/2-26+'px'});
         	var boxWidth=sym.getSymbol('grid').$('matchBox').width();
         	sym.getSymbol('grid').$('matchBox').css({'left':stageWidth/2-boxWidth/2+'px'});
         	sym.getSymbol("winners").$("yearBtnStrip").css({'width':stageWidth-40+'px'});
         	var cupWidth=sym.getSymbol("grid").$("trophy").width();
         	sym.getSymbol("grid").$("trophy").css({'left':stageWidth/2-cupWidth/2});
         	var matchWidth=sym.$('latest').width();
         	sym.$('latest').css({'left':stageWidth/2-matchWidth/2});
         	var selectWidth=sym.$('selection').width();
         	sym.$('selection').css({'left':stageWidth/2-selectWidth/2});
         	if(stageWidth<800){
         		$(".res").fadeOut(0);
         	}else{
         		$(".res").fadeIn(0);
         	}
         	if(stageWidth<640){
         		sym.getSymbol("winners").getSymbol("menBlock").$("menTable").css({'right':'5px','left':'auto','width':'58%'});
         		txtArr[1].css({'right':'5px','left':'auto','width':'58%'});
         		sym.getSymbol("winners").getSymbol("ladiesBlock").$("ladiesTable").css({'left':'5px','right':'auto','width':'58%'});
         		txtArr[2].css({'left':'5px','right':'auto','width':'58%'});
         		 $(".singletab").css({'width':'100%'});
         		// $(".versus").css({'width':'99%'});
         	}else{
         		sym.getSymbol("winners").getSymbol("menBlock").$("menTable").css({'right':'auto','left':'237px','width':'325px'});
         		txtArr[1].css({'right':'auto','left':'237px','width':'325px'});	
         		sym.getSymbol("winners").getSymbol("ladiesBlock").$("ladiesTable").css({'left':'auto','right':'237px','width':'325px'});
         		txtArr[2].css({'left':'auto','right':'237px','width':'325px'});
         		 $(".singletab").css({'width':'325px'});
         		 //$(".versus").css({'width':'99%'});//Jun 29
         	}	
         	if (stageWidth<480){
         		mobile=1;
         		//css for mobile
         		var picWidth=sym.getSymbol("winners").$("menPic").width();
         		sym.getSymbol("winners").$("menPic").css({'left':stageWidth/2-picWidth/2});
         		sym.getSymbol("winners").$("ladiesPic").css({'right':stageWidth/2-picWidth/2});
         		menuTxt.fadeOut(0);
         		$("#doubletab .beat, #doubletab .loser").fadeOut(0);
         		sym.getSymbol("latest").$("timezoneTxt").fadeOut(0);
         		for (var i=0;i<menuArray.length;i++){
         			sym.getSymbol("styleHead").$("menuBtn" +i).css({'width':'11%','right':22-(i*11)+'%'});
         		}
         		 $(".singles").css({'width':'100%','left':'5px'});
         		 sym.getSymbol("winners").$("menBlock").css({'top':'150px'});
         		 sym.getSymbol("winners").$("ladiesBlock").css({'top':'350px'});
         		 $(".latestmatch").css({'font-size':'12px'});
         		 sym.getSymbol("styleHead").$("headlinetxt").css({'font-size':'20px'});
         		 sym.getSymbol('grid').$('champ').css({'width':'10%','height':'auto'});
         		for (var i=0;i<5;i++){
         			sym.getSymbol("selection").$("selectBtn"+i).css({'left':'5px','width':'100%'});
         		}
         	}else{
         		mobile=0;
         		//css for desktop
         		sym.getSymbol("winners").$("menPic").css({'left':'3%'});
         		sym.getSymbol("winners").$("ladiesPic").css({'right':'3%'});
         		menuTxt.fadeIn(0);
         		$("#doubletab .beat, #doubletab .loser").fadeIn(0);
         		sym.getSymbol("latest").$("timezoneTxt").fadeIn(0);
         		$(".loser").fadeIn(0);
         		for (var i=0;i<menuArray.length;i++){
         			sym.getSymbol("styleHead").$("menuBtn" +i).css({'width':'45px','right':90-(i*45)+'px'});
         		}
         		sym.getSymbol("winners").$("menBlock").css({'top':'95px'});
         		sym.getSymbol("winners").$("ladiesBlock").css({'top':'308px'});
         		$(".latestmatch").css({'font-size':'14px'});
         		sym.getSymbol("styleHead").$("headlinetxt").css({'font-size':'24px'});
         		sym.getSymbol('grid').$('champ').css({'width':'52px','height':'auto'});
         		for (var i=0;i<5;i++){
         			sym.getSymbol("selection").$("selectBtn"+i).css({'left':selectWidth/2-165+"px",'width':'330px'});
         		}
         	}
         	var champWidth=sym.getSymbol('grid').$('champ').width();
         	sym.getSymbol('grid').$('champ').css({'left':stageWidth/2-champWidth/2+'px'});
         	var dblWidth=sym.getSymbol('winners').$('txt4').width();
         	sym.getSymbol("winners").$("doublesTable").css({'left':dblWidth+10+'px'});
         }
         var wWidth = $(window).width();//only change css on window width
         $(window).resize(function(){
           if(wWidth != $(window).width()){
             initSize();
             wWidth = $(window).width();
           }
         });
         // MENU BUTTONS --------------------------------------------	
         menuArray = []; //the array that will hold references to the buttons.
         for (var m = 0; m < 4; m++){
         	sym.getSymbol("styleHead").getSymbol("menuBtn"+m).$("menuIcon").attr('src',"images/icon"+m+".png");
         	var menuBtnSymbols = sym.getSymbol("styleHead").getSymbol("menuBtn" +m); 
         	menuBtnSymbols.setVariable("menuId", m);
         	menuArray.push(menuBtnSymbols);
         	sym.getSymbol("styleHead").$("menuBtn" +m).css({"cursor":"pointer"});
         }
         $.each(menuArray, function( count, menuInTheArray ){
         				var menuBtnElement = menuInTheArray.getSymbolElement();
         				menuBtnElement.off ("click",menuBtnClick);
         					menuBtnElement.on ("click", {menuId:count}, menuBtnClick);
         					menuBtnElement.on ("mouseover", {menuId:count}, menuBtnOver);
         					menuBtnElement.on ("mouseout", {menuId:count}, menuBtnOut);
         				});
         function resetmenu(){
         	for (var i=0;i<menuArray.length;i++){
         		menuArray[i].$("menuBg").fadeIn(0);
         	}
         }
         var genderSelect=0;
         var played=0;
         function menuBtnClick (e){
         		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
         		clicked=menuMenu_id;
         		var btnWidth=sym.getSymbol("styleHead").$("menuBtn0").width();
         		for (var i=0;i<menuArray.length;i++){
         			if(i==menuMenu_id){
         				menuArray[menuMenu_id].$("menuBg").fadeOut(0);
         				menuTxt.html(menuTxtArr[menuMenu_id]);
         				sym.$(screenArr[i]).fadeIn(0);
         					if (i>=2){
         						for (var n=0;n<menuArray.length;n++){
         							sym.getSymbol("styleHead").$("menuBtn"+n).animate({'right':(btnWidth*3)-(btnWidth*n)},400, 'easeOutQuad');
         						}
         						menuTxt.stop().animate({'right':(btnWidth*4)+5},400, 'easeOutQuad');
         						sym.getSymbol("grid").$("trophy").css({'width':'100%','max-width':'415px','height':'auto'});
         						if(i==2){
         							if(played==0){ sym.getSymbol(screenArr[2]).play(); played=1;}
         						}
         					}else{
         						menuTxt.stop().animate({'right':(btnWidth*3)+5},400, 'easeOutQuad');
         						for (var n=0;n<menuArray.length;n++){
         							sym.getSymbol("styleHead").$("menuBtn"+n).animate({'right':(btnWidth*2)-(btnWidth*n)},400, 'easeOutQuad');
         					}
         				}
         			}else{
         				sym.$(screenArr[i]).fadeOut(0);
         				menuArray[i].$("menuBg").fadeIn(0);
         			}	
         		}
         		initSize();
         		e.preventDefault();
         		e.stopPropagation();
         }
         function menuBtnOver(e){
         	e.preventDefault();
         	e.stopPropagation();
         	var menuMenu_id = (e.data.menuId);
         	menuArray[menuMenu_id].$("menuBg").fadeOut(0);
         	menuTxt.html(menuTxtArr[menuMenu_id]);
         }
         function menuBtnOut(e){
         	e.preventDefault();
         	e.stopPropagation();
         	var menuMenu_id = (e.data.menuId);
         	for (var i=0;i<menuArray.length;i++){
         		if(menuMenu_id!=clicked){
         			menuArray[menuMenu_id].$("menuBg").fadeIn(0);
         			menuTxt.html(menuTxtArr[clicked]);
         		}
         	}
         }
         //MORE BUTTONS
         var showLocal=0;
         sym.getSymbol("latest").$("timezone").on("click",function(){ 
                  		if(showLocal==0){ 
                  		showLocal=1; 
                  		getLive();
                  		}else{ 
                  		showLocal=0;
                  		getLive(); 
                  		} 
         				sym.getSymbol("latest").$("timezoneTxt").html(timetxt[showLocal]);
          });
         sym.getSymbol("latest").$("timezone").on("mouseover",function(){ 
                  	if (showLocal==0){  sym.getSymbol("latest").$("timezoneTxt").html(timetxt[1]);  }else{  sym.getSymbol("latest").$("timezoneTxt").html(timetxt[0]);  }});
         sym.getSymbol("latest").$("timezone").on("mouseout",function(){ 
                  	if (showLocal==0){  sym.getSymbol("latest").$("timezoneTxt").html(timetxt[0]);  }else{  sym.getSymbol("latest").$("timezoneTxt").html(timetxt[1]);  }});
         sym.getSymbol("latest").$("timezone").css({'cursor':'pointer'});
         //Select a Championship
         var champSelect=0;
         var selectChamp= function(champ){
         	return function(e){
         		champ<2?(sym.getSymbol("grid").$("trophy").attr('src','images/trophy'+champ+'.png'), sym.getSymbol("grid").$("trophy").fadeIn(0)):(sym.getSymbol("grid").$("trophy").fadeOut(0));
         		getMatches(champ);
         		sym.$("grid").fadeIn(0);
         		sym.getSymbol("grid").play();
         		sym.$("selection").fadeOut(400);
         		initSize();
         		menuArray[2].$("menuBg").fadeIn(0);clicked=2;
         		clearInterval(fixInterval);
         		if(status<2){ fixInterval=setInterval(getMatches(champ),300000);}//if tournament hasn't finished
         		champSelect=champ;
         	};
         };
         var overChamp= function(champ){
         	return function(e){
         				sym.getSymbol("selection").getSymbol("selectBtn"+champ).$("btnTxt").css({'color':'rgb(0,0,0)'});
         				sym.getSymbol("selection").getSymbol("selectBtn"+champ).$("panel").css({'opacity':1});
         			};
         };
         var outChamp= function(champ){
         	return function(e){
         				sym.getSymbol("selection").getSymbol("selectBtn"+champ).$("btnTxt").css({'color':'rgb(100,100,100)'});
         				sym.getSymbol("selection").getSymbol("selectBtn"+champ).$("panel").css({'opacity':0});
         			};
         };
         for (var n=0;n<5;n++){
         	sym.getSymbol("selection").getSymbol("selectBtn"+n).$("btnImg").attr('src','images/gender'+n+'.png');
         	sym.getSymbol("selection").$("selectBtn"+n).css({'cursor':'pointer'});
         	sym.getSymbol("selection").$("selectBtn"+n).on('click',selectChamp(n));
         	sym.getSymbol("selection").$("selectBtn"+n).on('mouseover',overChamp(n));
         	sym.getSymbol("selection").$("selectBtn"+n).on('mouseout',outChamp(n));
         }
         //change grid level
         var current;
         var levSelect;
         var changeLevel= function(lev){
         	return function(e){
         		//champSelect - show different cols depending on championship
         		levSelect=(lev==0)?levSelect-1:levSelect+1;
         		(levSelect<current)?sym.getSymbol("grid").getSymbol("upDown").$("btn1").fadeIn(0):sym.getSymbol("grid").getSymbol("upDown").$("btn1").fadeOut(0);
         		(levSelect==1)?sym.getSymbol("grid").getSymbol("upDown").$("btn0").fadeOut(0):sym.getSymbol("grid").getSymbol("upDown").$("btn0").fadeIn(0);
         		var cols=(champSelect<2)?13:11;//no of columns: number of levels = cols/2+1
         		for (var c=0;c<14;c++){
         			sym.getSymbol("grid").$("col"+c).css({'opacity':0});
         		}
         		for (c=0;c<2*(levSelect-1);c++){
         			sym.getSymbol("grid").$("col"+c).css({'opacity':0.15});//change opacity of all earlier phases
         		}
         		for (c=2*(levSelect-1);c<2*levSelect;c++){
         			levSelect>cols/2?sym.getSymbol("grid").$("col12").css({'opacity':1}):sym.getSymbol("grid").$("col"+c).css({'opacity':1});
         		}
         		clearInterval(fixInterval);
         	};
         };
         var overLevel= function(lev){
         	return function(e){
         				$(this).css({'opacity':1});
         			};
         };
         var outLevel= function(lev){
         	return function(e){
         				$(this).css({'opacity':0.65});
         			};
         };
         for (var b=0;b<2;b++){
         	sym.getSymbol("grid").getSymbol("upDown").$("btn"+b).on('click',changeLevel(b));
         	sym.getSymbol("grid").getSymbol("upDown").$("btn"+b).on('mouseover',overLevel(b));
         	sym.getSymbol("grid").getSymbol("upDown").$("btn"+b).on('mouseout',outLevel(b));
         }
         //MATCHBOX
         sym.getSymbol('grid').getSymbol('matchBox').$('close').on('click',function(){	sym.getSymbol('grid').$('matchBox').fadeOut(400); });//Jun 29
         sym.getSymbol('grid').getSymbol('matchBox').$('close').css({'cursor':'pointer'});
         
         //MISC
         function sortNumber(a,b) {
             return a - b;
         }
         //CHECK DATE
         var startDate = Date.parse("June 29, 2015, 05:59 UTC");
         var endDate = Date.parse("July 13, 2015, 23:59 UTC");
         var todayDate;
         var status;
         function getDate(){
         	todayDate = new Date();
         	if(todayDate<startDate){
         		status=0;
         	}else if(todayDate>endDate){
         		status=2;
         	}else{
         		status=1;
         	}
         }
         getDate();
         //Before seeds open with previous winners, before draw open with seeds, after draw open with latest matches, after end open with route to final
         //DATE FUNCTIONS --------------------------------------------
         var localOffset=todayDate.getTimezoneOffset()*60000;
         var cetOffset=7200000;
         function getDDMMYY(thisDateStr) {
                     var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
                     //var thisDate = new Date(parseInt(dateTxt, 10));
                     var thisDate = new Date(parseInt((dateTxt+localOffset), 10));
                     var mm = thisDate.getMonth() + 1;
                     var dd = thisDate.getDate();
                     mm = ((mm < 10) ? '0' : "") + mm;
                     dd = ((dd < 10) ? '0' : "") + dd;
                     return dd + "/" + mm + "/" + (thisDate.getFullYear()).toString();
                 }
         function getDDmonthYY(thisDateStr) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var matchDate=thisDate.getTime() +localOffset;
         	var matchTime=new Date(matchDate);
         	var mm = matchTime.getMonth();
         	var dd = matchTime.getDate();
         	var retDate=(dateFormat=="dayMonth")?dd.toString() +monthsArr[mm]:monthsArr[mm] + " " + dd.toString();//allows different date formats
         	return retDate;
         } 
         function getMatchVenue(thisDateStr,braziltime){
         	var timeTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(timeTxt, 10));
         	var thisTime = thisDate.getTime()+localOffset-braziltime;//localOffset to UTC - offset to venue location(e.g.Brazil)
         	var matchTime = new Date(thisTime);
         	var hh = matchTime.getHours();
         	var mm = parseInt(matchTime.getMinutes(),10);
         	mm=(mm<10)?"0"+mm:mm;
         	return hh+":"+mm;	
         }
         function getDateMyzone(thisDateStr) {
         	var dateTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(dateTxt, 10));
         	var mm = thisDate.getMonth();
         	var dd = thisDate.getDate();
         	var retDate=(dateFormat=="dayMonth")?dd.toString() +monthsArr[mm]:monthsArr[mm] + " " + dd.toString();//allows different date formats
         	return retDate
         	}
         function getMatchMyzone(thisDateStr){
         	var timeTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var thisDate = new Date(parseInt(timeTxt, 10));
         	var hh = thisDate.getHours();
         	var mm = parseInt(thisDate.getMinutes(),10);
         	mm=(mm<10)?"0"+mm:mm;
         	return hh+":"+mm;
         }
         function parsedDate(thisDateStr){
         	var matchRndDate = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
         	var dDate = parseInt(matchRndDate,10)+localOffset;
         	return dDate;
         } 
         var offsetVenue;//Offset between time at venue and UTC
         function getDST(thisDateStr,offsetZone){
         	var thisDate = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf('+'));
         	//if(thisDate<startDate||thisDate>endDate){
         	//	var offsetUTC = -3600000-offsetZone;
         	//}else{
         		var offsetUTC = 0-offsetZone;
         	//}
         	return offsetUTC;
         }
         var matchInterval;
         var showMatch= function(match){
         	return function(e){
         				clearInterval(matchInterval);
         				getMatch(match);
         				sym.getSymbol('grid').$('matchBox').fadeIn(400);
         				matchInterval=setInterval(getMatch(match),30000);
         			};
         };
         //LIVE DATA
         var latestPhase=[];//current stage, e.g. q-final
         var numMatches=[];//number of matches in first round
         var todayPhase;
         function getChamps(){
         	for (var n=0;n<champsArr.length;n++){
         		$.ajax({ type: "GET", 
         			url: dataURL,
         			data: "gn="+gn+"&sport=tennis&yr="+gnYear+"&q=phases&phase="+champsArr[n],
         			contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         			async: true,
         			crossDomain: true,
         			success: function (data) {
         				for (var i=0; i<data.length; i++){											
         						var thisPhase=data[i].n_PhaseID;
         						if(data[i].b_Current==true){ latestPhase.push(data[i].n_PhaseID); }//latest phase ID
         				}
         				numMatches.push((data[0].n_PhaseLevel)-1);
         			}
         		});
         	}
         }
         getChamps();
         function getLive(){
         	$.ajax({ type: "GET", 
         		url: dataURL,
         		data: "gn="+gn+"&type=tennis&yr="+gnYear+"&q=live",
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			if (data.length>0){
         				status=1;
         				sym.getSymbol("latest").$("table").empty();
         				var offsetZone=3600000;//venue offset to UTC
         				var statArr=[];
         				for (var i=0; i<data.length; i++){											
         					var compId = data[i].n_EventPhaseID;
         					var phaseNr = data[i].n_PhaseNr;
         					var mstatus = data[i].n_StatusCode;
         					statArr.push(mstatus);
         					var matchID = data[i].n_MatchID;
         					var pl1ID=(data[i].n_Person1ID!=null)?data[i].n_Person1ID:"";var pl2ID=(data[i].n_Person2ID)?data[i].n_Person2ID:"";
         					var player1=(data[i].c_Participant1!=null)?data[i].c_Participant1:""; var player2=(data[i].c_Participant2!=null)?data[i].c_Participant2:"";
         					var player1Nat=(data[i].c_Participant1NatioShort!=null)?data[i].c_Participant1NatioShort:""; var player2Nat=(data[i].c_Participant2NatioShort!=null)?data[i].c_Participant2NatioShort:"";
         					var player1Set1=(data[i].n_Score1Set1!=null)?data[i].n_Score1Set1:""; var player2Set1=(data[i].n_Score2Set1!=null)?data[i].n_Score2Set1:"";
         					var player1Tie1=(data[i].n_Score1Tiebreak1!=null)?" <span class='tie'>"+data[i].n_Score1Tiebreak1+"</span>":"";
         					var player2Tie1=(data[i].n_Score2Tiebreak1!=null)?" <span class='tie'>"+data[i].n_Score2Tiebreak1+"</span>":"";
         					var player1Set2=(data[i].n_Score1Set2!=null)?data[i].n_Score1Set2:""; var player2Set2=(data[i].n_Score2Set2!=null)?data[i].n_Score2Set2:"";
         					var player1Tie2=(data[i].n_Score1Tiebreak2!=null)?" <span class='tie'>"+data[i].n_Score1Tiebreak2+"</span>":"";
         					var player2Tie2=(data[i].n_Score2Tiebreak2!=null)?" <span class='tie'>"+data[i].n_Score2Tiebreak2+"</span>":"";
         					var player1Set3=(data[i].n_Score1Set3!=null)?data[i].n_Score1Set3:""; var player2Set3=(data[i].n_Score2Set3!=null)?data[i].n_Score2Set3:"";
         					var player1Tie3=(data[i].n_Score1Tiebreak3!=null)?" <span class='tie'>"+data[i].n_Score1Tiebreak3+"</span>":"";
         					var player2Tie3=(data[i].n_Score2Tiebreak3!=null)?" <span class='tie'>"+data[i].n_Score2Tiebreak3+"</span>":"";
         					var player1Set4=(data[i].n_Score1Set4!=null)?data[i].n_Score1Set4:""; var player2Set4=(data[i].n_Score2Set4!=null)?data[i].n_Score2Set4:"";
         					var player1Tie4=(data[i].n_Score1Tiebreak4!=null)?" <span class='tie'>"+data[i].n_Score1Tiebreak4+"</span>":"";
         					var player2Tie4=(data[i].n_Score2Tiebreak4!=null)?" <span class='tie'>"+data[i].n_Score2Tiebreak4+"</span>":"";
         					var player1Set5=(data[i].n_Score1Set5!=null)?data[i].n_Score1Set5:""; var player2Set5=(data[i].n_Score2Set5!=null)?data[i].n_Score2Set5:"";
         					var player1Tie5=(data[i].n_Score1Tiebreak5!=null)?" <span class='tie'>"+data[i].n_Score1Tiebreak5+"</span>":"";
         					var player2Tie5=(data[i].n_Score2Tiebreak5!=null)?" <span class='tie'>"+data[i].n_Score2Tiebreak5+"</span>":"";
         					var comp = champsArr.indexOf(compId);
         					//men, ladies, mdouble, fdouble, mixed 
         					phaseCaption=(comp<2)?phaseNr<4?txt[9]+" "+phaseNr:txt[5+phaseNr]:phaseNr<3?txt[9]+" "+phaseNr:txt[6+phaseNr];
         					var offsetVenue = getDST(data[i].d_Date,offsetZone);//match time
         					var matchTime=(showLocal!=0)?getDateMyzone(data[i].d_Date)+", "+getMatchMyzone(data[i].d_Date):getDDmonthYY(data[i].d_Date)+", "+getMatchVenue(data[i].d_Date,offsetVenue);
         					var gender="<img src='images/gender"+comp+".png'> "+phaseCaption+": <span style='font-weight:400'>"+matchTime+"</span>";
         					var seed1=(data[i].n_SeedNr1!=null)?' ['+data[i].n_SeedNr1+']':'';var seed2=(data[i].n_SeedNr2!=null)?' ['+data[i].n_SeedNr2+']':'';
         					var latestTab= "<table id='latest"+i+"' class='latestmatch'>";
         					latestTab+="<tr><td id='gender"+i+"' class='gender' colspan='"+((comp==0||comp==2)?5:3)+"'></td><tr>";
         					latestTab+="<tr id='player1match"+i+"' class='latestrow'>";
         					latestTab+="<td id='name1match"+i+"' class='latest lname'></td>";
         					latestTab+="<td id='pl1set1match"+i+"' class='latest sets'></td>";
         					latestTab+="<td id='pl1set2match"+i+"' class='latest sets'></td>";
         					latestTab+="<td id='pl1set3match"+i+"' class='latest sets'></td>";
         					if (comp==0||comp==2){ 
         					latestTab+="<td id='pl1set4match"+i+"' class='latest sets'></td>";
         					latestTab+="<td id='pl1set5match"+i+"' class='latest sets'></td>"
         					}
         					latestTab+="</tr>";
         					latestTab+="<tr id='player2match"+i+"' class='latestrow'>";
         					latestTab+="<td id='name2match"+i+"' class='latest lname'></td>";
         					latestTab+="<td id='pl2set1match"+i+"' class='latest sets'></td>";
         					latestTab+="<td id='pl2set2match"+i+"' class='latest sets'></td>";
         					latestTab+="<td id='pl2set3match"+i+"' class='latest sets'></td>";
         					if (comp==0||comp==2){ 
         					latestTab+="<td id='pl2set4match"+i+"' class='latest sets'></td>";
         					latestTab+="<td id='pl2set5match"+i+"' class='latest sets'></td>"
         					}
         					latestTab+="</tr>";
         					latestTab+="</table>";
         					var nextTab="<table id='next"+i+"' class='nextmatch'>";
         					nextTab+="<tr><td id='gender"+i+"' class='gender'></td></tr>";
         					nextTab+="<tr><td id='versus"+i+"' class='versus latest'></td></tr>";
         					nextTab+="</table>";
         					mstatus>=8?sym.getSymbol("latest").$("table").append(latestTab):sym.getSymbol("latest").$("table").append(nextTab);
         					//i==0?$("#next"+i).css({'margin':'15px 5px 3px 5px'}):$("#next"+i).css({'margin':'3px 5px'});//Jun 29
         					//$("#next"+i).css({'padding':'3px 5px'});
         					$("#versus"+i).html(player1+" <span class='nat'>"+player1Nat+"</span>"+seed1+" "+txt[13]+player2+" <span class='nat'>"+player2Nat+"</span>"+seed2);//Jun 29 seeds
         					$("#gender"+i).html(gender);
         					$("#name1match"+i).html(player1+" <span class='nat'>"+player1Nat+"</span>"+seed1+(data[i].n_ServingFirstInCurrentSetPersonID==pl1ID?"<div class='serve'></div>":""));
         					$("#name2match"+i).html(player2+" <span class='nat'>"+player2Nat+"</span>"+seed2+(data[i].n_ServingFirstInCurrentSetPersonID==pl2ID?"<div class='serve'></div>":""));
         					$("#pl1set1match"+i).html(player1Set1+player1Tie1);$("#pl1set2match"+i).html(player1Set2+player1Tie2);$("#pl1set3match"+i).html(player1Set3+player1Tie3);$("#pl1set4match"+i).html(player1Set4+player1Tie4);$("#pl1set5match"+i).html(player1Set5+player1Tie5);
         					$("#pl2set1match"+i).html(player2Set1+player2Tie1);$("#pl2set2match"+i).html(player2Set2+player2Tie2);$("#pl2set3match"+i).html(player2Set3+player2Tie3);$("#pl2set4match"+i).html(player2Set4+player2Tie4);$("#pl2set5match"+i).html(player2Set5+player2Tie5);
         					$('#gender'+i).css({'color':'black','font-weight':700});
         				}
         				$(".serve").css({'background-color':'white','width':'10px','height':'10px','border-radius':'5px','float':'right'});
         				//$(".nextmatch").css({'font-family':'pragmatica-web,sans-serif','color':'white','font-size':'14px'});
         				$(".versus").css({'display':'inline-block','padding':'0 3px', 'font-weight':700,'width':'99%'});//Jun 29 
         				$(".gender").css({'display':'inline','padding-right':'5px'});
         				$(".latestmatch, .nextmatch").css({'width':'100%','padding':'0px 2%','font-family':'pragmatica-web,sans-serif','color':'white','font-size':'14px','margin':'3px 0'});
         				$(".latest").css({'background-color':'rgb(0,150,81)','border-top':'solid 1px black','border-left':'solid 1px black'});
         				$(".sets").css({'width':'8%', 'text-align':'center'});
         				$(".nat, .tie").css({'font-size':'80%'});
         				$(".lname").css({'font-weight':700, 'padding-left':'3px'});
         				$(".gender img").css({'width':'30px'});
         				sym.getSymbol("latest").$("table").css({'overflow-y':'auto'});
         				var highest=Math.max.apply(null,statArr);
         				if (highest>=128){//Finished
         				 txtArr[0].html(txtAlt[1]);
         				}else if(highest>=4&&highest<128){//Live
         					txtArr[0].html(txtAlt[0]);
         				}else{
         					txtArr[0].html(txt[0]);
         				}
         			}else{
         					status==1?txtArr[0].html(txtAlt[3]):txtArr[0].html(txtAlt[2]);
         			}
         		},
         		error: function () {
         			txtArr[0].html(txtAlt[2]);
         		}
            });
         }
         getLive();
         function getMatches(champ){
         	$.ajax({ type: "GET", 
         		url: dataURL,
         		data: "gn="+gn+"&sport=tennis&yr="+gnYear+"&q=matches&phase="+champsArr[champ],
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			sym.getSymbol("grid").$("champ").attr('src','images/gender'+champ+'.png');
         			if(data.length>0){
         				for (var i=0;i<13;i++){
         					sym.getSymbol("grid").$("col"+i).empty();
         				}
         				var matchUnsort=[];
         				var matchSort=[];
         				//var current;
         				for (var i=0; i<data.length; i++){											
         					var matchNr =data[i].n_MatchNr;
         					matchUnsort.push(matchNr);
         				}
         				//status=2;
         				for (var n=0;n<data.length; n++){					//if matches are in the right phase, display
         					var dNr=matchUnsort.indexOf(n+1);
         					var matchID=data[dNr].n_MatchID;
         					var phase= data[dNr].n_PhaseID;
         					var winner= data[dNr].n_Winner;
         					var seed1=data[dNr].n_SeedNr1; var seed2=data[dNr].n_SeedNr2;
         					var nameShort1=(champ<2)?data[dNr].c_Participant1Short:data[dNr].c_Participant1;
         					var nameShort2=(champ<2)?data[dNr].c_Participant2Short:data[dNr].c_Participant2;
         					var score1=data[dNr].n_Result1; var score2=data[dNr].n_Result2;
         					if(n==data.length-1){
         					var player1Set1=(data[n].n_Score1Set1!=null)?data[n].n_Score1Set1:""; var player2Set1=(data[n].n_Score2Set1!=null)?data[n].n_Score2Set1:"";
         					var player1Tie1=(data[n].n_Score1Tiebreak1!=null)?" <span class='tie'>"+data[n].n_Score1Tiebreak1+"</span>":"";
         					var player2Tie1=(data[n].n_Score2Tiebreak1!=null)?" <span class='tie'>"+data[n].n_Score2Tiebreak1+"</span>":"";
         					var player1Set2=(data[n].n_Score1Set2!=null)?data[n].n_Score1Set2:""; var player2Set2=(data[n].n_Score2Set2!=null)?data[n].n_Score2Set2:"";
         					var player1Tie2=(data[n].n_Score1Tiebreak2!=null)?" <span class='tie'>"+data[n].n_Score1Tiebreak2+"</span>":"";
         					var player2Tie2=(data[n].n_Score2Tiebreak2!=null)?" <span class='tie'>"+data[n].n_Score2Tiebreak2+"</span>":"";
         					var player1Set3=(data[n].n_Score1Set3!=null)?data[n].n_Score1Set3:""; var player2Set3=(data[n].n_Score2Set3!=null)?data[n].n_Score2Set3:"";
         					var player1Tie3=(data[n].n_Score1Tiebreak3!=null)?" <span class='tie'>"+data[n].n_Score1Tiebreak3+"</span>":"";
         					var player2Tie3=(data[n].n_Score2Tiebreak3!=null)?" <span class='tie'>"+data[n].n_Score2Tiebreak3+"</span>":"";
         					var player1Set4=(data[n].n_Score1Set4!=null)?data[n].n_Score1Set4:""; var player2Set4=(data[n].n_Score2Set4!=null)?data[n].n_Score2Set4:"";
         					var player1Tie4=(data[n].n_Score1Tiebreak4!=null)?" <span class='tie'>"+data[n].n_Score1Tiebreak4+"</span>":"";
         					var player2Tie4=(data[n].n_Score2Tiebreak4!=null)?" <span class='tie'>"+data[n].n_Score2Tiebreak4+"</span>":"";
         					var player1Set5=(data[n].n_Score1Set5!=null)?data[n].n_Score1Set5:""; var player2Set5=(data[n].n_Score2Set5!=null)?data[n].n_Score2Set5:"";
         					var player1Tie5=(data[n].n_Score1Tiebreak5!=null)?" <span class='tie'>"+data[n].n_Score1Tiebreak5+"</span>":"";
         					var player2Tie5=(data[n].n_Score2Tiebreak5!=null)?" <span class='tie'>"+data[n].n_Score2Tiebreak5+"</span>":"";
         					}
         					if(latestPhase.indexOf(phase)>0){//if this phase is the current one
         						var lat=latestPhase.indexOf(phase);
         						var numberOfMatches=numMatches[lat];//no of matches in 1st round
         						var cols=(numberOfMatches==64)?13:11;//no of columns: number of levels = cols/2+1
         						current = data[dNr].n_PhaseNr; //to get latest column to front
         					}
         					if (data[dNr].n_MatchNr==n+1){
         						if(champ<2){
         							if (n<32){ drwCol=0; }else if (n>=32&&n<64){ drwCol=1; }else if(n>=64&&n<80){ drwCol=2; }else if(n>=80&&n<96){ drwCol=3;
         							}else if(n>=96&&n<104){ drwCol=4; }else if(n>=104&&n<112){ drwCol=5; }else if(n>=112&&n<116){ drwCol=6;
         							}else if(n>=116&&n<120){ drwCol=7; }else if(n>=120&&n<122){ drwCol=8; }else if(n>=122&&n<124){ drwCol=9;
         							}else if(n>=124&&n<125){ drwCol=10; }else if(n>=125&&n<126){ drwCol=11; }else{ drwCol=12; }
         						}else{//only 65 matches
         							var nom = numberOfMatches;
         							var nom1=nom/2;
         							for (var a=0;a<Math.round(cols/2);a++){//quick calc
         								var x=Math.pow(2,a)/2;
         							}
         							if (n<16){ drwCol=0; }else if (n>=16&&n<32){ drwCol=1; }else if(n>=32&&n<40){ drwCol=2; }else if(n>=40&&n<48){ drwCol=3; }else if(n>=48&&n<52){ drwCol=4; }else if(n>=52&&n<56){ drwCol=5; }else if(n>=56&&n<58){ drwCol=6; }else if(n>=58&&n<60){ drwCol=7; }else if(n>=60&&n<61){ drwCol=8; }else if(n>=61&&n<62){ drwCol=9; }else{ drwCol=12; }
         						}
         						var matchTab = "<div id='matchList"+n+"' class='matchtable'>";
         						matchTab += (winner==1)?"<div id='player1m"+n+"' class='win player1'>":"<div id='player1m"+n+"' class='player1'>";
         						matchTab += "<div id='name1m"+n+"' class='name'></div><div id='score1m"+n+"' class='score'></div></div>";
         						matchTab += (winner==2)?"<div id='player2m"+n+"' class='win player2'>":"<div id='player2m"+n+"' class='player2'>";
         						matchTab += (champ<2)?"<div id='score2m"+n+"' class='score'></div><div id='name2m"+n+"' class='name'></div>":"<div id='name2m"+n+"' class='name'></div><div id='score2m"+n+"' class='score'></div>";
         						matchTab += "</div></div>";
         						var finalTab= "<table id='finalList' class='finaltable'>";
         						finalTab+="<tr><td class='final title'>"+txt[12]+"</td><td class='final'>"+txt[16]+"</td><td class='final' colspan='"+((champ==0||champ==2)?5:3)+"'></td><tr>";
         						finalTab+="<tr id='player1match"+n+"' class='finalrow'><td id='name1m"+n+"' class='final fname'></td><td id='sets1m"+n+"' class='final fscore sets'></td>";
         						finalTab+="<td id='fp1set1match"+n+"' class='final sets'></td><td id='fp1set2match"+n+"' class='final sets'></td><td id='fp1set3match"+n+"' class='final sets'></td>";
         						if (champ==0||champ==2){ 
         						finalTab+="<td id='fp1set4match"+n+"' class='final sets'></td><td id='fp1set5match"+n+"' class='final sets'></td>";
         						}
         						finalTab+="</tr>";
         						finalTab+="<tr id='player2match"+n+"' class='finalrow'><td id='name2m"+n+"' class='final fname'></td><td id='sets2m"+n+"' class='final fscore sets'></td>";
         						finalTab+="<td id='fp2set1match"+n+"' class='final sets'></td><td id='fp2set2match"+n+"' class='final sets'></td><td id='fp2set3match"+n+"' class='final sets'></td>";
         						if (champ==0||champ==2){ 
         						finalTab+="<td id='fp2set4match"+n+"' class='final sets'></td><td id='fp2set5match"+n+"' class='final sets'></td>";
         						}
         						finalTab+="</tr>";
         						finalTab+="</table>";
         						drwCol==12?sym.getSymbol("grid").$("col12").append(finalTab):sym.getSymbol("grid").$("col"+drwCol).append(matchTab);
         						$(".matchtable").css({'font-family':'pragmatica-web,sans-serif','font-size':'11px','padding':'0 3px'});
         						$(".finaltable").css({'font-family':'pragmatica-web,sans-serif','font-size':'13px','padding':'0 3px','color':'white','width':'100%'});
         						$(".final").css({'background-color':'rgb(0,150,81)','border-top':'solid 1px black','border-left':'solid 1px black'});
         						var bgcolor=(n%2==0)?"rgb(220,240,235)":"rgb(255,255,255)";
         						$("#matchList"+n).css({'background-color':bgcolor,'cursor':'pointer'});
         						$("#matchList"+n).on('click',showMatch(matchID));
         						if(drwCol>1){ $("#matchList"+n).css({'box-shadow': '2px 2px 2px rgba(100,100,100,0.5)'}); }
         						if(drwCol==2||drwCol==3){
         							$("#matchList"+n).css({'margin':'15px 0'});
         						}else if(drwCol==4||drwCol==5){
         							$("#matchList"+n).css({'margin':'40px 0'});
         						}else if(drwCol==6||drwCol==7){
         							$("#matchList"+n).css({'margin':'70px 0'});
         						}else if(drwCol==8||drwCol==9){
         							$("#matchList"+n).css({'margin':'100px 0'});
         						}else if(drwCol==10||drwCol==11){
         							$("#matchList"+n).css({'margin':'130px 0'});
         						}else{
         							$("#matchList"+n).css({'margin':'0'});
         						}
         						$("#name1m"+n).html(nameShort1);$("#name2m"+n).html(nameShort2);$("#score1m"+n).html(score1);$("#score2m"+n).html(score2);
         						$("#sets1m"+n).html(score1);$("#sets2m"+n).html(score2);
         						$("#fp1set1match"+n).html(player1Set1+player1Tie1);$("#fp1set2match"+n).html(player1Set2+player1Tie2);$("#fp1set3match"+n).html(player1Set3+player1Tie3);$("#fp1set4match"+n).html(player1Set4+player1Tie4);$("#fp1set5match"+n).html(player1Set5+player1Tie5);
         						$("#fp2set1match"+n).html(player2Set1+player2Tie1);$("#fp2set2match"+n).html(player2Set2+player2Tie2);$("#fp2set3match"+n).html(player2Set3+player2Tie3);$("#fp2set4match"+n).html(player2Set4+player2Tie4);$("#fp2set5match"+n).html(player2Set5+player2Tie5);
         						champ<2?($(".player1, .player2").css({'display':'table-cell','text-align':'left','width':'80px','max-width':'87px','min-width':'71px'}),$(".name").css({'display':'table-cell','width':'72px'})):
         						($(".player1, .player2").css({'text-align':'left'}),$(".name").css({'display':'table-cell','width':'150px'}));
         						$(".score").css({'display':'table-cell','padding':'0 3px','width':'10%'});
         						$(".tie").css({'font-size':'80%'});
         						$(".sets").css({'width':'8%', 'text-align':'center'});
         						$(".win, .fname, .fscore, .title").css({'font-weight':700});
         					}
         				}
         				if(current>1){
         					sym.getSymbol('grid').getSymbol('upDown').$('btn0').fadeIn(0);
         						for (var c=0;c<14;c++){
         							sym.getSymbol("grid").$("col"+c).css({'opacity':0});
         						}
         						for (c=0;c<2*(current-1);c++){
         							sym.getSymbol("grid").$("col"+c).css({'opacity':0.15});//change opacity of all earlier phases
         						}
         						for (c=2*(current-1);c<2*current;c++){
         							current>cols/2?sym.getSymbol("grid").$("col12").css({'opacity':1}):sym.getSymbol("grid").$("col"+c).css({'opacity':1});
         						}
         
         				}
         				levSelect=current;//for up down buttons
         				sym.getSymbol('grid').getSymbol('upDown').$('btn1').fadeOut(0);
         			}else{
         			getSeeds(champ);
         			}
         		}
            });
         }
         getMatches(0);
         var fixInterval=setInterval(getMatches(0),300000);
         function getSeeds(champ){
         	$.ajax({ type: "GET", 
         		url: dataURL,
         		data: "gn="+gn+"&sport=tennis&yr="+gnYear+"&q=seeds&phase="+champsArr[champ],
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         			var odd=0;
         			sym.getSymbol("grid").$("champ").attr('src','images/gender'+champ+'.png');
         			if (data.length>0){
         				menuTxt.html(txt[15]);//Seeds
         				//status=2;
         				for (var i=0; i<data.length; i++){											
         					var seed=data[i].n_Rank;
         					var name=data[i].c_Participant;
         					var nation=data[i].c_ParticipantNatioShort;
         					var persons=128;
         					var seedTab = "<div id='seedList"+i+"' class='seedtable'>";
         					seedTab += "<div id='seedPlayer"+i+"' class='splayer'>";
         					seedTab += "<div id='seedRank"+i+"' class='srank'></div><div id='seedName"+i+"' class='sname'></div><div id='seednat"+i+"' class='snat'></div></div>";
         					seedTab += "</div>";
         					if(i<32){
         						if(i%2==0){
         						sym.getSymbol("grid").$("col0").append(seedTab);
         						}else{
         						sym.getSymbol("grid").$("col1").append(seedTab);
         						}
         					}
         					$("#seedRank"+i).html(seed);
         					$("#seedName"+i).html(name);
         					$("#seednat"+i).html(nation);
         					if(i%2==0){odd++;}
         					var bgcolor=(odd%2==0)?"rgba(220,240,235,0.8)":"rgba(255,255,255,0.8)";
         					$("#seedList"+i).css({'background-color':bgcolor})
         				}
         				$(".seedtable").css({'font-family':'pragmatica-web,sans-serif','font-size':'11px','padding':'0 3px'});
         				$(".srank").css({'display':'table-cell','text-align':'right','font-weight':700,'width':'20px'});
         				$(".sname").css({'display':'table-cell','text-align':'left','padding':'0 3px'});
         				$(".snat").css({'display':'table-cell','text-align':'left','font-style':'italic','font-size':'80%'});				
         			}else{
         					menuTxt.html(menuTxtArr[0]);//show winners
         					status=0;
         			}
         		}
            });
         }
         //getSeeds(0);
         function getMatch(match){
         	$.ajax({ type: "GET", 
         		url: dataURL,
         		data: "gn="+gn+"&sport=tennis&yr="+gnYear+"&match="+match,
         		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
         		async: true,
         		crossDomain: true,
         		success: function (data) {
         				sym.getSymbol('grid').getSymbol('matchBox').$('table').empty();
         				var offsetZone=3600000;//venue offset to UTC
         //function mkMatchTable(i){
         		if(data.length>0){//Jun 29
         			var winner= data[0].n_Winner;
         			var qual1=data[0].c_Suffix1;//qualifier=='Qual'
         			var qual2=data[0].c_Suffix2;
         			var seed1=data[0].n_SeedNr1;var seed2=data[0].n_SeedNr2;
         			var name1=data[0].c_Participant1;var name2=data[0].c_Participant2;
         					var score1=data[0].n_Result1;var score2=data[0].n_Result2;
         					var compId = data[0].n_EventPhaseID;
         					var phase = data[0].n_PhaseNr;
         					var mstatus = data[0].n_StatusCode;
         					var matchID = data[0].n_MatchID;
         					var pl1ID=(data[0].n_Person1ID!=null)?data[0].n_Person1ID:"";var pl2ID=(data[0].n_Person2ID)?data[0].n_Person2ID:"";
         					var player1=(data[0].c_Participant1!=null)?data[0].c_Participant1:""; var player2=(data[0].c_Participant2!=null)?data[0].c_Participant2:"";
         					var player1Nat=(data[0].c_Participant1NatioShort!=null)?data[0].c_Participant1NatioShort:""; var player2Nat=(data[0].c_Participant2NatioShort!=null)?data[0].c_Participant2NatioShort:"";
         					var player1Set1=(data[0].n_Score1Set1!=null)?data[0].n_Score1Set1:""; var player2Set1=(data[0].n_Score2Set1!=null)?data[0].n_Score2Set1:"";
         					var player1Tie1=(data[0].n_Score1Tiebreak1!=null)?" <span class='tie'>"+data[0].n_Score1Tiebreak1+"</span>":"";
         					var player2Tie1=(data[0].n_Score2Tiebreak1!=null)?" <span class='tie'>"+data[0].n_Score2Tiebreak1+"</span>":"";
         					var player1Set2=(data[0].n_Score1Set2!=null)?data[0].n_Score1Set2:""; var player2Set2=(data[0].n_Score2Set2!=null)?data[0].n_Score2Set2:"";
         					var player1Tie2=(data[0].n_Score1Tiebreak2!=null)?" <span class='tie'>"+data[0].n_Score1Tiebreak2+"</span>":"";
         					var player2Tie2=(data[0].n_Score2Tiebreak2!=null)?" <span class='tie'>"+data[0].n_Score2Tiebreak2+"</span>":"";
         					var player1Set3=(data[0].n_Score1Set3!=null)?data[0].n_Score1Set3:""; var player2Set3=(data[0].n_Score2Set3!=null)?data[0].n_Score2Set3:"";
         					var player1Tie3=(data[0].n_Score1Tiebreak3!=null)?" <span class='tie'>"+data[0].n_Score1Tiebreak3+"</span>":"";
         					var player2Tie3=(data[0].n_Score2Tiebreak3!=null)?" <span class='tie'>"+data[0].n_Score2Tiebreak3+"</span>":"";
         					var player1Set4=(data[0].n_Score1Set4!=null)?data[0].n_Score1Set4:""; var player2Set4=(data[0].n_Score2Set4!=null)?data[0].n_Score2Set4:"";
         					var player1Tie4=(data[0].n_Score1Tiebreak4!=null)?" <span class='tie'>"+data[0].n_Score1Tiebreak4+"</span>":"";
         					var player2Tie4=(data[0].n_Score2Tiebreak4!=null)?" <span class='tie'>"+data[0].n_Score2Tiebreak4+"</span>":"";
         					var player1Set5=(data[0].n_Score1Set5!=null)?data[0].n_Score1Set5:""; var player2Set5=(data[0].n_Score2Set5!=null)?data[0].n_Score2Set5:"";
         					var player1Tie5=(data[0].n_Score1Tiebreak5!=null)?" <span class='tie'>"+data[0].n_Score1Tiebreak5+"</span>":"";
         					var player2Tie5=(data[0].n_Score2Tiebreak5!=null)?" <span class='tie'>"+data[0].n_Score2Tiebreak5+"</span>":"";
         					var comp = champsArr.indexOf(compId);
         					//men, ladies, mdouble, fdouble, mixed 
         					phaseCaption=(comp<2)?phase<4?txt[9]+" "+phase:txt[5+phase]:phase<3?txt[9]+" "+phase:txt[6+phase];
         					var offsetVenue = getDST(data[0].d_Date,offsetZone);//match time
         					var matchTime=(showLocal!=0)?getDateMyzone(data[0].d_Date)+", "+getMatchMyzone(data[0].d_Date):getDDmonthYY(data[0].d_Date)+", "+getMatchVenue(data[0].d_Date,offsetVenue);
         					var gender="<img src='images/gender"+comp+".png' style='width:30px'> "+phaseCaption+": <span style='font-weight:400'>"+matchTime+"</span>";//Jun 29 width
         					var seed1=(data[0].n_SeedNr1!=null)?' ['+data[0].n_SeedNr1+']':'';var seed2=(data[0].n_SeedNr2!=null)?' ['+data[0].n_SeedNr2+']':'';
         					var matchTab= "<table id='match"+match+"' class='latestmatch'>";
         					matchTab+="<tr id='player1match"+match+"' class='latestrow'>";
         					matchTab+="<td id='name1match"+match+"' class='latest lname'></td>";
         					matchTab+="<td id='p1set1m"+match+"' class='latest sets'></td>";
         					matchTab+="<td id='p1set2m"+match+"' class='latest sets'></td>";
         					matchTab+="<td id='p1set3m"+match+"' class='latest sets'></td>";
         					if (comp==0||comp==2){ 
         					matchTab+="<td id='p1set4m"+match+"' class='latest sets'></td>";
         					matchTab+="<td id='p1set5m"+match+"' class='latest sets'></td>"
         					}
         					matchTab+="</tr>";
         					matchTab+="<tr id='player2match"+match+"' class='latestrow'>";
         					matchTab+="<td id='name2match"+match+"' class='latest lname'></td>";
         					matchTab+="<td id='p2set1m"+match+"' class='latest sets'></td>";
         					matchTab+="<td id='p2set2m"+match+"' class='latest sets'></td>";
         					matchTab+="<td id='p2set3m"+match+"' class='latest sets'></td>";
         					if (comp==0||comp==2){ 
         					matchTab+="<td id='p2set4m"+match+"' class='latest sets'></td>";
         					matchTab+="<td id='pl2set5m"+match+"' class='latest sets'></td>"
         					}
         					matchTab+="</tr>";
         					matchTab+="</table>";
         				sym.getSymbol('grid').getSymbol('matchBox').$('table').append(matchTab);
         				sym.getSymbol('grid').getSymbol('matchBox').$('matchTxt').html(gender);
         				$("#name1match"+match).html(player1+" <span class='nat'>"+player1Nat+"</span>"+seed1+(data[0].n_ServingFirstInCurrentSetPersonID==pl1ID?"<div class='serve'></div>":""));
         				$("#name2match"+match).html(player2+" <span class='nat'>"+player2Nat+"</span>"+seed2+(data[0].n_ServingFirstInCurrentSetPersonID==pl2ID?"<div class='serve'></div>":""));
         				$("#p1set1m"+match).html(player1Set1+player1Tie1); $("#p1set2m"+match).html(player1Set2+player1Tie2); $("#p1set3m"+match).html(player1Set3+player1Tie3); $("#p1set4m"+match).html(player1Set4+player1Tie4); $("#p1set5m"+match).html(player1Set5+player1Tie5);
         				$("#p2set1m"+match).html(player2Set1+player2Tie1); $("#p2set2m"+match).html(player2Set2+player2Tie2); $("#p2set3m"+match).html(player2Set3+player2Tie3); $("#p2set4m"+match).html(player2Set4+player2Tie4); $("#p2set5m"+match).html(player2Set5+player2Tie5);
         				//$('#gender'+i).css({'color':'black','font-weight':700});
         				$(".serve").css({'background-color':'white','width':'10px','height':'10px','border-radius':'5px','float':'right'});
         				$(".gender").css({'display':'inline','padding-right':'5px'});
         				$(".latestmatch").css({'width':'100%','padding':'0 2%','font-family':'pragmatica-web,sans-serif','color':'white','font-size':'14px'});
         				$(".latest").css({'background-color':'rgb(0,150,81)','border-top':'solid 1px black','border-left':'solid 1px black'});
         				$(".sets").css({'width':'8%', 'text-align':'center'});
         				$(".nat, .tie").css({'font-size':'80%'});
         				$(".lname").css({'font-weight':700, 'padding-left':'3px'});
         				$(".gender img").css({'width':'30px'});
         				sym.getSymbol("latest").$("table").css({'overflow-y':'auto'});
         				console.log(player1Set3+" "+player1Tie3);
         			}//end if
         		}
            });
         }
         function initShow(){
         //getLive();
         sym.$(screenArr[status]).fadeIn(0);
         menuArray[status].$("menuBg").fadeOut(0);
         initSize();
         }
         setTimeout(initShow, 400);
         if(status==0){
         var liveInterval=setInterval(getLive,600000);
         }else if(status==1){
         var liveInterval=setInterval(getLive,60000);
         }else{
         clearInterval(getLive);
         clearInterval(fixInterval);
         }
         //TEAM STRIP BUTTONS	
         //EDIT THE FOLLOWING	NUMBERS
         var thumbWidth=76; //distance between origin of thumbnail images
         var space = 0; //pixels offset at beginning of buttonstrip
         var ttime= 500; //transition time in milliseconds
         //END CHANGES
         //TOUCH / DRAG SLIDER Declare variables for use in touch functions
         var num=10; //total number of images
         var rail = sym.getSymbol("winners").$("yearBtnStrip");
         var railWidth;
         var thumbs;
         function getRail(){
         railWidth = rail.width();//width of the slder
         thumbs = railWidth/thumbWidth; //number of thumbnails visible at same time
         }
         getRail();
         var railX = rail.offset().left; //distance from left hand side at which slider starts
         var railRightX = railX + railWidth;
         var startX=0;
         var moveIt=0
         var startPos=railX;
         rail.on("touchstart", touchStartX); //binds touch function to slider
         rail.on("touchmove", moveMe); //binds touch function to slider
         //strip details
         var stripShow = sym.getSymbol("winners").getSymbol("yearBtnStrip").$("yearBtns");
         var stripWidth = stripShow.width();
         var moveStrip = stripWidth-railWidth;
         function touchStartX(e){ //handle touch event
         		startX = e.touches[0].pageX;
         }	
         function moveMe(e) {
         	e.preventDefault(); //prevents it firing a click when touched
         	e.stopPropagation();
         	var orig = e.originalEvent;
         	var pos = 0;
         	pos = orig.touches[0].pageX;
         	var moveDistance=startX-pos;
         	moveIt=startPos-moveDistance;   
         	if(pos>=railX&&pos<=railRightX){
         		if(moveIt<=0&&moveIt>=-moveStrip){
         			stripShow.css({'left':moveIt});
         		}
         	}
         };
         function handleTouchUp(jqEvent){ // handle touchup event
         	sym.getComposition().getStage().getSymbolElement().unbind("touchmove");
         	sym.getComposition().getStage().getSymbolElement().unbind("touchend");
         }
         var makeTables= function(year){
         	return function(e){
         		sym.getSymbol("winners").$("menPic").attr('src','images/m'+(2014-year)+'.png');
         		sym.getSymbol("winners").$("ladiesPic").attr('src','images/f'+(2014-year)+'.png');
         		makeWinnerstables(year);
         		initSize();
         		getRail();
         		var moveIt=0;
         				if(year<Math.round(thumbs/2)){
         						moveIt=0; 
         				}else	if(year>=Math.round(thumbs/2)&&(year<num-Math.round(thumbs/2))){
         						moveIt=((year-Math.floor(thumbs/2))*-(thumbWidth));
         				}else{ 
         						moveIt=((num-Math.round(thumbs))*-(thumbWidth));
         				}
         				sym.getSymbol("winners").getSymbol("yearBtnStrip").$("yearBtns").stop().animate ({'left': moveIt}, ttime);
         				startPos=moveIt;//record new position					
         				sym.setVariable("strip", Math.floor(year/thumbs));
         				sym.setVariable("number", year);
         		e.preventDefault();
         		e.stopPropagation();
         	};
         };
         var yearOver= function(year){
         	return function(e){
         		if(year!=yearClick){sym.getSymbol("winners").getSymbol("yearBtnStrip").getSymbol("yearBtns").$("yearBtn"+year).css({'color':'rgba(0,0,0,0.7)'});}
         	};
         };
         var yearOut= function(year){
         	return function(e){
         		if(year!=yearClick){sym.getSymbol("winners").getSymbol("yearBtnStrip").getSymbol("yearBtns").$("yearBtn"+year).css({'color':'rgba(0,0,0,0.4)'});}
         	};
         };
         for (var b=0;b<10;b++){
         sym.getSymbol("winners").getSymbol("yearBtnStrip").getSymbol("yearBtns").$("yearBtn"+b).on('click', makeTables(b));
         sym.getSymbol("winners").getSymbol("yearBtnStrip").getSymbol("yearBtns").$("yearBtn"+b).css({'cursor':'pointer'});
         sym.getSymbol("winners").getSymbol("yearBtnStrip").getSymbol("yearBtns").$("yearBtn"+b).on('mouseover',yearOver(b));
         sym.getSymbol("winners").getSymbol("yearBtnStrip").getSymbol("yearBtns").$("yearBtn"+b).on('mouseout',yearOut(b));
         }
         var mvStrip= function(x){
         	return function(e){
         		getRail();
         		x==1?sym.getSymbol("winners").getSymbol("yearBtnStrip").$("yearBtns").stop().animate ({'left': ((num-Math.round(thumbs))*-(thumbWidth))}, ttime):sym.getSymbol("winners").getSymbol("yearBtnStrip").$("yearBtns").stop().animate ({'left': 15}, ttime);
         	};
         };
         for (var i=0;i<2;i++){
         sym.getSymbol("winners").$("btn"+i).on('click',mvStrip(i));
         }

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleHead'
   (function(symbolName) {   
   
   })("StyleHead");
   //Edge symbol end:'StyleHead'

   //=========================================================
   
   //Edge symbol: 'MenuBtn'
   (function(symbolName) {   
   
   })("MenuBtn");
   //Edge symbol end:'MenuBtn'

   //=========================================================
   
   //Edge symbol: 'Base'
   (function(symbolName) {   
   
   })("Base");
   //Edge symbol end:'Base'

   //=========================================================
   
   //Edge symbol: 'grid'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 350, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 375, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 475, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 500, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 600, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 625, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 700, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("Grid");
   //Edge symbol end:'Grid'

   //=========================================================
   
   //Edge symbol: 'Winners'
   (function(symbolName) {   
   
   })("Winners");
   //Edge symbol end:'Winners'

   //=========================================================
   
   //Edge symbol: 'Latest'
   (function(symbolName) {   
   
   })("Latest");
   //Edge symbol end:'Latest'

   //=========================================================
   
   //Edge symbol: 'YearBtnStrip'
   (function(symbolName) {   
   
   })("YearBtnStrip");
   //Edge symbol end:'YearBtnStrip'

   //=========================================================
   
   //Edge symbol: 'MenBlock'
   (function(symbolName) {   
   
   })("MenBlock");
   //Edge symbol end:'MenBlock'

   //=========================================================
   
   //Edge symbol: 'LadiesBlock'
   (function(symbolName) {   
   
   })("LadiesBlock");
   //Edge symbol end:'LadiesBlock'

   //=========================================================
   
   //Edge symbol: 'yearBtns'
   (function(symbolName) {   
   
   })("yearBtns");
   //Edge symbol end:'yearBtns'

   //=========================================================
   
   //Edge symbol: 'Selection'
   (function(symbolName) {   
   
   })("Selection");
   //Edge symbol end:'Selection'

   //=========================================================
   
   //Edge symbol: 'SelectBtn'
   (function(symbolName) {   
   
   })("SelectBtn");
   //Edge symbol end:'SelectBtn'

   //=========================================================
   
   //Edge symbol: 'MatchMc'
   (function(symbolName) {   
   
   })("MatchMc");
   //Edge symbol end:'MatchMc'

   //=========================================================
   
   //Edge symbol: 'UpDown'
   (function(symbolName) {   
   
   })("UpDown");
   //Edge symbol end:'UpDown'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33126");