/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "click" : "click");
         	var clicked = 0;
         	var btnNo = 0;
         	var slide = -140;
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var stand;
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         // MENU TEXT START
         	var menuTxt=[];
         	menuTxt[0] = sym.getSymbol("menuBtnsMc").$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[1] = sym.$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[2] = sym.$("menuTxt").css({"pointer-events":"none"});
         	var menuArr=[];
         
         	for (var b=0;b<3; b++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+b).$("txt").html(b + 1);
         	} // MENU TEXT END
         
         	var outBtn  = {"background-color":"rgba(0,0,0,0.4)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         
         	var txt=[];
         	for (var i=0;i<13; i++){
         		txt[i] = sym.getSymbol("sceneMc1").$("txt" + i).css({"pointer-events":"none"});
         	}
         	txt[13] = sym.$("txt13").css({"pointer-events":"none"});
         	txt[14] = sym.$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.$("txt17").css({"pointer-events":"none"});
         	txt[18] = sym.$("txt18").css({"pointer-events":"none"});
         	txt[19] = sym.$("txt19").css({"pointer-events":"none"});
         	for (var i=20;i<29; i++){
         		txt[i] = sym.getSymbol("sceneMc1").$("txt" + i).css({"pointer-events":"none"});
         	}
         	for (var i=29;i<36; i++){
         		txt[i] = sym.getSymbol("sceneMc0").$("txt" + i).css({"pointer-events":"none"});
         	}
         	for (var i=36;i<56; i++){
         		txt[i] = sym.getSymbol("sceneMc2").$("txt" + i).css({"pointer-events":"none"});
         	}
         
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33093.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("styleHead").$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			// MENU TEXT START
         			for (var i=0; i<3; i++){
         				menuArr[i]=$(xml).find('menuTxt'+i).text();
         				menuTxt[i].html(menuArr[i]);
         			} // MENU TEXT END
         
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<56; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         			sym.getSymbol("sceneMc1").$("txt4").css({"height":"auto"});
         			sym.getSymbol("sceneMc1").$("txt7").css({"height":"auto"});
         			sym.getSymbol("sceneMc1").$("txt20").css({"height":"auto"});
         			sym.getSymbol("sceneMc2").$("txt46").css({"height":"auto"});
         			sym.getSymbol("sceneMc2").$("txt47").css({"height":"auto"});
         			sym.getSymbol("sceneMc1").$("txt12").animate({top:110 + sym.getSymbol("sceneMc1").$("txt4").height()+10}, 0);
         			sym.getSymbol("sceneMc1").$("txt7").animate({top:571 - sym.getSymbol("sceneMc1").$("txt7").height()+7}, 0);
         			sym.getSymbol("sceneMc1").$("icons").animate({top:552 - sym.getSymbol("sceneMc1").$("txt7").height()+6}, 0);
         			sym.getSymbol("sceneMc1").$("txt20").animate({top:265 - sym.getSymbol("sceneMc1").$("txt20").height()+14}, 0);
         			sym.getSymbol("sceneMc2").$("txt46").animate({top:407 - sym.getSymbol("sceneMc2").$("txt46").height()+14}, 0);
         			sym.getSymbol("sceneMc2").$("txt47").animate({top:300 - sym.getSymbol("sceneMc2").$("txt47").height()+14}, 0);
         
         		}
         	}); // END XML
         
         sym.$("sceneMc2").stop().animate ({opacity:0}, 0, function(){ 
         		sym.$("sceneMc2").stop().animate ({left:800}, 0);
         	});
         
         // MENU BUTTONS --------------------------------------------	
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<3; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(outBtn);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.$("sceneMc2").stop().animate ({opacity:0}, 200, function(){ 
         				sym.$("sceneMc2").stop().animate ({left:800}, 0);
         			});
         		if (menuNo == 0){
         			sym.$("sceneMc0").fadeIn(250);
         		}
         		if (menuNo == 1){
         			sym.$("sceneMc0").fadeOut(250);
         		}
         		if (menuNo == 2){
         			sym.$("sceneMc2").stop().animate ({left:0}, 0, function(){ 
         				sym.$("sceneMc2").stop().animate ({opacity:1}, 400);
         			});
         		}
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[menuNo]);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OVER
         var menuBtnOver = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[menuNo]);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OUT
         var menuBtnOut = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[clicked]);
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(outBtn);
         		if (clicked == menuNo){
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on(clickEventType,menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseover',menuBtnOver(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseout',menuBtnOut(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(overBtn);
         
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         var outNav  = {"background-color":"rgba(0,0,0,1)"};
         var overNav = {"background-color":"rgba(218,0,0,1)"};
         
         var accused = 0;
         sym.getSymbol("sceneMc1").$("nextBtn").on(clickEventType, function(e){
         	accused++;
         	btnClick();
         	e.stopPropagation(); e.preventDefault();
         	});
         sym.getSymbol("sceneMc1").$("nextBtn").mouseover(function(){
         	sym.getSymbol("sceneMc1").getSymbol("nextBtn").$("bg").css(outNav);
         	});
         sym.getSymbol("sceneMc1").$("nextBtn").mouseout(function(){
         	sym.getSymbol("sceneMc1").getSymbol("nextBtn").$("bg").css(overNav);
         	});
         
         sym.getSymbol("sceneMc1").$("backBtn").on(clickEventType, function(e){
         	accused--;
         	btnClick();
         	e.stopPropagation(); e.preventDefault();
         	});
         sym.getSymbol("sceneMc1").$("backBtn").mouseover(function(){
         	sym.getSymbol("sceneMc1").getSymbol("backBtn").$("bg").css(outNav);
         	});
         sym.getSymbol("sceneMc1").$("backBtn").mouseout(function(){
         	sym.getSymbol("sceneMc1").getSymbol("backBtn").$("bg").css(overNav);
         	});
         
         
         // START CLICK FUNCTION
         function btnClick(){ 
         	sym.getSymbol("sceneMc1").$("backBtn").fadeIn(0);
         	sym.getSymbol("sceneMc1").$("nextBtn").fadeIn(0);
         	sym.getSymbol("sceneMc1").$("txt12").empty();
         	sym.getSymbol("sceneMc1").$("txt12").append(txtArr[accused + 12]);
         
         	sym.getSymbol("sceneMc1").getSymbol("accusedMc").$("accused").stop().delay(0).animate ({left:accused*slide}, 300, 'easeOutCubic');
         
         	if (accused == 0) {
         		sym.getSymbol("sceneMc1").$("backBtn").fadeOut(0);
         	}
         	if (accused == 7) {
         		sym.getSymbol("sceneMc1").$("nextBtn").fadeOut(0);
         	}
         } // END CLICK FUNCTION
         btnClick();
         
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtn_1'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("auxBtnsMc");
   //Edge symbol end:'auxBtnsMc'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'sceneMc1'
   (function(symbolName) {   
   
   })("sceneMc1");
   //Edge symbol end:'sceneMc1'

   //=========================================================
   
   //Edge symbol: 'accusedMc'
   (function(symbolName) {   
   
   })("accusedMc");
   //Edge symbol end:'accusedMc'

   //=========================================================
   
   //Edge symbol: 'sceneMc0'
   (function(symbolName) {   
   
   })("sceneMc0");
   //Edge symbol end:'sceneMc0'

   //=========================================================
   
   //Edge symbol: 'sceneMc2'
   (function(symbolName) {   
   
   })("sceneMc2");
   //Edge symbol end:'sceneMc2'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNews33093");