/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "click" : "click");
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var stand;
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         var redBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(218,0,0,1)", "width":"auto", "padding":"6px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"};
         var blackBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto", "padding":"6px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"};
         var whiteBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,1)", "width":"auto", "padding":"6px", "padding-left":"28px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"};
         var yellowBox = {"border-width":"1px", "border-color":"white","border-style":"solid", "border-radius":"5px","background-color":"rgba(250,175,25,1)", "height":"auto", "padding":"6px"};
         
         	var outBtn  = {"background-color":"rgba(255,255,255,0.2)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         
         	var txt=[];
         
         	for(var i=0;i<24; i++){
         		txt[i] = sym.getSymbol("mapTxtMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for(var i=31;i<52; i++){
         		txt[i] = sym.getSymbol("zoom2Mc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for(var i=52;i<56; i++){
         		txt[i] = sym.getSymbol("zoom1Mc").$("txt"+i).css({"pointer-events":"none"});
         	}
         
         	txt[24] = sym.$("txt24").css({"pointer-events":"none"});
         	txt[25] = sym.getSymbol("mapTxtMc").getSymbol("iconMc0").$("txt25").css({"pointer-events":"none", "height":"auto"});
         	txt[26] = sym.getSymbol("mapTxtMc").getSymbol("iconMc1").$("txt26").css({"pointer-events":"none", "height":"auto"});
         	txt[27] = sym.getSymbol("mapTxtMc").getSymbol("iconMc2").$("txt27").css({"pointer-events":"none", "height":"auto"});
         	txt[28] = sym.getSymbol("mapTxtMc").getSymbol("iconMc3").$("txt28").css({"pointer-events":"none", "height":"auto"});
         	txt[29] = sym.$("txt29").css(yellowBox);
         	txt[30] = sym.$("txt30").css(yellowBox);
         
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33071.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("styleHead").$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<56; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         			var icon0 = sym.getSymbol("mapTxtMc").getSymbol("iconMc0").$("txt25").height()
         			var icon1 = sym.getSymbol("mapTxtMc").getSymbol("iconMc1").$("txt26").height()
         			var icon2 = sym.getSymbol("mapTxtMc").getSymbol("iconMc2").$("txt27").height()
         
         			sym.getSymbol("mapTxtMc").$("iconMc1").animate({top:-4 + icon0 +15}, 0);
         			sym.getSymbol("mapTxtMc").$("iconMc2").animate({top:-4 + icon0 + icon1 +25}, 0);
         			sym.getSymbol("mapTxtMc").$("iconMc3").animate({top:-4 + icon0 + icon1 + icon2 +35}, 0);
         
         			sym.getSymbol("zoom2Mc").$("txt32").css(redBox);
         			sym.getSymbol("zoom2Mc").$("txt33").css(blackBox);
         			sym.getSymbol("zoom2Mc").$("txt38").css(blackBox);
         			sym.getSymbol("zoom2Mc").$("txt44").css(whiteBox);
         
         		}
         	}); // END XML
         
         // TOGGLE BUTTON 1
         sym.$("toggleBtn1").on(clickEventType, function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (sym.getSymbol("toggleBtn1").$("plus").is(":visible") ) { 
         		sym.getSymbol("toggleBtn1").$("plus").fadeOut(0);
         		sym.$("zoom1Mc").fadeIn(300); 
         	}else{
         		sym.getSymbol("toggleBtn1").$("plus").fadeIn(0);
         		sym.$("zoom1Mc").fadeOut(300); 
         	}
         }); 
         sym.$("toggleBtn1").mouseover(function(){
         	sym.getSymbol("toggleBtn1").$("rollOver").stop().animate ({opacity:0.3}, 100);
         });
         sym.$("toggleBtn1").mouseout(function(){
         	sym.getSymbol("toggleBtn1").$("rollOver").stop().animate ({opacity:0}, 100);
         });
         
         
         // TOGGLE BUTTON 2
         sym.$("toggleBtn2").on(clickEventType, function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (sym.getSymbol("toggleBtn2").$("plus").is(":visible") ) { 
         		sym.$("toggleBtn1").fadeOut(0);
         		sym.$("txt30").fadeOut(0);
         		sym.getSymbol("toggleBtn2").$("plus").fadeOut(0);
         		sym.$("zoomLoco").stop().animate ({left:575}, 400, 'easeOutCubic');
         		sym.$("zoom2Map").stop().animate ({left:0, top:82, width:570, height:402}, 500, 'easeOutCubic', function(){
         			sym.$("zoom2Mc").fadeIn(100); 
         		});
         
         	}else{
         		sym.$("toggleBtn1").fadeIn(200);
         		sym.$("txt30").fadeIn(200);
         		sym.getSymbol("toggleBtn2").$("plus").fadeIn(0);
         		sym.$("zoom2Mc").fadeOut(100); 
         		sym.$("zoomLoco").stop().animate ({left:800}, 300);
         		sym.$("zoom2Map").stop().animate ({left:410, top:356, width:1, height:1}, 500, 'easeOutCubic');
         	}
         }); 
         sym.$("toggleBtn2").mouseover(function(){
         	sym.getSymbol("toggleBtn2").$("rollOver").stop().animate ({opacity:0.3}, 100);
         });
         sym.$("toggleBtn2").mouseout(function(){
         	sym.getSymbol("toggleBtn2").$("rollOver").stop().animate ({opacity:0}, 100);
         });
         

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'iconMc0'
   (function(symbolName) {   
   
   })("iconMc0");
   //Edge symbol end:'iconMc0'

   //=========================================================
   
   //Edge symbol: 'iconMc0_1'
   (function(symbolName) {   
   
   })("iconMc1");
   //Edge symbol end:'iconMc1'

   //=========================================================
   
   //Edge symbol: 'iconMc1_1'
   (function(symbolName) {   
   
   })("iconMc2");
   //Edge symbol end:'iconMc2'

   //=========================================================
   
   //Edge symbol: 'iconMc2_1'
   (function(symbolName) {   
   
   })("iconMc3");
   //Edge symbol end:'iconMc3'

   //=========================================================
   
   //Edge symbol: 'mapTxtMc'
   (function(symbolName) {   
   
   })("mapTxtMc");
   //Edge symbol end:'mapTxtMc'

   //=========================================================
   
   //Edge symbol: 'zoom2Mc'
   (function(symbolName) {   
   
   })("zoom2Mc");
   //Edge symbol end:'zoom2Mc'

   //=========================================================
   
   //Edge symbol: 'zoom1Mc'
   (function(symbolName) {   
   
   })("zoom1Mc");
   //Edge symbol end:'zoom1Mc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNews33071");