/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         
         var txtBlack = {"border-width":"1px","border-style":"solid", "border-radius":"5px",
         	"background-color":"rgba(20,20,20,1)", "height":"auto", "padding":"6px"};
         var txtGreen = {"border-width":"1px","border-style":"solid", "border-radius":"5px",
         	"background-color":"rgba(10,155,75,1)", "height":"auto", "padding":"6px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"};
         var txtBlue = {"border-width":"1px","border-style":"solid", "border-radius":"5px",
         	"background-color":"rgba(0,100,175,1)", "height":"auto", "width":"auto", "padding":"6px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"};
         var txtRed = {"border-width":"1px","border-style":"solid", "border-radius":"5px",
         	"background-color":"rgba(218,0,0,1)", "height":"auto", "width":"auto", "padding":"6px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"};
         var txtKey = {"border-width":"1px","border-style":"solid", "border-radius":"5px",
         	"background-color":"white", "width":"auto", "padding":"6px", "padding-left":"45px", "padding-bottom":"10px", "padding-right":"10px"};
         
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css(txtBlack);
         	for (var h=0; h<8; h++){
         		sym.getSymbol("map1Mc").getSymbol("numBtn"+h).$("txt").html(h+1);
         	}
         	var outBtn  = {"background-color":"rgba(100,100,100,1)"};
         	var overBtn = {"background-color":"rgba(0,0,0,1)"};
         	var txt=[];
         	for(var i=0;i<14;i++){
         		txt[i] = sym.getSymbol("map1Mc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for(var i=14;i<18;i++){
         		txt[i] = sym.getSymbol("keyMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for(var i=18;i<26;i++){
         		txt[i] = sym.getSymbol("map1Mc").$("arTxt"+(i-18)).css(txtBlack);
         	}
         	for(var i=29;i<44;i++){
         		txt[i] = sym.getSymbol("map0Mc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for(var i=44;i<59;i++){
         		txt[i] = sym.getSymbol("mapBeforeMc").getSymbol("zoomTxtMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for(var i=71;i<75;i++){
         		txt[i] = sym.getSymbol("beforeKeyMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for(var i=79;i<88;i++){
         		txt[i] = sym.getSymbol("endMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[1] = sym.getSymbol("map1Mc").$("txt1").css(txtRed);
         	txt[2] = sym.getSymbol("map1Mc").getSymbol("arMc6").$("txt2").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("map1Mc").getSymbol("arMc5").$("txt4").css(txtGreen);
         	txt[7] = sym.getSymbol("map1Mc").getSymbol("arMc5").$("txt7").css({"pointer-events":"none"});
         	txt[12] = sym.getSymbol("map1Mc").$("txt12").css(txtBlue);
         	txt[26] = sym.getSymbol("keyMc").$("txt26").css({"pointer-events":"none"});
         	txt[27] = sym.getSymbol("auxBtnsMc").getSymbol("auxBtn0").$("txt").css({"pointer-events":"none"});
         	txt[28] = sym.getSymbol("auxBtnsMc").getSymbol("auxBtn1").$("txt").css({"pointer-events":"none"});
         	txt[59] = sym.getSymbol("styleBase").getSymbol("toggleSource").$("txt59").css({"pointer-events":"none"});
         	txt[60] = sym.getSymbol("mapBeforeMc").$("txt60").css({"pointer-events":"none"});
         	txt[61] = sym.getSymbol("mapBeforeMc").$("txt61").css({"pointer-events":"none"});
         	txt[62] = sym.getSymbol("mapBeforeMc").$("txt62").css({"pointer-events":"none"});
         	txt[63] = sym.getSymbol("mapBeforeMc").$("txt63").css({"pointer-events":"none"});
         	txt[64] = sym.getSymbol("mapBeforeMc").$("txt64").css({"pointer-events":"none"});
         	txt[65] = sym.getSymbol("mapBeforeMc").$("txt65").css({"pointer-events":"none"});
         	txt[66] = sym.getSymbol("mapBeforeMc").$("txt66").css({"pointer-events":"none"});
         	txt[67] = sym.getSymbol("mapBeforeMc").$("txt67").css({"pointer-events":"none"});
         	txt[68] = sym.getSymbol("mapBeforeMc").$("txt68").css({"pointer-events":"none"});
         	txt[69] = sym.getSymbol("mapBeforeMc").$("txt69").css(txtKey);
         	txt[70] = sym.getSymbol("mapBeforeMc").$("txt70").css({"pointer-events":"none"});
         	txt[75] = sym.getSymbol("map0Mc").$("txt75").css({"pointer-events":"none"});
         	txt[76] = sym.getSymbol("map0Mc").$("txt76").css({"pointer-events":"none"});
         	txt[77] = sym.getSymbol("map0Mc").$("txt77").css({"pointer-events":"none"});
         	txt[78] = sym.getSymbol("map0Mc").$("txt78").css({"pointer-events":"none"});
         
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33037.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			var headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("styleHead").$("standTxt").css("font-size",stanSize);
         			var stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			var source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var newTable1="<div id='newTab1'>";
         			var dataTab1;
         			newTable1+="<div id='newtab1'>";
         			$(xml).find('table1').each(function() {
         				newTable1+="<table class='events'>";
         				$(this).find('number1').each(function() {
         					dataTab1 = $(this).find("date1").text();
         					newTable1+="<tr><td>"+dataTab1+"</td></tr>";
         				});
         				newTable1+="</table>";
         			});
         			newTable1+="</div>";	
         		sym.$("table1Mc").append(newTable1);
         
         		var newTable2="<div id='newTab2'>";
         			var dataTab2;
         			newTable2+="<div id='newtab2'>";
         			$(xml).find('table2').each(function() {
         				newTable2+="<table class='events'>";
         				$(this).find('number2').each(function() {
         					dataTab2 = $(this).find("date2").text();
         					newTable2+="<tr><td>"+dataTab2+"</td></tr>";
         				});
         				newTable2+="</table>";
         			});
         			newTable2+="</div>";	
         		sym.$("table2Mc").append(newTable2);
         
         		//apply styles
         		$("#newTab1").css({"font-family":"Pragmatica-web, sans-serif"});
         		$(".events").css({"text-align":"left","color":"#000000","font-size":"13px","line-height":"14px",'border':0,'border-collapse':'collapse'});
         		$("#newtab1 tr:odd").css({"background-color":"#dddddd"});
         		$("#newtab1 tr:even").css({"background-color":"#ffffff"});
         		$('.events td').css({'padding':'9px', 'padding-right':10});
         		sym.$("table1Mc").css({'overflow-y':'scroll'});
         
         		$("#newTab2").css({"font-family":"Pragmatica-web, sans-serif"});
         		$("#newtab2 tr:odd").css({"background-color":"#dddddd"});
         		$("#newtab2 tr:even").css({"background-color":"#ffffff"});
         		sym.$("table2Mc").css({'overflow-y':'scroll'});
         
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<88; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         
         			// TXT FOR MAP BEFORE
         			for (var h=0; h<8; h++){
         				sym.getSymbol("mapBeforeMc").$("mapBefore" + h).empty();
         			}
         			sym.getSymbol("mapBeforeMc").$("mapBefore0").append(txtArr[30]);
         			sym.getSymbol("mapBeforeMc").$("mapBefore1").append(txtArr[34]);
         			sym.getSymbol("mapBeforeMc").$("mapBefore2").append(txtArr[33]);
         			sym.getSymbol("mapBeforeMc").$("mapBefore3").append(txtArr[37]);
         			sym.getSymbol("mapBeforeMc").$("mapBefore4").append(txtArr[36]);
         			sym.getSymbol("mapBeforeMc").$("mapBefore5").append(txtArr[39]);
         			sym.getSymbol("mapBeforeMc").$("mapBefore6").append(txtArr[41]);
         			sym.getSymbol("mapBeforeMc").$("mapBefore7").append(txtArr[42]);
         
         			sym.getSymbol("map0Mc").$("txt43").css(txtKey);
         
         			//sym.getSymbol("SYMBOL").$("txt").animate({top:yNUMBER - sym.getSymbol("SYMBOL").$("txt").height()+10}, 200);
         		}
         	}); // END XML
         
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         
         sym.$("map1Mc").fadeOut(0);
         sym.$("map0Mc").fadeOut(0);
         
         // MENU BUTTONS
         var btnNo = 0;
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<8; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("map1Mc").getSymbol("numBtn" + h).$("bg").css(outBtn);
         		sym.getSymbol("map1Mc").getSymbol("numBtn" + h).$("cross").fadeOut(0);
         		sym.getSymbol("map1Mc").$("arTxt" + h).fadeOut(0);
         		sym.getSymbol("map1Mc").getSymbol("arMc2").$("dot").css(outBtn);
         		sym.getSymbol("map1Mc").getSymbol("arMc4").$("dot").css(outBtn);
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		btnNo = menuNo;
         		click();
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OVER
         var menuBtnOver = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("map1Mc").getSymbol("numBtn" + menuNo).$("bg").css(overBtn);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OUT
         var menuBtnOut = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("map1Mc").getSymbol("numBtn" + menuNo).$("bg").css(outBtn);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("map1Mc").$("numBtn"+b).on(clickEventType,menuBtnClick(b));
         	sym.getSymbol("map1Mc").$("numBtn"+b).on('mouseover',menuBtnOver(b));
         	sym.getSymbol("map1Mc").$("numBtn"+b).on('mouseout',menuBtnOut(b));
         	sym.getSymbol("map1Mc").$("numBtn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("map1Mc").getSymbol("numBtn0").$("bg").css(overBtn);
         sym.getSymbol("map1Mc").getSymbol("numBtn0").$("cross").fadeIn(0);
         
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         
         // NEXT BUTTON
         var scene = -1;
         
         function hideMenu(){
         	for (var h=0; h<8; h++){
         		sym.getSymbol("map1Mc").getSymbol("arMc"+h).stop(0);
         		sym.getSymbol("map1Mc").$("numBtn" + h).fadeOut(0);
         		resetmenu();
         	}
         }
         hideMenu();
         
         // NEXT BUTTONS
         sym.$("nextBtn").on(clickEventType, function(e){
         	scene++;
         	btnNo = scene;
         	resetmenu();
         	sym.getSymbol("nextBtn").$("btnReplay").fadeOut(0);
         	sym.getSymbol("nextBtn").$("arrow").fadeIn(0);
         	if (scene == 2){
         		sym.getSymbol("map1Mc").getSymbol("arMc2").$("dot").css(overBtn);
         	}
         	if (scene == 4){
         		sym.getSymbol("map1Mc").getSymbol("arMc4").$("dot").css(overBtn);
         	}
         	if (scene == 8){
         		sym.$("map0Mc").fadeIn(300);
         		sym.$("endMc").fadeIn(300);
         		sym.getSymbol("nextBtn").$("btnReplay").fadeIn(0);
         		sym.getSymbol("nextBtn").$("arrow").fadeOut(0);
         		sym.getSymbol("map1Mc").getSymbol("numBtn7").$("cross").fadeIn(0);
         	}
         	if (scene == 9){
         		sym.$("map0Mc").fadeOut(300);
         		sym.$("endMc").fadeOut(300);
         		sym.getSymbol("map1Mc").getSymbol("numBtn7").$("cross").fadeIn(0);
         		hideMenu();
         		scene = 0;
         	}
         	sym.getSymbol("map1Mc").getSymbol("arMc" + scene).play(0);
         	sym.getSymbol("map1Mc").$("numBtn" + scene).fadeIn(200);
         	sym.getSymbol("map1Mc").$("arTxt" + scene).fadeIn(200);
         	sym.getSymbol("map1Mc").getSymbol("numBtn" + scene).$("cross").delay(500).fadeIn(200);
         	e.stopPropagation(); e.preventDefault();
         });
         sym.$("nextBtn").mouseover(function(){
         		sym.getSymbol("nextBtn").$("bg").css(outAux);
         	});
         sym.$("nextBtn").mouseout(function(){
         		sym.getSymbol("nextBtn").$("bg").css(overAux);
         	});
         
         sym.getSymbol("nextBtn").$("btnReplay").fadeOut(0);
         
         function click() {
         	if (sym.getSymbol("map1Mc").getSymbol("numBtn" + btnNo).$("cross").is(":visible") ) { 
         		resetmenu();
         	}else{
         		resetmenu();
         		sym.getSymbol("map1Mc").getSymbol("numBtn" + btnNo).$("bg").css(overBtn);
         		sym.getSymbol("map1Mc").getSymbol("numBtn" + btnNo).$("cross").fadeIn(0);
         		sym.getSymbol("map1Mc").$("arTxt" + btnNo).fadeIn(0);
         	}
         	if (sym.getSymbol("map1Mc").getSymbol("numBtn2").$("cross").is(":visible") ) { 
         		sym.getSymbol("map1Mc").getSymbol("arMc2").$("dot").css(overBtn);
         	}else{
         		sym.getSymbol("map1Mc").getSymbol("arMc2").$("dot").css(outBtn);
         	}
         	if (sym.getSymbol("map1Mc").getSymbol("numBtn4").$("cross").is(":visible") ) { 
         		sym.getSymbol("map1Mc").getSymbol("arMc4").$("dot").css(overBtn);
         	}else{
         		sym.getSymbol("map1Mc").getSymbol("arMc4").$("dot").css(outBtn);
         	}
         	}
         
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         
         // AUX BUTTONS
         var clickAux = 1;
         var outAux  = {"background-color":"black"};
         var overAux = {"background-color":"rgba(218,0,0,1)"};
         auxArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<2; a++){
         	auxArray.push(a);
         }
         
         function resetAux(){
         	for (var a=0; a<auxArray.length; a++){
         		sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + a).$("bg").css(outAux);
         		sym.$("table" + (a+1) + "Mc").fadeOut(0);
         	}
         }
         //resetAux();
         
         // AUX CLICK
         var auxBtnClick = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		clickAux = auxNo;
         		resetAux();
         		sym.$("table" + (auxNo+1) + "Mc").fadeIn(50);
         		sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxNo).$("bg").css(overAux);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // AUX OVER
         var auxBtnOver = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxNo).$("bg").css(overAux);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // AUX OUT
         var auxBtnOut = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxNo).$("bg").css(outAux);
         		if (clickAux == auxNo){
         			sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxNo).$("bg").css(overAux);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<auxArray.length;b++){
         	sym.getSymbol("auxBtnsMc").$("auxBtn"+b).on(clickEventType,auxBtnClick(b));
         	sym.getSymbol("auxBtnsMc").$("auxBtn"+b).on('mouseover',auxBtnOver(b));
         	sym.getSymbol("auxBtnsMc").$("auxBtn"+b).on('mouseout',auxBtnOut(b));
         	sym.getSymbol("auxBtnsMc").$("auxBtn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("auxBtnsMc").getSymbol("auxBtn1").$("bg").css(overAux);
         sym.$("table1Mc").fadeOut(0);
         
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         
         // SET ZOOM 1
         sym.getSymbol("mapBeforeMc").$("zoomTxtMc").fadeOut(0);
         sym.getSymbol("mapBeforeMc").$("zoomMap").stop().animate ({opacity:0, left:182, top:282, width:84, height:63}, 0, 'easeOutCubic');
         
         // TOGGLE ZOOM BUTTON 1
         sym.getSymbol("mapBeforeMc").$("toggleZoomBtn1").on(clickEventType, function(e){
         	if (sym.getSymbol("mapBeforeMc").getSymbol("toggleZoomBtn1").$("plus").is(":visible") ) { 
         		sym.getSymbol("mapBeforeMc").getSymbol("toggleZoomBtn1").$("plus").fadeOut(0);
         		sym.getSymbol("mapBeforeMc").$("zoomMap").stop().delay(0).animate ({opacity:1, left:248, top:110, width:341, height:337}, 500, 'easeOutCubic', function(){
         			sym.getSymbol("mapBeforeMc").$("zoomTxtMc").fadeIn(200);
         			sym.$("toggleZoomBtn2").fadeIn(0);
         			sym.$("beforeKeyMc").fadeIn(200);
         		});
         	}else{
         		sym.getSymbol("mapBeforeMc").getSymbol("toggleZoomBtn1").$("plus").fadeIn(0);
         		sym.getSymbol("mapBeforeMc").$("zoomTxtMc").fadeOut(100);
         		sym.getSymbol("mapBeforeMc").$("zoomMap").stop().animate ({opacity:0, left:212, top:296, width:26, height:26}, 500, 'easeOutCubic');
         		sym.$("toggleZoomBtn2").fadeOut(0);
         		sym.$("beforeKeyMc").fadeOut(100);
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         sym.getSymbol("mapBeforeMc").$("toggleZoomBtn1").mouseover(function(){
         	sym.getSymbol("mapBeforeMc").getSymbol("toggleZoomBtn1").$("Ellipse").css(outAux);
         });
         sym.getSymbol("mapBeforeMc").$("toggleZoomBtn1").mouseout(function(){
         	sym.getSymbol("mapBeforeMc").getSymbol("toggleZoomBtn1").$("Ellipse").css(overAux);
         });
         
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         
         // TOGGLE ZOOM BUTTON 2
         sym.$("toggleZoomBtn2").fadeOut(0);
         
         sym.$("toggleZoomBtn2").on(clickEventType, function(e){
         	if (sym.getSymbol("toggleZoomBtn2").$("plus").is(":visible") ) { 
         		sym.getSymbol("toggleZoomBtn2").$("plus").fadeOut(0);
         		sym.$("map1Mc").fadeIn(300);
         		sym.$("toggleZoomBtn2").animate ({left:515, top:115}, 400, 'easeOutCubic');
         		sym.$("nextBtn").delay(500).animate ({left:-45}, 400, 'easeOutCubic');
         		sym.$("keyMc").fadeIn(200);
         	}else{
         		sym.getSymbol("toggleZoomBtn2").$("plus").fadeIn(0);
         		sym.$("map1Mc").fadeOut(300);
         		sym.$("toggleZoomBtn2").animate ({left:390, top:153}, 400, 'easeOutCubic');
         		sym.$("keyMc").fadeOut(200);
         		sym.$("nextBtn").animate ({left:-90}, 400, 'easeOutCubic');
         		sym.$("map0Mc").fadeOut(300);
         		sym.$("endMc").fadeOut(300);
         		resetmenu();
         		//hideMenu();
         		//scene = -1;
         		//sym.getSymbol("map1Mc").getSymbol("arMc0").play(0);
         		sym.getSymbol("nextBtn").$("btnReplay").fadeOut(0);
         		sym.getSymbol("nextBtn").$("arrow").fadeIn(0);
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         sym.$("toggleZoomBtn2").mouseover(function(){
         	sym.getSymbol("toggleZoomBtn2").$("Ellipse").css(outAux);
         });
         sym.$("toggleZoomBtn2").mouseout(function(){
         	sym.getSymbol("toggleZoomBtn2").$("Ellipse").css(overAux);
         });
         
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on(clickEventType, function(e){
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("sourceTxt").stop().animate ({top:-10-sym.getSymbol("styleBase").$("sourceTxt").height()}, 500, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("sourceTxt").stop().animate ({top:15}, 500, 'easeInCubic');
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         
         sym.$("mapMainMc").fadeOut(0);
         //sym.getSymbol("janMapMc").$("janArrows").stop().delay(200).animate ({opacity:1, left:0}, 1000, 'easeOutCubic');
         sym.$("scrollDown").stop().delay(200).animate ({opacity:0.8, top:493}, 1000, 'easeOutCubic');
         
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         //-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         
         

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'ar2Mc'
   (function(symbolName) {   
   
   })("arMc1");
   //Edge symbol end:'arMc1'

   //=========================================================
   
   //Edge symbol: 'numBtn'
   (function(symbolName) {   
   
   })("numBtn");
   //Edge symbol end:'numBtn'

   //=========================================================
   
   //Edge symbol: 'map1Mc'
   (function(symbolName) {   
   
   })("map1Mc");
   //Edge symbol end:'map1Mc'

   //=========================================================
   
   //Edge symbol: 'arMc1'
   (function(symbolName) {   
   
   })("arMc0");
   //Edge symbol end:'arMc0'

   //=========================================================
   
   //Edge symbol: 'arMc3'
   (function(symbolName) {   
   
   })("arMc2");
   //Edge symbol end:'arMc2'

   //=========================================================
   
   //Edge symbol: 'nextBtn'
   (function(symbolName) {   
   
   })("nextBtn");
   //Edge symbol end:'nextBtn'

   //=========================================================
   
   //Edge symbol: 'arMc4'
   (function(symbolName) {   
   
   })("arMc4");
   //Edge symbol end:'arMc4'

   //=========================================================
   
   //Edge symbol: 'arMc5'
   (function(symbolName) {   
   
   })("arMc5");
   //Edge symbol end:'arMc5'

   //=========================================================
   
   //Edge symbol: 'arMc4_1'
   (function(symbolName) {   
   
      })("arMc3");
   //Edge symbol end:'arMc3'

   //=========================================================
   
   //Edge symbol: 'arMc6'
   (function(symbolName) {   
   
   })("arMc7");
   //Edge symbol end:'arMc7'

   //=========================================================
   
   //Edge symbol: 'map1Txt'
   (function(symbolName) {   
   
   })("map1Txt");
   //Edge symbol end:'map1Txt'

   //=========================================================
   
   //Edge symbol: 'arMc5_1'
   (function(symbolName) {   
   
      })("arMc6");
   //Edge symbol end:'arMc6'

   //=========================================================
   
   //Edge symbol: 'tableMc'
   (function(symbolName) {   
   
   })("tableMc");
   //Edge symbol end:'tableMc'

   //=========================================================
   
   //Edge symbol: 'map0Mc'
   (function(symbolName) {   
   
   })("map0Mc");
   //Edge symbol end:'map0Mc'

   //=========================================================
   
   //Edge symbol: 'zoomTxtMc'
   (function(symbolName) {   
   
   })("zoomTxtMc");
   //Edge symbol end:'zoomTxtMc'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleSource'
   (function(symbolName) {   
   
   })("toggleSource");
   //Edge symbol end:'toggleSource'

   //=========================================================
   
   //Edge symbol: 'KeyMc'
   (function(symbolName) {   
   
   })("KeyMc");
   //Edge symbol end:'KeyMc'

   //=========================================================
   
   //Edge symbol: 'mapBeforeMc'
   (function(symbolName) {   
   
   })("mapBeforeMc");
   //Edge symbol end:'mapBeforeMc'

   //=========================================================
   
   //Edge symbol: 'beforeKeyMc'
   (function(symbolName) {   
   
   })("beforeKeyMc");
   //Edge symbol end:'beforeKeyMc'

   //=========================================================
   
   //Edge symbol: 'arrowBtn'
   (function(symbolName) {   
   
   })("arrowBtn");
   //Edge symbol end:'arrowBtn'

   //=========================================================
   
   //Edge symbol: 'endMc'
   (function(symbolName) {   
   
   })("endMc");
   //Edge symbol end:'endMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33037");