/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var clicked = 0;
         	var btnNo = 0;
         	
         	var yellowBox = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"white", 
         	"color":"rgba(0,0,0,1)", "background-color":"#FBAE17", "width":"auto", "height":"auto", "padding":"6px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"};
         	var blackBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "border-color":"white", 
         	"color":"white", "background-color":"black", "height":"auto", "padding":"6px","padding-right":"18px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"};
         	var redBox = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"white", 
         	"color":"rgba(white)", "background-color":"rgba(218,0,0,1)", "width":"auto", "height":"auto", "padding":"6px", "box-shadow":"5px 5px 5px rgba(0,0,0,0.3)"};
         	
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css(blackBox);
         	var outBtn  = {"background-color":"rgba(255,255,255,0.2)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         	
         	var txt=[];
         	for (var i=0; i<42; i++){
         				txt[i] = sym.getSymbol("mapMainMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	for (var i=42; i<64; i++){
         				txt[i] = sym.getSymbol("janMapMc").$("txt"+i).css({"pointer-events":"none"});
         				txt[42] = sym.getSymbol("janMapMc").$("txt42").css(yellowBox);
         				txt[44] = sym.getSymbol("janMapMc").$("txt44").css(yellowBox);
         				txt[63] = sym.getSymbol("janMapMc").$("txt63").css(yellowBox);
         	}
         	for (var i=64; i<76; i++){
         				txt[i] = sym.getSymbol("febMapMc").$("txt"+i).css({"pointer-events":"none"});
         				txt[64] = sym.getSymbol("febMapMc").$("txt64").css(yellowBox);
         				txt[76] = sym.getSymbol("febMapMc").$("txt76").css(yellowBox);
         	}
         	for (var i=77; i<87; i++){
         				txt[i] = sym.getSymbol("aprMapMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[87] = sym.$("txt87").css(blackBox);
         	txt[88] = sym.$("txt88").css(blackBox);
         	txt[89] = sym.$("txt89").css(blackBox);
         	txt[90] = sym.getSymbol("toggleBtn").$("txt90").css({"pointer-events":"none"});
         	txt[91] = sym.getSymbol("styleBase").getSymbol("toggleSource").$("txt91").css({"pointer-events":"none"});
         	txt[92] = sym.getSymbol("mapMainMc").$("txt92").css({"pointer-events":"none"});
         	
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33019.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         //create table
         			var newTable="<div id='newTab'>";
         			var dataTab1;
         			newTable+="<div id='newtab1'>";
         			$(xml).find('table1').each(function() {
         				var strap=$(this).find('strap').text();
         				newTable+="<div class='redstrap'>"+strap+"</div>";
         				newTable+="<table class='events'>";
         				$(this).find('number1').each(function() {
         					dataTab1 = $(this).find("date1").text();
         					newTable+="<tr><td>"+dataTab1+"</td></tr>";
         				});
         				newTable+="</table>";
         			});
         			newTable+="</div>";
         			newTable+="<div id='newtab2'>";
         			$(xml).find('table2').each(function() {
         				var strap=$(this).find('strap').text();
         				newTable+="<div class='redstrap'>"+strap+"</div>";
         				newTable+="<table class='events'>";
         				$(this).find('number2').each(function() {
         					dataTab2 = $(this).find("date2").text();
         					newTable+="<tr><td>"+dataTab2+"</td></tr>";
         				});
         				newTable+="</table>";
         			});			
         			newTable+="</div>";
         			newTable+="<div id='newtab3'>";
         			$(xml).find('table3').each(function() {
         				var strap=$(this).find('strap').text();
         				newTable+="<div class='redstrap'>"+strap+"</div>";
         				newTable+="<table class='events'>";
         				$(this).find('number3').each(function() {
         					dataTab3 = $(this).find("date3").text();
         					newTable+="<tr><td>"+dataTab3+"</td></tr>";
         				});
         				newTable+="</table>";
         			});
         			newTable+="</div>";
         			newTable+="<div id='newtab4'>";
         			$(xml).find('table4').each(function() {
         				var strap=$(this).find('strap').text();
         				newTable+="<div class='redstrap'>"+strap+"</div>";
         				newTable+="<table class='events'>";
         				$(this).find('number4').each(function() {
         					dataTab4 = $(this).find("date4").text();
         					newTable+="<tr><td>"+dataTab4+"</td></tr>";
         				});
         				newTable+="</table>";
         			});
         			newTable+="</div>";
         			newTable+="<div id='newtab5'>";
         			$(xml).find('table5').each(function() {
         				var strap=$(this).find('strap').text();
         				var strap1=$(this).find('strap1').text();
         				newTable+="<div class='redstrap'>"+strap+"</div>";
         				newTable+="<table class='events'>";
         				$(this).find('number5').each(function() {
         					dataTab5 = $(this).find("date5").text();
         					newTable+="<tr><td>"+dataTab5+"</td></tr>";
         				});
         
         				newTable+="</table>";
         				newTable+="<div class='redstrap'>"+strap1+"</div>";
         			});	
         		sym.$("tableMc").append(newTable);
         		//apply styles
         		$("#newTab").css({"font-family":"Pragmatica-web, sans-serif"});
         		$(".events").css({"text-align":"left","color":"#000000","font-size":"13px","line-height":"15px",'border':0,'border-collapse':'collapse'});
         		$("#newtab1 tr:odd").css({"background-color":"#dddddd"});
         		$("#newtab1 tr:even").css({"background-color":"#ffffff"});
         		$("#newtab2 tr:odd").css({"background-color":"#cccccc"});
         		$("#newtab2 tr:even").css({"background-color":"#dddddd"});
         		$("#newtab3 tr:odd").css({"background-color":"#dddddd"});
         		$("#newtab3 tr:even").css({"background-color":"#ffffff"});
         		$("#newtab4 tr:odd").css({"background-color":"#cccccc"});
         		$("#newtab4 tr:even").css({"background-color":"#dddddd"});
         		$("#newtab5 tr:odd").css({"background-color":"#dddddd"});
         		$("#newtab5 tr:even").css({"background-color":"#ffffff"});
         		$('.events td').css({'padding':'9px', 'padding-right':10});
         		$(".redstrap").css({'font-weight':700,'color':'rgb(255,255,255)','width':'100%','background-color':'rgb(218,0,0)', 'text-align':'center', 'padding-top':4, 'padding-bottom':4});
         		sym.$("tableMc").css({'overflow-y':'scroll'});
         
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<93; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         			sym.$("txt87").animate({top:570 - sym.$("txt87").height()+4}, 0);
         			sym.$("txt88").animate({top:570 - sym.$("txt88").height()+4}, 0);
         			sym.$("txt89").animate({top:570 - sym.$("txt89").height()+4}, 0);
         		}
         	}); // END XML
         
         function timelineScroll(){
         // Map scroll position to timeline position
         var tabHeight = $("#newTab").height();
         var tableHeight = sym.$("tableMc").height();
         var scrollPos = sym.$("tableMc").scrollTop();
         var duration = sym.getDuration();
         var percent = scrollPos / (tabHeight - tableHeight);
         var time = duration * percent;
         sym.stop(time);
         sym.$("scrollDown").fadeOut(200);
         }	
         sym.$("tableMc").on('scroll',timelineScroll);	
         
         
         // TOGGLE BUTTON
         sym.$("toggleBtn").on(clickEventType, function(e){
         	if (sym.getSymbol("toggleBtn").$("plus").is(":visible") ) { 
         		sym.getSymbol("toggleBtn").$("plus").fadeOut(0);
         		sym.$("mapMainMc").fadeIn(500);
         	}else{
         		sym.getSymbol("toggleBtn").$("plus").fadeIn(0);
         		sym.$("mapMainMc").fadeOut(500);
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         sym.$("toggleBtn").mouseover(function(){
         	sym.getSymbol("toggleBtn").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.$("toggleBtn").mouseout(function(){
         	sym.getSymbol("toggleBtn").$("togBox").stop().animate ({opacity:1}, 200);
         });
         
         // SOURCE BUTTON
         sym.getSymbol("styleBase").$("toggleSource").on(clickEventType, function(e){
         	if (sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").is(":visible") ) { 
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeOut(0);
         		sym.getSymbol("styleBase").$("sourceTxt").stop().animate ({top:-10-sym.getSymbol("styleBase").$("sourceTxt").height()}, 500, 'easeOutCubic');
         	}else{
         		sym.getSymbol("styleBase").getSymbol("toggleSource").$("plus").fadeIn(0);
         		sym.getSymbol("styleBase").$("sourceTxt").stop().animate ({top:15}, 500, 'easeInCubic');
         	}
         	e.stopPropagation(); e.preventDefault();
         }); 
         sym.getSymbol("styleBase").$("toggleSource").mouseover(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:0.5}, 200);
         });
         sym.getSymbol("styleBase").$("toggleSource").mouseout(function(){
         	sym.getSymbol("styleBase").getSymbol("toggleSource").$("togBox").stop().animate ({opacity:1}, 200);
         });
         
         sym.$("mapMainMc").fadeOut(0);
         sym.getSymbol("janMapMc").$("janArrows").stop().delay(200).animate ({opacity:1, left:0}, 1000, 'easeOutCubic');
         sym.$("scrollDown").stop().delay(200).animate ({opacity:0.8, top:493}, 1000, 'easeOutCubic');

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'mapMainMc'
   (function(symbolName) {   
   
   })("mapMainMc");
   //Edge symbol end:'mapMainMc'

   //=========================================================
   
   //Edge symbol: 'tableMc'
   (function(symbolName) {   
   
   })("tableMc");
   //Edge symbol end:'tableMc'

   //=========================================================
   
   //Edge symbol: 'janMapMc'
   (function(symbolName) {   
   
   })("janMapMc");
   //Edge symbol end:'janMapMc'

   //=========================================================
   
   //Edge symbol: 'febMapMc'
   (function(symbolName) {   
   
   })("febMapMc");
   //Edge symbol end:'febMapMc'

   //=========================================================
   
   //Edge symbol: 'aprMapMc'
   (function(symbolName) {   
   
   })("aprMapMc");
   //Edge symbol end:'aprMapMc'

   //=========================================================
   
   //Edge symbol: 'toggleBtn_1'
   (function(symbolName) {   
   
      })("toggleSource");
   //Edge symbol end:'toggleSource'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33019");