/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "click" : "click");
         	var clicked = 0;
         	var btnNo = 0;
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var stand;
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         	var outBtn  = {"background-color":"rgba(255,255,255,0.2)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         	
         	var txt=[];
         	txt[0] = sym.$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.getSymbol("txtOut").$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.getSymbol("txtOut").$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.getSymbol("txtOut").$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("txtOut").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("txtOut").$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.getSymbol("txtOut").$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.getSymbol("intMc").$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.getSymbol("intMc").$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.getSymbol("intMc").$("txt13").css({"pointer-events":"none"});
         	
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33011.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("styleHead").$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<51; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         	
         		}
         	}); // END XML
         	
         sym.$("intMc").stop().animate ({opacity:0}, 0);
         
         // ROTATE 1
         $.fn.animateRotate = function(angle, duration, easing, complete) {
             return this.each(function() {
                 var $elem = $(this);
                 $({deg: 0}).animate({deg: angle}, {
                     duration: duration,
                     easing: easing,
                     step: function(now) {
                         $elem.css({
                           '-moz-transform':'rotate('+now+'deg)',
                           '-webkit-transform':'rotate('+now+'deg)',
                           '-o-transform':'rotate('+now+'deg)',
                           '-ms-transform':'rotate('+now+'deg)',
                           'transform':'rotate('+now+'deg)'
                         });
                     }
                 });
             });
         };
         
         var turn = 0;
         
         var tankCont = function() {
         	sym.getSymbol("tankMc").$("track0").stop().animate ({left:27, top:162}, 0);
         	sym.getSymbol("tankMc").getSymbol("track1").$("track1Mc").stop().animate ({left:0}, 0);
         	sym.getSymbol("tankMc").$("track2").stop().animate ({left:377, top:26}, 0);
         
         	if (turn == 0) {
         	for (var i = 0; i < 8; i++){
         		sym.getSymbol("tankMc").$("wheel"+i).animateRotate(360, 1000, 'linear');
         		sym.getSymbol("tankMc").$("track0").stop().animate ({left:-62, top:108}, 1000, 'linear', function(){ tankCont(); });
         		sym.getSymbol("tankMc").getSymbol("track1").$("track1Mc").stop().animate ({left:-128}, 1000, 'linear');
         		sym.getSymbol("tankMc").$("track2").stop().animate ({left:300, top:92}, 1000, 'linear');
         	}
         	}else{
         	for (var i = 0; i < 8; i++){
         		sym.getSymbol("tankMc").$("wheel"+i).stop().animateRotate(360, 3000, 'easeOutCubic');
         		sym.getSymbol("tankMc").$("track0").stop().animate ({left:-62, top:108}, 3000, 'easeOutCubic');
         		sym.getSymbol("tankMc").getSymbol("track1").$("track1Mc").stop().animate ({left:-128}, 3000, 'easeOutCubic');
         		sym.getSymbol("tankMc").$("track2").stop().animate ({left:300, top:92}, 3000, 'easeOutCubic');
         		}
         	}
         }
         
         function tankStart() {
         	sym.getSymbol("tankMc").$("track0").stop().animate ({left:27, top:162}, 0);
         	sym.getSymbol("tankMc").getSymbol("track1").$("track1Mc").stop().animate ({left:0}, 0);
         	sym.getSymbol("tankMc").$("track2").stop().animate ({left:376, top:26}, 0);
         	sym.getSymbol("tankMc").$("track0").stop().animate ({left:-62, top:108}, 3000, 'easeInCubic');
         	sym.getSymbol("tankMc").getSymbol("track1").$("track1Mc").stop().animate ({left:-128}, 3000, 'easeInCubic', function(){ tankCont(); });
         	sym.getSymbol("tankMc").$("track2").stop().animate ({left:300, top:92}, 3000, 'easeInCubic');	
         
         	for (var i = 0; i < 8; i++){
         		sym.getSymbol("tankMc").$("wheel"+i).animateRotate(360, 3000, 'easeInCubic');
         		sym.getSymbol("tankMc").$("track0").stop().animate ({left:-62, top:108}, 3000, 'easeInCubic');
         }
         }
         tankStart();
         
         // TOGGLE BUTTON
         sym.$("toggleBtn").on(clickEventType, function(e){
         	e.stopPropagation(); e.preventDefault();
         	if (sym.getSymbol("toggleBtn").$("plus").is(":visible") ) {
         		sym.$("intMc").stop().animate ({opacity:1}, 500);
         		sym.$("txtOut").stop().animate ({opacity:0}, 200);
         		sym.getSymbol("toggleBtn").$("plus").fadeOut(0);
         		turn = 1;
         	}else{
         		sym.$("intMc").stop().animate ({opacity:0}, 500);
         		sym.$("txtOut").stop().animate ({opacity:1}, 200);
         		sym.getSymbol("toggleBtn").$("plus").fadeIn(0);
         		turn = 0;
         		tankStart();
         	}
         }); 
         sym.$("toggleBtn").mouseover(function(){
         	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0.3}, 200);
         });
         sym.$("toggleBtn").mouseout(function(){
         	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0}, 200);
         });

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'tankMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 122, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("tankMc");
   //Edge symbol end:'tankMc'

   //=========================================================
   
   //Edge symbol: 'tracks'
   (function(symbolName) {   
   
   })("tracks");
   //Edge symbol end:'tracks'

   //=========================================================
   
   //Edge symbol: 'track1Mc'
   (function(symbolName) {   
   
   })("track1Mc");
   //Edge symbol end:'track1Mc'

   //=========================================================
   
   //Edge symbol: 'txtOut'
   (function(symbolName) {   
   
   })("txtOut");
   //Edge symbol end:'txtOut'

   //=========================================================
   
   //Edge symbol: 'Symbol_1'
   (function(symbolName) {   
   
   })("Symbol_1");
   //Edge symbol end:'Symbol_1'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33011");