/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var clicked = 0;
         	var btnNo = 0;
         	
         	var txtBox = {"background-color":"#ffffff", "height":"auto", "padding":"6px", "padding-right":"30px", "pointer-events":"none"};
         	var placeTxt  = {"background-color":"rgba(255,255,255,0.6)",  "border-radius":"4px",  "width":"auto", "padding":"3px"};
         	
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var stand;
         	var standtxt = sym.$("standTxt").css(txtBox);
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         	
         	
         	var txt=[];
         	txt[0] = sym.getSymbol("txtMc").$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.getSymbol("txtMc").$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.getSymbol("txtMc").$("txt2").css(placeTxt);
         	txt[3] = sym.getSymbol("txtMc").$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("txtMc").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("txtMc").$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.getSymbol("txtMc").$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.getSymbol("txtMc").$("txt7").css({"pointer-events":"none"});
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN33000.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.$("headlineTxt").css("font-size",headSize);
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	//create table
         			var newTable="<div id='newTab'>";
         			var dataTab1;
         			newTable+="<div id='newtab1'>";
         			$(xml).find('table1').each(function() {
         				var strap=$(this).find('strap').text();
         				//newTable+="<div class='redstrap'>"+strap+"</div>";
         				newTable+="<table class='events'>";
         				$(this).find('number1').each(function() {
         					dataTab1 = $(this).find("date1").text();
         					newTable+="<tr><td>"+dataTab1+"</td></tr>";
         				});
         				newTable+="</table>";
         			});
         			newTable+="</div>";
         	
         		sym.$("tableMc").append(newTable);
         		//apply styles
         		$("#newTab").css({"font-family":"Pragmatica-web, sans-serif"});
         		$(".events").css({"text-align":"left","color":"#000000","font-size":"14px","line-height":"16px",'border':0,'border-collapse':'collapse'});
         		$("#newtab1 tr:odd").css({"background-color":"#dddddd"});
         		$("#newtab1 tr:even").css({"background-color":"#eeeeee"});
         		$('.events td').css({'padding':'9px'});
         		sym.$("tableMc").css({'overflow-y':'scroll'});
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<8; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         			sym.getSymbol("txtMc").$("txt2").animate({left:190 - sym.getSymbol("txtMc").$("txt2").width()/2}, 0);
         		}
         	}); // END XML
         	
         function timelineScroll(){
         // Map scroll position to timeline position
         var tabHeight = $("#newTab").height();
         var tableHeight = sym.$("tableMc").height();
         var scrollPos = sym.$("tableMc").scrollTop();
         var duration = sym.getDuration();
         var percent = scrollPos / (tabHeight - tableHeight);
         var time = duration * percent;
         sym.stop(time);
         sym.$("scrollDown").fadeOut(50);
         }	
         sym.$("tableMc").on('scroll',timelineScroll);	

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         /*
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         
         */

      });
      //Edge binding end

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'tableMc'
   (function(symbolName) {   
   
   })("tableMc");
   //Edge symbol end:'tableMc'

   //=========================================================
   
   //Edge symbol: 'txtMc'
   (function(symbolName) {   
   
   })("txtMc");
   //Edge symbol end:'txtMc'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews33000");