/***********************
* Adobe Edge Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
var gnYear=2015; //2014
var gnNo=32984;//32092
var classifications=[1063975,1352530,1352531,1352533,1352535]; //  General, Points, Mountain, Youth/Combination, Team 905952,1034131,1034132,1034133,1034135
var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://www.graphicnews.org/")+ "infostradasports/api.php";
var todayDate = new Date();
var startDate= Date.UTC(2015,04,09,17,00,01);
var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
//DATE FUNCTIONS
function getMatchLocal(thisDateStr){
	var timeTxt = thisDateStr.substring(thisDateStr.indexOf('(') + 1, thisDateStr.indexOf(')'));
	var thisDate = new Date(parseInt(timeTxt, 10));
	var hh = thisDate.getHours();
	var mm = parseInt(thisDate.getMinutes(),10);
	mm=(mm<10)?"0"+mm:mm;
	return hh+":"+mm;
}
var raceInterval;
var stageInterval;
var stageChanger = function(stage){ //to handle lexical scope
	return function (e) {
		clearInterval(stageInterval);
		getStageInfo(stage);
		if(stage==latestStage){
			raceInterval = setInterval(getRace,120000);
			stageInterval = setInterval(function(){getStageInfo(stage);},30000);
		}
	};
};
var classChanger = function(stage){ //to handle lexical scope
	return function (e) {
	getPhase(stage);
	};
};
	var teamNo = 0;
	var stgMove = 0;
	var move = 32;
	var stageMove = 160;
	for (var p=0;p<21; p++){
		sym.getSymbol("stagesMc").getSymbol("stageBtn"+p).$("txt").html(p+1); // ADD NUMBERS TO STAGE BUTTONS
		sym.getSymbol("routeMc").getSymbol("stageBtn"+p).$("txt").html(p+1); // ADD NUMBERS TO MAIN ROUTE
	}	
	sym.getSymbol("stagesMc").$("graph").css({"overflowY":"scroll"});
	sym.$("teamsMc").fadeOut(0);
	sym.$("stagesMc").fadeOut(0);
	sym.$("results").fadeOut(0);
	var headline;
	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
	var source;
	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
	var stagestring;
	var datestring;
	var keyBox = {"border-width":"2px","border-style":"solid", "border-radius":"5px", "border-color":"#0071BB", "pointer-events":"none",
	"background-color":"white", "height":"auto","width":"auto", "padding":"6px"};
	var mapBox = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"white", "pointer-events":"none",
	"background-color":"#FAAB18", "height":"auto", "padding":"4px"};
	var menu=[];
	for (var m=0;m<4; m++){
		menu[m] = sym.getSymbol("menuBtnsMc").$("menuTxt");
		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+m).$("menuIcon").attr("src", "images/menuIcon" + m + ".png"); // ADD MENU ICONS
	}
	var name=sym.getSymbol("teamsMc").$("name");
	var country=sym.getSymbol("teamsMc").$("country");
	var txt=[];
	txt[0] = sym.getSymbol("routeMc").$("txt0").css({"pointer-events":"none"});
	txt[1] = sym.getSymbol("routeMc").$("txt1").css(mapBox);
	txt[2] = sym.$("txt2").css({"pointer-events":"none"});
	txt[3] = sym.getSymbol("routeMc").$("txt3").css(mapBox);
	txt[4] = sym.$("txt4").css({"pointer-events":"none"});
	txt[5] = sym.getSymbol("routeMc").$("txt5").css(keyBox);
	txt[6] = sym.getSymbol("stagesMc").$("txt6").css({"pointer-events":"none"});
	txt[7] = sym.getSymbol("routeMc").$("txt7").css({"pointer-events":"none"});
	txt[8] = sym.getSymbol("routeMc").$("txt8").css({"pointer-events":"none"});
	txt[9] = sym.getSymbol("routeMc").$("txt9").css({"pointer-events":"none"});
	txt[10] = sym.getSymbol("routeMc").$("txt10").css({"pointer-events":"none"});
	txt[11] = sym.getSymbol("routeMc").$("txt11").css({"pointer-events":"none"});
	txt[12] = sym.getSymbol("routeMc").$("txt12").css({"pointer-events":"none"});
	txt[13] = sym.getSymbol("routeMc").$("txt13").css({"pointer-events":"none"});
	txt[14] = sym.getSymbol("routeMc").$("txt14").css({"pointer-events":"none"});
	txt[15] = sym.getSymbol("routeMc").$("txt15").css({"pointer-events":"none"});
	txt[16] = sym.getSymbol("routeMc").$("txt16").css({"pointer-events":"none"});
	txt[17] = sym.getSymbol("routeMc").$("txt17").css({"pointer-events":"none"});
	txt[18] = sym.getSymbol("routeMc").$("txt18").css({"pointer-events":"none"});
	txt[19] = sym.getSymbol("routeMc").$("txt19").css({"pointer-events":"none"});
	txt[20] = sym.getSymbol("stagesMc").getSymbol("stgTxtMc").$("txt20").css({"pointer-events":"none"});
	txt[21] = sym.getSymbol("stagesMc").getSymbol("stgTxtMc").$("txt21").css({"pointer-events":"none"});
	txt[22] = sym.getSymbol("teamsMc").$("txt22").css({"pointer-events":"none"});
	txt[23] = sym.getSymbol("stagesMc").$("txt23").css({"pointer-events":"none"});
	txt[24] = sym.$("txt24").css({"pointer-events":"none"});
	txt[25] = sym.$("txt25").css({"pointer-events":"none"});
	txt[26] = sym.$("txt26").css({"pointer-events":"none"});
	txt[27] = sym.$("txt27").css({"pointer-events":"none"});
	txt[28] = sym.getSymbol("stagesMc").$("txt28").css({"pointer-events":"none"});
	txt[29] = sym.$("txt29").css({"pointer-events":"none"});
	txt[30] = sym.getSymbol("stagesMc").$("txt30").css({"pointer-events":"none"});
	txt[31] = sym.getSymbol("stagesMc").$("txt31").css({"pointer-events":"none"});
	txt[32] = sym.$("txt32").css({"pointer-events":"none"});
	txt[33] = sym.getSymbol("results").getSymbol("classificationsBtn").$("phaseTxt").css({"pointer-events":"none"});
	txt[34] = sym.getSymbol("results").getSymbol("classBtn0").$("classTxt").css({"pointer-events":"none"});
	txt[35] = sym.getSymbol("results").getSymbol("classBtn1").$("classTxt").css({"pointer-events":"none"});
	txt[36] = sym.getSymbol("results").getSymbol("classBtn2").$("classTxt").css({"pointer-events":"none"});
	txt[37] = sym.getSymbol("results").getSymbol("classBtn3").$("classTxt").css({"pointer-events":"none"});
	txt[38] = sym.getSymbol("results").getSymbol("classBtn4").$("classTxt").css({"pointer-events":"none"});
	txt[39] = sym.getSymbol("results").$("txt17").css({"pointer-events":"none"});
	txt[40] = sym.getSymbol("results").$("txt18").css({"pointer-events":"none"});
	txt[41] = sym.$("txt41").css({"pointer-events":"none"})
	txt[42] = sym.$("txt42").css({"pointer-events":"none"});
	txt[43] = sym.$("txt43").css({"pointer-events":"none"});
	txt[44] = sym.$("txt44").css({"pointer-events":"none"});
	txt[45] = sym.$("txt45").css({"pointer-events":"none"});
	txt[46] = sym.$("txt46").css({"pointer-events":"none"});
	txt[47] = sym.$("txt47").css({"pointer-events":"none"});
	txt[48] = sym.$("txt48").css({"pointer-events":"none"});
	txt[49] = sym.$("txt49").css({"pointer-events":"none"});

	var menuArr=[];
	var txtArr=[];
	var nameArr=[];
	var countryArr=[];
	var ridersArr=[];
	var riderNoArr=[];
	var riderNatArr=[];
	for (var t=0;t<22;t++){ //arrays for each team
		ridersArr[t]=[];
		riderNoArr[t]=[];
		riderNatArr[t]=[];
	}
	var nameShortArr=[];
	var string0;
	var string1;
	var string2;
	var string3;
	var string4;
	var string5;
	var stagestring;
	var datestring;
	var tablestring;
	var resultstring0;
	var resultstring1;
	var resultstring2;
	var distancekm;
	var distancemap;
	var mediterranean;
//Stage array (includes map and profile captions)
	var profilekey;
	var mapkey;
	var keystring;
//end
	var mapStart;
	var mapFinish;

	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
	$.ajax({	
		type: "GET",
		url: "GN"+gnNo+".xml",
		dataType: "xml",
		success: function(xml) {
			custonCol = $(xml).find('customColour').text();
			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
			headline = $(xml).find('headline').text();
			headlinetxt.html(headline);
			source = $(xml).find('source').text();
			sourcetxt.html(source);
			for (var m=0; m<4; m++){
				menuArr[m]=$(xml).find('menuTxt'+m).text();
				menu[0].html(menuArr[0]);
			}
			for (var i=0; i<50; i++){
				txtArr[i]=$(xml).find('txt'+i).text();
				txt[i].html(txtArr[i]);
			}
			sym.getSymbol("stagesMc").$("graph").html(txtArr[32]);
			sym.getSymbol("results").$("table").html(txtArr[32]);
			sym.getSymbol("routeMc").$("txt20").html(txtArr[46]);
			for (var t=0;t<22;t++){		//get details for each team
				$(xml).find("team"+t).each(function(){
					var $teams = $(this);
					nameArr[t]=$teams.find('teamName').text();
					countryArr[t]=$teams.find('country').text();
					nameShortArr[t]=$teams.find('nameShort').text();		
					sym.getSymbol("teamsMc").getSymbol("teamBtn"+t).$("teamImg").attr("src", "teams/" + nameShortArr[t] + ".png");
						$teams.find("rider").each(function(){
						var $rider = $(this);
							riderNoArr[t].push($rider.find('number').text());
							ridersArr[t].push($rider.find('name').text());
							riderNatArr[t].push($rider.find('nation').text());
						});
				});
			}
			country.html(countryArr[0]);
			name.html(nameArr[0]);
			txtArr[20]=$(xml).find('txt20').text(); // Stage text for main map key
			txt[20].html(txtArr[20] + ' 1');
			var stringDate = $(xml).find('txt14').text(); // Stage date for stage btn info
         datestring=stringDate.split("<br>");
         var stringDistance = $(xml).find('txt15').text(); // Stage date for stage btn info
         distancestring=stringDistance.split("<br>");
			txtArr[21]=$(xml).find('txt21').text(datestring[0]+" "+datestring[1]); // Stage + number for stage btn info
			txt[21].html(txtArr[21]);
			distance = $(xml).find('distancekm').text();
			distancemap = $(xml).find('distancemap').text();
			mapStart = $(xml).find('mapStart').text();
			mapFinish = $(xml).find('mapFinish').text();
	var routeArr=[];
	var distArr=[];
	var capsArr=[];
	var stageRoute;
	for (var s=0;s<21;s++){			//get details for each race
		routeArr[s]=[]; //array of place names for each stage e.g. routeArr[0] is an array of names
		distArr[s]=[]; //array of distances for each stage e.g. distArr[0] is an array of numbers	
		$(xml).find("stage"+s).each(function(){
			var $stages = $(this);
			var stageRoute=$stages.find('route').text();
			routeArr[s]=stageRoute.split(";"); //array of place names for each stage, split by ";" 
			var stageDistance=$stages.find('distance').text();
			distArr[s]=stageDistance.split(";");//array of distances for each stage, split by ";" 
			var stageTotalLen=distArr[s].length;
			stageTotal=distArr[s][stageTotalLen-1]; //total distance = final distance in list
			var capsExtra=$stages.find('caps').text();
			capsArr[s]=capsExtra.split(";")
			for (var r=0;r<routeArr[s].length; r++){//ensure txtboxnames match - stagetxt0, stagetxt1, etc
				sym.getSymbol("stagesMc").getSymbol("profileMc"+s).$("stagetxt"+r).html(routeArr[s][r]);
				if (r==0){
					sym.getSymbol("stagesMc").getSymbol("mapMc"+s).$("maptxt0").html(mapStart +" "+ routeArr[s][0]);//first caption on map
				}else if(r==routeArr[s].length-1){
					sym.getSymbol("stagesMc").getSymbol("mapMc"+s).$("maptxt1").html(mapFinish +" "+ routeArr[s][r]);//last caption on map
				}
			}
			for (var d=0;d<distArr[s].length; d++){//ensure txtboxnames match - stagedst0, stagedst1, etc map0_dst1
				sym.getSymbol("stagesMc").getSymbol("profileMc"+s).$("stagedst"+d).html(distArr[s][d]);//e.g. 25
				if(d<distArr[s].length-1){
				 sym.getSymbol("stagesMc").getSymbol("mapMc"+s).$("mapdst"+d).html(distArr[s][d]+distance);//e.g. 25km
				}
			}
			//if(capsArr[s].length>0){
				for (var c=0;c<capsArr[s].length;c++){
					sym.getSymbol("stagesMc").getSymbol("mapMc"+s).$("cap"+c).html(capsArr[s][c]);//e.g. ROMA
				}
			//}
		});
	}
	$(".hrule hr").css({'color':'#CCCCCC','background-color':'#CCCCCC'});
	$(".map i").css({'display':'none'});
		sym.getSymbol("routeMc").$("txt5").animate({left:555 - sym.getSymbol("routeMc").$("txt5").width()-40}, 0);
	},
	complete:function(){
		teamLoad();
		loadTable();
	}
}); // END XML

	// MENU BUTTONS --------------------------------------------	
	menuArray = []; //the array that will hold references to the buttons.

	for (var h = 0; h < 4; h++){
		var menuBtnSymbols = sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" +h); // Create an instance element of a symbol as a child of the given parent element
		menuBtnSymbols.setVariable("menuId", h); //set the value of a Symbol variable
		menuArray.push(menuBtnSymbols); //push it into the array
	}

	$.each(menuArray, function( count, menuInTheArray ){ //a 'for each' loop through the newly populated array
		var menuBtnItem = $(menuInTheArray); //create jQuery reference to the item
		var menuBtnElement = menuInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
		menuBtnElement.bind (clickEventType, {menuId:count}, menuBtnClick);
		//menuBtnElement.bind ("touchstart", {menuId:count}, menuBtnClick);
		menuBtnElement.bind ("mouseover", {menuId:count}, menuShow);
		menuBtnElement.bind ("mouseout", {menuId:count}, menuHide);
	})

	function resetmenu(){
		for (var h=0; h<menuArray.length; h++){
         menuArray[h].$("btnClick").fadeOut(0);
         menuArray[h].$("btnOver").fadeOut(0);
		}
	}
	resetmenu();

	function menuBtnClick (e){
		resetmenu(); //set them all back to normal state
		var menuMenu_id = (e.data.menuId); //get the id of the clicked item
		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuMenu_id).$("btnClick").fadeIn(0);
		var endMc=sym.getSymbol("routeMc").getDuration();
		var playMc=sym.getSymbol("routeMc").getPosition();
		sym.$("routeMc").stop().fadeOut(500);
		sym.$("stagesMc").stop().fadeOut(500);
		sym.$("teamsMc").stop().fadeOut(500);
		sym.$("results").stop().fadeOut(500);
		if (menuMenu_id==0) {
			sym.$("routeMc").stop().fadeIn(500);
			if (playMc<endMc){
				sym.getSymbol("routeMc").play(playMc);
			}
		}
		if (menuMenu_id==1) {
			sym.$("stagesMc").stop().fadeIn(500);
			stageLoad();
		}
		if (menuMenu_id==2) {
			teamLoad();
			sym.$("teamsMc").stop().fadeIn(500);
		}
		if (menuMenu_id==3) {
			sym.$("results").stop().fadeIn(500);
		}
	}

	function menuShow (e){
		var menuMenu_id = (e.data.menuId); //get the id of the over button
		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuMenu_id).$("btnOver").fadeIn(0);
		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[menuMenu_id]);
	}
	function menuHide (e){
		var menuMenu_id = (e.data.menuId); //get the id of the out button
		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuMenu_id).$("btnOver").fadeOut(0);
		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
	}
sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("btnClick").fadeIn(0);
// START TEAM BUTTONS *********************************************************************	
teamArray = []; //the array that will hold references to the buttons.
for (var a = 0; a < 22; a++){
		var teamBtnSymbols = sym.getSymbol("teamsMc").getSymbol("teamBtn" +a); // Create an instance element of a symbol as a child of the given parent element
		teamBtnSymbols.setVariable("teamId", a); //set the value of a Symbol variable
		teamArray.push(teamBtnSymbols); //push it into the array
	}
$.each(teamArray, function( count, teamInTheArray ){ //a 'for each' loop through the newly populated array
		var teamBtnItem = $(teamInTheArray); //create jQuery reference to the item
		var teamBtnElement = teamInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
		teamBtnElement.bind ("click", {teamId:count}, teamBtnClick);
		teamBtnElement.bind ("touchstart", {teamId:count}, teamBtnClick);
		teamBtnElement.bind ("mouseover", {teamId:count}, teamBtnShow);
		teamBtnElement.bind ("mouseout", {teamId:count}, teamBtnHide);
	})
function resetteam(){
		for (var a=0; a<teamArray.length; a++){
        	teamArray[a].$("btnClick").fadeOut(0);
       	teamArray[a].$("btnOver").fadeOut(0);
		}
	}
	resetteam();
function teamBtnClick (e){
		resetteam(); //set them all back to normal state
		var teamteam_id = (e.data.teamId); //get the id of the clicked item
		teamNo = teamteam_id;
		teamLoad();
		loadTable();
	}
function teamBtnShow (e){
		var teamteam_id = (e.data.teamId); //get the id of the over button
		sym.getSymbol("teamsMc").getSymbol("teamBtn" + teamteam_id).$("btnOver").fadeIn(0);
	}
function teamBtnHide (e){
		var teamteam_id = (e.data.teamId); //get the id of the out button
		sym.getSymbol("teamsMc").getSymbol("teamBtn" + teamteam_id).$("btnOver").fadeOut(0);
	}
	sym.getSymbol("teamsMc").getSymbol("teamBtn0").$("btnClick").fadeIn(0);
function teamLoad(){
		sym.getSymbol("teamsMc").getSymbol("teamBtn" + teamNo).$("btnClick").fadeIn(0);
		sym.getSymbol("teamsMc").$("teamMain").stop().fadeOut(0);
		sym.getSymbol("teamsMc").$("teamMain").attr("src", "teams/" + nameShortArr[teamNo] + ".png");
		sym.getSymbol("teamsMc").$("teamMain").stop().fadeIn(300);
		sym.getSymbol("teamsMc").$("teamName").html(nameArr[teamNo]);
		sym.getSymbol("teamsMc").$("country").html(countryArr[teamNo]);
	}
// TABLE START
function loadTable(){
	sym.getSymbol("teamsMc").$("table").empty();
	htmlOutput = '<table width="100%" border="0" cellpadding="4" cellspacing="0">';
	for (var n=0;n<ridersArr[teamNo].length;n++){
	htmlOutput+='<tr><td  class="rideNo">'+ riderNoArr[teamNo][n] +'</td><td  class="riderName">'+ ridersArr[teamNo][n] +'</td><td class="riderNat">'+ riderNatArr[teamNo][n] +'</td></tr>';
	}
	htmlOutput += '</table>';
	sym.getSymbol("teamsMc").$("table").append(htmlOutput);
	sym.getSymbol("teamsMc").$("table tr:odd").css({"text-align":"left", "background-color":'rgba(0,113,187,0.3)',"color":"#000000", "font":"13px Pragmatica-web, sans-serif"});
	sym.getSymbol("teamsMc").$("table tr:even").css({"text-align":"left", "background-color":'rgba(0,113,187,0.2)',"color":"#000000", "font":"13px Pragmatica-web, sans-serif"});
	$(".riderNo").css({'width':'10%','border':'solid 0 #FFF','border-top-width':'1px','padding-left':'5px'})
	$(".riderName").css({'width':'75%','border':'solid 0 #FFF', 'border-top-width':'1px'});
	$(".riderNat").css({'width':'15%','border':'solid 0 #FFF', 'border-top-width':'1px','padding-left':'5px','font-style':'oblique'});
}
// TABLE END
// END TEAM BUTTONS *********************************************************************
// START STAGE BUTTONS *********************************************************************
stageArray = []; //the array that will hold references to the buttons.
for (var a = 0; a < 21; a++){
		var stageBtnSymbols = sym.getSymbol("stagesMc").getSymbol("stageBtn" +a); // Create an instance element of a symbol as a child of the given parent element
		stageBtnSymbols.setVariable("stageId", a); //set the value of a Symbol variable
		stageArray.push(stageBtnSymbols); //push it into the array
}
$.each(stageArray, function( count, stageInTheArray ){ //a 'for each' loop through the newly populated array
		var stageBtnItem = $(stageInTheArray); //create jQuery reference to the item
		var stageBtnElement = stageInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
		stageBtnElement.bind ("click", {stageId:count}, stageBtnClick);
		stageBtnElement.bind ("touchstart", {stageId:count}, stageBtnClick);
		stageBtnElement.bind ("mouseover", {stageId:count}, stageBtnShow);
		stageBtnElement.bind ("mouseout", {stageId:count}, stageBtnHide);
	})
function resetstage(){
		for (var a=0; a<stageArray.length; a++){
        	stageArray[a].$("btnClick").fadeOut(0);
       	stageArray[a].$("btnOver").fadeOut(0);
       	stageArray[a].$("txt").css({"color":"black"});
		}
      sym.getSymbol("stagesMc").$("graph").empty();
		sym.getSymbol("stagesMc").$("preloader").fadeIn(400);
		sym.getSymbol("stagesMc").$("weather").attr('src','images/weather0.png');
		sym.getSymbol("stagesMc").$("wind").attr('src','images/weather0.png');
		sym.getSymbol("stagesMc").$("liveline").empty();
		sym.getSymbol("stagesMc").$("windTxt").html("");
		sym.getSymbol("stagesMc").$("preloader").fadeIn(400);
	}
resetstage();
function stageBtnClick (e){
		resetstage(); //set them all back to normal state
		clearInterval(raceInterval);
		var stagestage_id = (e.data.stageId); //get the id of the clicked item
		stgMove = stagestage_id;
		fadeProfilesOut();
		stageLoad();
		/*
		if(stgMove<3){
			sym.getSymbol("stagesMc").$("mapMini").attr("src", "images/mapMini.jpg");
			sym.getSymbol("stagesMc").$("txt34").fadeIn(0);//Dublin
			sym.getSymbol("stagesMc").$("txt35").fadeIn(0);//Ireland
		}else{
			sym.getSymbol("stagesMc").$("mapMini").attr("src", "images/mapMini2.jpg");
			sym.getSymbol("stagesMc").$("txt34").fadeOut(0);
			sym.getSymbol("stagesMc").$("txt35").fadeOut(0);
		}
		*/
	}
function stageBtnShow (e){
		var stagestage_id = (e.data.stageId); //get the id of the over button
		sym.getSymbol("stagesMc").getSymbol("stageBtn" + stagestage_id).$("btnOver").fadeIn(0);
		sym.getSymbol("stagesMc").getSymbol("stageBtn" + stagestage_id).$("txt").css({"color":"white", "font-weight":"bold"});
	}
function stageBtnHide (e){
		var stagestage_id = (e.data.stageId); //get the id of the out button
		sym.getSymbol("stagesMc").getSymbol("stageBtn" + stagestage_id).$("btnOver").fadeOut(0);
		sym.getSymbol("stagesMc").getSymbol("stageBtn" + stagestage_id).$("txt").css({"color":"black", "font-weight":"normal"});
	}
function fadeProfilesOut(){
	for (var p=0;p<21; p++){
		sym.getSymbol("stagesMc").$("profileMc"+p).fadeOut(0);
		sym.getSymbol("stagesMc").$("mapMc"+p).fadeOut(0);
		}
	}
fadeProfilesOut();
function stageLoad() {
		sym.getSymbol("stagesMc").$("profileImg").stop().fadeOut(0);
		sym.getSymbol("stagesMc").$("profileImg").attr("src", "profiles/profile" + stgMove + ".png"); // Load profile image 
		sym.getSymbol("stagesMc").$("profileImg").stop().fadeIn(0);
		sym.getSymbol("stagesMc").$("mapImg").stop().fadeOut(0);
		sym.getSymbol("stagesMc").$("mapImg").attr("src", "maps/map" + stgMove + ".png"); // Load map image 
		sym.getSymbol("stagesMc").$("mapImg").stop().fadeIn(300);
		sym.getSymbol("stagesMc").$("profileMc"+stgMove).stop().fadeIn(300);
		sym.getSymbol("stagesMc").$("mapMc"+stgMove).stop().fadeIn(300);
		for (var k=0;k<stgMove; k++){
		sym.getSymbol("stagesMc").$("stageBtn"+k).stop().animate ({left:k*move}, 0, 'easeOutCubic');
		}
		for (var h=stgMove;h<21; h++){
		sym.getSymbol("stagesMc").$("stageBtn"+h).stop().animate ({left:h*move + 128}, 200, 'easeOutCubic');
		sym.getSymbol("stagesMc").$("stgTxtMc").stop().animate ({left:stgMove*move}, 200, 'easeOutCubic');
		sym.getSymbol("stagesMc").getSymbol("stgTxtMc").$("txt20").html(txtArr[20] + " " + (stgMove + 1));
		sym.getSymbol("stagesMc").getSymbol("stgTxtMc").$("txt21").html(datestring[0]+" "+datestring[stgMove+1]);
		sym.getSymbol("stagesMc").$("txt23").html(txtArr[23] + txtArr[24] + txtArr[25]); // ADD PROFILE KEY
		//sym.getSymbol("stagesMc").$("txt29").html(txtArr[29] +" "+ (distancestring[stgMove+1]) + txtArr[28]); // ADD DISTANCE TO PROFILE
			if (stgMove == 0) {
				sym.getSymbol("stagesMc").$("txt23").html(txtArr[26]); // ADD TTT PROFILE KEY
			}
			if (stgMove == 13) {
				sym.getSymbol("stagesMc").$("txt23").html(txtArr[27]); // ADD ITT PROFILE KEY
			}
		}
	}
for (var r=0;r<21;r++){
	sym.getSymbol("routeMc").$("stageBtn" +r).on('click',{stageId:r}, stageBtnClick);
 	sym.getSymbol("routeMc").$("stageBtn" +r).on ("click", {menuId:1}, menuBtnClick);
}
// END STAGE BUTTONS *********************************************************************
//LIVE DATA
function resetPhases(){
	sym.getSymbol("results").getSymbol("classificationsBtn").$("tab").css({'background-color':'rgb(206,206,206)'});
	sym.getSymbol("results").getSymbol("classificationsBtn").$("phaseTxt").css({'color':'rgb(100,100,100)'});
}
resetPhases();
var classClicker = function(stage,id){ //to handle lexical scope
							return function (e) {
							getPhase(stage,id);
							txt[39].html(txtArr[39+id]);
							for (i=0;i<5;i++){
									if (i==id){
										sym.getSymbol("results").getSymbol("classBtn"+i).$("classTxt").css({'font-weight':700,'color':'rgb(0,0,0)'});
										sym.getSymbol("results").$("classBtn"+i).css({'border':'solid 0px rgb(255,0,0)'});
										if(i==1||i==2){
										 txt[40].html(txtArr[45]);
										}else{
											txt[40].html(txtArr[44]);
										}
									}else{
										sym.getSymbol("results").getSymbol("classBtn"+i).$("classTxt").css({'font-weight':400,'color':'rgb(100,100,100)'});
										sym.getSymbol("results").$("classBtn"+i).css({'border':'solid 1px rgb(255,255,255)'});
									}								
							}
							sym.getSymbol("results").getSymbol("classificationsBtn").$("tab").css({'background-color':'rgb(255,255,255)'});
							sym.getSymbol("results").getSymbol("classificationsBtn").$("phaseTxt").css({'color':'rgb(0,0,0)'});
						};
};
//GET race stage list data
var todayStage=0;
var latestStage;
function getRace(){
		for (var s=0; s<21; s++){											
			//sym.getSymbol("stagesMc").$("stageBtn"+s).off('click',stageChanger);
		}
		$.ajax({ type: "GET", 
		url: dataURL,
		data: "gn="+gnNo+"&type=cycling&yr="+gnYear+"&q=stages",
		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
		async: true,
		crossDomain: true,
		success: function (data) {
		//sym.getSymbol("styleHead").$("menuBtn3").unbind('click');
		//	sym.getSymbol("results").$("classificationsBtn").unbind('click');
		//	for (var c=0;c<5;c++){
		//		sym.getSymbol("results").$("classBtn"+c).unbind('click');
		//	}
			for (var s=0; s<21; s++){											
				//sym.getSymbol("stagesMc").$("stageBtn"+s).off('click',stageChanger);
			}
			for (var i=0; i<data.length; i++){											
					var thisStage=data[i].n_PhaseID;
					sym.getSymbol("stagesMc").$("stageBtn"+i).unbind('click',stageChanger);
					if(data[i].b_Current==true){
						todayStage=i;
					}
					if(data[i].b_Live==true){
						var stageFinished='false';
					}else if(data[i].b_Finished==true){
						var stageFinished='true';
					}	
					sym.getSymbol("stagesMc").$("stageBtn"+i).on('click',stageChanger(thisStage));
					sym.getSymbol("menuBtnsMc").$("menuBtn3").off("click").on ("click", {menuId:3}, menuBtnClick);	
			}
			latestStage=data[todayStage].n_PhaseID;
				sym.getSymbol("results").$("classBtn1").off().on('click',classClicker(classifications[1],1));//Points Classification							  
				sym.getSymbol("results").$("classBtn2").off().on('click',classClicker(classifications[2],2));//Mountain Classification		
				sym.getSymbol("results").$("classBtn3").off().on('click',classClicker(classifications[3],3));//Young Rider Classification		

			if (stageFinished=='true'){
						sym.getSymbol("menuBtnsMc").$("menuBtn3").on('click',classClicker(classifications[0],0));//bind classification buttons
			}
			sym.getSymbol("results").$("classificationsBtn").off().on('click',classClicker(classifications[0],0));//bind classification buttons
			sym.getSymbol("results").$("classificationsBtn").css({'cursor':'pointer'});
			sym.getSymbol("results").$("classBtn0").off().on('click',classClicker(classifications[0],0));
			sym.getSymbol("results").$("classBtn4").off().on('click',classClicker(classifications[4],4));
		}
   });
}
getRace();
setTimeout(function checkStart(){
	getStageInfo(latestStage);
	if (todayDate>=startDate){
		raceInterval = setInterval(getRace,120000);
		stgMove = todayStage;
		fadeProfilesOut();
		stageLoad();
		stageInterval = setInterval(function(){getStageInfo(latestStage)},30000);
		if (stgMove>0){
			resetmenu;
			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn1").$("btnClick").fadeIn(0);
			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("btnClick").fadeOut(0);
			sym.$("routeMc").fadeOut(800);
			sym.$("stagesMc").fadeIn(800);
			sym.$("results").fadeOut(800);
			sym.$("teamsMc").fadeOut(800);
			sym.getSymbol("routeMc").stop(0);
		}
	}
},1500);
function getStageInfo(stageID){
sym.getSymbol("stagesMc").$("preloader").fadeIn(400);
sym.getSymbol("stagesMc").$("liveline").css({'width':0});
$.ajax({ type: "GET", 
			url: dataURL,
			data: "gn="+gnNo+"&yr="+gnYear+"&stage="+stageID+"&q=info",
			contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
			async: true,
			crossDomain: true,
			success: function (data) {
           var stageinfo=data;
           var weather=stageinfo[0].n_WeatherConditionType;
           var wind=(stageinfo[0].n_WindDirection)?stageinfo[0].n_WindDirection:0;
           sym.getSymbol("stagesMc").$("weather").attr('src','images/weather'+weather+'.png');
           sym.getSymbol("stagesMc").$("wind").attr('src','images/wind'+wind+'.png');
           var stagelive=(stageinfo[0].b_Live==true)?1:0;
           var stagefin=(stageinfo[0].b_Finished==true)?1:0;
           var speed =(stageinfo[0].c_AverageSpeed>0)?stageinfo[0].c_AverageSpeed:"";
			  var startTime=getMatchLocal(stageinfo[0].d_DateStart);
           var completed=(stageinfo[0].n_DistanceDriven/stageinfo[0].n_DistanceScheduled)*100;
           //var liveLine="<div id='comp'></div>";//shows progress bar through the stage
           //sym.getSymbol("stagesMc").$("liveline").append(liveLine);
				//$("#comp").css({'width':completed+'%','height':'156px','background-color':'rgba(250,166,26,1)'});
				sym.getSymbol("stagesMc").$("liveline").css({'width':completed+'%'});
           var windSpeed=stageinfo[0].n_WindSpeed;
				windSpeed=windSpeed/1000;
           if (stagelive==1){
					txt[30].html(txtArr[47]);
					sym.getSymbol("stagesMc").$("windTxt").html(windSpeed);
					getBreak(stageID);
           }else{
           		if(todayDate>=startDate-(86400000*5)||stgMove==0){
						txt[30].html(txtArr[30]+startTime);
           		}else{
						txt[30].html(txtArr[49]);
           		}
				}
			if(stagefin==1){
					txt[30].html(txtArr[49]);
					getStage(stageID);
					sym.getSymbol("stagesMc").$("windTxt").html(windSpeed);
         }
		}
	});
}
function getBreak(stageID){//get breakaway group live
	$.ajax({ type: "GET", 
		url: dataURL,
		data: "gn="+gnNo+"&yr="+gnYear+"&stage="+stageID+"&q=group",
		contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
		async: true,
		crossDomain: true,
		success: function (data) {
			var breakData=data;
			sym.getSymbol("stagesMc").$("graph").empty();
			if (breakData){
				sym.getSymbol("stagesMc").$("preloader").fadeOut(400);
				txt[30].html(txtArr[47]+txtArr[48]);
				for (var i = 0; i < breakData.length; i++) {
					var breakAway=breakData[i].n_GroupDisplayNr;
					if(breakData[i].n_GroupSort<0){
						var tableText ="<div class='race'>";
						if(breakData[i].n_GroupDisplayNr==1){
							tableText += "<div id='riderdata"+i+"' class='break1'>";
						}else{
							if(breakData[i].n_GroupPersonSort==1){
								tableText += "<div id='riderdata"+i+"' class='breakLeader'>";
							}else{
								tableText += "<div id='riderdata"+i+"'>";
							}													
						}
						tableText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
						tableText += "<td id='rank"+i+"' width='7%'></td>";
						tableText += "<td id='rider"+i+"'width='43%'></td>";
						tableText += "<td id='team"+i+"' style='font-style:italic' width='10%'></td>";
						tableText += "<td id='time"+i+"' style='font-style:italic'></td>";
						tableText += "</tr></table>";
						tableText += "</div>";
						tableText += "</div>";
						sym.getSymbol("stagesMc").$("graph").append(tableText);
						$('#rank' + i).text(breakData[i].c_ShirtNr);
						$('#rider' + i).text(breakData[i].c_Person);
						$('#team' + i).text(breakData[i].c_TeamShort);
						$('#time' + i).text("-"+(Math.floor(breakData[i].n_AttackLeadMax/60000))+":"+(breakData[i].n_AttackLeadMax%60000)/1000);
						$(".race").css({'font-size':'13px', 'font-family':'pragmatica-web, sans-serif', 'width':'98%'});
						if (i==0){
							$('#rider' + i).css({'font-weight':'bold','padding-left':'5px','background-color':'rgba(255,255,255,0.7)'});
						}else{
							$('#rider' + i).css({'padding-left':'5px','background-color':'rgba(255,255,255,0.7)'});
						}
						$("#riderdata" + i).css({'padding-left':'3px', 
								'border-top':'solid 1px rgb(255,255,255)',
								'border-bottom':'solid 1px rgb(150,150,150)'});
						if (i%2==0){
							$("#riderdata" + i +".break1").css({'background-color':'rgb(213,218,224)'});
						}else{
							$("#riderdata" + i+".break1").css({'background-color':'rgb(239,239,239)'});							
						}
						$(".breakLeader").css({'border-top':'inset 1px rgb(255,255,255)'});
						$("#team" + i).css({'text-align':'center'});
						$('#time' + i).css({'text-align':'right'});
					}
				}
			}
		}
	});
}
function getStage(stageID){
//sym.getSymbol("stagesMc").$("preloader").fadeIn(400);
$.ajax({ type: "GET", 
					url: dataURL,
               data: "gn="+gnNo+"&yr="+gnYear+"&stage="+stageID,
               contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
               async: true,
               crossDomain: true,
               success: function (data) {
						var classData = data;
						sym.getSymbol("stagesMc").$("graph").empty();
						if (classData.length>0){
							sym.getSymbol("stagesMc").$("preloader").fadeOut(400);
						}											
						for (var i = 0; i < classData.length; i++) {
							//create graph for each rider and for final results
							var tableText ="<div class='race'>";
							tableText += "<div id='riderdata"+i+"'>";
							tableText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
							tableText += "<td id='rank"+i+"' width='7%'></td>";
							tableText += "<td id='rider"+i+"'width='56%'></td>";
							tableText += "<td id='team"+i+"' style='font-style:italic' width='10%'></td>";
							tableText += "<td id='time"+i+"'></td>";
							tableText += "</tr></table>";
							tableText += "</div>";
							tableText += "</div>";
							sym.getSymbol("stagesMc").$("graph").append(tableText);
							$('#rank' + i).text(classData[i].c_Rank);
							$('#rider' + i).text(classData[i].c_Participant);
							$('#team' + i).text(classData[i].c_TeamShort);
							if(classData[i].c_Result!=null){
							$('#time' + i).text(classData[i].c_Result);
							}else{
							$('#time' + i).text("");
							}
						$(".race").css({'font-size':'14px', 'color':'black','font-family':'pragmatica-web, sans-serif', 'width':'98%'});
						if (i==0){
							$('#rider' + i).css({'font-weight':'bold','padding-left':'5px','background-color':'rgba(255,255,255,0.5)','padding-bottom':'3px', 'padding-top':'3px'});
						}else{
							$('#rider' + i).css({'padding-left':'5px','background-color':'rgba(255,255,255,0.5)','padding-bottom':'3px', 'padding-top':'3px'});
						}
						if (i%2==0){
								$("#riderdata" + i).css({'background-color':'rgba(0,113,187,0.3)',
								'padding-left':'3px', 
								'border-top':'solid 0px rgb(255,255,255)',
								'border-bottom':'solid 1px rgb(255,255,255)',
								'padding-bottom':'0px',
								'padding-top':'0px'});
						}else{
								$("#riderdata" + i).css({'background-color':'rgba(0,113,187,0.2)',
								'padding-left':'3px', 
								'border-top':'solid 0px rgb(255,255,255)',
								'border-bottom':'solid 1px rgb(255,255,255)',
								'padding-bottom':'0px',
								'padding-top':'0px'});							
						}
						$("#team" + i).css({'text-align':'center'});
						$("#time" + i).css({'text-align':'right', 'padding-right':'5px'});
						}
						},
						error: function(){
						sym.getSymbol("stagesMc").$("graph").empty();					
						}
	});
}
function getPhase(stageID,classID){
sym.getSymbol("results").$("preloader").fadeIn(400);
sym.getSymbol("results").$("table").empty();
$.ajax({ type: "GET", 
					url: dataURL,
               data: "gn="+gnNo+"&yr="+gnYear+"&stage="+stageID,
               contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
               async: true,
               crossDomain: true,
               success: function (data) {                
						var raceStage = data;
				if(data.length>0){
						sym.getSymbol("results").$("preloader").fadeOut(400);
						var scale;
						if (classID==1||classID==2){//Points or Mountain
							var max = raceStage[0].n_Points;
							var minTime = (max!=null) ? max : 0;
								for (var n=0; n<raceStage.length; n++) {
									if (raceStage[n].n_Points!=null && raceStage[n].n_Points<minTime) {
									minTime = raceStage[n].n_Points;
									}
									if (raceStage[n].n_Points!=null && raceStage[n].n_Points>max) {
									max = raceStage[n].n_Points;									
									}
								}
						/*								
						}else if(classID==3){//Combination
							var minTime = raceStage[0].n_Points;
							var max = (minTime!=null) ? minTime : 0;
								for (var n=0; n<raceStage.length; n++) {
									if (raceStage[n].n_Points!=null && raceStage[n].n_Points>max) {
									max = raceStage[n].n_Points;
									}
									if (raceStage[n].n_Points!=null && raceStage[n].n_Points<minTime) {
									minTime = raceStage[n].n_Points;									
									}
								}
						*/
						}else{//General or Young rider
							var minTime = raceStage[0].n_TimeAbs;
							var max = (minTime!=null) ? minTime : 0;
								for (var n=0; n<raceStage.length; n++) {
									if (raceStage[n].n_TimeAbs!=null && raceStage[n].n_TimeAbs>max) {
									max = raceStage[n].n_TimeAbs;
									}
									if (raceStage[n].n_TimeAbs!=null && raceStage[n].n_TimeAbs<minTime) {
									minTime = raceStage[n].n_TimeAbs;									
									}
								}						
						}
							for (var i = 0; i < raceStage.length; i++) {
								var stageText ="<div class='stg'>";
								stageText += "<div id='stgdata"+i+"'>";
								stageText += "<table style='width:100%; border:none; border-collapse:collapse; padding:0; margin:0'><tr>";
								stageText += "<td id='stgrank"+i+"' width='35px'></td>";
								stageText += "<td id='stgrider"+i+"' width='180px'></td>";
								stageText += "<td id='stgflag"+i+"' width='30px'></td>";
								stageText += "<td id='stgteam"+i+"' style='font-style:italic' width='50px'></td>";
								stageText += "<td id='stgtime"+i+"'></td>";
								stageText += "</tr></table>";
								stageText += "</div></div>";
								if (classID==1||classID==2){								
									if (max==minTime && raceStage[i].n_Points==max) {
										scale=100;
									}else if(raceStage[i].n_Points==null){
										scale=59;
									}else{
										scale = 59+((raceStage[i].n_Points-minTime)*41/(max-minTime));
									}
							/*	}else if(classID==3){//Combination
									if (minTime==max && raceStage[i].n_Points==minTime) {
										scale=100;
									}else if(raceStage[i].n_Points==null){
										scale=59;
									}else{
										scale = 100-((raceStage[i].n_Points-minTime)*41/(max-minTime));
									}	*/							
								}else{
								if (minTime==max && raceStage[i].n_TimeAbs==max) {	//if minTime=mxm=item Time that means that there is just 1 item with valid time. show this graph as max
										scale=100;
									}else if(raceStage[i].n_TimeAbs==null){
										scale=59;
									}else{
										scale = 100-((raceStage[i].n_TimeAbs-minTime)*41/(max-minTime));
									}
								}
								sym.getSymbol("results").$("table").append(stageText);
								$('#stgrank' + i).text(raceStage[i].c_Rank);
								$('#stgrider' + i).text(raceStage[i].c_Participant);
								$('#stgteam' + i).text(raceStage[i].c_TeamShort);
								$('#stgflag' + i).text(raceStage[i].c_NOCShort);
								if(raceStage[i].c_Result!=null){
									$('#stgtime' + i).text(raceStage[i].c_Result);
								}else{
									$('#stgtime' + i).text("");
								}
								$(".stg").css({'font-size':'14px', 'font-family':'pragmatica-web, sans-serif', 'width':'99%'});
								if (i==0){
									$('#stgrider' + i).css({'font-weight':'bold'});
								}
								if (i%2==0){
									$("#stgdata" + i).css({'width':scale+'%',
									'background-color':'rgba(0,113,187,0.3)',
									'padding-left':'3px', 
									'border-top':'solid 0px rgb(255,255,255)',
									'border-bottom':'solid 1px rgb(255,255,255)',
									'padding-bottom':'0px',
									'padding-top':'0px'});
								}else{
									$("#stgdata" + i).css({'width':scale+'%',
									'background-color':'rgba(0,113,187,0.2)',
									'padding-left':'3px', 
									'border-top':'solid 0px rgb(255,255,255)',
									'border-bottom':'solid 1px rgb(255,255,255)',
									'padding-bottom':'0px',
									'padding-top':'0px'});								
								}
								$("#stgteam" + i).css({'text-align':'center','background-color':'rgba(255,255,255,0.5)','padding-bottom':'3px', 'padding-top':'3px'});
								$("#stgtime" + i).css({'text-align':'right', 'padding-right':'5px'});
						}
						}else{
							sym.getSymbol("results").$("table").html(txtArr[32]);
						}
               }
			});
}

         	});//Edge binding end	
		
		// VIDEO BTN 1 =========================================================
         	
			
         	
         		
         	
			
			
         	// VIDEO BTN 2 =========================================================
         	
         	
         	
         		
         	
         	


      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3000, function(sym, e) {
         sym.$("introMc").fadeOut(0);

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'styleHead_1'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'menuBtn_2'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn_1'
   (function(symbolName) {   
   
      })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("stagesMc");
   //Edge symbol end:'stagesMc'

   //=========================================================
   
   //Edge symbol: 'stageBtn'
   (function(symbolName) {   
   
   })("stageBtn");
   //Edge symbol end:'stageBtn'

   //=========================================================
   
   //Edge symbol: 'teamsMc'
   (function(symbolName) {   
   
   })("teamsMc");
   //Edge symbol end:'teamsMc'

   //=========================================================
   
   //Edge symbol: 'teamBtn0'
   (function(symbolName) {   
   
   })("teamBtn0");
   //Edge symbol end:'teamBtn0'

   //=========================================================
   
   //Edge symbol: 'stgTxtNo'
   (function(symbolName) {   
   
   })("stgTxtNo");
   //Edge symbol end:'stgTxtNo'

   //=========================================================
   
   //Edge symbol: 'MountainBtn'
   (function(symbolName) {   
   
   })("MountainBtn");
   //Edge symbol end:'MountainBtn'

   //=========================================================
   
   //Edge symbol: 'phaseBtn'
   (function(symbolName) {   
   
   })("phaseBtn");
   //Edge symbol end:'phaseBtn'

   //=========================================================
   
   //Edge symbol: 'TeamBtn'
   (function(symbolName) {   
   
   })("TeamBtn");
   //Edge symbol end:'TeamBtn'

   //=========================================================
   
   //Edge symbol: 'GeneralBtn'
   (function(symbolName) {   
   
   })("GeneralBtn");
   //Edge symbol end:'GeneralBtn'

   //=========================================================
   
   //Edge symbol: 'ResultsMc'
   (function(symbolName) {   
   
   })("ResultsMc");
   //Edge symbol end:'ResultsMc'

   //=========================================================
   
   //Edge symbol: 'YouthBtn'
   (function(symbolName) {   
   
   })("YouthBtn");
   //Edge symbol end:'YouthBtn'

   //=========================================================
   
   //Edge symbol: 'ClassificationsBtn'
   (function(symbolName) {   
   
   })("ClassificationsBtn");
   //Edge symbol end:'ClassificationsBtn'

   //=========================================================
   
   //Edge symbol: 'PointsBtn'
   (function(symbolName) {   
   
   })("PointsBtn");
   //Edge symbol end:'PointsBtn'

   //=========================================================
   
   //Edge symbol: 'LeadTeam'
   (function(symbolName) {   
   
   })("LeadTeam");
   //Edge symbol end:'LeadTeam'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc8_1'
   (function(symbolName) {   
   
      })("mapMc9");
   //Edge symbol end:'mapMc9'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc7_1'
   (function(symbolName) {   
   
      })("mapMc8");
   //Edge symbol end:'mapMc8'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc6_1'
   (function(symbolName) {   
   
      })("mapMc7");
   //Edge symbol end:'mapMc7'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc5_1'
   (function(symbolName) {   
   
      })("mapMc6");
   //Edge symbol end:'mapMc6'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc4_1'
   (function(symbolName) {   
   
      })("mapMc5");
   //Edge symbol end:'mapMc5'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc2_1'
   (function(symbolName) {   
   
      })("mapMc4");
   //Edge symbol end:'mapMc4'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc2_1'
   (function(symbolName) {   
   
      })("mapMc3");
   //Edge symbol end:'mapMc3'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc19_1'
   (function(symbolName) {   
   
      })("mapMc20");
   //Edge symbol end:'mapMc20'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc1_1'
   (function(symbolName) {   
   
      })("mapMc2");
   //Edge symbol end:'mapMc2'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc18_1'
   (function(symbolName) {   
   
      })("mapMc19");
   //Edge symbol end:'mapMc19'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc17_1'
   (function(symbolName) {   
   
      })("mapMc18");
   //Edge symbol end:'mapMc18'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc16_1'
   (function(symbolName) {   
   
      })("mapMc17");
   //Edge symbol end:'mapMc17'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc15_1'
   (function(symbolName) {   
   
      })("mapMc16");
   //Edge symbol end:'mapMc16'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc13_1'
   (function(symbolName) {   
   
      })("mapMc15");
   //Edge symbol end:'mapMc15'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc13_1'
   (function(symbolName) {   
   
      })("mapMc14");
   //Edge symbol end:'mapMc14'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc12_1'
   (function(symbolName) {   
   
      })("mapMc13");
   //Edge symbol end:'mapMc13'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc11_1'
   (function(symbolName) {   
   
      })("mapMc12");
   //Edge symbol end:'mapMc12'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc10_1'
   (function(symbolName) {   
   
      })("mapMc11");
   //Edge symbol end:'mapMc11'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc8_1'
   (function(symbolName) {   
   
      })("mapMc10");
   //Edge symbol end:'mapMc10'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc0_1'
   (function(symbolName) {   
   
      })("mapMc1");
   //Edge symbol end:'mapMc1'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'mapMc0'
   (function(symbolName) {   
   
   })("mapMc0");
   //Edge symbol end:'mapMc0'

   //=========================================================

   //=========================================================
   
   //Edge symbol: 'stageBtn'
   (function(symbolName) {   
   
   })("stageBtn_1");
   //Edge symbol end:'stageBtn_1'

   //=========================================================
   
   //Edge symbol: 'startMc'
   (function(symbolName) {   
   
   })("startMc");
   //Edge symbol end:'startMc'

   //=========================================================
   
   //Edge symbol: 'finishMc'
   (function(symbolName) {   
   
   })("finishMc");
   //Edge symbol end:'finishMc'

   //=========================================================
   
   //Edge symbol: 'ttMc'
   (function(symbolName) {   
   
   })("itMc");
   //Edge symbol end:'itMc'

   //=========================================================
   
   //Edge symbol: 'iconItMC'
   (function(symbolName) {   
   
   })("iconItMC");
   //Edge symbol end:'iconItMC'

   //=========================================================
   
   //Edge symbol: 'iconIT'
   (function(symbolName) {   
   
   })("iconTT");
   //Edge symbol end:'iconTT'

   //=========================================================
   
   //Edge symbol: 'restMc'
   (function(symbolName) {   
   
   })("restMc");
   //Edge symbol end:'restMc'

   //=========================================================
   
   //Edge symbol: 'profileMc0'
   (function(symbolName) {   
   
   })("profileMc0");
   //Edge symbol end:'profileMc0'

   //=========================================================
   
   //Edge symbol: 'Down-level'
   (function(symbolName) {   
   
   })("Down-level");
   //Edge symbol end:'Down-level'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'mapMiniMc'
   (function(symbolName) {   
   
   })("mapMiniMc");
   //Edge symbol end:'mapMiniMc'

   //=========================================================
   
   //Edge symbol: 'locoMc'
   (function(symbolName) {   
   
   })("locoMc");
   //Edge symbol end:'locoMc'

   //=========================================================
   
   //Edge symbol: 'profileMc0_1'
   (function(symbolName) {   
   
      })("profileMc1");
   //Edge symbol end:'profileMc1'

   //=========================================================
   
   //Edge symbol: 'profileMc1_1'
   (function(symbolName) {   
   
      })("profileMc2");
   //Edge symbol end:'profileMc2'

   //=========================================================
   
   //Edge symbol: 'profileMc2_1'
   (function(symbolName) {   
   
      })("profileMc3");
   //Edge symbol end:'profileMc3'

   //=========================================================
   
   //Edge symbol: 'profileMc3_1'
   (function(symbolName) {   
   
      })("profileMc4");
   //Edge symbol end:'profileMc4'

   //=========================================================
   
   //Edge symbol: 'profileMc4_1'
   (function(symbolName) {   
   
         })("profileMc5");
   //Edge symbol end:'profileMc5'

   //=========================================================
   
   //Edge symbol: 'profileMc3_1'
   (function(symbolName) {   
   
         })("profileMc6");
   //Edge symbol end:'profileMc6'

   //=========================================================
   
   //Edge symbol: 'profileMc6_1'
   (function(symbolName) {   
   
         })("profileMc7");
   //Edge symbol end:'profileMc7'

   //=========================================================
   
   //Edge symbol: 'profileMc7_1'
   (function(symbolName) {   
   
         })("profileMc8");
   //Edge symbol end:'profileMc8'

   //=========================================================
   
   //Edge symbol: 'profileMc8_1'
   (function(symbolName) {   
   
         })("profileMc9");
   //Edge symbol end:'profileMc9'

   //=========================================================
   
   //Edge symbol: 'profileMc9_1'
   (function(symbolName) {   
   
         })("profileMc10");
   //Edge symbol end:'profileMc10'

   //=========================================================
   
   //Edge symbol: 'profileMc10_1'
   (function(symbolName) {   
   
         })("profileMc11");
   //Edge symbol end:'profileMc11'

   //=========================================================
   
   //Edge symbol: 'profileMc11_1'
   (function(symbolName) {   
   
         })("profileMc12");
   //Edge symbol end:'profileMc12'

   //=========================================================
   
   //Edge symbol: 'profileMc12_1'
   (function(symbolName) {   
   
         })("profileMc13");
   //Edge symbol end:'profileMc13'

   //=========================================================
   
   //Edge symbol: 'profileMc13_1'
   (function(symbolName) {   
   
         })("profileMc14");
   //Edge symbol end:'profileMc14'

   //=========================================================
   
   //Edge symbol: 'profileMc14_1'
   (function(symbolName) {   
   
         })("profileMc15");
   //Edge symbol end:'profileMc15'

   //=========================================================
   
   //Edge symbol: 'profileMc15_1'
   (function(symbolName) {   
   
         })("profileMc16");
   //Edge symbol end:'profileMc16'

   //=========================================================
   
   //Edge symbol: 'profileMc16_1'
   (function(symbolName) {   
   
         })("profileMc17");
   //Edge symbol end:'profileMc17'

   //=========================================================
   
   //Edge symbol: 'profileMc17_1'
   (function(symbolName) {   
   
         })("profileMc18");
   //Edge symbol end:'profileMc18'

   //=========================================================
   
   //Edge symbol: 'profileMc18_1'
   (function(symbolName) {   
   
         })("profileMc19");
   //Edge symbol end:'profileMc19'

   //=========================================================
   
   //Edge symbol: 'profileMc19_1'
   (function(symbolName) {   
   
         })("profileMc20");
   //Edge symbol end:'profileMc20'

   //=========================================================
   
   //Edge symbol: 'cycleMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 900, function(sym, e) {
         sym.play(50);

      });
      //Edge binding end

   })("cycleMc");
   //Edge symbol end:'cycleMc'

   //=========================================================
   
   //Edge symbol: 'cycleSide'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 500, function(sym, e) {
         sym.play(50);

      });
      //Edge binding end

   })("cycleSide");
   //Edge symbol end:'cycleSide'

   //=========================================================
   
   //Edge symbol: 'introMc'
   (function(symbolName) {   
   
   })("introMc");
   //Edge symbol end:'introMc'

   //=========================================================
   
   //Edge symbol: 'courseMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 12728, function(sym, e) {
         // insert code here
      });
      //Edge binding end

      

   })("courseMc");
   //Edge symbol end:'courseMc'

   //=========================================================
   
   //Edge symbol: 'startDot'
   (function(symbolName) {   
   
   })("startDot");
   //Edge symbol end:'startDot'

   //=========================================================
   
   //Edge symbol: 'endDot'
   (function(symbolName) {   
   
   })("endDot");
   //Edge symbol end:'endDot'

   //=========================================================
   
   //Edge symbol: 'riderDotMc'
   (function(symbolName) {   
   
   })("riderDotMc");
   //Edge symbol end:'riderDotMc'

   //=========================================================
   
   //Edge symbol: 'startEndDot_1'
   (function(symbolName) {   
   
   })("startEndDot_1");
   //Edge symbol end:'startEndDot_1'

   //=========================================================
   
   //Edge symbol: 'startEndDot'
   (function(symbolName) {   
   
   })("startEndDot");
   //Edge symbol end:'startEndDot'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32984");