/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var clicked = 0;
         	var btnNo = 0;
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         	var txtBox = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"rgba(255,255,255,1)", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(24,66,134,1)", "height":"auto","width":"auto", "padding":"6px"};
         	
         	var txt=[];
         
         	txt[0] = sym.$("txt0").css({"pointer-events":"none",});
         	txt[1] = sym.getSymbol("controllerMc").getSymbol("auxBtn0").$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.getSymbol("controllerMc").getSymbol("auxBtn1").$("txt2").css({"pointer-events":"none"});
         	for (var i=3;i<38;i++){
         		txt[i] = sym.getSymbol("textMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	txt[11] = sym.$("txt11").css({"pointer-events":"none"});
         	txt[22] = sym.$("txt22").css(txtBox);
         	txt[38] = sym.getSymbol("styleBase").$("txt38").css({"pointer-events":"none"});
         	txt[39] = sym.$("txt39").css({"pointer-events":"none"});
         	txt[40] = sym.getSymbol("courseMc").$("txt40").css(txtBox);
         	txt[41] = sym.$("txt41").css({"pointer-events":"none"});
         	txt[42] = sym.$("txt42").css({"pointer-events":"none"});
         	txt[43] = sym.$("txt43").css({"pointer-events":"none"});
         	txt[44] = sym.$("txt44").css({"pointer-events":"none"});
         	txt[45] = sym.getSymbol("textMc").$("txt45").css({"pointer-events":"none"});
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32953.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<46; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         	
         			sym.getSymbol("courseMc").$("txt40").animate({top:40 - sym.getSymbol("courseMc").$("txt40").height()-0}, 0);
         	
         	sym.getSymbol("textMc").$("txt12").empty();
         	var st1 = "<div class='captionNote'>" + txtArr[12] + "</div>" + "<div class='blackstrap'>" + txtArr[41] + "</div>" + "<div class='captionNote'>"  + txtArr[44] + "</div>"+ "<div class='blackstrap'>"  + txtArr[42] + "</div>" + "<div class='captionNote'>"  + txtArr[44] + "</div>" + "<div class='blackstrap'>"+txtArr[43] + "</div>";
         	sym.getSymbol("textMc").$("txt12").append(st1);
         	
         	$('.blackstrap').css({'float':'left', 'background-color':'rgba(255,255,255,1)', 'padding-right':'6px', "border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"rgba(170,170,170,1)", 'padding-left':'4px', 'padding-bottom':'4px', 'padding-top':'4px'});
         	$('.captionNote').css({'float':'left', 'background-color':'rgba(255,255,255,1)', 'padding-right':'5px', "border-radius":"4px", 'padding-left':'1px', 'padding-bottom':'4px', 'padding-top':'7px'});
         	
         		}
         	}); // END XML
         	
         // AUX BUTTONS --------------------------------------------	
         var clickAux = 0;
         var outAux  = {"background-color":"rgba(0,0,0,1)"};
         var overAux = {"background-color":"rgba(24,66,134,1)"};
         auxArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<2; a++){
         	auxArray.push(a);
         }
         
         function resetAux(){
         	for (var a=0; a<auxArray.length; a++){
         		sym.getSymbol("controllerMc").getSymbol("auxBtn" + a).$("bg").css(outAux);
         	}
         }
         //resetAux();
         sym.getSymbol("controllerMc").$("km").animate ({opacity:0}, 0);
         //sym.$("controllerMc").animate ({opacity:0}, 0);
         
         // AUX CLICK
         var auxBtnClick = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		clickAux = auxNo;
         		resetAux();
         		sym.getSymbol("controllerMc").getSymbol("auxBtn" + auxNo).$("bg").css(overAux);
         		if (auxNo == 0){
         			sym.getSymbol("controllerMc").$("m").animate ({opacity:1}, 0);
         			sym.getSymbol("controllerMc").$("km").animate ({opacity:0}, 0);
         			sym.$("miles").stop().animate ({opacity:1}, 0);
         			sym.$("kms").stop().animate ({opacity:0}, 0);
         		}
         		if (auxNo == 1){
         			sym.getSymbol("controllerMc").$("m").animate ({opacity:0}, 0);
         			sym.getSymbol("controllerMc").$("km").animate ({opacity:1}, 0);
         			sym.$("miles").stop().animate ({opacity:0}, 0);
         			sym.$("kms").stop().animate ({opacity:1}, 0);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // AUX OVER
         var auxBtnOver = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("controllerMc").getSymbol("auxBtn" + auxNo).$("bg").css(overAux);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // AUX OUT
         var auxBtnOut = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("controllerMc").getSymbol("auxBtn" + auxNo).$("bg").css(outAux);
         		if (clickAux == auxNo){
         			sym.getSymbol("controllerMc").getSymbol("auxBtn" + auxNo).$("bg").css(overAux);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<auxArray.length;b++){
         	sym.getSymbol("controllerMc").$("auxBtn"+b).on(clickEventType,auxBtnClick(b));
         	sym.getSymbol("controllerMc").$("auxBtn"+b).on('mouseover',auxBtnOver(b));
         	sym.getSymbol("controllerMc").$("auxBtn"+b).on('mouseout',auxBtnOut(b));
         	sym.getSymbol("controllerMc").$("auxBtn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("controllerMc").getSymbol("auxBtn0").$("bg").css(overAux);
         sym.$("kms").stop().animate ({opacity:0}, 0);
         

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         sym.getSymbol("controllerMc").$("km").text((pos / 500).toFixed(1) + "km");
         sym.getSymbol("controllerMc").$("m").text((pos / 805.5).toFixed(1) + "m");
         
         sym.getSymbol("courseMc").stop(pos);
         
         if (pos >= 21000) {
         	sym.$("kms").fadeIn(200);
         	sym.$("miles").fadeIn(200);
         	sym.getSymbol("courseMc").$("txt40").stop().animate({opacity:1}, 200);
         } else {
         	sym.$("kms").fadeOut(200);
         	sym.$("miles").fadeOut(200);
         	sym.getSymbol("courseMc").$("txt40").stop().animate({opacity:0}, 0);
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'TimelineController'
   (function(symbolName) {   
   
      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         // flag of use keyboard event.
         
         var useKeyBoardEvent = true;

         // key code of right/left key

         var KEY_RIGHT = 39;

         var KEY_LEFT =  37;

         // params

         var power = 1.5;

         var declineRate = 0.5;

         var speedWidth = 30;

         
         // try to hide the location bar at Safari,if need, comment out it. 

         // setTimeout(function() { window.scrollTo(0, 0); }, 250);

         
         var fps = 60;

         var interval = (1000/fps)|0;

         var speed = 0;

         var isKeyPress = false, isMousePress = false;

         
         var centerX,target,v;

         
         if(useKeyBoardEvent)$(window).bind("keydown",onStartControll).bind("keyup",onStopControll);  

         
         var el = $(sym.getSymbolElement());

         el.mousedown(onStartControll)

           .mouseup(onStopControll)

           .mouseout(onStopControll)

           .mousemove(onMouseMove)

           .bind("touchstart",onStartControll)

           .bind("touchmove",onMouseMove)

           .bind("touchend",onStopControll);

         
         function onStartControll(evt){
         
           evt.preventDefault();

           target = sym.getParentSymbol();

           centerX = el.offset().left+el.width()/2;

           if(evt.type=="keydown" && isKeyPress===false){

             speed = 

               (evt.which==KEY_RIGHT)*interval*power

                  + (evt.which==KEY_LEFT)*interval*-1*power;

             speed|=0;

             isKeyPress = true;
           }else if(evt.type=="mousedown" || evt.type=="touchstart"){

             isMousePress = true;
           }

           if(v===undefined)v=setInterval(onControll,interval);
         }

         function onStopControll(evt){
     
           if(evt.type=="keyup"){

             isKeyPress = false;
           }else{

             isMousePress = false;
           }
         }

         function onControll(){

           if(isKeyPress===false && isMousePress===false){

             speed = (speed*declineRate)|0;

             if(-1<speed && speed<1){

               clearInterval(v);

               v = undefined;

             }

           }

           var n = target.getPosition()+speed;

           if(-1<n && n<=target.getDuration())target.stop(n);
         }

         function onMouseMove(evt){

           evt.preventDefault();

           evt = (evt.originalEvent.touches && evt.originalEvent.touches[0]) || evt;

           if(isMousePress===true){

             speed = (((evt.clientX - centerX)/speedWidth)*power*interval)|0;

           }
         }

         

      });
      //Edge binding end

   })("TimelineController");
   //Edge symbol end:'TimelineController'

   //=========================================================
   
   //Edge symbol: 'textMc'
   (function(symbolName) {   
   
   })("textMc");
   //Edge symbol end:'textMc'

   //=========================================================
   
   //Edge symbol: 'courseMc'
   (function(symbolName) {   
   
   })("courseMc");
   //Edge symbol end:'courseMc'

   //=========================================================
   
   //Edge symbol: 'auxBtn0'
   (function(symbolName) {   
   
   })("auxBtn0");
   //Edge symbol end:'auxBtn0'

   //=========================================================
   
   //Edge symbol: 'auxBtn1'
   (function(symbolName) {   
   
   })("auxBtn1");
   //Edge symbol end:'auxBtn1'

   //=========================================================
   
   //Edge symbol: 'controllerMc'
   (function(symbolName) {   
   
   })("controllerMc");
   //Edge symbol end:'controllerMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32953");