/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var clicked = 0;
         	var btnNo = 0;
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var stand;
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         	var controlBox = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"rgba(0,0,0,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto", "width":"auto", "padding":"6px", "pointer-events":"none"};
         	
         	var startBox = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"rgba(255,255,255,1)",
         	"background-color":"#0054A5", "height":"auto", "width":"auto", "padding":"6px", "pointer-events":"none"};
         	
         	var txt=[];
         	txt[0] = sym.getSymbol("pointersMc").$("txt0").css(startBox);
         	txt[1] = sym.getSymbol("pointersMc").$("txt1").css(startBox);
         	txt[2] = sym.getSymbol("startMc").$("txt2").css(controlBox);
         	txt[3] = sym.getSymbol("txtMc").$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("txtMc").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("txtMc").$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.getSymbol("txtMc").$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.getSymbol("txtMc").$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.getSymbol("txtMc").$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.getSymbol("txtMc").$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.getSymbol("txtMc").$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.getSymbol("txtMc").$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.getSymbol("pointersMc").$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.getSymbol("txtMc").$("txt13").css({"pointer-events":"none"});
         	txt[14] = sym.getSymbol("txtMc").$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.getSymbol("pointersMc").$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.getSymbol("txtMc").$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.getSymbol("txtMc").$("txt17").css({"pointer-events":"none"});
         	txt[18] = sym.getSymbol("txtMc").$("txt18").css({"pointer-events":"none"});
         	txt[19] = sym.getSymbol("txtMc").$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.getSymbol("txtMc").$("txt20").css({"pointer-events":"none"});
         	txt[21] = sym.getSymbol("txtMc").$("txt21").css({"pointer-events":"none"});
         	txt[22] = sym.getSymbol("txtMc").$("txt22").css({"pointer-events":"none"});
         	txt[23] = sym.getSymbol("txtMc").$("txt23").css({"pointer-events":"none"});
         	txt[24] = sym.getSymbol("txtMc").$("txt24").css({"pointer-events":"none"});
         	txt[25] = sym.getSymbol("txtMc").$("txt25").css({"pointer-events":"none"});
         	txt[26] = sym.getSymbol("txtMc").$("txt26").css({"pointer-events":"none"});
         	txt[27] = sym.getSymbol("txtMc").$("txt27").css({"pointer-events":"none"});
         	txt[28] = sym.getSymbol("txtMc").$("txt28").css({"pointer-events":"none"});
         	txt[29] = sym.getSymbol("auxBtnsMc").getSymbol("auxBtn0").$("txt").css({"pointer-events":"none"});
         	txt[30] = sym.getSymbol("auxBtnsMc").getSymbol("auxBtn1").$("txt").css({"pointer-events":"none"});
         	txt[31] = sym.getSymbol("txtMc").$("t400").css({"pointer-events":"none"});
         	
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32924.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("styleHead").$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<32; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         	
         			sym.getSymbol("startMc").$("txt2").animate({top:92 - sym.getSymbol("startMc").$("txt2").height()+10}, 0);
         			sym.getSymbol("startMc").$("txt2").animate({left:100 - sym.getSymbol("startMc").$("txt2").width()/2}, 0);
         			sym.getSymbol("pointersMc").$("txt1").animate({left:586 - sym.getSymbol("pointersMc").$("txt1").width()-10}, 0);
         		}
         	}); // END XML
         	
         // AUX BUTTONS --------------------------------------------	
         var clickAux = 0;
         var outAux  = {"background-color":"rgba(0,0,0,1)"};
         var overAux = {"background-color":"rgba(218,0,0,1)"};
         auxArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<2; a++){
         	auxArray.push(a);
         }
         
         function resetAux(){
         	for (var a=0; a<auxArray.length; a++){
         		sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + a).$("bg").css(outAux);
         	}
         }
         //resetAux();
         sym.$("km").animate ({opacity:0}, 0);
         sym.$("auxBtnsMc").animate ({opacity:0}, 0);
         
         // AUX CLICK
         var auxBtnClick = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		clickAux = auxNo;
         		resetAux();
         		sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxNo).$("bg").css(overAux);
         		if (auxNo == 0){
         			sym.$("m").animate ({opacity:1}, 0);
         			sym.$("km").animate ({opacity:0}, 0);
         		}
         		if (auxNo == 1){
         			sym.$("m").animate ({opacity:0}, 0);
         			sym.$("km").animate ({opacity:1}, 0);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // AUX OVER
         var auxBtnOver = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxNo).$("bg").css(overAux);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // AUX OUT
         var auxBtnOut = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxNo).$("bg").css(outAux);
         		if (clickAux == auxNo){
         			sym.getSymbol("auxBtnsMc").getSymbol("auxBtn" + auxNo).$("bg").css(overAux);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<auxArray.length;b++){
         	sym.getSymbol("auxBtnsMc").$("auxBtn"+b).on(clickEventType,auxBtnClick(b));
         	sym.getSymbol("auxBtnsMc").$("auxBtn"+b).on('mouseover',auxBtnOver(b));
         	sym.getSymbol("auxBtnsMc").$("auxBtn"+b).on('mouseout',auxBtnOut(b));
         	sym.getSymbol("auxBtnsMc").$("auxBtn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("auxBtnsMc").getSymbol("auxBtn0").$("bg").css(overAux);

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos >= 10) {
         	sym.$("startMc").fadeOut(200);
         	sym.$("auxBtnsMc").animate ({opacity:1}, 0);
         	sym.$("km").text((pos / 200).toFixed(2) + "km");
         	sym.$("m").text((pos / 322.1).toFixed(2) + "m");
         }
         
         if (pos <= 10) {
         	sym.$("m").empty();
         	sym.$("m").text("0.00m");
         	sym.$("km").empty();
         	sym.$("km").text("0.00km");
         }

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'TimelineController'
   (function(symbolName) {   
   
      Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {
         // flag of use keyboard event.
         
         var useKeyBoardEvent = true;

         // key code of right/left key

         var KEY_RIGHT = 39;

         var KEY_LEFT =  37;

         // params

         var power = 1.5;

         var declineRate = 0.5;

         var speedWidth = 30;

         
         // try to hide the location bar at Safari,if need, comment out it. 

         // setTimeout(function() { window.scrollTo(0, 0); }, 250);

         
         var fps = 60;

         var interval = (1000/fps)|0;

         var speed = 0;

         var isKeyPress = false, isMousePress = false;

         
         var centerX,target,v;

         
         if(useKeyBoardEvent)$(window).bind("keydown",onStartControll).bind("keyup",onStopControll);  

         
         var el = $(sym.getSymbolElement());

         el.mousedown(onStartControll)

           .mouseup(onStopControll)

           .mouseout(onStopControll)

           .mousemove(onMouseMove)

           .bind("touchstart",onStartControll)

           .bind("touchmove",onMouseMove)

           .bind("touchend",onStopControll);

         
         function onStartControll(evt){
         
           evt.preventDefault();

           target = sym.getParentSymbol();

           centerX = el.offset().left+el.width()/2;

           if(evt.type=="keydown" && isKeyPress===false){

             speed = 

               (evt.which==KEY_RIGHT)*interval*power

                  + (evt.which==KEY_LEFT)*interval*-1*power;

             speed|=0;

             isKeyPress = true;
           }else if(evt.type=="mousedown" || evt.type=="touchstart"){

             isMousePress = true;
           }

           if(v===undefined)v=setInterval(onControll,interval);
         }

         function onStopControll(evt){
     
           if(evt.type=="keyup"){

             isKeyPress = false;
           }else{

             isMousePress = false;
           }
         }

         function onControll(){

           if(isKeyPress===false && isMousePress===false){

             speed = (speed*declineRate)|0;

             if(-1<speed && speed<1){

               clearInterval(v);

               v = undefined;

             }

           }

           var n = target.getPosition()+speed;

           if(-1<n && n<=target.getDuration())target.stop(n);
         }

         function onMouseMove(evt){

           evt.preventDefault();

           evt = (evt.originalEvent.touches && evt.originalEvent.touches[0]) || evt;

           if(isMousePress===true){

             speed = (((evt.clientX - centerX)/speedWidth)*power*interval)|0;

           }
         }

         

      });
      //Edge binding end

   })("TimelineController");
   //Edge symbol end:'TimelineController'

   //=========================================================
   
   //Edge symbol: 'btnsMc'
   (function(symbolName) {   
   
   })("btnsMc");
   //Edge symbol end:'btnsMc'

   //=========================================================
   
   //Edge symbol: 'btn0'
   (function(symbolName) {   
   
   })("auxBtn0");
   //Edge symbol end:'auxBtn0'

   //=========================================================
   
   //Edge symbol: 'startMc'
   (function(symbolName) {   
   
   })("startMc");
   //Edge symbol end:'startMc'

   //=========================================================
   
   //Edge symbol: 'pointersMc'
   (function(symbolName) {   
   
   })("pointersMc");
   //Edge symbol end:'pointersMc'

   //=========================================================
   
   //Edge symbol: 'auxBtn0_1'
   (function(symbolName) {   
   
   })("auxBtn1");
   //Edge symbol end:'auxBtn1'

   //=========================================================
   
   //Edge symbol: 'txtMc'
   (function(symbolName) {   
   
   })("txtMc");
   //Edge symbol end:'txtMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32924");