/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var clicked = 0;
         	var btnNo = 0;
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var stand;
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         	var txtBox1 = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"white", 
         	"color":"white", "background-color":"black", "padding":"6px", "pointer-events":"none", "height":"auto", "width":"auto"};
         
         	var txtBox2 = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"white", 
         	"color":"white", "background-color":"black", "padding":"6px", "pointer-events":"none", "height":"auto"};
         
         	var txtBox3 = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"white", 
         	"color":"black", "background-color":"#FBAE17", "padding":"6px", "pointer-events":"none", "height":"auto"};
         
         	var txtBox4 = {"border-width":"1px","border-style":"solid", "border-radius":"5px", "border-color":"black", 
         	"color":"black", "background-color":"white", "padding":"6px", "pointer-events":"none", "width":"auto", "height":"auto"};
         
         	var txt=[];
         	txt[0] = sym.getSymbol("shipMc").$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.getSymbol("shipMc").$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.getSymbol("shipMc").$("txt2").css({"height":"auto", "pointer-events":"none"});
         	txt[3] = sym.getSymbol("shipMc").getSymbol("shipPointMc").$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("shipMc").getSymbol("shipPointMc").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("shipMc").getSymbol("shipPointMc").$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.getSymbol("shipMc").getSymbol("shipPointMc").$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.getSymbol("shipMc").getSymbol("shipPointMc").$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.getSymbol("shipMc").getSymbol("shipPointMc").$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.getSymbol("shipMc").getSymbol("shipPointMc").$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.getSymbol("shipMc").getSymbol("shipPointMc").$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.getSymbol("shipMc").getSymbol("shipPointMc").$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.getSymbol("shipMc").getSymbol("shipPointMc").$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.getSymbol("shipMc").getSymbol("shipPointMc").$("txt13").css({"pointer-events":"none"});
         	txt[14] = sym.getSymbol("shipMc").getSymbol("shipPointMc").$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.getSymbol("mapMc").$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.getSymbol("mapMc").$("txt16").css(txtBox1);
         	txt[17] = sym.getSymbol("mapMc").$("txt17").css({"pointer-events":"none"});
         	txt[18] = sym.getSymbol("mapMc").$("txt18").css(txtBox1);
         	txt[19] = sym.getSymbol("mapMc").$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.getSymbol("mapMc").$("txt20").css({"pointer-events":"none"});
         	txt[21] = sym.getSymbol("mapMc").$("txt21").css({"pointer-events":"none"});
         	txt[22] = sym.getSymbol("mapMc").$("txt22").css({"pointer-events":"none"});
         	txt[23] = sym.getSymbol("mapMc").$("txt23").css({"pointer-events":"none"});
         	txt[24] = sym.getSymbol("mapMc").getSymbol("locoMc").$("txt24").css({"pointer-events":"none"});
         	txt[25] = sym.getSymbol("mapMc").$("txt25").css(txtBox2);
         	txt[26] = sym.getSymbol("mapMc").getSymbol("zoomTxtMc").$("txt26").css(txtBox2);
         	txt[27] = sym.getSymbol("mapMc").getSymbol("zoomTxtMc").$("txt27").css(txtBox2);
         	txt[28] = sym.getSymbol("mapMc").getSymbol("zoomTxtMc").$("txt28").css(txtBox2);
         	txt[29] = sym.getSymbol("mapMc").getSymbol("zoomTxtMc").$("txt29").css(txtBox3);
         	txt[30] = sym.getSymbol("mapMc").getSymbol("zoomTxtMc").$("txt30").css({"pointer-events":"none"});
         	txt[31] = sym.getSymbol("mapMc").getSymbol("zoomTxtMc").$("txt31").css({"pointer-events":"none"});
         	txt[32] = sym.getSymbol("mapMc").getSymbol("zoomTxtMc").$("txt32").css({"pointer-events":"none"});
         	txt[33] = sym.getSymbol("mapMc").getSymbol("zoomTxtMc").$("txt33").css(txtBox4);
         	txt[34] = sym.$("txt34").css({"pointer-events":"none"});
         	txt[35] = sym.$("txt35").css({"pointer-events":"none"});
         
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32920.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("styleHead").$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<34; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         
         			//sym.getSymbol("SYMBOL").$("txt").animate({top:yNUMBER - sym.getSymbol("SYMBOL").$("txt").height()+10}, 200);
         			sym.getSymbol("shipMc").$("txt2").animate({top:570 - sym.getSymbol("shipMc").$("txt2").height()+6}, 0);
         			sym.getSymbol("mapMc").$("txt16").animate({left:290 - sym.getSymbol("mapMc").$("txt16").width()/2}, 0);
         			sym.getSymbol("mapMc").$("txt16").animate({top:170 - sym.getSymbol("mapMc").$("txt16").height()+6}, 0);
         			sym.getSymbol("mapMc").$("txt25").animate({top:566 - sym.getSymbol("mapMc").$("txt25").height()+0}, 0);
         
         			sym.getSymbol("mapMc").$("locoMc").animate({top:390 - sym.getSymbol("mapMc").$("txt25").height()+0}, 0);
         
         			sym.getSymbol("mapMc").getSymbol("zoomTxtMc").$("txt28").animate({top:425 - sym.getSymbol("mapMc").getSymbol("zoomTxtMc").$("txt28").height()+0}, 0);
         
         		}
         	}); // END XML
         
         
         // SET THE SCENE
         sym.$("mapMc").stop().animate({opacity:0}, 0);
         sym.getSymbol("shipMc").$("shipInt").stop().animate({opacity:0}, 0);
         sym.getSymbol("shipMc").$("shipPointMc").stop().animate({opacity:0}, 0);
         sym.getSymbol("menuBtn").$("btnReplay").stop().animate({opacity:0}, 0);
         
         sym.getSymbol("shipMc").$("shipInt").stop().delay(1000).animate({opacity:1}, 1000);
         sym.getSymbol("shipMc").$("shipPointMc").stop().delay(2000).animate({opacity:1}, 1000);
         sym.$("menuBtn").stop().delay(4500).animate({left:760}, 500, 'easeOutCubic');
         
         // BUTTONS COUNT
         sym.$("menuBtn").on(clickEventType, function(e){
         	e.stopPropagation(); e.preventDefault();
         	clicked++;
         	btnClick();
         	});
         sym.$("menuBtn").mouseover(function(){
         	sym.getSymbol("menuBtn").$("bg").stop().animate({opacity:0.7}, 0);
         	});
         sym.$("menuBtn").mouseout(function(){
         	sym.getSymbol("menuBtn").$("bg").stop().animate({opacity:1}, 0);
         	});
         
         // START CLICK FUNCTION
         function btnClick(){
         	sym.$("menuBtn").stop().animate({left:800}, 0);
         
         	if (clicked == 0) {
         		sym.getSymbol("menuBtn").$("btnReplay").stop().animate({opacity:0}, 0);
         		sym.getSymbol("menuBtn").$("arrow").stop().animate({opacity:1}, 0);
         		sym.$("mapMc").stop().animate({opacity:0}, 500);
         		sym.$("shipMc").stop().animate({opacity:1}, 500);
         		sym.$("menuBtn").stop().delay(1000).animate({left:760}, 500, 'easeOutCubic');
         	}
         	if (clicked == 1) {
         		sym.$("mapMc").stop().animate({opacity:1}, 500);
         		sym.getSymbol("mapMc").play(1);
         		sym.$("menuBtn").stop().delay(4500).animate({left:760}, 500, 'easeOutCubic');
         	}
         	if (clicked == 2) {
         		sym.getSymbol("mapMc").play();
         		sym.$("menuBtn").stop().delay(4500).animate({left:760}, 500, 'easeOutCubic');
         		sym.getSymbol("menuBtn").$("btnReplay").stop().animate({opacity:1}, 0);
         		sym.getSymbol("menuBtn").$("arrow").stop().animate({opacity:0}, 0);
         		clicked = -1;
         		//btnClick();
         	}
         } // END CLICK FUNCTION

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'shipMc'
   (function(symbolName) {   
   
   })("shipMc");
   //Edge symbol end:'shipMc'

   //=========================================================
   
   //Edge symbol: 'shipPointMc'
   (function(symbolName) {   
   
   })("shipPointMc");
   //Edge symbol end:'shipPointMc'

   //=========================================================
   
   //Edge symbol: 'mapMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 3500, function(sym, e) {
         sym.stop();

      });
      //Edge binding end

   })("mapMc");
   //Edge symbol end:'mapMc'

   //=========================================================
   
   //Edge symbol: 'dotMc'
   (function(symbolName) {   
   
   })("dotMc1");
   //Edge symbol end:'dotMc1'

   //=========================================================
   
   //Edge symbol: 'dotMc1_1'
   (function(symbolName) {   
   
   })("dotMc2");
   //Edge symbol end:'dotMc2'

   //=========================================================
   
   //Edge symbol: 'dotMc1_2'
   (function(symbolName) {   
   
   })("dotMc3");
   //Edge symbol end:'dotMc3'

   //=========================================================
   
   //Edge symbol: 'dotMc1_3'
   (function(symbolName) {   
   
   })("dotMc4");
   //Edge symbol end:'dotMc4'

   //=========================================================
   
   //Edge symbol: 'dotMc4_1'
   (function(symbolName) {   
   
   })("dotMc5");
   //Edge symbol end:'dotMc5'

   //=========================================================
   
   //Edge symbol: 'locoMc'
   (function(symbolName) {   
   
   })("locoMc");
   //Edge symbol end:'locoMc'

   //=========================================================
   
   //Edge symbol: 'zoomTxtMc'
   (function(symbolName) {   
   
   })("zoomTxtMc");
   //Edge symbol end:'zoomTxtMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32920");