/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var clicked = 0;
         	var btnNo = 0;
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var stand;
         	var standtxt = sym.$("standTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         	var txtBox = {"background-color":"rgba(0,0,0,0.8)", "height":"auto", "padding":"4px", "border-width":"1px","border-style":"solid","border-color":"rgba(0,0,0,1)", "border-radius":"4px", "pointer-events":"none"};
         	var outBtn  = {"background-color":"rgba(255,255,255,0.2)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         	
         	var txt=[];
         	txt[0] = sym.$("txt1").css({"pointer-events":"none"});
         	txt[1] = sym.$("txt2").css(txtBox);
         	txt[2] = sym.$("txt4").css(txtBox);
         	
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32911.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.$("headlineTxt").css("font-size",headSize);
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	//create table
         			var newTable="<div id='newTab'>";
         			var dataTab1;
         			newTable+="<div id='newtab1'>";
         			$(xml).find('table1').each(function() {
         				var strap=$(this).find('strap').text();
         				newTable+="<div class='redstrap'>"+strap+"</div>";
         				newTable+="<table class='events'>";
         				$(this).find('number1').each(function() {
         					dataTab1 = $(this).find("date1").text();
         					newTable+="<tr><td>"+dataTab1+"</td></tr>";
         				});
         				newTable+="</table>";
         			});
         			newTable+="</div>";
         			newTable+="<div id='newtab2'>";
         			$(xml).find('table2').each(function() {
         				var strap=$(this).find('strap').text();
         				newTable+="<div class='redstrap'>"+strap+"</div>";
         				newTable+="<table class='events'>";
         				$(this).find('number2').each(function() {
         					dataTab2 = $(this).find("date2").text();
         					newTable+="<tr><td>"+dataTab2+"</td></tr>";
         				});
         				newTable+="</table>";
         			});			
         			newTable+="</div>";
         			newTable+="</div>";
         		sym.$("tableMc").append(newTable);
         		//apply styles
         		$("#newTab").css({"font-family":"Pragmatica-web, sans-serif"});
         		$(".events").css({"text-align":"left","color":"#000000","font-size":"13px","line-height":"15px",'border':0,'border-collapse':'collapse'});
         		$("#newtab1 tr:odd").css({"background-color":"#DFDBCF"});
         		$("#newtab1 tr:even").css({"background-color":"#E7E5E0"});
         		$("#newtab2 tr:odd").css({"background-color":"#cccccc"});
         		$("#newtab2 tr:even").css({"background-color":"#dddddd"});
         		$('.events td').css({'padding':'9px'});
         		$(".redstrap").css({'font-weight':700,'color':'rgb(255,255,255)','width':'100%','background-color':'rgb(218,0,0)','padding':'4px 9px'});
         		sym.$("tableMc").css({'overflow-y':'scroll'});
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<5; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         	
         		}
         	}); // END XML
         	
         function timelineScroll(){
         // Map scroll position to timeline position
         var tabHeight = $("#newTab").height();
         var tableHeight = sym.$("tableMc").height();
         var scrollPos = sym.$("tableMc").scrollTop();
         var duration = sym.getDuration();
         var percent = scrollPos / (tabHeight - tableHeight);
         var time = duration * percent;
         sym.stop(time);
         sym.$("scrollDown").fadeOut(50);
         }	
         sym.$("tableMc").on('scroll',timelineScroll);	

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         /*
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         
         */

      });
      //Edge binding end

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'tableMc'
   (function(symbolName) {   
   
   })("tableMc");
   //Edge symbol end:'tableMc'

   //=========================================================
   
   //Edge symbol: 'table1Mc'
   (function(symbolName) {   
   
   })("table1Mc");
   //Edge symbol end:'table1Mc'

   //=========================================================
   
   //Edge symbol: 'table1Mc_1'
   (function(symbolName) {   
   
   })("table2Mc");
   //Edge symbol end:'table2Mc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNews32911");