/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var clicked = 0;
         	var btnNo = 0;
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         sym.getSymbol("rowerMc").getSymbol("rowMan0").$("rowHead").attr("src", "images/rowerBrown.png");
         sym.getSymbol("rowerMc").getSymbol("rowMan3").$("rowHead").attr("src", "images/rowerWhite.png");
         sym.getSymbol("rowerMc").getSymbol("rowMan5").$("rowHead").attr("src", "images/rowerBrown.png");
         sym.getSymbol("rowerMc").getSymbol("rowMan7").$("rowHead").attr("src", "images/rowerWhite.png");
         
         var noArray = ["C","S","7","6","5","4","3","2","B"];
         for (var i = 0; i < 9; i++){
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+i).$("txt").html(noArray[i]);
         }
         
         	var txtBox = {"border-width":"2px","border-style":"solid", "border-radius":"5px", "border-color":"rgba(255,255,255,1)", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(80,80,80,1)", "height":"auto","width":"auto", "padding":"6px", "padding-top":"50px", "pointer-events":"none"};
         	var txtBox2 = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.8)", "height":"auto","width":"auto", "padding":"6px", "padding-left":"30px", "pointer-events":"none"};
         	var txtBox3 = {"border-width":"2px","border-style":"solid", "border-radius":"5px", "border-color":"rgba(255,255,255,1)", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(80,80,80,1)", "height":"auto","width":"auto", "padding":"6px", "pointer-events":"none"};
         
         	var txtBox4 = {"font-size":"50px"};
         
         
         	var outBtn  = {"background-color":"rgba(0,0,0,0.4)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         
         	var txt=[];
         	txt[0] = sym.$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.getSymbol("txtMc").$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.getSymbol("txtMc").$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.getSymbol("txtMc").$("txt3").css(txtBox);
         	txt[4] = sym.getSymbol("txtMc").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("txtMc").$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.getSymbol("routeMc").$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.getSymbol("routeMc").$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.getSymbol("txtMc").$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.getSymbol("txtMc").$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.getSymbol("txtMc").$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.getSymbol("txtMc").$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.getSymbol("txtMc").$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.getSymbol("txtMc").$("txt13").css({"pointer-events":"none"});
         	txt[14] = sym.getSymbol("txtMc").$("txt14").css(txtBox2);
         	txt[15] = sym.$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.getSymbol("txtMc").$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.getSymbol("txtMc").$("txt17").css({"pointer-events":"none"});
         	txt[18] = sym.getSymbol("routeMc").$("txt18").css({"pointer-events":"none"});
         	txt[19] = sym.getSymbol("routeMc").$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.getSymbol("routeMc").$("txt20").css({"pointer-events":"none"});
         	txt[21] = sym.getSymbol("routeMc").$("txt21").css(txtBox3);
         	txt[22] = sym.getSymbol("txtMc").$("txt22").css({"pointer-events":"none"});
         	txt[23] = sym.getSymbol("txtMc").$("txt23").css({"pointer-events":"none"});
         	txt[24] = sym.getSymbol("txtMc").$("txt24").css({"pointer-events":"none"});
         	txt[25] = sym.getSymbol("txtMc").$("txt25").css({"pointer-events":"none"});
         	txt[26] = sym.$("txt26").css({"pointer-events":"none"});
         	txt[27] = sym.getSymbol("txtMc").$("txt27").css({"pointer-events":"none"});
         	txt[28] = sym.$("txt28").css({"pointer-events":"none"});
         	txt[29] = sym.$("txt29").css({"pointer-events":"none"});
         	txt[30] = sym.$("txt30").css({"pointer-events":"none"});
         	txt[31] = sym.$("txt31").css({"pointer-events":"none"});
         	txt[32] = sym.$("txt32").css({"pointer-events":"none"});
         	txt[33] = sym.$("txt33").css({"pointer-events":"none"});
         	txt[34] = sym.$("txt34").css({"pointer-events":"none"});
         	txt[35] = sym.$("txt35").css({"pointer-events":"none"});
         	txt[36] = sym.getSymbol("txtMc").$("txt36").css({"pointer-events":"none"});
         	txt[37] = sym.getSymbol("txtMc").$("txt37").css({"pointer-events":"none"});
         	txt[38] = sym.getSymbol("txtMc").$("txt38").css({"pointer-events":"none"});
         	txt[39] = sym.getSymbol("txtMc").$("txt39").css({"pointer-events":"none"});
         	txt[40] = sym.getSymbol("txtMc").$("txt40").css({"pointer-events":"none"});
         	txt[41] = sym.$("txt41").css({"pointer-events":"none"});
         	txt[42] = sym.$("txt42").css({"pointer-events":"none"});
         	txt[43] = sym.$("txt43").css({"pointer-events":"none"});
         	txt[44] = sym.$("txt44").css({"pointer-events":"none"});
         	txt[45] = sym.$("txt45").css({"pointer-events":"none"});
         	txt[46] = sym.$("txt46").css({"pointer-events":"none"});
         	txt[47] = sym.$("txt47").css({"pointer-events":"none"});
         	txt[48] = sym.$("txt48").css({"pointer-events":"none"});
         	txt[49] = sym.getSymbol("txtMc").$("txt49").css({"pointer-events":"none"});
         	txt[50] = sym.$("txt50").css({"pointer-events":"none"});
         
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32902.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<51; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         			sym.getSymbol("routeMc").$("txt18").animate({left:0 + sym.getSymbol("routeMc").$("txt21").width()+20}, 0);
         			sym.getSymbol("txtMc").$("txt3").animate({left:552 - sym.getSymbol("txtMc").$("txt3").width()/2}, 0);
         
         			sym.getSymbol("txtMc").$("txt24").css(txtBox4);
         			sym.getSymbol("txtMc").$("txt38").css(txtBox4);
         
         		}
         	}); // END XML
         
         // MENU BUTTONS --------------------------------------------	
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<9; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(outBtn);
         	}
         }
         resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         
         		sym.getSymbol("txtMc").$("txt27").empty();
         		sym.getSymbol("txtMc").$("txt27").append(txtArr[menuNo + 27]);
         		sym.getSymbol("txtMc").$("txt40").empty();
         		sym.getSymbol("txtMc").$("txt40").append(txtArr[menuNo + 40]);
         
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OVER
         var menuBtnOver = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OUT
         var menuBtnOut = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(outBtn);
         		if (clicked == menuNo){
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on(clickEventType,menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseover',menuBtnOver(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseout',menuBtnOut(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(overBtn);
         
         // BUTTONS COUNT
         sym.getSymbol("txtMc").$("btnPlay").on(clickEventType, function(e){
         	sym.getSymbol("routeMc").play(0);
         	e.stopPropagation(); e.preventDefault();
         	});
         sym.getSymbol("txtMc").$("btnPlay").mouseover(function(){
         	sym.getSymbol("txtMc").$("btnPlay").stop().animate ({opacity:0.5}, 0);
         	e.stopPropagation(); e.preventDefault();
         	});
         sym.getSymbol("txtMc").$("btnPlay").mouseout(function(){
         	sym.getSymbol("txtMc").$("btnPlay").stop().animate ({opacity:1}, 0);
         	e.stopPropagation(); e.preventDefault();
         	});

      });
      //Edge binding end

      

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'routeMc'
   (function(symbolName) {   
   
   })("routeMc");
   //Edge symbol end:'routeMc'

   //=========================================================
   
   //Edge symbol: 'rowerMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.play();

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2001, function(sym, e) {
         // play the timeline from the given position (ms or label)
         sym.play(0);

      });
      //Edge binding end

   })("rowerMc");
   //Edge symbol end:'rowerMc'

   //=========================================================
   
   //Edge symbol: 'styleMc'
   (function(symbolName) {   
   
   })("styleMc");
   //Edge symbol end:'styleMc'

   //=========================================================
   
   //Edge symbol: 'txtMc'
   (function(symbolName) {   
   
   })("txtMc");
   //Edge symbol end:'txtMc'

   //=========================================================
   
   //Edge symbol: 'rowMan0'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 2001, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("rowMan0");
   //Edge symbol end:'rowMan0'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32902");