/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "click" : "click");
         	var clicked = 0;
         	var btnNo = 0;
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var stand;
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         var txtBox = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"#FFC10E", "height":"auto", "padding":"6px", "pointer-events":"none"};
         
         var txtBoxWhite = {"border-width":"0px","border-style":"solid", "border-radius":"5px", "color":"rgba(0,0,0,1)",
         	"background-color":"rgba(255,255,255,0.9)", "height":"auto", "padding":"6px", "pointer-events":"none"};
         
         
         	var outBtn  = {"background-color":"rgba(255,255,255,0.2)"};
         	var overBtn = {"background-color":"rgba(218,0,0,.5)"};
         
         	var txt=[];
         	txt[0] = sym.getSymbol("cockPitMc").getSymbol("cockTxtMc").$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.getSymbol("cockPitMc").getSymbol("cockTxtMc").$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.getSymbol("cockPitMc").getSymbol("cockTxtMc").$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.getSymbol("cockPitMc").getSymbol("cockTxtMc").$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("cockPitMc").getSymbol("cockTxtMc").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("cockPitMc").getSymbol("cockTxtMc").$("txt5").css(txtBox);
         	txt[6] = sym.getSymbol("cockPitMc").getSymbol("cockTxtMc").$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.getSymbol("cockPitMc").getSymbol("cockTxtMc").$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.getSymbol("cockPitMc").getSymbol("cockTxtMc").$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.getSymbol("cockPitMc").getSymbol("cockTxtMc").$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.getSymbol("cockPitMc").getSymbol("cockTxtMc").$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.getSymbol("cockPitMc").getSymbol("cockTxtMc").$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.getSymbol("boxMc").getSymbol("boxTxtMc").$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.getSymbol("boxMc").getSymbol("boxTxtMc").$("txt13").css({"pointer-events":"none"});
         	txt[14] = sym.getSymbol("boxMc").getSymbol("boxTxtMc").$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.getSymbol("boxMc").getSymbol("boxTxtMc").$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.getSymbol("boxMc").getSymbol("boxTxtMc").$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.getSymbol("boxMc").getSymbol("boxTxtMc").$("txt17").css(txtBoxWhite);
         	txt[18] = sym.getSymbol("boxMc").getSymbol("boxTxtMc").$("txt18").css({"pointer-events":"none"});
         	txt[19] = sym.getSymbol("boxMc").getSymbol("boxTxtMc").$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.getSymbol("boxMc").getSymbol("boxTxtMc").$("txt20").css({"pointer-events":"none"});
         	txt[21] = sym.$("txt21").css(txtBoxWhite);
         	txt[22] = sym.$("txt22").css({"pointer-events":"none"});
         
         	var txtArr=[];
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32889.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("styleHead").$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<23; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         
         			sym.getSymbol("cockPitMc").getSymbol("cockTxtMc").$("txt5").animate({top:565 - sym.getSymbol("cockPitMc").getSymbol("cockTxtMc").$("txt5").height()-0}, 0);
         
         		}
         	}); // END XML
         
         // MENU BUTTONS --------------------------------------------	
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<2; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtn" + h).$("bg").css(outBtn);
         	}
         }
         //resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		resetmenu();
         		sym.getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		if (menuNo == 0){
         			if(clicked!=menuNo){
         				cockIn();
         				boxOut();
         			}
         		}
         		if (menuNo == 1){
         			if(clicked!=menuNo){
         				sym.getSymbol("menuBtn1").stop(0);
         				cockOut();
         				boxIn();				
         			}
         		}
         		clicked = menuNo;
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OVER
         var menuBtnOver = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OUT
         var menuBtnOut = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtn" + menuNo).$("bg").css(outBtn);
         		if (clicked == menuNo){
         			sym.getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<menuArray.length;b++){
         	sym.$("menuBtn"+b).on(clickEventType,menuBtnClick(b));
         	sym.$("menuBtn"+b).on('mouseover',menuBtnOver(b));
         	sym.$("menuBtn"+b).on('mouseout',menuBtnOut(b));
         	sym.$("menuBtn"+b).css({'cursor':'pointer'});
         }
         	sym.getSymbol("menuBtn0").$("bg").css(overBtn);
         
         sym.getSymbol("menuBtn0").stop(0);
         sym.getSymbol("cockPitMc").$("cockTxtMc").animate ({opacity:0}, 0);
         sym.$("boxMc").stop().animate ({opacity:0}, 0);
         sym.$("txt21").stop().animate ({opacity:0}, 0);
         sym.$("txt22").stop().delay(0).animate ({opacity:0}, 0);
         sym.$("txt22").stop().delay(1500).animate ({opacity:1}, 200);
         
         sym.$("planeInt").stop().delay(0).animate ({left:541, top:16}, 1500, 'easeOutCubic');
         sym.$("menuBtn0").stop().delay(0).animate ({left:532, top:7}, 1500, 'easeOutCubic');
         sym.$("menuBtn1").stop().delay(0).animate ({left:708, top:152}, 1500, 'easeOutCubic');
         
         function cockIn(){
         	sym.getSymbol("cockPitMc").$("door").stop().delay(0).animate ({left:0}, 700, 'easeOutCubic');
         	sym.getSymbol("cockPitMc").$("nose").stop().delay(0).animate ({top:0}, 700, 'easeOutCubic');
         	sym.getSymbol("cockPitMc").$("switch").stop().delay(0).animate ({opacity:1}, 500);
         	sym.getSymbol("cockPitMc").$("cockpitPic").stop().delay(0).animate ({left:0}, 700, 'easeOutCubic', function(){
         			sym.getSymbol("cockPitMc").$("cockTxtMc").animate ({opacity:1}, 400);
         	});
         }
         cockIn();
         
         function cockOut(){
         	sym.getSymbol("cockPitMc").$("cockTxtMc").stop().animate ({opacity:0}, 0);
         	sym.getSymbol("cockPitMc").$("door").stop().delay(0).animate ({left:-800}, 700, 'easeOutCubic');
         	sym.getSymbol("cockPitMc").$("nose").stop().delay(0).animate ({top:600}, 700, 'easeOutCubic');
         	sym.getSymbol("cockPitMc").$("cockpitPic").stop().delay(0).animate ({left:800}, 400, 'easeOutCubic');
         	sym.getSymbol("cockPitMc").$("switch").stop().delay(0).animate ({opacity:0}, 200, function(){
         	});
         }
         
         function boxIn(){
         	sym.getSymbol("boxMc").$("boxes").stop().delay(0).animate ({left:400, top:300, width:0, height:0}, 0);
         	sym.getSymbol("boxMc").$("boxBg").stop().animate ({opacity:0}, 0);
         	sym.getSymbol("boxMc").$("boxOver").stop().animate ({opacity:0}, 0);
         	sym.getSymbol("boxMc").$("boxTxtMc").stop().animate ({opacity:0}, 0);
         	sym.$("boxMc").stop().animate ({opacity:1}, 0);
         	sym.getSymbol("boxMc").$("boxBg").stop().animate ({opacity:1}, 500);
         	sym.getSymbol("boxMc").$("boxes").stop().delay(0).animate ({left:0, top:0, width:800, height:600}, 500, 'easeOutCubic', function(){
         		sym.getSymbol("boxMc").$("boxOver").stop().animate ({opacity:1}, 500, function(){
         		sym.getSymbol("boxMc").$("boxTxtMc").stop().animate ({opacity:1}, 500);
         		sym.$("txt21").stop().animate ({opacity:1}, 200);
         		});
         	});
         }
         function boxOut(){
         	sym.$("txt21").stop().animate ({opacity:0}, 0);
         	sym.getSymbol("boxMc").$("boxTxtMc").stop().animate ({opacity:0}, 0);
         	sym.getSymbol("boxMc").$("boxOver").stop().animate ({opacity:0}, 200);
         	sym.getSymbol("boxMc").$("boxBg").stop().animate ({opacity:0}, 500);
         	sym.getSymbol("boxMc").$("boxes").stop().delay(0).animate ({left:400, top:300, width:0, height:0}, 500, 'easeOutCubic', function(){
         		sym.$("boxMc").stop().animate ({opacity:0}, 0);
         	});
         }

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 1500, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'cockPitMc'
   (function(symbolName) {   
   
   })("cockPitMc");
   //Edge symbol end:'cockPitMc'

   //=========================================================
   
   //Edge symbol: 'cockTxtMc'
   (function(symbolName) {   
   
   })("cockTxtMc");
   //Edge symbol end:'cockTxtMc'

   //=========================================================
   
   //Edge symbol: 'boxMc'
   (function(symbolName) {   
   
   })("boxMc");
   //Edge symbol end:'boxMc'

   //=========================================================
   
   //Edge symbol: 'boxTxtMc'
   (function(symbolName) {   
   
   })("boxTxtMc");
   //Edge symbol end:'boxTxtMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GNews32889");