/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var stand;
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         	var txt=[];
         	txt[0] = sym.getSymbol("pointerMc").$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.getSymbol("pointerMc").$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.getSymbol("pointerMc").$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.getSymbol("pointerMc").$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("pointerMc").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("pointerMc").$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.getSymbol("pointerMc").$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.getSymbol("mapTxtMc").$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.getSymbol("mapTxtMc").$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.getSymbol("mapTxtMc").$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.getSymbol("mapTxtMc").$("txt13").css({"pointer-events":"none"});
         	txt[14] = sym.getSymbol("mapTxtMc").$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.getSymbol("mapTxtMc").$("txt15").css({"pointer-events":"none"});
         	txt[16] = sym.getSymbol("mapTxtMc").$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.getSymbol("mapTxtMc").$("txt17").css({"pointer-events":"none"});
         	txt[18] = sym.getSymbol("mapTxtMc").$("txt18").css({"pointer-events":"none"});
         	txt[19] = sym.getSymbol("mapTxtMc").$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.getSymbol("mapTxtMc").$("txt20").css({"pointer-events":"none"});
         	txt[21] = sym.getSymbol("mapTxtMc").$("txt21").css({"pointer-events":"none"});
         	
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32885.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("styleHead").$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<22; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         		}
         	}); // END XML
         	
         function droneReset(){
         	sym.$("toggleBtn").fadeOut(0);
         	sym.$("toggleBtn").stop().animate ({left:800}, 0);
         	sym.$("crate").stop().delay(0).animate ({opacity:1, top:-569}, 0);
         	sym.$("pointerMc").stop().delay(0).animate ({opacity:0}, 0);
         	sym.$("miniDrone").stop().delay(0).animate ({top:-363}, 0);
         	sym.$("miniCrate").stop().delay(0).animate ({opacity:1, top:-314}, 0);
         	sym.$("droneMc").stop().delay(0).animate ({top:-530}, 0);
         	sym.$("shadow").stop().delay(0).animate ({opacity:0, left:-400, top:600, width:2200, height:1200}, 0);
         	droneIn();
         }
         droneReset();
         
         function droneIn(){
         	txt[9].stop().delay(0).animate ({opacity:0}, 50, 'easeOutCubic');
         	sym.$("miniDrone").stop().delay(0).animate ({top:137}, 2000, 'easeOutCubic');
         	sym.$("miniCrate").stop().delay(0).animate ({opacity:1, top:186}, 2000, 'easeOutCubic');
         	sym.$("droneMc").stop().delay(0).animate ({top:0}, 2000, 'easeOutCubic');
         	sym.$("crate").stop().delay(0).animate ({opacity:1, top:-39}, 2000, 'easeOutCubic');
         	sym.$("shadow").stop().delay(0).animate ({opacity:1, left:0, top:0, width:800, height:600}, 2000, 'easeOutCubic', function(){
         		sym.$("pointerMc").stop().delay(0).animate ({opacity:1}, 500); 
         		sym.$("toggleBtn").fadeIn(0);
         		sym.$("toggleBtn").stop().animate ({left:720}, 500, 'easeOutBounce');
         	});
         }
         
         // TOGGLE BUTTON
         sym.$("toggleBtn").on(clickEventType, function(e){
         		droneDown();
         		e.stopPropagation(); e.preventDefault();
         }); 
         sym.$("toggleBtn").mouseover(function(){
         	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0.3}, 200);
         });
         sym.$("toggleBtn").mouseout(function(){
         	sym.getSymbol("toggleBtn").$("btnOver").stop().animate ({opacity:0}, 200);
         });
         
         function droneDown(){
         		sym.$("toggleBtn").fadeOut(0);
         		sym.$("pointerMc").stop().delay(0).animate ({opacity:0}, 50);
         		txt[8].stop().delay(2000).animate ({opacity:1}, 50);
         		sym.$("miniCrate").stop().delay(0).animate ({top:217}, 2000, 'easeOutBounce');
         		sym.$("miniDrone").stop().delay(0).animate ({top:168}, 2000, 'easeOutBounce');
         		sym.$("crate").stop().delay(0).animate ({top:-19}, 2000, 'easeOutBounce');
         		sym.$("shadow").stop().delay(0).animate ({opacity:1, left:0, top:-10}, 2000, 'easeOutCubic');
         		sym.$("droneMc").stop().delay(0).animate ({top:30}, 2000, 'easeOutBounce', function(){ 
         			sym.$("crate").stop().delay(0).animate ({top:21}, 500, 'easeOutBounce');
         			sym.$("miniCrate").stop().delay(0).animate ({top:236}, 500, 'easeOutBounce', function(){
         			droneUp()
         			});
         		});
         }
         function droneUp(){
         		txt[8].stop().delay(1000).animate ({opacity:0}, 50, 'easeOutCubic');
         		txt[9].stop().delay(1000).animate ({opacity:1}, 50, 'easeOutCubic');
         		sym.$("miniDrone").stop().delay(500).animate ({top:-363}, 2000, 'easeOutCubic');
         		sym.$("droneMc").stop().delay(500).animate ({top:-830}, 2000, 'easeOutCubic');
         		sym.$("shadow").stop().delay(500).animate ({opacity:0, left:-400, top:600, width:2200, height:1200}, 1500, 'easeOutCubic', function(){
         			sym.$("miniCrate").stop().animate ({opacity:0}, 200);
         			sym.$("crate").stop().animate ({opacity:0}, 200, function(){
         				droneReset();
         			});
         		});
         }

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'rotorMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 100, function(sym, e) {
         sym.play(0);

      });
      //Edge binding end

   })("rotorMc");
   //Edge symbol end:'rotorMc'

   //=========================================================
   
   //Edge symbol: 'droneMc'
   (function(symbolName) {   
   
   })("droneMc");
   //Edge symbol end:'droneMc'

   //=========================================================
   
   //Edge symbol: 'pointerMc'
   (function(symbolName) {   
   
   })("pointerMc");
   //Edge symbol end:'pointerMc'

   //=========================================================
   
   //Edge symbol: 'mapTxtMc'
   (function(symbolName) {   
   
   })("mapTxtMc");
   //Edge symbol end:'mapTxtMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32885");