/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         var gn=32877;
         var dataURL = ('http:'==document.location.protocol?"http://www2.graphicnews.com/":"https://www.graphicnews.org/")+ "data/api.php";
         var pollsOpen = Date.parse("May 7, 2015, 05:59 UTC");
         var pollsClose = Date.parse("May 7, 2015, 20:59 UTC");
         var oneDay = 86400000;
         var todayDate;
         var status=1;
         function getDate(){
         	todayDate = new Date();
         	if(todayDate<pollsOpen-oneDay){
         		if(todayDate<pollsOpen){
         			status=0;
         		}else{
         			status=1;
         		}
         	}else if(todayDate>pollsClose){
         		status=2;
         	}
         }
         getDate();
         var headlines=[];var txt=[];var partyArr=[];var partyShortArr=[];
         //AJAX retrieves data, captions from xml source
         $.ajax({	
         	type: "GET",
         	url: "GN"+gn+".xml",
         	dataType: "xml",
         	success: function(xml) {
         		for (var h=0;h<4;h++){
         		headlines[h]=$(xml).find('headline'+h).text();
         		}
         		var headline=headlines[status];
         		var source=$(xml).find('source').text();
         		sym.getSymbol('styleHead').$('headlinetxt').html(headline);
         		sym.getSymbol('styleBase').$('sourceTxt').html(source);
         		for (var i=0;i<13;i++){
         			txt[i]=$(xml).find('txt'+i).text();
         		}
         		sym.$('text0').html(txt[0]).css({'pointer-events':'none'});
         		var partytxt=$(xml).find('parties').text();
         		partyArr=partytxt.split(';');
         		var partyShort=$(xml).find('partyShort').text();
         		partyShortArr=partyShort.split(';');
         		for (var p=0;p<partyArr.length;p++){
         			sym.getSymbol("partyBtnMc").$('btnTxt'+p).html(partyArr[p]);
         		}
            },complete: function(){
           	 getSum();
            }
         }); // END XML
         //LIVE GRAPH
         function getSum(){
         $.ajax({ type: "GET", 
         				url: dataURL,
                     data: "gn=32860&q=sum&yr=2015",
                     contentType: "text/plain", dataType: "jsonp", jsonp: "callback",
                     async: true,
                     crossDomain: true,
                     success: function (data) {         
         			var voteCount = data;
         			sym.$("graph").empty();
         			getDate;
         			var totalVote=[];var colors=[];var parties=[];var partyName;
         			if(status==0){
         				colors=['con','lab','lib','dup','snp','sf','pc','sdlp','ukip','grn','other'];
         				for (var p=0;p<partyArr.length;p++){
         							var color=colors[p].toUpperCase();
         							var index=(partyShortArr.indexOf(color)>=0)?partyShortArr.indexOf(color):10;
         							parties[p]=partyArr[index];
         					}
         				totalVote=[302,256,56,8,6,5,3,3,2,1,8];//outgoing
         			}else{
         				if(voteCount){
         					for (var i = 0; i < voteCount.length; i++) {
         						colors[i]=(voteCount[i].name=="libdem")?"lib":voteCount[i].name;
         						totalVote[i]=voteCount[i].total;
         						var index=(partyShortArr.indexOf(colors[i].toUpperCase())>=0)?partyShortArr.indexOf(colors[i].toUpperCase()):11;
         						parties[i]=partyArr[index];
         					}
         				}
         			}
         			var highest=Math.max.apply(null,totalVote);
         			var cumulative=0;
         			for(var i=0;i<totalVote.length;i++) { cumulative += parseInt(totalVote[i]); }
         			if (status>=2&&cumulative==650){//finished
         				status=3;
         				sym.$("voteCounter").fadeOut(0);
         				sym.$("leaderpic").fadeIn(0);
         				sym.$("graph").fadeIn(0);
         				sym.$("partyBtnMc").fadeOut(0);
         				sym.$('text1').html(txt[4]);
         			}else if(status==2){
         				sym.$("voteCounter").fadeIn(0);
         				sym.$("leaderpic").fadeOut(0);
         				sym.$("graph").fadeIn(0);
         				sym.$("partyBtnMc").fadeOut(0);
         				sym.$('text1').html(txt[3]);
         			}else if(status==1){
         				sym.$("voteCounter").fadeIn(0);
         				sym.$("leaderpic").fadeOut(0);
         				sym.$("graph").fadeOut(0);
         				sym.$("partyBtnMc").fadeIn(0);
         				sym.$('text1').html(txt[2]);
         				cumulative=0;
         			}else if (status==0){//pre-election
         				sym.$("voteCounter").fadeOut(0);
         				sym.$("leaderpic").fadeIn(0);
         				sym.$("graph").fadeIn(0);
         				sym.$("partyBtnMc").fadeOut(0);
         				sym.$('text1').html(txt[1]);
         			} 
         			//Angle per vote:
         			var voteAngle = 360*cumulative/650;
         			sym.getSymbol("voteCounter").$("voteTxt").html(txt[5]+" <b>"+cumulative+"</b>");
         			if (cumulative/650<0.5){
         				sym.getSymbol("voteCounter").$("laps1").animate({rotate:voteAngle},{
         				step: function(now,fx) {
         					$(this).css('-webkit-transform','rotate('+now+'deg)');
         					$(this).css('-moz-transform','rotate('+now+'deg)'); 
         					$(this).css('-ms-transform','rotate('+now+'deg)'); 
         					$(this).css('-op-transform','rotate('+now+'deg)'); 
         					$(this).css('transform','rotate('+now+'deg)');
         				},duration:'fast'},'linear');
         			}else if (cumulative/650>=0.5){
         				sym.getSymbol("voteCounter").$("laps1").animate({rotate:180},{
         				step: function(now,fx) {
         					$(this).css('-webkit-transform','rotate(180deg)');
         					$(this).css('-moz-transform','rotate(180deg)'); 
         					$(this).css('-moz-transform','rotate(180deg)'); 
         					$(this).css('-ms-transform','rotate(180deg)');
         					$(this).css('-op-transform','rotate(180deg)');
         					$(this).css('transform','rotate(180deg)');
         				},duration:'fast'},'linear');
         				sym.getSymbol("voteCounter").$("laps2").show();
         				sym.getSymbol("voteCounter").$("laps2").animate({rotate:voteAngle},{
         				step: function(now,fx) {
         					$(this).css('-webkit-transform','rotate('+now+'deg)');
         					$(this).css('-moz-transform','rotate('+now+'deg)'); 
         					$(this).css('-ms-transform','rotate('+now+'deg)'); 
         					$(this).css('-op-transform','rotate('+now+'deg)'); 
         					$(this).css('transform','rotate('+now+'deg)');
         				},duration:'fast'},'linear');
         			}
         			sym.getSymbol('styleHead').$('headlinetxt').html(headlines[status]);
         			var max=(Math.max.apply(null,totalVote)<326)?325:Math.ceil(Math.max.apply(null,totalVote)/50)*50;
         			var maxWidth = sym.$("graph").width()-48;//width-numberwidth-marginright
         			var majority=41+Math.round(326*maxWidth/max);//numberwidth+326 votes
         			var barHeight=(totalVote.length>=11)?Math.round(sym.$("graph").height()/totalVote.length):30;//height=340
         			var graph="<div class='vr'></div><div id='voteTable'>";
         			for (var v=0;v<totalVote.length;v++){
         				if(totalVote[v]==highest){
         				var leader=(status==3)?colors[v]:colors[v]+"bw";
         				}
         				sym.$("leaderpic").attr('src','leaders/'+leader+'.png');
         				var votes=(totalVote[v]==highest)?"<b>"+totalVote[v]+"</b>":totalVote[v];
         				graph+="<div class='col' id='party"+v+"'>";
         				graph+="<div class='number' id='num"+v+"'>"+votes+"</div>";
         				if(v<2&&totalVote[v]>100){
         					graph+="<div class='bar "+colors[v]+"' id='count"+v+"'><div class='nm' style='color:rgb(255,255,255);font-weight:700' id='name"+v+"'>"+parties[v]+"</div></div>";
         				}else{
         					graph+="<div class='bar "+colors[v]+"' id='count"+v+"'></div><div class='nm' style='display:table-cell' id='name"+v+"'>"+parties[v]+"</div>";
         				}
         				graph+="</div>";
         			}
         			graph+="</div>";
         			sym.$("graph").append(graph);
         			$("#voteTable").css({'font-family':'pragmatica-web,sans-serif','height':'100%','margin':'4px 3px'});
         			$(".col").css({'text-align':'center','height':(barHeight)+'px'});
         			$(".bar").css({'display':'table-cell','box-shadow':'2px 2px 3px rgba(150,150,150,0.65)','margin':'2px 2px 2px 0px'});
         			$(".number").css({'display':'table-cell','font-size':'17px','font-weight':700,'width':'38px','text-align':'right','padding-right':'3px','color':'rgb(150,150,150)'});
         			$(".nm").css({'font-size':'14px','height':'15px','text-align':'left','padding-left':'5px'});
         			$(".lab").css({'background-color':'#FF3049'});$(".con").css({'background-color':'#0077C0'});$(".lib").css({'background-color':'#FFD520'});
         			$(".snp").css({'background-color':'#FF903D'});$(".pc").css({'background-color':'#A92958'});$(".grn").css({'background-color':'#009700'});
         			$(".ukip").css({'background-color':'#90278F'});$(".uup").css({'background-color':'#5AC5C3'});$(".dup").css({'background-color':'#7E9DD2'});
         			$(".sdlp").css({'background-color':'#F37574'});$(".sf").css({'background-color':'#89C53F'});$(".other").css({'background-color':'#CCCCFF'});
         			$(".vr").css({'height':'100%','width':'1px','position':'absolute','margin-left':majority+'px','border-left':'1px dotted rgba(218,57,57,0.3)'});
         			for (var v=0;v<totalVote.length;v++){
         				$('#count'+v).css({'width':Math.max(Math.ceil(totalVote[v]*maxWidth/max),3)});
         			}
         		}
         	});
         	setTimeout(function(){getSum()}, 60000);
         }	
         function scaleWidth(){
         	var mainWidth=$(window).width();
         	if(mainWidth<480){
         		var fontScale=Math.round(mainWidth*24/480);
         		sym.getSymbol('styleHead').$('headlinetxt').css({'font-size':fontScale+'px'});
         	}
         }
         scaleWidth();
         $(window).on("resize",scaleWidth);

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'StyleHead'
   (function(symbolName) {   
   
   })("StyleHead");
   //Edge symbol end:'StyleHead'

   //=========================================================
   
   //Edge symbol: 'partyBtnMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         sym.$("partylines0").css({'border-top':'dotted 2px rgb(150,150,150)'});

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 650, function(sym, e) {
         sym.$("partylines0").css({'border-bottom':'dotted 2px rgb(150,150,150)'});

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 750, function(sym, e) {
         sym.$("partylines1").css({'border-top':'dotted 2px rgb(150,150,150)'});

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 850, function(sym, e) {
         sym.$("partylines1").css({'border-bottom':'dotted 2px rgb(150,150,150)'});

      });
      //Edge binding end

   })("partyBtnMc");
   //Edge symbol end:'partyBtnMc'

   //=========================================================
   
   //Edge symbol: 'StyleBase'
   (function(symbolName) {   
   
   })("StyleBase");
   //Edge symbol end:'StyleBase'

   //=========================================================
   
   //Edge symbol: 'lapCounter'
   (function(symbolName) {   
   
   })("lapCounter");
   //Edge symbol end:'lapCounter'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32877");