/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var stand;
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         	var txt=[];
         	txt[0] = sym.getSymbol("mapTxtMc").$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.getSymbol("mapTxtMc").$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.getSymbol("mapTxtMc").$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.getSymbol("mapTxtMc").$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("tableMc").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.$("txt5").css({"pointer-events":"none"});
         	
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32872.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("styleHead").$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         		var htmlOutput = '';
         	 	htmlOutput += '<table width="100%" border="0" cellpadding="9" cellspacing="0">';
         		var riderNumber;
         	
         		$(xml).find('table').find('number').each(function() {
         			riderNumber = $(this).find("date").text();
         			var riderData = riderTable(riderNumber);
         			htmlOutput = htmlOutput + riderData;
         		});
         	
         		htmlOutput += '</table>';
         		sym.getSymbol("tableMc").$("table").append(htmlOutput);
         		sym.getSymbol("tableMc").$("table tr:odd").css({"text-align":"left", "background-color":"#ACD2EF","color":"#000000", "font":"13px pragmatica-web, sans-serif", "line-height":"15px"});
         		sym.getSymbol("tableMc").$("table tr:even").css({"text-align":"left", "background-color":"#C6DEF3","color":"#000000", "font":"13px pragmatica-web, sans-serif", "line-height":"15px"});
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<5; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         			sym.getSymbol("tableMc").$("table").css({'overflow-x':'hidden'});
         			sym.getSymbol("tableMc").$("table").css({'overflow-y':'scroll'});
         		}
         	}); // END XML
         	
         function riderTable(riderNumber){ 
         	output = '';
         	output += '<tr>';
         	output += '<td style="width:100%">'+ riderNumber +'</td>';
         	output += '</tr>';
         	return output;
         	}
         
         
         
         
         
         
         
         
         
         

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'tableMc'
   (function(symbolName) {   
   
   })("tableMc");
   //Edge symbol end:'tableMc'

   //=========================================================
   
   //Edge symbol: 'mapTxtMc'
   (function(symbolName) {   
   
   })("mapTxtMc");
   //Edge symbol end:'mapTxtMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32872");