/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var clicked = 0;
         	var clickedAux = 0;
         	var clickedDot = 0;
         	var btnNo = 0;
         	var navMove = 0;
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var stand;
         	var standtxt = sym.$("standTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	var winner;
         	var winnertxt = sym.getSymbol("winnersMc").$("winner").css("pointer-events","none");
         	var course;
         	var coursetxt = sym.getSymbol("winnersMc").$("course0").css("pointer-events","none");
         	
         	var datestring;
         	
         	for (var a=0; a<18; a++){
         	sym.getSymbol("roundBtnsMc").getSymbol("roundBtn"+a).$("txt").html(a+1);
         	sym.getSymbol("roundBtnsMc").getSymbol("roundBtn"+a).$("txt").css({"pointer-events":"none"});
         	sym.getSymbol("holesMc").getSymbol("allHolesMc").$("hole"+a).animate ({left:200*a});
         }
         
         // MENU TEXT START
         	var menuTxt=[];
         	menuTxt[0] = sym.getSymbol("menuBtnsMc").$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[1] = sym.$("menuTxt").css({"pointer-events":"none"});
         	menuTxt[2] = sym.$("menuTxt").css({"pointer-events":"none"});
         	var menuArr=[];
         
         	for (var b=0;b<3; b++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+b).$("menuIcon").attr("src", "images/menuIcon" + b + ".png");
         	} // MENU TEXT END
         
         	var outBtn  = {"background-color":"black"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         
         	var txt=[];
         	txt[0] = sym.$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.getSymbol("cardMc").$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("cardMc").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("cardMc").$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.getSymbol("cardMc").$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.getSymbol("cardMc").$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.getSymbol("cardMc").$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.getSymbol("cardMc").$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.getSymbol("cardMc").$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.getSymbol("cardMc").$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.getSymbol("cardMc").$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.getSymbol("cardMc").$("txt13").css({"pointer-events":"none"});
         	txt[14] = sym.getSymbol("cardMc").$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.getSymbol("winnersMc").$("txt15").css({"pointer-events":"none", "font-size":"18px"});
         	txt[16] = sym.getSymbol("winnersMc").$("txt16").css({"pointer-events":"none"});
         	txt[17] = sym.getSymbol("winnersMc").$("txt17").css({"pointer-events":"none"});
         	txt[18] = sym.getSymbol("winnersMc").$("txt18").css({"pointer-events":"none"});
         	txt[19] = sym.getSymbol("holesMc").$("txt19").css({"pointer-events":"none"});
         	txt[20] = sym.getSymbol("holesMc").$("txt20").css({"pointer-events":"none"});
         	txt[21] = sym.$("txt21").css({"pointer-events":"none"});
         	txt[22] = sym.$("txt22").css({"pointer-events":"none"});
         	txt[23] = sym.$("txt23").css({"pointer-events":"none"});
         	txt[24] = sym.$("txt24").css({"pointer-events":"none"});
         	txt[25] = sym.$("txt25").css({"pointer-events":"none"});
         	txt[26] = sym.$("txt26").css({"pointer-events":"none"});
         	txt[27] = sym.$("txt27").css({"pointer-events":"none"});
         	txt[28] = sym.$("txt28").css({"pointer-events":"none"});
         	txt[29] = sym.$("txt29").css({"pointer-events":"none"});
         	txt[30] = sym.$("txt30").css({"pointer-events":"none"});
         	txt[31] = sym.$("txt31").css({"pointer-events":"none"});
         	txt[32] = sym.$("txt32").css({"pointer-events":"none"});
         	txt[33] = sym.$("txt33").css({"pointer-events":"none"});
         	txt[34] = sym.$("txt34").css({"pointer-events":"none"});
         	txt[35] = sym.$("txt35").css({"pointer-events":"none"});
         	txt[36] = sym.$("txt36").css({"pointer-events":"none"});
         	txt[37] = sym.$("txt37").css({"pointer-events":"none"});
         
         	var txtArr=[];
         	var parstring;
         	var yardsstring;
         
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32853.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			stanSize = $(xml).find('stanSize').text();
         			sym.$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         
         			// MENU TEXT START
         			for (var i=0; i<3; i++){
         				menuArr[i]=$(xml).find('menuTxt'+i).text();
         				menuTxt[i].html(menuArr[i]);
         			} // MENU TEXT END
         
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<38; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         
                  stringPar = $(xml).find('txt4').text(); // Stage date for stage btn info
                  parstring=stringPar.split("<br>");
                  stringYards = $(xml).find('txt5').text(); // Stage date for stage btn info
                  yardsstring=stringYards.split("<br>");
                  for (var h=0; h<18; h++){
         				sym.getSymbol("cardMc").getSymbol("btn"+h).$("txt01").html(h+1).css({"pointer-events":"none"});
         				sym.getSymbol("cardMc").getSymbol("btn"+h).$("txt02").append(parstring[h]).css({"pointer-events":"none"});
         				sym.getSymbol("cardMc").getSymbol("btn"+h).$("txt03").append(yardsstring[h]).css({"pointer-events":"none"});
         			}
         
         			sym.getSymbol("winnersMc").$("txt15").css({"pointer-events":"none", "font-size":"18px"});
         			sym.getSymbol("holesMc").$("txt19").css({"pointer-events":"none", "font-size":"16px"});
         			sym.getSymbol("holesMc").$("txt19").empty();
         			sym.getSymbol("holesMc").$("txt19").append(txtArr[7] + " " + parstring[clickedAux] + "<br>" + txtArr[8] + " " + yardsstring[clickedAux]);
         
         		}
         	}); // END XML
         
         // MENU BUTTONS --------------------------------------------	
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<3; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(outBtn);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         	}
         }
         //resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[menuNo]);
         		if (menuNo == 1){
         			sym.$("holesMc").stop().delay(0).animate ({left:400}, 500, 'easeOutCubic');
         			sym.$("winnersMc").stop().delay(0).animate ({left:850}, 700, 'easeOutCubic');
         		}
         		if (menuNo == 0){
         			sym.$("holesMc").stop().delay(0).animate ({left:600}, 500, 'easeOutCubic');
         			sym.$("winnersMc").stop().delay(0).animate ({left:850}, 700, 'easeOutCubic');
         		}
         		if (menuNo == 2){
         			sym.$("winnersMc").stop().delay(0).animate ({left:0}, 700, 'easeOutCubic');
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OVER
         var menuBtnOver = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[menuNo]);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OUT
         var menuBtnOut = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").$("menuTxt").empty();
         		sym.getSymbol("menuBtnsMc").$("menuTxt").append(menuArr[clicked]);
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(outBtn);
         		if (clicked == menuNo){
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on(clickEventType,menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseover',menuBtnOver(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseout',menuBtnOut(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(overBtn);
         
         
         
         // AUX BUTTONS --------------------------------------------	
         auxArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<18; a++){
         	auxArray.push(a);
         }
         
         function resetAux(){
         	for (var a=0; a<auxArray.length; a++){
         		sym.getSymbol("cardMc").getSymbol("btn" + a).$("btnBg").fadeOut(0);
         		sym.getSymbol("cardMc").getSymbol("btn" + a).$("txt01").css({"color":"black", "font-weight":"normal"});
         		sym.getSymbol("cardMc").getSymbol("btn" + a).$("txt02").css({"color":"black", "font-weight":"normal"});
         		sym.getSymbol("cardMc").getSymbol("btn" + a).$("txt03").css({"color":"black", "font-weight":"normal"});
         	}
         }
         resetAux();
         
         // AUX CLICK
         var auxBtnClick = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		clickedAux = auxNo;
         		navClick();
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // AUX OVER
         var auxBtnOver = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("btnBg").fadeIn(0);
         		sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("txt01").css({"color":"white", "font-weight":"bold"});
         		sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("txt02").css({"color":"white", "font-weight":"bold"});
         		sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("txt03").css({"color":"white", "font-weight":"bold"});
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // AUX OUT
         var auxBtnOut = function(auxNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("btnBg").fadeOut(0);
         		sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("txt01").css({"color":"black", "font-weight":"normal"});
         		sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("txt02").css({"color":"black", "font-weight":"normal"});
         		sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("txt03").css({"color":"black", "font-weight":"normal"});
         		if (clickedAux == auxNo){
         			sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("btnBg").fadeIn(0);
         			sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("txt01").css({"color":"white", "font-weight":"bold"});
         			sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("txt02").css({"color":"white", "font-weight":"bold"});
         			sym.getSymbol("cardMc").getSymbol("btn" + auxNo).$("txt03").css({"color":"white", "font-weight":"bold"});
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<auxArray.length;b++){
         	sym.getSymbol("cardMc").$("btn"+b).on(clickEventType,auxBtnClick(b));
         	sym.getSymbol("cardMc").$("btn"+b).on('mouseover',auxBtnOver(b));
         	sym.getSymbol("cardMc").$("btn"+b).on('mouseout',auxBtnOut(b));
         	sym.getSymbol("cardMc").$("btn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("cardMc").getSymbol("btn0").$("btnBg").fadeIn(0);
         sym.getSymbol("cardMc").getSymbol("btn0").$("txt01").css({"color":"white", "font-weight":"bold"});
         sym.getSymbol("cardMc").getSymbol("btn0").$("txt02").css({"color":"white", "font-weight":"bold"});
         sym.getSymbol("cardMc").getSymbol("btn0").$("txt03").css({"color":"white", "font-weight":"bold"});
         
         sym.$("navBtnBack").fadeOut(0);
         sym.getSymbol("navBtnNext").$("bg").css({"background-color":"#da0000"});
         
         // NAV CLICK FUNCTION
         function navClick(){
         	sym.getSymbol("holesMc").$("allHolesMc").stop().animate ({left:-200*clickedAux}, 500, 'easeOutCubic');
         	sym.getSymbol("holesMc").$("holeNo").html(clickedAux + 1);
         	sym.getSymbol("holesMc").$("txt19").empty();
         	sym.getSymbol("holesMc").$("txt19").append(txtArr[7] + " " + parstring[clickedAux] + "<br>" + txtArr[8] + " " + yardsstring[clickedAux]);
         	sym.getSymbol("holesMc").$("txt20").empty();
         	sym.getSymbol("holesMc").$("txt20").append(txtArr[clickedAux+20]);
         
         	if (clickedAux <=0 ){
         		sym.$("navBtnBack").fadeOut(0);
         	}else{
         		sym.$("navBtnBack").fadeIn(0);
         	}
         	if (clickedAux >= 17){
         		sym.$("navBtnNext").fadeOut(0);
         	}else{
         		sym.$("navBtnNext").fadeIn(0);
         	}
         	resetAux();
         	resetDot();
         	sym.getSymbol("cardMc").getSymbol("btn" + clickedAux).$("btnBg").fadeIn(0);
         	sym.getSymbol("roundBtnsMc").getSymbol("roundBtn" + clickedAux).$("btnBg").css({"background-color":"#da0000"});
         	sym.getSymbol("roundBtnsMc").getSymbol("roundBtn" + clickedAux).$("txt").css({"color":"white"});
         	sym.getSymbol("cardMc").getSymbol("btn"+clickedAux).$("txt01").css({"color":"white", "font-weight":"bold"});
         	sym.getSymbol("cardMc").getSymbol("btn"+clickedAux).$("txt02").css({"color":"white", "font-weight":"bold"});
         	sym.getSymbol("cardMc").getSymbol("btn"+clickedAux).$("txt03").css({"color":"white", "font-weight":"bold"});
         }
         
         // NAVIGATION BUTTONS
         sym.$("navBtnNext").on(clickEventType, function(e){
         	clickedAux++;
         	navClick();
         	e.stopPropagation(); e.preventDefault();
         	});
         sym.$("navBtnNext").mouseover(function(){
         	sym.getSymbol("navBtnNext").$("bg").css({"background-color":"black"});
         	});
         sym.$("navBtnNext").mouseout(function(){
         	sym.getSymbol("navBtnNext").$("bg").css({"background-color":"#da0000"});
         	});
         sym.$("navBtnBack").on(clickEventType, function(e){
         	clickedAux--;
         	navClick();
         	e.stopPropagation(); e.preventDefault();
         	});
         sym.$("navBtnBack").mouseover(function(){
         	sym.getSymbol("navBtnBack").$("bg").css({"background-color":"black"});
         	});
         sym.$("navBtnBack").mouseout(function(){
         	sym.getSymbol("navBtnBack").$("bg").css({"background-color":"#da0000"});
         	});
         
         
         // DOT BUTTONS --------------------------------------------	
         dotArray = [];//the array that will hold references to the buttons.
         
         for (var a=0; a<18; a++){
         	dotArray.push(a);
         }
         
         function resetDot(){
         	for (var a=0; a<dotArray.length; a++){
         		sym.getSymbol("roundBtnsMc").getSymbol("roundBtn" + a).$("btnBg").css({"background-color":"white"});
         		sym.getSymbol("roundBtnsMc").getSymbol("roundBtn" + a).$("txt").css({"color":"black"});
         	}
         }
         resetDot();
         
         // DOT CLICK
         var dotBtnClick = function(dotNo){ //to handle lexical scope
         	return function (e) {
         		clickedAux = dotNo;
         		clickedDot = clickedAux;
         		navClick();
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // DOT OVER
         var dotBtnOver = function(dotNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("roundBtnsMc").getSymbol("roundBtn" + dotNo).$("btnBg").css({"background-color":"#da0000"});
         		sym.getSymbol("roundBtnsMc").getSymbol("roundBtn" + dotNo).$("txt").css({"color":"white"});
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // DOT OUT
         var dotBtnOut = function(dotNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("roundBtnsMc").getSymbol("roundBtn" + dotNo).$("btnBg").css({"background-color":"white"});
         		sym.getSymbol("roundBtnsMc").getSymbol("roundBtn" + dotNo).$("txt").css({"color":"black"});
         		if (clickedDot == dotNo){
         			sym.getSymbol("roundBtnsMc").getSymbol("roundBtn" + dotNo).$("btnBg").css({"background-color":"#da0000"});
         			sym.getSymbol("roundBtnsMc").getSymbol("roundBtn" + dotNo).$("txt").css({"color":"white"});
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<dotArray.length;b++){
         	sym.getSymbol("roundBtnsMc").$("roundBtn"+b).on(clickEventType,dotBtnClick(b));
         	sym.getSymbol("roundBtnsMc").$("roundBtn"+b).on('mouseover',dotBtnOver(b));
         	sym.getSymbol("roundBtnsMc").$("roundBtn"+b).on('mouseout',dotBtnOut(b));
         	sym.getSymbol("roundBtnsMc").$("roundBtn"+b).css({'cursor':'pointer'});
         }
         sym.getSymbol("roundBtnsMc").getSymbol("roundBtn0").$("btnBg").css({"background-color":"#da0000"});
         sym.getSymbol("roundBtnsMc").getSymbol("roundBtn0").$("txt").css({"color":"white"});
         
         
         // WINNERS BUTTONS --------------------------------------------	
         sym.getSymbol("winnersMc").getSymbol("winnersBtn8").$("btnOut").css({"background-color":"#7c9359"});
         sym.getSymbol("winnersMc").getSymbol("winnersBtn7").$("btnOut").css({"background-color":"#7c9359"});
         sym.getSymbol("winnersMc").getSymbol("winnersBtn4").$("btnOut").css({"background-color":"#7c9359"});
         sym.getSymbol("winnersMc").getSymbol("winnersBtn3").$("btnOut").css({"background-color":"#7c9359"});
         sym.getSymbol("winnersMc").getSymbol("winnersBtn0").$("btnOut").css({"background-color":"#7c9359"});
         
         	// ADD NUMBERS
         	for (var b=0; b<10; b++){
         		sym.getSymbol("winnersMc").getSymbol("winnersBtn"+b).$("txt").html(b+2005)
         	}
                  winnersBtnArray = []; //the array that will hold references to the buttons.
         
                  for (var w = 0; w < 10; w++){
                  	 var winnersBtnSymbols = sym.getSymbol("winnersMc").getSymbol("winnersBtn" +w); // Create an instance element of a symbol as a child of the given parent element
                  	 winnersBtnSymbols.setVariable("winnersBtnId", w); //set the value of a Symbol variable
                  	 winnersBtnArray.push(winnersBtnSymbols); //push it into the array
                  }
         
                  $.each(winnersBtnArray, function( count, winnersBtnInTheArray ){ //a 'for each' loop through the newly populated array
                  	 var winnersBtnItem = $(winnersBtnInTheArray); //create jQuery reference to the item
                  	 var winnersBtnElement = winnersBtnInTheArray.getSymbolElement(); //create a jQuery reference to the DIV element inside the symbol
                  	 winnersBtnElement.bind ("click touchstart", {winnersBtnId:count}, winnersBtnClick);
                  	 winnersBtnElement.bind ("mouseover", {winnersBtnId:count}, winnersBtnShow);
                  	 winnersBtnElement.bind ("mouseout", {winnersBtnId:count}, winnersBtnHide);
                  	})
         
         	function resetwinnersBtn(){
         		for (var k=0; k<winnersBtnArray.length; k++){
               	winnersBtnArray[k].$("btnClick").fadeOut(0);
         			winnersBtnArray[k].$("btnOver").fadeOut(0);
         		}
         	}
         	resetwinnersBtn();
         
         function winnersBtnClick (e){
         	sym.getSymbol("winnersMc").$("table").empty()
         		resetwinnersBtn(); //set them all back to normal state
         		var winnersBtn_id = (e.data.winnersBtnId); //get the id of the clicked item
         		sym.getSymbol("winnersMc").getSymbol("winnersBtn" + winnersBtn_id).$("btnClick").fadeIn(0);
         		sym.getSymbol("winnersMc").$("winPic").attr("src", "images/w" + (winnersBtn_id + 2005) + ".jpg");
         		getYear(2005 + winnersBtn_id);
         		//Removed all the ajax and buildtable functions
         }
         function winnersBtnShow (e){
               var winnersBtn_id = (e.data.winnersBtnId); //get the id of the over button
         		sym.getSymbol("winnersMc").getSymbol("winnersBtn" + winnersBtn_id).$("btnOver").fadeIn(0);
         }
         function winnersBtnHide (e){
               var winnersBtn_id = (e.data.winnersBtnId); //get the id of the out button
         		sym.getSymbol("winnersMc").getSymbol("winnersBtn" + winnersBtn_id).$("btnOver").fadeOut(0);
         }
         
         sym.getSymbol("winnersMc").getSymbol("winnersBtn9").$("btnClick").fadeIn(0);
         
         function getYear(year){
         		$.ajax({	
         		type: "GET",
         		url: year + "_results.xml",
         		dataType: "xml",
         		success: function(xml) {
         		winner = $(xml).find('winner').text();
         		winnertxt.html(winner);
         		course = $(xml).find('course').text();
         		coursetxt.html(course);
         
         		// Build an HTML string
         		var htmlOutput = '';
         	 	htmlOutput += '<table width="100%" border="0" cellpadding="3" cellspacing="0">';
         		var playerName;
         		var playerScore;
         		var playerPrize;
         		// Run the function for each student tag in the XML file
         		$('Ranked',xml).each(function(i) {
         			playerName = $(this).find("person").text();
         			playerScore = $(this).find("score").text();
         			playerPrize = $(this).find("prize").text();
         			// Build row HTML data and store in string
         			var playerdata = winnersTable(playerName,playerScore,playerPrize);
         			htmlOutput = htmlOutput + playerdata;
         		});
         		htmlOutput += '</table>';
         		sym.getSymbol("winnersMc").$("table").append(htmlOutput);
         		sym.getSymbol("winnersMc").$("table tr:odd").css({"text-align":"left", "background-color":"#f0f6ec","color":"#000000", "font":"13px Pragmatica-web, sans-serif"});
         		sym.getSymbol("winnersMc").$("table tr:even").css({"text-align":"left", "background-color":"#dde9d5","color":"#000000", "font":"13px Pragmatica-web, sans-serif"});
         		sym.getSymbol("winnersMc").$("table tr:first-child").css({"text-align":"left", "font-weight":"bold", "background-color":"#e60000","color":"#ffffff", "font":"13px, Pragmatica-web, sans-serif"});
         	}
         });
         
          function winnersTable(playerName,playerScore,playerPrize){
         	// Build HTML string and return
         	output = '';
         	output += '<tr>';
         	output += '<td style="width:40%;font-weight: bold;">'+ playerName +'</td>';
         	output += '<td style="width:40%;">'+ playerScore +'</td>';
         	output += '<td style="width:20%;font-weight: bold;">'+ playerPrize +'</td>';
         	output += '</tr>';
         	return output;
         	}
         }
         getYear(2014);
         
         var colourArray = ["66","100","167","335","352","402","503","519","553","570","653"];
         sym.getSymbol("timeMc").$("pointTime").stop().animate ({left:(slideArray[time])}, 600, 'easeOutCubic');
         
         

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'toggleBtn'
   (function(symbolName) {   
   
   })("toggleBtn");
   //Edge symbol end:'toggleBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtn_1'
   (function(symbolName) {   
   
   })("auxBtn");
   //Edge symbol end:'auxBtn'

   //=========================================================
   
   //Edge symbol: 'auxBtnsMc'
   (function(symbolName) {   
   
   })("auxBtnsMc");
   //Edge symbol end:'auxBtnsMc'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'cardMc'
   (function(symbolName) {   
   
   })("cardMc");
   //Edge symbol end:'cardMc'

   //=========================================================
   
   //Edge symbol: 'btnDark'
   (function(symbolName) {   
   
   })("cardBtn");
   //Edge symbol end:'cardBtn'

   //=========================================================
   
   //Edge symbol: 'menuBtn_1'
   (function(symbolName) {   
   
      })("navBtn");
   //Edge symbol end:'navBtn'

   //=========================================================
   
   //Edge symbol: 'roundBtn'
   (function(symbolName) {   
   
   })("roundBtn");
   //Edge symbol end:'roundBtn'

   //=========================================================
   
   //Edge symbol: 'roundBtnsMc'
   (function(symbolName) {   
   
   })("roundBtnsMc");
   //Edge symbol end:'roundBtnsMc'

   //=========================================================
   
   //Edge symbol: 'winnersMc'
   (function(symbolName) {   
   
   })("winnersMc");
   //Edge symbol end:'winnersMc'

   //=========================================================
   
   //Edge symbol: 'winnersBtn'
   (function(symbolName) {   
   
   })("winnersBtn");
   //Edge symbol end:'winnersBtn'

   //=========================================================
   
   //Edge symbol: 'allHolesMc'
   (function(symbolName) {   
   
   })("allHolesMc");
   //Edge symbol end:'allHolesMc'

   //=========================================================
   
   //Edge symbol: 'holesMc'
   (function(symbolName) {   
   
   })("holesMc");
   //Edge symbol end:'holesMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32853");