/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var clicked = 0;
         	var btnNo = 0;
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var stand;
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         	var txtBox = {"border-width":"1px", "border-color":"white","border-style":"solid", "border-radius":"5px", "color":"rgba(255,255,255,1)",
         	"background-color":"rgba(0,0,0,1)", "height":"auto","width":"auto", "padding":"3px"};
         	
         	
         	var outBtn  = {"background-color":"rgba(255,255,255,0.2)"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         	
         	var txt=[];
         	for (var i = 0; i < 44; i++){
         	txt[i] = sym.getSymbol("txtMc").$("txt"+i).css({"pointer-events":"none"});
         	}
         	
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32844.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("styleHead").$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			for (var i=0; i<51; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         			}
         	
         			//sym.getSymbol("SYMBOL").$("txt").animate({top:yNUMBER - sym.getSymbol("SYMBOL").$("txt").height()+10}, 200);
         	
         		}
         	}); // END XML
         	
         	//var 
         	var thumb = sym.$("thumbMc").css({'cursor':'ew-resize'});
         	var rail = sym.$("railMc");
         	var box = sym.$("box");
         	var railWidth = rail.width();
         	var railX = rail.offset().left;
         	var railRightX = railX + railWidth;
         	var thumbWidth = thumb.width();
         	
         thumb.bind("touchstart touchmove", moveMe); //bind touch function to thumb
         thumb.bind("mousedown", mouseMoveMe); //bind mouse function to thumb
         
         //function to be applied just to specific elements
         function moveMe(e) {
         	e.stopPropagation(); e.preventDefault();
         	var orig = e.originalEvent;
         	var pos = 0;
         	pos = orig.touches[0].pageX-40;
         
         if(pos>=railX&&pos<=railRightX-thumbWidth){
         		$(this).css({ //change css of element clicked or explicitly name element
         		'left': pos
         		});
         		sym.getSymbol("Arrow").stop(((pos-245)*10000)/291);
         		}		
         };
         
         function mouseMoveMe(){ //handle mousedown event
         sym.getComposition().getStage().getSymbolElement().mousemove(handleMouseMove); //bind mousemove functions to stage in case cursor goes oustide the thumb
         sym.getComposition().getStage().getSymbolElement().mouseup(handleMouseUp); //bind mouseup functions to stage 
         }	
         
         function handleMouseMove(jqEvent){
         	var pos = 0;
         		pos = jqEvent.pageX-40;
         		if(pos>=railX&&pos<=railRightX-thumbWidth){
         		sym.$("thumbMc").stop().animate ({left:pos},0);
         		sym.getSymbol("Arrow").stop(((pos-245)*10125)/291);
         		}
         }
         
         function handleMouseUp(jqEvent){ // handle mouseup event
         sym.getComposition().getStage().getSymbolElement().unbind("mousemove");
         sym.getComposition().getStage().getSymbolElement().unbind("mouseup");
         }
         
         function handleTouchUp(jqEvent){ // handle touchup event
         sym.getComposition().getStage().getSymbolElement().unbind("touchmove");
         sym.getComposition().getStage().getSymbolElement().unbind("touchend");
         }
         
         //sym.$("thumbMc").delay(410).animate ({left:536}, 4600, 'linear');
         //sym.$("thumbMc").delay(820).animate ({left:536}, 9200, 'linear');
         sym.$("thumbMc").delay(125).animate ({left:536}, 10000, 'linear');

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'Arrow'
   (function(symbolName) {   
         

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var posi = sym.getPosition();
         var pertxt;
         if (posi <= 20) {
         	pertxt=0;
         }else if (posi <= 4200) {
         	pertxt=(posi/42).toFixed(0);
         }else if(posi>4200&&posi<6300){
         	pertxt=100;
         }else if (posi >= 6300) {
         	pertxt=((10125 - posi)/38.14).toFixed(0);
         }else if (posi >= 10000) {
         	pertxt=0;
         }
         sym.getComposition().getStage().$("perTxt").html(pertxt);
         
         var startHr=7;
         var mins = (posi*280/10125)+15; //280mins total, 10000ms animation
         var hrs=startHr+Math.floor(mins/60);
         var min=(mins%60<10)?"0"+Math.floor(mins%60):Math.floor(mins%60);
         sym.getComposition().getStage().$("timeTxt").html(hrs + ":" +min);

      });
      //Edge binding end

      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 5400, function(sym, e) {
         sym.getComposition().getStage().$("marker").animate({'opacity':1.0},150,function(){sym.getComposition().getStage().$("marker").animate({'opacity':0},800)});

      });
      //Edge binding end

   })("Arrow");
   //Edge symbol end:'Arrow'

   //=========================================================
   
   //Edge symbol: 'thumbMc'
   (function(symbolName) {   
   
      Symbol.bindTriggerAction(compId, symbolName, "Default Timeline", 0, function(sym, e) {
         // insert code here
      });
      //Edge binding end

   })("thumbMc");
   //Edge symbol end:'thumbMc'

   //=========================================================
   
   //Edge symbol: 'txtMc'
   (function(symbolName) {   
   
   })("txtMc");
   //Edge symbol end:'txtMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32844");