/***********************
* Adobe Edge Animate Composition Actions
*
* Edit this file with caution, being careful to preserve 
* function signatures and comments starting with 'Edge' to maintain the 
* ability to interact with these actions from within Adobe Edge Animate
*
***********************/
(function($, Edge, compId){
var Composition = Edge.Composition, Symbol = Edge.Symbol; // aliases for commonly used Edge classes

   //Edge symbol: 'stage'
   (function(symbolName) {
      
      
      Symbol.bindElementAction(compId, symbolName, "document", "compositionReady", function(sym, e) {
         	var clickEventType = ('ontouchstart' in document.documentElement ? "touchstart" : "click");
         	var clicked = 0;
         	var btnNo = 0;
         	var headline;
         	var headlinetxt = sym.getSymbol("styleHead").$("headlineTxt").css("pointer-events","none");
         	var stand;
         	var standtxt = sym.getSymbol("styleHead").$("standTxt").css("pointer-events","none");
         	var source;
         	var sourcetxt = sym.getSymbol("styleBase").$("sourceTxt").css("pointer-events","none");
         	
         	for (var b=0;b<5; b++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn"+b).$("txt").html(b+1);
         		sym.$("des"+b+"Mc").fadeOut(0);
         	} // MENU TEXT END
         	sym.$("des0Mc").fadeIn(0);
         	
         	var outBtn  = {"background-color":"black"};
         	var overBtn = {"background-color":"rgba(218,0,0,1)"};
         	
         	var txt=[];
         	txt[0] = sym.getSymbol("des0Mc").$("txt0").css({"pointer-events":"none"});
         	txt[1] = sym.getSymbol("des0Mc").$("txt1").css({"pointer-events":"none"});
         	txt[2] = sym.getSymbol("des1Mc").$("txt2").css({"pointer-events":"none"});
         	txt[3] = sym.getSymbol("des2Mc").$("txt3").css({"pointer-events":"none"});
         	txt[4] = sym.getSymbol("des3Mc").$("txt4").css({"pointer-events":"none"});
         	txt[5] = sym.getSymbol("des4Mc").$("txt5").css({"pointer-events":"none"});
         	txt[6] = sym.getSymbol("des4Mc").$("txt6").css({"pointer-events":"none"});
         	txt[7] = sym.getSymbol("mapMc").$("txt7").css({"pointer-events":"none"});
         	txt[8] = sym.getSymbol("mapMc").$("txt8").css({"pointer-events":"none"});
         	txt[9] = sym.getSymbol("mapMc").$("txt9").css({"pointer-events":"none"});
         	txt[10] = sym.getSymbol("mapMc").$("txt10").css({"pointer-events":"none"});
         	txt[11] = sym.$("txt11").css({"pointer-events":"none"});
         	txt[12] = sym.$("txt12").css({"pointer-events":"none"});
         	txt[13] = sym.$("txt13").css({"pointer-events":"none"});
         	txt[14] = sym.$("txt14").css({"pointer-events":"none"});
         	txt[15] = sym.$("txt15").css({"pointer-events":"none"});
         	
         	var txtArr=[];
         	
         	//AJAX retrieves data from xml source specified in url, maps xml variable to DOM object variable
         	$.ajax({	
         		type: "GET",
         		url: "GN32824.xml",
         		dataType: "xml",
         		success: function(xml) {
         			custonCol = $(xml).find('customColour').text();
         			sym.getSymbol("styleHead").$("headerBox").css("background-color",custonCol);
         			headline = $(xml).find('headline').text();
         			headlinetxt.html(headline);
         			headSize = $(xml).find('headSize').text();
         			sym.getSymbol("styleHead").$("headlineTxt").css("font-size",headSize);
         			stanSize = $(xml).find('stanSize').text();
         			sym.getSymbol("styleHead").$("standTxt").css("font-size",stanSize);
         			stand = $(xml).find('stand').text();
         			standtxt.html(stand);
         			source = $(xml).find('source').text();
         			sourcetxt.html(source);
         	
         			var fontSize= $(xml).find('fontSize').text();
         			for (var i=0; i<16; i++){
         				txtArr[i]=$(xml).find('txt'+i).text();
         				txt[i].html(txtArr[i]);
         				txt[i].css({'font-size':fontSize});
         			}
         		}
         	}); // END XML
         	
         // MENU BUTTONS --------------------------------------------	
         menuArray = [];//the array that will hold references to the buttons.
         
         for (var h=0; h<5; h++){
         	menuArray.push(h);
         }
         
         function resetmenu(){
         	for (var h=0; h<menuArray.length; h++){
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + h).$("bg").css(outBtn);
         		sym.$("des"+h+"Mc").fadeOut(200);
         	}
         }
         //resetmenu();
         
         // MENU CLICK
         var menuBtnClick = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		clicked = menuNo;
         		resetmenu();
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		sym.$("des"+ menuNo +"Mc").fadeIn(200);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OVER
         var menuBtnOver = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         // MENU OUT
         var menuBtnOut = function(menuNo){ //to handle lexical scope
         	return function (e) {
         		sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(outBtn);
         		if (clicked == menuNo){
         			sym.getSymbol("menuBtnsMc").getSymbol("menuBtn" + menuNo).$("bg").css(overBtn);
         		}
         		e.preventDefault(); e.stopPropagation();
         	};
         };
         for (var b=0;b<menuArray.length;b++){
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on(clickEventType,menuBtnClick(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseover',menuBtnOver(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).on('mouseout',menuBtnOut(b));
         	sym.getSymbol("menuBtnsMc").$("menuBtn"+b).css({'cursor':'pointer'});
         }
         	sym.getSymbol("menuBtnsMc").getSymbol("menuBtn0").$("bg").css(overBtn);
         

      });
      //Edge binding end

      Symbol.bindTimelineAction(compId, symbolName, "Default Timeline", "update", function(sym, e) {
         var pos = sym.getPosition();
         
         if (pos == 0) {
         	// do something
         }else{
         	// do something else
         }
         

      });
      //Edge binding end

   })("stage");
   //Edge symbol end:'stage'

   //=========================================================
   
   //Edge symbol: 'styleHead'
   (function(symbolName) {   
   
   })("styleHead");
   //Edge symbol end:'styleHead'

   //=========================================================
   
   //Edge symbol: 'styleBase'
   (function(symbolName) {   
   
   })("styleBase");
   //Edge symbol end:'styleBase'

   //=========================================================
   
   //Edge symbol: 'menuBtnsMc'
   (function(symbolName) {   
   
   })("menuBtnsMc");
   //Edge symbol end:'menuBtnsMc'

   //=========================================================
   
   //Edge symbol: 'menuBtn'
   (function(symbolName) {   
   
   })("menuBtn");
   //Edge symbol end:'menuBtn'

   //=========================================================
   
   //Edge symbol: 'Preloader'
   (function(symbolName) {   
   
   })("Preloader");
   //Edge symbol end:'Preloader'

   //=========================================================
   
   //Edge symbol: 'des0Mc'
   (function(symbolName) {   
   
   })("des0Mc");
   //Edge symbol end:'des0Mc'

   //=========================================================
   
   //Edge symbol: 'des1Mc'
   (function(symbolName) {   
   
   })("des1Mc");
   //Edge symbol end:'des1Mc'

   //=========================================================
   
   //Edge symbol: 'des2Mc'
   (function(symbolName) {   
   
   })("des2Mc");
   //Edge symbol end:'des2Mc'

   //=========================================================
   
   //Edge symbol: 'des4Mc'
   (function(symbolName) {   
   
   })("des4Mc");
   //Edge symbol end:'des4Mc'

   //=========================================================
   
   //Edge symbol: 'des5Mc'
   (function(symbolName) {   
   
   })("des5Mc");
   //Edge symbol end:'des5Mc'

   //=========================================================
   
   //Edge symbol: 'mapMc'
   (function(symbolName) {   
   
   })("mapMc");
   //Edge symbol end:'mapMc'

})(window.jQuery || AdobeEdge.$, AdobeEdge, "GraphicNews32824");